/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.css.SelectorSpecificity;
import com.gargoylesoftware.htmlunit.css.StyleElement;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedHeight;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Text;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;
import org.w3c.css.sac.Selector;

@JsxClass(isJSObject=false, value={SupportedBrowser.FF})
public class ComputedCSSStyleDeclaration
extends CSSStyleDeclaration {
    private static final String EMPTY_FINAL = new String("");
    private static final int PIXELS_PER_CHAR = 10;
    private static final Set<StyleAttributes.Definition> INHERITABLE_DEFINITIONS = EnumSet.of(StyleAttributes.Definition.AZIMUTH, new StyleAttributes.Definition[]{StyleAttributes.Definition.BORDER_COLLAPSE, StyleAttributes.Definition.BORDER_SPACING, StyleAttributes.Definition.CAPTION_SIDE, StyleAttributes.Definition.COLOR, StyleAttributes.Definition.CURSOR, StyleAttributes.Definition.DIRECTION, StyleAttributes.Definition.ELEVATION, StyleAttributes.Definition.EMPTY_CELLS, StyleAttributes.Definition.FONT_FAMILY, StyleAttributes.Definition.FONT_SIZE, StyleAttributes.Definition.FONT_STYLE, StyleAttributes.Definition.FONT_VARIANT, StyleAttributes.Definition.FONT_WEIGHT, StyleAttributes.Definition.FONT, StyleAttributes.Definition.LETTER_SPACING, StyleAttributes.Definition.LINE_HEIGHT, StyleAttributes.Definition.LIST_STYLE_IMAGE, StyleAttributes.Definition.LIST_STYLE_POSITION, StyleAttributes.Definition.LIST_STYLE_TYPE, StyleAttributes.Definition.LIST_STYLE, StyleAttributes.Definition.ORPHANS, StyleAttributes.Definition.PITCH_RANGE, StyleAttributes.Definition.PITCH, StyleAttributes.Definition.QUOTES, StyleAttributes.Definition.RICHNESS, StyleAttributes.Definition.SPEAK_HEADER, StyleAttributes.Definition.SPEAK_NUMERAL, StyleAttributes.Definition.SPEAK_PUNCTUATION, StyleAttributes.Definition.SPEAK, StyleAttributes.Definition.SPEECH_RATE, StyleAttributes.Definition.STRESS, StyleAttributes.Definition.TEXT_ALIGN, StyleAttributes.Definition.TEXT_INDENT, StyleAttributes.Definition.TEXT_TRANSFORM, StyleAttributes.Definition.VISIBILITY, StyleAttributes.Definition.VOICE_FAMILY, StyleAttributes.Definition.VOICE_FAMILY, StyleAttributes.Definition.VOLUME, StyleAttributes.Definition.WHITE_SPACE, StyleAttributes.Definition.WIDOWS, StyleAttributes.Definition.WORD_SPACING});
    private final SortedMap<String, StyleElement> localModifications_ = new TreeMap<String, StyleElement>();
    private Integer width_;
    private Integer height_;
    private Integer height2_;
    private Integer paddingHorizontal_;
    private Integer paddingVertical_;
    private Integer borderHorizontal_;
    private Integer borderVertical_;
    private Integer top_;

    public ComputedCSSStyleDeclaration() {
    }

    public ComputedCSSStyleDeclaration(CSSStyleDeclaration style) {
        super(style.getElement());
        this.getElement().setDefaults(this);
    }

    @Override
    protected void setStyleAttribute(String name, String newValue) {
    }

    public void applyStyleFromSelector(org.w3c.dom.css.CSSStyleDeclaration declaration, Selector selector) {
        BrowserVersion browserVersion = this.getBrowserVersion();
        SelectorSpecificity specificity = new SelectorSpecificity(selector);
        for (int k = 0; k < declaration.getLength(); ++k) {
            String name = declaration.item(k);
            String value = declaration.getPropertyValue(name);
            String priority = declaration.getPropertyPriority(name);
            if ("z-index".equals(name) && browserVersion.hasFeature(BrowserVersionFeatures.CSS_COMPUTED_NO_Z_INDEX)) continue;
            this.applyLocalStyleAttribute(name, value, priority, specificity);
        }
    }

    private void applyLocalStyleAttribute(String name, String newValue, String priority, SelectorSpecificity specificity) {
        StyleElement existingElement;
        if (!"important".equals(priority) && (existingElement = (StyleElement)this.localModifications_.get(name)) != null) {
            if ("important".equals(existingElement.getPriority())) {
                return;
            }
            if (specificity.compareTo(existingElement.getSpecificity()) < 0) {
                return;
            }
        }
        StyleElement element = new StyleElement(name, newValue, priority, specificity);
        this.localModifications_.put(name, element);
    }

    public void setDefaultLocalStyleAttribute(String name, String newValue) {
        StyleElement element = new StyleElement(name, newValue);
        this.localModifications_.put(name, element);
    }

    @Override
    protected StyleElement getStyleElement(String name) {
        StyleElement existent = super.getStyleElement(name);
        if (this.localModifications_ != null) {
            StyleElement localStyleMod = (StyleElement)this.localModifications_.get(name);
            if (localStyleMod == null) {
                return existent;
            }
            if (existent == null) {
                return localStyleMod;
            }
            if ("important".equals(localStyleMod.getPriority())) {
                if ("important".equals(existent.getPriority())) {
                    if (existent.getSpecificity().compareTo(localStyleMod.getSpecificity()) < 0) {
                        return localStyleMod;
                    }
                } else {
                    return localStyleMod;
                }
            }
        }
        return existent;
    }

    private String defaultIfEmpty(String str, StyleAttributes.Definition definition) {
        return this.defaultIfEmpty(str, definition, false);
    }

    private String defaultIfEmpty(String str, StyleAttributes.Definition definition, boolean isPixel) {
        if (!this.getElement().getDomNodeOrDie().isAttachedToPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_COMPUTED_NO_Z_INDEX)) {
            return EMPTY_FINAL;
        }
        if (str == null || str.isEmpty()) {
            return definition.getDefaultComputedValue(this.getBrowserVersion());
        }
        if (isPixel) {
            return this.pixelString(str);
        }
        return str;
    }

    private String defaultIfEmpty(String str, String toReturnIfEmptyOrDefault, String defaultValue) {
        if (!this.getElement().getDomNodeOrDie().isAttachedToPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_COMPUTED_NO_Z_INDEX)) {
            return EMPTY_FINAL;
        }
        if (str == null || str.isEmpty() || str.equals(defaultValue)) {
            return toReturnIfEmptyOrDefault;
        }
        return str;
    }

    @Override
    public String getAccelerator() {
        return this.defaultIfEmpty(this.getStyleAttribute(StyleAttributes.Definition.ACCELERATOR, false), StyleAttributes.Definition.ACCELERATOR);
    }

    @Override
    public String getBackgroundAttachment() {
        return this.defaultIfEmpty(super.getBackgroundAttachment(), StyleAttributes.Definition.BACKGROUND_ATTACHMENT);
    }

    @Override
    public String getBackgroundColor() {
        String value = super.getBackgroundColor();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return StyleAttributes.Definition.BACKGROUND_COLOR.getDefaultComputedValue(this.getBrowserVersion());
        }
        return ComputedCSSStyleDeclaration.toRGBColor(value);
    }

    @Override
    public String getBackgroundImage() {
        return this.defaultIfEmpty(super.getBackgroundImage(), StyleAttributes.Definition.BACKGROUND_IMAGE);
    }

    @Override
    public String getBackgroundPosition() {
        return this.defaultIfEmpty(super.getBackgroundPosition(), StyleAttributes.Definition.BACKGROUND_POSITION);
    }

    @Override
    public String getBackgroundRepeat() {
        return this.defaultIfEmpty(super.getBackgroundRepeat(), StyleAttributes.Definition.BACKGROUND_REPEAT);
    }

    @Override
    public String getBorderBottomColor() {
        return this.defaultIfEmpty(super.getBorderBottomColor(), StyleAttributes.Definition.BORDER_BOTTOM_COLOR);
    }

    @Override
    public String getBorderBottomStyle() {
        return this.defaultIfEmpty(super.getBorderBottomStyle(), StyleAttributes.Definition.BORDER_BOTTOM_STYLE);
    }

    @Override
    public String getBorderBottomWidth() {
        return this.pixelString(this.defaultIfEmpty(super.getBorderBottomWidth(), StyleAttributes.Definition.BORDER_BOTTOM_WIDTH));
    }

    @Override
    public String getBorderLeftColor() {
        return this.defaultIfEmpty(super.getBorderLeftColor(), StyleAttributes.Definition.BORDER_LEFT_COLOR);
    }

    @Override
    public String getBorderLeftStyle() {
        return this.defaultIfEmpty(super.getBorderLeftStyle(), StyleAttributes.Definition.BORDER_LEFT_STYLE);
    }

    @Override
    public String getBorderLeftWidth() {
        return this.pixelString(this.defaultIfEmpty(super.getBorderLeftWidth(), "0px", null));
    }

    @Override
    public String getBorderRightColor() {
        return this.defaultIfEmpty(super.getBorderRightColor(), "rgb(0, 0, 0)", null);
    }

    @Override
    public String getBorderRightStyle() {
        return this.defaultIfEmpty(super.getBorderRightStyle(), "none", null);
    }

    @Override
    public String getBorderRightWidth() {
        return this.pixelString(this.defaultIfEmpty(super.getBorderRightWidth(), "0px", null));
    }

    @Override
    public String getBorderTopColor() {
        return this.defaultIfEmpty(super.getBorderTopColor(), "rgb(0, 0, 0)", null);
    }

    @Override
    public String getBorderTopStyle() {
        return this.defaultIfEmpty(super.getBorderTopStyle(), "none", null);
    }

    @Override
    public String getBorderTopWidth() {
        return this.pixelString(this.defaultIfEmpty(super.getBorderTopWidth(), "0px", null));
    }

    @Override
    public String getBottom() {
        return this.defaultIfEmpty(super.getBottom(), "auto", null);
    }

    @Override
    public String getColor() {
        String value = this.defaultIfEmpty(super.getColor(), "rgb(0, 0, 0)", null);
        return ComputedCSSStyleDeclaration.toRGBColor(value);
    }

    @Override
    public String getCssFloat() {
        return this.defaultIfEmpty(super.getCssFloat(), StyleAttributes.Definition.CSS_FLOAT);
    }

    @Override
    public String getDisplay() {
        return this.getDisplay(false);
    }

    public String getDisplay(boolean ignoreBlockIfNotAttached) {
        String value;
        Element elem = this.getElement();
        DomElement domElem = elem.getDomNodeOrDie();
        boolean changeValueIfEmpty = false;
        if (!domElem.isAttachedToPage()) {
            BrowserVersion browserVersion = this.getBrowserVersion();
            if (browserVersion.hasFeature(BrowserVersionFeatures.CSS_COMPUTED_NO_Z_INDEX)) {
                return "";
            }
            if (!ignoreBlockIfNotAttached && browserVersion.hasFeature(BrowserVersionFeatures.CSS_COMPUTED_BLOCK_IF_NOT_ATTACHED)) {
                changeValueIfEmpty = true;
            }
        }
        if (StringUtils.isEmpty((CharSequence)(value = super.getStyleAttribute(StyleAttributes.Definition.DISPLAY, false)))) {
            if (domElem instanceof HtmlElement) {
                String defaultValue = ((HtmlElement)domElem).getDefaultStyleDisplay().value();
                if (changeValueIfEmpty) {
                    switch (defaultValue) {
                        case "inline": 
                        case "inline-block": 
                        case "table-caption": 
                        case "table-cell": 
                        case "table-column": 
                        case "table-column-group": 
                        case "table-footer-group": 
                        case "table-header-group": 
                        case "table-row": 
                        case "table-row-group": 
                        case "list-item": 
                        case "ruby": {
                            return "block";
                        }
                    }
                }
                return defaultValue;
            }
            return "";
        }
        return value;
    }

    @Override
    public String getFont() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_COMPUTED_NO_Z_INDEX) && this.getElement().getDomNodeOrDie().isAttachedToPage()) {
            return this.getStyleAttribute(StyleAttributes.Definition.FONT_STYLE, true) + ' ' + this.getStyleAttribute(StyleAttributes.Definition.FONT_VARIANT, true) + ' ' + this.getStyleAttribute(StyleAttributes.Definition.FONT_WEIGHT, true) + ' ' + this.getStyleAttribute(StyleAttributes.Definition.FONT_STRETCH, true) + ' ' + this.getFontSize() + ' ' + '/' + ' ' + this.getStyleAttribute(StyleAttributes.Definition.LINE_HEIGHT, true) + ' ' + this.getStyleAttribute(StyleAttributes.Definition.FONT_FAMILY, true);
        }
        return "";
    }

    @Override
    public String getFontSize() {
        String value = super.getFontSize();
        if (!value.isEmpty()) {
            value = ComputedCSSStyleDeclaration.pixelValue(value) + "px";
        }
        return value;
    }

    @Override
    public String getLineHeight() {
        return this.defaultIfEmpty(super.getLineHeight(), StyleAttributes.Definition.LINE_HEIGHT);
    }

    @Override
    public String getFontFamily() {
        return this.defaultIfEmpty(super.getFontFamily(), StyleAttributes.Definition.FONT_FAMILY);
    }

    @Override
    public String getHeight() {
        final Element elem = this.getElement();
        if (!elem.getDomNodeOrDie().isAttachedToPage()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_COMPUTED_NO_Z_INDEX)) {
                return "";
            }
            if (this.getStyleAttribute(StyleAttributes.Definition.HEIGHT, true).isEmpty()) {
                return "auto";
            }
        }
        int windowHeight = elem.getWindow().getWebWindow().getInnerHeight();
        return this.pixelString(elem, new CSSStyleDeclaration.CssValue(0, windowHeight){

            @Override
            public String get(ComputedCSSStyleDeclaration style) {
                String offsetHeight = ((HTMLElement)elem).getOffsetHeight() + "px";
                return ComputedCSSStyleDeclaration.this.defaultIfEmpty(style.getStyleAttribute(StyleAttributes.Definition.HEIGHT, true), offsetHeight, "auto");
            }
        });
    }

    @Override
    public String getLeft() {
        String superLeft = super.getLeft();
        if (!superLeft.endsWith("%")) {
            return this.defaultIfEmpty(superLeft, "auto", null);
        }
        final Element elem = this.getElement();
        return this.pixelString(elem, new CSSStyleDeclaration.CssValue(0, 0){

            @Override
            public String get(ComputedCSSStyleDeclaration style) {
                if (style.getElement() == elem) {
                    return style.getStyleAttribute(StyleAttributes.Definition.LEFT, true);
                }
                return style.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
            }
        });
    }

    @Override
    public String getLetterSpacing() {
        return this.defaultIfEmpty(super.getLetterSpacing(), "normal", null);
    }

    @Override
    public String getMargin() {
        return this.defaultIfEmpty(super.getMargin(), StyleAttributes.Definition.MARGIN, true);
    }

    @Override
    public String getMarginBottom() {
        return this.pixelString(this.defaultIfEmpty(super.getMarginBottom(), "0px", null));
    }

    @Override
    public String getMarginLeft() {
        return this.getMarginX(super.getMarginLeft(), StyleAttributes.Definition.MARGIN_LEFT);
    }

    @Override
    public String getMarginRight() {
        return this.getMarginX(super.getMarginRight(), StyleAttributes.Definition.MARGIN_RIGHT);
    }

    private String getMarginX(String superMarginX, final StyleAttributes.Definition definition) {
        if (!superMarginX.endsWith("%")) {
            return this.pixelString(this.defaultIfEmpty(superMarginX, "0px", null));
        }
        final Element elem = this.getElement();
        if (!elem.getDomNodeOrDie().isAttachedToPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_COMPUTED_NO_Z_INDEX)) {
            return "";
        }
        int windowWidth = elem.getWindow().getWebWindow().getInnerWidth();
        return this.pixelString(elem, new CSSStyleDeclaration.CssValue(0, windowWidth){

            @Override
            public String get(ComputedCSSStyleDeclaration style) {
                if (style.getElement() == elem) {
                    return style.getStyleAttribute(definition, true);
                }
                return style.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
            }
        });
    }

    @Override
    public String getMarginTop() {
        return this.pixelString(this.defaultIfEmpty(super.getMarginTop(), "0px", null));
    }

    @Override
    public String getMaxHeight() {
        return this.defaultIfEmpty(super.getMaxHeight(), "none", null);
    }

    @Override
    public String getMaxWidth() {
        return this.defaultIfEmpty(super.getMaxWidth(), "none", null);
    }

    @Override
    public String getMinHeight() {
        return this.defaultIfEmpty(super.getMinHeight(), "0px", null);
    }

    @Override
    public String getMinWidth() {
        return this.defaultIfEmpty(super.getMinWidth(), "0px", null);
    }

    @Override
    public String getOpacity() {
        return this.defaultIfEmpty(super.getOpacity(), "1", null);
    }

    @Override
    public String getOutlineWidth() {
        return this.defaultIfEmpty(super.getOutlineWidth(), "0px", null);
    }

    @Override
    public String getPadding() {
        return this.defaultIfEmpty(super.getPadding(), StyleAttributes.Definition.PADDING, true);
    }

    @Override
    public String getPaddingBottom() {
        return this.pixelString(this.defaultIfEmpty(super.getPaddingBottom(), "0px", null));
    }

    @Override
    public String getPaddingLeft() {
        return this.pixelString(this.defaultIfEmpty(super.getPaddingLeft(), "0px", null));
    }

    @Override
    public String getPaddingRight() {
        return this.pixelString(this.defaultIfEmpty(super.getPaddingRight(), "0px", null));
    }

    @Override
    public String getPaddingTop() {
        return this.pixelString(this.defaultIfEmpty(super.getPaddingTop(), "0px", null));
    }

    @Override
    public String getRight() {
        return this.defaultIfEmpty(super.getRight(), "auto", null);
    }

    @Override
    public String getTextIndent() {
        return this.defaultIfEmpty(super.getTextIndent(), "0px", null);
    }

    @Override
    public String getTop() {
        final Element elem = this.getElement();
        if (!elem.getDomNodeOrDie().isAttachedToPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_COMPUTED_NO_Z_INDEX)) {
            return "";
        }
        String superTop = super.getTop();
        if (!superTop.endsWith("%")) {
            return this.defaultIfEmpty(superTop, StyleAttributes.Definition.TOP);
        }
        return this.pixelString(elem, new CSSStyleDeclaration.CssValue(0, 0){

            @Override
            public String get(ComputedCSSStyleDeclaration style) {
                if (style.getElement() == elem) {
                    return style.getStyleAttribute(StyleAttributes.Definition.TOP, true);
                }
                return style.getStyleAttribute(StyleAttributes.Definition.HEIGHT, true);
            }
        });
    }

    @Override
    public String getVerticalAlign() {
        return this.defaultIfEmpty(super.getVerticalAlign(), "baseline", null);
    }

    @Override
    public String getWidows() {
        return this.defaultIfEmpty(super.getWidows(), StyleAttributes.Definition.WIDOWS);
    }

    @Override
    public String getOrphans() {
        return this.defaultIfEmpty(super.getOrphans(), StyleAttributes.Definition.ORPHANS);
    }

    @Override
    public String getPosition() {
        return this.defaultIfEmpty(super.getPosition(), StyleAttributes.Definition.POSITION);
    }

    @Override
    public String getWidth() {
        if ("none".equals(this.getDisplay())) {
            return "auto";
        }
        final Element elem = this.getElement();
        if (!elem.getDomNodeOrDie().isAttachedToPage()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_COMPUTED_NO_Z_INDEX)) {
                return "";
            }
            if (this.getStyleAttribute(StyleAttributes.Definition.WIDTH, true).isEmpty()) {
                return "auto";
            }
        }
        int windowWidth = elem.getWindow().getWebWindow().getInnerWidth();
        return this.pixelString(elem, new CSSStyleDeclaration.CssValue(0, windowWidth){

            @Override
            public String get(ComputedCSSStyleDeclaration style) {
                String value = style.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
                if (StringUtils.isEmpty((CharSequence)value)) {
                    String content;
                    if ("absolute".equals(ComputedCSSStyleDeclaration.this.getStyleAttribute(StyleAttributes.Definition.POSITION, true)) && null != (content = ComputedCSSStyleDeclaration.this.getDomNodeOrDie().getTextContent()) && content.length() < 13) {
                        return content.length() * 7 + "px";
                    }
                    int windowDefaultValue = this.getWindowDefaultValue();
                    if (elem instanceof HTMLBodyElement) {
                        windowDefaultValue -= 16;
                    }
                    return windowDefaultValue + "px";
                }
                if ("auto".equals(value)) {
                    int windowDefaultValue = this.getWindowDefaultValue();
                    if (elem instanceof HTMLBodyElement) {
                        windowDefaultValue -= 16;
                    }
                    return windowDefaultValue + "px";
                }
                return value;
            }
        });
    }

    public int getCalculatedWidth(boolean includeBorder, boolean includePadding) {
        if (!this.getElement().getDomNodeOrNull().isAttachedToPage()) {
            return 0;
        }
        int width = this.getCalculatedWidth();
        if (!"border-box".equals(this.getStyleAttribute(StyleAttributes.Definition.BOX_SIZING))) {
            if (includeBorder) {
                width += this.getBorderHorizontal();
            } else if (this.isScrollable(true, true) && !(this.getElement() instanceof HTMLBodyElement) && this.getElement().getDomNodeOrDie().isAttachedToPage()) {
                width -= 17;
            }
            if (includePadding) {
                width += this.getPaddingHorizontal();
            }
        }
        return width;
    }

    private int getCalculatedWidth() {
        int width;
        if (this.width_ != null) {
            return this.width_;
        }
        Element element = this.getElement();
        DomElement node = element.getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            this.width_ = 0;
            return 0;
        }
        String display = this.getDisplay();
        if ("none".equals(display)) {
            this.width_ = 0;
            return 0;
        }
        int windowWidth = element.getWindow().getWebWindow().getInnerWidth();
        String styleWidth = super.getWidth();
        DomNode parent = node.getParentNode();
        if (("inline".equals(display) || StringUtils.isEmpty((CharSequence)styleWidth)) && parent instanceof HtmlElement) {
            if (element instanceof HTMLCanvasElement) {
                return 300;
            }
            String cssFloat = this.getCssFloat();
            if ("right".equals(cssFloat) || "left".equals(cssFloat) || "absolute".equals(this.getStyleAttribute(StyleAttributes.Definition.POSITION, true))) {
                width = node.getTextContent().length() * 10;
            } else if ("block".equals(display)) {
                if (element instanceof HTMLBodyElement) {
                    width = windowWidth - 16;
                } else {
                    HTMLElement parentJS = (HTMLElement)parent.getScriptableObject();
                    width = ComputedCSSStyleDeclaration.pixelValue(parentJS, new CSSStyleDeclaration.CssValue(0, windowWidth){

                        @Override
                        public String get(ComputedCSSStyleDeclaration style) {
                            return style.getWidth();
                        }
                    }) - (this.getBorderHorizontal() + this.getPaddingHorizontal());
                }
            } else if (node instanceof HtmlSubmitInput || node instanceof HtmlResetInput || node instanceof HtmlButtonInput || node instanceof HtmlButton || node instanceof HtmlFileInput) {
                String text = node.asText();
                width = 10 + (int)((double)(text.length() * 10) * 0.9);
            } else if (node instanceof HtmlTextInput || node instanceof HtmlPasswordInput) {
                BrowserVersion browserVersion = this.getBrowserVersion();
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_CLIENTWIDTH_INPUT_TEXT_143)) {
                    return 143;
                }
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_CLIENTWIDTH_INPUT_TEXT_169)) {
                    return 169;
                }
                width = 141;
            } else {
                width = node instanceof HtmlRadioButtonInput || node instanceof HtmlCheckBoxInput ? 13 : (node instanceof HtmlTextArea ? 100 : this.getContentWidth());
            }
        } else {
            width = "auto".equals(styleWidth) ? windowWidth : ComputedCSSStyleDeclaration.pixelValue(element, new CSSStyleDeclaration.CssValue(0, windowWidth){

                @Override
                public String get(ComputedCSSStyleDeclaration style) {
                    return style.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
                }
            });
        }
        this.width_ = width;
        return width;
    }

    public int getContentWidth() {
        Page enclosedPage;
        int width = 0;
        DomNode domNode = this.getDomNodeOrDie();
        Iterable<DomNode> children = domNode.getChildren();
        if (domNode instanceof BaseFrameElement && (enclosedPage = ((BaseFrameElement)domNode).getEnclosedPage()) != null && enclosedPage.isHtmlPage()) {
            HtmlPage htmlPage = (HtmlPage)enclosedPage;
            children = htmlPage.getChildren();
        }
        for (DomNode child : children) {
            if (child.getScriptableObject() instanceof HTMLElement) {
                HTMLElement e = (HTMLElement)child.getScriptableObject();
                CSS2Properties style = e.getWindow().getComputedStyle(e, null);
                int w = style.getCalculatedWidth(true, true);
                width += w;
                continue;
            }
            if (!(child.getScriptableObject() instanceof Text)) continue;
            DomNode parent = child.getParentNode();
            if (parent instanceof HtmlElement) {
                HTMLElement e = (HTMLElement)child.getParentNode().getScriptableObject();
                CSS2Properties style = e.getWindow().getComputedStyle(e, null);
                int height = ComputedHeight.getHeight(this.getBrowserVersion(), style.getFontSize());
                width += child.getTextContent().length() * (int)((float)height / 1.8f);
                continue;
            }
            width += child.getTextContent().length() * 10;
        }
        return width;
    }

    public int getCalculatedHeight(boolean includeBorder, boolean includePadding) {
        if (!this.getElement().getDomNodeOrNull().isAttachedToPage()) {
            return 0;
        }
        int height = this.getCalculatedHeight();
        if (!"border-box".equals(this.getStyleAttribute(StyleAttributes.Definition.BOX_SIZING))) {
            if (includeBorder) {
                height += this.getBorderVertical();
            } else if (this.isScrollable(false, true) && !(this.getElement() instanceof HTMLBodyElement) && this.getElement().getDomNodeOrDie().isAttachedToPage()) {
                height -= 17;
            }
            if (includePadding) {
                height += this.getPaddingVertical();
            }
        }
        return height;
    }

    private int getCalculatedHeight() {
        if (this.height_ != null) {
            return this.height_;
        }
        int elementHeight = this.getEmptyHeight();
        if (elementHeight == 0) {
            this.height_ = elementHeight;
            return elementHeight;
        }
        int contentHeight = this.getContentHeight();
        boolean explicitHeightSpecified = !super.getHeight().isEmpty();
        int height = contentHeight > 0 && !explicitHeightSpecified ? contentHeight : elementHeight;
        this.height_ = height;
        return height;
    }

    private int getEmptyHeight() {
        int defaultHeight;
        boolean explicitHeightSpecified;
        if (this.height2_ != null) {
            return this.height2_;
        }
        DomElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            this.height2_ = 0;
            return 0;
        }
        if ("none".equals(this.getDisplay())) {
            this.height2_ = 0;
            return 0;
        }
        Element elem = this.getElement();
        int windowHeight = elem.getWindow().getWebWindow().getInnerHeight();
        if (elem instanceof HTMLBodyElement) {
            this.height2_ = windowHeight;
            return windowHeight;
        }
        boolean bl = explicitHeightSpecified = !super.getHeight().isEmpty();
        if (node instanceof HtmlDivision && node.getTextContent().trim().isEmpty()) {
            defaultHeight = 0;
        } else if (elem.getFirstChild() == null) {
            defaultHeight = node instanceof HtmlRadioButtonInput || node instanceof HtmlCheckBoxInput ? 13 : (node instanceof HtmlButton ? 20 : (node instanceof HtmlInput && !(node instanceof HtmlHiddenInput) ? (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLIENTHIGHT_INPUT_17) ? 17 : 21) : (node instanceof HtmlSelect ? 20 : (node instanceof HtmlTextArea ? 49 : (node instanceof HtmlInlineFrame ? 154 : 0)))));
        } else {
            defaultHeight = ComputedHeight.getHeight(this.getBrowserVersion(), this.getFontSize());
            if (node instanceof HtmlDivision) {
                defaultHeight *= StringUtils.countMatches((CharSequence)node.asText(), (char)'\n') + 1;
            }
        }
        int defaultWindowHeight = elem instanceof HTMLCanvasElement ? 150 : windowHeight;
        int height = ComputedCSSStyleDeclaration.pixelValue(elem, new CSSStyleDeclaration.CssValue(defaultHeight, defaultWindowHeight){

            @Override
            public String get(ComputedCSSStyleDeclaration style) {
                Element element = style.getElement();
                if (element instanceof HTMLBodyElement) {
                    return String.valueOf(element.getWindow().getWebWindow().getInnerHeight());
                }
                return style.getStyleAttribute(StyleAttributes.Definition.HEIGHT, true);
            }
        });
        if (height == 0 && !explicitHeightSpecified) {
            height = defaultHeight;
        }
        this.height2_ = height;
        return height;
    }

    public int getContentHeight() {
        DomElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            return 0;
        }
        CSS2Properties lastFlowing = null;
        HashSet<CSS2Properties> styles = new HashSet<CSS2Properties>();
        for (DomNode child : node.getChildren()) {
            Object t;
            if (!child.mayBeDisplayed() || !((t = child.getScriptableObject()) instanceof HTMLElement)) continue;
            HTMLElement e = (HTMLElement)t;
            CSS2Properties style = e.getWindow().getComputedStyle(e, null);
            String pos = style.getPositionWithInheritance();
            if ("static".equals(pos) || "relative".equals(pos)) {
                lastFlowing = style;
                continue;
            }
            if (!"absolute".equals(pos)) continue;
            styles.add(style);
        }
        if (lastFlowing != null) {
            styles.add(lastFlowing);
        }
        int max = 0;
        for (ComputedCSSStyleDeclaration computedCSSStyleDeclaration : styles) {
            int h = computedCSSStyleDeclaration.getTop(true, false, false) + computedCSSStyleDeclaration.getCalculatedHeight(true, true);
            if (h <= max) continue;
            max = h;
        }
        return max;
    }

    public boolean isScrollable(boolean horizontal) {
        return this.isScrollable(horizontal, false);
    }

    private boolean isScrollable(boolean horizontal, boolean ignoreSize) {
        Element node = this.getElement();
        String overflow = this.getStyleAttribute(StyleAttributes.Definition.OVERFLOW, true);
        boolean scrollable = horizontal ? !(!(node instanceof HTMLBodyElement) && !"scroll".equals(overflow) && !"auto".equals(overflow) || !ignoreSize && this.getContentWidth() <= this.getCalculatedWidth()) : !(!(node instanceof HTMLBodyElement) && !"scroll".equals(overflow) && !"auto".equals(overflow) || !ignoreSize && this.getContentHeight() <= this.getEmptyHeight());
        return scrollable;
    }

    public int getTop(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        int top = 0;
        if (null == this.top_) {
            String p = this.getPositionWithInheritance();
            if ("absolute".equals(p)) {
                top = this.getTopForAbsolutePositionWithInheritance();
            } else {
                boolean prevHadComputedTop = false;
                for (DomNode prev = this.getElement().getDomNodeOrDie().getPreviousSibling(); prev != null && !prevHadComputedTop; prev = prev.getPreviousSibling()) {
                    if (!(prev instanceof HtmlElement)) continue;
                    HTMLElement e = (HTMLElement)((HtmlElement)prev).getScriptableObject();
                    CSS2Properties style = e.getWindow().getComputedStyle(e, null);
                    int prevTop = 0;
                    if (style.top_ == null) {
                        String prevPosition = style.getPositionWithInheritance();
                        if ("absolute".equals(prevPosition)) {
                            prevTop += super.getTopForAbsolutePositionWithInheritance();
                        } else if ("relative".equals(prevPosition)) {
                            String t = style.getTopWithInheritance();
                            prevTop += ComputedCSSStyleDeclaration.pixelValue(t);
                        }
                    } else {
                        prevHadComputedTop = true;
                        prevTop += style.top_.intValue();
                    }
                    prevTop += style.getCalculatedHeight(true, true);
                    int margin = ComputedCSSStyleDeclaration.pixelValue(style.getMarginTop());
                    top += (prevTop += margin);
                }
                if ("relative".equals(p)) {
                    String t = this.getTopWithInheritance();
                    top += ComputedCSSStyleDeclaration.pixelValue(t);
                }
            }
            this.top_ = top;
        } else {
            top = this.top_;
        }
        if (includeMargin) {
            int margin = ComputedCSSStyleDeclaration.pixelValue(this.getMarginTop());
            top += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.getBorderTopWidth());
            top += border;
        }
        if (includePadding) {
            int padding = this.getPaddingTopValue();
            top += padding;
        }
        return top;
    }

    private int getTopForAbsolutePositionWithInheritance() {
        int top = 0;
        String t = this.getTopWithInheritance();
        if (!"auto".equals(t)) {
            top = ComputedCSSStyleDeclaration.pixelValue(t);
        } else {
            String b = this.getBottomWithInheritance();
            if (!"auto".equals(b)) {
                top = 0;
                for (DomNode child = this.getElement().getDomNodeOrDie().getParentNode().getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof HtmlElement) || !child.mayBeDisplayed()) continue;
                    top += 20;
                }
                top -= ComputedCSSStyleDeclaration.pixelValue(b);
            }
        }
        return top;
    }

    public int getLeft(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        HTMLElement parent;
        int left;
        String p = this.getPositionWithInheritance();
        String l = this.getLeftWithInheritance();
        String r = this.getRightWithInheritance();
        if ("absolute".equals(p) && !"auto".equals(l)) {
            left = ComputedCSSStyleDeclaration.pixelValue(l);
        } else if ("absolute".equals(p) && !"auto".equals(r)) {
            parent = (HTMLElement)this.getElement().getParentElement();
            CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
            int parentWidth = style.getCalculatedWidth(false, false);
            left = parentWidth - ComputedCSSStyleDeclaration.pixelValue(r);
        } else if ("fixed".equals(p) && !"auto".equals(r)) {
            parent = (HTMLElement)this.getElement().getParentElement();
            CSS2Properties style = this.getWindow().getComputedStyle(this.getElement(), null);
            CSS2Properties parentStyle = parent.getWindow().getComputedStyle(parent, null);
            left = ComputedCSSStyleDeclaration.pixelValue(parentStyle.getWidth()) - ComputedCSSStyleDeclaration.pixelValue(style.getWidth()) - ComputedCSSStyleDeclaration.pixelValue(r);
        } else if ("fixed".equals(p) && "auto".equals(l)) {
            parent = (HTMLElement)this.getElement().getParentElement();
            CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
            left = ComputedCSSStyleDeclaration.pixelValue(style.getLeftWithInheritance());
        } else if ("static".equals(p)) {
            left = 0;
            for (DomNode n = this.getDomNodeOrDie(); n != null; n = n.getPreviousSibling()) {
                if (n.getScriptableObject() instanceof HTMLElement) {
                    HTMLElement e = (HTMLElement)n.getScriptableObject();
                    CSS2Properties style = e.getWindow().getComputedStyle(e, null);
                    String d = style.getDisplay();
                    if ("block".equals(d)) break;
                    if (!"none".equals(d)) {
                        left += style.getCalculatedWidth(true, true);
                    }
                } else if (n.getScriptableObject() instanceof Text) {
                    left += n.getTextContent().length() * 10;
                }
                if (!(n instanceof HtmlTableRow)) {
                    continue;
                }
                break;
            }
        } else {
            left = ComputedCSSStyleDeclaration.pixelValue(l);
        }
        if (includeMargin) {
            int margin = this.getMarginLeftValue();
            left += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.getBorderLeftWidth());
            left += border;
        }
        if (includePadding) {
            int padding = this.getPaddingLeftValue();
            left += padding;
        }
        return left;
    }

    public String getPositionWithInheritance() {
        String p = this.getStyleAttribute(StyleAttributes.Definition.POSITION, true);
        if ("inherit".equals(p)) {
            HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
            if (parent == null) {
                p = "static";
            } else {
                CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
                p = style.getPositionWithInheritance();
            }
        }
        return p;
    }

    public String getLeftWithInheritance() {
        String left = this.getLeft();
        if ("inherit".equals(left)) {
            HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
            if (parent == null) {
                left = "auto";
            } else {
                CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
                left = style.getLeftWithInheritance();
            }
        }
        return left;
    }

    public String getRightWithInheritance() {
        String right = this.getRight();
        if ("inherit".equals(right)) {
            HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
            if (parent == null) {
                right = "auto";
            } else {
                CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
                right = style.getRightWithInheritance();
            }
        }
        return right;
    }

    public String getTopWithInheritance() {
        String top = this.getTop();
        if ("inherit".equals(top)) {
            HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
            if (parent == null) {
                top = "auto";
            } else {
                CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
                top = style.getTopWithInheritance();
            }
        }
        return top;
    }

    public String getBottomWithInheritance() {
        String bottom = this.getBottom();
        if ("inherit".equals(bottom)) {
            HTMLElement parent = (HTMLElement)this.getElement().getParentElement();
            if (parent == null) {
                bottom = "auto";
            } else {
                CSS2Properties style = parent.getWindow().getComputedStyle(parent, null);
                bottom = style.getBottomWithInheritance();
            }
        }
        return bottom;
    }

    public int getMarginLeftValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getMarginLeft());
    }

    public int getMarginRightValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getMarginRight());
    }

    public int getMarginTopValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getMarginTop());
    }

    public int getMarginBottomValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getMarginBottom());
    }

    public int getPaddingLeftValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getPaddingLeft());
    }

    public int getPaddingRightValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getPaddingRight());
    }

    public int getPaddingTopValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getPaddingTop());
    }

    public int getPaddingBottomValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getPaddingBottom());
    }

    private int getPaddingHorizontal() {
        if (this.paddingHorizontal_ == null) {
            this.paddingHorizontal_ = "none".equals(this.getDisplay()) ? 0 : this.getPaddingLeftValue() + this.getPaddingRightValue();
        }
        return this.paddingHorizontal_;
    }

    private int getPaddingVertical() {
        if (this.paddingVertical_ == null) {
            this.paddingVertical_ = "none".equals(this.getDisplay()) ? 0 : this.getPaddingTopValue() + this.getPaddingBottomValue();
        }
        return this.paddingVertical_;
    }

    public int getBorderLeftValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getBorderLeftWidth());
    }

    public int getBorderRightValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getBorderRightWidth());
    }

    public int getBorderTopValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getBorderTopWidth());
    }

    public int getBorderBottomValue() {
        return ComputedCSSStyleDeclaration.pixelValue(this.getBorderBottomWidth());
    }

    private int getBorderHorizontal() {
        if (this.borderHorizontal_ == null) {
            this.borderHorizontal_ = "none".equals(this.getDisplay()) ? 0 : this.getBorderLeftValue() + this.getBorderRightValue();
        }
        return this.borderHorizontal_;
    }

    private int getBorderVertical() {
        if (this.borderVertical_ == null) {
            this.borderVertical_ = "none".equals(this.getDisplay()) ? 0 : this.getBorderTopValue() + this.getBorderBottomValue();
        }
        return this.borderVertical_;
    }

    @Override
    public String getWordSpacing() {
        return this.defaultIfEmpty(super.getWordSpacing(), StyleAttributes.Definition.WORD_SPACING);
    }

    @Override
    public String getStyleAttribute(StyleAttributes.Definition style, boolean getDefaultValueIfEmpty) {
        if (!this.getElement().getDomNodeOrDie().isAttachedToPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_COMPUTED_NO_Z_INDEX)) {
            return EMPTY_FINAL;
        }
        String value = super.getStyleAttribute(style, getDefaultValueIfEmpty);
        if (value.isEmpty()) {
            Element parent = this.getElement().getParentElement();
            if (INHERITABLE_DEFINITIONS.contains((Object)style) && parent != null) {
                value = this.getWindow().getComputedStyle(parent, null).getStyleAttribute(style, getDefaultValueIfEmpty);
            } else if (getDefaultValueIfEmpty) {
                value = style.getDefaultComputedValue(this.getBrowserVersion());
            }
        }
        return value;
    }

    @Override
    public Object getZIndex() {
        Object response = super.getZIndex();
        if (response.toString().isEmpty()) {
            return "auto";
        }
        return response;
    }

    @Override
    public String getPropertyValue(String name) {
        Object property = ComputedCSSStyleDeclaration.getProperty((Scriptable)this, (String)ComputedCSSStyleDeclaration.camelize(name));
        if (property == NOT_FOUND) {
            return super.getPropertyValue(name);
        }
        return Context.toString((Object)property);
    }

    protected String pixelString(String value) {
        if (value == EMPTY_FINAL || value.endsWith("px")) {
            return value;
        }
        return ComputedCSSStyleDeclaration.pixelValue(value) + "px";
    }

    protected String pixelString(Element element, CSSStyleDeclaration.CssValue value) {
        String s = value.get(element);
        if (s.endsWith("px")) {
            return s;
        }
        return ComputedCSSStyleDeclaration.pixelValue(element, value) + "px";
    }
}

