/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.server.customExport;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class CustomExportDMI {
    private static Logger log = new Logger(DSRequest.class.getName());

    public static DSResponse customExport(DSRequest dsRequest, HttpServletRequest servletRequest) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yy");
        DSResponse response = dsRequest.execute();
        List data = response.getDataList();
        List fields = dsRequest.getExportFields();
        fields.add("gdppercapita");
        dsRequest.setExportFields(fields);
        for (Map record : data) {
            Date dateField = (Date)record.get("independence");
            if (dateField != null) {
                String field = sdf.format(dateField);
                record.put("independence", field);
            }
            double population = 1.0;
            Object populationObj = record.get("population");
            if (populationObj != null) {
                population = Double.parseDouble(populationObj.toString());
            }
            double gdp = Double.parseDouble(record.get("gdp").toString());
            double gdppercapita = gdp * 1000000.0 / population;
            record.put("gdppercapita", new Long(Math.round(gdppercapita)));
        }
        response.setData((Object)data);
        return response;
    }
}

