/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.desktop;

import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.QuickMenu;
import com.opera.core.systems.QuickMenuItem;
import com.opera.core.systems.QuickWidget;
import com.opera.core.systems.QuickWindow;
import com.opera.core.systems.internal.WatirUtils;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.desktop.DesktopUtils;
import com.opera.core.systems.scope.services.desktop.DesktopWindowManager;
import com.opera.core.systems.scope.stp.services.desktop.ScopeSystemInputManager;
import com.opera.core.systems.scope.stp.services.messages.desktop.DesktopWindowManagerMessage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ScopeDesktopWindowManager
extends AbstractService
implements DesktopWindowManager {
    private ScopeSystemInputManager systemInputManager;
    private DesktopUtils desktopUtils;
    private int activeWindowId = 0;

    public ScopeDesktopWindowManager(ScopeServices services) {
        super(services, "desktop-window-manager", "2.3");
        services.setDesktopWindowManager(this);
    }

    @Override
    public void init() {
        this.systemInputManager = this.services.getSystemInputManager();
        this.desktopUtils = this.services.getDesktopUtils();
    }

    @Override
    public int getActiveQuickWindowId() {
        UmsProtos.Response response = this.executeMessage(DesktopWindowManagerMessage.GET_ACTIVE_WINDOW, null);
        DesktopWmProtos.DesktopWindowID.Builder builder = DesktopWmProtos.DesktopWindowID.newBuilder();
        ScopeDesktopWindowManager.buildPayload(response, builder);
        this.activeWindowId = builder.build().getWindowID();
        return this.activeWindowId;
    }

    @Override
    public int getOpenQuickWindowCount() {
        List<DesktopWmProtos.DesktopWindowInfo> windows = this.getDesktopWindowInfoList();
        return windows.size();
    }

    @Override
    public QuickWindow getQuickWindow(DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType property, String value) {
        QuickWindow lastFound = null;
        List<QuickWindow> windows = this.getQuickWindowList();
        for (QuickWindow window : windows) {
            if (!property.equals((Object)DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType.NAME) || !window.getName().equals(value)) continue;
            if (window.isOnScreen()) {
                return window;
            }
            lastFound = window;
        }
        return lastFound;
    }

    @Override
    public List<QuickWindow> getQuickWindowList() {
        UmsProtos.Response response = this.executeMessage(DesktopWindowManagerMessage.LIST_WINDOWS, null);
        DesktopWmProtos.DesktopWindowList.Builder builder = DesktopWmProtos.DesktopWindowList.newBuilder();
        builder.clear();
        ScopeDesktopWindowManager.buildPayload(response, builder);
        DesktopWmProtos.DesktopWindowList list = builder.build();
        List<DesktopWmProtos.DesktopWindowInfo> windowInfoList = list.getWindowListList();
        LinkedList<QuickWindow> windowList = new LinkedList<QuickWindow>();
        for (DesktopWmProtos.DesktopWindowInfo windowInfo : windowInfoList) {
            windowList.add(new QuickWindow(windowInfo));
        }
        return windowList;
    }

    public List<DesktopWmProtos.DesktopWindowInfo> getDesktopWindowInfoList() {
        UmsProtos.Response response = this.executeMessage(DesktopWindowManagerMessage.LIST_WINDOWS, null);
        DesktopWmProtos.DesktopWindowList.Builder builder = DesktopWmProtos.DesktopWindowList.newBuilder();
        ScopeDesktopWindowManager.buildPayload(response, builder);
        DesktopWmProtos.DesktopWindowList list = builder.build();
        return list.getWindowListList();
    }

    @Override
    public int getQuickWindowID(String name) {
        QuickWindow win = this.getQuickWindowByName(name);
        if (win != null) {
            return win.getWindowID();
        }
        return -1;
    }

    @Override
    public QuickWindow getQuickWindowByName(String name) {
        List<DesktopWmProtos.DesktopWindowInfo> windowList = this.getDesktopWindowInfoList();
        for (DesktopWmProtos.DesktopWindowInfo window : windowList) {
            if (!window.getName().equals(name)) continue;
            return new QuickWindow(window);
        }
        return null;
    }

    @Override
    public QuickWindow getQuickWindowById(int windowId) {
        List<DesktopWmProtos.DesktopWindowInfo> windowList = this.getDesktopWindowInfoList();
        for (DesktopWmProtos.DesktopWindowInfo window : windowList) {
            if (window.getWindowID() != windowId) continue;
            return new QuickWindow(window);
        }
        return null;
    }

    @Override
    public String getQuickWindowName(int windowId) {
        QuickWindow window = this.getQuickWindowById(windowId);
        return window == null ? "" : window.getName();
    }

    @Override
    public QuickWidget getQuickWidget(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType property, String value) {
        return this.getQuickWidget(type, windowId, property, value, "");
    }

    @Override
    public QuickWidget getQuickWidget(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType property, String value, String parentName) {
        if (windowId < 0) {
            windowId = this.getActiveQuickWindowId();
        }
        List<QuickWidget> widgets = this.getQuickWidgetList(windowId);
        for (QuickWidget widget : widgets) {
            if (widget.getType() != type || !(property.equals((Object)DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType.NAME) ? (parentName.length() == 0 || widget.getParentName().equals(parentName)) && widget.getName().equals(value) : property.equals((Object)DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType.TEXT) && (parentName.length() == 0 || widget.getParentName().equals(parentName)) && WatirUtils.textMatchesWithANY(widget.getText(), value))) continue;
            return widget;
        }
        return null;
    }

    @Override
    public QuickWidget getQuickWidgetByPos(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int id, int row, int column) {
        return this.getQuickWidgetByPos(type, id, row, column, "");
    }

    @Override
    public QuickWidget getQuickWidgetByPos(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, int row, int column, String parentName) {
        if (windowId < 0) {
            windowId = this.getActiveQuickWindowId();
        }
        List<QuickWidget> widgets = this.getQuickWidgetList(windowId);
        for (QuickWidget widget : widgets) {
            if (parentName.length() != 0 && !widget.getParentName().equals(parentName) || widget.getType() != type || widget.getType() != DesktopWmProtos.QuickWidgetInfo.QuickWidgetType.TABBUTTON && widget.getType() != DesktopWmProtos.QuickWidgetInfo.QuickWidgetType.TREEITEM && widget.getType() != DesktopWmProtos.QuickWidgetInfo.QuickWidgetType.THUMBNAIL && widget.getType() != DesktopWmProtos.QuickWidgetInfo.QuickWidgetType.BUTTON || widget.getRow() != row || widget.getColumn() != column) continue;
            return widget;
        }
        return null;
    }

    @Override
    public List<QuickWidget> getQuickWidgetList(int windowId) {
        if (windowId <= 0) {
            windowId = this.getActiveQuickWindowId();
        }
        DesktopWmProtos.DesktopWindowID.Builder winBuilder = DesktopWmProtos.DesktopWindowID.newBuilder();
        winBuilder.clearWindowID();
        if (windowId >= 0) {
            winBuilder.setWindowID(windowId);
        } else {
            winBuilder.setWindowID(this.activeWindowId);
            windowId = this.activeWindowId;
        }
        UmsProtos.Response response = this.executeMessage(DesktopWindowManagerMessage.LIST_QUICK_WIDGETS, (AbstractMessage.Builder<?>)winBuilder);
        DesktopWmProtos.QuickWidgetInfoList.Builder builder = DesktopWmProtos.QuickWidgetInfoList.newBuilder();
        builder.clear();
        ScopeDesktopWindowManager.buildPayload(response, builder);
        DesktopWmProtos.QuickWidgetInfoList list = builder.build();
        List<DesktopWmProtos.QuickWidgetInfo> widgetList = list.getQuickwidgetListList();
        LinkedList<QuickWidget> quickWidgetList = new LinkedList<QuickWidget>();
        for (DesktopWmProtos.QuickWidgetInfo widgetInfo : widgetList) {
            quickWidgetList.add(new QuickWidget(this.desktopUtils, this.systemInputManager, widgetInfo, windowId));
        }
        return quickWidgetList;
    }

    @Override
    public QuickMenu getQuickMenu(String menuName) {
        List<DesktopWmProtos.QuickMenuInfo> list = this.getQuickMenuInfoList();
        for (DesktopWmProtos.QuickMenuInfo info : list) {
            if (!info.getMenuId().getMenuName().equals(menuName)) continue;
            return new QuickMenu(info, this.desktopUtils, this.systemInputManager);
        }
        return null;
    }

    @Override
    public List<QuickMenu> getQuickMenuList() {
        List<DesktopWmProtos.QuickMenuInfo> menuInfoList = this.getQuickMenuInfoList();
        LinkedList<QuickMenu> menuList = new LinkedList<QuickMenu>();
        for (DesktopWmProtos.QuickMenuInfo menuInfo : menuInfoList) {
            menuList.add(new QuickMenu(menuInfo, this.desktopUtils, this.systemInputManager));
        }
        return menuList;
    }

    private List<DesktopWmProtos.QuickMenuInfo> getQuickMenuInfoList() {
        UmsProtos.Response response = this.executeMessage(DesktopWindowManagerMessage.LIST_QUICK_MENUS, null);
        DesktopWmProtos.QuickMenuList.Builder builder = DesktopWmProtos.QuickMenuList.newBuilder();
        builder.clear();
        ScopeDesktopWindowManager.buildPayload(response, builder);
        DesktopWmProtos.QuickMenuList list = builder.build();
        return list.getMenuListList();
    }

    @Override
    public List<QuickMenuItem> getQuickMenuItemList() {
        ArrayList<QuickMenuItem> list = new ArrayList<QuickMenuItem>();
        List<DesktopWmProtos.QuickMenuInfo> menus = this.getQuickMenuInfoList();
        for (DesktopWmProtos.QuickMenuInfo info : menus) {
            for (DesktopWmProtos.QuickMenuItemInfo infoItem : info.getMenuItemListList()) {
                QuickMenuItem item = new QuickMenuItem(infoItem, info.getMenuId().getMenuName(), this.desktopUtils, this.systemInputManager);
                list.add(item);
            }
        }
        return list;
    }

    @Override
    public void pressQuickMenuItem(String menuItemText, boolean popMenu) {
        DesktopWmProtos.QuickMenuItemID.Builder builder = DesktopWmProtos.QuickMenuItemID.newBuilder();
        builder.setMenuText(menuItemText);
        builder.setPopupMenu(popMenu);
        this.executeMessage(DesktopWindowManagerMessage.PRESS_QUICK_MENU, (AbstractMessage.Builder<?>)builder);
    }

    @Override
    public QuickMenuItem getQuickMenuItemByAction(String action) {
        List<QuickMenuItem> itemList = this.getQuickMenuItemList();
        for (QuickMenuItem item : itemList) {
            if (!item.getActionName().equals(action)) continue;
            return item;
        }
        return null;
    }

    @Override
    public QuickMenuItem getQuickMenuItemBySubmenu(String submenu) {
        List<QuickMenu> menus = this.getQuickMenuList();
        for (QuickMenu menu : menus) {
            List<QuickMenuItem> itemList = menu.getItemList();
            for (QuickMenuItem item : itemList) {
                if (!item.getSubMenu().equals(submenu)) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public QuickMenuItem getQuickMenuItemByText(String text) {
        List<QuickMenu> menus = this.getQuickMenuList();
        for (QuickMenu menu : menus) {
            List<QuickMenuItem> itemList = menu.getItemList();
            for (QuickMenuItem item : itemList) {
                if (!item.getText().equals(text)) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public QuickMenuItem getQuickMenuItemByAccKey(String key, String menuName) {
        List<QuickMenu> menus = this.getQuickMenuList();
        for (QuickMenu menu : menus) {
            List<QuickMenuItem> itemList = menu.getItemList();
            for (QuickMenuItem item : itemList) {
                if (!item.getShortcutLetter().equalsIgnoreCase(key) || menuName != null && !item.getMenu().equals(menuName)) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public QuickMenuItem getQuickMenuItemByShortcut(String shortcut) {
        List<QuickMenu> menus = this.getQuickMenuList();
        for (QuickMenu menu : menus) {
            List<QuickMenuItem> itemList = menu.getItemList();
            for (QuickMenuItem item : itemList) {
                if (!item.getShortcut().equals(shortcut)) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public QuickMenuItem getQuickMenuItemByPosition(int row, String menuName) {
        List<QuickMenu> menus = this.getQuickMenuList();
        for (QuickMenu menu : menus) {
            List<QuickMenuItem> itemList = menu.getItemList();
            for (QuickMenuItem item : itemList) {
                if (item.getRow() != row || menuName != null && !item.getMenu().equals(menuName)) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public QuickMenuItem getQuickMenuItemByName(String name) {
        List<QuickMenu> menus = this.getQuickMenuList();
        for (QuickMenu menu : menus) {
            List<QuickMenuItem> itemList = menu.getItemList();
            for (QuickMenuItem item : itemList) {
                String[] parts;
                if (item.getActionName().equals(name) || item.getSubMenu().equals(name) || item.isSeparator() && name.equals("Separator")) {
                    return item;
                }
                if (name.indexOf(44) == 0 || (parts = name.split(",")).length < 2 || !parts[0].trim().equals(item.getActionName()) || !parts[1].trim().equals(item.getActionParameter())) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public QuickMenu getQuickMenu(String menuName, int windowId) {
        List<DesktopWmProtos.QuickMenuInfo> list = this.getQuickMenuInfoList();
        for (DesktopWmProtos.QuickMenuInfo info : list) {
            if (!info.getMenuId().getMenuName().equals(menuName) || info.getWindowId().getWindowID() != windowId) continue;
            return new QuickMenu(info, this.desktopUtils, this.systemInputManager);
        }
        return null;
    }

    @Override
    public QuickMenuItem getQuickMenuItemByName(String name, int window_id) {
        List<QuickMenu> menus = this.getQuickMenuList();
        for (QuickMenu menu : menus) {
            if (menu.getParentWindowId() != window_id) continue;
            List<QuickMenuItem> itemList = menu.getItemList();
            for (QuickMenuItem item : itemList) {
                String[] parts;
                if (item.getActionName().equals(name) || item.getSubMenu().equals(name) || item.isSeparator() && name.equals("Separator")) {
                    return item;
                }
                if (name.indexOf(",") == 0 || (parts = name.split(",")).length < 2 || !parts[0].trim().equals(item.getActionName()) || !parts[1].trim().equals(item.getActionParameter())) continue;
                return item;
            }
        }
        return null;
    }
}

