/*-=-
    Isomorphic SmartClient web presentation layer
    Copyright 2000-2007 Isomorphic Software, Inc.

    OWNERSHIP NOTICE
    Isomorphic Software owns and reserves all rights not expressly granted in this source code,
    including all intellectual property rights to the structure, sequence, and format of this code
    and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.

    CONFIDENTIALITY NOTICE
    The contents of this file are confidential and protected by non-disclosure agreement:
      * You may not expose this file to any person who is not bound by the same obligations.
      * You may not expose or send this file unencrypted on a public network.

    SUPPORTED INTERFACES
    Most interfaces expressed in this source code are internal and unsupported. Isomorphic supports
    only the documented behaviors of properties and methods that are marked "@visibility external"
    in this code. All other interfaces may be changed or removed without notice. The implementation
    of any supported interface may also be changed without notice.
 
    If you have any questions, please email <sourcecode@isomorphic.com>.
 
    This entire comment must accompany any portion of Isomorphic Software source code that is
    copied or moved from this file.
*/

package com.isomorphic.struts;

import java.io.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

import com.isomorphic.base.*;
import com.isomorphic.log.*;
import com.isomorphic.rpc.*;
import com.isomorphic.datasource.*;

import org.apache.struts.action.*;


public class ValidationAction extends Action {

    private Logger log = new Logger(ValidationAction.class.getName());

    // if we're here, the validation succeeded.
    public ActionForward execute(ActionMapping mapping, ActionForm form,
                                 HttpServletRequest request, HttpServletResponse response)
        throws Exception 
    {
        if(!RPCManager.isRPC(request)) 
            throw new Exception("Received a non-RPC request in ValidationAction - please check"
                                + " your DynamicForm configuration, the ValidationAction URL should"
                                + " be specified as the 'validationURL' parameter on the DynamicForm.");
        
        //log.warn("sending success response");

        RPCManager rpc = new RPCManager(request, response);

        DSRequest dsRequest = (DSRequest)rpc.getRequests().get(0);
        DSResponse dsResponse = new DSResponse(dsRequest == null ? (DataSource)null : 
                                                                   dsRequest.getDataSource());
        rpc.send(dsRequest, dsResponse);

        return null;
    }
}
