/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.base.VersionSafeChecker;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.CriteriaUtils;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Evaluator;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.OperatorBase;
import com.isomorphic.criteria.criterion.DateRangeCriterion;
import com.isomorphic.criteria.criterion.LogicalCriterion;
import com.isomorphic.criteria.criterion.NotCriterion;
import com.isomorphic.criteria.criterion.RelativeDateRangeCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.AuditDSGenerator;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.Committable;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DynamicDSGenerator;
import com.isomorphic.datasource.ForeignKeyNotFoundException;
import com.isomorphic.datasource.FrameworkDynamicDSGenerator;
import com.isomorphic.datasource.FreeResourcesHandler;
import com.isomorphic.datasource.ISCGregorianCalendar;
import com.isomorphic.datasource.ISCMapBean;
import com.isomorphic.datasource.IType;
import com.isomorphic.datasource.IncludeFromInfo;
import com.isomorphic.datasource.OperationNotSupportedException;
import com.isomorphic.datasource.Relation;
import com.isomorphic.datasource.RelationFieldInfo;
import com.isomorphic.datasource.RelationInfo;
import com.isomorphic.datasource.StreamingResponseException;
import com.isomorphic.datasource.SummaryFunctionType;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.datasource.Validator;
import com.isomorphic.interfaces.ISpringTransactionObjectProvider;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.IBeanFilter;
import com.isomorphic.js.IContextBeanFilter;
import com.isomorphic.js.IContextBeanFilterWithNullControl;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BuiltinRPC;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.ISCDate;
import com.isomorphic.util.ISCTime;
import com.isomorphic.util.JXPathBeanPointer;
import com.isomorphic.util.JXPathBeanPointerFactory;
import com.isomorphic.util.JXPathContextObjectFactory;
import com.isomorphic.util.date.DateUtil;
import com.isomorphic.util.date.Period;
import com.isomorphic.util.date.RelativeDate;
import com.isomorphic.util.date.RelativeDateRangePosition;
import com.isomorphic.util.date.RelativeDateShortcut;
import com.isomorphic.velocity.Velocity;
import com.isomorphic.xml.XML;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.jxpath.ri.model.beans.BeanPropertyPointer;
import org.apache.commons.lang.ObjectUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataSource
extends Base
implements Committable,
IType,
IToJSON,
FreeResourcesHandler,
Serializable {
    private static final String TIMING_TRANSFORM_MULTIPLE_FIELDS = "transformMultipleFields processing";
    protected static final int DEFAULT_PROGRESSIVE_LOADING_THRESHOLD = 200000;
    protected static final int DEFAULT_LOOKAHEAD = 1;
    protected static final int DEFAULT_END_GAP = 20;
    private static Logger log = new Logger(DataSource.class.getName());
    protected String dsName;
    protected String dsConfigFile;
    protected DataTypeMap<String, Object> dsConfig;
    protected DataTypeMap<String, Object> dsConfigAnnotated;
    protected List<String> fieldList;
    protected long configTimestamp = -1L;
    protected Thread owner = null;
    public static int totalInstantiationTime = 0;
    public static int totalDataSources = 0;
    protected static long nextInstanceId = 1L;
    protected long instanceId;
    protected boolean omitNullMapValuesInResponse;
    private final String TRANSACTION_OBJECT_KEY;
    private static ThreadLocal<HashMap<String, DataSource>> inInitStateThreadLocal = new ThreadLocal();
    protected Map<String, RelationFieldInfo> relationFields;
    protected Map<String, IncludeFromInfo> includeFromFields;
    public static final String OP_VIEW_FILE = "viewFile";
    public static final String OP_DOWNLOAD_FILE = "downloadFile";
    public static final String OP_LOAD_SCHEMA = "loadSchema";
    public static final String OP_FETCH = "fetch";
    public static final String OP_ADD = "add";
    public static final String OP_REMOVE = "remove";
    public static final String OP_UPDATE = "update";
    public static final String OP_CUSTOM = "custom";
    public static final String OP_VALIDATE = "validate";
    public static final Set<String> OPS_VALID_FOR_FIELDVALUEEXPRESSION = new HashSet<String>(Arrays.asList("fetch", "add", "update", "remove", "custom"));
    public static final String OP_CLIENT_EXPORT = "clientExport";
    public static final String OP_GET_FILE = "getFile";
    public static final String OP_ID_XML_TO_JS = "xmlToJs";
    public static final String OP_HAS_FILE = "hasFile";
    public static final String OP_LIST_FILES = "listFiles";
    public static final String OP_SAVE_FILE = "saveFile";
    public static final String OP_RENAME_FILE = "renameFile";
    public static final String OP_REMOVE_FILE = "removeFile";
    public static final String OP_LIST_FILE_VERSIONS = "listFileVersions";
    public static final String OP_GET_FILE_VERSION = "getFileVersion";
    public static final String OP_HAS_FILE_VERSION = "hasFileVersion";
    public static final String OP_REMOVE_FILE_VERSION = "removeFileVersion";
    public static final Set<String> OP_FILE_SOURCE = new HashSet<String>(Arrays.asList("getFile", "hasFile", "listFiles", "saveFile", "renameFile", "removeFile", "listFileVersions", "getFileVersion", "hasFileVersion", "removeFileVersion"));
    public static final Set<String> RESPONSE_PROPS_VALID_FOR_FIELDVALUEEXPRESSION = new HashSet<String>(Arrays.asList("totalRows", "startRow", "endRow", "status"));
    public static final String FS_FILE_CONTENTS = "fileContents";
    public static final String FS_FILE_TYPE = "fileType";
    public static final String FS_FILE_FORMAT = "fileFormat";
    public static final String FS_FILE_NAME = "fileName";
    public static final String FS_FILE_LAST_MODIFIED = "fileLastModified";
    public static final String FS_FILE_SIZE = "fileSize";
    public static final String FS_FILE_ENCODING = "fileEncoding";
    public static final String FS_FILE_CONTENTS_AS_JS = "fileContentsJS";
    public static final String FS_EXT_FIELDS = "fileSourceExtensionFields";
    public static final String FS_MAX_FILE_VERSIONS_PROPERTY = "maxFileVersions";
    public static final int FS_MAX_FILE_VERSIONS_DEFAULT = 20;
    public static final List<String> FS_PRIMARY_KEYS = Arrays.asList("fileName", "fileType", "fileFormat");
    public static final String OP_STORE_TEST_DATA = "storeTestData";
    public static final String OP_GET_TEST_DATA = "getTestData";
    private static Map dynamicDSGenerators = new LinkedHashMap();
    private static Stack<DynamicDSGenerator> defaultDDSGs = new Stack();
    private static Object ddsgSyncFlag = new Object();
    private static Stack gettingDynamic = new Stack();
    public static Map creationCount = new HashMap();
    static final String builtinTypesFile = "builtinTypes.xml";
    static Map builtinTypes;
    protected DataTypeMap globalServerConfig = null;
    protected DataTypeMap serverConfigByOperationId = new DataTypeMap();
    static String dynamicBeanMarkerName;
    static Class dynamicBeanMarker;
    public static long beanConversionLapse;
    public static long subValuesLapse;
    public static long subValDSMLapse;
    public static long subValVCLapse;
    public static long subValVCHit;
    public static long subValVCMiss;
    public static long inSubValueLapse;
    public static long inSubValueLapse0;
    public static long inSubValueLapse1;
    public static long inSubValueLapse2;
    public static long subPropsLapse;
    protected Map<String, String> fileSourceFieldMapToNative = new HashMap<String, String>();
    protected Map<String, String> fileSourceFieldMapFromNative = new HashMap<String, String>();
    protected boolean fileSourceFieldMapInitialized = false;
    private boolean preventFileContentsRecursion = false;
    public static final String USE_SPRING_TRANSACTION = "useSpringTransaction";
    public static boolean useAxisForSQLDS;
    Evaluator evaluator;
    private Map<String, RelationInfo> cachedRelations = new HashMap<String, RelationInfo>();
    protected Map<String, String> filenameField = new HashMap<String, String>();
    protected Map<String, String> filesizeField = new HashMap<String, String>();
    protected Map<String, String> dateCreatedField = new HashMap<String, String>();
    private Map<DSField, Class> convertedProps = new HashMap<DSField, Class>();

    public Thread getOwningThread() {
        return this.owner;
    }

    public boolean belongsToThread(Thread returner) {
        return returner == this.owner;
    }

    public void activateOnThread(Thread activator) {
        this.owner = activator;
    }

    public void passivate() {
        this.owner = null;
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public boolean getOmitNullMapValuesInResponse() {
        return this.omitNullMapValuesInResponse;
    }

    public void setOmitNullMapValuesInResponse(boolean omitNullMapValuesInResponse) {
        this.omitNullMapValuesInResponse = omitNullMapValuesInResponse;
    }

    protected static final HashMap<String, DataSource> getInInitState() {
        HashMap<String, DataSource> work = inInitStateThreadLocal.get();
        if (work == null) {
            log.debug("Initializing inInitState");
            work = new HashMap();
            DataSource.setInInitState(work);
        }
        return work;
    }

    protected static final void setInInitState(HashMap<String, DataSource> value) {
        log.debug("Setting inInitState");
        inInitStateThreadLocal.set(value);
    }

    protected static final void clearInInitState() {
        HashMap<String, DataSource> work = inInitStateThreadLocal.get();
        if (work == null) {
            log.debug("In clearInInitState, the cache was already null; nothing to do");
            return;
        }
        log.debug("Clearing inInitState; it contained " + work.size() + " entries");
        work.clear();
        inInitStateThreadLocal.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource forName(String dsName, DSRequest dsRequest, boolean isSchemaless) throws Exception {
        DataSource ds;
        try {
            if ("DataSource".equals(dsName)) {
                DataStructCache.disableDsPaths();
            }
            if ((ds = DataSource.getDynamicDataSource(dsName, dsRequest)) == null) {
                ds = DataSource.loadDS(dsName, dsRequest, isSchemaless);
            }
        }
        finally {
            if ("DataSource".equals(dsName)) {
                DataStructCache.enableDsPaths();
            }
        }
        return ds;
    }

    private static DataSource loadDS(String dsName, DSRequest dsRequest, boolean isSchemaless) throws Exception {
        Object dsConfig;
        HashMap flags = new HashMap();
        String dsConfigFile = null;
        if ("Object".equals(dsName)) {
            dsConfig = DataTools.buildMap("ID", "Object");
        } else {
            Object dsObject = DataStructCache.getCachedObjectWithNoConfigFile(dsName);
            if (dsObject != null && dsObject instanceof DataSource) {
                return (DataSource)dsObject;
            }
            dsConfigFile = DataStructCache.getInstanceFile(dsName, "datasources", "DS", isSchemaless);
            if (dsConfigFile == null) {
                return null;
            }
            dsConfig = (Map)DataStructCache.loadInstance(dsConfigFile, dsName, "DS", flags);
            if (dsConfig == null) {
                throw new Exception("Can't locate datasource for name: " + dsName);
            }
            String ID = (String)dsConfig.get("ID");
            if (ID != null && !dsName.equals(ID)) {
                if (log.isDebugEnabled()) {
                    log.debug("dsName case sensitivity mismatch - looking for: " + dsName + ", but got: " + ID);
                }
                return null;
            }
            if (dsConfig == null) {
                return null;
            }
        }
        Object autoDerive = dsConfig.get("autoDeriveSchema");
        if (autoDerive != null && "true".equals(autoDerive.toString()) && Boolean.TRUE.equals(flags.get("objectWasStale"))) {
            DataStructCache.removeCachedObjectWithNoConfigFile(dsName + "_inheritsFrom");
        }
        long start = System.currentTimeMillis();
        DataSource ds = DataSource.fromConfig((Map)dsConfig, dsRequest);
        long end = System.currentTimeMillis();
        if (dsConfigFile != null) {
            ds.dsConfigFile = dsConfigFile;
            ds.configTimestamp = ISCFile.newInstance(dsConfigFile).lastModified();
            if (dsConfigFile.startsWith("ds://")) {
                int prefixLen = "ds://".length();
                String parentDatasourceId = dsConfigFile.substring(prefixLen, dsConfigFile.indexOf("/", prefixLen));
                ds.getConfig().put("sourceDataSourceID", parentDatasourceId);
            }
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDynamicDSGenerator(DynamicDSGenerator ddsg) {
        Object object = ddsgSyncFlag;
        synchronized (object) {
            if (ddsg != null && log.isDebugEnabled()) {
                log.debug("Adding new default DynamicDSGenerator with hashcode '" + ddsg.hashCode() + "'");
            }
            defaultDDSGs.push(ddsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicDSGenerator removeDynamicDSGenerator() {
        Object object = ddsgSyncFlag;
        synchronized (object) {
            DynamicDSGenerator ddsg = null;
            if (!defaultDDSGs.isEmpty()) {
                ddsg = defaultDDSGs.pop();
            }
            if (log.isDebugEnabled()) {
                DynamicDSGenerator newDft = null;
                Object object2 = ddsgSyncFlag;
                synchronized (object2) {
                    if (!defaultDDSGs.isEmpty()) {
                        newDft = defaultDDSGs.peek();
                    }
                }
                String newHash = newDft == null ? "null" : "" + newDft.hashCode();
                log.debug("Removed current default DynamicDSGenerator '" + (ddsg == null ? "null" : Integer.valueOf(ddsg.hashCode())) + "' from the stack.  New default is '" + newHash + "'");
            }
            return ddsg;
        }
    }

    public static void addDynamicDSGenerator(DynamicDSGenerator ddsg, String prefix) {
        dynamicDSGenerators.put(prefix, ddsg);
    }

    public static void addDynamicDSGenerator(DynamicDSGenerator ddsg, Pattern regex) {
        dynamicDSGenerators.put(regex, ddsg);
    }

    public static DynamicDSGenerator getDefaultDynamicDSGenerator() {
        if (defaultDDSGs.isEmpty()) {
            return null;
        }
        return defaultDDSGs.peek();
    }

    public static Map getDynamicDSGenerators() {
        return dynamicDSGenerators;
    }

    public static DynamicDSGenerator removeDynamicDSGenerator(String prefix) {
        if (dynamicDSGenerators.containsKey(prefix)) {
            DynamicDSGenerator ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(prefix);
            dynamicDSGenerators.remove(prefix);
            return ddsg;
        }
        return null;
    }

    public static DynamicDSGenerator removeDynamicDSGenerator(Pattern regex) {
        if (dynamicDSGenerators.containsKey(regex)) {
            DynamicDSGenerator ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(regex);
            dynamicDSGenerators.remove(regex);
            return ddsg;
        }
        return null;
    }

    public static void clearDynamicDSGenerators() {
        DataSource.clearDynamicDSGenerators(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearDynamicDSGenerators(boolean removeFrameworkGenerators) {
        Object object = ddsgSyncFlag;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Clearing all DynamicDSGenerators", new Exception());
            }
            Stack<DynamicDSGenerator> work = new Stack<DynamicDSGenerator>();
            int entries = defaultDDSGs.size();
            int i = 0;
            while (i++ < entries) {
                DynamicDSGenerator ddsg = defaultDDSGs.pop();
                if (removeFrameworkGenerators || !(ddsg instanceof FrameworkDynamicDSGenerator)) continue;
                work.push(ddsg);
            }
            entries = work.size();
            i = 0;
            while (i++ < entries) {
                defaultDDSGs.push((DynamicDSGenerator)work.pop());
            }
            if (removeFrameworkGenerators) {
                dynamicDSGenerators.clear();
            } else {
                Iterator j = dynamicDSGenerators.keySet().iterator();
                while (j.hasNext()) {
                    Object key = j.next();
                    DynamicDSGenerator ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(key);
                    if (ddsg instanceof FrameworkDynamicDSGenerator) continue;
                    j.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DataSource getDynamicDataSource(String id, DSRequest dsRequest) throws Exception {
        if (!gettingDynamic.empty() && gettingDynamic.peek().equals(id)) {
            return null;
        }
        gettingDynamic.push(id);
        DynamicDSGenerator ddsg = null;
        for (Object keyObj : dynamicDSGenerators.keySet()) {
            if (keyObj instanceof String) {
                if (id.indexOf((String)keyObj) != 0) continue;
                ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(keyObj);
                break;
            }
            if (keyObj instanceof Pattern) {
                Pattern p = (Pattern)keyObj;
                Matcher m = p.matcher(id);
                if (!m.find()) continue;
                ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(keyObj);
                break;
            }
            log.warn("In the dynamicDSGenerators list, we found a key of type " + keyObj.getClass().getName() + ". Ignoring");
        }
        DataSource ds = null;
        try {
            if (ddsg != null) {
                ds = ddsg.getDataSource(id, dsRequest);
            }
            if (ds == null) {
                ds = DataSource.getDataSourceFromStack(id, dsRequest, defaultDDSGs);
            }
        }
        finally {
            if (!gettingDynamic.isEmpty()) {
                gettingDynamic.pop();
            }
            if (ds != null && id != null && !id.equals(ds.getName())) {
                String msg = "A DynamicDSGenerator returned a DataSource named '" + ds.getName() + "' in response to a request for '" + id + "'.  This is a bug in your DynamicDSGenerator.  Abandoning now to avoid unpredictable errors later in the code flow";
                log.warn(msg);
                throw new Exception(msg);
            }
        }
        return ds;
    }

    private static DataSource getDataSourceFromStack(String id, DSRequest dsRequest, Stack<DynamicDSGenerator> stackIn) {
        Stack<DynamicDSGenerator> stackWork = new Stack<DynamicDSGenerator>();
        stackWork.addAll(stackIn);
        DynamicDSGenerator ddsg = null;
        if (!stackWork.isEmpty()) {
            ddsg = (DynamicDSGenerator)stackWork.pop();
        }
        if (ddsg == null) {
            return null;
        }
        DataSource ds = ddsg.getDataSource(id, dsRequest);
        if (ds != null) {
            return ds;
        }
        return DataSource.getDataSourceFromStack(id, dsRequest, stackWork);
    }

    public static boolean isDynamic(String id) {
        DynamicDSGenerator ddsg = null;
        for (Object keyObj : dynamicDSGenerators.keySet()) {
            if (keyObj instanceof String) {
                if (id.indexOf((String)keyObj) != 0) continue;
                ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(keyObj);
                break;
            }
            if (keyObj instanceof Pattern) {
                Pattern p = (Pattern)keyObj;
                Matcher m = p.matcher(id);
                if (!m.find()) continue;
                ddsg = (DynamicDSGenerator)dynamicDSGenerators.get(keyObj);
                break;
            }
            log.warn("In the dynamicDSGenerators list, we found a key of type " + keyObj.getClass().getName() + ". Ignoring");
        }
        if (ddsg == null) {
            ddsg = DataSource.getDefaultDynamicDSGenerator();
        }
        return ddsg != null;
    }

    public static DataSource fromConfig(Map theConfig, DSRequest dsRequest) throws Exception {
        if (config.getBoolean((Object)"datasource.detect.bad.creation", false)) {
            Exception e = new Exception("We are in DataSource.fromConfig() and we came through PoolableDataSourceFactory.makeUnpooledObject(), but did not come through DataSourceManager.getDataSource().  This could lead to concurrency problems! (DS ID: " + theConfig.get("ID") + ")");
            StackTraceElement[] ste = e.getStackTrace();
            boolean ok = true;
            for (int i = 0; i < ste.length; ++i) {
                if ("com.isomorphic.datasource.PoolableDataSourceFactory".equals(ste[i].getClassName()) && "makeUnpooledObject".equals(ste[i].getMethodName())) {
                    ok = false;
                    continue;
                }
                if (!"com.isomorphic.datasource.DataSourceManager".equals(ste[i].getClassName()) || !"getDataSource".equals(ste[i].getMethodName())) continue;
                ok = true;
            }
            if (!ok) {
                if (config.getBoolean((Object)"datasource.reject.bad.creation", false)) {
                    throw e;
                }
                log.warn((Object)"Potential concurrency problem", e);
            }
        }
        return BasicDataSource.fromConfig(theConfig, dsRequest);
    }

    public final void initialize(Map theConfig, DSRequest dsRequest) throws Exception {
        this.init(theConfig, dsRequest);
        this.initialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        Object object = DataSource.class;
        synchronized (DataSource.class) {
            this.instanceId = nextInstanceId++;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.dsConfig = (DataTypeMap)((Object)DataTools.mapMerge(theConfig, new DataTypeMap()));
            this.dsName = this.dsConfig.getString("ID");
            this.fieldList = new ArrayList<String>();
            if (this.dsName == null) {
                log.warn("dsConfig with no ID: " + DataTools.prettyPrint(this.dsConfig));
            }
            if (log.isDebugEnabled()) {
                if (config.getBoolean((Object)"debug.dataSource.creation", false)) {
                    log.debug("Creating instance of DataSource '" + this.dsName + "' with instanceId " + this.instanceId);
                }
                object = creationCount;
                synchronized (object) {
                    DataTools.incrementIntInMap(creationCount, this.dsName);
                }
                ++totalDataSources;
            }
            return;
        }
    }

    public Object deepCloneWithVelocityEval(Object source, String operationName, Map templateContext) throws Exception {
        if (source == null) {
            return null;
        }
        if (source instanceof Map) {
            Map target = (Map)Reflection.newInstance(source.getClass());
            for (Object key : ((Map)source).keySet()) {
                Object value = ((Map)source).get(key);
                target.put(key, this.deepCloneWithVelocityEval(value, operationName, templateContext));
            }
            return target;
        }
        if (source instanceof Collection) {
            Collection target = (Collection)Reflection.newInstance(source.getClass());
            for (Object value : (Collection)source) {
                target.add(this.deepCloneWithVelocityEval(value, operationName, templateContext));
            }
            return target;
        }
        Method cloneMethod = null;
        try {
            cloneMethod = Reflection.findMethod(source, "clone");
        }
        catch (NoSuchMethodException i) {
            // empty catch block
        }
        if (cloneMethod != null) {
            return this.doVelocityEval(cloneMethod.invoke(source, null), operationName, templateContext);
        }
        Class[] paramTypes = new Class[]{source.getClass()};
        Constructor<?> copyConstructor = null;
        try {
            copyConstructor = source.getClass().getConstructor(paramTypes);
        }
        catch (NoSuchMethodException value) {
            // empty catch block
        }
        if (copyConstructor != null) {
            Object[] params = new Object[]{source};
            return this.doVelocityEval(copyConstructor.newInstance(params), operationName, templateContext);
        }
        return this.doVelocityEval(source, operationName, templateContext);
    }

    protected Object doVelocityEval(Object o, String operationName, Map contextMap) throws Exception {
        if (!(o instanceof String)) {
            return o;
        }
        Object val = Velocity.evaluate((String)o, contextMap, operationName, this, false, false, null);
        if (val instanceof String) {
            return ((String)val).trim();
        }
        return val;
    }

    protected void initialized() throws Exception {
    }

    public static DataSource fromXML(Element elem) throws Exception {
        return DataSource.fromXML(elem, null);
    }

    public static DataSource fromXML(Element elem, DSRequest dsRequest) throws Exception {
        return DataSource.fromConfig((Map)XML.toDSRecords(elem), dsRequest);
    }

    public static DataSource fromXML(Document doc) throws Exception {
        return DataSource.fromXML(doc.getDocumentElement());
    }

    public static DataSource fromXML(Document doc, DSRequest dsRequest) throws Exception {
        return DataSource.fromXML(doc.getDocumentElement(), dsRequest);
    }

    public static DataSource fromXML(String xml) throws Exception {
        return DataSource.fromXML(new StringReader(xml));
    }

    public static DataSource fromXML(String xml, DSRequest dsRequest) throws Exception {
        return DataSource.fromXML(new StringReader(xml), dsRequest);
    }

    public static DataSource fromXML(Reader reader) throws Exception {
        return DataSource.fromXML(reader, null);
    }

    public static DataSource fromXML(Reader reader, DSRequest dsRequest) throws Exception {
        return DataSource.fromConfig((Map)XML.toDSRecords(reader), dsRequest);
    }

    public static Map getBuiltinType(String typeID) {
        if (typeID == null) {
            return null;
        }
        return (Map)builtinTypes.get(typeID);
    }

    public boolean isStale() {
        if (this.configTimestamp == -1L) {
            return false;
        }
        try {
            ISCFile configFile = ISCFile.newInstance(this.dsConfigFile);
            return configFile.lastModified() != this.configTimestamp;
        }
        catch (IOException ex) {
            log.warn("isStale caught exception: " + ex.toString());
            return true;
        }
    }

    public String getID() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.dsName;
    }

    public String getTableName() {
        return (String)this.dsConfig.get("tableName");
    }

    public boolean broadcastUpdates() {
        return this.dsConfig.get("broadcastUpdates") != null && (Boolean)this.dsConfig.get("broadcastUpdates") != false;
    }

    public String getConfigFilename() {
        return this.dsConfigFile;
    }

    public Map getServerObjectConfig() {
        return (Map)this.dsConfig.get("serverObject");
    }

    public DataTypeMap getGlobalServerConfig(DSRequest dsRequest) throws Exception {
        if (this.globalServerConfig != null) {
            return this.globalServerConfig;
        }
        this.globalServerConfig = this.dsConfig.getMap("serverConfig");
        if (this.globalServerConfig != null) {
            this.globalServerConfig = (DataTypeMap)((Object)this.deepCloneWithVelocityEval((Object)this.globalServerConfig, "serverConfig", Velocity.getStandardContextMap(dsRequest)));
        }
        return this.globalServerConfig;
    }

    public DataTypeMap getServerConfig(DSRequest dsRequest) throws Exception {
        String operationType = dsRequest.getOperationType();
        String operationId = dsRequest.getOperationId();
        DataTypeMap opBindingServerConfig = this.serverConfigByOperationId.getMap(operationId);
        if (opBindingServerConfig != null) {
            return opBindingServerConfig;
        }
        DataTypeMap opBinding = this.getOperationBinding(operationType, operationId);
        DataTypeMap globalServerConfig = this.getGlobalServerConfig(dsRequest);
        if (opBinding == null) {
            return globalServerConfig;
        }
        opBindingServerConfig = opBinding.getMap("serverConfig");
        if (opBindingServerConfig == null) {
            return globalServerConfig;
        }
        if (globalServerConfig != null) {
            opBindingServerConfig = (DataTypeMap)((Object)DataTools.deepMerge((Object)opBindingServerConfig, DataTools.deepClone((Object)globalServerConfig), true));
        }
        opBindingServerConfig = (DataTypeMap)((Object)this.deepCloneWithVelocityEval((Object)opBindingServerConfig, "serverConfig operationType=" + operationType + ", operationId=" + operationId, Velocity.getStandardContextMap(dsRequest)));
        this.serverConfigByOperationId.put(operationId, opBindingServerConfig);
        return opBindingServerConfig;
    }

    public String getConfigName() {
        return "";
    }

    public List getOperationBindings() {
        return DataSource.getOperationBindings(this.dsConfig);
    }

    public static List getOperationBindings(Map dsConfig) {
        return (List)dsConfig.get("operationBindings");
    }

    public String getAutoOperationId(String operationType) {
        return this.getName() + "_" + operationType;
    }

    public DataTypeMap getOperationBinding(DSRequest req) {
        return this.getOperationBinding(req.getOperationType(), req.getOperationId());
    }

    public DataTypeMap getOperationBinding(String operationType) {
        return this.getOperationBinding(operationType, this.getAutoOperationId(operationType));
    }

    public DataTypeMap getOperationBinding(String operationType, String operationId) {
        List operationBindings = this.getOperationBindings();
        if (operationBindings == null) {
            return null;
        }
        boolean operationIdIsAuto = operationId != null && operationId.equals(this.getAutoOperationId(operationType));
        DataTypeMap autoOperationBinding = null;
        Iterator i = operationBindings.iterator();
        while (i.hasNext()) {
            DataTypeMap operationBinding = new DataTypeMap((Map)i.next());
            if (!operationType.equals((String)operationBinding.get("operationType"))) continue;
            String bindingOperationId = (String)operationBinding.get("operationId");
            if (operationId != null && operationId.equals(bindingOperationId)) {
                return operationBinding;
            }
            if (bindingOperationId != null) continue;
            autoOperationBinding = operationBinding;
        }
        if (autoOperationBinding != null) {
            return autoOperationBinding;
        }
        return null;
    }

    public boolean dropExtraFieldsDefined() {
        return this.dsConfig.get("dropExtraFields") != null;
    }

    public boolean dropExtraFields() {
        Boolean dropExtraFields = (Boolean)this.dsConfig.get("dropExtraFields");
        return dropExtraFields == null || dropExtraFields != false;
    }

    public String getTestFileName() throws Exception {
        String testFilePath;
        String testFileName = (String)this.dsConfig.get("dbImportFileName");
        if (testFileName == null) {
            testFileName = (String)this.dsConfig.get("testFileName");
        }
        if (testFileName == null) {
            testFileName = this.dsName + ".data";
        }
        if ((testFilePath = testFileName).indexOf("/") == -1) {
            String sourceDataSourceID = (String)this.dsConfig.get("sourceDataSourceID");
            if (sourceDataSourceID != null) {
                DataSource sourceDataSource = DataSourceManager.getDataSource(sourceDataSourceID, null);
                if (sourceDataSource != null) {
                    DataSource testDataFileSource;
                    String testDataFileSourceName = sourceDataSource.getConfig().getString("testDataFileSource");
                    if (testDataFileSourceName == null) {
                        testDataFileSourceName = sourceDataSourceID + "_testData";
                    }
                    if ((testDataFileSource = DataSourceManager.getDataSource(testDataFileSourceName, null)) != null) {
                        testFilePath = "ds://" + testDataFileSourceName + "/" + testFileName;
                        if ((testFilePath = this.tryExtension(testFilePath, ".xml")) != null) {
                            return testFilePath;
                        }
                    }
                    testFilePath = "ds://" + sourceDataSourceID + "/test_data/" + testFileName + ".xml";
                    if ((testFilePath = this.tryExtension(testFilePath, ".xml")) != null) {
                        return testFilePath;
                    }
                }
                return null;
            }
            testFilePath = DataStructCache.getInstanceDir(this.getName(), "datasources", "ds") + "/test_data/" + testFileName;
        } else {
            testFilePath = Config.getGlobal().get("webRoot") + testFileName;
        }
        String finalPath = this.tryExtension(testFilePath, ".xml");
        if (finalPath == null) {
            finalPath = this.tryExtension(testFilePath, ".csv");
        }
        if (finalPath == null) {
            finalPath = this.tryExtension(testFilePath, ".js");
        }
        if (finalPath == null) {
            log.info("No test data file for datasource '" + this.getName() + ".  Tried " + testFilePath + " with extensions .xml, .csv and .js");
        }
        return finalPath;
    }

    private String tryExtension(String baseName, String extension) throws Exception {
        String fullName = baseName.endsWith(extension) ? baseName : baseName + extension;
        log.debug("Look for test file at path " + fullName);
        ISCFile iscFile = ISCFile.newInstance(fullName);
        if (iscFile.exists()) {
            return iscFile.getCanonicalPath();
        }
        return null;
    }

    public static boolean simpleTypeInheritsFromBuiltInType(String typeId, String parentTypeId) {
        if (typeId == null) {
            return false;
        }
        if (parentTypeId.equals(typeId)) {
            return true;
        }
        Map typeDef = DataSource.getBuiltinType(typeId);
        while (typeDef != null) {
            typeId = (String)typeDef.get("inheritsFrom");
            if (parentTypeId.equals(typeId)) {
                return true;
            }
            typeDef = DataSource.getBuiltinType(typeId);
        }
        return false;
    }

    protected Map getSimpleTypeDef(String typeId) {
        Map typeDef = DataSource.getBuiltinType(typeId);
        if (typeDef != null) {
            return typeDef;
        }
        typeDef = this.getLocalType(typeId);
        if (typeDef != null && typeDef.get("fields") == null) {
            return typeDef;
        }
        return null;
    }

    public String getSimpleBaseType(String typeId) {
        Map typeDef = this.getSimpleTypeDef(typeId);
        while (typeDef != null) {
            String parentTypeId = (String)typeDef.get("inheritsFrom");
            if (parentTypeId == null) {
                return typeId;
            }
            Map parentTypeDef = this.getSimpleTypeDef(parentTypeId);
            if (parentTypeDef == null) {
                log.warn("type: " + typeId + " declares inheritsFrom: " + parentTypeId + " but parentTypeId could not be found");
                return typeId;
            }
            typeId = parentTypeId;
            typeDef = parentTypeDef;
        }
        return null;
    }

    public boolean simpleTypeInheritsFrom(String typeId, String parentTypeId) throws Exception {
        if (typeId == null) {
            return false;
        }
        if (parentTypeId.equals(typeId)) {
            return true;
        }
        Map typeDef = this.getSimpleTypeDef(typeId);
        while (typeDef != null) {
            typeId = (String)typeDef.get("inheritsFrom");
            if (parentTypeId.equals(typeId)) {
                return true;
            }
            typeDef = this.getSimpleTypeDef(typeId);
        }
        return false;
    }

    protected Map getLocalType(String typeID) {
        if (typeID == null) {
            return null;
        }
        Map types = (Map)this.dsConfig.get("types");
        if (types != null && types.get(typeID) != null) {
            return (Map)types.get(typeID);
        }
        if (this.getSuper() != null) {
            return this.getSuper().getLocalType(typeID);
        }
        return null;
    }

    public List<String> getFieldNames() {
        return this.getFieldNames(true);
    }

    public List<String> getFieldNames(boolean dropIgnored) {
        if (!dropIgnored) {
            return this.fieldList;
        }
        ArrayList<String> fieldNames = new ArrayList<String>(this.fieldList);
        Iterator i = fieldNames.iterator();
        while (i.hasNext()) {
            DSField field = this.getField((String)i.next());
            if (!field.ignore()) continue;
            i.remove();
        }
        return fieldNames;
    }

    public List<DSField> getFields() {
        return this.getFields(true);
    }

    public List<DSField> getFields(boolean dropIgnored) {
        List<String> fieldNames = this.getFieldNames(dropIgnored);
        if (fieldNames == null) {
            return null;
        }
        ArrayList<DSField> fields = new ArrayList<DSField>();
        for (String fieldName : fieldNames) {
            fields.add(this.getField(fieldName));
        }
        return fields;
    }

    protected void trimCriteria(DSRequest request) {
        String opType = request.getOperationType();
        if (!request.getAllowMultiUpdate() && (DataSource.isRemove(opType) || DataSource.isUpdate(opType) || "replace".equals(opType))) {
            Map criteria = request.getCriteria();
            List<String> pkList = this.getPrimaryKeys();
            if (request.getIsAdvancedCriteria()) {
                if ((criteria = this._trimCriteria(criteria, pkList)) != null) {
                    criteria.put("_constructor", "AdvancedCriteria");
                }
                request.setCriteria(criteria);
            } else {
                HashMap newCriteria = new HashMap();
                for (String fieldName : criteria.keySet()) {
                    if (!pkList.contains(fieldName)) continue;
                    newCriteria.put(fieldName, criteria.get(fieldName));
                }
                request.setCriteria(newCriteria);
            }
        }
    }

    private Map _trimCriteria(Map criteria, List pkList) {
        if (criteria == null) {
            return null;
        }
        if (pkList == null) {
            return criteria;
        }
        if (criteria.containsKey("criteria")) {
            ArrayList newCrit = new ArrayList();
            for (Object c : (List)criteria.get("criteria")) {
                if ((c = this._trimCriteria((Map)c, pkList)) == null) continue;
                newCrit.add(c);
            }
            criteria.put("criteria", newCrit);
            return criteria;
        }
        if (criteria.containsKey("fieldName")) {
            String fieldName = (String)criteria.get("fieldName");
            return pkList.contains(fieldName) ? criteria : null;
        }
        return null;
    }

    public List<String> getPrimaryKeys() {
        return new ArrayList<String>();
    }

    public String getPrimaryKey() {
        List<String> pks = this.getPrimaryKeys();
        if (pks == null || pks.size() == 0 || pks.get(0) == null) {
            return null;
        }
        return pks.get(0).toString();
    }

    public DataTypeMap<String, Object> getConfig() {
        return this.dsConfig;
    }

    public int getVersion() {
        return new Integer(this.dsConfig.get("dataSourceVersion").toString());
    }

    public static String getType(Map<String, Object> dsConfig) {
        Object type = dsConfig.get("serverType");
        if (type == null) {
            type = dsConfig.get("type");
        }
        if (type == null) {
            type = dsConfig.get("dataSourceType");
        }
        if (type == null && dsConfig.get("constructor") != null && !"DataSource".equals(dsConfig.get("constructor"))) {
            type = dsConfig.get("constructor");
        }
        if (type == null && dsConfig.get("serviceNamespace") != null) {
            type = "webService";
        }
        if (type == null) {
            type = dsConfig.get("dataFormat");
        }
        if (type == null && dsConfig.get("recordXPath") != null) {
            type = "xml";
        }
        return (String)type;
    }

    public String getType() {
        String type = DataSource.getType(this.dsConfig);
        if (type == null) {
            type = "generic";
        }
        return type;
    }

    public boolean getUseStrictJSON() {
        Object useStrictJSON = this.dsConfig.get("useStrictJSON");
        return useStrictJSON == null ? false : (Boolean)useStrictJSON;
    }

    public boolean inheritsFrom(String dsName) {
        return false;
    }

    public Map getRawFields() {
        return (Map)this.dsConfig.get("fields");
    }

    public void _cloneConfigForSecurityAnnotations() throws Exception {
        this.dsConfigAnnotated = (DataTypeMap)((Object)DataTools.deepClone(this.dsConfig));
    }

    public Map<String, Object> getAnnotatedConfig() {
        return this.dsConfigAnnotated;
    }

    public void clearAnnotatedConfig() {
        this.dsConfigAnnotated = null;
    }

    public DSField getField(String fieldName) {
        return null;
    }

    public String getFieldTitle(String fieldName) {
        DSField field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        return field.getTitle();
    }

    public Map getValueMaps() {
        return this.getValueMaps(this.getFieldNames());
    }

    public Map getValueMaps(List fieldNames) {
        HashMap valueMaps = new HashMap();
        if (fieldNames == null || fieldNames.size() == 0) {
            return valueMaps;
        }
        for (String fieldName : fieldNames) {
            Object valueMap;
            DSField field = this.getField(fieldName);
            if (field == null || (valueMap = field.get("valueMap")) == null || !(valueMap instanceof Map)) continue;
            valueMaps.put(fieldName, valueMap);
        }
        return valueMaps;
    }

    public String getRecordXPath() {
        return (String)this.dsConfig.get("recordXPath");
    }

    public boolean isAdvancedCriteria(Map criteria) {
        if (criteria == null) {
            return false;
        }
        String constructor = (String)criteria.get("_constructor");
        if ("AdvancedCriteria".equals(constructor)) {
            return true;
        }
        String fieldName = (String)criteria.get("fieldName");
        String operator = (String)criteria.get("operator");
        return this.getField("fieldName") == null && this.getField("operator") == null && this.getField(fieldName) != null && operator != null;
    }

    public Map normalizeAdvancedCriteria(Map criteria) throws Exception {
        return this.normalizeAdvancedCriteria(criteria, false);
    }

    public Map normalizeAdvancedCriteria(Map criteria, boolean subLevel) throws Exception {
        String[] canNormalizeArray = new String[]{"equals", "iEquals", "notEqual", "iNotEqual", "startsWith", "iStartsWith", "notStartsWith", "iNotStartsWith", "endsWith", "iEndsWith", "notEndsWith", "iNotEndsWith", "contains", "iContains", "notContains", "iNotContains", "equalsField", "notEqualField", "containsField", "startsWithField", "endsWithField"};
        List<String> canNormalize = Arrays.asList(canNormalizeArray);
        String[] negatedArray = new String[]{"notEqual", "iNotEqual", "notStartsWith", "iNotStartsWith", "notEndsWith", "iNotEndsWith", "notContains", "iNotContains", "notEqualField"};
        List<String> negated = Arrays.asList(negatedArray);
        if (criteria == null || !subLevel && !this.isAdvancedCriteria(criteria)) {
            return criteria;
        }
        Map<String, String> norm = new HashMap<String, String>();
        if (!subLevel) {
            norm.put("_constructor", "AdvancedCriteria");
            if (criteria.get("strictSQLFiltering") != null) {
                norm.put("strictSQLFiltering", (String)criteria.get("strictSQLFiltering"));
            }
        }
        if (criteria.containsKey("criteria")) {
            norm.put("operator", (String)criteria.get("operator"));
            ArrayList<Map> normSubCrit = new ArrayList<Map>();
            if (!(criteria.get("criteria") instanceof List)) {
                throw new Exception("Invalid AdvancedCriteria structure - expected a List");
            }
            for (Object subObj : (List)criteria.get("criteria")) {
                if (!(subObj instanceof Map)) {
                    throw new Exception("Invalid AdvancedCriteria structure - expected a Map");
                }
                normSubCrit.add(this.normalizeAdvancedCriteria((Map)subObj, true));
            }
            norm.put("criteria", (String)((Object)normSubCrit));
        } else if (canNormalize.contains(criteria.get("operator"))) {
            String operator = (String)criteria.get("operator");
            if (criteria.get("value") instanceof List) {
                Iterator i = ((List)criteria.get("value")).iterator();
                if (i.hasNext()) {
                    ArrayList normSubCrit = new ArrayList();
                    norm.put("operator", negated.contains(operator) ? "and" : "or");
                    while (i.hasNext()) {
                        HashMap<String, Object> normSubCriterion = new HashMap<String, Object>();
                        normSubCriterion.put("fieldName", criteria.get("fieldName"));
                        normSubCriterion.put("operator", operator);
                        normSubCriterion.put("value", i.next());
                        normSubCrit.add(normSubCriterion);
                    }
                    norm.put("criteria", (String)((Object)normSubCrit));
                } else {
                    norm.put("operator", operator);
                    norm.put("fieldName", (String)criteria.get("fieldName"));
                    norm.put("value", null);
                }
            } else {
                norm = criteria;
            }
        } else {
            norm = criteria;
        }
        return norm;
    }

    public boolean allowAdvancedCriteria() {
        Object obj = this.dsConfig.get("allowAdvancedCriteria");
        return DataTools.asBoolean(obj, this.getDefaultAllowAdvancedCriteria());
    }

    protected boolean getDefaultAllowAdvancedCriteria() {
        return true;
    }

    public List extractFieldNamesFromAdvancedCriteria(Map advancedCriteria) {
        ArrayList fieldNames = new ArrayList();
        ArrayList<Map> criteria = (ArrayList<Map>)advancedCriteria.get("criteria");
        if (criteria == null) {
            criteria = new ArrayList<Map>();
            criteria.add(advancedCriteria);
        }
        return this.extractFieldNamesRecursively(criteria, fieldNames);
    }

    public List extractFieldNamesRecursively(List criteria, List fieldNames) {
        for (Map criterion : criteria) {
            String fieldName;
            if (criterion.containsKey("criteria")) {
                this.extractFieldNamesRecursively((List)criterion.get("criteria"), fieldNames);
                continue;
            }
            if (!criterion.containsKey("fieldName") || fieldNames.contains(fieldName = (String)criterion.get("fieldName"))) continue;
            fieldNames.add(fieldName);
        }
        return fieldNames;
    }

    public Map extractValuesFromAdvancedCriteria(Map advancedCriteria) {
        HashMap values = new HashMap();
        ArrayList<Map> criteria = (ArrayList<Map>)advancedCriteria.get("criteria");
        if (criteria == null) {
            criteria = new ArrayList<Map>();
            criteria.add(advancedCriteria);
        }
        return this.extractValuesRecursively(criteria, values);
    }

    public Map extractValuesRecursively(List criteria, Map values) {
        for (Map criterion : criteria) {
            if (criterion.containsKey("criteria")) {
                this.extractValuesRecursively((List)criterion.get("criteria"), values);
                continue;
            }
            if (!criterion.containsKey("fieldName")) continue;
            String fieldName = (String)criterion.get("fieldName");
            Object value = criterion.get("value");
            if (values.containsKey(fieldName)) continue;
            values.put(fieldName, value);
        }
        return values;
    }

    public static DataSource getElementType(Element element, ValidationContext context) throws Exception {
        if (element == null) {
            return null;
        }
        String tagName = element.getTagName();
        String constructor = element.getAttribute("constructor");
        BasicDataSource ds = context.getType(constructor);
        if (ds != null) {
            return ds;
        }
        ds = context.getType(tagName);
        return ds;
    }

    public static Object recordsFromXML(Object data) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = DataSource.recordsFromXML(data, vc);
            return object;
        }
        finally {
            vc.freeResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object recordsFromXML(Object data, ValidationContext context) throws Exception {
        if (data instanceof List) {
            return DataSource.recordsFromXML((List)data, context);
        }
        if (!(data instanceof Element)) {
            return data;
        }
        Element element = (Element)data;
        DataSource ds = DataSource.getElementType(element, context);
        if (ds == null) {
            if ("true".equals(element.getAttribute("xsi:nil"))) {
                return null;
            }
            if (element.hasAttributes() || !XML.getElementChildren(element).isEmpty()) {
                ds = context.getType("Object");
            } else {
                return XML.toSimpleValue(element);
            }
        }
        ArrayList<Object> result = ds.toRecords(element, context);
        if ("DataSource".equals(ds.getName())) {
            String loadID = (String)((Map)((Object)result)).get("loadID");
            Boolean loadParents = (Boolean)((Map)((Object)result)).get("loadParents");
            if (loadParents == null) {
                loadParents = false;
            }
            if (loadID != null) {
                HashMap<String, DataSource> processed = new HashMap<String, DataSource>();
                try {
                    DataSource refDS = DataSourceManager.getDataSource(loadID, context.getDSRequest());
                    if (refDS == null) {
                        throw new Exception("Unable to load DataSource referenced by loadID: " + loadID);
                    }
                    processed.put(loadID, refDS);
                    result = refDS.getConfig();
                    if (loadParents.booleanValue()) {
                        String inheritsFrom = refDS.getConfig().getString("inheritsFrom");
                        if (inheritsFrom != null) {
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.add(result);
                            result = list;
                        }
                        while (inheritsFrom != null) {
                            DataSource parentDS = null;
                            if (!processed.containsKey(inheritsFrom)) {
                                parentDS = DataSourceManager.getDataSource(inheritsFrom, null);
                                if (parentDS == null) {
                                    throw new Exception("Unable to load DataSource for ID '" + DataTools.escapeHTML(inheritsFrom) + "' when loading parent DataSources for DataSource '" + DataTools.escapeHTML(loadID) + "'");
                                }
                                processed.put(inheritsFrom, parentDS);
                                ((List)result).add(parentDS.getConfig());
                            } else {
                                parentDS = (DataSource)processed.get(inheritsFrom);
                            }
                            inheritsFrom = parentDS.getConfig().getString("inheritsFrom");
                        }
                    }
                }
                finally {
                    Iterator dsIter = processed.keySet().iterator();
                    while (dsIter.hasNext()) {
                        DataSourceManager.free((DataSource)processed.get(dsIter.next()));
                    }
                }
            }
        }
        if (context.hasErrors()) {
            Logger.validation.warning("Validation errors validating a '" + ds.getName() + "':\n" + DataTools.prettyPrint(context.getErrors()));
        }
        return result;
    }

    public static Object recordsFromXML(List elements) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = DataSource.recordsFromXML(elements, vc);
            return object;
        }
        finally {
            vc.freeResources();
        }
    }

    public static Object recordsFromXML(List elements, ValidationContext context) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator e = elements.iterator();
        while (e.hasNext()) {
            values.add(DataSource.recordsFromXML(e.next(), context));
        }
        return values;
    }

    @Override
    public Object create(Object data, ValidationContext context) throws Exception {
        return this.toRecords(data, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toRecords(Object data) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = this.toRecords(data, vc);
            return object;
        }
        finally {
            vc.freeResources();
        }
    }

    public Object toRecords(Object data, ValidationContext context) throws Exception {
        throw new Exception("This DataSource does not support validation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toRecord(Object data) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = this.toRecord(data, vc);
            return object;
        }
        finally {
            vc.freeResources();
        }
    }

    public Object toRecord(Object data, ValidationContext context) throws Exception {
        throw new Exception("This DataSource does not support validation");
    }

    public void ds2Schema(DataSource ds, Writer out) throws Exception {
        out.write("<?xml version='1.0' encoding='UTF-8'?>\n");
        out.write("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n");
        out.write("<xs:element name='" + ds.getName() + "'>");
        out.write("<xs:complexType>");
        out.write("<xs:any processContents='lax'>");
        List<String> fields = ds.getFieldNames();
        for (String fieldName : fields) {
            String xmlType = ds.getField(fieldName).getType();
            out.write("<xs:attribute name='" + fieldName + "' type='" + xmlType + "'>");
        }
        out.write("<xs:anyAttribute processContents='lax'>");
        out.write("</xs:complexType>");
        out.write("</xs:element>");
        out.write("</xs:schema>");
    }

    public static boolean isModificationOperation(String operationType) {
        return DataSource.isAdd(operationType) || DataSource.isRemove(operationType) || DataSource.isUpdate(operationType) || "replace".equals(operationType);
    }

    public boolean isModificationOperation(String opType, String opId) {
        if (DataSource.isModificationOperation(opType)) {
            return true;
        }
        DataTypeMap opBinding = this.getOperationBinding(opType, opId);
        return opBinding != null && OP_UPDATE.equals(opBinding.get("sqlType"));
    }

    public boolean isModificationRequest(DSRequest req) {
        return this.isModificationOperation(req.getOperationType(), req.getOperationId());
    }

    public static boolean isFetch(String opType) {
        return OP_FETCH.equals(opType) || "select".equals(opType) || "filter".equals(opType);
    }

    public static boolean isAdd(String opType) {
        return OP_ADD.equals(opType) || "insert".equals(opType);
    }

    public static boolean isRemove(String opType) {
        return OP_REMOVE.equals(opType) || "delete".equals(opType);
    }

    public static boolean isUpdate(String opType) {
        return OP_UPDATE.equals(opType);
    }

    public static boolean isDownload(String opType) {
        return OP_DOWNLOAD_FILE.equals(opType) || OP_VIEW_FILE.equals(opType);
    }

    public static boolean isCustom(String opType) {
        return OP_CUSTOM.equals(opType);
    }

    public static boolean isCrud(String opType) {
        return DataSource.isAdd(opType) || DataSource.isFetch(opType) || DataSource.isUpdate(opType) || DataSource.isRemove(opType);
    }

    public static boolean isAddOrUpdate(String opType) {
        return DataSource.isAdd(opType) || DataSource.isUpdate(opType);
    }

    public static boolean isValidate(String opType) {
        return OP_VALIDATE.equals(opType);
    }

    public static boolean isFileSource(String opType) {
        return OP_FILE_SOURCE.contains(opType);
    }

    public static boolean isFileSourceSubrequest(String opType, String opID) {
        if (DataSource.isFetch(opType)) {
            return OP_GET_FILE.equals(opID) || OP_HAS_FILE.equals(opID) || OP_LIST_FILES.equals(opID) || OP_LIST_FILE_VERSIONS.equals(opID) || OP_GET_FILE_VERSION.equals(opID) || OP_HAS_FILE_VERSION.equals(opID);
        }
        if (DataSource.isAddOrUpdate(opType)) {
            return OP_SAVE_FILE.equals(opID) || OP_RENAME_FILE.equals(opID);
        }
        if (DataSource.isRemove(opType)) {
            return OP_REMOVE_FILE.equals(opID) || OP_RENAME_FILE.equals(opID) || OP_REMOVE_FILE_VERSION.equals(opID);
        }
        return false;
    }

    public void transformMultipleFields(DSRequest req) {
    }

    public void transformMultipleFields(DSResponse res) {
    }

    public DSResponse execute(DSRequest req) throws Exception {
        DSResponse validationFailure;
        req.registerFreeResourcesHandler(this);
        String operationType = req.getOperationType();
        if (!DataSource.isCustom(operationType) && (validationFailure = this.validateDSRequest(req)) != null) {
            return validationFailure;
        }
        req.setRequestStarted(true);
        req.recordTimingData(TIMING_TRANSFORM_MULTIPLE_FIELDS, DSRequest.TimingLogType.START);
        this.transformMultipleFields(req);
        req.recordTimingData(TIMING_TRANSFORM_MULTIPLE_FIELDS, DSRequest.TimingLogType.END);
        DSResponse res = null;
        if (DataSource.isFetch(operationType)) {
            DataSource ds = req.getDataSource();
            try {
                res = this.executeFetch(req);
                String string = res.getDataSource() != null ? res.getDataSource().getName() : "null";
            }
            catch (Exception ex) {
                BasicDataSource bds = (BasicDataSource)ds;
                if (bds.isAutoCreateAuditTableActive()) {
                    if (BasicDataSource.auditGenerator != null) {
                        if (BasicDataSource.auditGenerator.hasMappingFor(this.getID())) {
                            log.warn("There was an issue fetching the data. Trying to auto-generate the underlying audit storage for " + ds.getName());
                            ds.createStorage(false);
                            res = this.executeFetch(req);
                        }
                    }
                }
                if (BasicDataSource.auditGenerator != null) {
                    if (BasicDataSource.auditGenerator.hasMappingFor(this.getID())) {
                        log.warn("There was an error fetching the data. Cannot create underlying audit storage as it is disabled for " + ds.getName() + " DataSource.");
                    }
                }
                throw ex;
            }
            if (res != null) {
                this.transformMultipleFields(res);
            }
        } else if (DataSource.isAdd(operationType)) {
            res = this.executeAdd(req);
            this.transformMultipleFields(res);
            this.makeAuditIfRequired(req, res);
            this.dataChangedNotify(req, res);
        } else if (DataSource.isRemove(operationType)) {
            res = this.executeRemove(req);
            this.transformMultipleFields(res);
            this.makeAuditIfRequired(req, res);
            this.dataChangedNotify(req, res);
        } else if (DataSource.isUpdate(operationType)) {
            res = this.executeUpdate(req);
            this.transformMultipleFields(res);
            this.makeAuditIfRequired(req, res);
            this.dataChangedNotify(req, res);
        } else if (operationType.equals("replace")) {
            res = this.executeReplace(req);
        } else if (operationType.equals(OP_LOAD_SCHEMA)) {
            res = this.executeLoadDS(req);
        } else if (DataSource.isDownload(operationType)) {
            res = this.executeDownload(req);
        } else if (operationType.equals(OP_VALIDATE)) {
            res = new DSResponse(this);
            res.setSuccess();
        } else {
            res = operationType.equals(OP_CLIENT_EXPORT) ? this.executeClientExport(req) : (DataSource.isFileSource(operationType) ? this.executeFileSource(req) : (operationType.equals(OP_STORE_TEST_DATA) ? this.executeStoreTestData(req) : (operationType.equals(OP_GET_TEST_DATA) ? this.executeGetTestData(req) : this.executeCustom(req))));
        }
        return res;
    }

    private DSResponse dataChangedNotify(DSRequest req, DSResponse res) {
        if (!res.statusIsSuccess()) {
            return null;
        }
        try {
            boolean dataChangedNotify = this.dsConfig.getBoolean((Object)"realtimeUpdates", false);
            String notifyDataSource = "DataSourceDataChanged";
            DataTypeMap serverConfig = this.getServerConfig(req);
            if (serverConfig != null) {
                notifyDataSource = serverConfig.getString("dataChangedDataSource", notifyDataSource);
                dataChangedNotify = serverConfig.getBoolean((Object)"dataChangedNotify", dataChangedNotify);
            }
            if (!dataChangedNotify) {
                return null;
            }
            Map data = DataTools.cascadeMaps(req.getValues(), res.getRecord(), new HashMap());
            DataTypeMap notifyRecord = DataTools.buildMap("dataSourceName", req.getDataSourceName(), "operationType", req.getOperationType(), "operationId", req.getOperationId(), "userId", req.getUserId(), "timestamp", req.getCurrentDate(), "data", JSTranslater.instance().toJS(DataTools.makeListIfSingle(data)));
            return new DSRequest(notifyDataSource, OP_ADD).setValues((Object)notifyRecord).execute();
        }
        catch (Exception e) {
            log.error((Object)"Failed to send dataChanged notification", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DSResponse makeAuditIfRequired(DSRequest req, DSResponse res) throws Exception {
        if (res == null || res.statusIsError()) {
            return null;
        }
        BasicDataSource ds = (BasicDataSource)req.getDataSource();
        if (!ds.getConfig().getBoolean((Object)"audit", false)) {
            return null;
        }
        if (req.isAuditSkipped()) {
            log.debug("Skipping auditing process, as was disabled in the request or operationBinding.");
            return res;
        }
        if (res.getAffectedRows() > 1L) {
            log.debug("Skipping auditing process, cause multiple records were affected by request.");
            return res;
        }
        BasicDataSource auditDS = null;
        try {
            auditDS = (BasicDataSource)ds.getAuditDataSource();
            DSRequest audit = new DSRequest();
            Map<String, String> values = new HashMap();
            if (OP_REMOVE.equals(req.getOperationType())) {
                Map oldValues = req.getOldValues();
                if (oldValues != null) {
                    values.putAll(oldValues);
                }
            } else if ("jpa".equals(ds.getType())) {
                log.warn("DataSource is JPA, using getProperties to retrieve values from the response");
                values = ds.getProperties(res.getData());
            } else if (res.getDataMap() != null) {
                values.putAll(res.getDataMap());
            } else {
                log.warn("When saving the audit record, getDataMap() returned null for DataSource " + ds.getID());
            }
            List<String> auditFields = auditDS.getFieldNames();
            String fieldName = ds.getAuditUserFieldName();
            if (auditFields.contains(fieldName)) {
                values.put(fieldName, req.getUserId());
            } else {
                log.warn("When saving audit record, the user field is not defined, ignoring!");
            }
            fieldName = ds.getAuditTypeFieldName();
            if (auditFields.contains(fieldName)) {
                values.put(fieldName, req.getOperationType());
            } else {
                log.warn("When saving audit record, the type field is not defined, ignoring!");
            }
            fieldName = ds.getAuditTimestampFieldName();
            if (auditFields.contains(fieldName)) {
                values.put(fieldName, (String)((Object)new Date()));
            } else {
                log.warn("When saving audit record, the timestamp field is not defined, ignoring!");
            }
            audit.setValues(values);
            audit.setOldValues(req.getOldValues());
            audit.setDataSource(auditDS);
            audit.setOperationType(OP_ADD);
            audit.setRPCManager(req.getRPCManager());
            DSResponse resp = null;
            Exception auditWriteException = null;
            try {
                resp = audit.execute();
            }
            catch (Exception e) {
                auditWriteException = e;
            }
            if (resp == null || resp.statusIsError()) {
                if (!auditDS.canQueryTable() && ds.isAutoCreateAuditTableActive()) {
                    log.warn("Audit table missing, attempting to rebuild");
                    auditDS.createStorage(false);
                    try {
                        resp = audit.execute();
                    }
                    catch (Exception e) {
                        String message = "Unable to write to audit DS: " + auditDS.getID();
                        if (auditWriteException == null) {
                            auditWriteException = new Exception(message);
                        }
                        log.error((Object)message, auditWriteException);
                        throw auditWriteException;
                    }
                }
                if (resp == null || resp.statusIsError()) {
                    String message = "Unable to write to audit DS: " + auditDS.getID();
                    if (auditWriteException == null) {
                        auditWriteException = new Exception(message);
                    }
                    log.error((Object)message, auditWriteException);
                    throw auditWriteException;
                }
            }
            DSResponse dSResponse = resp;
            return dSResponse;
        }
        finally {
            DataSourceManager.free(auditDS);
        }
    }

    public String getAuditTypeFieldName() {
        return AuditDSGenerator.getAuditTypeFieldName(this);
    }

    public String getAuditRevisionFieldName() {
        return AuditDSGenerator.getAuditRevisionFieldName(this);
    }

    public String getAuditTimestampFieldName() {
        return AuditDSGenerator.getAuditTimestampFieldName(this);
    }

    public String getAuditUserFieldName() {
        return AuditDSGenerator.getAuditUserFieldName(this);
    }

    public Object setProperties(Map properties, Object target) {
        return this.setProperties(properties, target, null, true);
    }

    public Object setProperties(Map properties, Object target, DSRequest dsRequest) {
        return this.setProperties(properties, target, dsRequest, true);
    }

    public Object setProperties(Map properties, Object target, DSRequest dsRequest, boolean clearContext) {
        if (properties == null) {
            properties = new HashMap();
        }
        JXPathContext context = null;
        HashMap tryAsBean = null;
        HashMap adaptedProperties = new HashMap();
        for (String fieldName : properties.keySet()) {
            RelationFieldInfo relationFieldInfo;
            DSField field = this.getField(fieldName);
            if (field == null) continue;
            Object value = properties.get(fieldName);
            if (this.handlesRelations() && this.relationFields != null && (relationFieldInfo = this.relationFields.get(fieldName)) != null) {
                try {
                    this.setRelationFieldValue(relationFieldInfo, target, value);
                }
                catch (Exception e) {
                    log.warn("Couldn't set property '" + fieldName + "' for datasource '" + this.getName() + "'. Actual error: " + (log.isDebugEnabled() ? DataTools.getStackTrace(e) : e.toString()));
                }
                continue;
            }
            String valueXPath = field.getValueWriteXPath();
            String string = valueXPath = valueXPath != null ? valueXPath : field.getValueXPath();
            if (valueXPath == null) {
                if (tryAsBean == null) {
                    tryAsBean = new HashMap();
                }
                if (value instanceof Collection || value instanceof Map) {
                    try {
                        PropertyDescriptor pd = null;
                        try {
                            pd = new PropertyDescriptor(fieldName, target.getClass());
                        }
                        catch (IntrospectionException introspectionException) {
                            // empty catch block
                        }
                        if (pd != null) {
                            value = this.adaptValue(pd, field, value, dsRequest);
                            adaptedProperties.put(fieldName, value);
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception trying to adapt collection/map: " + fieldName + " for datasource: " + this.getName() + ".  Actual error: " + e.toString());
                    }
                }
                tryAsBean.put(fieldName, value);
                continue;
            }
            if (context == null) {
                context = JXPathContext.newContext((Object)target);
                context.setFactory((AbstractFactory)JXPathContextObjectFactory.getInstance());
            }
            if (valueXPath.contains("/")) {
                try {
                    context.createPath(valueXPath.substring(0, valueXPath.lastIndexOf("/")));
                }
                catch (Exception e) {
                    log.warn("Exception trying to create path for valueXPath: " + valueXPath + " for datasource: " + this.getName() + ".  Actual error: " + e.toString());
                }
            }
            Object adaptedValue = value;
            try {
                Pointer p = context.getPointer(valueXPath);
                if (p instanceof BeanPropertyPointer) {
                    BeanPropertyPointer bpp = (BeanPropertyPointer)p;
                    Object bean = bpp.getBean();
                    PropertyDescriptor pd = new PropertyDescriptor(bpp.getPropertyName(), bean.getClass());
                    if (pd != null) {
                        adaptedValue = this.adaptValue(pd, field, value, dsRequest);
                    }
                }
            }
            catch (Exception e) {
                log.warn("Exception trying to adapt value for valueXPath: " + valueXPath + " for datasource: " + this.getName() + ".  Actual error: " + e.toString());
            }
            try {
                context.setValue(valueXPath, adaptedValue);
            }
            catch (Exception e) {
                log.warn("Couldn't set value at valueXPath: " + valueXPath + " for datasource: " + this.getName() + " - ignoring.  Actual error: " + e.toString());
            }
        }
        for (Object key : adaptedProperties.keySet()) {
            properties.put(key, adaptedProperties.get(key));
            tryAsBean.put((String)key, adaptedProperties.get(key));
        }
        if (tryAsBean != null) {
            try {
                DataTools.setProperties(tryAsBean, target, this, null, clearContext);
            }
            catch (Exception e) {
                log.warn("Exception trying to set properties for datasource: " + this.getName() + " from: " + tryAsBean + " to: " + target + ". Actual error: " + e.toString());
                e.printStackTrace();
            }
        }
        return target;
    }

    private Object adaptValue(PropertyDescriptor pd, DSField field, Object value, DSRequest dsRequest) throws Exception {
        Class javaClass = null;
        Class javaCollectionClass = null;
        Class javaKeyClass = null;
        try {
            javaClass = this._getPropertyJavaClass(field.getName(), field, value);
            String typeName = field.getProperty("javaCollectionClass");
            if (typeName != null) {
                javaCollectionClass = Reflection.classForName(typeName);
            }
            if ((typeName = field.getProperty("javaKeyClass")) != null) {
                javaKeyClass = Reflection.classForName(typeName);
            }
        }
        catch (Exception e) {
            log.warn(e.getClass().getName() + " " + e.getMessage() + " encountered whilst trying to derive Java classes from override class names for DataSource '" + this.getName() + "', field name '" + field.getName() + "'");
        }
        Method method = pd.getWriteMethod();
        Class<?>[] argTypes = method.getParameterTypes();
        List genericInfo = VersionSafeChecker.getGenericParameterTypes(method);
        VersionSafeChecker.GenericParameterNode targetGenericInfo = null;
        if (genericInfo != null && genericInfo.size() > 0) {
            targetGenericInfo = (VersionSafeChecker.GenericParameterNode)genericInfo.get(0);
        }
        if (targetGenericInfo != null && targetGenericInfo.getClassByIndex(0) == argTypes[0]) {
            targetGenericInfo = targetGenericInfo.getChildNode();
        }
        ReflectionArgument reflectionArg = new ReflectionArgument(value.getClass(), value, true, true);
        if (argTypes.length > 0) {
            String fieldType = field.getType();
            DataSource subDataSource = fieldType == null ? null : DataSourceManager.get(fieldType, dsRequest);
            value = Reflection.adaptValue(argTypes[0], targetGenericInfo, reflectionArg, null, subDataSource, javaClass, javaCollectionClass, javaKeyClass, dsRequest);
        }
        return value;
    }

    public List getListProperties(List list) {
        return this.getListProperties(list, true, true);
    }

    public List getListProperties(List list, boolean dropExtraFields, boolean dropIgnoredFields) {
        ArrayList<Map> rtn = new ArrayList<Map>();
        ValidationContext vc = new ValidationContext();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            rtn.add(this.getProperties(i.next(), dropExtraFields, dropIgnoredFields, vc));
        }
        vc.freeResources();
        return rtn;
    }

    public Map getProperties(Object obj) {
        return this.getProperties(obj, true, true);
    }

    public Map getProperties(Object obj, boolean dropExtraFields, boolean dropIgnoredFields) {
        return this.getProperties(obj, null, dropExtraFields, dropIgnoredFields);
    }

    public Map getProperties(Object obj, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext) {
        return this.getProperties(obj, null, dropExtraFields, dropIgnoredFields, validationContext);
    }

    public Map getProperties(Object obj, Collection propsToKeep) {
        return this.getProperties(obj, propsToKeep, false, false);
    }

    public Map getProperties(Object obj, Collection propsToKeep, ValidationContext validationContext) {
        return this.getProperties(obj, propsToKeep, false, false, validationContext);
    }

    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields) {
        return this.getProperties(obj, propsToKeep, dropExtraFields, dropIgnoredFields, null);
    }

    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext) {
        return this.getProperties(obj, propsToKeep, dropExtraFields, dropIgnoredFields, validationContext, null);
    }

    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList) {
        return this.getProperties(obj, propsToKeep, dropExtraFields, dropIgnoredFields, validationContext, recursedList, null);
    }

    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList, Collection propsToDrop) {
        return this.getProperties(obj, propsToKeep, dropExtraFields, dropIgnoredFields, validationContext, recursedList, propsToDrop, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Map getProperties(Object obj, Collection propsToKeep, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList, Collection propsToDrop, boolean omitNullMapValues) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof DataSourcePropertiesMap) {
            return (DataSourcePropertiesMap)obj;
        }
        if (DataTools.containsByReference(recursedList = recursedList == null ? new ArrayList<Object>() : new ArrayList<E>(recursedList), obj)) {
            DataSource.log.warn(obj.getClass().getName() + " contains a (potentially indirect) looping reference to itself.  Returning null for recursed value.");
            return null;
        }
        recursedList.add(obj);
        context = null;
        tryAsBean = null;
        ignoredFields = new HashMap<String, String>();
        hadRelation = null;
        hadXPath = null;
        result = new DataSourcePropertiesMap();
        recordIsPlainMap = false;
        if (validationContext != null && validationContext.dsRequest != null && obj instanceof Map) {
            recordIsPlainMap = validationContext.dsRequest.isSummary();
            if (!recordIsPlainMap) {
                v0 = recordIsPlainMap = validationContext.dsRequest.getConsolidatedOutputs() != null && validationContext.dsRequest.getConsolidatedOutputs().size() > 0;
            }
            if (!recordIsPlainMap) {
                recordIsPlainMap = validationContext.dsRequest.getSummaryFunctionFields() != null && validationContext.dsRequest.getSummaryFunctionFields().size() > 0;
            }
        }
        fieldNames = this.getFieldNames(false);
        for (String fieldName : fieldNames) {
            if (propsToKeep != null && !propsToKeep.contains(fieldName) || propsToDrop != null && propsToDrop.contains(fieldName)) continue;
            field = this.getField(fieldName);
            if (dropIgnoredFields && field.getBoolean("ignore")) {
                ignoredFields.put(fieldName, "ignore");
                continue;
            }
            if (dropExtraFields && field.getBoolean("unknownType", false) && !(fields = (Map)this.dsConfig.get("fields")).containsKey(fieldName)) continue;
            if (this.handlesRelations() && this.relationFields != null && !recordIsPlainMap && (!(obj instanceof Map) || obj instanceof ISCMapBean) && (relationFieldInfo = this.relationFields.get(fieldName)) != null) {
                try {
                    result.put(fieldName, this.getRelationFieldValue(relationFieldInfo, obj, recursedList, validationContext));
                    if (hadRelation == null) {
                        hadRelation = new ArrayList<String>();
                    }
                    hadRelation.add(fieldName);
                }
                catch (Exception e) {
                    DataSource.log.warn("Couldn't get value for property '" + fieldName + "' for datasource '" + this.getName() + "' - ignoring. Actual error: " + (DataSource.log.isDebugEnabled() != false ? DataTools.getStackTrace(e) : e.toString()));
                }
                continue;
            }
            valueXPath = field.getValueXPath();
            if (valueXPath == null || recordIsPlainMap) {
                if (tryAsBean == null) {
                    tryAsBean = new ArrayList<String>();
                }
                tryAsBean.add(fieldName);
                continue;
            }
            if (hadXPath == null) {
                hadXPath = new ArrayList<String>();
            }
            hadXPath.add(fieldName);
            if (context == null) {
                context = JXPathContext.newContext((Object)obj);
            }
            context.setLenient(true);
            JXPathBeanPointer.enableAdditionalValidation();
            try {
                value = null;
                if (field.isMultiple()) {
                    valueList = null;
                    valueIterator = context.iterate(valueXPath);
                    while (valueIterator.hasNext()) {
                        if (valueList == null) {
                            valueList = new ArrayList<E>();
                        }
                        valueList.add(valueIterator.next());
                    }
                    value = valueList;
                } else {
                    value = context.getValue(valueXPath);
                }
                subDS /* !! */  = null;
                subDS /* !! */  = validationContext != null ? validationContext.getType(field.getType()) : DataSourceManager.get(field.getType(), null);
                if (subDS /* !! */  != null) {
                    value = this.getSubValue(subDS /* !! */ , field, value, dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                }
                result.put(fieldName, value);
            }
            catch (Exception e) {
                DataSource.log.warn("Couldn't get value at valueXPath: " + valueXPath + " for datasource: " + this.getName() + " - ignoring.  Actual error: " + e.toString());
            }
            finally {
                JXPathBeanPointer.disableAdditionalValidation();
            }
        }
        if (!dropExtraFields || tryAsBean != null || propsToKeep != null) {
            block79: {
                beanValues = null;
                if (!(obj instanceof Map) || obj instanceof ISCMapBean) {
                    nanos = System.nanoTime();
                    try {
                        if (propsToKeep != null) {
                            if (hadXPath != null) {
                                propsToKeep = new ArrayList<E>(propsToKeep);
                                propsToKeep.removeAll(hadXPath);
                            }
                            if (hadRelation != null) {
                                propsToKeep = new ArrayList<E>(propsToKeep);
                                propsToKeep.removeAll(hadRelation);
                            }
                            beanValues = DataTools.getProperties(obj, propsToKeep);
                            break block79;
                        }
                        if (hadXPath != null && tryAsBean != null) {
                            tryAsBean.removeAll(hadXPath);
                        }
                        if (hadRelation != null && tryAsBean != null) {
                            tryAsBean.removeAll(hadRelation);
                        }
                        if (dropExtraFields) {
                            beanValues = DataTools.getProperties(obj, tryAsBean);
                            break block79;
                        }
                        beanProperties = DataTools.getPropertyDescriptors(obj).keySet();
                        normalizedProperties = new LinkedHashSet<String>();
                        dsFields = this.getFieldNames();
                        for (String prop : beanProperties) {
                            if (dsFields.contains(prop)) {
                                normalizedProperties.add(prop);
                                continue;
                            }
                            foundNormalized = false;
                            for (i = 0; i < dsFields.size(); ++i) {
                                if (!dsFields.get(i).toLowerCase().equals(prop.toLowerCase())) continue;
                                normalizedProperties.add(dsFields.get(i));
                                foundNormalized = true;
                                break;
                            }
                            if (foundNormalized) continue;
                            normalizedProperties.add(prop);
                        }
                        if (ignoredFields != null) {
                            normalizedProperties.removeAll(ignoredFields.keySet());
                        }
                        if (hadXPath != null) {
                            normalizedProperties.removeAll(hadXPath);
                        }
                        if (hadRelation != null) {
                            normalizedProperties.removeAll(hadRelation);
                        }
                        beanValues = DataTools.getProperties(obj, normalizedProperties);
                    }
                    catch (Exception e) {
                        DataSource.log.warn("Couldn't get values: " + tryAsBean.toString() + " for datasource: " + this.getName() + " - ignoring.  Actual error: " + e.toString());
                    }
                } else {
                    beanValues = new HashMap<K, V>();
                }
            }
            nanos = System.nanoTime();
            i = beanValues.keySet().iterator();
            while (i.hasNext()) {
                key = i.next().toString();
                if (propsToDrop != null && propsToDrop.contains(key)) {
                    i.remove();
                    continue;
                }
                field = this.getField(key.toString());
                if (field == null || beanValues.get(key) instanceof IToJSON) continue;
                try {
                    if (validationContext != null) {
                        nanos2 = System.nanoTime();
                        subDS = validationContext.getType(field.getType());
                    } else {
                        subDS = DataSourceManager.get(field.getType(), null);
                    }
                    if (subDS == null) continue;
                    value = this.getSubValue(subDS, field, beanValues.get(key), dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                    beanValues.put(key, value);
                }
                catch (Exception e) {
                    DataSource.log.warn((Object)("Error looking for sub-DataSource " + field.getType() + " in datasource: " + this.getName()), e);
                }
            }
            if (obj instanceof Map) {
                i = null;
                i = propsToKeep != null ? propsToKeep.iterator() : (dropExtraFields != false ? tryAsBean.iterator() : DataTools.mapDisjunction((Map)obj, ignoredFields).keySet().iterator());
                objKeys = ((Map)obj).keySet();
                while (i.hasNext()) {
                    key = i.next();
                    if (propsToDrop != null && propsToDrop.contains(key) || beanValues.get(key) != null) continue;
                    value /* !! */  = ((Map)obj).get(key);
                    field = this.getField(key.toString());
                    if (field != null && !(value /* !! */  instanceof IToJSON)) {
                        try {
                            subDS /* !! */  = validationContext != null ? validationContext.getType(field.getType()) : DataSourceManager.get(field.getType(), null);
                            if (subDS /* !! */  != null) {
                                value /* !! */  = this.getSubValue(subDS /* !! */ , field, value /* !! */ , dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                            }
                        }
                        catch (Exception e) {
                            DataSource.log.warn((Object)("Error looking for sub-DataSource " + field.getType() + " in datasource: " + this.getName()), e);
                        }
                    }
                    if (value /* !! */  == null && (omitNullMapValues || !objKeys.contains(key))) continue;
                    beanValues.put(key, value /* !! */ );
                }
            } else if (DataSource.config.getBoolean((Object)"supportDynamicBeans", false) && tryAsBean != null && dropExtraFields && DataSource.dynamicBeanMarker != null && DataSource.dynamicBeanMarker.isAssignableFrom(obj.getClass())) {
                try {
                    getter = Reflection.findMethod(obj, "get");
                    if (getter == null) ** GOTO lbl216
                    for (String propertyName : tryAsBean) {
                        if (beanValues.get(propertyName) != null) continue;
                        params = new String[]{propertyName};
                        value = getter.invoke(obj, params);
                        field = this.getField(propertyName.toString());
                        if (field != null && !(value instanceof IToJSON)) {
                            try {
                                subDS /* !! */  = validationContext != null ? validationContext.getType(field.getType()) : DataSourceManager.get(field.getType(), null);
                                if (subDS /* !! */  != null) {
                                    value = this.getSubValue(subDS /* !! */ , field, value, dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                                }
                            }
                            catch (Exception e) {
                                DataSource.log.warn((Object)("Error looking for sub-DataSource " + field.getType() + " in datasource: " + this.getName()), e);
                            }
                        }
                        if (value == null) continue;
                        beanValues.put(propertyName, value);
                    }
                }
                catch (Exception e) {
                    if (e instanceof NoSuchMethodException) ** GOTO lbl216
                    DataSource.log.warn("Error trying to mine dynamic bean.  Actual error: " + e.toString());
                }
            }
lbl216:
            // 7 sources

            if (hadXPath != null) {
                for (Object key : hadXPath) {
                    if (!hadXPath.contains(key)) continue;
                    beanValues.remove(key);
                }
            }
            DataTools.putAllNotPresent(result, beanValues);
        }
        for (String fieldName : fieldNames) {
            block80: {
                value /* !! */  = result.get(fieldName);
                if (value /* !! */  != null && value /* !! */  instanceof Date && !(value /* !! */  instanceof ISCDate) && !(value /* !! */  instanceof ISCTime)) {
                    field = this.getField(fieldName);
                    fieldType = null;
                    try {
                        bds_this = (BasicDataSource)this;
                        fieldType = bds_this.getSimpleBaseType(field.getType());
                        if ("date".equals(fieldType) && !bds_this.simpleTypeInheritsFrom(field.getType(), "datetime") && !bds_this.simpleTypeInheritsFrom(field.getType(), "dateTime")) {
                            value /* !! */  = new ISCDate(((Date)value /* !! */ ).getTime());
                            result.put(fieldName, value /* !! */ );
                            break block80;
                        }
                        if (!"time".equals(fieldType)) break block80;
                        value /* !! */  = new ISCTime(((Date)value /* !! */ ).getTime());
                        result.put(fieldName, value /* !! */ );
                    }
                    catch (Exception e) {
                        DataSource.log.warn((Object)("Unable to look up simpleBaseType for field: " + fieldName), e);
                        continue;
                    }
                }
            }
            if (validationContext == null || !validationContext.getEncodeBinaryFields() || (field = this.getField(fieldName)) == null || !field.shouldEncodeInResponse()) continue;
            if (value /* !! */  instanceof File) {
                try {
                    value /* !! */  = new FileInputStream((File)value /* !! */ );
                }
                catch (FileNotFoundException ex) {
                    DataSource.log.warn((Object)("Failed to open file " + ((File)value /* !! */ ).getName() + ". Skipping."), ex);
                    value /* !! */  = null;
                }
            }
            if (value /* !! */  instanceof InputStream) {
                try {
                    encoded = DataTools.base64Encode((InputStream)value /* !! */ );
                    result.put(fieldName, encoded);
                }
                catch (Exception ex) {
                    DataSource.log.warn((Object)"Failed to read from input stream. Skipping.", ex);
                }
                continue;
            }
            if (value /* !! */  instanceof byte[]) {
                encoded = DataTools.base64Encode((byte[])value /* !! */ );
                result.put(fieldName, encoded);
                continue;
            }
            if (!(value /* !! */  instanceof Byte[])) continue;
            work = new byte[((Byte[])value /* !! */ ).length];
            for (j = 0; j < work.length; ++j) {
                work[j] = ((Byte[])value /* !! */ )[j];
            }
            encoded = DataTools.base64Encode(work);
            result.put(fieldName, encoded);
        }
        return result;
    }

    private Object getSubValue(DataSource subDS, DSField field, Object value, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList, boolean omitNullMapValues) {
        long nanos = System.nanoTime();
        dropExtraFields = subDS.dropExtraFields();
        if (value == null) {
            return null;
        }
        if (value instanceof JSONFilter && ((JSONFilter)value).getObj() instanceof Collection) {
            JSONFilter filter = (JSONFilter)value;
            ArrayList<Map> list = new ArrayList<Map>();
            Collection valueCollection = (Collection)filter.getObj();
            for (Object item : valueCollection) {
                IBeanFilter beanFilter = filter.getBeanFilter();
                Map record = subDS.getSubProperties(new JSONFilter(item, beanFilter), dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                list.add(record);
            }
            return list;
        }
        if (value instanceof Collection || field.getBoolean("multiple")) {
            ArrayList<Map> list = new ArrayList<Map>();
            if (value instanceof Collection) {
                Iterator i = ((Collection)value).iterator();
                while (i.hasNext()) {
                    Map record = subDS.getSubProperties(i.next(), dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                    list.add(record);
                }
            } else {
                if (value instanceof Map) {
                    LinkedHashMap map = new LinkedHashMap();
                    for (Object key : ((Map)value).keySet()) {
                        Object mapValue = ((Map)value).get(key);
                        if (this.isSerializable(mapValue)) {
                            map.put(key, mapValue);
                            continue;
                        }
                        Map record = subDS.getSubProperties(mapValue, dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
                        map.put(key, record);
                    }
                    return map;
                }
                list.add(subDS.getSubProperties(value, dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues));
            }
            return list;
        }
        Map result = subDS.getSubProperties(value, dropExtraFields, dropIgnoredFields, validationContext, recursedList, omitNullMapValues);
        return result;
    }

    private Map getSubProperties(Object value, boolean dropExtraFields, boolean dropIgnoredFields, ValidationContext validationContext, List recursedList, boolean omitNullMapValues) {
        long nanos = System.nanoTime();
        Map record = null;
        JSONFilter filter = null;
        IBeanFilter beanFilter = null;
        if (value instanceof JSONFilter) {
            filter = (JSONFilter)value;
            value = filter.getObj();
            beanFilter = filter.getBeanFilter();
        }
        try {
            record = beanFilter instanceof IContextBeanFilterWithNullControl ? ((IContextBeanFilterWithNullControl)beanFilter).filter(value, validationContext, omitNullMapValues) : (beanFilter instanceof IContextBeanFilter ? ((IContextBeanFilter)beanFilter).filter(value, validationContext) : this.getProperties(value, null, dropExtraFields, dropIgnoredFields, validationContext, recursedList, null, omitNullMapValues));
        }
        catch (Exception e) {
            log.warn((Object)"Error trying to get sub-object properties", e);
        }
        return record;
    }

    private boolean isSerializable(Object obj) {
        return obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof Date || VersionSafeChecker.isEnum(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List computeOutputColumns(DSRequest request) {
        String opId;
        ArrayList<String> outputColumns = null;
        if (request == null) {
            return null;
        }
        String opType = request.getOperationType();
        DataTypeMap opBinding = this.getOperationBinding(opType, opId = request.getOperationId());
        if (opBinding != null && opBinding.get("outputs") != null) {
            String outputString = (String)opBinding.get("outputs");
            String[] outputArray = outputString.split(",");
            outputColumns = new ArrayList<String>();
            for (int i = 0; i < outputArray.length; ++i) {
                outputColumns.add(outputArray[i].trim());
            }
        }
        if (request.outputs() != null) {
            if (outputColumns != null) {
                if (!outputColumns.containsAll(request.outputs())) return null;
                outputColumns = request.outputs();
            } else {
                if (!this.getFieldNames().containsAll(request.outputs())) return null;
                outputColumns = request.outputs();
            }
        }
        if (outputColumns == null || !outputColumns.isEmpty()) return outputColumns;
        return null;
    }

    public ErrorReport validate(Map data, boolean reportMissingRequiredFields) throws Exception {
        return this.validate(data, reportMissingRequiredFields, null);
    }

    public ErrorReport validate(Map data, boolean reportMissingRequiredFields, ValidationContext context) throws Exception {
        return this.validate(data, reportMissingRequiredFields, context, false);
    }

    public ErrorReport validate(Map data, boolean reportMissingRequiredFields, ValidationContext context, boolean mergeValidatedValues) throws Exception {
        Map errors;
        boolean localContext = false;
        if (context == null) {
            context = new ValidationContext();
            localContext = true;
        }
        context.setPropertiesOnly(!reportMissingRequiredFields);
        Map validated = (Map)this.toRecords(data, context);
        if (mergeValidatedValues) {
            DataTools.mapMergeNonNull(validated, data);
        }
        if (localContext) {
            context.freeResources();
        }
        if ((errors = context.getErrors()) == null) {
            return null;
        }
        return (ErrorReport)errors.values().toArray()[0];
    }

    @Deprecated
    public ErrorReport validate(Map data, ErrorReport errors) throws Exception {
        return errors;
    }

    public ErrorReport validateRecord(Map data, ErrorReport errors, ValidationContext context) throws Exception {
        return errors;
    }

    public DSResponse validateDSRequest(DSRequest dsRequest) throws Exception {
        if (dsRequest.getValidated()) {
            return null;
        }
        List errors = DataSource.validateDSRequest(this, dsRequest);
        if (errors != null) {
            Logger.validation.info("Validation error: " + DataTools.prettyPrint(errors));
            DSResponse dsResponse = new DSResponse(this);
            dsResponse.setStatus(-4);
            dsResponse.setErrors(errors);
            return dsResponse;
        }
        dsRequest.setValidated(true);
        return null;
    }

    public static List validateDSRequest(DataSource dataSource, DSRequest dsRequest) throws Exception {
        Map errors;
        String operationType = dsRequest.getOperationType();
        if (DataSource.isRemove(operationType) || !DataSource.isModificationOperation(operationType) && !OP_VALIDATE.equals(operationType)) {
            return null;
        }
        ValidationContext context = new ValidationContext();
        if ("partial".equals(dsRequest.getValidationMode())) {
            context.setPropertiesOnly(true);
        }
        context.setRPCManager(dsRequest.getRPCManager());
        context.setRequestContext(dsRequest.getRequestContext());
        if (dsRequest.getOperationType().equals(OP_UPDATE)) {
            context.setPropertiesOnly();
        }
        context.setDSRequest(dsRequest);
        dsRequest.setValidatedValues(dataSource.toRecords(dsRequest.getValueSets(), context));
        context.freeResources();
        if (log.isDebugEnabled()) {
            log.debug("post-validation valueSet: " + DataTools.prettyPrint(dsRequest.getValueSets()));
        }
        if ((errors = context.getErrors()) != null) {
            errors = ErrorReport.toImpliedForm(errors);
            ArrayList<Map> errorList = new ArrayList<Map>();
            errorList.add(errors);
            return errorList;
        }
        return null;
    }

    public Map validateOperationBinding(DSRequest dsRequest, Map operationBinding) throws Exception {
        return operationBinding;
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeAdd(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeReplace(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeDownload(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeCustom(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeClientExport(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeStoreTestData(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeGetTestData(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    public DSResponse executeLoadDS(DSRequest req) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("dsName", this.getName());
        result.put("dsData", JSTranslater.instance().toJS(this.getConfig()));
        DSResponse dsResponse = new DSResponse(this);
        dsResponse.setBypassDataFilter(true);
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        list.add(result);
        dsResponse.setData(list);
        return dsResponse;
    }

    protected DSResponse notSupported(DSRequest req) throws Exception {
        throw new OperationNotSupportedException("Operation type '" + req.getOperationType() + "' not supported by this DataSource (" + this.getName() + ")");
    }

    public boolean usesSCServerProtocol() {
        Object serviceNamespace = this.dsConfig.get("serviceNamespace");
        Object constructor = this.dsConfig.get("constructor");
        Object dataProtocol = this.dsConfig.get("dataProtocol");
        boolean result = serviceNamespace == null && constructor == null && (dataProtocol == null || dataProtocol.equals("iscServer"));
        return result;
    }

    public DSResponse executeFileSource(DSRequest req) throws Exception {
        List clientOutputs;
        Object defaultFormat;
        Object defaultType;
        DSResponse response;
        DSResponse response2;
        String operationType;
        String operationId = operationType = req.getOperationType();
        DSRequest work = null;
        String versionField = this.getFileVersionField();
        if (versionField != null) {
            DSField dsField = this.getField(versionField);
            if (dsField == null) {
                log.warn("DataSource " + this.getName() + " specifies fileVersionField: " + versionField + ", but does not specify a field of that name. Automatic file versioning will be disabled");
                versionField = null;
            } else if (!this.simpleTypeInheritsFrom(dsField.getType(), "datetime")) {
                log.warn("DataSource " + this.getName() + " specifies fileVersionField: " + versionField + ", but that field is not a 'datetime' or subtype. Automatic file versioning will be disabled");
                versionField = null;
            }
        }
        List<String> extensionFields = this.getFileExtensionFields();
        HashMap<String, Object> values = null;
        Map<String, Object> nativeValues = null;
        Map<String, Object> nativeFileSourcePrimaryKeys = null;
        if (OP_LIST_FILES.equals(operationType)) {
            if (!req.getIsAdvancedCriteria()) {
                values = req.getCriteria();
            }
        } else {
            values = req.getValues();
        }
        if (values != null) {
            DataTools.removeNullValuedKeys(values);
            DataTools.removeEmptyStringValuedKeys(values);
            nativeValues = this.getFileSourceNativeValues(values);
            nativeFileSourcePrimaryKeys = this.getFileSourceNativePrimaryKeys(values);
        }
        if (OP_GET_FILE.equals(operationType) || OP_HAS_FILE.equals(operationType)) {
            response2 = this.requireFileSourceField((Map<String, Object>)values, "Field is required", DataTools.makeList(FS_FILE_NAME));
            if (response2 != null) {
                return response2;
            }
            this.warnFileSourceField((Map<String, Object>)values, "not provided for fileSource:" + operationType + " operation", FS_FILE_TYPE, FS_FILE_FORMAT);
            work = new DSRequest(this.getName(), OP_FETCH);
            work.setCriteria(nativeFileSourcePrimaryKeys);
            if (versionField != null) {
                work.setSortBy("-" + versionField);
            }
        } else if (OP_GET_FILE_VERSION.equals(operationType) || OP_HAS_FILE_VERSION.equals(operationType)) {
            if (versionField == null) {
                String msg = "'getFileVersion' API called for DataSource " + this.getName() + " but that DataSource does not specify a fileVersionField property.  Cannot continue.";
                log.warn(msg);
                throw new Exception(msg);
            }
            ArrayList<String> requiredFields = new ArrayList<String>();
            requiredFields.add(FS_FILE_NAME);
            requiredFields.add(versionField);
            response = this.requireFileSourceField((Map<String, Object>)values, "Field is required", requiredFields);
            if (response != null) {
                return response;
            }
            this.warnFileSourceField(values, "not provided for fileSource:" + operationType + " operation", FS_FILE_TYPE, FS_FILE_FORMAT);
            work = new DSRequest(this.getName(), OP_FETCH);
            work.setCriteria(nativeFileSourcePrimaryKeys);
            work.getCriteria().put(versionField, values.get(versionField));
        } else if (OP_LIST_FILES.equals(operationType)) {
            work = new DSRequest(this.getName(), OP_FETCH);
            if (req.getIsAdvancedCriteria()) {
                AdvancedCriteria remappedCriteria;
                AdvancedCriteria criteria = req.getAdvancedCriteria();
                values = new HashMap<String, Object>();
                defaultType = req.getCriteriaValue(FS_FILE_TYPE);
                if (defaultType != null) {
                    values.put(FS_FILE_TYPE, defaultType);
                }
                if ((defaultFormat = req.getCriteriaValue(FS_FILE_FORMAT)) != null) {
                    values.put(FS_FILE_FORMAT, defaultFormat);
                }
                if ((remappedCriteria = CriteriaUtils.remapFields(criteria, this.getFileSourceFieldMapToNative())) != null) {
                    work.setCriteria(remappedCriteria);
                }
            } else {
                work.setCriteria(DataTools.remapRow(values, this.getFileSourceFieldMapToNative(), true));
            }
            if (versionField != null) {
                HashMap<String, SummaryFunctionType> summ = new HashMap<String, SummaryFunctionType>();
                summ.put(versionField, SummaryFunctionType.MAX);
                work.setSummaryFunctions(summ);
                List<String> groupFields = this.getFileSourceNativeKeys(FS_PRIMARY_KEYS);
                Map<String, String> remap = this.getFileSourceFieldMapToNative();
                work.setGroupBy(groupFields);
                List grouped = work.execute().getDataList();
                if (!groupFields.contains(versionField)) {
                    groupFields.add(versionField);
                }
                Criterion[] lc = new LogicalCriterion[grouped.size()];
                for (int i = 0; i < grouped.size(); ++i) {
                    Map record = (Map)grouped.get(i);
                    Criterion[] sc = new SimpleCriterion[groupFields.size()];
                    for (int j = 0; j < sc.length; ++j) {
                        String field = groupFields.get(j);
                        OperatorBase operatorId = field.equals(remap.get(FS_FILE_TYPE)) || field.equals(remap.get(FS_FILE_FORMAT)) ? DefaultOperators.IEquals : DefaultOperators.Equals;
                        sc[j] = new SimpleCriterion(field, operatorId, record.get(field));
                    }
                    lc[i] = new LogicalCriterion(DefaultOperators.And, sc);
                }
                AdvancedCriteria ac = new AdvancedCriteria(DefaultOperators.Or, lc);
                work = new DSRequest(this.getName(), OP_FETCH);
                work.setAdvancedCriteria(ac);
            }
        } else if (OP_LIST_FILE_VERSIONS.equals(operationType)) {
            if (versionField == null) {
                String msg = "'listFileVersions' API called for DataSource " + this.getName() + " but that DataSource does not specify a fileVersionField property.  Cannot continue.";
                log.warn(msg);
                throw new Exception(msg);
            }
            if (values.containsKey(versionField)) {
                values.remove(versionField);
            }
            if ((response2 = this.requireFileSourceField((Map<String, Object>)values, "Field is required", FS_PRIMARY_KEYS)) != null) {
                return response2;
            }
            work = new DSRequest(this.getName(), OP_FETCH);
            work.setCriteria(this.getFileSourceNativeValues(values));
            work.setSortBy("-" + versionField);
        } else {
            DSResponse success;
            Date timestamp = new Date();
            response = this.requireFileSourceField((Map<String, Object>)values, "Field is required", FS_PRIMARY_KEYS);
            if (response != null) {
                return response;
            }
            DSRequest existingFileRequest = new DSRequest(this.getName(), OP_FETCH);
            existingFileRequest.setCriteria(nativeFileSourcePrimaryKeys);
            if (OP_REMOVE_FILE_VERSION.equals(operationType)) {
                existingFileRequest.setOperationId(OP_HAS_FILE_VERSION);
                existingFileRequest.getCriteria().put(versionField, values.get(versionField));
            } else {
                existingFileRequest.setOperationId(OP_HAS_FILE);
            }
            existingFileRequest.setOutputs(this.getPrimaryKeys());
            Map existingFile = existingFileRequest.execute().getDataMap();
            Date replaceVersion = null;
            Map replaceRecord = null;
            if (existingFile != null && versionField != null) {
                DSRequest versionsRequest = new DSRequest(this.getName(), OP_FETCH);
                versionsRequest.setOperationId(OP_LIST_FILE_VERSIONS);
                versionsRequest.setCriteria(nativeFileSourcePrimaryKeys);
                versionsRequest.setOutputs(this.getCustomFileSourceFieldNames(FS_PRIMARY_KEYS));
                versionsRequest.getOutputs().add(versionField);
                versionsRequest.setSortBy(versionField);
                List versions = versionsRequest.execute().getDataList();
                int maxVersions = this.dsConfig.getInt(FS_MAX_FILE_VERSIONS_PROPERTY, 20);
                if (versions.size() >= maxVersions) {
                    replaceRecord = (Map)versions.get(0);
                    replaceVersion = (Date)replaceRecord.get(versionField);
                }
            }
            if (OP_SAVE_FILE.equals(operationType)) {
                DSField lastModifiedField;
                String lastModifiedFieldName;
                if (existingFile == null || versionField != null && replaceVersion == null) {
                    work = new DSRequest(this.getName(), OP_ADD);
                    work.setValues(nativeValues);
                } else {
                    work = versionField != null && this.getPrimaryKeys().contains(versionField) ? new DSRequest(this.getName(), OP_ADD) : new DSRequest(this.getName(), OP_UPDATE);
                    work.setCriteria(existingFile);
                    if (versionField != null && this.getPrimaryKeys().contains(versionField)) {
                        DSRequest removeRequest = new DSRequest(this.getName(), OP_REMOVE);
                        HashMap removeCriteria = new HashMap(replaceRecord);
                        removeRequest.setCriteria(removeCriteria);
                        removeRequest.setOperationId(OP_REMOVE_FILE);
                        removeRequest.setRPCManager(req.getRPCManager());
                        removeRequest.setClientRequest(req.isClientRequest());
                        DSResponse removeResponse = removeRequest.execute();
                        if (removeResponse.statusIsError()) {
                            return removeResponse;
                        }
                        work.setValues(nativeValues);
                    }
                    work.setFieldValue(this.getFileContentsField(), values.get(FS_FILE_CONTENTS));
                }
                for (String fieldName : extensionFields) {
                    work.setFieldValue(fieldName, values.get(fieldName));
                }
                if (versionField != null) {
                    work.setFieldValue(versionField, timestamp);
                }
                if ((lastModifiedFieldName = this.getFileLastModifiedField()) != null && (lastModifiedField = this.getField(lastModifiedFieldName)) != null && !"modifierTimestamp".equals(lastModifiedField.getType())) {
                    work.setFieldValue(lastModifiedFieldName, timestamp);
                }
            } else if (OP_RENAME_FILE.equals(operationType)) {
                List sourceFileList;
                boolean mustRemoveAndAdd;
                if (existingFile != null) {
                    DSResponse error = new DSResponse(this);
                    error.setFailure("destination file already exists");
                    return error;
                }
                Map oldValues = req.getOldValues();
                DSResponse error = this.requireFileSourceField(oldValues, "Field is required in oldValues", FS_PRIMARY_KEYS);
                if (error != null) {
                    return error;
                }
                DSRequest sourceFileRequest = new DSRequest(this.getName(), OP_FETCH);
                Map<String, Object> sourceNativePrimaryKeys = this.getFileSourceNativePrimaryKeys(oldValues);
                sourceFileRequest.setCriteria(sourceNativePrimaryKeys);
                Map updatingPrimaryKeys = DataTools.subsetMap(nativeFileSourcePrimaryKeys, this.getPrimaryKeys());
                boolean bl = mustRemoveAndAdd = updatingPrimaryKeys.size() > 0;
                if (!mustRemoveAndAdd) {
                    sourceFileRequest.setOutputs(this.getPrimaryKeys());
                }
                if ((sourceFileList = sourceFileRequest.execute().getDataList()) == null || sourceFileList.size() == 0) {
                    error = new DSResponse(this);
                    error.setFailure("source file does not exist");
                    return error;
                }
                HashMap sourceFile = new HashMap((Map)sourceFileList.get(0));
                if (mustRemoveAndAdd) {
                    DSRequest removalRequest = new DSRequest(this.getName(), OP_REMOVE);
                    removalRequest.setCriteria(DataTools.subsetMap(sourceFile, this.getPrimaryKeys()));
                    if (versionField != null) {
                        removalRequest.setAllowMultiUpdate(true);
                        removalRequest.getCriteria().remove(versionField);
                    }
                    removalRequest.setOperationId(OP_REMOVE_FILE);
                    removalRequest.inheritClientContext(req);
                    DSResponse removal = removalRequest.execute();
                    if (removal.statusIsError()) {
                        return removal;
                    }
                    work = new DSRequest(this.getName(), OP_ADD);
                    operationId = OP_SAVE_FILE;
                    if (versionField == null) {
                        work.setValues(DataTools.mapUnion(nativeFileSourcePrimaryKeys, sourceFile));
                    } else {
                        ArrayList<Map> remappedList = new ArrayList<Map>();
                        for (int i = 0; i < sourceFileList.size(); ++i) {
                            String lastMod = this.getFileLastModifiedField();
                            if (lastMod != null) {
                                ((Map)sourceFileList.get(i)).put(lastMod, timestamp);
                            }
                            remappedList.add(DataTools.mapUnion(nativeFileSourcePrimaryKeys, (Map)sourceFileList.get(i)));
                        }
                        work.setValues(remappedList);
                    }
                } else {
                    work = new DSRequest(this.getName(), OP_UPDATE);
                    if (versionField == null) {
                        work.setCriteria(sourceFile);
                    } else {
                        work.setAllowMultiUpdate(true);
                        work.setCriteria(sourceNativePrimaryKeys);
                        work.getCriteria().remove(versionField);
                    }
                    work.setValues(nativeFileSourcePrimaryKeys);
                }
            } else if (OP_REMOVE_FILE.equals(operationType)) {
                if (existingFile == null) {
                    success = new DSResponse(this);
                    success.setSuccess();
                    return success;
                }
                work = new DSRequest(this.getName(), OP_REMOVE);
                work.setCriteria(existingFile);
                if (versionField != null) {
                    work.setAllowMultiUpdate(true);
                    work.setCriteria(new HashMap<String, Object>(nativeFileSourcePrimaryKeys));
                    work.getCriteria().remove(versionField);
                }
            } else if (OP_REMOVE_FILE_VERSION.equals(operationType)) {
                if (existingFile == null) {
                    success = new DSResponse(this);
                    success.setSuccess();
                    return success;
                }
                work = new DSRequest(this.getName(), OP_REMOVE);
                work.setCriteria(existingFile);
            }
        }
        if (work == null) {
            throw new OperationNotSupportedException("operationType: '" + operationType + "' is not supported by executeFileSource() for dataSource: '" + this.getName() + "'");
        }
        if (!(OP_GET_FILE.equals(operationType) || OP_GET_FILE_VERSION.equals(operationType) || (clientOutputs = req.getOutputs()) != null && clientOutputs.contains(FS_FILE_CONTENTS))) {
            List<String> fieldNames = this.getFieldNames();
            ArrayList<String> outputs = new ArrayList<String>(fieldNames);
            outputs.remove(this.getFileContentsField());
            work.setOutputs(outputs);
        }
        work.setOperationId(operationId);
        work.inheritClientContext(req);
        if (!work.isAllowMultiUpdateExplicitlySet()) {
            work.setAllowMultiUpdate(req.getAllowMultiUpdate());
        }
        response2 = work.execute();
        if (!work.getOperationType().equals(OP_FETCH)) {
            response2.setInvalidateCache(true);
        }
        try {
            response2.setData(DataTools.remapObject(response2.getDataList(), this.getFileSourceFieldMapFromNative()));
        }
        catch (Exception fieldNames) {
            // empty catch block
        }
        defaultType = null;
        defaultFormat = null;
        if (values != null) {
            if (this.getFileTypeField() == null) {
                defaultType = values.get(FS_FILE_TYPE);
            }
            if (this.getFileFormatField() == null) {
                defaultFormat = values.get(FS_FILE_FORMAT);
            }
        }
        if (defaultType != null || defaultFormat != null) {
            List data = response2.getDataList();
            for (Map record : data) {
                if (defaultType != null) {
                    record.put(FS_FILE_TYPE, defaultType);
                }
                if (defaultFormat == null) continue;
                record.put(FS_FILE_FORMAT, defaultFormat);
            }
            response2.setData(data);
        }
        if ((OP_REMOVE_FILE.equals(operationType) || OP_SAVE_FILE.equals(operationType)) && config.getList("project.datasources", new ArrayList()).contains("ds://" + this.getName())) {
            DataSourceManager.clearAllDataSourceCaches();
        }
        this.convertXmlToJsIfRequested(req, response2);
        return response2;
    }

    protected void convertXmlToJsIfRequested(DSRequest req, DSResponse response) {
        if (response.statusIsError()) {
            return;
        }
        if (OP_ID_XML_TO_JS.equals(req.getOperationId())) {
            List data = response.getDataList();
            for (Map record : data) {
                Object contents = record.get(FS_FILE_CONTENTS);
                if (contents == null || !(contents instanceof String)) continue;
                String xmlString = (String)contents;
                try {
                    String jsString = BuiltinRPC.xmlToJsString(xmlString);
                    record.put(FS_FILE_CONTENTS_AS_JS, jsString);
                }
                catch (Exception ex) {
                    log.warn("Error running xmlToJs on\n" + xmlString + "\nMessage: " + ex.getMessage());
                }
            }
            response.setData(data);
        }
    }

    protected DSResponse requireFileSourceField(Map<String, Object> values, String errorMessage, List<String> fieldNames) {
        LinkedList<String> missingFields = new LinkedList<String>();
        Map<String, String> fileSourceFieldMap = this.getFileSourceFieldMapToNative();
        for (String fieldName : fieldNames) {
            if (fileSourceFieldMap.get(fieldName) == null || values.containsKey(fieldName)) continue;
            missingFields.add(fieldName);
        }
        if (missingFields.size() > 0) {
            DSResponse response = new DSResponse(this);
            for (String fieldName : missingFields) {
                response.addError(fieldName, errorMessage);
            }
            return response;
        }
        return null;
    }

    private List getCustomFileSourceFieldNames(List<String> fieldNames) {
        ArrayList<String> custom = new ArrayList<String>();
        Map<String, String> fileSourceFieldMap = this.getFileSourceFieldMapToNative();
        for (String fieldName : fieldNames) {
            custom.add(fileSourceFieldMap.get(fieldName));
        }
        return custom;
    }

    protected void warnFileSourceField(Map<String, Object> values, String message, String ... fieldNames) {
        Map<String, String> fileSourceFieldMap = this.getFileSourceFieldMapToNative();
        for (String fieldName : fieldNames) {
            if (fileSourceFieldMap.get(fieldName) == null || values.containsKey(fieldName)) continue;
            log.warn("field '" + fieldName + "': " + message);
        }
    }

    protected Map<String, Object> getFileSourceNativeValues(Map values) {
        if (values == null) {
            return new HashMap<String, Object>();
        }
        return DataTools.remapRow(values, this.getFileSourceFieldMapToNative(), false);
    }

    protected List<String> getFileSourceNativeKeys(List keys) {
        return DataTools.remapKeys(keys, this.getFileSourceFieldMapToNative(), false);
    }

    protected Map<String, Object> getFileSourceNonNativeValues(Map values) {
        if (values == null) {
            return new HashMap<String, Object>();
        }
        return DataTools.remapRow(values, this.getFileSourceFieldMapFromNative(), false);
    }

    protected Map<String, Object> getFileSourceNativePrimaryKeys(Map values) {
        if (values == null) {
            return new HashMap<String, Object>();
        }
        Map primaryKeys = DataTools.subsetMap(values, FS_PRIMARY_KEYS);
        return this.getFileSourceNativeValues(primaryKeys);
    }

    protected Map<String, Object> getFileSourceNonNativePrimaryKeys(Map values) {
        if (values == null) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> nonNativeValues = this.getFileSourceNonNativeValues(values);
        Map primaryKeys = DataTools.subsetMap(nonNativeValues, FS_PRIMARY_KEYS);
        return primaryKeys;
    }

    protected Map<String, String> getFileSourceFieldMapToNative() {
        if (!this.fileSourceFieldMapInitialized) {
            this.setFileNameField(this.getFileNameField());
            this.setFileTypeField(this.getFileTypeField());
            this.setFileFormatField(this.getFileFormatField());
            this.setFileSizeField(this.getFileSizeField());
            this.setFileLastModifiedField(this.getFileLastModifiedField());
            this.setFileContentsField(this.getFileContentsField());
            this.fileSourceFieldMapInitialized = true;
        }
        return this.fileSourceFieldMapToNative;
    }

    protected Map<String, String> getFileSourceFieldMapFromNative() {
        this.getFileSourceFieldMapToNative();
        return this.fileSourceFieldMapFromNative;
    }

    protected final void setFileSourceField(String fsName, String nativeName) {
        String oldNativeName = this.fileSourceFieldMapToNative.put(fsName, nativeName);
        if (oldNativeName != null) {
            this.fileSourceFieldMapFromNative.remove(oldNativeName);
        }
        if (nativeName != null) {
            this.fileSourceFieldMapFromNative.put(nativeName, fsName);
        }
    }

    public final void setFileNameField(String fieldName) {
        this.setFileSourceField(FS_FILE_NAME, fieldName);
    }

    public final void setFileTypeField(String fieldName) {
        this.setFileSourceField(FS_FILE_TYPE, fieldName);
    }

    public final void setFileFormatField(String fieldName) {
        this.setFileSourceField(FS_FILE_FORMAT, fieldName);
    }

    public final void setFileContentsField(String fieldName) {
        this.setFileSourceField(FS_FILE_CONTENTS, fieldName);
    }

    public final void setFileSizeField(String fieldName) {
        this.setFileSourceField(FS_FILE_SIZE, fieldName);
    }

    public final void setFileLastModifiedField(String fieldName) {
        this.setFileSourceField(FS_FILE_LAST_MODIFIED, fieldName);
    }

    public String getFileNameField() {
        if (!this.fileSourceFieldMapToNative.containsKey(FS_FILE_NAME)) {
            this.setFileNameField(this.getFileNameFieldWithoutCache());
        }
        return this.fileSourceFieldMapToNative.get(FS_FILE_NAME);
    }

    protected String getFileNameFieldWithoutCache() {
        DSField pk;
        String binaryFileNameField;
        String fileContentsFieldName;
        DSField fileContentsField;
        String fileNameField = this.dsConfig.getString("fileNameField");
        if (fileNameField != null) {
            return fileNameField;
        }
        if (!this.preventFileContentsRecursion && (fileContentsField = this.getField(fileContentsFieldName = this.getFileContentsField())) != null && fileContentsField.isBinary() && (binaryFileNameField = this.getFilenameField(fileContentsField)) != null) {
            return binaryFileNameField;
        }
        if (this.getField(FS_FILE_NAME) != null) {
            return FS_FILE_NAME;
        }
        if (this.getField("name") != null) {
            return "name";
        }
        if (this.getField("title") != null) {
            return "title";
        }
        List<String> pks = this.getPrimaryKeys();
        if (pks != null && pks.size() == 1 && "text".equals((pk = this.getField(pks.get(0).toString())).getType())) {
            return pk.getName();
        }
        log.error("DataSource.getFileNameField: No suitable field found for '" + this.getName() + "'");
        return FS_FILE_NAME;
    }

    public String getFileContentsField() {
        if (!this.fileSourceFieldMapToNative.containsKey(FS_FILE_CONTENTS)) {
            this.setFileContentsField(this.getFileContentsFieldWithoutCache());
        }
        return this.fileSourceFieldMapToNative.get(FS_FILE_CONTENTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFileContentsFieldWithoutCache() {
        String fileContentsField = this.dsConfig.getString("fileContentsField");
        if (fileContentsField != null) {
            return fileContentsField;
        }
        if (this.getField(FS_FILE_CONTENTS) != null) {
            return FS_FILE_CONTENTS;
        }
        if (this.getField("contents") != null) {
            return "contents";
        }
        for (DSField field : this.getFields()) {
            if (!field.isBinary()) continue;
            return field.getName();
        }
        this.preventFileContentsRecursion = true;
        String fileNameField = null;
        String fileTypeField = null;
        String fileFormatField = null;
        try {
            fileNameField = this.getFileNameField();
            fileTypeField = this.getFileTypeField();
            fileFormatField = this.getFileFormatField();
        }
        finally {
            this.preventFileContentsRecursion = false;
        }
        long bestLength = 0L;
        String bestFieldName = null;
        for (DSField field : this.getFields()) {
            long length;
            String fieldName;
            if (!"text".equals(field.getType()) || (fieldName = field.getName()).equals(fileNameField) || fieldName.equals(fileTypeField) || fieldName.equals(fileFormatField) || (length = field.getLength().longValue()) <= bestLength) continue;
            bestLength = length;
            bestFieldName = fieldName;
        }
        if (bestFieldName != null) {
            return bestFieldName;
        }
        log.error("DataSource::getFileContentsField() : no suitable field found for '" + this.getName() + "'");
        return FS_FILE_CONTENTS;
    }

    public String getFileTypeField() {
        if (!this.fileSourceFieldMapToNative.containsKey(FS_FILE_TYPE)) {
            this.setFileTypeField(this.getFileTypeFieldWithoutCache());
        }
        return this.fileSourceFieldMapToNative.get(FS_FILE_TYPE);
    }

    protected String getFileTypeFieldWithoutCache() {
        String fileTypeField = this.dsConfig.getString("fileTypeField");
        if (fileTypeField != null) {
            return fileTypeField;
        }
        if (this.getField(FS_FILE_TYPE) != null) {
            return FS_FILE_TYPE;
        }
        return null;
    }

    public String getFileFormatField() {
        if (!this.fileSourceFieldMapToNative.containsKey(FS_FILE_FORMAT)) {
            this.setFileFormatField(this.getFileFormatFieldWithoutCache());
        }
        return this.fileSourceFieldMapToNative.get(FS_FILE_FORMAT);
    }

    protected String getFileFormatFieldWithoutCache() {
        String fileFormatField = this.dsConfig.getString("fileFormatField");
        if (fileFormatField != null) {
            return fileFormatField;
        }
        if (this.getField(FS_FILE_FORMAT) != null) {
            return FS_FILE_FORMAT;
        }
        return null;
    }

    public String getFileSizeField() {
        if (!this.fileSourceFieldMapToNative.containsKey(FS_FILE_SIZE)) {
            this.setFileSizeField(this.getFileSizeFieldWithoutCache());
        }
        return this.fileSourceFieldMapToNative.get(FS_FILE_SIZE);
    }

    protected String getFileSizeFieldWithoutCache() {
        String fileSizeField = this.dsConfig.getString("fileSizeField");
        if (fileSizeField != null) {
            return fileSizeField;
        }
        if (this.getField(FS_FILE_SIZE) != null) {
            return FS_FILE_SIZE;
        }
        return null;
    }

    public String getFileLastModifiedField() {
        if (!this.fileSourceFieldMapToNative.containsKey(FS_FILE_LAST_MODIFIED)) {
            this.setFileLastModifiedField(this.getFileLastModifiedFieldWithoutCache());
        }
        return this.fileSourceFieldMapToNative.get(FS_FILE_LAST_MODIFIED);
    }

    protected String getFileLastModifiedFieldWithoutCache() {
        String fileLastModifiedField = this.dsConfig.getString("fileLastModifiedField");
        if (fileLastModifiedField != null) {
            return fileLastModifiedField;
        }
        if (this.getField(FS_FILE_LAST_MODIFIED) != null) {
            return FS_FILE_LAST_MODIFIED;
        }
        for (DSField field : this.getFields()) {
            if (!"modifierTimestamp".equals(field.getType())) continue;
            return field.getName();
        }
        return null;
    }

    public String getFileVersionField() {
        String fileVersionField = this.dsConfig.getString("fileVersionField");
        return fileVersionField != null ? fileVersionField : null;
    }

    public List<String> getFileExtensionFields() {
        String extensionConfig;
        ArrayList<String> fields = new ArrayList<String>();
        if (this.dsConfig.containsKey(FS_EXT_FIELDS) && (extensionConfig = this.dsConfig.getString(FS_EXT_FIELDS)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensionConfig, " |:;,");
            while (tokenizer.hasMoreTokens()) {
                String fieldName = tokenizer.nextToken();
                if (this.getField(fieldName) == null) {
                    log.warn("DataSource " + this.getName() + " includes the invalid field '" + fieldName + "' in its declaration of the config property '" + FS_EXT_FIELDS + "' - ignoring that field");
                    continue;
                }
                fields.add(fieldName);
            }
        }
        return fields;
    }

    public Reader getFile(DSFileSpec fileSpec) throws Exception {
        DSResponse response;
        DSRequest req = new DSRequest(this.getName(), OP_GET_FILE);
        req.setValues(fileSpec.getPrimaryKeys());
        DSRequest fileSpecRequestContext = fileSpec.getRequestContext();
        if (fileSpecRequestContext != null) {
            req.inheritClientContext(fileSpecRequestContext);
            String userId = fileSpecRequestContext.getUserId();
            if (userId != null) {
                req.setUserId(userId);
            }
        }
        if ((response = req.execute()).statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        Map record = response.getDataMap();
        if (record == null) {
            return null;
        }
        Object fileContents = record.get(FS_FILE_CONTENTS);
        if (fileContents == null) {
            return null;
        }
        return IOUtil.makeReader(fileContents);
    }

    public String getFileAsString(DSFileSpec fileSpec) throws Exception {
        Reader reader = this.getFile(fileSpec);
        if (reader == null) {
            return null;
        }
        return IOUtil.readerToString(reader);
    }

    public InputStream getFileAsInputStream(DSFileSpec fileSpec) throws Exception {
        String contents = this.getFileAsString(fileSpec);
        if (contents == null) {
            return null;
        }
        return new StringBufferInputStream(contents);
    }

    public long getFileSize(DSFileSpec fileSpec) throws Exception {
        String contents = this.getFileAsString(fileSpec);
        if (contents == null) {
            return -1L;
        }
        return contents.length();
    }

    public long getFileLastModified(DSFileSpec fileSpec) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_HAS_FILE);
        req.setValues(fileSpec.getPrimaryKeys());
        req.inheritClientContext(fileSpec.getRequestContext());
        DSResponse response = req.execute();
        if (response.statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        Map data = response.getDataMap();
        if (data == null) {
            return 0L;
        }
        Object lastModified = data.get(FS_FILE_LAST_MODIFIED);
        if (lastModified == null) {
            return -1L;
        }
        if (lastModified instanceof Date) {
            return ((Date)lastModified).getTime();
        }
        log.error("fileLastModified value was of type: " + lastModified.getClass().getName() + " -- expected java.util.Date");
        return -1L;
    }

    public boolean setFileLastModified(DSFileSpec fileSpec, long lastModified) throws Exception {
        return false;
    }

    public boolean hasFile(DSFileSpec fileSpec) throws Exception {
        DSResponse response;
        DSRequest req = new DSRequest(this.getName(), OP_HAS_FILE);
        req.setValues(fileSpec.getPrimaryKeys());
        DSRequest fileSpecRequestContext = fileSpec.getRequestContext();
        if (fileSpecRequestContext != null) {
            req.inheritClientContext(fileSpecRequestContext);
            String userId = fileSpecRequestContext.getUserId();
            if (userId != null) {
                req.setUserId(userId);
            }
        }
        if ((response = req.execute()).statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        List data = response.getDataList();
        return data != null && !data.isEmpty();
    }

    public Map<String, Object> saveFile(DSFileSpec fileSpec, Object contents) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_SAVE_FILE);
        DSRequest context = fileSpec.getRequestContext();
        if (context != null) {
            req.inheritClientContext(context);
            req.setAllowMultiUpdate(context.getAllowMultiUpdate());
        }
        Map<String, Object> values = fileSpec.getPrimaryKeys();
        values.put(FS_FILE_CONTENTS, contents);
        req.setValues(values);
        DSResponse response = req.execute();
        if (response.statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        return response.getDataMap();
    }

    public List<Map<String, Object>> listFiles(Object criteria, DSRequest context) throws Exception {
        DSResponse response;
        DSRequest req = new DSRequest(this.getName(), OP_LIST_FILES);
        if (context != null) {
            req.inheritClientContext(context);
        }
        if (criteria != null) {
            req.setCriteria(criteria);
        }
        if ((response = req.execute()).statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        return response.getDataList();
    }

    public List<Map<String, Object>> listFiles(Object criteria) throws Exception {
        return this.listFiles(criteria, (DSRequest)null);
    }

    public List<Map<String, Object>> listFiles(String type, String format, DSRequest context) throws Exception {
        HashMap<String, String> criteria = new HashMap<String, String>();
        if (type != null) {
            criteria.put(FS_FILE_TYPE, type);
        }
        if (format != null) {
            criteria.put(FS_FILE_FORMAT, format);
        }
        return this.listFiles(criteria, context);
    }

    public List<Map<String, Object>> listFiles(String type, String format) throws Exception {
        return this.listFiles(type, format, null);
    }

    public List<Map<String, Object>> listFiles() throws Exception {
        return this.listFiles(null, (DSRequest)null);
    }

    public List<Map<String, Object>> renameFile(DSFileSpec oldSpec, DSFileSpec newSpec) throws Exception {
        String oldFormat;
        String oldType;
        DSRequest req = new DSRequest(this.getName(), OP_RENAME_FILE);
        req.inheritClientContext(oldSpec.getRequestContext());
        Map<String, Object> values = newSpec.getPrimaryKeys();
        if (!values.containsKey(FS_FILE_TYPE) && (oldType = oldSpec.getFileType()) != null) {
            values.put(FS_FILE_TYPE, oldType);
        }
        if (!values.containsKey(FS_FILE_FORMAT) && (oldFormat = oldSpec.getFileFormat()) != null) {
            values.put(FS_FILE_FORMAT, oldFormat);
        }
        req.setValues(values);
        Map<String, Object> oldValues = oldSpec.getPrimaryKeys();
        req.setOldValues(oldValues);
        DSResponse response = req.execute();
        if (response.statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        DSRequest refetchRequest = new DSRequest(this.getName(), OP_LIST_FILES);
        refetchRequest.inheritClientContext(newSpec.getRequestContext());
        refetchRequest.setCriteria(newSpec.getPrimaryKeys());
        DSResponse refetchResponse = refetchRequest.execute();
        return refetchResponse.getDataList();
    }

    public List<Map<String, Object>> removeFile(DSFileSpec fileSpec) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_REMOVE_FILE);
        DSRequest context = fileSpec.getRequestContext();
        if (context != null) {
            req.inheritClientContext(context);
            req.setAllowMultiUpdate(context.getAllowMultiUpdate());
        }
        req.setValues(fileSpec.getPrimaryKeys());
        DSResponse response = req.execute();
        if (response.statusIsError()) {
            Object error = response.getData();
            throw new Exception("DSResponse error " + (error != null ? error.toString() : ""));
        }
        return response.getDataList();
    }

    public Object getLastRow() throws Exception {
        throw new Exception("Not supported by this DataSource (" + this.getName() + ")");
    }

    public Map getLastPrimaryKeys() throws Exception {
        throw new Exception("Not supported by this DataSource (" + this.getName() + ")");
    }

    public void clearState() {
        this.clearAnnotatedConfig();
        this.globalServerConfig = null;
        this.serverConfigByOperationId = new DataTypeMap();
    }

    public List fetch(Object criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_FETCH);
        req.setCriteria(criteria);
        return req.execute().getDataList();
    }

    public List fetch(String key, Object value) throws Exception {
        return this.fetch((Object)DataTools.buildMap(key, value));
    }

    public List filter(Object criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), "filter");
        req.setCriteria(criteria);
        return req.execute().getDataList();
    }

    public List filter(String key, Object value) throws Exception {
        return this.filter((Object)DataTools.buildMap(key, value));
    }

    public long add(Object values) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_ADD);
        req.setValues(values);
        return req.execute().getAffectedRows();
    }

    public long replace(Object values) throws Exception {
        DSRequest req = new DSRequest(this.getName(), "replace");
        req.setValues(values);
        return req.execute().getAffectedRows();
    }

    public long update(Object criteria, Object values) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_UPDATE);
        req.setCriteria(criteria);
        req.setValues(values);
        return req.execute().getAffectedRows();
    }

    public long remove(Object criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_REMOVE);
        req.setCriteria(criteria);
        return req.execute().getAffectedRows();
    }

    public long insert(Object values) throws Exception {
        return this.add(values);
    }

    public long delete(Object criteria) throws Exception {
        return this.remove(criteria);
    }

    public List select(Object criteria) throws Exception {
        return this.fetch(criteria);
    }

    public List select(String key, Object value) throws Exception {
        return this.fetch(key, value);
    }

    public Map selectSingle(Object criteria) throws Exception {
        return this.fetchSingle(criteria);
    }

    public Map selectSingle(String key, Object value) throws Exception {
        return this.fetchSingle(key, value);
    }

    public Map selectUnique(Map criteria) throws Exception {
        throw new Exception("not supported by this class");
    }

    public Map fetchSingle(String key, Object value) throws Exception {
        return this.forceSingle(this.fetch(key, value));
    }

    public Map fetchSingle(Object criteria) throws Exception {
        return this.forceSingle(this.fetch(criteria));
    }

    public String getTransactionObjectKey(boolean longForm) throws Exception {
        return this.TRANSACTION_OBJECT_KEY;
    }

    public Object getTransactionObject(DSRequest req) throws Exception {
        return DataSource.getTransactionObject(req, this.getTransactionObjectKey(true), this.getTransactionObjectKey(false));
    }

    public static Object getTransactionObject(DSRequest req, String transactionObjectKey, String shortTransactionObjectKey) throws Exception {
        if (req == null) {
            throw new Exception("DSRequest must not be null");
        }
        DSTransaction dsTransaction = req.getDsTransaction();
        if (dsTransaction == null) {
            return null;
        }
        return dsTransaction.getAttribute(transactionObjectKey);
    }

    public static boolean usesSpringTransaction(DSRequest req, String transactionObjectKey) throws Exception {
        if (req == null) {
            return false;
        }
        DataSource ds = req.getDataSource();
        if (ds == null) {
            return false;
        }
        Boolean useSpring = null;
        DataTypeMap opConfig = ds.getOperationBinding(req);
        if (opConfig != null) {
            useSpring = (Boolean)opConfig.get(USE_SPRING_TRANSACTION);
        }
        if (useSpring == null && req.getPrimaryDSRequest() != null && (opConfig = ds.getOperationBinding(req.getPrimaryDSRequest())) != null) {
            useSpring = (Boolean)opConfig.get(USE_SPRING_TRANSACTION);
        }
        if (useSpring == null) {
            useSpring = (Boolean)ds.dsConfig.get(USE_SPRING_TRANSACTION);
        }
        if (useSpring == null) {
            useSpring = config.getBoolean(transactionObjectKey + "." + USE_SPRING_TRANSACTION);
        }
        if (useSpring == null) {
            useSpring = config.getBoolean(USE_SPRING_TRANSACTION);
        }
        if (useSpring == null) {
            useSpring = false;
        }
        return useSpring;
    }

    public static Object getSpringTransaction(DSRequest req, String transactionObjectKey) throws Exception {
        if (!DataSource.usesSpringTransaction(req, transactionObjectKey)) {
            return null;
        }
        ISpringTransactionObjectProvider provider = (ISpringTransactionObjectProvider)InterfaceProvider.load("ISpringTransactionObjectProvider");
        return provider.getSpringTransactionObject(transactionObjectKey);
    }

    protected Map forceSingle(List result) throws Exception {
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new Exception("Fetched multiple results when trying single");
        }
        return (Map)result.get(0);
    }

    protected Object forceSingleObject(List result) throws Exception {
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new Exception("Fetched multiple results when trying single");
        }
        return result.get(0);
    }

    public String toXML() {
        return this.toXML((Map)((Object)this.dsConfig));
    }

    public String toXML(Map dsConfig) {
        StringBuffer buf = new StringBuffer();
        buf.append("<DataSource \n");
        ArrayList complexValueKeys = new ArrayList();
        for (Object key : dsConfig.keySet()) {
            Object value = dsConfig.get(key);
            if (value instanceof List || value instanceof Map) {
                if ("fields".equals(key.toString())) continue;
                complexValueKeys.add(key);
                continue;
            }
            buf.append("\t" + key + "=\"" + value + "\"\n");
        }
        buf.append(">\n");
        buf.append("\n\t<fields>\n");
        Object fieldList = dsConfig.get("fields");
        StringWriter fw = new StringWriter();
        Iterator<Object> fields = null;
        if (fieldList instanceof Map) {
            fields = ((Map)fieldList).values().iterator();
        }
        if (fieldList instanceof List) {
            fields = ((List)fieldList).iterator();
        }
        if (fields != null) {
            while (fields.hasNext()) {
                fw.write("\t\t");
                try {
                    XML.recordToXML("field", (Map)fields.next(), fw, true, null);
                }
                catch (Exception exception) {}
            }
        }
        buf.append(fw.toString());
        buf.append("\t</fields>\n");
        for (Object key : complexValueKeys) {
            Object value = dsConfig.get(key);
            StringWriter sw = new StringWriter();
            try {
                if (value instanceof List) {
                    buf.append("\t<" + key.toString() + ">\n");
                    for (Object object : (List)value) {
                        if (object instanceof Map) {
                            XML.recordToXML(key.toString().substring(0, key.toString().length() - 1), (Map)object, sw, true, null);
                            continue;
                        }
                        sw.append(ObjectUtils.toString(object));
                    }
                    buf.append("\t\t" + sw.toString());
                    buf.append("\t</" + key.toString() + ">\n");
                    continue;
                }
                if (!(value instanceof Map)) continue;
                XML.recordToXML(key.toString(), (Map)value, sw, true, null);
                buf.append(sw.toString());
            }
            catch (Exception e) {
                log.warn("Unable to XMLSerialize value for key: " + key.toString());
            }
        }
        buf.append("</DataSource>\n");
        return buf.toString();
    }

    @Override
    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        Object dsConfig = this.getAnnotatedConfig();
        if (dsConfig == null) {
            dsConfig = this.getConfig();
        }
        HashMap<String, Object> maskedConfig = new HashMap<String, Object>((Map<String, Object>)dsConfig);
        String tableName = (String)maskedConfig.remove("tableName");
        maskedConfig.remove("quoteTableName");
        maskedConfig.remove("dbName");
        maskedConfig.remove("schema");
        maskedConfig.remove("serverConfig");
        maskedConfig.remove("serverObject");
        maskedConfig.remove("serverConstructor");
        maskedConfig.remove("schemaBean");
        maskedConfig.remove("beanClassName");
        maskedConfig.remove("configBean");
        maskedConfig.remove("requires");
        maskedConfig.remove("requiresAuthentication");
        maskedConfig.remove("requiresRole");
        maskedConfig.remove("creatorOverrides");
        maskedConfig.remove("ownerIdField");
        maskedConfig.remove("guestUserId");
        maskedConfig.remove("projectFileKey");
        maskedConfig.remove("projectFileLocations");
        maskedConfig.remove("lookAhead");
        maskedConfig.remove("endGap");
        maskedConfig.remove("progressiveLoadingThreshold");
        maskedConfig.remove("qualifyColumnNames");
        maskedConfig.remove("quoteColumnNames");
        maskedConfig.remove("sqlPaging");
        maskedConfig.remove("scriptImport");
        maskedConfig.remove("script");
        maskedConfig.remove("serverOnly");
        if (Boolean.TRUE != (Boolean)maskedConfig.get("clientOnly") && Boolean.TRUE != (Boolean)maskedConfig.get("mockMode")) {
            maskedConfig.remove("cacheData");
        }
        maskedConfig.remove("fmt");
        maskedConfig.remove("fmt:bundle");
        List operationBindings = (List)maskedConfig.get("operationBindings");
        if (operationBindings != null) {
            ArrayList newBindings = new ArrayList();
            maskedConfig.put("operationBindings", newBindings);
            for (int i = 0; i < operationBindings.size(); ++i) {
                HashMap newBinding = new HashMap((Map)operationBindings.get(i));
                newBinding.remove("serverConfig");
                newBinding.remove("serverObject");
                newBinding.remove("customSQL");
                newBinding.remove("customHQL");
                newBinding.remove("selectClause");
                newBinding.remove("tableClause");
                newBinding.remove("whereClause");
                newBinding.remove("valuesClause");
                newBinding.remove("orderClause");
                newBinding.remove("groupClause");
                newBinding.remove("groupWhereClause");
                newBinding.remove("language");
                newBinding.remove("requires");
                newBinding.remove("requiresAuthentication");
                newBinding.remove("requiresRole");
                newBinding.remove("creatorOverrides");
                newBinding.remove("ownerIdField");
                newBinding.remove("guestUserId");
                newBinding.remove("allowMultiUpdate");
                newBinding.remove("customCriteriaFields");
                newBinding.remove("customFields");
                newBinding.remove("customValueFields");
                newBinding.remove("excludeCriteriaFields");
                newBinding.remove("methodArguments");
                newBinding.remove("qualifyColumnNames");
                newBinding.remove("serverMethod");
                newBinding.remove("skipRowCount");
                newBinding.remove("sqlPaging");
                newBinding.remove("sqlType");
                newBinding.remove("scriptImport");
                newBinding.remove("script");
                newBinding.remove("criteria");
                newBinding.remove("values");
                newBinding.remove("mail");
                newBindings.add(newBinding);
            }
        }
        if (this instanceof BasicDataSource && ((BasicDataSource)this).autoDeriveDS != null) {
            DataSource inheritsFrom = ((BasicDataSource)this).autoDeriveDS;
            maskedConfig.put("inheritsFrom", inheritsFrom);
        }
        boolean autoLinkFKs = !Boolean.FALSE.equals(config.getBoolean("datasource.autoLinkFKs"));
        Map fields = (Map)maskedConfig.get("fields");
        BasicDataSource superDS = ((BasicDataSource)this).getSuper();
        HashSet<String> suppressedFilenames = new HashSet<String>();
        if (fields != null) {
            ArrayList<Object> fieldList = new ArrayList<Object>();
            for (String fieldName : fields.keySet()) {
                String displayFieldName;
                Object fieldObj = fields.get(fieldName);
                boolean bl = false;
                if (!(fieldObj instanceof Map)) {
                    fieldList.add(fieldObj);
                    continue;
                }
                HashMap<String, Object> fieldMap = new HashMap<String, Object>((Map)fieldObj);
                if (!fieldMap.containsKey("name")) {
                    if (!bl) {
                        fieldMap = new LinkedHashMap(fieldMap);
                        bl = true;
                    }
                    fieldMap.put("name", fieldName);
                }
                if (DataTools.getBoolean(fieldMap, "ignore")) {
                    if (fieldName.toLowerCase().endsWith("_filename")) {
                        suppressedFilenames.add(fieldName.substring(0, fieldName.length() - "_filename".length()));
                    }
                    DSField superField = null;
                    if (superDS != null) {
                        superField = ((DataSource)superDS).getField((String)fieldMap.get("name"));
                    }
                    if (superField == null) continue;
                    if (!bl) {
                        fieldMap = new LinkedHashMap(fieldMap);
                        bl = true;
                    }
                    fieldMap.put("hidden", true);
                }
                if (fieldMap.get("tableName") != null && fieldMap.get("canEdit") == null) {
                    if (!bl) {
                        fieldMap = new LinkedHashMap(fieldMap);
                        bl = true;
                    }
                    fieldMap.put("canEdit", Boolean.FALSE);
                }
                if ((displayFieldName = (String)fieldMap.get("displayField")) != null) {
                    HashMap displayFieldMap;
                    Object explicitUseLocalDisplayFieldValue = fieldMap.get("useLocalDisplayFieldValue");
                    Object displayFieldObj = fields.get(displayFieldName);
                    if (displayFieldObj != null && explicitUseLocalDisplayFieldValue == null && (displayFieldMap = new HashMap((Map)displayFieldObj)).get("includeFrom") != null) {
                        fieldMap.put("useLocalDisplayFieldValue", true);
                    }
                }
                try {
                    String typeName = (String)fieldMap.get("type");
                    BasicDataSource cfr_ignored_0 = (BasicDataSource)this;
                    Map typeDef = BasicDataSource.getBuiltinType(typeName);
                    if (typeDef != null) {
                        if (fieldMap.get("hidden") == null && typeDef.get("hidden") != null) {
                            fieldMap.put("hidden", new Boolean(typeDef.get("hidden").toString()));
                        }
                        if (fieldMap.get("canView") == null && typeDef.get("canView") != null) {
                            fieldMap.put("canView", new Boolean(typeDef.get("canView").toString()));
                        }
                        if (fieldMap.get("canEdit") == null && typeDef.get("canEdit") != null) {
                            fieldMap.put("canEdit", new Boolean(typeDef.get("canEdit").toString()));
                        }
                        if (fieldMap.get("canSave") == null && typeDef.get("canSave") != null) {
                            fieldMap.put("canSave", new Boolean(typeDef.get("canSave").toString()));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String columnName = (String)fieldMap.get("nativeName");
                if (!DataTools.getBoolean(fieldMap, "canView", true)) {
                    Iterator keys = fieldMap.keySet().iterator();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if ("name".equals(key) || "canView".equals(key)) continue;
                        keys.remove();
                    }
                } else {
                    fieldMap.remove("hashCipher");
                    fieldMap.remove("viewRequires");
                    fieldMap.remove("viewRequiresAuthentication");
                    fieldMap.remove("viewRequiresRole");
                    fieldMap.remove("editRequires");
                    fieldMap.remove("editRequiresAuthentication");
                    fieldMap.remove("editRequiresRole");
                    fieldMap.remove("initRequires");
                    fieldMap.remove("initRequiresAuthentication");
                    fieldMap.remove("initRequiresRole");
                    fieldMap.remove("updateRequires");
                    fieldMap.remove("updateRequiresAuthentication");
                    fieldMap.remove("updateRequiresRole");
                    fieldMap.remove("creatorOverrides");
                    fieldMap.remove("autoQuoteCustomExpressions");
                    fieldMap.remove("customCriteriaExpression");
                    fieldMap.remove("customInsertExpression");
                    fieldMap.remove("customSelectExpression");
                    fieldMap.remove("customSQL");
                    fieldMap.remove("customUpdateExpression");
                    fieldMap.remove("includeFrom");
                    fieldMap.remove("javaClass");
                    fieldMap.remove("javaCollectionClass");
                    fieldMap.remove("javaKeyClass");
                    fieldMap.remove("sequenceName");
                    fieldMap.remove("sqlDateFormat");
                    fieldMap.remove("sqlFalseValue");
                    fieldMap.remove("sqlStorageStrategy");
                    fieldMap.remove("sqlTrueValue");
                    fieldMap.remove("tableName");
                    fieldMap.remove("implicitSequence");
                    fieldMap.remove("typeInherited");
                    fieldMap.remove("typeExplicitlyDeclared");
                    fieldMap.remove("__cachedType");
                    fieldMap.remove("isBinary");
                    List allValidators = (List)fieldMap.get("validators");
                    ArrayList<Map> publicValidators = new ArrayList<Map>();
                    if (allValidators != null) {
                        for (int j = 0; j < allValidators.size(); ++j) {
                            Map privateMap = (Map)allValidators.get(j);
                            Object[] exclusions = new String[]{"serverObject", "serverCondition"};
                            List inclusions = DataTools.setDisjunction(privateMap.keySet(), DataTools.arrayToList(exclusions));
                            if (inclusions.isEmpty()) continue;
                            publicValidators.add(DataTools.subsetMap(privateMap, inclusions));
                        }
                    }
                    fieldMap.put("validators", publicValidators);
                }
                String nativeFKs = (String)fieldMap.remove("nativeFK");
                if ("sql".equals(this.getType()) && autoLinkFKs) {
                    if (nativeFKs != null) {
                        String[] parts = nativeFKs.split("\\.");
                        try {
                            String tableCode = DataTools.hashValue(parts[0].toLowerCase());
                            String columnCode = DataTools.hashValue(parts[1].toLowerCase());
                            fieldMap.put("fkTableCode", tableCode);
                            fieldMap.put("fkColumnCode", columnCode);
                        }
                        catch (Exception e) {
                            log.error((Object)"Can't hash foreign key", e);
                        }
                    }
                    if (columnName == null && (columnName = (String)fieldMap.get("nativeName")) == null) {
                        columnName = (String)fieldMap.get("name");
                    }
                    try {
                        String columnCode = DataTools.hashValue(columnName.toLowerCase());
                        fieldMap.put("columnCode", columnCode);
                    }
                    catch (Exception e) {
                        log.error((Object)"Can't hash columnName", e);
                    }
                }
                fieldMap.remove("nativeName");
                fieldList.add(fieldMap);
            }
            block12: for (String fieldName : suppressedFilenames) {
                if (fieldName == null) continue;
                for (Map map : fieldList) {
                    String nameInList = (String)map.get("name");
                    if (nameInList == null || !fieldName.toLowerCase().equals(nameInList.toLowerCase())) continue;
                    map.put("filenameSuppressed", true);
                    continue block12;
                }
            }
            maskedConfig.put("fields", fieldList);
        }
        if (useAxisForSQLDS && "sql".equals(this.getType())) {
            dsConfig.put((String)"__autoConstruct", (Object)"WSDataSource");
        }
        if ("sql".equals(this.getType()) && autoLinkFKs) {
            try {
                if (tableName == null) {
                    tableName = (String)maskedConfig.get("ID");
                }
                String tableCode = DataTools.hashValue(tableName.toLowerCase());
                maskedConfig.put("tableCode", tableCode);
            }
            catch (Exception e) {
                log.error((Object)"Can't hash tableName", e);
            }
        }
        jsTrans.toJS(maskedConfig, out);
    }

    public String getFieldXML() throws Exception {
        return DataSource.getFieldXML(this.fieldList);
    }

    public static String getFieldXML(List fields) throws Exception {
        StringBuffer xml = new StringBuffer();
        xml.append("<fields>\n");
        for (Object map : fields) {
            if (!(map instanceof Map)) {
                log.warn("Found object of type " + map.getClass() + " in list passed to getFieldXML - was expecting Map");
                continue;
            }
            StringWriter out = new StringWriter();
            XML.recordToXML("field", (Map)map, out);
            xml.append("\t");
            xml.append(out.toString());
        }
        xml.append("</fields>\n");
        return xml.toString();
    }

    public String escapeValueForWhereClause(Object value, Object key) throws Exception {
        return value == null ? null : value.toString();
    }

    public boolean hasRecord(String columnName, Object value) throws Exception {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(columnName, value);
        return this.hasRecord(criteria);
    }

    public boolean hasRecord(Map criteria) throws Exception {
        DSRequest req = new DSRequest(this.getName(), OP_FETCH);
        req.setCriteria(criteria);
        req.context = req.context;
        DSResponse resp = req.execute();
        return resp.getRowCount() != 0L;
    }

    public Map<String, Object> fetchById(Object id) throws Exception {
        return this.fetchById(id, null);
    }

    public Map<String, Object> fetchById(Object id, RPCManager rpc) throws Exception {
        List<String> pks = this.getPrimaryKeys();
        if (pks.size() == 0) {
            throw new Exception("Cannot fetch by ID - DataSource has no primary key field");
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        if (id instanceof Map) {
            for (String fieldName : pks) {
                if (!((Map)id).containsKey(fieldName)) continue;
                criteria.put(fieldName, ((Map)id).get(fieldName));
            }
        } else {
            criteria = new HashMap();
            criteria.put(this.getPrimaryKey(), id);
        }
        DSRequest req = new DSRequest(this.getName(), OP_FETCH);
        req.setCriteria(criteria);
        req.context = req.context;
        if (rpc != null) {
            req.setRPCManager(rpc);
        }
        DSResponse resp = req.execute();
        return resp.getRecord();
    }

    public String getEnumTranslateStrategy() {
        String value = (String)this.dsConfig.get("enumTranslateStrategy");
        if (value == null) {
            boolean autoDerive = DataTools.getBoolean(this.dsConfig, "autoDeriveSchema", false);
            value = autoDerive ? "name" : "string";
        }
        return value;
    }

    public void setEnumTranslateStrategy(String newValue) {
        this.dsConfig.put("enumTranslateStrategy", newValue);
    }

    public String getEnumOrdinalProperty() {
        String value = (String)this.dsConfig.get("enumOrdinalProperty");
        if (value == null) {
            value = "_ordinal";
        }
        return value;
    }

    public String getEnumConstantProperty() {
        String value = (String)this.dsConfig.get("enumConstantProperty");
        if (value == null) {
            value = "_constant";
        }
        return value;
    }

    public void setEnumOrdinalProperty(String newValue) {
        this.dsConfig.put("enumOrdinalProperty", newValue);
    }

    public void setEnumConstantProperty(String newValue) {
        this.dsConfig.put("enumConstantProperty", newValue);
    }

    Evaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = new Evaluator();
        }
        return this.evaluator;
    }

    public void addSearchOperator(Operator op) {
        this.getEvaluator().addSearchOperator(op);
    }

    public boolean matchesCriteria(Map values, AdvancedCriteria criteria) throws Exception {
        return this.getEvaluator().valuesMatchCriteria(values, criteria);
    }

    public boolean matchesCriteria(Map values, Map rawCriteria) throws Exception {
        AdvancedCriteria criteria = Evaluator.parseAdvancedCriteria(rawCriteria);
        return this.getEvaluator().valuesMatchCriteria(values, criteria);
    }

    @Override
    public void freeResources(DSRequest req) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeQueueResources(DSRequest req) {
        try {
            Map<String, DataSource> includes = req.getCachedDataSourceInstances();
            if (includes != null) {
                Iterator<String> i = includes.keySet().iterator();
                while (i.hasNext()) {
                    DataSource ds = includes.get(i.next());
                    if (ds == this || !req.isDataSourceNull() && ds == req.getDataSource()) continue;
                    DataSourceManager.free(ds);
                }
            }
            if (!req.isDataSourceNull() && req.getDataSource() != this) {
                DataSourceManager.free(this);
            }
            if (config.getBoolean((Object)"clear.inInitState.at.queue.end", false)) {
                DataSource.clearInInitState();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception freeing QueueResources", e);
        }
        finally {
            if (!req.isDataSourceNull()) {
                req.clearDataSource();
            }
        }
    }

    public boolean hasRelation(DataSource relatedDS) throws Exception {
        return this.getRelation(relatedDS) != null;
    }

    public boolean isRelatedThroughPrimaryKey(DataSource relatedDS) throws Exception {
        Relation rel = this.getRelation(relatedDS);
        if (rel == null) {
            return false;
        }
        List<DSField> keys = rel.getToFields();
        if (keys == null || keys.size() == 0) {
            return false;
        }
        boolean allPKs = true;
        Iterator<DSField> i = keys.iterator();
        while (i.hasNext()) {
            if (i.next().isPrimaryKey()) continue;
            allPKs = false;
            break;
        }
        return allPKs;
    }

    protected void addCachedRelationInfo(String key, RelationInfo relationInfo) {
        this.cachedRelations.put(key, relationInfo);
    }

    protected void removeCachedRelation(String key) {
        this.cachedRelations.remove(key);
    }

    protected RelationInfo getCachedRelationInfo(String key) {
        return this.cachedRelations.get(key);
    }

    public void clearCachedRelations() {
        this.cachedRelations.clear();
    }

    public Relation getRelation(DataSource relatedDS, String includeVia) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, includeVia, true, null);
    }

    public Relation getRelation(DataSource relatedDS) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, null, true, null);
    }

    public Relation getRelation(DataSource relatedDS, boolean logProblems) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, null, logProblems, null);
    }

    public Relation getRelation(DataSource relatedDS, DSRequest dsRequest) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, null, true, dsRequest);
    }

    public Relation getRelation(DataSource relatedDS, boolean logProblems, DSRequest dsRequest) throws Exception {
        return this.getRelation(new DataSource[]{relatedDS}, null, logProblems, dsRequest);
    }

    public Relation getRelation(DataSource[] relatedDS, DSRequest dsRequest) throws Exception {
        return this.getRelation(relatedDS, null, true, dsRequest);
    }

    public Relation getRelation(DataSource[] relatedDS, String includeVia, DSRequest dsRequest) throws Exception {
        return this.getRelation(relatedDS, includeVia, true, dsRequest);
    }

    public Relation getRelation(DataSource[] relatedDSArray, boolean logProblems, DSRequest dsRequest) throws Exception {
        return this.getRelation(relatedDSArray, null, logProblems, dsRequest);
    }

    public Relation getRelation(DataSource[] relatedDSArray, String includeVia, boolean logProblems, DSRequest dsRequest) throws Exception {
        String includePath = "";
        for (DataSource ds : relatedDSArray) {
            if (!"".equals(includePath)) {
                includePath = includePath + ".";
            }
            includePath = includePath + ds.getName();
        }
        String cachedRelationKey = includePath + (includeVia != null ? "*" + includeVia : "");
        String[] includeViaArray = new String[]{includeVia};
        if (includeVia != null && includeVia.contains(".")) {
            includeViaArray = includeVia.split("\\.");
        }
        HashMap<String, DataSource> inInitState = DataSource.getInInitState();
        Map<String, DataSource> dsObjectsMap = dsRequest != null ? dsRequest.getCachedDataSourceInstances() : inInitState;
        dsObjectsMap.putAll(inInitState);
        if (this.getCachedRelationInfo(cachedRelationKey) != null && dsObjectsMap != null) {
            log.debug("Returning cached relation for " + this.getName() + " -> " + includePath + " (the relation is not necessarily direct)");
            return Relation.create(this.getCachedRelationInfo(cachedRelationKey), dsObjectsMap, dsRequest);
        }
        Relation relation = null;
        if (relatedDSArray.length == 1) {
            relation = DataSource._getRelation(this, relatedDSArray[0], includeViaArray[0], logProblems, dsObjectsMap, new HashMap(), false);
        } else {
            for (int i = relatedDSArray.length - 2; i >= -1; --i) {
                Relation r;
                DataSource baseDS = null;
                DataSource relatedDS = null;
                if (i >= 0) {
                    baseDS = relatedDSArray[i];
                    relatedDS = relatedDSArray[i + 1];
                } else {
                    baseDS = this;
                    relatedDS = relatedDSArray[i + 1];
                }
                String useIncludeVia = null;
                if (includeViaArray.length < relatedDSArray.length) {
                    if (includeViaArray.length > i + 1) {
                        useIncludeVia = includeViaArray[i + 1];
                    }
                } else {
                    useIncludeVia = includeViaArray[i + 1];
                }
                if ((r = DataSource._getRelation(baseDS, relatedDS, useIncludeVia, logProblems, dsObjectsMap, null, true)) == null) {
                    relation = null;
                    break;
                }
                if (relation != null) {
                    r.setNextRelation(relation);
                }
                relation = r;
            }
        }
        String nextDS = "";
        if (relation != null && relation.isValid()) {
            String msg = "Path selected from " + this.getName() + " to " + includePath + ": ";
            for (Relation r = relation; r != null; r = r.getNextRelation()) {
                msg = msg + " -> " + r.getFromDataSource().getName();
                nextDS = r.getToDataSource().getName();
            }
            msg = msg + " -> " + nextDS;
            log.debug(msg);
            this.addCachedRelationInfo(cachedRelationKey, RelationInfo.create(relation));
            return relation;
        }
        String message = "DataSource " + this.getName() + " includes fields from DataSource " + includePath + " but we cannot establish a direct or indirect relation between those DataSources.  You must specify foreignKey field(s) on the including DataSource (" + this.getName() + ") that either express a direct relationship to " + includePath + ", or express an indrect relationship via one or more intervening tables";
        if (logProblems) {
            log.warn(message);
        }
        throw new ForeignKeyNotFoundException(message);
    }

    public static Relation _getRelation(DataSource baseDS, DataSource relatedDS, String includeVia, boolean logProblems, Map<String, DataSource> dsObjectsMap, Map seenBefore, boolean directOnly) throws Exception {
        List<DSField> fks;
        String[] parsed;
        Relation relation = new Relation();
        relation.setFromDataSource(baseDS);
        relation.setToDataSource(relatedDS);
        boolean foundLink = false;
        HashMap<String, List<DSField>> fkSets = new HashMap<String, List<DSField>>();
        for (DSField field : baseDS.getFields()) {
            if (field.getForeignKey() == null || includeVia != null && !includeVia.equals(field.getName())) continue;
            parsed = field.getForeignKey().split("\\.");
            String dsName = null;
            if (parsed.length == 1) {
                dsName = baseDS.getName();
                if (baseDS.getName().equals(relatedDS.getName())) {
                    relation.addFromField(field);
                    relation.addToField(field);
                    relation.setJoinType(field.getJoinType());
                    foundLink = true;
                }
            } else if (parsed.length == 2) {
                dsName = parsed[0];
                if (relatedDS.getName().equals(parsed[0])) {
                    relation.addFromField(field);
                    relation.addToField(relatedDS.getField(parsed[1]));
                    relation.setJoinType(field.getJoinType());
                    foundLink = true;
                }
            }
            if (fkSets.containsKey(dsName)) {
                fks = (List)fkSets.get(dsName);
            } else {
                fks = new ArrayList();
                fkSets.put(dsName, fks);
            }
            fks.add(field);
        }
        if (!foundLink) {
            for (DSField field : relatedDS.getFields()) {
                if (field.getForeignKey() == null) continue;
                parsed = field.getForeignKey().split("\\.");
                if (parsed.length == 1) {
                    if (!relatedDS.getName().equals(baseDS.getName())) continue;
                    relation.addFromField(field);
                    relation.addToField(field);
                    relation.setJoinType(field.getJoinType());
                    foundLink = true;
                    continue;
                }
                if (parsed.length != 2 || !baseDS.getName().equals(parsed[0])) continue;
                relation.addFromField(baseDS.getField(parsed[1]));
                relation.addToField(field);
                relation.setJoinType(field.getJoinType());
                foundLink = true;
            }
        }
        if (directOnly) {
            return relation;
        }
        if (!foundLink && dsObjectsMap != null) {
            ArrayList candidates = new ArrayList();
            for (String dsName : fkSets.keySet()) {
                if (seenBefore.containsKey(dsName)) continue;
                DataSource ds = dsObjectsMap.get(dsName);
                if (ds == null) {
                    ds = DataSourceManager.get(dsName, null);
                    if (ds == null) {
                        throw new Exception("DataSource '" + baseDS.getName() + "' declares a foreignKey relation to DataSource '" + dsName + "', which does not exist.");
                    }
                    dsObjectsMap.put(dsName, ds);
                }
                fks = (List)fkSets.get(dsName);
                seenBefore.put(dsName, ds);
                Relation candidate = DataSource._getRelation(ds, relatedDS, null, logProblems, dsObjectsMap, seenBefore, directOnly);
                if (candidate == null || !candidate.isValid()) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("relation", candidate);
                map.put("ds", ds);
                map.put("fks", fks);
                candidates.add(map);
            }
            int shortest = Integer.MAX_VALUE;
            int index = -1;
            for (int i = 0; i < candidates.size(); ++i) {
                Relation r = (Relation)((Map)candidates.get(i)).get("relation");
                int length = 1;
                while (r.getNextRelation() != null) {
                    r = r.getNextRelation();
                    ++length;
                }
                if (length < shortest) {
                    shortest = length;
                    index = i;
                    String msg = "Found new shortest path from " + baseDS.getName() + " to " + relatedDS.getName() + ".  Path is: " + baseDS.getName();
                    String nextDS = "";
                    for (r = (Relation)((Map)candidates.get(i)).get("relation"); r != null; r = r.getNextRelation()) {
                        msg = msg + " -> " + r.getFromDataSource().getName();
                        nextDS = r.getToDataSource().getName();
                    }
                    msg = msg + " -> " + nextDS;
                    log.debug(msg);
                    continue;
                }
                String nextDS = "";
                String msg = "Ignoring a path from " + baseDS.getName() + " to " + relatedDS.getName() + " - we already know of one at least as as short.  The ignored path is: " + baseDS.getName();
                for (r = (Relation)((Map)candidates.get(i)).get("relation"); r != null; r = r.getNextRelation()) {
                    msg = msg + " -> " + r.getFromDataSource().getName();
                    nextDS = r.getToDataSource().getName();
                }
                msg = msg + " -> " + nextDS;
                log.debug(msg);
            }
            if (index != -1) {
                DataSource ds = (DataSource)((Map)candidates.get(index)).get("ds");
                fks = (List)((Map)candidates.get(index)).get("fks");
                Relation selected = (Relation)((Map)candidates.get(index)).get("relation");
                relation.setToDataSource(ds);
                relation.setFromFields(fks);
                for (DSField field : fks) {
                    String[] parsed2 = field.getForeignKey().split("\\.");
                    if (parsed2.length == 1) {
                        if (!ds.getName().equals(ds.getName())) continue;
                        relation.addToField(field);
                        relation.setJoinType(field.getJoinType());
                        continue;
                    }
                    if (parsed2.length != 2 || !ds.getName().equals(parsed2[0])) continue;
                    relation.addToField(ds.getField(parsed2[1]));
                    relation.setJoinType(field.getJoinType());
                }
                relation.setNextRelation(selected);
            }
        }
        return relation;
    }

    public boolean canJoinIncludedFields() {
        return false;
    }

    public boolean inheritsParent() {
        return false;
    }

    public List getLocalFieldNames() {
        Map fields = this.getRawFields();
        if (fields == null) {
            return new ArrayList();
        }
        return new ArrayList(fields.keySet());
    }

    public List getLocalFields() {
        List fieldNames = this.getLocalFieldNames();
        ArrayList<DSField> fields = new ArrayList<DSField>();
        if (fieldNames != null) {
            Iterator i = fieldNames.iterator();
            while (i.hasNext()) {
                fields.add(this.getField((String)i.next()));
            }
        }
        return fields;
    }

    public boolean isInherited(DSField field) {
        String name = field.getName();
        for (DataSource ds = this.getSuper(); ds != null; ds = ds.getSuper()) {
            List locals = ds.getLocalFieldNames();
            if (locals.contains(name)) {
                return true;
            }
            if (ds == ds.getSuper()) break;
        }
        return false;
    }

    public boolean isPureInherited(DSField field) {
        String name;
        List locals = this.getLocalFieldNames();
        if (locals.contains(name = field.getName())) {
            return false;
        }
        return this.isInherited(field);
    }

    public boolean isAutoDerived(DSField field) {
        DataSource autoDerive = this.getAutoDeriveDS();
        if (autoDerive == null) {
            return false;
        }
        List fields = autoDerive.getLocalFieldNames();
        String name = field.getName();
        return fields.contains(name);
    }

    public boolean isPureAutoDerived(DSField field) {
        String name;
        List locals = this.getLocalFieldNames();
        if (locals.contains(name = field.getName())) {
            return false;
        }
        return this.isAutoDerived(field);
    }

    protected DataSource getSuper() {
        return null;
    }

    public DataSource getAutoDeriveDS() {
        return null;
    }

    public boolean isBinaryMetadata(DSField field) {
        if (field == null) {
            return false;
        }
        String name = field.getName();
        List<String> fields = this.getFieldNames();
        String[] sfx = new String[]{"_filename", "_filesize", "_date_created"};
        for (int i = 0; i < sfx.length; ++i) {
            if (!name.endsWith(sfx[i]) || !fields.contains(name.substring(0, name.length() - sfx[i].length()))) continue;
            return true;
        }
        return false;
    }

    public String getFilenameField(DSField baseField) {
        if (baseField == null) {
            return null;
        }
        return this.getFilenameField(baseField.getName());
    }

    public String getFilenameField(String baseFieldName) {
        if (this.filenameField.containsKey(baseFieldName)) {
            return this.filenameField.get(baseFieldName);
        }
        this.filenameField.put(baseFieldName, this.getMetadataField(baseFieldName, "_filename"));
        return this.filenameField.get(baseFieldName);
    }

    public String getFilesizeField(DSField baseField) {
        if (baseField == null) {
            return null;
        }
        return this.getFilesizeField(baseField.getName());
    }

    public String getFilesizeField(String baseFieldName) {
        if (this.filesizeField.containsKey(baseFieldName)) {
            return this.filesizeField.get(baseFieldName);
        }
        this.filesizeField.put(baseFieldName, this.getMetadataField(baseFieldName, "_filesize"));
        return this.filesizeField.get(baseFieldName);
    }

    public String getDateCreatedField(DSField baseField) {
        if (baseField == null) {
            return null;
        }
        return this.getDateCreatedField(baseField.getName());
    }

    public String getDateCreatedField(String baseFieldName) {
        if (this.dateCreatedField.containsKey(baseFieldName)) {
            return this.dateCreatedField.get(baseFieldName);
        }
        this.dateCreatedField.put(baseFieldName, this.getMetadataField(baseFieldName, "_date_created"));
        return this.dateCreatedField.get(baseFieldName);
    }

    protected String getMetadataField(String baseFieldName, String suffix) {
        String fld = baseFieldName + suffix;
        List<String> fields = this.getFieldNames();
        for (int i = 0; i < fields.size(); ++i) {
            if (!fld.equalsIgnoreCase(fields.get(i))) continue;
            return fields.get(i);
        }
        return fld;
    }

    public static AdvancedCriteria parseAdvancedCriteria(Map rawCriteria) {
        return Evaluator.parseAdvancedCriteria(rawCriteria);
    }

    public boolean handlesRelations() {
        return false;
    }

    protected Object getRelationFieldValue(RelationFieldInfo relationFieldInfo, Object obj, List recursedList, ValidationContext vc) throws Exception {
        return DataTools.getProperties(obj, DataTools.buildList(relationFieldInfo.getFieldName())).get(relationFieldInfo.getFieldName());
    }

    protected void setRelationFieldValue(RelationFieldInfo relationFieldInfo, Object obj, Object value) throws Exception {
        DataTools.setProperties((Map)((Object)DataTools.buildMap(relationFieldInfo.getFieldName(), value)), obj, this);
    }

    protected IncludeFromInfo getIncludeFromInfo(DSField field, DSRequest dsRequest) throws Exception {
        HashMap<String, DataSource> inInitState = DataSource.getInInitState();
        if (dsRequest != null || log.isDebugEnabled()) {
            // empty if block
        }
        if (this.includeFromFields != null && this.includeFromFields.get(field.getName()) != null) {
            return this.includeFromFields.get(field.getName());
        }
        String text = (String)field.get("includeFrom");
        if (text != null) {
            DataSource includeFromDS;
            DSField includedField;
            IncludeFromInfo includeFromInfo = new IncludeFromInfo();
            String[] parsed = text.split("\\.");
            if (parsed.length < 2) {
                log.warn("Field " + field.getName() + " has invalid IncludeFromDefinition definition: '" + includeFromInfo + "'.  Should be of the form 'dataSourceName.fieldName'. You can also define multiple data sources to request certain  path to connect indirectly related data sources: 'dataSourceName1.dataSourceName2.fieldName'.");
                return null;
            }
            String includePath = text.substring(0, text.lastIndexOf("."));
            String includedFieldName = text.substring(text.lastIndexOf(".") + 1);
            DataSource[] dataSources = new DataSource[parsed.length - 1];
            String[] dataSourceNames = new String[parsed.length - 1];
            for (int i = 0; i < parsed.length - 1; ++i) {
                String dsName = parsed[i];
                DataSource ds = inInitState.get(dsName);
                if (ds == null && dsRequest != null) {
                    ds = dsRequest.getCachedDataSourceInstance(dsName);
                }
                if (ds == null && (ds = DataSourceManager.get(dsName, dsRequest)) != null && dsRequest != null) {
                    log.debug("Caching instance " + (ds == null ? "null" : Long.valueOf(ds.getInstanceId())) + " of DS '" + dsName + "' from getIncludeFromInfo()");
                    dsRequest.cacheDataSourceInstance(dsName, ds);
                }
                if (ds == null) {
                    log.warn("includeFrom field named '" + field.getName() + "' refers to a related DataSource ('" + dsName + "') that does not exist. Ignoring this field.");
                    return null;
                }
                dataSources[i] = ds;
                dataSourceNames[i] = dsName;
            }
            includeFromInfo.setThisDataSourceName(this.getName());
            includeFromInfo.setThisFieldName(field.getName());
            includeFromInfo.setIncludedFieldName(includedFieldName);
            includeFromInfo.setIncludePath(includePath);
            includeFromInfo.setDataSourceNames(dataSourceNames);
            String includeVia = field.getProperty("includeVia");
            Relation relationObject = this.getRelation(dataSources, includeVia, dsRequest);
            if (relationObject == null || !relationObject.isValid()) {
                log.warn("includeFrom field named '" + field.getName() + "' refers to a related DataSource ('" + dataSourceNames[dataSourceNames.length - 1] + "'). Failed to discover relation between data sources. Ignoring this field.");
                return null;
            }
            includeFromInfo.setRelation(RelationInfo.create(relationObject));
            if (includeVia != null && !"".equals(includeVia.trim())) {
                includeFromInfo.setIncludeVia(includeVia);
            }
            if ((includedField = (includeFromDS = dataSources[dataSources.length - 1]).getField(includedFieldName)) == null) {
                log.warn("includeFrom field named '" + field.getName() + "' refers to a '" + includedFieldName + "' field that does not exist in '" + includeFromDS.getName() + "' data source. Ignoring this field.");
                return null;
            }
            if (this.getName().equals(includeFromDS.getName()) && includedField.equals(field)) {
                log.warn("includeFrom field named '" + field.getName() + "' of datasource '" + this.getName() + "' refers to itself. Ignoring this field.");
                return null;
            }
            includeFromInfo.setTargetIncludeFrom(includeFromDS.getIncludeFromInfo(includedField, dsRequest));
            includeFromInfo.setTargetInspected(true);
            DataTypeMap configField = null;
            DataTypeMap configFieldsList = this.dsConfig.getMap("fields");
            if (configFieldsList != null) {
                configField = configFieldsList.getMap(field.getName());
            }
            if (!field.getBoolean("canEdit")) {
                field.put("canEdit", Boolean.FALSE);
                if (configField != null) {
                    configField.put("canEdit", Boolean.FALSE);
                }
            }
            for (Object propertyName : includedField.keySet()) {
                if (propertyName == null || "primaryKey".equals(propertyName) || "foreignKey".equals(propertyName) || "joinType".equals(propertyName) || "required".equals(propertyName) || "conditionallyRequired".equals(propertyName) || "validators".equals(propertyName) || "__cachedType".equals(propertyName) || propertyName.toString().startsWith("editRequires") || propertyName.toString().startsWith("updateRequires") || propertyName.toString().startsWith("initRequires") || "includeVia".equals(propertyName) || field.getProperty("includeSummaryFunction") != null && "displayField".equals(propertyName)) continue;
                if ("type".equals(propertyName)) {
                    if ("sequence".equalsIgnoreCase(includedField.getString(propertyName))) {
                        field.put("type", "integer");
                    } else {
                        field.put(propertyName, includedField.get(propertyName));
                    }
                    if (configField == null) continue;
                    configField.put(propertyName, includedField.get(propertyName));
                    continue;
                }
                if (field.containsKey(propertyName)) continue;
                field.put(propertyName, includedField.get(propertyName));
                if (configField == null) continue;
                configField.put(propertyName, includedField.get(propertyName));
            }
            if (this.handlesRelations()) {
                Object propertyName;
                propertyName = null;
                for (RelationInfo r = includeFromInfo.getRelation(); r != null; r = r.getNextRelation()) {
                    propertyName = propertyName == null ? r.getFromFields().get(0) : propertyName + "/" + r.getFromFields().get(0);
                }
                propertyName = includeFromInfo.getTargetIncludeFrom() != null ? propertyName + "/" + includedField.getValueXPath() : propertyName + "/" + includedFieldName;
                field.put("valueXPath", propertyName);
                if (configField != null) {
                    configField.put("valueXPath", propertyName);
                }
            }
            includeFromInfo.setPrepared(true);
            return includeFromInfo;
        }
        return null;
    }

    public boolean supportsSummaryFunction(String functionName) {
        return false;
    }

    public Class getPropertyJavaClass(String propertyName, DSField field, Object value) throws Exception {
        if (field == null) {
            return null;
        }
        String typeName = field.getProperty("javaClass");
        if (typeName != null) {
            return Reflection.classForName(typeName);
        }
        return null;
    }

    public Class getFieldJavaType(String fieldName) {
        return this.getFieldJavaType(this.getField(fieldName));
    }

    public Class getFieldJavaType(DSField field) {
        return null;
    }

    public void _clearConvertedProperties() {
        this.convertedProps.clear();
    }

    public Class _getPropertyJavaClass(String propertyName, DSField field, Object value) throws Exception {
        if (this.convertedProps.containsKey(field)) {
            return this.convertedProps.get(field);
        }
        Class c = this.getPropertyJavaClass(propertyName, field, value);
        this.convertedProps.put(field, c);
        return c;
    }

    public boolean hasNextRecord(DSResponse response) throws StreamingResponseException {
        throw new StreamingResponseException("Streaming is not supported by this DataSource type");
    }

    public Map streamNextRecord(DSResponse response) throws StreamingResponseException {
        throw new StreamingResponseException("Streaming is not supported by this DataSource type");
    }

    public Object streamNextRecordAsObject(DSResponse response) throws StreamingResponseException {
        throw new StreamingResponseException("Streaming is not supported by this DataSource type");
    }

    public int getProgressiveLoadingThreshold() {
        Object fromConfig = this.dsConfig.get("progressiveLoadingThreshold");
        if (fromConfig == null) {
            return 200000;
        }
        if (fromConfig instanceof Integer) {
            return (Integer)fromConfig;
        }
        return Integer.parseInt(fromConfig.toString());
    }

    public int getLookAhead() {
        Object fromConfig = this.dsConfig.get("lookAhead");
        if (fromConfig == null) {
            return 1;
        }
        if (fromConfig instanceof Integer) {
            return (Integer)fromConfig;
        }
        return Integer.parseInt(fromConfig.toString());
    }

    public int getEndGap() {
        Object fromConfig = this.dsConfig.get("endGap");
        if (fromConfig == null) {
            return 20;
        }
        if (fromConfig instanceof Integer) {
            return (Integer)fromConfig;
        }
        return Integer.parseInt(fromConfig.toString());
    }

    public DSInheritanceMode getInheritanceMode() {
        return DSInheritanceMode.FULL;
    }

    @Override
    public void commit(DSTransaction dsTransaction) throws Exception {
    }

    @Override
    public void rollback(DSTransaction dsTransaction) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpCreateTrace(List<Map> createTrace, String dsName, String filename, boolean dumpStack, boolean dumpConfig) throws Exception {
        List<Map> list = createTrace;
        synchronized (list) {
            PrintStream out;
            if (filename == null) {
                out = System.out;
            } else {
                File file = new File(filename);
                file.createNewFile();
                out = new PrintStream(file);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            out.println("\nDumping Create Trace data for DataSource " + (dsName == null ? "(all)" : dsName + "*"));
            for (Map map : createTrace) {
                String id = (String)map.get("ID");
                if (dsName != null && !id.startsWith(dsName)) continue;
                out.println(sdf.format(new Date((Long)map.get("time"))) + " ID: " + map.get("ID") + ", instanceId: " + map.get("instanceId"));
                if (dumpConfig) {
                    out.println("Config: " + map.get("config"));
                }
                if (!dumpStack) continue;
                out.println("Stacktrace: ");
                StackTraceElement[] ste = (StackTraceElement[])map.get("stack");
                for (int j = 0; j < ste.length; ++j) {
                    out.println(ste[j]);
                }
            }
            out.println("\nEnd of Create Trace data for DataSource " + (dsName == null ? "(all)" : dsName) + "\n");
        }
    }

    public static AdvancedCriteria convertRelativeDates(AdvancedCriteria advancedCriteria) {
        return DataSource.convertRelativeDates(advancedCriteria, null);
    }

    public static AdvancedCriteria convertRelativeDates(AdvancedCriteria advancedCriteria, Date baseDate) {
        advancedCriteria.convertRelativeDates(baseDate);
        return advancedCriteria;
    }

    public static Criterion convertRelativeDates(Criterion criterion) {
        return DataSource.convertRelativeDates(criterion, null, null);
    }

    public static Criterion convertRelativeDates(Criterion criterion, Date baseDate, DataSource ds) {
        return DataSource.convertRelativeDates(criterion, baseDate, ds, false);
    }

    public static Criterion convertRelativeDates(Criterion criterion, Date baseDate, DataSource ds, boolean useEmbeddedTZ) {
        LinkedList<Criterion> newCriterions;
        LogicalCriterion logicalCriterion;
        Date localBaseDate;
        if (criterion == null) {
            return null;
        }
        Date date = localBaseDate = baseDate != null ? baseDate : new Date();
        if (criterion instanceof LogicalCriterion) {
            logicalCriterion = (LogicalCriterion)criterion;
            newCriterions = new LinkedList<Criterion>();
            for (Criterion subCriterion : logicalCriterion.getCriteria()) {
                Criterion newCriterion;
                if (subCriterion == null) continue;
                if (subCriterion instanceof LogicalCriterion) {
                    newCriterion = DataSource.convertRelativeDates(subCriterion, localBaseDate, ds);
                    newCriterions.add(newCriterion);
                    continue;
                }
                newCriterion = DataSource.mapRelativeDate(subCriterion, localBaseDate, ds, useEmbeddedTZ);
                newCriterions.add(newCriterion);
            }
        } else {
            return DataSource.mapRelativeDate(criterion, localBaseDate, ds, useEmbeddedTZ);
        }
        logicalCriterion.setCriteria(newCriterions);
        return criterion;
    }

    public static Criterion mapRelativeDate(Criterion criterion, Date baseDate, DataSource ds, boolean useEmbeddedTZ) {
        Date localBaseDate = baseDate != null ? baseDate : new Date();
        String fieldName = criterion.getFieldName();
        boolean logicalDate = false;
        if (ds != null) {
            String type = ds.getField(fieldName).getType();
            try {
                logicalDate = "date".equals(ds.getSimpleBaseType(type)) && !ds.simpleTypeInheritsFrom(type, "datetime");
            }
            catch (Exception e) {
                log.warn((Object)"Exception deriving field type", e);
            }
        }
        if (criterion instanceof SimpleCriterion && DateUtil.isRelativeDate(criterion.getValue())) {
            ISCGregorianCalendar absoluteDate;
            Map valueMap = (Map)criterion.getValue();
            RelativeDateRangePosition rangePosition = RelativeDateRangePosition.START;
            RelativeDate relativeDate = new RelativeDate((String)valueMap.get("value"), rangePosition);
            String embeddedTZ = (String)valueMap.get("browserTZ");
            if (useEmbeddedTZ && embeddedTZ != null && embeddedTZ.length() > 0) {
                TimeZone clientTZ = TimeZone.getTimeZone("GMT" + embeddedTZ);
                if (clientTZ == null) {
                    log.warn("Error: No valid Java TimeZone for embeddedTZ '" + embeddedTZ + "'.  Using server timezone instead");
                }
                GregorianCalendar work = relativeDate.getAbsoluteDate(localBaseDate, logicalDate, clientTZ);
                absoluteDate = new ISCGregorianCalendar(work);
            } else {
                absoluteDate = new ISCGregorianCalendar(relativeDate.getAbsoluteDate(localBaseDate, logicalDate, null));
            }
            RelativeDateShortcut shortcut = RelativeDateShortcut.parseShortcut((String)valueMap.get("value"));
            if (!logicalDate && shortcut != null && (shortcut.equals((Object)RelativeDateShortcut.YESTERDAY) || shortcut.equals((Object)RelativeDateShortcut.TODAY) || shortcut.equals((Object)RelativeDateShortcut.TOMORROW))) {
                Date startOfDay;
                if (criterion.getOperatorId().equals("equals")) {
                    startOfDay = DateUtil.getStartOf(absoluteDate, Period.DAY, logicalDate).getTime();
                    Date endOfDay = DateUtil.getEndOf(absoluteDate, Period.DAY, logicalDate).getTime();
                    return new DateRangeCriterion(fieldName, "betweenInclusive", startOfDay, endOfDay);
                }
                if (criterion.getOperatorId().equals("notEqual")) {
                    startOfDay = DateUtil.getStartOf(absoluteDate, Period.DAY, logicalDate).getTime();
                    Date endOfDay = DateUtil.getEndOf(absoluteDate, Period.DAY, logicalDate).getTime();
                    DateRangeCriterion dateRangeCriterion = new DateRangeCriterion(fieldName, "betweenInclusive", startOfDay, endOfDay);
                    return new NotCriterion(dateRangeCriterion);
                }
                if (criterion.getOperatorId().equals("lessThan") || criterion.getOperatorId().equals("greaterOrEqual")) {
                    startOfDay = DateUtil.getStartOf(absoluteDate, Period.DAY, logicalDate).getTime();
                    return new SimpleCriterion(fieldName, criterion.getOperatorId(), (Object)startOfDay);
                }
                if (criterion.getOperatorId().equals("greaterThan") || criterion.getOperatorId().equals("lessOrEqual")) {
                    Date endOfDay = DateUtil.getEndOf(absoluteDate, Period.DAY, logicalDate).getTime();
                    return new SimpleCriterion(fieldName, criterion.getOperatorId(), (Object)endOfDay);
                }
                return new SimpleCriterion(fieldName, criterion.getOperatorId(), (Object)absoluteDate);
            }
            return new SimpleCriterion(fieldName, criterion.getOperatorId(), (Object)absoluteDate);
        }
        if (criterion instanceof RelativeDateRangeCriterion) {
            RelativeDate end;
            RelativeDate start;
            Date endDate;
            RelativeDateRangeCriterion rangeCriterion = (RelativeDateRangeCriterion)criterion;
            Date startDate = rangeCriterion.getMin() instanceof Date ? (Date)rangeCriterion.getMin() : null;
            Date date = endDate = rangeCriterion.getMax() instanceof Date ? (Date)rangeCriterion.getMax() : null;
            if (startDate == null && (start = (RelativeDate)rangeCriterion.getMin()) != null) {
                startDate = start.getAbsoluteDate(localBaseDate, logicalDate).getTime();
            }
            if (endDate == null && (end = (RelativeDate)rangeCriterion.getMax()) != null) {
                endDate = end.getAbsoluteDate(localBaseDate, logicalDate).getTime();
            }
            return new DateRangeCriterion(fieldName, criterion.getOperatorId(), startDate, endDate);
        }
        return criterion;
    }

    public String toString() {
        return this.getID() + " DataSource with instanceId " + this.getInstanceId();
    }

    public void createStorage(boolean dropFirst) throws Exception {
    }

    public boolean isCacheable() {
        return true;
    }

    public DataSource() {
        this.TRANSACTION_OBJECT_KEY = null;
        this.checkIsValidSubclass();
    }

    private void checkIsValidSubclass() {
        Class<?> c = this.getClass();
        Class<DataSource> dsc = DataSource.class;
        Class<BasicDataSource> bdsc = BasicDataSource.class;
        if (c != dsc && c != bdsc && !this.isValidSubclass()) {
            log.warn(c + ": Direct subclassing of DataSource is not allowed. Subclass BasicDataSource instead. If you are sure you need to subclass DataSource directly, implement isValidSubclass() returning true.");
        }
    }

    protected boolean isValidSubclass() {
        return false;
    }

    public boolean canQueryTable() throws Exception {
        log.warn("canQueryTable() method called on unsupported DataSource type - returning false");
        return false;
    }

    public void setComponentSchema(boolean componentSchema) {
        this.dsConfig.put("componentSchema", componentSchema);
    }

    public boolean getComponentSchema() {
        Boolean ret = (Boolean)this.dsConfig.get("componentSchema");
        return ret != null && ret != false;
    }

    public List getSortByFields(List sortByFields) {
        ArrayList<String> result = new ArrayList<String>();
        if (sortByFields == null) {
            return result;
        }
        for (String fieldName : sortByFields) {
            String sortByField;
            DSField field;
            boolean ascending = true;
            if (fieldName.startsWith("-")) {
                fieldName = fieldName.substring(1);
                ascending = false;
            }
            if ((field = this.getField(fieldName)) != null && (sortByField = field.getProperty("sortByField")) != null && !"".equals(sortByField.trim())) {
                fieldName = sortByField;
            }
            result.add((ascending ? "" : "-") + fieldName);
        }
        return result;
    }

    @Deprecated
    public Map getRelatedDisplayRecord(String fieldName, Object displayValue) throws Exception {
        return this.getRelatedDisplayRecord(fieldName, displayValue, null);
    }

    public Map getRelatedDisplayRecord(String fieldName, Object displayValue, DSRequest dsRequest) throws Exception {
        DisplayFieldProperties props = this.getIncludedDisplayFieldProperties(fieldName);
        if (props == null) {
            return null;
        }
        DSRequest fetch = new DSRequest(props.fkDataSourceName, OP_FETCH);
        fetch.inheritClientContext(dsRequest);
        if (props.batchUploadCaseSensitive) {
            fetch.setTextMatchStyle("exactCase");
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(props.foreignDisplayFieldName, displayValue);
        fetch.setCriteria(criteria);
        fetch.setOperationId(props.batchUploadOperationId);
        return fetch.execute().getDataMap();
    }

    public DisplayFieldProperties getIncludedDisplayFieldProperties(String fieldName) {
        DisplayFieldProperties props = new DisplayFieldProperties();
        props.fieldName = fieldName;
        DSField field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        String fk = field.getForeignKey();
        if (fk == null || field.get("displayField") == null) {
            return null;
        }
        DSField displayField = this.getField((String)field.get("displayField"));
        if (displayField == null) {
            return null;
        }
        String dfTarget = displayField.getIncludeFrom();
        if (dfTarget == null) {
            return null;
        }
        props.displayFieldName = displayField.getName();
        String[] fkElements = fk.split("\\.");
        String[] dfElements = dfTarget.split("\\.");
        if (fkElements.length == 1) {
            props.fkDataSourceName = this.getName();
            props.fkFieldName = fkElements[0];
        } else {
            props.fkDataSourceName = fkElements[0];
            props.fkFieldName = fkElements[1];
        }
        if (dfElements.length == 1) {
            props.foreignDisplayFieldDataSourceName = this.getName();
            props.foreignDisplayFieldName = dfElements[0];
        } else {
            props.foreignDisplayFieldDataSourceName = dfElements[0];
            props.foreignDisplayFieldName = dfElements[1];
        }
        if (!props.fkDataSourceName.equals(props.foreignDisplayFieldDataSourceName)) {
            log.info("Field " + fieldName + " on DataSource " + this.getName() + " declares a foreignKey and a displayFIeld that target different dataSource. This is rarely correct.");
            return null;
        }
        props.batchUploadOperationId = (String)field.get("batchUploadOperationId");
        if (field.get("batchUploadCaseSensitive") != null && Boolean.parseBoolean(field.get("batchUploadCaseSensitive").toString())) {
            props.batchUploadCaseSensitive = true;
        }
        return props;
    }

    public Object getRelatedDisplayRecordKey(String fieldName, Object displayValue, DSRequest dsRequest) throws Exception {
        Map record = this.getRelatedDisplayRecord(fieldName, displayValue, dsRequest);
        if (record == null) {
            return displayValue;
        }
        DSField field = this.getField(fieldName);
        String fk = field.getForeignKey();
        String[] fkElements = fk.split("\\.");
        String fkname = fkElements.length == 1 ? fkElements[0] : fkElements[1];
        return record.get(fkname);
    }

    @Deprecated
    public Object transformImportValue(String fieldName, Object rawValue, String defaultStrategy) throws Exception {
        return this.transformImportValue(fieldName, rawValue, defaultStrategy, null);
    }

    public Object transformImportValue(String fieldName, Object rawValue, String defaultStrategy, DSRequest dsRequest) throws Exception {
        DisplayFieldProperties props = this.getIncludedDisplayFieldProperties(fieldName);
        Object transformed = null;
        if (props != null) {
            String importStrategy;
            DSField field = this.getField(fieldName);
            String string = importStrategy = field == null ? null : (String)field.get("importStrategy");
            if ("display".equals(importStrategy)) {
                transformed = this.getRelatedDisplayRecordKey(fieldName, rawValue, dsRequest);
            }
            if (("auto".equals(importStrategy) || importStrategy == null) && "display".equals(defaultStrategy)) {
                transformed = this.getRelatedDisplayRecordKey(fieldName, rawValue, dsRequest);
            }
        }
        return transformed;
    }

    public boolean isServerOnly() {
        return this.dsConfig.getBoolean((Object)"serverOnly", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        DataStructCache.disableDsPaths();
        try {
            builtinTypes = new HashMap();
            List paths = config.getCommaSeparatedList("framework.datasources");
            LinkedHashMap<String, Exception> triedPaths = new LinkedHashMap<String, Exception>();
            Iterator j = paths.iterator();
            while (j.hasNext()) {
                String dsDirPath = ISCFile.canonicalizePath((String)j.next());
                String fileName = null;
                try {
                    fileName = dsDirPath + "/" + builtinTypesFile;
                    builtinTypes = (Map)XML.toDSRecords(fileName);
                    if (builtinTypes == null) continue;
                    break;
                }
                catch (Exception e) {
                    triedPaths.put(fileName, e);
                }
            }
            if (builtinTypes.size() == 0) {
                System.out.println("Problem loading builtinTypes.xml");
                for (String path : triedPaths.keySet()) {
                    Exception e = (Exception)triedPaths.get(path);
                    System.out.println("Exception when loading from " + path + ":\n" + DataTools.getStackTrace(e));
                }
            }
            for (String key : builtinTypes.keySet()) {
                Map map = (Map)builtinTypes.get(key);
                Object valObj = map.get("validators");
                if (valObj instanceof List) {
                    List valList = (List)valObj;
                    for (int j2 = 0; j2 < valList.size(); ++j2) {
                        valObj = valList.get(j2);
                        if (!(valObj instanceof Map)) continue;
                        valList.set(j2, new Validator((Map)valObj));
                    }
                    continue;
                }
                if (!(valObj instanceof Map)) continue;
                map.put("validators", new Validator((Map)valObj));
            }
        }
        finally {
            DataStructCache.enableDsPaths();
        }
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new JXPathBeanPointerFactory());
        dynamicBeanMarkerName = config.getString("dynamicBeanMarker");
        try {
            dynamicBeanMarker = dynamicBeanMarkerName == null ? null : Class.forName(dynamicBeanMarkerName);
        }
        catch (Exception e) {
            log.warn((Object)("Error attempting to load dynamic bean marker class " + dynamicBeanMarkerName + ", dynamic beans will not be supported"), e);
            dynamicBeanMarker = null;
        }
        beanConversionLapse = 0L;
        subValuesLapse = 0L;
        subValDSMLapse = 0L;
        subValVCLapse = 0L;
        subValVCHit = 0L;
        subValVCMiss = 0L;
        inSubValueLapse = 0L;
        inSubValueLapse0 = 0L;
        inSubValueLapse1 = 0L;
        inSubValueLapse2 = 0L;
        subPropsLapse = 0L;
        useAxisForSQLDS = config.getBoolean((Object)"useAxisForSQLDS", false);
    }

    public static class DisplayFieldProperties {
        public String fieldName;
        public String displayFieldName;
        public String fkDataSourceName;
        public String fkFieldName;
        public String foreignDisplayFieldDataSourceName;
        public String foreignDisplayFieldName;
        public String batchUploadOperationId;
        public boolean batchUploadCaseSensitive = false;
    }

    public static enum DSInheritanceMode {
        FULL,
        NONE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    static class DataSourcePropertiesMap
    extends LinkedHashMap {
        DataSourcePropertiesMap() {
        }
    }
}

