/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.PoolableDataSourceFactory;
import com.isomorphic.log.Logger;
import com.isomorphic.pool.PoolManager;
import com.isomorphic.util.DataTools;

public class DataSourceManager
extends Base {
    private static Logger log = new Logger(DataSourceManager.class.getName());
    public static PoolManager manager = new PoolManager("datasources", new PoolableDataSourceFactory());
    private static boolean poolDynamicDataSources = Config.getGlobal().getBoolean((Object)"datasources.poolDynamicDataSources", false);
    private static long count = 0L;
    private static long millis = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restartPoolManager() throws Exception {
        Class<DataSourceManager> clazz = DataSourceManager.class;
        synchronized (DataSourceManager.class) {
            manager.close();
            manager = new PoolManager("datasources", new PoolableDataSourceFactory());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void clearPooledInstances(String dsName) throws Exception {
        manager.clearPool(dsName);
    }

    public static void clearAllDataSourceCaches() throws Exception {
    }

    public static DataSource getDataSource(String name) throws Exception {
        return DataSourceManager.getDataSource(name, null);
    }

    public static DataSource getDataSource(String name, DSRequest request) throws Exception {
        return DataSourceManager.getDataSource(name, request, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource getDataSource(String name, DSRequest dsRequest, boolean isSchemaless) throws Exception {
        long start = 0L;
        if (log.isDebugEnabled()) {
            ++count;
            start = System.currentTimeMillis();
        }
        DataSource ds = null;
        Class<DataSourceManager> clazz = DataSourceManager.class;
        synchronized (DataSourceManager.class) {
            ds = !poolDynamicDataSources && DataSource.isDynamic(name) ? (DataSource)manager.borrowUnpooledObject(name, dsRequest, isSchemaless) : (DataSource)manager.borrowObject(name, dsRequest, isSchemaless);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return ds;
        }
    }

    public static DataSource get(String name) throws Exception {
        return DataSourceManager.getDataSource(name);
    }

    public static DataSource get(String name, DSRequest dsRequest) throws Exception {
        return DataSourceManager.getDataSource(name, dsRequest);
    }

    public static DataSource getUnpooledDataSource(String name) throws Exception {
        return (DataSource)manager.borrowUnpooledObject(name);
    }

    public static void freeDataSource(DataSource ds) {
        DataSourceManager.free(ds);
    }

    public static void free(DataSource ds) {
        if (ds == null) {
            return;
        }
        if (!ds.belongsToThread(Thread.currentThread())) {
            if (!"Finalizer".equals(Thread.currentThread().getName())) {
                return;
            }
            log.warn("Allowing the Finalizer thread to passivate instance " + ds.getInstanceId() + " of DataSource '" + ds.getID() + "'");
        }
        ds.clearState();
        if (!poolDynamicDataSources && DataSource.isDynamic(ds.getID())) {
            ds = null;
        } else if (DataTools.getBoolean(ds.getConfig(), "doNotPool")) {
            manager.invalidateObject(ds.getName(), ds);
        } else {
            manager.returnObject(ds.getName(), ds);
        }
    }
}

