/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.applets;

import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppletClassLoader
extends URLClassLoader {
    private static final Log LOG = LogFactory.getLog(AppletClassLoader.class);

    public AppletClassLoader(Window window) {
        super(new URL[0]);
        if (window.getWebWindow().getWebClient().getOptions().isUseInsecureSSL()) {
            LOG.warn((Object)"AppletClassLoader: your WebClient accepts ssl connections without certificate checking.If you like to load applet archives from a SSL/HTTPS connection you have to configureyour jvm to accept untrusted certificate for SSL/HTTPS connections also.");
        }
        try {
            this.loadOurNetscapeStuff("netscape.javascript.JSException");
            Class<?> jsObjectClass = this.loadOurNetscapeStuff("netscape.javascript.JSObject");
            MethodUtils.invokeExactStaticMethod(jsObjectClass, (String)"setWindow", (Object[])new Object[]{window});
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void addArchiveToClassPath(URL jarUrl) {
        this.addURL(jarUrl);
    }

    public void addClassToClassPath(String className, WebResponse webResponse) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)webResponse.getContentAsStream());
        this.defineClass(className, bytes, 0, bytes.length);
    }

    private Class<?> loadOurNetscapeStuff(String classNane) throws IOException {
        String myNetscapeClassName = classNane.replace('.', '/') + ".class";
        Enumeration<URL> locations = this.getClass().getClassLoader().getResources(myNetscapeClassName);
        URL myLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        while (locations.hasMoreElements()) {
            URL pos = locations.nextElement();
            if (!pos.toExternalForm().contains(myLocation.toExternalForm())) continue;
            try (InputStream byteStream = pos.openStream();){
                byte[] bytes = IOUtils.toByteArray((InputStream)byteStream);
                Class<?> clazz = this.defineClass(classNane, bytes, 0, bytes.length);
                return clazz;
            }
        }
        return null;
    }
}

