/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.css.sac.InputSource;

@JsxClass(domClass=HtmlStyle.class)
public class HTMLStyleElement
extends HTMLElement {
    private CSSStyleSheet sheet_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public HTMLStyleElement() {
    }

    @JsxGetter
    public CSSStyleSheet getSheet() {
        if (this.sheet_ != null) {
            return this.sheet_;
        }
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        String css = style.getTextContent();
        Cache cache = this.getWindow().getWebWindow().getWebClient().getCache();
        org.w3c.dom.css.CSSStyleSheet cached = cache.getCachedStyleSheet(css);
        String uri = this.getDomNodeOrDie().getPage().getWebResponse().getWebRequest().getUrl().toExternalForm();
        if (cached != null) {
            this.sheet_ = new CSSStyleSheet((HTMLElement)this, cached, uri);
        } else {
            InputSource source = new InputSource((Reader)new StringReader(css));
            this.sheet_ = new CSSStyleSheet((HTMLElement)this, source, uri);
            cache.cache(css, this.sheet_.getWrappedSheet());
        }
        return this.sheet_;
    }

    @JsxGetter
    public String getType() {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        return style.getTypeAttribute();
    }

    @JsxSetter
    public void setType(String type) {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        style.setTypeAttribute(type);
    }

    @JsxGetter
    public String getMedia() {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        return style.getAttribute("media");
    }

    @JsxSetter
    public void setMedia(String media) {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        style.setAttribute("media", media);
    }

    @JsxGetter(value={SupportedBrowser.FF})
    public boolean isScoped() {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        return style.hasAttribute("scoped");
    }

    @JsxSetter(value={SupportedBrowser.FF})
    public void setScoped(boolean scoped) {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        style.setAttribute("scoped", Boolean.toString(scoped));
    }

    @Override
    @JsxGetter
    public boolean isDisabled() {
        return !this.getSheet().isEnabled();
    }

    @Override
    @JsxSetter
    public void setDisabled(boolean disabled) {
        CSSStyleSheet sheet = this.getSheet();
        boolean modified = disabled == sheet.isEnabled();
        sheet.setEnabled(!disabled);
        if (modified) {
            this.getWindow().clearComputedStyles();
        }
    }
}

