/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import sun.net.ProgressEvent;
import sun.net.ProgressListener;
import sun.net.ProgressSource;
import sun.plugin.util.EventMulticaster;

public class ProgressMonitor
extends sun.net.ProgressMonitor {
    private final ArrayList progressSourceList = new ArrayList();
    private final HashMap threadGroupListenerMap = new HashMap();
    private static volatile Method progressSourceGetProgressMethod;
    private static volatile Method progressSourceGetExpectedMethod;
    private static volatile Method progressEventGetProgressMethod;
    private static volatile Method progressEventGetExpectedMethod;
    private static volatile Constructor progressEventCtor;
    private static volatile boolean usingLongs;
    private static ProgressMonitor instance;
    private static boolean isInstalled;

    private ProgressMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getProgressSources() {
        ArrayList<ProgressSource> arrayList = new ArrayList<ProgressSource>();
        try {
            ArrayList arrayList2 = this.progressSourceList;
            synchronized (arrayList2) {
                for (ProgressSource progressSource : this.progressSourceList) {
                    arrayList.add((ProgressSource)progressSource.clone());
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return arrayList;
    }

    public int getProgressUpdateThreshold() {
        return 65536;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldMeterInput(URL uRL, String string) {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        ProgressListener progressListener = null;
        Object object = this.threadGroupListenerMap;
        synchronized (object) {
            progressListener = (ProgressListener)this.threadGroupListenerMap.get(new Integer(threadGroup.hashCode()));
        }
        if (progressListener == null) {
            return false;
        }
        object = uRL.getProtocol();
        return (((String)object).equalsIgnoreCase("http") || ((String)object).equalsIgnoreCase("https") || ((String)object).equalsIgnoreCase("file")) && string.equalsIgnoreCase("GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSource(ProgressSource progressSource) {
        Object object = this.progressSourceList;
        synchronized (object) {
            if (this.progressSourceList.contains(progressSource)) {
                return;
            }
            this.progressSourceList.add(progressSource);
        }
        object = Thread.currentThread();
        ThreadGroup threadGroup = ((Thread)object).getThreadGroup();
        ProgressListener progressListener = null;
        HashMap hashMap = this.threadGroupListenerMap;
        synchronized (hashMap) {
            progressListener = (ProgressListener)this.threadGroupListenerMap.get(new Integer(threadGroup.hashCode()));
        }
        if (progressListener != null) {
            hashMap = ProgressMonitor.newProgressEvent(progressSource);
            progressListener.progressStart((ProgressEvent)hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSource(ProgressSource progressSource) {
        Object object = this.progressSourceList;
        synchronized (object) {
            if (!this.progressSourceList.contains(progressSource)) {
                return;
            }
            progressSource.close();
            this.progressSourceList.remove(progressSource);
        }
        object = Thread.currentThread();
        ThreadGroup threadGroup = ((Thread)object).getThreadGroup();
        ProgressListener progressListener = null;
        HashMap hashMap = this.threadGroupListenerMap;
        synchronized (hashMap) {
            progressListener = (ProgressListener)this.threadGroupListenerMap.get(new Integer(threadGroup.hashCode()));
        }
        if (progressListener != null) {
            hashMap = ProgressMonitor.newProgressEvent(progressSource);
            progressListener.progressFinish((ProgressEvent)hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgress(ProgressSource progressSource) {
        Object object = this.progressSourceList;
        synchronized (object) {
            if (!this.progressSourceList.contains(progressSource)) {
                return;
            }
        }
        object = Thread.currentThread();
        ThreadGroup threadGroup = ((Thread)object).getThreadGroup();
        ProgressListener progressListener = null;
        HashMap hashMap = this.threadGroupListenerMap;
        synchronized (hashMap) {
            progressListener = (ProgressListener)this.threadGroupListenerMap.get(new Integer(threadGroup.hashCode()));
        }
        if (progressListener != null) {
            hashMap = ProgressMonitor.newProgressEvent(progressSource);
            progressListener.progressUpdate((ProgressEvent)hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ThreadGroup threadGroup, ProgressListener progressListener) {
        Trace.msgPrintln((String)"progress.listener.added", (Object[])new Object[]{progressListener}, (TraceLevel)TraceLevel.BASIC);
        ProgressMonitor.install();
        Integer n = threadGroup != null ? new Integer(threadGroup.hashCode()) : new Integer(0);
        HashMap hashMap = this.threadGroupListenerMap;
        synchronized (hashMap) {
            ProgressListener progressListener2 = (ProgressListener)this.threadGroupListenerMap.get(n);
            progressListener2 = EventMulticaster.add(progressListener2, progressListener);
            this.threadGroupListenerMap.put(n, progressListener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ThreadGroup threadGroup, ProgressListener progressListener) {
        Trace.msgPrintln((String)"progress.listener.removed", (Object[])new Object[]{progressListener}, (TraceLevel)TraceLevel.BASIC);
        HashMap hashMap = this.threadGroupListenerMap;
        synchronized (hashMap) {
            ProgressListener progressListener2 = (ProgressListener)this.threadGroupListenerMap.get(new Integer(threadGroup.hashCode()));
            progressListener2 = EventMulticaster.remove(progressListener2, progressListener);
            if (progressListener2 != null) {
                this.threadGroupListenerMap.put(new Integer(threadGroup.hashCode()), progressListener2);
            } else {
                this.threadGroupListenerMap.remove(new Integer(threadGroup.hashCode()));
            }
        }
    }

    public static long getProgress(ProgressEvent progressEvent) {
        if (progressEventGetProgressMethod == null) {
            progressEventGetProgressMethod = ProgressMonitor.getProgressEventMethod("getProgress");
        }
        try {
            return ((Number)progressEventGetProgressMethod.invoke((Object)progressEvent, null)).longValue();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static long getExpected(ProgressEvent progressEvent) {
        if (progressEventGetExpectedMethod == null) {
            progressEventGetExpectedMethod = ProgressMonitor.getProgressEventMethod("getExpected");
        }
        try {
            return ((Number)progressEventGetExpectedMethod.invoke((Object)progressEvent, null)).longValue();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Method getProgressSourceMethod(final String string) {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Method method = ProgressSource.class.getDeclaredMethod(string, null);
                    method.setAccessible(true);
                    return method;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    private static long getProgress(ProgressSource progressSource) {
        if (progressSourceGetProgressMethod == null) {
            progressSourceGetProgressMethod = ProgressMonitor.getProgressSourceMethod("getProgress");
        }
        try {
            return ((Number)progressSourceGetProgressMethod.invoke((Object)progressSource, null)).longValue();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static long getExpected(ProgressSource progressSource) {
        if (progressSourceGetExpectedMethod == null) {
            progressSourceGetExpectedMethod = ProgressMonitor.getProgressSourceMethod("getExpected");
        }
        try {
            return ((Number)progressSourceGetExpectedMethod.invoke((Object)progressSource, null)).longValue();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Method getProgressEventMethod(final String string) {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Method method = ProgressEvent.class.getDeclaredMethod(string, null);
                    method.setAccessible(true);
                    return method;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    private static Constructor getProgressEventConstructor(boolean bl) {
        try {
            return ProgressEvent.class.getDeclaredConstructor(ProgressSource.class, URL.class, String.class, String.class, ProgressSource.State.class, bl ? Long.TYPE : Integer.TYPE, bl ? Long.TYPE : Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static ProgressEvent newProgressEvent(ProgressSource progressSource) {
        if (progressEventCtor == null) {
            progressEventCtor = (Constructor)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Constructor constructor = ProgressMonitor.getProgressEventConstructor(true);
                        if (constructor != null) {
                            usingLongs = true;
                        } else {
                            constructor = ProgressMonitor.getProgressEventConstructor(false);
                        }
                        constructor.setAccessible(true);
                        return constructor;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
        }
        long l = ProgressMonitor.getProgress(progressSource);
        long l2 = ProgressMonitor.getExpected(progressSource);
        Number number = null;
        Number number2 = null;
        if (usingLongs) {
            number = new Long(l);
            number2 = new Long(l2);
        } else {
            number = new Integer((int)l);
            number2 = new Integer((int)l2);
        }
        try {
            return (ProgressEvent)progressEventCtor.newInstance(progressSource, progressSource.getURL(), progressSource.getMethod(), progressSource.getContentType(), progressSource.getState(), number, number2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void warmup() {
        ProgressMonitor.install();
    }

    private static synchronized void install() {
        Trace.println((String)("Installing progress monitor " + isInstalled), (TraceLevel)TraceLevel.PRELOADER);
        try {
            if (!isInstalled) {
                sun.net.ProgressMonitor.setDefault((sun.net.ProgressMonitor)instance);
            }
        }
        catch (Throwable throwable) {
            Trace.ignored((Throwable)throwable);
        }
        isInstalled = true;
    }

    public static ProgressMonitor get() {
        return instance;
    }

    static ProgressEvent unusedCreateProgressEvent(ProgressSource progressSource) {
        return new ProgressEvent(progressSource, progressSource.getURL(), progressSource.getMethod(), progressSource.getContentType(), progressSource.getState(), progressSource.getProgress(), progressSource.getExpected());
    }

    static {
        instance = new ProgressMonitor();
        isInstalled = false;
    }
}

