/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.Relation;
import com.isomorphic.datasource.SummaryFunctionType;
import com.isomorphic.datasource.UnionDataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.DBType;
import com.isomorphic.sql.SQLAnsiJoinClause;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLJoinWhereClause;
import com.isomorphic.sql.SQLOrderClause;
import com.isomorphic.sql.SQLTableClause;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SQLSelectClause
extends Base {
    private static Logger log = new Logger(SQLSelectClause.class.getName());
    private List dataSources;
    private Map remapTable;
    private Map column2TableMap = new HashMap();
    private boolean qualifyColumnNames = true;
    private List customValueFields = null;
    private DSRequest request;
    private Boolean useAnsiJoins;
    private String groupByString = null;
    private String groupByWithAliasString = null;
    private boolean ignoreOutputs = false;
    private List<String> summaryFunctionFields;

    public SQLSelectClause(List dataSources) throws Exception {
        this.dataSources = dataSources;
        this.remapTable = SQLDataSource.getField2ColumnMap(dataSources);
        if (dataSources.size() > 1) {
            this.column2TableMap = SQLDataSource.getColumn2TableMap(dataSources);
        }
    }

    public SQLSelectClause(SQLDataSource ds) throws Exception {
        this(DataTools.makeList((Object)((Object)ds)));
    }

    public SQLSelectClause(DSRequest request, SQLDataSource ds, boolean qualifyColumnNames) throws Exception {
        this(request, DataTools.makeList((Object)((Object)ds)), qualifyColumnNames);
    }

    public SQLSelectClause(DSRequest request, List dataSources, boolean qualifyColumnNames) throws Exception {
        this(dataSources);
        this.request = request;
        List summaryColumns = request.getSummaryFields();
        if (summaryColumns != null && !summaryColumns.isEmpty()) {
            this.remapTable = DataTools.subsetMap((Map)this.remapTable, (List)summaryColumns, (boolean)true);
        } else {
            DataSource ds = (DataSource)dataSources.get(0);
            List outputColumns = request.getConsolidatedOutputs();
            boolean bl = this.ignoreOutputs = outputColumns == null;
            if (outputColumns != null) {
                this.remapTable = DataTools.subsetMap((Map)this.remapTable, (List)outputColumns, (boolean)true);
            }
        }
        this.qualifyColumnNames = qualifyColumnNames;
    }

    public SQLSelectClause(DSRequest request, List outputColumns, List dataSources, boolean qualifyColumnNames) throws Exception {
        this(dataSources);
        List summaryColumns = request.getSummaryFields();
        if (summaryColumns != null && !summaryColumns.isEmpty()) {
            this.remapTable = DataTools.subsetMap((Map)this.remapTable, (List)summaryColumns, (boolean)true);
        } else if (outputColumns != null) {
            this.remapTable = DataTools.subsetMap((Map)this.remapTable, (List)outputColumns, (boolean)true);
        }
        this.qualifyColumnNames = qualifyColumnNames;
    }

    public SQLSelectClause(DSRequest request, List outputColumns, SQLDataSource ds, boolean qualifyColumnNames) throws Exception {
        this(request, outputColumns, DataTools.makeList((Object)((Object)ds)), qualifyColumnNames);
    }

    public List getCustomValueFields() {
        return this.customValueFields;
    }

    public void setCustomValueFields(List fields) {
        this.customValueFields = fields;
    }

    public String toString(SQLDriver driver) throws Exception {
        return this.getSQLString(driver);
    }

    public String getSQLString() throws Exception {
        return this.getSQLString(((SQLDataSource)((Object)this.dataSources.get(0))).getDriver());
    }

    public String getSQLString(SQLDriver driver) throws Exception {
        SQLOrderClause orderClause;
        DataTypeMap operationBinding;
        String order;
        String opType = this.request.getOperationType();
        String opId = this.request.getOperationId();
        DataSource ds = (DataSource)this.dataSources.get(0);
        SQLDataSource sqlds = (SQLDataSource)ds;
        DataTypeMap opBinding = ds.getOperationBinding(opType, opId);
        boolean vanillaFetch = false;
        boolean unionMode = Boolean.TRUE.equals(this.request.getAttribute("unionMode"));
        UnionDataSource unionDs = (UnionDataSource)this.request.getAttribute("unionDataSource");
        if (opBinding != null && !this.request.isSummary()) {
            if (opBinding.get("customSQL") == null && opBinding.get("selectClause") == null && opBinding.get("tableClause") == null && opBinding.get("whereClause") == null && opBinding.get("groupClause") == null && opBinding.get("orderClause") == null && opBinding.get("valueClause") == null) {
                vanillaFetch = true;
            }
        } else {
            vanillaFetch = true;
        }
        this.useAnsiJoins = DataTools.asBooleanObject((Object)this.request.getDataSource().getConfig().get((Object)"useAnsiJoins"));
        if (this.useAnsiJoins == null) {
            this.useAnsiJoins = config.getBoolean((Object)"sql.useAnsiJoins", false);
        }
        if (this.request.getOutputs() != null && Boolean.TRUE.equals(this.request.getAttribute("enforceOutputsFieldOrder"))) {
            this.remapTable = this.orderRemapTableByOutputs(this.request.getOutputs());
        }
        ArrayList<String> sortFields = null;
        if (this.request.isPaged() && driver.supportsSQLLimit() && sqlds.shouldForceSort(this.request) && !driver.supportsOffsetFetch() && ((order = (String)((operationBinding = ds.getOperationBinding(this.request)) == null ? null : operationBinding.get("orderClause"))) == null || "$defaultOrderClause".equals(order.trim())) && "".equals((orderClause = new SQLOrderClause(this.request, this.dataSources, true)).getSQLString())) {
            String dft = ds.getConfig().getString((Object)"defaultSortField");
            if (dft != null) {
                if (sortFields == null) {
                    sortFields = new ArrayList<String>();
                }
                sortFields.add(dft);
                if (!this.remapTable.containsKey(dft)) {
                    this.remapTable.put(dft, dft);
                }
            } else {
                for (String pk : ((DataSource)this.dataSources.get(0)).getPrimaryKeys()) {
                    if (sortFields == null) {
                        sortFields = new ArrayList();
                    }
                    sortFields.add(pk);
                    if (this.remapTable.containsKey(pk)) continue;
                    this.remapTable.put(pk, pk);
                }
            }
        }
        StringBuffer result = new StringBuffer();
        StringBuffer groupByResult = new StringBuffer();
        StringBuffer groupByWithAliasResult = new StringBuffer();
        for (String rsName : this.remapTable.keySet()) {
            DataSource firstDS;
            String tableName;
            boolean sortField;
            boolean includeOnlyInGroupBy = false;
            List groupByList = this.request.getGroupBy();
            boolean bl = sortField = sortFields != null && sortFields.contains(rsName);
            if (!(this.ignoreOutputs || sortField || this.request.getConsolidatedOutputs() == null || this.request.getConsolidatedOutputs().contains(rsName))) {
                if (!this.request.isSummary() || groupByList == null || !groupByList.contains(rsName)) continue;
                includeOnlyInGroupBy = true;
            }
            if (this.request.skipField(rsName) && !sortField || this.request.getDroppedFields() != null && this.request.getDroppedFields().contains(rsName)) continue;
            String columnName = (String)this.remapTable.get(rsName);
            if (columnName != null && columnName.contains(".")) {
                columnName = columnName.substring(columnName.lastIndexOf(".") + 1);
            }
            String string = tableName = this.qualifyColumnNames ? (String)this.column2TableMap.get(columnName) : null;
            if (tableName == null && this.qualifyColumnNames && (firstDS = (DataSource)this.dataSources.get(0)) instanceof SQLDataSource) {
                tableName = ((SQLDataSource)firstDS).getTable().getNameQuotedIfNecessary((SQLDataSource)firstDS);
            }
            boolean skipCustomSQLCheck = false;
            if (this.customValueFields != null) {
                Iterator i = this.customValueFields.iterator();
                while (i.hasNext()) {
                    if (!i.next().equals(rsName)) continue;
                    skipCustomSQLCheck = true;
                    break;
                }
            }
            boolean exclude = false;
            DSField field = null;
            for (int i = 0; i < this.dataSources.size(); ++i) {
                ds = (DataSource)this.dataSources.get(i);
                field = ds.getField(rsName);
                if (unionMode && field == null) {
                    field = ds.getField(unionDs.getOriginalFieldName(ds, rsName, this.request));
                }
                if (field == null) continue;
                if (field.getIncludeFromDefinition(this.request) != null) {
                    if (unionMode) {
                        this.addSQLForJoinedField(field, driver, result, groupByResult, groupByWithAliasResult);
                        if (!field.getName().equals(rsName)) {
                            String badRename = "AS " + field.getName();
                            if (badRename.equals(result.substring(result.length() - badRename.length()))) {
                                result.delete(result.length() - badRename.length(), result.length());
                            }
                            result.append(" AS " + rsName);
                        }
                    }
                    exclude = true;
                    break;
                }
                if (!skipCustomSQLCheck && field.getBoolean("customSQL")) {
                    if (unionMode) {
                        columnName = null;
                        break;
                    }
                    exclude = true;
                    break;
                }
                if (field.get((Object)"tableName") != null && vanillaFetch) {
                    exclude = true;
                    break;
                }
                if (field.isInapplicable()) {
                    exclude = true;
                    break;
                }
                if (this.qualifyColumnNames && field.get((Object)"tableName") != null) {
                    tableName = field.get((Object)"tableName").toString();
                }
                if (!DataSource.simpleTypeInheritsFromBuiltInType((String)field.getType(), (String)"binary")) break;
                boolean includeBinaryField = false;
                if (this.request.isClientRequest() && (this.request.isDownload() || field.shouldEncodeInResponse())) {
                    includeBinaryField = true;
                }
                if (!includeBinaryField && this.request.getIncludeBinaryFields()) {
                    includeBinaryField = true;
                }
                if (!includeBinaryField && this.request.getConsolidatedOutputs() != null && this.request.getConsolidatedOutputs().contains(rsName)) {
                    includeBinaryField = true;
                }
                List sortByFields = this.request.getSortByFields();
                if (!includeBinaryField && sortByFields != null && !sortByFields.isEmpty()) {
                    for (int y = 0; y < sortByFields.size(); ++y) {
                        DataTypeMap operationBinding2;
                        String paging;
                        String sortByField = (String)sortByFields.get(y);
                        if (sortByField.startsWith("-")) {
                            sortByField = sortByField.substring(1);
                        }
                        if (!sortByField.equals(rsName) || !this.request.isPaged() || "none".equals(paging = SQLDataSource.getPaging(this.request, (Map)(operationBinding2 = this.request.getDataSource().getOperationBinding(this.request.getOperationType(), this.request.getOperationId())), (SQLDataSource)ds))) continue;
                        includeBinaryField = true;
                    }
                }
                if (includeBinaryField) break;
                exclude = true;
                break;
            }
            DSField unionDSField = null;
            String unionDSFType = null;
            if (field == null && this.request != null && this.request.getDataSource() != null && (unionDSField = unionDs.getUnionField(rsName, this.request)) != null) {
                unionDSFType = this.request.getDataSource().getSimpleBaseType(unionDSField.getType());
            }
            if (exclude) continue;
            String functionName = null;
            Map summaryFunctionMap = this.request.getSummaryFunctions();
            if (summaryFunctionMap != null && summaryFunctionMap.containsKey(rsName)) {
                functionName = ((SummaryFunctionType)summaryFunctionMap.get(rsName)).getFunctionName();
            }
            if ("CONCAT".equalsIgnoreCase(functionName) && driver.getDBType() != DBType.Oracle && !this.isConcatFetch(ds, rsName)) continue;
            if (!includeOnlyInGroupBy && result.length() != 0) {
                result.append(", ");
            }
            if (field != null && "relatedCount".equals(field.getProperty("type")) && !includeOnlyInGroupBy) {
                result.append(this.aggregationSubSelect(driver, columnName, rsName, tableName, field));
                continue;
            }
            if (field != null && (field.getProperty("customSelectExpression") != null || field.getProperty("customSQLExpression") != null)) {
                if (!includeOnlyInGroupBy) {
                    result.append(this.customSQLExpression(driver, field, functionName, true));
                }
                if (groupByList == null || !groupByList.contains(rsName)) continue;
                if (groupByResult.length() != 0) {
                    groupByResult.append(", ");
                }
                groupByResult.append(this.customSQLExpression(driver, field, functionName, false));
                if (groupByWithAliasResult.length() != 0) {
                    groupByWithAliasResult.append(", ");
                }
                groupByWithAliasResult.append(this.customSQLExpression(driver, field, functionName, true));
                continue;
            }
            if (!includeOnlyInGroupBy) {
                String thisTableName = tableName;
                if (unionMode) {
                    String originalName = unionDs.getOriginalFieldName(ds, rsName, this.request);
                    if (ds.getField(originalName) == null) {
                        originalName = null;
                    }
                    if (originalName != null) {
                        columnName = originalName;
                    } else {
                        DSField renamedField = unionDs.getRenamedField(ds, ds.getField(columnName));
                        if (renamedField != null && !ds.getField(columnName).getName().equals(unionDs.getOriginalFieldName(ds, ds.getField(columnName).getName()))) {
                            columnName = null;
                        }
                    }
                    if (columnName == null) {
                        thisTableName = null;
                    }
                }
                result.append(driver.sqlOutTransform(columnName, rsName, thisTableName, functionName, (Map)field, unionDSFType));
            }
            if (groupByList == null || !groupByList.contains(rsName)) continue;
            if (groupByResult.length() != 0) {
                groupByResult.append(", ");
            }
            groupByResult.append(driver.sqlOutTransform(columnName, null, tableName, null, null, unionDSFType));
            if (groupByWithAliasResult.length() != 0) {
                groupByWithAliasResult.append(", ");
            }
            groupByWithAliasResult.append(driver.sqlOutTransform(columnName, rsName, tableName, null, null, unionDSFType));
        }
        if (!unionMode) {
            this.addSQLForJoinedFields(driver, result, groupByResult, groupByWithAliasResult);
        }
        if (groupByResult != null && groupByResult.length() > 0) {
            this.groupByString = groupByResult.toString();
            this.groupByWithAliasString = groupByWithAliasResult.toString();
        }
        if (this.summaryFunctionFields != null && !this.summaryFunctionFields.isEmpty()) {
            this.request.setSummaryFunctionFields(this.summaryFunctionFields);
        }
        if (result.length() == 0) {
            log.warning((Object)"SQLSelectClause is null or zero size, remap and conversions won't work!");
            return "*";
        }
        return result.toString();
    }

    private void addSQLForJoinedField(DSField field, SQLDriver driver, StringBuffer sbSelect, StringBuffer sbGroupBy, StringBuffer sbGroupByWithAlias) throws Exception {
        IncludeFromDefinition incFrom = field.getIncludeFromDefinition(this.request);
        if (incFrom.isInError() || incFrom.isCriteria() && !this.request.selectCriteriaFields() || incFrom.isSortBy() && !this.request.selectSortByFields()) {
            return;
        }
        this._addSQLForJoinedField(incFrom, driver, sbSelect, sbGroupBy, sbGroupByWithAlias);
    }

    private void addSQLForJoinedFields(SQLDriver driver, StringBuffer sbSelect, StringBuffer sbGroupBy, StringBuffer sbGroupByWithAlias) throws Exception {
        if (this.request.getIncludeFrom() == null || this.request.getIncludeFrom().size() == 0) {
            return;
        }
        for (IncludeFromDefinition incFrom : this.request.getIncludeFrom()) {
            if (incFrom.isInError() || incFrom.isCriteria() && !this.request.selectCriteriaFields() || incFrom.isSortBy() && !this.request.selectSortByFields()) continue;
            this._addSQLForJoinedField(incFrom, driver, sbSelect, sbGroupBy, sbGroupByWithAlias);
        }
    }

    private void _addSQLForJoinedField(IncludeFromDefinition incFrom, SQLDriver driver, StringBuffer sbSelect, StringBuffer sbGroupBy, StringBuffer sbGroupByWithAlias) throws Exception {
        DataSource thisDS = incFrom.getThisDataSource();
        String thisFieldName = incFrom.getThisFieldName();
        DSField thisField = incFrom.getThisField();
        if (thisField != null && thisField.getBoolean("customSQL")) {
            boolean skipField = true;
            if (this.customValueFields != null) {
                Iterator j = this.customValueFields.iterator();
                while (j.hasNext()) {
                    if (!j.next().equals(thisFieldName)) continue;
                    skipField = false;
                    break;
                }
            }
            if (skipField) {
                return;
            }
        }
        IncludeFromDefinition topIncFrom = incFrom;
        IncludeFromDefinition target = incFrom.getTargetIncludeFrom();
        while (target != null && incFrom.getDataSource() instanceof SQLDataSource) {
            incFrom = target;
            target = incFrom.getTargetIncludeFrom();
        }
        if (!(incFrom.getDataSource() instanceof SQLDataSource)) {
            return;
        }
        if (!this.request.isSummary() && thisField != null && thisField.getProperty("includeSummaryFunction") != null) {
            this.addSubSelectForIncludeSummaryField(topIncFrom, incFrom, driver, sbSelect);
            return;
        }
        String fieldName = incFrom.getIncludedFieldName();
        String columnName = incFrom.getIncludedField().getNativeName();
        if (columnName == null) {
            columnName = fieldName;
        }
        SQLDataSource relatedDS = (SQLDataSource)incFrom.getDataSource();
        String tableName = relatedDS.getTable().getNameQuotedIfNecessary(relatedDS);
        String alias = incFrom.getAlias();
        if (alias != null) {
            tableName = alias;
        }
        if (this.request.isSummary() && !this.request.getSummaryFields().contains(thisFieldName)) {
            return;
        }
        String functionName = null;
        Map summaryFunctionsMap = this.request.getSummaryFunctions();
        if (summaryFunctionsMap != null && summaryFunctionsMap.containsKey(thisFieldName)) {
            functionName = ((SummaryFunctionType)summaryFunctionsMap.get(thisFieldName)).getFunctionName();
        }
        if ("CONCAT".equalsIgnoreCase(functionName) && driver.getDBType() != DBType.Oracle && !this.isConcatFetch(thisDS, thisFieldName)) {
            return;
        }
        if (sbSelect.length() > 0) {
            sbSelect.append(", ");
        }
        if (thisField != null && (thisField.getProperty("customSelectExpression") != null || thisField.getProperty("customSQLExpression") != null)) {
            sbSelect.append(this.customSQLExpression(driver, thisField, functionName, true));
            List groupByList = this.request.getGroupBy();
            if (groupByList != null && groupByList.contains(thisFieldName)) {
                if (sbGroupBy.length() != 0) {
                    sbGroupBy.append(", ");
                }
                sbGroupBy.append(this.customSQLExpression(driver, thisField, functionName, false));
                if (sbGroupByWithAlias.length() != 0) {
                    sbGroupByWithAlias.append(", ");
                }
                sbGroupByWithAlias.append(this.customSQLExpression(driver, thisField, functionName, true));
            }
        } else {
            UnionDataSource unionDs = (UnionDataSource)this.request.getAttribute("unionDataSource");
            DSField unionDSField = null;
            String unionDSFType = null;
            if (columnName == null) {
                unionDSField = unionDs.getField(thisField.getName());
                unionDSFType = this.request.getDataSource().getSimpleBaseType(unionDSField.getType());
            }
            sbSelect.append(relatedDS.getDriver().sqlOutTransform(columnName, thisFieldName, tableName, functionName, (Map)incFrom.getThisField(), unionDSFType));
            List groupByList = this.request.getGroupBy();
            if (groupByList != null && groupByList.contains(thisFieldName)) {
                if (sbGroupBy.length() != 0) {
                    sbGroupBy.append(", ");
                }
                sbGroupBy.append(driver.sqlOutTransform(columnName, null, tableName, null, null, unionDSFType));
                if (sbGroupByWithAlias.length() != 0) {
                    sbGroupByWithAlias.append(", ");
                }
                sbGroupByWithAlias.append(driver.sqlOutTransform(columnName, thisFieldName, tableName, null, null, unionDSFType));
            }
        }
    }

    private void addSubSelectForIncludeSummaryField(IncludeFromDefinition topIncFrom, IncludeFromDefinition incFrom, SQLDriver driver, StringBuffer sbSelect) throws Exception {
        DSField thisField = incFrom.getThisField();
        String thisFieldName = topIncFrom.getThisFieldName();
        String fieldName = incFrom.getIncludedFieldName();
        String columnName = incFrom.getIncludedField().getNativeName();
        if (columnName == null) {
            columnName = fieldName;
        }
        SQLDataSource relatedDS = (SQLDataSource)incFrom.getDataSource();
        SQLDataSource thisDS = (SQLDataSource)incFrom.getThisDataSource();
        String tableName = relatedDS.getTable().getNameQuotedIfNecessary(relatedDS);
        String summaryFunction = thisField.getProperty("includeSummaryFunction");
        if ("FIRST".equals(summaryFunction.toUpperCase())) {
            summaryFunction = "MIN";
        }
        String alias = null;
        for (Relation lastRelation = incFrom.getRelation(); lastRelation != null; lastRelation = lastRelation.getNextRelation()) {
            alias = lastRelation.getToAlias();
        }
        if (!thisDS.supportsSummaryFunction(summaryFunction)) {
            log.warn((Object)("Function name: '" + summaryFunction + "' specified in summaryFunction attribute for field '" + thisDS.getName() + "." + thisFieldName + "' is not supported by this type of data source. Skipping."));
            return;
        }
        StringBuffer subSelect = null;
        if ("CONCAT".equalsIgnoreCase(summaryFunction) && driver.getDBType() != DBType.Oracle) {
            if (this.isConcatFetch((DataSource)thisDS, thisFieldName)) {
                subSelect = new StringBuffer();
                subSelect.append(relatedDS.getDriver().sqlOutTransform(columnName, null, alias != null ? alias : tableName, null, (Map)incFrom.getThisField()));
            } else {
                return;
            }
        }
        if (subSelect == null) {
            subSelect = new StringBuffer();
            subSelect.append("(SELECT ");
            subSelect.append(relatedDS.getDriver().sqlOutTransform(columnName, thisFieldName, alias != null ? alias : tableName, summaryFunction, (Map)incFrom.getThisField()));
            SQLTableClause tableClause = new SQLTableClause(this.request, this.useAnsiJoins != false ? DataTools.makeList((Object)topIncFrom.getRelation().getToDataSource()) : null, topIncFrom);
            subSelect.append(" FROM ");
            subSelect.append(tableClause.getSQLString());
            if (this.useAnsiJoins.booleanValue()) {
                String subAlias = topIncFrom.getRelation().getToAlias();
                if (subAlias != null) {
                    subSelect.append(" ");
                    subSelect.append(subAlias);
                }
                SQLAnsiJoinClause joinClause = new SQLAnsiJoinClause(this.request, this.dataSources, topIncFrom, this.qualifyColumnNames);
                subSelect.append(joinClause.getSQLString());
            }
            SQLJoinWhereClause whereClause = new SQLJoinWhereClause(this.request, this.dataSources, topIncFrom, this.qualifyColumnNames);
            subSelect.append(" WHERE " + whereClause.getSQLString() + ")");
        }
        if (sbSelect.length() > 0) {
            sbSelect.append(", ");
        }
        sbSelect.append(subSelect.toString());
        sbSelect.append(" AS " + driver.escapeColumnName(thisFieldName));
    }

    public String getGroupByString() {
        return this.groupByString;
    }

    public String getGroupByWithAliasString() {
        return this.groupByWithAliasString;
    }

    public boolean isGroupBy() {
        return this.groupByString != null;
    }

    public boolean isJoin() {
        return this.dataSources.size() > 1;
    }

    protected String aggregationSubSelect(SQLDriver driver, String columnName, String rsName, String tableName, DSField field) throws Exception {
        String relatedTable = field.getProperty("relatedTable");
        String relatedColumn = field.getProperty("relatedColumn");
        String localField = field.getProperty("localField");
        String subselect = " (SELECT ";
        subselect = subselect + "COUNT";
        subselect = subselect + "(";
        subselect = subselect + "*";
        subselect = subselect + ") FROM ";
        subselect = subselect + field.getProperty("relatedTable");
        subselect = subselect + " WHERE ";
        subselect = subselect + driver.sqlOutTransform(localField, localField, tableName, null, null);
        subselect = subselect + " = ";
        subselect = subselect + driver.sqlOutTransform(relatedColumn, relatedColumn, relatedTable, null, null);
        subselect = subselect + ") AS ";
        subselect = subselect + field.getName();
        return subselect;
    }

    protected String customSQLExpression(SQLDriver driver, DSField field) throws Exception {
        return this.customSQLExpression(driver, field, null, true);
    }

    protected String customSQLExpression(SQLDriver driver, DSField field, String functionName, boolean addAlias) throws Exception {
        String expression = field.getProperty("customSelectExpression");
        if (expression == null) {
            expression = field.getProperty("customSQLExpression");
        }
        Map context = Velocity.getStandardContextMap((DSRequest)this.request);
        boolean searchForVelocityVariables = config.getBoolean((Object)"velocity.searchForVariables.enabled", true);
        if (!searchForVelocityVariables || expression.contains("$")) {
            expression = Velocity.evaluateWithSnippets((String)expression, (Map)context, (String)"customSelectExpression", (DSRequest)this.request, (boolean)field.getBoolean("autoQuoteCustomExpressions", true), (boolean)false);
        }
        if (functionName != null) {
            expression = driver.sqlOutTransformFunction(expression, functionName, (Map)field);
        }
        if (addAlias) {
            expression = expression + " AS ";
            expression = expression + field.getName();
        }
        return expression;
    }

    protected boolean isConcatFetch(DataSource ds, String fieldName) {
        if (this.request.isConcatFetchRequest()) {
            return true;
        }
        if (this.request.shouldStreamResults()) {
            log.warn((Object)("Field '" + ds.getName() + "." + fieldName + "' is configured to use 'CONCAT' summaryFunction and  DSRequest.streamResults is enabled. Both these features are not allowed in same request. Field will be skipped."));
            return false;
        }
        if (this.summaryFunctionFields == null) {
            this.summaryFunctionFields = new ArrayList<String>();
        }
        this.summaryFunctionFields.add(fieldName);
        return false;
    }

    protected Map orderRemapTableByOutputs(List outputs) {
        LinkedHashMap<String, String> work = new LinkedHashMap<String, String>();
        for (int i = 0; i < outputs.size(); ++i) {
            work.put((String)outputs.get(i), (String)this.remapTable.get(outputs.get(i)));
        }
        this.remapTable = work;
        return this.remapTable;
    }
}

