/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.store;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.file.ISCFileSourceFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.store.ExpiringCache;
import com.isomorphic.store.ExpiringValue;
import com.isomorphic.store.ProcessedFileCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.keyvalue.MultiKey;

public class DataStructCache
extends Base {
    private static Logger log = new Logger(DataStructCache.class.getName());
    private static JSTranslater jsTrans = JSTranslater.instance();
    private static boolean enableUpToDateCheck = false;
    private static boolean enableUpToDateCheckForComponentSchema;
    public static StructCache cache;
    public static ThreadLocal<int[]> disableDsPaths;
    private static Map<String, String> permanentInstanceFileCache;
    private static Map<String, ExpiringCache<MultiKey, String>> instanceFileCaches;
    public static int instanceFileCacheHits;
    public static int instanceFileCacheMisses;
    public static int getInstanceFileCalls;
    public static int getInstanceFileTime;
    private static int count;
    private static int failCount;
    private static long nanosecs;
    private static Set failSet;
    static Boolean logLoadLocations;

    public static Map getDataMap(String filename) throws Exception {
        return cache.getDataMap(filename);
    }

    public static List getSingleList(String filename) throws Exception {
        Map myMap = DataStructCache.getDataMap(filename);
        return DataStructCache.singleList(myMap, filename);
    }

    public static List singleList(Map myMap, String name) throws Exception {
        if (myMap.size() > 1) {
            log.warn("getSingleList: Found multiple js variables in file " + name + ", returning the first one");
        } else if (myMap.size() == 0) {
            throw new IOException("No js variable definitions found in file " + name);
        }
        return (List)myMap.get(myMap.keySet().iterator().next());
    }

    public static Object getJSVariableFromFile(String filename, String variableName) throws Exception {
        return DataStructCache.getDataMap(filename).get(variableName);
    }

    public static Map getSingleDataMap(String filename) throws Exception {
        Map myMap = DataStructCache.getDataMap(filename);
        if (myMap.size() > 1) {
            log.warn("getSingleDataMap: Found multiple js variables in file " + filename + ", returning the first one");
        } else if (myMap.size() == 0) {
            throw new IOException("No js variable definitions found in file " + filename);
        }
        return (Map)myMap.get(myMap.keySet().iterator().next());
    }

    public static void addCachedObjectWithNoConfigFile(String typeName, Object config) {
        cache.setDataMapForTypeName(typeName, config);
    }

    public static void removeCachedObjectWithNoConfigFile(String typeName) {
        cache.removeDataMapForTypeName(typeName);
    }

    public static Object getCachedObjectWithNoConfigFile(String typeName) {
        return cache.getDataMapForTypeName(typeName);
    }

    public static Object getInstance(String ID, String typeName, String suffix) throws Exception {
        String filename = DataStructCache.getInstanceFile(ID, typeName, suffix);
        if (filename == null) {
            return null;
        }
        return DataStructCache.loadInstance(filename, ID, suffix);
    }

    public static Object loadInstance(String filename, String ID, String suffix) throws Exception {
        return DataStructCache.loadInstance(filename, ID, suffix, null);
    }

    public static Object loadInstance(String filename, String ID, String suffix, Map flags) throws Exception {
        return DataStructCache.loadInstance(filename, ID, suffix, flags, null);
    }

    public static Object loadInstance(String filename, String ID, String suffix, Map flags, Map fileConfig) throws Exception {
        return DataStructCache.loadInstance(filename, ID, suffix, flags, fileConfig, null, null);
    }

    public static Object loadInstance(String filename, String ID, String suffix, Map flags, Map fileConfig, ISCFile reusableFileInstance, DSRequest request) throws Exception {
        if (filename.endsWith(".js")) {
            return DataStructCache.getJSVariableFromFile(filename, ID + suffix);
        }
        ISCFile iscFileInstance = reusableFileInstance != null ? reusableFileInstance : DataStructCache.newISCFileInstance(filename, fileConfig, request);
        return XML.loadCacheableDSRecords(iscFileInstance, flags);
    }

    public static void disableDsPaths() {
        int[] count2 = disableDsPaths.get();
        count2[0] = count2[0] + 1;
    }

    public static void enableDsPaths() {
        int[] count2 = disableDsPaths.get();
        count2[0] = count2[0] - 1;
    }

    public static void clearInstanceFileCaches() {
        Iterator<String> i = instanceFileCaches.keySet().iterator();
        while (i.hasNext()) {
            instanceFileCaches.get(i.next()).clear();
        }
    }

    public static String getInstanceFile(String ID, String typeName, String suffix) throws Exception {
        return DataStructCache.getInstanceFile(ID, typeName, suffix, null);
    }

    public static String getInstanceFile(String ID, String typeName, String suffix, DataTypeMap flags) throws Exception {
        return DataStructCache.getInstanceFile(ID, typeName, suffix, flags, null, null, null);
    }

    public static String getInstanceFile(String ID, String typeName, String suffix, DataTypeMap flags, Map fileConfig, Map additionalContext, DSRequest request) throws Exception {
        String result;
        boolean upToDateCheck;
        long start = System.currentTimeMillis();
        if (flags == null) {
            flags = DataSource.getLoadFlags();
        }
        suffix = suffix.toLowerCase();
        String entryName = ID + "." + suffix;
        boolean forSCServerXML = flags.getBoolean((Object)"forSCServerXML", false);
        if (forSCServerXML) {
            if (permanentInstanceFileCache.containsKey(entryName)) {
                log.debug("Found entry for " + entryName + " in the forSCServerXML cache");
                return permanentInstanceFileCache.get(entryName);
            }
            log.debug("Did not find entry for " + entryName + " in the forSCServerXML cache, looking it up");
        }
        String frameworkSchemaOnlyKey = "frameworkSchemaOnly" + flags.getBoolean((Object)"frameworkSchemaOnly", Boolean.FALSE).toString();
        String forComponentXMLKey = "forComponentXML" + flags.getBoolean((Object)"forComponentXML", Boolean.FALSE).toString();
        MultiKey cacheKey = new MultiKey((Object)ID, (Object)typeName, (Object)suffix, (Object)frameworkSchemaOnlyKey, (Object)forComponentXMLKey);
        ExpiringCache<Object, String> instanceFileCache = instanceFileCaches.get(config.getString("project.datasources") + flags.getBoolean((Object)"forComponentXML", false));
        boolean bl = upToDateCheck = flags.getBoolean((Object)"forComponentXML", false) ? enableUpToDateCheckForComponentSchema : enableUpToDateCheck;
        if (instanceFileCache == null) {
            log.debug("Creating instanceFileCache for project.datasources path '" + config.getString("project.datasources") + "' and forComponentXML:" + flags.getBoolean((Object)"forComponentXML", false));
            instanceFileCache = new ExpiringCache(config.getLong((Object)"file.stalenessCheckInterval", upToDateCheck ? 500L : -1L), upToDateCheck ? 1024L : 16384L);
            instanceFileCaches.put(config.getString("project.datasources") + flags.getBoolean((Object)"forComponentXML", false), instanceFileCache);
        }
        String tenantId = request != null ? request.getTenantId() : null;
        ExpiringValue<String> value = instanceFileCache.get(cacheKey);
        if (value == null || tenantId != null && value.get() == null) {
            ISCFile iscFile;
            log.debug(entryName + " is not in the cache, looking it up (forComponentXML is " + flags.getBoolean((Object)"forComponentXML", false) + ")");
            ++count;
            long startNano = System.nanoTime();
            if (additionalContext == null) {
                additionalContext = new HashMap();
            }
            result = DataStructCache._getInstanceFile(ID, typeName, suffix, flags, fileConfig, additionalContext, request);
            nanosecs += System.nanoTime() - startNano;
            boolean resultIsCacheable = flags.getBoolean((Object)"_resultIsCacheable", true);
            if (resultIsCacheable && result == null && (iscFile = (ISCFile)additionalContext.get("iscFileInstance")) != null && iscFile instanceof ISCFileSourceFile && DataSource.isSandboxEligible(DataSource.parentDataSourceId(iscFile.getCanonicalPath()))) {
                log.debug("Got a null response from a sandbox-eligible parent DS - declining to cache");
                resultIsCacheable = false;
            }
            if (resultIsCacheable) {
                instanceFileCache.put(cacheKey, result);
                ++instanceFileCacheMisses;
                log.debug(entryName + " is now cached - value is " + result);
                if (forSCServerXML) {
                    log.debug("Adding " + entryName + " to the forSCServerXML cache");
                    permanentInstanceFileCache.put(entryName, result);
                }
            } else {
                log.debug(entryName + " is NOT cached - _resultIsCacheable is " + flags.getBoolean((Object)"_resultIsCacheable", true));
                ++failCount;
                failSet.add(ID + "." + typeName + "." + suffix);
            }
            flags.remove("_resultIsCacheable");
        } else {
            result = value.get();
            log.debug("instanceFile for " + entryName + " was found [" + result + "]. forComponentXML is " + flags.getBoolean((Object)"forComponentXML", false));
            ++instanceFileCacheHits;
        }
        long end = System.currentTimeMillis();
        ++getInstanceFileCalls;
        getInstanceFileTime = (int)((long)getInstanceFileTime + (end - start));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String _getInstanceFile(String ID, String typeName, String suffix, DataTypeMap flags, Map fileConfig, Map additionalContext, DSRequest request) throws Exception {
        boolean useDsPaths;
        String filePath;
        String filename = ID + "." + suffix;
        String instanceDir = null;
        if (config.getBoolean((Object)(typeName + ".enableExplicitLocations"), true)) {
            instanceDir = config.getPath(typeName + "." + ID + ".location");
        }
        String frameworkFilePath = null;
        if (instanceDir != null) {
            List simpleModeList;
            boolean allowExplicitLocation = true;
            if (config.getBoolean((Object)(typeName + ".restrictExplicitLocationsToSimpleModeList"), false) && (simpleModeList = config.getList(typeName + ".simpleModeList", null)) != null && !simpleModeList.contains(ID)) {
                allowExplicitLocation = false;
                log.debug("Explicit location for " + typeName + " " + ID + " suppressed by " + typeName + ".restrictExplicitLocationsToSimpleModeList: true");
            }
            if (allowExplicitLocation) {
                filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename, fileConfig, additionalContext, request);
                if (filePath != null) {
                    return filePath;
                }
                if (instanceDir != null) {
                    log.warning("File " + filename + " not found at explicitly specified location " + instanceDir + ", checking project-wide area");
                }
            }
        }
        boolean projectDataSourcesCanShadowFramework = config.getBoolean((Object)"datasources.projectDataSourcesCanShadowFramework", true);
        boolean frameworkSchemaOnly = flags.getBoolean((Object)"frameworkSchemaOnly", false);
        if (!projectDataSourcesCanShadowFramework || frameworkSchemaOnly) {
            frameworkFilePath = DataStructCache._getFrameworkInstanceFile(typeName, filename, fileConfig, additionalContext);
            if (frameworkFilePath != null) {
                return frameworkFilePath;
            }
            if (frameworkSchemaOnly) {
                return null;
            }
        }
        List<String> providedPaths = config.getCommaSeparatedList("provided." + typeName);
        List<String> projectPaths = config.getCommaSeparatedList("project." + typeName);
        ArrayList<String> configuredPaths = new ArrayList<String>();
        if (providedPaths != null) {
            configuredPaths.addAll(providedPaths);
        }
        if (projectPaths != null) {
            configuredPaths.addAll(projectPaths);
        }
        boolean bl = useDsPaths = disableDsPaths.get()[0] == 0 && DataSource.getBuiltinType(ID) == null;
        if (configuredPaths != null) {
            Iterator i = configuredPaths.iterator();
            while (i.hasNext()) {
                instanceDir = ISCFile.canonicalizePath((String)i.next());
                boolean isDSPath = instanceDir.startsWith("ds://");
                if (!isDSPath) {
                    filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename, fileConfig, additionalContext);
                    if (filePath == null) continue;
                    if (!projectDataSourcesCanShadowFramework && frameworkFilePath != null) {
                        log.warn("Disallowing " + filePath + " from shadowing framework instance at :" + frameworkFilePath);
                        return frameworkFilePath;
                    }
                    return filePath;
                }
                if (!useDsPaths) continue;
                boolean allowFileSourceLookup = flags.getBoolean((Object)"allowFileSourceLookup", true);
                if (allowFileSourceLookup && flags.getBoolean((Object)"forComponentXML", false)) {
                    String sourceDSName = new DSFileSpec(instanceDir).getDataSourceName();
                    DataSource sourceDS = null;
                    try {
                        sourceDS = DataSourceManager.get(sourceDSName, null, DataTools.buildMap("allowFileSourceLookup", false));
                        allowFileSourceLookup = sourceDS != null && sourceDS.getConfig().getBoolean((Object)"hasComponentSchema", false);
                    }
                    catch (Throwable throwable) {
                        DataSourceManager.free(sourceDS);
                        throw throwable;
                    }
                    DataSourceManager.free(sourceDS);
                }
                if (!allowFileSourceLookup) continue;
                additionalContext.put("_performingFileSourceLookup", Boolean.TRUE);
                filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename, fileConfig, additionalContext, request);
                if (filePath == null) continue;
                if (!projectDataSourcesCanShadowFramework && frameworkFilePath != null) {
                    log.warn("Disallowing " + filePath + " from shadowing framework instance at :" + frameworkFilePath);
                    return frameworkFilePath;
                }
                if (DataSource.isSandboxEligible(DataSource.parentDataSourceId(filePath))) {
                    flags.put("_resultIsCacheable", Boolean.FALSE);
                }
                return filePath;
            }
        }
        filePath = projectDataSourcesCanShadowFramework ? DataStructCache._getFrameworkInstanceFile(typeName, filename, fileConfig, additionalContext) : null;
        return filePath;
    }

    protected static String _getFrameworkInstanceFile(String typeName, String filename, Map fileConfig, Map additionalContext) throws Exception {
        List<String> frameworkPaths = config.getCommaSeparatedList("framework." + typeName);
        if (frameworkPaths != null) {
            Iterator<String> i = frameworkPaths.iterator();
            while (i.hasNext()) {
                String instanceDir = ISCFile.canonicalizePath(i.next());
                String filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename, fileConfig, additionalContext);
                if (filePath == null) continue;
                return filePath;
            }
        }
        return null;
    }

    public static String getInstanceDir(String ID, String typeName, String fileSuffix) throws Exception {
        String instanceFilename = DataStructCache.getInstanceFile(ID, typeName, fileSuffix);
        if (instanceFilename == null) {
            return null;
        }
        if (instanceFilename.startsWith("ds://")) {
            String path = instanceFilename.substring("ds://".length());
            String parent = new File(path).getParent();
            return "ds://" + parent;
        }
        return new File(instanceFilename).getParent();
    }

    public static String XMLOrJSFile(String baseName, Map fileConfig) throws IOException {
        return DataStructCache.XMLOrJSFile(baseName, fileConfig, null);
    }

    public static String XMLOrJSFile(String baseName, Map fileConfig, Map additionalContext) throws IOException {
        return DataStructCache.XMLOrJSFile(baseName, fileConfig, additionalContext, null);
    }

    public static String XMLOrJSFile(String baseName, Map fileConfig, Map additionalContext, DSRequest request) throws IOException {
        boolean allowJS = config.getBoolean((Object)"allowJSDataSource", false);
        if (baseName == null) {
            return null;
        }
        String xmlName = baseName + ".xml";
        String jsName = baseName + ".js";
        ISCFile iscFile = DataStructCache.newISCFileInstance(xmlName, fileConfig, request);
        if (additionalContext != null) {
            additionalContext.put("iscFileInstance", iscFile);
        }
        if (iscFile.exists()) {
            String path = iscFile.getCanonicalPath();
            if (logLoadLocations == null) {
                logLoadLocations = Config.getGlobal().getBoolean((Object)"datasource.logLoadLocations", false);
            }
            if (logLoadLocations.booleanValue()) {
                System.out.println("file exists at: " + xmlName + "\r\nwill load from: " + path);
            }
            return path;
        }
        if (allowJS && (iscFile = ISCFile.newInstance(jsName)).exists()) {
            return iscFile.getCanonicalPath();
        }
        return null;
    }

    public static ISCFile newISCFileInstance(String filename, Map fileConfig, DSRequest request) throws IOException {
        ISCFile iscFile = ISCFile.newInstance(filename);
        if (iscFile instanceof ISCFileSourceFile) {
            String textMatchStyle;
            DSFileSpec fileSpec = (DSFileSpec)iscFile.getNativeHandler();
            if (fileConfig != null && (textMatchStyle = (String)fileConfig.get("textMatchStyle")) != null) {
                fileSpec.setTextMatchStyle(textMatchStyle);
            }
            if (request != null) {
                fileSpec.setFileTenantId(request);
                fileSpec.setMatchNullTenantId(true);
            }
            fileSpec.setExistsShouldFetchContents(true);
        }
        return iscFile;
    }

    static {
        enableUpToDateCheck = config.getBoolean((Object)"datasources.enableUpToDateCheck", false);
        enableUpToDateCheckForComponentSchema = config.getBoolean("datasources.enableUpToDateCheckForComponentSchema") == null ? enableUpToDateCheck : config.getBoolean("datasources.enableUpToDateCheckForComponentSchema");
        cache = new StructCache();
        disableDsPaths = new ThreadLocal<int[]>(){

            @Override
            protected int[] initialValue() {
                return new int[]{0};
            }
        };
        permanentInstanceFileCache = new HashMap<String, String>();
        instanceFileCaches = new HashMap<String, ExpiringCache<MultiKey, String>>();
        instanceFileCacheHits = 0;
        instanceFileCacheMisses = 0;
        getInstanceFileCalls = 0;
        getInstanceFileTime = 0;
        count = 0;
        failCount = 0;
        nanosecs = 0L;
        failSet = new HashSet();
        logLoadLocations = null;
    }

    public static class StructCache
    extends ProcessedFileCache {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object loadObjectFromFile(ISCFile file) throws Exception {
            long start = System.currentTimeMillis();
            InputStream inStream = null;
            Map result = null;
            try {
                inStream = file.getInputStream();
                result = (Map)jsTrans.fromJSMap(inStream);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            long end = System.currentTimeMillis();
            Logger.timing.debug("Parsed JS file '" + file.getCanonicalPath() + "': " + (end - start) + "ms");
            return result;
        }

        public Map getDataMap(String filename) throws Exception {
            return (Map)this.getObjectFromFile(DataTools.makePathAbsolute(filename));
        }

        public Object getDataMapForTypeName(String typeName) {
            return this.cache.get(typeName);
        }

        public synchronized void setDataMapForTypeName(String typeName, Object dataMap) {
            this.cache.put(typeName, dataMap);
        }

        public synchronized void removeDataMapForTypeName(String typeName) {
            this.cache.remove(typeName);
        }
    }
}

