/*

  SmartClient Ajax RIA system
  Version v13.1p_2026-02-08/EVAL Development Only (2026-02-08)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/

if(window.isc&&window.isc.module_Core&&!window.isc.module_AI){isc.module_AI=1;isc._moduleStart=isc._AI_start=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc._moduleEnd&&(!isc.Log||(isc.Log&&isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={message:'AI load/parse time: '+(isc._moduleStart-isc._moduleEnd)+'ms',category:'loadTime'};
if(isc.Log&&isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime');
else if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM;
else isc._preLog=[isc._pTM]}isc.definingFramework=true;isc.defineClass("InternalAIMessagesBuilder").addProperties({
messagesSource:"user",
ssMessagesProperty:"userMessages",
ssMessagesPlaceholder:"${userMessages}",
init:function(){
this.Super("init",arguments);
this.aiMessages=[]},
appendPrompt:function(_1){
if(_1==this.ssMessagesPlaceholder){
this.$287x()}else{
this.aiMessages.push({
source:"system",
content:_1.evalDynamicString(this.target,this.evalVars)
})}
},
$287x:function(){
var _1=this.messagesSource;
this.aiMessages.addList(this[this.ssMessagesProperty].map(function(_2){
return{
source:_1,
content:_2.content,
type:_2.type
}}))},
appendPrompts:function(_1){
if(!isc.isAn.Array(_1)){
this.appendPrompt(_1);
return}
for(var i=0;i<_1.length;++i){
this.appendPrompt(_1[i])}
},
appendHelpDocuments:function(_1){
if(_1&&_1.length>0){
var _2="";
for(var h=0;h<_1.length;++h){
var _4=_1[h];
_2+="<requirements-document topic=\""+(_4.topic||_4.ID).trim()+"\"";
if(_4.format)_2+=" format=\""+_4.format.trim()+"\"";
_2+=">\n"
+_4.content.trim()+"\n</requirements-document>\n"}
this.aiMessages.push({
source:"system",
content:_2
})}
},
renderTemplate:function(_1){
var _2=(this.target||isc.AI).render(_1,this.evalVars);
var _3=_2.indexOf(this.ssMessagesPlaceholder);
if(_3<0)_3=0;
else{
if(_3>0){
this.aiMessages.push({
source:"system",
content:_2.substring(0,_3)
})}
this.$287x();
_3+=this.ssMessagesPlaceholder.length}
if(_3<_2.length){
this.aiMessages.push({
source:"system",
content:_2.substring(_3)
})}
}
});
isc.defineClass("InternalAIMessagesBuilder2","InternalAIMessagesBuilder");
isc.A=isc.InternalAIMessagesBuilder2.getPrototype();
isc.A.ssMessagesProperty="ssMessages";
isc.A.ssMessagesPlaceholder="${ssMessages}"
;
isc.defineClass("AIEngine").addClassProperties({
defaultHistoryIntroduction:"You have previously interacted with the user as follows. Each prior message from the user is delineated by ^^^^^^^ both before and after their message. Your responses are delineated by ####### both before and after your message.",
defaultHistoryConclusion:"That is the end of your previous interaction with the user. You are now to respond to the following.",
defaultHistoryDelimiters:{
"system":"\n\n",
"user":"^^^^^^^\n",
"AI":"#######\n"
},
$272z:function(_1){
return _1==null||_1=="text"},
$2720:function(_1){
return _1=="jpegImage"||_1=="pngImage"},
isImageMessage:function(_1){
return this.$2720(_1.type)},
$269b:function(_1){
this.$102q(this.isImageMessage(_1));
return _1.type=="jpegImage"?"image/jpeg":"image/png"},
containsImageMessage:function(_1){
if(_1!=null){
for(var i=0;i<_1.length;++i){
if(this.isImageMessage(_1[i])){
return true}
}
}
return false},
isVisionRequest:function(_1){
if(this.containsImageMessage(_1.messages)){
return true}
return false},
cloneAIRequest:function(_1){
var _2=isc.addPropertiesWithAssign({},_1);
delete _2.$260u;
if(isc.isAn.Array(_2.messages)){
_2.messages=_2.messages.duplicate()}
return _2},
$2889:"aiResponse,aiRequest"
});
isc.A=isc.AIEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.maxRecordsPerBatch=10;
isc.A.$258j=[];
isc.A.recordPickingBatchTimeout=20000;
isc.A.fieldPagingPrompts=[
"A user is interacting with an Isomorphic SmartClient web application.\nThey wish to take the following action - \"${actionDescription}\" - on a data-bound component (such as a ListGrid) based on the following query prompt:",
"${userMessages}",
"The dataSource the component is bound to has a large number of fields, many of which are unlikely to be relevant to the action being performed.\nThe objects in the source-array below represent a subset of these available fields.Using the properties on each field object for the dataSource and your own knowledge, determine which fields are relevant to the user-supplied query prompt.\nFor example, if the query was 'amount is larger than 100', you should look for a field with a name, title or description most related to 'amount'. Note that the user may not use the exact field name or title in their query. For example if the user refers to 'amount' they may be referring to 'quantity', 'price', 'cost' or similar fields. Please return all field objects that could be relevant.\n\nYour response should be an object serialized in JSON format with a single property called 'result'. This property should be set to an array of integers, where each integer is the index of a matching record in the source-array below.  For example, if the first field object in the array below may be relevant to the user's query, your response array must include its source-array index (0) as the first entry.  Similarly, the source-array indices of any other matching field objects must also be in your response array.\n\nIf a field object is not relevant to the query prompt, do not include its index in your response array.\n\nIf no field objects are relevant, the 'result' property in your response object should be set to an empty array.\n\nApart from this object, your response must not include any other preamble or content of any kind."
];
isc.A.$50a=[null,"text","number","object","array"];
isc.A.requestOperationId="createChatCompletion";
isc.A.rateLimitInitialDelay=5000;
isc.A.rateLimitMaxDelay=60000;
isc.A.rateLimitBackoffFactor=2;
isc.A.rateLimitMaxRetries=4;
isc.B.push(isc.A.getRecordsPerPrompt=function isc_AIEngine_getRecordsPerPrompt(_1,_2,_3){
this.$102q(isc.isAn.Array(_1));
var _4=_1;
_2=_2||0;
_3=_3||{};
_3.startIndex=_3.startIndex||0;
var _5={
fixedTokens:isc.isA.Number(parseInt(_2))?parseInt(_2):
this.estimateTokenCount(_2),
responseTokensPerRecord:_3.responseTokensPerRecord,
totalTokens:null,
avgTokens:null,
minTokens:null,
maxTokens:null,
usedTokens:null,
remainingTokens:null
};
var _6=[];
var _7={
status:null,
engineId:this.engineId,
totalRecords:_4.length,
startIndex:_3.startIndex,
numRecords:0,
exactNumRecords:0,
variance:1,
tokenStats:_5,
formatDescription:null,
serializedForm:_6
};
var _8=this.tokenLimit-_5.fixedTokens;
var _9=0;
var _10=_3.serializationFormat||this.serializationFormat;
var _11=_10!="csv";
var _12=_10=="compactJSON";
var _13=(_12?",":(_11?",\n":"\n"));
for(var i=_3.startIndex;i<_4.length;i++){
var _15=_4[i];
var _16={};
_16.record=isc.AI.serializeIndexedRecord(_15,i,_3);
_16.tokenCount=this.estimateTokenCount(_16.record+_13);
if(_7.numRecords==0||_8>=_16.tokenCount){
_6.add(_16);
_7.numRecords++;
_7.exactNumRecords=_7.numRecords;
_9+=_16.tokenCount;
_8-=_16.tokenCount;
if(_8<0){
_7.status="The number of fixed tokens already exceeds the token limit.";
_7.exactNumRecords=0;
break}
}else{
var _17=_16.tokenCount-_8;
_7.exactNumRecords=_7.numRecords+(_17/_16.tokenCount);
break}
if(_3.aiPageSize&&_7.numRecords>=_3.aiPageSize){
break}
}
_5.totalTokens=_9;
_5.minTokens=_6.getProperty("tokenCount").min();
_5.maxTokens=_6.getProperty("tokenCount").max();
_5.avgTokens=Math.ceil(_6.getProperty("tokenCount").sum()/_7.numRecords);
_5.remainingTokens=_8;
_7.variance=_5.maxTokens/_5.minTokens;
return _7}
,isc.A.getBatches=function isc_AIEngine_getBatches(_1,_2,_3){
this.$102q(isc.isAn.Array(_2));
_3=_3||{};
var _4=isc.AI.getFormatDescription(_3);
_1=isc.AIEngine.cloneAIRequest(_1);
if(!_1.messages)_1.messages=[];
_1.messages.push({source:"system",content:_4});
var _5=_1.messages.length-1;
var _6=this.estimateRequestTokenCount(_1);
if(_3.aiPageSize==0)_3.aiPageSize=null;
if(this.maxRecordsPerBatch){
if(!isc.isA.Number(_3.aiPageSize))_3.aiPageSize=this.maxRecordsPerBatch;
else _3.aiPageSize=Math.min(_3.aiPageSize,this.maxRecordsPerBatch)}
var _7=[];
for(var i=0,_9=_2.length;i<_9;){
var _10=isc.addPropertiesWithAssign({},_3);
_10.startIndex=i;
var _11=this.getRecordsPerPrompt(_2,_6,_10);
this.$102q(_11.numRecords>0);
var _12=_11.serializedForm.getProperty("record");
this.$102q(_12.length==_11.numRecords);
var _13=isc.AIEngine.cloneAIRequest(_1);
_13.willHandleError=true;
for(var m=0;m<_5;++m){
var _15=_13.messages[m];
if(_15.source=="system"&&
isc.AIEngine.$272z(_15.type)&&
isc.isA.nonemptyString(_15.content))
{
_15=isc.addPropertiesWithAssign({},_15);
_15.content=_15.content.evalDynamicString(this,_11);
_13.messages[m]=_15}
}
_13.messages[_5]={
source:"system",
content:_4+isc.AI.$2590(_12,_3)
};
_7.push({
aiRequest:_13,
startIndex:i,
length:_11.numRecords,
$270e:_4,
$270f:_12,
$270g:_3
});
i+=_11.numRecords
}
return _7}
,isc.A.splitBatch=function isc_AIEngine_splitBatch(_1){
this.$102q(_1.length>=2);
var _2=_1.startIndex,
_3=_1.length>>1,
_4=_1.startIndex+_3,
_5=_1.length-_3;
this.$102q(_3>=1&&_5>=1);
var _6=_1.aiRequest,
_7=_6.messages.length-1,
_8=_1.$270e,
_9=_1.$270g;
var _10=_1.$270f.slice(0,_3),
_11=isc.AIEngine.cloneAIRequest(_6);
_11.willHandleError=true;
this.$102q(_10.length==_3);
_11.messages[_7]={
source:"system",
content:_8+isc.AI.$2590(_10,_9)
};
var _12=_1.$270f.slice(_3),
_13=isc.AIEngine.cloneAIRequest(_6);
_13.willHandleError=true;
this.$102q(_12.length==_5);
_13.messages[_7]={
source:"system",
content:_8+isc.AI.$2590(_12,_9)
};
return[{
aiRequest:_11,
startIndex:_2,
length:_3,
$270e:_8,
$270f:_10,
$270g:_9
},{
aiRequest:_13,
startIndex:_4,
length:_5,
$270e:_8,
$270f:_12,
$270g:_9
}]}
,isc.A.doPageRecordsPicking=function isc_AIEngine_doPageRecordsPicking(_1,_2,_3,_4){
_4=_4||{};
var _5=this;
var _6=this.$258j;
var _7={
id:"aiTransaction_"+_6.length,
engineId:this.engineId,
postProcessCallback:_3,
progressCallback:_4.progressCallback,
batches:[],
results:[]
};
_6.add(_7);
var _8=_4.cancellationController,
_9=isc.CancellationController.create();
var _10=_2;
if(_10.localData)_10=_10.localData;
var _11=function(_7){
_6.remove(_7);
var _12=[];
for(var i=0;i<_7.batches.length;i++){
var _14=_7.batches[i];
if(_4.keepEmptyMatches){
_5.$102q(_14.result.getLength()==_14.length);
_12.addList(_14.result)}else{
for(var j=0;j<_14.result.length;j++){
var _16=_14.result[j];
var _17=_10.get(_16);
if(_17==null){
_5.logWarn("Unable to find match for index in data: "+_16,"AI")}else{
_12.add(_17)}
}
}
}
_5.logDebug("Completing AI Transaction "+_7.id+", with "+
_7.batches.length+" batches covering "+
_10.length+" total records, and "+_12.length+" matches","AI");
_5.fireCallback(_7.postProcessCallback,"matches,batches",[_12,_7.batches])};
if(!isc.isAn.Array(_10)||_10.length<=0){
this.delayFireCallback(_11,"transaction",[_7]);
return _7}
var _18=0;
var _19=function(_7,_14){
_5.logDebug("Adding batch "+_14.batchId+" to AI-transaction "+_7.id,"AI");
_7.batches.add(_14);
var _20=_14.aiRequest;
_5.sendRequest(_20,function(_29){
_18+=_14.length;
var _21;
if(_29.type!="success"){
_21=[];
_14.nonSuccessfulResult=_29}else{
_21=_29.message&&_29.message.content&&_29.message.content.result;
if(!isc.isAn.Array(_21))_21=[_21]}
if(_4.keepEmptyMatches){
while(_21.length<_14.length){
_21.push(isc.AI.invalidSummaryValue)}
if(_21.length>_14.length)_21.setLength(_14.length)}else{
_21.removeEmpty()}
_14.result.addList(_21);
_7.results.addList(_21);
_14.executing=0;
var _12=_7.results.length;
if(_7.progressCallback){
var _22=_8&&_8.canceled,
_23=_7.progressCallback(_18,_10.length,_12),
_24=!_22&&_23!==false;
if(!_24){
var _25=_22?_8.cancellationReason:"progressCallback() returned `false`.";
if(!_9.canceled){
_9.cancel(_25,"application")}
_5.logDebug("doPageRecordsPicking() transaction "+_7.id+" was canceled by the progressCallback.","AI");
return}
}
if(_7.batches.getProperty("executing").sum()==0){
_11(_7)}
},{
showPrompt:false,
ignoreTokenLimit:true,
requestProperties:{timeout:this.recordPickingBatchTimeout},
maxRetries:_4.maxRetries
})};
var _26={
messages:_1,
responseType:"object",
cancellationController:_9
};
var _27=this.getBatches(_26,_10,_4);
for(var _28=0;_28<_27.length;++_28){
var _14=_27[_28];
isc.addPropertiesWithAssign(_14,{
batchId:_28,
range:[_14.startIndex,_14.startIndex+_14.length-1],
executing:1,
result:[]
});
_19(_7,_14)}
return _7}
,isc.A.shouldUseAIFieldPaging=function isc_AIEngine_shouldUseAIFieldPaging(_1,_2,_3){
if(!isc.AI.useAIFieldPaging)return false;
var _4={
engineId:this.engineId,
fieldNames:_3.salientFieldAttributes||isc.AI.salientFieldAttributes,
serializationFormat:_3.serializationFormat
};
var _5=this.estimateRequestTokenCount(_1);
var _6=this.getRecordsPerPrompt(_2,_5,_4);
return(_6.totalRecords>_6.numRecords)}
,isc.A.retrieveFieldsForPrompt=function isc_AIEngine_retrieveFieldsForPrompt(_1,_2,_3,_4,_5,_6){
var _7=isc.InternalAIMessagesBuilder.create({
userMessages:_1,
target:this,
evalVars:{
actionDescription:_2
}
});
_7.appendPrompts(this.fieldPagingPrompts);
_5=_5||{};
var _8=_5.progressCallback;
var _9=_5.aiPageSize;
if(_9==0)_9=null;
var _10=_6&&_6.salientFieldAttributes;
if(_10==null)_10=isc.AI.salientFieldAttributes;
var _11={
engineId:this.engineId,
fieldNames:_10,
aiPageSize:_9,
progressCallback:_8
};
this.doPageRecordsPicking(_7.aiMessages,_3,function(_12){
isc.AI.fireCallback(_4,"finalFields",[_12])},_11)}
,isc.A.asyncRetrieveFieldsForPrompt=function isc_AIEngine_asyncRetrieveFieldsForPrompt(_1,_2,_3,_4,_5){
var _6=Promise.withResolvers();
this.retrieveFieldsForPrompt(_1,_2,_3,function(_7){
_6.resolve(_7)},_4,_5);
return _6.promise}
,isc.A.estimateTokenCount=function isc_AIEngine_estimateTokenCount(_1){
_1=_1||"";
var _2=_1.trim().split(/\s/);
var _3=3;
var _4=0;
for(var i=0;i<_2.length;i++){
var _6=_2[i].split(/\W/);
_4+=_6.length-1;
for(var _7=0;_7<_6.length;_7++){
_4+=Math.max(1,_6[_7].length/_3)}
}
return Math.ceil(_4)}
,isc.A.estimateMessageTokenCount=function isc_AIEngine_estimateMessageTokenCount(_1){
if(_1.type=="jpegImage"||_1.type=="pngImage"){
return 1000}
var _2=_1.content;
if((_1.type=="array"||_1.type=="object")&&
!isc.isA.String(_2)&&
isc.isAn.Object(_2))
{
_2=isc.AI.$260x(_2)}
return this.estimateTokenCount(String(_2))}
,isc.A.estimateRequestTokenCount=function isc_AIEngine_estimateRequestTokenCount(_1){
_1=this.normalizeRequest(_1);
this.$102q(_1.prompt==null);
var _2=this.makePromptText(_1);
return this.estimateTokenCount(_2)}
,isc.A.getTokenLimit=function isc_AIEngine_getTokenLimit(_1){
return this.tokenLimit}
,isc.A.couldSupportRequest=function isc_AIEngine_couldSupportRequest(_1){
_1=this.normalizeRequest(_1);
if(!this.$50a.contains(_1.responseType)){
return false}
const _2=_1.messages,
_3=this.canSupportVisionRequests();
if(_2!=null){
for(var i=0;i<_2.length;++i){
var _5=_2[i];
if(this.$50a.contains(_5.type)){
continue}
if(_3&&isc.AIEngine.$2720(_5.type)){
continue}
return false}
}
var _6=this.estimateRequestTokenCount(_1);
if(_6>this.getTokenLimit(_1)){
return false}
return true}
,isc.A.canSupportVisionRequests=function isc_AIEngine_canSupportVisionRequests(){
return false}
,isc.A.sendRequest=function isc_AIEngine_sendRequest(_1,_2,_3){
_3=isc.addPropertiesWithAssign({retryIndex:0},_3);
var _4=this.transformRequest(_1,_3);
this.handleSendRequest(_4,_1,_2,_3)}
,isc.A.asyncSendRequest=function isc_AIEngine_asyncSendRequest(_1,_2){
_1.$281m=_1.willHandleError;
_1.willHandleError=true;
const _3=Promise.withResolvers();
this.sendRequest(_1,function(_4,_1,_2,_5,_6){
_1.willHandleError=_1.$281m;
_4.$294d=_5;
_4._dsRequest=_6;
if(_4.type=="success")_3.resolve(_4);
else _3.reject(_4)},_2);
if(!_1.$281m){
return _3.promise
.$274g(function(_7){
const _4=isc.defaultAsyncOperationCatchCallback(_7),
_5=_4.$294d||{},
_6=_4._dsRequest||{};
if(!(_5.status<0)){
_5.status=isc.DSResponse.STATUS_FAILURE;
_5.data=isc.getAsyncMessage(_4)}
if(_4.type!="canceled"||_4.cancellationInitiator!="user"){
isc.RPCManager.$a0(_5,_6)}
return null},
this)}else{
return _3.promise}
}
,isc.A.normalizeRequest=function isc_AIEngine_normalizeRequest(_1){
if(_1.$260u)return _1;
var _2=_1.messages;
var _3=false;
var _4=function(){
_1=isc.addProperties({},_1);
_2=_1.messages=(_2==null?null:_2.duplicate());
_3=true}
if(_2!=null){
for(var i=0;i<_2.length;++i){
var _6=_2[i],
_7=false;
if(_6.source==null||
(_6.source!="system"&&_6.source!="user"&&_6.source!="AI"))
{
if(_6.source!=null){
this.logWarn("Unrecognized AIMessageSource '"+_6.source+"'. Changing to 'user'","AI")}
if(!_3)_4();
if(!_7){
_6=_2[i]=isc.addProperties({},_6);
_7=true}
_6.source="user"}
if(_6.type=="number"&&!isc.isA.String(_6.content)){
if(!_3)_4();
if(!_7){
_6=_2[i]=isc.addProperties({},_6);
_7=true}
_6.content=String(_6.content);
delete _6.type}
if((_6.type=="object"||_6.type=="array")&&
!isc.isA.String(_6.content)&&
isc.isAn.Object(_6.content))
{
if(!_3)_4();
if(!_7){
_6=_2[i]=isc.addProperties({},_6);
_7=true}
_6.content=isc.AI.$260x(_6.content);
delete _6.type}
}
}
if(_1.prompt!=null){
if(!_3)_4();
_1.$260n=_1.prompt;
if(_2==null){
_2=_1.messages=[]}
_2.push({source:"user",content:_1.prompt});
delete _1.prompt}
if(_1.responseType=="number"){
if(!_3)_4();
if(_2==null){
_2=_1.messages=[]}
var _8="Your response must only be a number";
if(_1.responseMinimum!=null){
if(_1.responseMaximum!=null){
_8+=(" between "+_1.responseMinimum+" and "+
_1.responseMaximum+" inclusive.")}else{
_8+=" at least "+_1.responseMinimum+"."}
}else if(_1.responseMaximum!=null){
_8+=" no more than "+_1.responseMaximum+"."}else{
_8+="."}
_2.push({source:"system",content:_8});
delete _1.responseType}
if(_1.responseType=="array"||_1.responseType=="object"){
var _9=false;
if(_2!=null){
for(var i=0;i<_2.length;++i){
var _6=_2[i];
if(isc.AIEngine.$272z(_6.type)&&
/JSON/i.test(_6.content))
{
_9=true;
break}
}
}
if(!_9){
if(!_3)_4();
if(_2==null){
_2=_1.messages=[]}
_2.push({
source:"system",
content:"Your response must only be a JSON "+_1.responseType+"."
})}
}
_1.$260u=true;
return _1}
,isc.A.getTemperature=function isc_AIEngine_getTemperature(_1){
return(_1&&_1.temperature!=null?_1.temperature:this.temperature)}
,isc.A.makeNonTextPromptPart=function isc_AIEngine_makeNonTextPromptPart(_1){
return"*non-text content*\n"}
,isc.A.makePromptParts=function isc_AIEngine_makePromptParts(_1){
_1=this.normalizeRequest(_1);
this.$102q(_1.prompt==null);
var _2=isc.addProperties({},isc.AIEngine.defaultHistoryDelimiters,_1.historyDelimiters);
var _3=[],
_4=_1.messages;
var _5=(function(_15){
this.$102q(_3.length>0);
var _6=_3[_3.length-1];
if(!isc.isA.String(_6))return true;
return _6.endsWith(_15)}).bind(this);
var _7=function(_15){
if(isc.isA.String(_15)&&
_3.length>0&&
isc.isA.String(_3[_3.length-1]))
{
_3[_3.length-1]+=_15}else{
_3.push(_15)}
};
if(_4!=null){
var _8=(function(_14){
if(_3.length>0){
var _9=String(_2["system"]);
if(_14.source=="system"&&!_5(_9)){
_7(_9)}else if(!_5('\n')){
_7("\n")}
}
if(!isc.AIEngine.$272z(_14.type)){
_7(this.makeNonTextPromptPart(_14))}else{
_7(String(_14.content))}
}).bind(this);
var _10=0;
for(;_10<_4.length;++_10){
var i=_10;
if(_4[i].source!="system"){
break}
_8(_4[i])}
var i=_10,
_12=_4.length;
for(;_12>i&&_4[_12-1].source=="system";--_12){}
if(i<_12){
var _13=_4[_12-1].source;
this.$102q(_13!="system");
for(;_12-1>i&&(_4[_12-1-1].source=="system"||
_4[_12-1-1].source==_13);--_12)
{
}
}
if(i<=_12-2){
_8({
source:"system",
content:(_1.historyIntroduction!=null
?_1.historyIntroduction
:isc.AIEngine.defaultHistoryIntroduction)
});
for(;i<_12-1;++i){
var _14=_4[i],
_9=String(_2[_14.source||"user"]);
if(_14.source!="system"){
if(_3.length>0&&!_5("\n"))_7("\n");
_7(_9)}
_8(_14);
if(_14.source!="system"){
if(_3.length>0&&!_5("\n"))_7("\n");
_7(_9)}
}
_8({
source:"system",
content:(_1.historyConclusion!=null
?_1.historyConclusion
:isc.AIEngine.defaultHistoryConclusion)
})}
for(;i<_4.length;++i){
_8(_4[i])}
}
return _3}
,isc.A.makePromptText=function isc_AIEngine_makePromptText(_1){
var _2=this.makePromptParts(_1);
return _2.join("")}
,isc.A.transformRequest=function isc_AIEngine_transformRequest(_1,_2){
_1=this.normalizeRequest(_1);
var _3=this.makePromptText(_1);
if(!_2.ignoreTokenLimit&&this.tokenLimit!=null){
var _4=this.estimateTokenCount(_3);
if(_4>this.tokenLimit){
this.logWarn("Approximate token count for prompt text is: "+_4+
". This exceeds the token limit for the ai engine: "+this.name+
". This request may be rejected by the AI server (proceeding anyway).","AI")}else{
this.logDebug("Estimated token count for prompt is: "+_4,"AI")}
}
return{
engineId:this.engineId,
model:this.model,
temperature:this.getTemperature(_1),
text:_3
}}
,isc.A.getDataSourceName=function isc_AIEngine_getDataSourceName(_1){
return this.dataSourceName||isc.AI.dataSourceName}
,isc.A.$2500=function isc_AIEngine__getDataSource(_1,_2,_3,_4){
var _5=isc.AI.$2500(this.engineId,_2),
_6=this.getDataSourceName(_2);
if(_5==null&&_6){
if(isc.AI.autoLoadDataSource&&!isc.AI.$257k[_6]){
isc.AI.$260m.push({
engine:this,
dataSourceName:_6,
rawRequest:_1,
aiRequest:_2,
callback:_3,
config:_4
});
isc.AI.loadDataSource(_6)}else{
this.logWarn("No AI DataSource configured","AI")}
}
return _5}
,isc.A.handleSendRequest=function isc_AIEngine_handleSendRequest(_1,_2,_3,_4){
const _5={
operationId:this.requestOperationId,
willHandleError:true,
clientContext:_4.context,
showPrompt:!!_4.showPrompt
};
if(_4.requestProperties!=null){
isc.addPropertiesWithAssign(_5,_4.requestProperties)}
const _6=this.$2500(_1,_2,_3,_4);
if(!_6){
const _7=this.getDataSourceName(_2);
if(!isc.AI.$257l[_7]&&!isc.AI.$257k[_7]){
const _8={
type:"error",
errorMessage:"DataSource '"+String(_7).asHTML()+"' was not found or could not be loaded to make an AI request."
};
this.delayCall("$294e",[_2,_3,_4,_5,null,_8])}
return}
if(_2.cancellationController&&_2.cancellationController.canceled){
const _8=_2.cancellationController.asCanceledResult();
this.delayCall("$294e",[_2,_3,_4,_5,null,_8]);
return}
if(this.logIsDebugEnabled("AI")){
this.logDebug("Prompt text to send to AI: "+this.makePromptText(_2),"AI")}
var _9=_4.responseSpoofingMode||isc.AI.responseSpoofingMode;
if(_9!="none"){
var _10=isc.AI.getSpoofedResponse(_2,this);
if(_10!=null||_9=="full"){
this.logDebug("* Using a spoofed response for the current interaction. responseSpoofingMode is \""+_9+"\". *","AI");
_5.dataProtocol="clientCustom";
if(_5.clientContext==null){
_5.clientContext={}}
_5.clientContext.dataSource=_6;
_5.clientContext.aiEngine=this;
_5.clientContext.aiRequest=_2;
_5.clientContext.spoofingMode=_9;
_5.clientContext.spoofedResponse=_10}
}
const _11=this;
_6.fetchData(
_1,
function(_19,_20,_5){
var _12,
_13;
if(_2.cancellationController&&_2.cancellationController.canceled){
_12=_2.cancellationController.asCanceledResult()}else{
if(_19.$260o&&(_20.makeAIResponse||_20.aiResponse)){
_12=_20.makeAIResponse?_20.makeAIResponse(_2,_11):_20.aiResponse;
_13=_20.makeErrorResponseInfo?_20.makeErrorResponseInfo(_2,_11):_20.errorResponseInfo}else{
var _14=(_19.$260o?_11.makeSpoofedRawResponse(_2,_20.value):_19.completeData||_20);
if(_19.status<0||_11.isErrorResponse(_14,_2)){
_13=_11.getErrorResponseInfo(_14,_1,_2,_4);
_12=isc.createErrorResult(_13&&_13.errorMessage)}else{
_12=_11.transformRawResponse(_14,_1,_2,_4)}
}
if(_12.type!="success"){
var _15=_13&&_13.errorType;
if(_15)_12.errorType=_15;
var _16=Math.max(0,+_4.retryIndex);
if(isNaN(_16))_16=0;
var _17=Math.max(0,_4.maxRetries!=null?_4.maxRetries:
isc.AI.defaultMaxRetries);
if(isNaN(_17))_17=0;
if(_16>=_17){
_12=isc.createErrorResult("Exceeded the maximum number of retries ("+
_17+").",{lastAIResponse:_12})}else if(_13&&_13.recoverable){
var _18=_13.retryDelay||isc.AI.sendPromptRetryDelay;
_1=_13.newRawRequest||_1;
_4.retryIndex=_16+1;
if(!_4.$2883){
_4.$2883=_5.requestId}
_11.logDebug("Delaying original "+_4.$2883+" for "+
_18+"ms due to rate limiting.  Attempt "+
_4.retryIndex+" / "+_4.maxRetries,"AI");
_11.delayCall("handleSendRequest",[_1,_2,_3,_4],
_18);
return}
}
}
_12=_11.normalizeResponse(_12,_2,_4);
_11.$294e(_2,_3,_4,_5,_19,_12)},
_5
)}
,isc.A.$294e=function isc_AIEngine___handleAIResponse(_1,_2,_3,_4,_5,_6){
if(_1.willHandleError||_6.type=="success"){
this.fireCallback(_2,isc.AIEngine.$2889,[_6,_1,_3,_5,_4])}else if(_6.type!="canceled"||_6.cancellationInitiator!="user"){
if(!_5)_5={};
if(!(_5.status<0)){
_5.status=isc.DSResponse.STATUS_FAILURE;
_5.data=isc.getAsyncMessage(_6)}
isc.RPCManager.$a0(_5,_4)}
}
,isc.A.makeSpoofedRawResponse=function isc_AIEngine_makeSpoofedRawResponse(_1,_2){
return[{
chat_role:"assistant",
chat_content:_2
}]}
,isc.A.isErrorResponse=function isc_AIEngine_isErrorResponse(_1,_2){
return!_1||isc.isA.String(_1)||!!_1.error}
,isc.A.getErrorResponseInfo=function isc_AIEngine_getErrorResponseInfo(_1,_2,_3){
if(isc.isA.String(_1)){
var _4=isc.AI._extractJsonResult(_1);
if(_4&&_4.error)_1=_4;
else return{errorMessage:"An error occurred. The response from the server was: "+_1}}else if(!_1||!_1.error)return null;
return{errorMessage:_1.error.message}}
,isc.A.extractAIMessage=function isc_AIEngine_extractAIMessage(_1,_2,_3){
var _4="text";
if(_3.responseType=="array"||_3.responseType=="object"){
var _5=_1.indexOf("```");
if(_5>=0){
if(_1.indexOf("```json",_5)>=0){
_1=isc.AI._extractJsonResult(_1,"```json","```",true)}else{
_1=isc.AI._extractJsonResult(_1,"```","```",true)}
}else if(_3.responseType=="array"&&_1.indexOf("[")>=0){
_1=isc.AI._extractJsonResult(_1,"[","]")}else{
_1=isc.AI._extractJsonResult(_1)}
_4=isc.isAn.Array(_1)?"array":"object"}
return{source:"AI",content:_1,type:_4}}
,isc.A.transformRawResponse=function isc_AIEngine_transformRawResponse(_1,_2,_3,_4){
var _5=isc.isAn.Array(_1)&&_1[0]&&_1[0].chat_content;
if(!isc.isA.String(_5)){
var _6="Unable to extract the message from the AI response";
this.logWarn(_6,"AI");
return isc.createErrorResult(_6)}
this.logDebug("Response text from AI: "+_5,"AI");
return{
type:"success",
message:this.extractAIMessage(_5,_2,_3)
}}
,isc.A.normalizeResponse=function isc_AIEngine_normalizeResponse(_1,_2,_3){
if(!_1)_1={};
if(_1.type==null||_1.type=="error"){
_1.type="error"}else{
var _4=_1.message;
if(_4){
var _5=_2.responseType||"text";
if(_5=="array"){
if(!isc.isAn.Array(_4.content)){
_4.content=[_4.content];
_4.type="array"}
}else if(_5=="object"){
if(!isc.isAn.Object(_4.content)||isc.isAn.Array(_4.content)){
_4.content={result:_4.content};
_4.type="object"}
}else if(_5=="number"){
_4.content=Number(_4.content);
if(_2.responseMinimum!=null){
_4.content=Math.max(_2.responseMinimum,_4.content)}
if(_2.responseMaximum!=null){
_4.content=Math.min(_4.content,_2.responseMaximum)}
_4.type="number"}
}
}
return _1}
);
isc.B._maxIndex=isc.C+31;
isc.A=isc.AIEngine.getPrototype();
isc.A.temperature=0.7;
isc.A.tokenLimit=4096
;
isc.defineClass("BaseOpenAIEngine",isc.AIEngine);
isc.A=isc.BaseOpenAIEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.provider="OpenAI";
isc.A.dataSourceName="openAIRestConnector";
isc.A.requestOperationId="fetch";
isc.A.tokenLimit=4096;
isc.A.supportsJSONMode=false;
isc.A.supportsStructuredOutputs=false;
isc.A.rateLimitInstructOffset=5000;
isc.A.rateLimitDelayMode="backoff";
isc.B.push(isc.A.estimateRequestTokenCount=function isc_BaseOpenAIEngine_estimateRequestTokenCount(_1){
_1=this.normalizeRequest(_1);
this.$102q(_1.prompt==null);
var _2=0,
_3=_1.messages;
if(_3!=null){
for(var i=0;i<_3.length;++i){
_2+=this.estimateMessageTokenCount(_3[i])}
}
return _2}
,isc.A.$277z=function isc_BaseOpenAIEngine__mapAIMessageSourceToRole(_1){
if(!_1)return"user";
return _1=="AI"?"assistant":_1}
,isc.A.transformRequest=function isc_BaseOpenAIEngine_transformRequest(_1){
_1=this.normalizeRequest(_1);
var _2=this.canSupportVisionRequests()&&isc.AIEngine.isVisionRequest(_1);
var _3={
model:_2&&this.visionModel?this.visionModel:this.model||this.engineId,
temperature:this.getTemperature(_1),
messages:null
};
var _4=_1.messages;
if(_4!=null){
var _5=_3.messages=new Array(_4.length);
for(var i=0;i<_5.length;++i){
var _7=_4[i];
_5[i]={
role:this.$277z(_7.source),
content:null
};
if(_2&&isc.AIEngine.isImageMessage(_7)){
_5[i].content=[{
type:"image_url",
image_url:{
url:"data:image/"+(_7.type=="jpegImage"?"jpeg":"png")+";base64,"+_7.content
}
}]}else if(!isc.AIEngine.$272z(_7.type)){
_5[i].content=this.makeNonTextPromptPart(_7)}else{
_5[i].content=String(_7.content)}
}
}
if(this.supportsJSONMode){
if(_1.responseType=="object"&&
_1.responseType!="array")
{
_3.response_format={type:"json_object"}}
}
if(this.seed!=null)_3.seed=this.seed;
return _3}
,isc.A.makeSpoofedRawResponse=function isc_BaseOpenAIEngine_makeSpoofedRawResponse(_1,_2){
return{
choices:[{
finish_reason:"stop",
index:0,
message:{
content:_2,
role:"assistant"
}
}]
}}
,isc.A.extractAIMessage=function isc_BaseOpenAIEngine_extractAIMessage(_1,_2,_3){
if((_1.contains('{')||_1.contains('['))&&
_2&&_2.response_format&&_2.response_format.type=="json_object")
{
try{
_1=isc.JSON.decode(_1);
var _4=isc.isAn.Array(_1)?"array":"object";
return{source:"AI",content:_1,type:_4}}catch(e){
this.logWarn("JSON mode was enabled, but the response did not parse as JSON: "+e,"AI")}
}
return this.Super("extractAIMessage",arguments)}
,isc.A.getErrorResponseInfo=function isc_BaseOpenAIEngine_getErrorResponseInfo(_1,_2,_3,_4){
if(isc.isA.String(_1)){
var _5=isc.AI._extractJsonResult(_1);
if(_5&&_5.error)_1=_5;
else return{errorMessage:"An error occurred. The response from the server was: "+_1}}else if(!_1||!_1.error)return null;
var _6={errorMessage:_1.error.message};
var _7=_4.rateLimitDelayMode||this.rateLimitDelayMode;
if(_1.error.code=="rate_limit_exceeded"&&_7!="none"){
if(!_4.retryIndex){
if(!_4.maxRetries)_4.maxRetries=this.rateLimitMaxRetries}
switch(_7){
case"instruct":
var _8=_1.error.message;
if(_8){
var _9=_8.match(/token.*limit.*please try again in ([0-9.]+)s/i);
if(_9){
_6.retryDelay=Math.ceil(parseFloat(_9[1])*1000)+
this.rateLimitInstructOffset,
_6.recoverable=true}
}
break;
case"backoff":
if(_4.retryDelay)_4.retryDelay*=this.rateLimitBackoffFactor;
else _4.retryDelay=this.rateLimitInitialDelay;
if(_4.retryDelay>this.rateLimitMaxDelay){
_4.retryDelay=this.rateLimitMaxDelay}
_6.retryDelay=_4.retryDelay;
_6.recoverable=true;
break}
}
return _6}
,isc.A.transformRawResponse=function isc_BaseOpenAIEngine_transformRawResponse(_1,_2,_3){
var _4={type:"error"};
if(!_1){
_4.errorMessage="The response was empty."}else if(_1.error){
_4.errorMessage=_1.error.message}else{
var _5=isc.isAn.Array(_1.choices)&&_1.choices[0];
var _6=_5&&_5.message&&_5.message.content;
if(!isc.isA.String(_6)){
this.logWarn(_4.errorMessage="Unable to extract the message from the AI response","AI")}else{
this.logDebug("Response text from AI: "+_6,"AI");
_4.type="success";
_4.message=this.extractAIMessage(_6,_2,_3)}
}
return _4}
);
isc.B._maxIndex=isc.C+7;
isc.defineClass("OpenAIReasoningEngine",isc.MultimodalGPTEngine);
isc.A=isc.OpenAIReasoningEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.tokenLimit=200000-25000;
isc.B.push(isc.A.transformRequest=function isc_OpenAIReasoningEngine_transformRequest(_1){
var _2=this.Super("transformRequest",arguments);
_2.max_completion_tokens=25000;
return _2}
);
isc.B._maxIndex=isc.C+1;
isc.defineClass("MultimodalGPTEngine",isc.BaseOpenAIEngine);
isc.A=isc.MultimodalGPTEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.tokenLimit=128000;
isc.B.push(isc.A.canSupportVisionRequests=function isc_MultimodalGPTEngine_canSupportVisionRequests(){
return true}
,isc.A.estimateMessageTokenCount=function isc_MultimodalGPTEngine_estimateMessageTokenCount(_1){
if(isc.AIEngine.isImageMessage(_1)){
return 85}
return this.Super("estimateMessageTokenCount",arguments)}
);
isc.B._maxIndex=isc.C+2;
isc.defineClass("GeminiProAIEngine",isc.AIEngine);
isc.A=isc.GeminiProAIEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.name="Gemini Pro";
isc.A.provider="Google";
isc.A.tokenLimit=30720;
isc.A.visionTokenLimit=12288;
isc.A.requestOperationId="fetch";
isc.A.dataSourceName="geminiProRestConnector";
isc.A.visionDataSourceName="geminiProVisionRestConnector";
isc.B.push(isc.A.canSupportVisionRequests=function isc_GeminiProAIEngine_canSupportVisionRequests(){
return true}
,isc.A.estimateRequestTokenCount=function isc_GeminiProAIEngine_estimateRequestTokenCount(_1){
_1=this.normalizeRequest(_1);
this.$102q(_1.prompt==null);
if(isc.AIEngine.isVisionRequest(_1)){
var _2=this.makePromptParts(_1),
_3=0;
for(var i=0;i<_2.length;++i){
var _5=_2[i];
if(isc.isA.String(_5)){
_3+=this.estimateTokenCount(_5)}
}
return _3}
var _3=0,
_6=_1.messages;
if(_6!=null){
for(var i=0;i<_6.length;++i){
_3+=this.estimateMessageTokenCount(_6[i])}
}
return _3}
,isc.A.getTokenLimit=function isc_GeminiProAIEngine_getTokenLimit(_1){
return(isc.AIEngine.isVisionRequest(_1)?this.visionTokenLimit:this.tokenLimit)}
,isc.A.getDataSourceName=function isc_GeminiProAIEngine_getDataSourceName(_1){
return(isc.AIEngine.isVisionRequest(_1)?this.visionDataSourceName:this.dataSourceName)}
,isc.A.makeNonTextPromptPart=function isc_GeminiProAIEngine_makeNonTextPromptPart(_1){
if(isc.AIEngine.isImageMessage(_1)){
return{
inlineData:{
mimeType:isc.AIEngine.$269b(_1),
data:_1.content
}
}}
return this.Super("makeNonTextPromptPart",arguments)}
,isc.A.makePromptParts=function isc_GeminiProAIEngine_makePromptParts(_1){
_1=this.normalizeRequest(_1);
var _2=_1.messages,
_3=0,
_4;
if(_2!=null&&
_2.length>0&&
isc.AIEngine.isImageMessage(_4=_2[_2.length-1]))
{
for(var _5=_2.length;_5>0;--_5){
var _6=_2[_5-1];
if(!isc.AIEngine.isImageMessage(_6)||
_4.source!=_6.source)
{
break}
++_3}
}
if(_3==0||_3==_2.length){
return this.Super("makePromptParts",[_1])}
var _7=_2.duplicate();
_7.setLength(_7.length-_3);
var _8=_7[_7.length-1];
if(_8.source!=_4.source){
_7.push({source:_4.source,content:""})}
var _9;
try{
_1.messages=_7;
_9=this.Super("makePromptParts",[_1])}finally{
_1.messages=_2}
for(var i=0;i<_3;++i){
_9.push(this.makeNonTextPromptPart(_2[_2.length-_3+i]))}
return _9}
,isc.A.transformRequest=function isc_GeminiProAIEngine_transformRequest(_1){
_1=this.normalizeRequest(_1);
var _2=_1.messages;
var _3={
contents:null,
generationConfig:{
temperature:this.getTemperature(_1)
}
};
if(isc.AIEngine.isVisionRequest(_1)){
var _4=this.makePromptParts(_1);
for(var i=0;i<_4.length;++i){
if(isc.isA.String(_4[i])){
_4[i]={text:String(_4[i])}}
}
_3.contents=[{parts:_4,role:"user"}]}else if(_2!=null){
var _6=_3.contents=[];
for(var _7=0;_7<_2.length;++_7){
var _8=_2[_7];
this.$102q(!isc.AIEngine.isImageMessage(_8));
var _9={text:String(_8.content)};
var _10=(_8.source=="AI"?"model":"user");
if(_6.length>0&&_6[_6.length-1].role==_10){
_6[_6.length-1].parts.push(_9)}else{
_6.push({
parts:[_9],
role:_10
})}
}
}
return _3}
,isc.A.isErrorResponse=function isc_GeminiProAIEngine_isErrorResponse(_1,_2){
if(!_1)return true;
var _3=_1.promptFeedback;
if(_3&&_3.blockReason)return true;
var _4=_1.candidates;
if(!isc.isAn.Array(_4)||_4.length==0)return true;
return _4[0].finishReason!="STOP"}
,isc.A.getErrorResponseInfo=function isc_GeminiProAIEngine_getErrorResponseInfo(_1,_2,_3){
if(isc.isA.String(_1)){
var _4=isc.AI._extractJsonResult(_1);
if(_4&&_4.finishReason)_1=_4;
else return{errorMessage:"An error occurred. The response from the server was: "+_1}}else if(!_1)return null;
var _5,
_6;
var _7=_1.promptFeedback,
_8=_1.candidates;
if(_7&&_7.blockReason){
if(_7.blockReason=="SAFETY"){
_5="The request was deemed unsafe.";
_6="requestUnsafe"}else{
var _9=_1.usageMetadata;
if(_9&&
isc.isA.Number(_9.promptTokenCount)&&
_9.promptTokenCount>this.getTokenLimit(_3))
{
_5="The request contained too many tokens.";
_6="requestSizeLimitExceeded"}else{
_5="The request was blocked for an unspecified reason."}
}
}else if(!isc.isAn.Array(_8)||_8.length==0){
_5="No candidates were generated."}else{
var _10=_8[0].finishReason;
if(_10=="MAX_TOKENS"){
_5="The response contained too many tokens.";
_6="responseSizeLimitExceeded"}else if(_10=="SAFETY"){
_5="The response was blocked for safety reasons.";
_6="responseUnsafe"}else if(_10=="RECITATION"){
_5="The response was blocked for recitation reasons."}else{
_5="The first candidate's finishReason was: "+_10}
}
return{
errorMessage:_5,
errorType:_6
}}
,isc.A.makeSpoofedRawResponse=function isc_GeminiProAIEngine_makeSpoofedRawResponse(_1,_2){
if(_1.responseType=="array"||_1.responseType=="object"){
_2="```json\n"+_2+"\n```"}
return{
candidates:[{
content:{
parts:[{
text:_2
}],
role:"model"
},
finishReason:"STOP"
}]
}}
,isc.A.transformRawResponse=function isc_GeminiProAIEngine_transformRawResponse(_1,_2,_3){
var _4={type:"error"};
var _5=_1&&isc.isAn.Array(_1.candidates)&&_1.candidates[0];
var _6=_5&&_5.content&&_5.content.parts;
if(_6==null||_6.length==0){
this.logWarn(_4.errorMessage="Unable to extract the message from the AI response","AI")}else{
var _7="";
if(_6.length>1)this.logWarn(_6.length+" parts were in the AI response","AI");
for(var i=0;i<_6.length;++i){
var _9=_6[i];
if(!("text"in _9)){
this.logWarn("message part was not text: "+isc.JSON.encode(_9),"AI")}else{
_7=(_7!=""?"\n":"")+_9.text}
}
this.logDebug("Response text from AI: "+_7,"AI");
_4.type="success";
_4.message=this.extractAIMessage(_7,_2,_3)}
return _4}
);
isc.B._maxIndex=isc.C+11;
if(!isc.AI)isc.defineClass("AI");
isc.A=isc.AI;
isc.A.requirementsForDisplayingInformationSectionTitle="Requirements for displaying information to the user"
;
isc.AI.registerTemplates({
summarizeDataSource:function(state,sc,j){
var dataSource=state.dataSource,
fields=state.fields||dataSource.getAllFields(),
dsName=dataSource.getID(),
shortDescription=isc.AI.getShortDSDescription(dataSource),
maskedFields=isc.applyMask(fields,isc.AI.salientFieldAttributes);
for(let f=0;f<maskedFields.length;++f){
const field=maskedFields[f];
if(!field.type)field.type="text"}
return isc.trimDoc`
            DataSource '${dsName}' is summarized as "${shortDescription}" and has the following available ${'field'.pluralize(fields.length)}:
            ${j(maskedFields, true)}`},
applicationDataSourcesPromptSection:function(dataSources,sc,j){
var numDataSources=!isc.isA.nonemptyArray(dataSources)?0:dataSources.length;
return isc.trimDoc`
            ## Application DataSources
            ${sc.if(numDataSources == 0,
                "There are no DataSources in the application.",
                isc.trimDoc`
                    There ${sc.if(numDataSources == 1, "is", "are")} ${numDataSources} ${"DataSource".pluralize(numDataSources)} in the application:

                    ${sc.for(dataSources, function (dataSource) {
                        return sc.render("summarizeDataSource", {dataSource: dataSource})}, "\n\n")}`
            )}`},
requirementsForDisplayingInformationPromptSection:function(state,sc,j){
return isc.trimDoc`
            <requirements-document topic="${sc.AI.requirementsForDisplayingInformationSectionTitle}" format="Markdown">
            The user's locale is: ${(sc.FileLoader && sc.FileLoader.currentLocale) || "en"}
            All display text should be translated into that language, and numbers and dates should be formatted for this locale.
            Automatic localized formatting of numbers in UIs may be achieved via the "localeInt"
            and "localeFloat" field types.

            Be concise and brief. Avoid redundancy.

            Use a neutral, professional, analytical tone.
            Avoid casual, emotional, or chatty expressions (e.g. "Let's take a look", "Great job!").

            *Never* refer to the user passively or indirectly (e.g. "the user", "a user").
            *Always* use second-person pronouns to refer to the user ("you"/"your").

            *Never* refer to yourself directly or use first-person pronouns (avoid "I"/"me"/"my"/"myself"/"we"/"us"/"our").

            Do not use overly technical language.
            Do not include programming code.

            Assume that the user understands business applications, including the current application,
            but not the SmartClient framework or its terminology. Use plain language to describe
            things rather than technical terms or identifiers:
            * "AdvancedCriteria" \u2192 "criteria"
            * "DSRequest" used to fetch data \u2192 "query"
            * "ListGrid" \u2192 "table"
            * "FacetChart" \u2192 "chart"
            * "DynamicForm" \u2192 "form"
            * Do not refer to a "ScalarViewer". This type of component displays a single
              number result of a query, along with a title. You should talk about the number,
              its significance, and why you are displaying it rather than talking about the
              ScalarViewer component itself.
            * Do not refer to DataSource field names directly.

            Do not display primary key or foreign key values. Always display titles or labels
            that identify records meaningfully. Any DataBoundComponent that you create should
            also not display primary key or foreign key values. Configure fields with "displayField",
            "valueMap", "optionDataSource", or similar properties.

            Never suggest a fix that wouldn't actually fix the problem. For example, do not
            suggest that the user specify a "by rank" criterion (such as "top 10", "lowest 2%")
            in the description of a filter, because that is not achievable via AdvancedCriteria.
            </requirements-document>`}
});
isc.A=isc.AI;
isc.A.advancedCriteriaAIHelpDocument=(isc.aiHelpDocuments&&isc.aiHelpDocuments["object:AdvancedCriteria"])||{
topic:"AdvancedCriteria",
content:
isc.trimDoc`
                An AdvancedCriteria object expresses record-filtering logic in SmartClient data queries.
                The object usually contains, at minimum, the properties:
                * "_constructor" (only for the top-level object, omitted in subcriteria): the string "AdvancedCriteria"
                * "operator": one of the following operator strings:
                    - Logical operators: "and", "or", "not"
                    - Field operators:
                        * Equality: "equals", "notEqual", "iEquals", "iNotEqual"
                        * Substring: "contains", "notContains", "iContains", "iNotContains"
                        * Prefix: "startsWith", "notStartsWith", "iStartsWith", "iNotStartsWith"
                        * Suffix: "endsWith", "notEndsWith", "iEndsWith", "iNotEndsWith"
                        * Comparison: "greaterThan", "greaterOrEqual", "lessThan", "lessOrEqual"
                        * Null/blank: "isNull", "notNull", "isBlank" (equals null or ""), "notBlank" (neither null nor "")

                    Do not use any other operator.

                You may see that the "_constructor" property has been omitted in the top-level
                object.  That is valid, but it is better to explicitly include "_constructor":"AdvancedCriteria".

                If the "operator" is "equals" (the default), then "operator" may be omitted.

                When using a logical operator, the AdvancedCriteria must have a "criteria" property.
                For "not", this is a single AdvancedCriteria, and for "and"/"or" this is an array
                of two or more AdvancedCriteria.
                The semantics of the logical operators are as follows:
                * "and" requires all subcriteria to be \`true\`.
                * "or" requires at least one subcriterion to be \`true\`.
                * "not" negates the single subcriterion.

                When using a field operator, the AdvancedCriteria object must have the additional properties:
                * "fieldName": the field name
                * "value": the comparison value (omit if "operator" is "isNull", "notNull", "isBlank", or "notBlank")

                For equality and comparison criteria on numeric fields, you must infer the units
                of the field's values from the field's title, description, name or other available
                information about the field. For example, if a field's title is "Area in km^2",
                then you might infer that the field's values have units of square-kilometers.
                Always convert comparison values to the same units that you infer for the
                field's values. For example, if you infer (from the name) that a 'cmLength' field
                has units of centimeters and you want to filter for lengths greater than
                100 inches, then you must convert 100 inches (the comparison value) to the same
                units of the field values (centimeters); "'cmLength' is more than 100 inches"
                can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "greaterThan",
                  "fieldName": "cmLength",
                  "value": 254  // 100 inches converted to centimeters (the units of the 'cmLength' field)
                }
                </code>

                If you are outputting AdvancedCriteria as JSON, then for fields of type "date",
                "value" will be a string in the format "yyyy-MM-dd", where yyyy
                is the four-digit year, MM is the two-digit month (01 = January), and dd is
                the two-digit day of the month. If you are outputting AdvancedCriteria as JavaScript,
                then "value" should be a call to isc.DateUtil.createLogicalDate(year, month, day),
                where \`month\` is 0-based.

                AdvancedCriteria does not support filtering by top-N (e.g. the top 3 records)
                or percentiles directly. To achieve those requirements, configure the "startRow",
                "endRow", and "sortBy" fetch DSRequest properties, or the "dataPageSize" and
                "initialSort" DataBoundComponent properties.

                The equality, substring, prefix, and suffix operators beginning with "i" are
                case-insensitive.

                If the "operator" is "lessThan" or "lessOrEqual" and the field's values may
                be \`null\` (i.e. the field is not "required":\`true\`), then you must be
                explicit about whether to include \`null\` values or not; this is because some
                data queries will treat \`null\` as always less-than any non-\`null\` value,
                but other data queries will not. If you want \`null\` values to be included,
                then use an "or" criterion with one of the subcriteria using "operator":"isNull"
                on the field. If you do not want \`null\` values to be included, then use an
                "and" criterion with one of the subcriteria using "operator":"notNull"
                on the field.
                For example, given a 'testScore' field that is not required (hence, its values
                may be \`null\`):
                "'testScore' is available and less than 75" can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "and",
                  "criteria": [
                    {"fieldName": "testScore", "operator": "notNull"},
                    {"fieldName": "testScore", "operator": "lessThan", "value": 75}
                  ]
                }
                </code>
                "'testScore' is not reported or less than 20" can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "or",
                  "criteria": [
                    {"fieldName": "testScore", "operator": "isNull"},
                    {"fieldName": "testScore", "operator": "lessThan", "value": 20}
                  ]
                }
                </code>

                Example: "'fieldA' is greater than zero" can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "greaterThan",
                  "fieldName": "fieldA",
                  "value": 0
                }
                </code>

                Example: "'orderID' must be non-empty and 'orderTotal' must be more than 0 and
                less than 20" can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "and",
                  "criteria": [
                    {"fieldName": "orderID", "operator": "notBlank"},
                    {"fieldName": "orderTotal", "operator": "greaterThan", "value": 0},
                    {"fieldName": "orderTotal", "operator": "lessThan", "value": 20}
                  ]
                }
                </code>
            `,
format:"Markdown"
}
;
isc.A=isc.AI;
isc.A.aiWasDisabledMessage="AI was disabled.";
isc.A.defaultAIEngineNotRegisteredErrorMessage="The default AI engine '${defaultEngineId}' is not registered.";
isc.A.noAIEngineSupportingVisionRequestsIsRegisteredErrorMessage="No AI engine is registered which supports vision requests.";
isc.A.aiNotAbleToProcessRequestErrorMessage="AI is not able to process your request.";
isc.A.noDataSourcesAvailableOrFoundErrorMessage="There were no data sources available or found.";
isc.A.startingYourRequestDetailMessage="Starting your request\u2026";
isc.A.willSubsetFieldsDetailMessage="Since the data source has a large number of fields, AI will be asked to select which ones are likely to be relevant to your request.";
isc.A.finishedSubsettingFieldsDetailMessage="Finished the request to select the relevant fields.";
isc.A.dataSourceIsRequiredErrorMessage="A globally-installed DataSource with a non-composite primary key is required.";
isc.A.exampleResponseDelineator="$$$$$$$";
isc.A.aiResponseDelineator="#######";
isc.A.scPostDelineator="^^^^^^^";
isc.A.$272z=isc.AIEngine.$272z;
isc.A.$2720=isc.AIEngine.$2720;
isc.A.$262j="context,numStepsCompleted,estimatedNumTotalSteps,newMessages"
;
isc.A=isc.AI;
isc.A.responseTypes=["Execute JavaScript","Clarify","Inspect","Explain Why Not","Ad Hoc UI","Send A Message"];
isc.A.messageTypes=["Notify","Modal Message"];
isc.A.errorTypes={
"ContainsAIDelineator":"The Response should not contain "+isc.AI.aiResponseDelineator+" or "+isc.AI.scPostDelineator,
"NoResponseType":"The Response has no ResponseType, which is invalid.",
"BadResponseType":"The Response has ResponseType ${responseType}, which is not a valid ResponseType.",
"NoMessageType":"The Response has a Message but there is no MessageType, which is invalid.",
"BadMessageType":"The Response has MessageType ${messageType}, which is not a valid MessageType.",
"NoMessage":"ResponseType is ${responseType} but there is no Message in the Response, which is invalid.",
"NoJavaScript":"ResponseType is ${responseType} but there is no JavaScript in the Response, which is invalid.",
"NoCommandComplete":"ResponseType is ${responseType} but the JavaScript code in the Response does not contain a call to isc.AI.commandComplete(). This method should be invoked exactly once when the script's actions are completed",
"JavaScriptError":
"Your attempt to execute JavaScript in the user's session resulted in a JavaScript error.\nThe error message is as follows:\n    ${error.message}\nEnd of error message.\n${hint}The attempted changes have been reverted and no messages have been displayed to the end user.\nPlease provide a revised response in the same format previously described."
}
;
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.serializationFormat="compactJSON";
isc.A.csvFormatDescription="Objects are formatted in a character-separated-values format where each line shows the attribute-values of an object for the following fields:\n${fieldNames}\nAttribute values are separated by ${separator}.\n";
isc.A.separatorCharacter="|";
isc.A.jsonFormatDescription="Objects are serialized as an array of JSON formatted objects.\n";
isc.A.defaultRecordIndexFieldName="data-record index";
isc.A.disabled=true;
isc.A.engineConfigs=[
{
engineId:"gpt-3.5-turbo",
_constructor:"BaseOpenAIEngine",
name:"GPT-3.5 Turbo",
tokenLimit:4096,
supportsJSONMode:true
},
{
engineId:"gpt-4",
_constructor:"BaseOpenAIEngine",
name:"GPT-4",
tokenLimit:8192,
supportsJSONMode:true
},
{
engineId:"gpt-4-turbo",
_constructor:"MultimodalGPTEngine",
name:"GPT-4 Turbo",
tokenLimit:128000,
supportsJSONMode:true
},
{
engineId:"gpt-4o",
_constructor:"MultimodalGPTEngine",
name:"GPT-4o",
tokenLimit:128000,
supportsJSONMode:true,
supportsStructuredOutputs:true
},
{
engineId:"gpt-4o-mini",
_constructor:"MultimodalGPTEngine",
name:"GPT-4o mini",
tokenLimit:128000,
supportsJSONMode:true,
supportsStructuredOutputs:true
},
{
engineId:"gpt-4.1",
_constructor:"MultimodalGPTEngine",
name:"GPT-4.1",
tokenLimit:1047576,
supportsJSONMode:true,
supportsStructuredOutputs:true
},
{
engineId:"gpt-4.1-mini",
_constructor:"MultimodalGPTEngine",
name:"GPT-4.1 mini",
tokenLimit:1047576,
supportsJSONMode:true,
supportsStructuredOutputs:true
},
{
engineId:"gpt-4.1-nano",
_constructor:"MultimodalGPTEngine",
name:"GPT-4.1 nano",
tokenLimit:1047576,
supportsJSONMode:true,
supportsStructuredOutputs:true
},
{
engineId:"gemini-pro",
_constructor:"GeminiProAIEngine"
},
{
engineId:"o1",
_constructor:"OpenAIReasoningEngine"
},
{
engineId:"o3",
_constructor:"OpenAIReasoningEngine"
},
{
engineId:"o3-mini",
_constructor:"OpenAIReasoningEngine",
canSupportVisionRequests:function(){
return false}
},
{
engineId:"o4-mini",
_constructor:"OpenAIReasoningEngine"
}
];
isc.A.defaultEngineId="gpt-4.1";
isc.A.engines={};
isc.A.assistantKey={altKey:true,keyName:"J"};
isc.A.$273s="result,request";
isc.A.defaultMaxRetries=2;
isc.A.sendPromptRetryDelay=5000;
isc.A.$260m=[];
isc.A.templatedStringFunctionsCache=isc.LRUCache.create({
maxSize:10,
keyEvicted:function(_1){
if(isc.AI.logIsDebugEnabled("AI")){
isc.AI.logDebug("Function for templated string "+isc.AI.$289a(_1)+
" was evicted from the cache.","AI")}
}
});
isc.A.useClientSessionHistory=true;
isc.A.adjacentValidationFailureCount=0;
isc.A.$2542=0;
isc.A.canExport=true;
isc.A.canExportCharts=true;
isc.A.canExportGrids=true;
isc.A.canSaveScreens=true;
isc.A.adHocUIWindowDefaults={
_constructor:"Window",
width:"80%",
height:"80%",
canDragResize:true,canDragReposition:true,
keepInParentRect:false,
autoCenter:true,
isModal:true,
title:"AI created User Interface",
showHeaderIcon:true,
bodyProperties:{
padding:10,
layoutMargin:10,
membersMargin:9
},
toolStripDefaults:{
_constructor:"ToolStrip",
autoDraw:false,
width:"100%",
height:40
},
helpButtonDefaults:{
_constructor:"ToolStripButton",
autoDraw:false,
name:"helpWithUI",
prompt:"Ask for help with the dynamically created UI",
click:function(){
this.creator.getHelpWithThisUI()}
},
saveButtonDefaults:{
_constructor:"ToolStripButton",
autoDraw:false,
name:"helpWithUI",icon:"[SKINIMG]actions/save.png",
prompt:"Save this UI for future use",
click:function(){
this.creator.saveAdHocUI()}
},
exportButtonDefaults:{
_constructor:"ToolStripButton",
name:"exportUI",icon:"[SKINIMG]actions/export.png",
click:function(){
this.creator.exportUI()}
},
initWidget:function(){
this.headerIconDefaults.src=isc.AI.getIconURL(true);
this.addAutoChild("helpButton",{icon:isc.AI.getIconURL(true)});
this.addAutoChild("saveButton",{showIf:"isc.AI.canSaveScreens"});
this.addAutoChild("exportButton",{showIf:"isc.AI.canExport"});
this.addAutoChild("toolStrip",{members:[this.helpButton,this.saveButton,this.exportButton]});
this.addItem(this.toolStrip);
return this.Super("initWidget",arguments)},
showCloseButton:true,
showMinimizeButton:false,showMaximizeButton:true,
closeClick:function(){
this.destroy()},
setAdHocUI:function(_1,_2){
this.adHocUI=isc.isAn.Array(_1)?_1[0]:_1;
this.response=_2;
var _3=this.adHocUI&&this.adHocUI.getFirstDBC();
if(!_3){
this.exportButton.hide()}else{
this.exportButton.show();
this.exportButton.prompt=isc.isA.ListGrid(_3)?"Export Grid Data":
"Export Chart"}
this.firstDBC=_3;
if(this.adHocUI){
this.addItem(this.adHocUI,0)}
},
getAdHocUI:function(){
return this.adHocUI},
saveAdHocUI:function(){
isc.AI.showSaveUIWindow(this.response)},
getAdHocUISummary:function(){
return this.adHocUI&&this.adHocUI.getUISummary(["data"])},
exportUI:function(){
var _1=this.adHocUI.getFirstDBC();
if(!_1){
isc.logWarn("No exportable UI.");
return}
var _2=isc.isA.ListGrid(_1),
_3=isc.isA.FacetChart(_1),
_4=[]
;
if(_2){
_4=[
{title:"CSV",val:"csv"},
{title:"JSON",val:"json"},
{title:"XML",val:"xml"},
{title:"XLS (Excel97)",val:"xls"},
{title:"OOXML (Excel2007)",val:"ooxml"}
]}else if(_3){
_4=[
{title:"PNG",val:"png"},
{title:"JPEG",val:"jpeg"}
]}
var _5=isc.Menu.create({
autoDraw:false,
items:_4,
keepInParentRect:true,
itemClick:function(_7){
if(_2){
if(_7.val=="json"){
_1.exportClientData({operationId:"customJSONExport"
})}else{
_1.exportClientData({exportAs:_7.val
})}
}else if(_3){
isc.RPCManager.exportImage(_1.getSvgString(),{
exportDisplay:"download",
exportFilename:"export",
exportImageFormat:_7.val,
exportImageQuality:1
})}
}
})
_5.$91y();
_5.draw();
var _6=_5.getVisibleHeight();
_5.placeNear(this.exportButton.getPageLeft(),
this.exportButton.getPageTop()-_6);
_5.show()},
getHelpWithThisUI:function(){
isc.AI.showAssistant({rootCanvas:this.adHocUI})}
};
isc.A.saveUIWindowDefaults={
_constructor:"Window",
width:300,
autoCenter:true,
autoSize:true,
overflow:"visible",
canDragResize:true,
isModal:true,
canDragReposition:true,
title:"Save AI generated UI",
bodyProperties:{
padding:10,
layoutMargin:10,
membersMargin:9
},
labelDefaults:{
_constructor:"Label",
width:"100%",
height:1,
overflow:"visible",
dynamicContents:true,
contents:"You can save AI-generated screens for later use.  Saved screens are available whenever you open the AI assistant.<br><br>What would you like to name this UI?<br>"
},
formDefaults:{
_constructor:"DynamicForm",
height:"*",
autoFocus:true,
cellPadding:0,
fields:[
{name:"userText",type:"textArea",minHeight:50,width:"*",height:"*",
colSpan:"*",showTitle:false,
hint:"Type a name for your saved UI",showHintInField:true,
keyPress:function(_1,_2,_3,_4){
if(_3=="Enter"){
this.form.creator.saveAdHocUI();
return false}
}
}
]
},
controlsLayoutDefaults:{
_constructor:"HLayout",
width:"100%",
height:1,
overflow:"visible",
align:"right",
membersMargin:8
},
saveButtonDefaults:{
_constructor:"Button",
title:"Save",
autoFit:true,
autoDraw:false,
click:function(){
this.creator.saveAdHocUI()},
layoutAlign:"right"
},
cancelButtonDefaults:{
_constructor:"Button",
title:"Cancel",
autoFit:true,
autoDraw:false,
click:function(){
this.creator.hide();},
layoutAlign:"right"
},
initWidget:function(){
this.Super("initWidget",arguments);
this.addItem(this.addAutoChild("label"));
this.addItem(this.addAutoChild("form"));
this.addAutoChild("saveButton");
this.addAutoChild("cancelButton");
this.addItem(this.addAutoChild("controlsLayout",{members:[this.saveButton,this.cancelButton]}))},
saveAdHocUI:function(){
isc.AI.saveAdHocUI(this.form.getValue("userText"),this.response);
this.hide()},
closeClick:function(){
this.hide()},
setResponse:function(_1){
this.response=_1},
show:function(){
this.form.setValue("userText",(isc.AI.lastUserPrompt||"").substring(0,100));
return this.Super("show",arguments)}
};
isc.A.savedUIStorageKey="savedUI";
isc.A.screensDataSource=null;
isc.A.logLocalDSRequests=false;
isc.A.assistantBlurb="<b>Ask for AI assistance in using this ${isc.AI.isShowcase ? \"Showcase Sample\" : \"application\"}.</b><br><br>You can:<br><br>1. request that the AI configures the existing screen to do something you want (such as configuring complex search criteria for a grid)<br><br>2. request that the AI builds you a custom interface, to enable you to complete tasks more quickly than what the current UI allows. Note that AI-created screens may be saved for future use.<br>";
isc.A.assistantHint="Type your question or request here";
isc.A.assistantWindowDefaults={
_constructor:"Window",
width:500,
autoCenter:true,
autoSize:true,
overflow:"visible",
canDragResize:true,
canDragReposition:true,
title:"SmartClient AI Assistant",
showHeaderIcon:true,
bodyProperties:{
padding:10,
layoutMargin:10,
membersMargin:10
},
labelDefaults:{
_constructor:"Label",
width:"100%",
dynamicContents:true
},
formDefaults:{
_constructor:"DynamicForm",
height:"*",
autoFocus:true,
cellPadding:0,
fields:[
{name:"userText",type:"textArea",minHeight:50,width:"*",height:"*",
colSpan:"*",showTitle:false,
hint:isc.AI.assistantHint,showHintInField:true,
keyPress:function(_1,_2,_3,_4){
if(_3=="Enter"){
this.form.creator.askTheAI();
return false}
}
}
]
},
controlsLayoutDefaults:{
_constructor:"HLayout",
width:"100%",
height:1,
membersMargin:10,
overflow:"visible"
},
savedUIFormDefaults:{
_constructor:"DynamicForm",
width:360,
minWidth:200,
height:1,
overflow:"visible",
autoFocus:false,
autoDraw:false,
cellPadding:0,
layoutAlign:"left"
},
askButtonDefaults:{
_constructor:"Button",
title:"Ask the AI",
autoFit:true,
click:function(){
this.creator.askTheAI()},
layoutAlign:"right"
},
initWidget:function(){
this.headerIconDefaults.src=isc.AI.getIconURL(true);
this.Super("initWidget",arguments);
this.addItem(this.addAutoChild("label",{
contents:isc.AI.assistantBlurb
}));
this.addItem(this.addAutoChild("form"));
this.addItem(this.addAutoChild("controlsLayout"));
this.addAutoChild("savedUIForm",{
fields:[{
name:"savedUI",type:"select",width:"*",
colSpan:"*",
optionDataSource:isc.AI.getScreensDataSource(),
valueField:"name",displayField:"name",
title:"Saved Screens",
wrapTitle:false,
pickListProperties:{canRemoveRecords:true},
changed:function(){
this.form.creator.loadSavedUI(this.getValue());
return false}
}]
});
this.addAutoChild("askButton");
this.controlsLayout.addMembers([
this.savedUIForm,
isc.LayoutSpacer.create({width:"*"}),
this.askButton
])},
askTheAI:function(){
var _1=this.form.getValue("userText")
isc.AI.command(_1,"userQuery");
isc.Notify.addMessage("Asked the AI: \""+_1+"\"")},
loadSavedUI:function(){
var _1=this.savedUIForm.getValue("savedUI");
isc.AI.getSavedUI(_1,function(_2){
isc.AI.handleAIResponse(_2.response.aiResponse)})
},
close:function(){
this.Super("close",arguments);
isc.AI.assistantClosed()}
};
isc.A.clearHistoryOnClose=true;
isc.A.clarifyWindowDefaults={
_constructor:"Window",
width:300,
autoCenter:true,
autoSize:true,
canDragResize:true,
canDragReposition:true,
height:200,
title:"The AI needs your input",
bodyProperties:{
padding:10,
layoutMargin:10,
membersMargin:9
},
labelContents:"",
labelDefaults:{
_constructor:"Label",
width:"100%",
height:1,
contents:""
},
formDefaults:{
_constructor:"DynamicForm",
height:"*",
autoFocus:true,
cellPadding:0,
fields:[
{name:"userText",type:"textArea",minHeight:50,width:"*",height:80,
colSpan:"*",showTitle:false,
hint:"Type your clarifying information here",showHintInField:true,
keyPress:function(_1,_2,_3,_4){
if(_3=="Enter"){
this.form.creator.tellTheAI();
return false}
}
}
]
},
aiButtonDefaults:{
_constructor:"Button",
title:"Tell the AI",
autoFit:true,
click:function(){
this.creator.tellTheAI()},
layoutAlign:"right"
},
initWidget:function(){
this.Super("initWidget",arguments);
this.addItem(this.addAutoChild("label"));
this.addItem(this.addAutoChild("form"));
this.addItem(this.addAutoChild("aiButton"))},
tellTheAI:function(){
var _1=this.form.getValue("userText")
isc.AI.command(_1,"userClarification");
isc.AI.hideClarifyWindow()}
};
isc.A.$2593={result:"invalid"};
isc.A.$270h="aiResponseForBatch,context";
isc.A.useAIFieldPaging=true;
isc.A.salientFieldAttributes=[
"name",
"type",
"required",
"multiple",
"title",
"description",
"valueMap",
"validOperators",
"displayField",
"foreignKey",
"joinType",
"includeFrom",
"includeVia",
"hidden"
];
isc.A.setFieldsFixedPrompt="This is a request by a user to show and/or hide some ListGrid fields in a web application built with the Isomorphic SmartClient Javascript framework. The user request is as follows:\n'${userPrompt}'\nYour response should be a JSON string containing an object with two attributes.\n\"show\": the fields the user wants to show as an array of strings, or an empty array if the user did not ask to show any fields.\n\"hide\": the fields the user wants to hide as an array of strings, or an empty array if the user did not ask to hide any fields.\n\nDo not include any other text in your response.\n\n";
isc.A.setFieldsHiddenFieldsPromptPrefix="The following fields are not currently visible in the grid but are available to be shown.\n";
isc.A.setFieldsVisibleFieldsPromptPrefix="The grid currently contains the following visible fields which may be hidden.\n";
isc.A.$265j="buildResponse,buildRequest";
isc.A.$274q="asyncBuildCriterion";
isc.B.push(isc.A.init=function isc_c_AI_init(){
this.Super("init",arguments);
this.startAssistant(this.assistantKey);
this.$270z();
this.$2700()}
,isc.A.$260x=function isc_c_AI__encodeJSON(_1){
return isc.JSON.encode(_1,{prettyPrint:false})}
,isc.A.doPageRecordsPicking=function isc_c_AI_doPageRecordsPicking(_1,_2,_3,_4){
var _5=[{source:"user",content:_1}],
_6=this.$2678(_5);
return _6.aiEngine.doPageRecordsPicking(_5,_2,_3,_4)
}
,isc.A.$2679=function isc_c_AI__getContextForRequest(_1){
if(this.disabled)return{errorMessage:this.aiWasDisabledMessage};
var _2=this.getEngine();
if(!_2)return{errorMessage:this.defaultAIEngineNotRegisteredErrorMessage.evalDynamicString(this,this)};
this.$102q(this.isEnabled());
var _3,
_4=_2.couldSupportRequest(_1),
_5=isc.AIEngine.containsImageMessage(_1.messages);
if(_4){
_3=_2}else{
var _6=isc.getValues(this.engines),
i=_6.findIndex(_2);
this.$102q(i>=0);
if(i>0){
_6.removeAt(i);
_6.addAt(_2,0)}
for(i=0;i<_6.length;++i){
if(i>0&&_6[i].couldSupportRequest(_1)){
_3=_6[i];
_4=true;
break}
if(!_3&&_5&&_6[i].canSupportVisionRequests()){
_3=_6[i]}
}
}
if(!_3){
return{errorMessage:_5
?this.noAIEngineSupportingVisionRequestsIsRegisteredErrorMessage
:"No suitable AIEngine was found."}}
if(!_4){
this.logWarn("Will use AIEngine "+_3.engineId+", but it claims not to support the request","AI")}
return{
cancellationController:_1.cancellationController,
aiEngine:_3,
couldSupportRequest:_4,
isVisionRequest:_5
}}
,isc.A.$2678=function isc_c_AI__getContextForAIMessages(_1){
var _2={messages:_1};
return this.$2679(_2)}
,isc.A.shouldUseAIFieldPaging=function isc_c_AI_shouldUseAIFieldPaging(_1,_2,_3){
var _4={
messages:[{source:"user",content:_1}]
};
var _5=this.$2679(_4);
return _5.aiEngine.shouldUseAIFieldPaging(_4,_2,_3)}
,isc.A.retrieveFieldsForPrompt=function isc_c_AI_retrieveFieldsForPrompt(_1,_2,_3,_4,_5,_6){
var _7=[{content:_1}];
_5=this.$2678(_7);
return _5.aiEngine.retrieveFieldsForPrompt(_7,_2,_3,_4,_5,_6)}
,isc.A.getSerializedFields=function isc_c_AI_getSerializedFields(_1,_2){
if(_2==null)_2={};
var _3={
engineId:_2.engineId,
fieldNames:_2.salientFieldAttributes||isc.AI.salientFieldAttributes,
recordIndexFieldName:"",
serializationFormat:_2.serializationFormat
};
return this.serializeRecords(_1,_3)}
,isc.A.getShortDSDescription=function isc_c_AI_getShortDSDescription(_1){
var _2={
ID:_1.ID
};
if(_1.title!=null){
_2.title=_1.title}
if(_1.pluralTitle!=null){
_2.pluralTitle=_1.pluralTitle}
if(_1.description!=null){
_2.description=_1.description}
if(_1.titleField!=null){
_2.titleField=_1.titleField}
var _3=_1.getPrimaryKeyFieldNames();
if(_3!=null&&_3.length>0){
if(_3.length==1)_3=_3[0];
_2.primaryKey=_3}
return this.echoFull(_2)}
,isc.A.summarizeDataSource=function isc_c_AI_summarizeDataSource(_1,_2,_3,_4){
var _5=this.getShortDSDescription(_1),
_6=isc.isAn.Array(_2)&&!_2.isEmpty(),
_7=_6&&_4!=false?_1.getSalientFields():[];
if(_6){
for(var i=0;i<_2.length;++i){
var _9=_2[i];
if(isc.isA.String(_9))_9=_1.getField(_9);
if(_9==null)continue;
if(_7.find("name",_9.name)==null){
_7.add(_9)}
}
}
_5+=("\nThis dataSource has the following fields that are relevant to the query:\n"+
this.getSerializedFields(_7,_3));
return _5}
,isc.A.serializeRecords=function isc_c_AI_serializeRecords(_1,_2){
if(_2==null)_2={};
if(_1==null)_1=[];
var _3=_2.serializationFormat||this.serializationFormat;
if(_3=="csv"&&_2.fieldNames==null&&_1.length>0){
_2.fieldNames=isc.getKeys(_1[0])}
var _4=[];
for(var i=0;i<_1.length;i++){
_4.add(this.serializeIndexedRecord(_1[i],i,_2))}
return this.getFormatDescription(_2)+this.$2590(_4,_2)}
,isc.A.$2590=function isc_c_AI__joinSerializedRecords(_1,_2){
var _3=_2.serializationFormat||this.serializationFormat;
var _4=_3!="csv";
var _5=_3=="compactJSON";
var _6=(_5?",":(_4?",\n":"\n"));
var _7=
(_5?"[":(_4?"[\n":""))+
_1.join(_6)+
(_5?"]":(_4?"\n]":""));
return _7}
,isc.A.getFormatDescription=function isc_c_AI_getFormatDescription(_1){
if(_1==null)_1={};
var _2=_1.serializationFormat||this.serializationFormat,
_3=_2!="csv",
_4=_1.recordIndexFieldName!=null?_1.recordIndexFieldName:this.defaultRecordIndexFieldName,
_5=_4!="",
_6=_1.fieldNames||[];
if(_5){
_6=_6.duplicate();
_6.unshift(_4)}
var _7=_6.join(","),
_8=!_3?this.csvFormatDescription:this.jsonFormatDescription;
_8=_8.evalDynamicString(this,{
fieldNames:_7,
separator:this.separatorCharacter
});
return _8}
,isc.A.serializeIndexedRecord=function isc_c_AI_serializeIndexedRecord(_1,_2,_3){
if(_1==null)return"";
if(_3==null)_3={};
var _4=_3.serializationFormat||this.serializationFormat;
var _5=_4!="csv";
var _6=_4=="compactJSON";
var _7=_3.fieldNames;
if(!_5&&_7==null){
_7=isc.getKeys(_1);
this.logWarn(
"serializeIndexedRecord is serializing in a format where attribute names are not included in the output.Attributes will be output in the following order:"+_7.join(",")
)}
var _8=(_3.recordIndexFieldName!=null?_3.recordIndexFieldName:this.defaultRecordIndexFieldName);
var _9=(_8!="");
var _10="";
if(_4=="csv"){
if(_9)_10+=this.$2591(String(_2),_3);
for(var _11=0;_11<_7.length;_11++){
_10+=((_9||_11>0?this.separatorCharacter:"")+
this.$2591(_1[_7[_11]],_3))}
}else{
if(_7!=null){
_1=isc.applyMask(_1,_7)}
if(_9){
var _12={};
_12[_8]=_2;
_1=isc.addProperties(_12,_1)}
_10=isc.JSON.encode(_1,{prettyPrint:!_6})}
return _10}
,isc.A.$2591=function isc_c_AI__csvSerializeAttribute(_1,_2){
if(_1==null)return"";
return isc.isA.String(_1)?_1.asSource():_1+""}
,isc.A.isEnabled=function isc_c_AI_isEnabled(){
return this.disabled!=true&&
(this.defaultEngineId in this.engines||
this.engineConfigs.find("engineId",this.defaultEngineId)!=null)}
,isc.A.registerEngine=function isc_c_AI_registerEngine(_1){
if(_1.engineId in this.engines)return false;
this.engines[_1.engineId]=_1;
return true}
,isc.A.unregisterEngine=function isc_c_AI_unregisterEngine(_1){
if(!(_1 in this.engines))return false;
return delete this.engines[_1]}
,isc.A.getEngine=function isc_c_AI_getEngine(_1,_2){
_1=_1||isc.AI.defaultEngineId;
var _3=this.engines[_1];
if(_3==null){
var _4=this.engineConfigs.find("engineId",_1);
if(_4==null)return null;
var _5=isc.addProperties({engineId:_1,name:_1},_4,_2);
var _6=_4._constructor||"AIEngine";
_3=isc[_6].create(_5);
this.engines[_1]=_3}
return _3}
,isc.A.allowAssistant=function isc_c_AI_allowAssistant(){
return true}
,isc.A.startAssistant=function isc_c_AI_startAssistant(_1){
if(isc.AI.aiReady)return;
if(!isc.AI.allowAssistant()){
isc.logWarn("No AI engine API key found found.  Can't install AI.","AI");
return}
if(_1)isc.AI.assistantKey=_1;
_1=isc.AI.assistantKey;
var _2=isc.Page.getRegisteredKeyActions(_1);
if(_2&&_2.length>0){
isc.logWarn("Specified AI shortcut-key ("+JSON.stringify(_1)+") is already in use by another handler. To enable the AI assistant shortcut, call isc.AI.startAssistant() with an unused key-name.","AI");
return}
isc.Page.registerKey(_1,function(_1,_3){
_3.showAssistant();
return false},isc.AI);
isc.AI.aiReady=true}
,isc.A.stopAssistant=function isc_c_AI_stopAssistant(){
if(!isc.AI.aiReady){
isc.AI.logWarn("Cannot stop the AI Assistant - it isn't running.");
return}
isc.Page.unregisterKey(isc.AI.assistantKey,isc.AI);
isc.AI.aiReady=false}
,isc.A.$274v=function isc_c_AI__asyncAIOperation(_1,_2){
if(!this.isEnabled()){
return isc.rejectAsDisabled(this.aiWasDisabledMessage)}
var _3=Array.prototype.slice.call(arguments,1);
return isc.AsyncUtil.asyncOperation(_2,function(_4){
_3.push(_4);
return isc.AI[_1].apply(isc.AI,_3)})}
,isc.A.$273t=function isc_c_AI__asyncDataBoundAIOperation(_1,_2){
if(!this.isEnabled()){
return isc.rejectAsDisabled(this.aiWasDisabledMessage)}
var _3=Array.prototype.slice.call(arguments,1);
return isc.AsyncUtil.asyncDataBoundOperation(_2,function(_13){
var _4=_13.component||_13.dataSource;
var _5=_4&&_4.getAllNamedFields();
var _6=_2.relevantFieldNames;
if(_5&&!_5.isEmpty()){
var _7=_5.makeIndex("name"),
_8=isc.getKeys(_7),
_9=_2.excludeFieldNames;
if(_6){
for(var i=0;i<_6.length;++i){
var _11=_6[i];
if(!_11||_11.contains('.'))continue;
if(!_8.contains(_11)&&
!_6.contains(_11,i+1))
{
isc.AI.logWarn("'"+_11+"' is listed in `relevantFieldNames`, but there is no such field.","AI")}
}
_7=isc.applyMask(_7,_6)}
if(_9){
for(var i=0;i<_9.length;++i){
var _12=_9[i];
if(!_12||_12.contains('.'))continue;
if(!_8.contains(_12)&&
!_9.contains(_12,i+1))
{
isc.AI.logWarn("'"+_12+"' is listed in `excludeFieldNames`, but there is no such field.","AI")}
delete _7[_12]}
}
_13.availableFields=isc.getValues(_7);
_13.availableFieldNames=_13.availableFields.getProperty("name");
_13.availableFieldsIndex=_7}else if(_6&&!_6.isEmpty()){
isc.AI.logWarn("Relevant field names were specified, but there are no named fields. Ignoring...","AI")}
_3.push(_13);
return isc.AI[_1].apply(isc.AI,_3)})}
,isc.A.$273v=function isc_c_AI__wrapAsyncDataBoundAIOperation(_1,_2){
var _3=Array.prototype.slice.call(arguments,1,-1),
_4=arguments[arguments.length-1];
var _5=function(_7){
var _6=isc.AI.$273s;
isc.AI.fireCallback(_4,_6,[_7,_2])};
this[_1].apply(this,_3)
.$271y(_5)}
,isc.A.summarizeValue=function isc_c_AI_summarizeValue(_1,_2){
this.$273v("asyncSummarizeValue",_1,_2)}
,isc.A.asyncSummarizeValue=function isc_c_AI_asyncSummarizeValue(_1){
return this.$273t("$271m",_1)}
,isc.A.$271m=function isc_c_AI__asyncSummarizeValue(_1,_2){
var _3=_1.aiRequest;
if(!_3){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"aiRequest"}))}
var _4=_1.value;
if(!_4){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"value"}))}
var _5=[
"This is a request to supplement a value from a DataSource, using relevant general knowledge and your own reasonable inferences. The supplemental information requested is:",
"${ssMessages}"
];
var _6=[{content:_3.prompt,type:_3.promptType}],
_7=_3.additionalMessages;
if(_7){
_6.addList(_7);
_6.removeEmpty()}
var _8=_2.availableFields,
_9=_1.record,
_10=_1.fieldName,
_11;
if(_8){
var _12=_8,
_13=_2.availableFieldNames;
var _14;
if(_10){
var _15=_13.indexOf(_10);
if(_15<0){
this.logWarn("A field with name '"+_10+"' is not available. Ignoring...","AI");
_10=null}else{
_13.removeAt(_15);
_14=_12[_15]}
}
if(_2.dataSource){
var _16=this.summarizeDataSource(_2.dataSource,_12,{format:"compactJSON"},false);
_5.push(
"The value to be summarized is from "+
(_10?"the '"+_10+"' field of ":"")+
"the DataSource with the following description: "+_16+"\n\n"
)}else{
this.$102q(_2.component);
if(_14){
_5.push(
"The value to be summarized comes from the DataBoundComponent field with the following description (in JSON format): "+
this.serializeIndexedRecord(_14,null,{
recordIndexFieldName:"",
fieldNames:this.salientFieldAttributes,
format:"compactJSON"
})+"\n\n"
)}
}
if(_9){
if(_13.isEmpty()){
this.logWarn("The context record was specified, but no additional fields are relevant to the request.","AI")}else{
_11={
recordIndexFieldName:"",
fieldNames:_13,
format:"compactJSON"
};
_5.push(
"The record that the value is part of is (in JSON format): "+
this.serializeIndexedRecord(_9,null,_11)+"\n\n"
)}
}
}else{
if(_9){
this.logWarn("The record was specified, but no fields are available. Ignoring...","AI")}
if(_10){
this.logWarn("fieldName was specified, but no fields are available. Ignoring...","AI")}
}
var _17=isc.InternalAIMessagesBuilder2.create({
ssMessages:_6,
messagesSource:_1.aiRequestSource||"system",
target:this,
evalVars:{
value:_4
}
});
_17.appendPrompts(_5);
_5=null;
var _18=_17.aiMessages;
var _19=_1.examples;
if(_19&&!_19.isEmpty()){
if(_1.valueType!=null&&_1.valueType!="text"){
this.logWarn("The valueType of examples must be 'text'. Omitting the examples...","AI")}else{
var _20="For example: ";
for(var _21=0;_21<_19.length;++_21){
var _22=_19[_21];
_20+="For the value '"+(_22.value||"")+"'";
if(_11&&_22.record){
_20+=" and record "+this.serializeIndexedRecord(
_22.record,null,_11)}
_20+=", you might generate '"+(_22.summary||"")+"'.\n"}
_18.push({
source:"system",
content:_20
})}
}
_18.push({
source:"system",
content:"Your response should be a single JSON object with one key \"result\" and value being the string of supplemental information for the value. The value is:"
});
_18.push({
content:_4,
type:_1.valueType
});
var _23={
messages:_18,
responseType:"object",
cancellationController:_2.cancellationController,
willHandleError:true
};
var _24=this.$2679(_23);
if(_24.errorMessage)return isc.rejectWithError(_24.errorMessage);
var _25={
maxRetries:_1.maxRetries
};
return _24.aiEngine.asyncSendRequest(_23,_25)
.then(function(_28){
var _26=_28.message.content,
_27;
if(!isc.isAn.Object(_26)||
!isc.isA.String(_26.result)||
!(_27=_26.result.trim()))
{
return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage)}
return{
type:"success",
summary:_27
}})}
,isc.A.command=function isc_c_AI_command(_1,_2){
if(_1==null)return;
if(_2=="complete"){
if(_1!=null){
}
return}
if(_2!="userQuery"&&_2!="resolveError"&&_2!="userClarification"){
return}
if(_2=="userQuery"){
isc.AI.lastUserPrompt=_1}
var _3=isc.AI.getSession(),
_4=_3[0],
_5=_3[1],
_6=_3[2];
if(_6==null&&this.useClientSessionHistory){
_5={};
_6=this.sessionMessages=[this.getInitiatorMessage(_5)];
_1="** Initial request **\n"+_1}
var _7=function(_9,_10){
isc.AI.handleAIResponse(_9,_10.clientContext)};
var _8=(_6||[]).concat([{source:(_2=="resolveError"?"system":"user"),content:_1}]);
this.sendRequest({
messages:_8,
historyIntroduction:"You have previously interacted with this user during this session as follows. Input from the user, including contextual information automatically provided by SmartClient, is delineated by "+
isc.AI.scPostDelineator+" at the beginning and end of that information. Your responses are delineated by "+isc.AI.aiResponseDelineator+" at the beginning and end.",
historyConclusion:"** New request **",
historyDelimiters:{
user:isc.AI.scPostDelineator,
model:isc.AI.aiResponseDelineator
}
},_7,{clientContext:_5});
this.addUserRequestToSessionHistory(_1,_5)}
);
isc.evalBoundary;isc.B.push(isc.A.origSendPrompt=function isc_c_AI_origSendPrompt(_1,_2,_3){
this.sendRequest({messages:[{source:"user",content:_1}]},_2,_3)}
,isc.A.sendRequest=function isc_c_AI_sendRequest(_1,_2,_3){
_3=isc.addProperties({},_3);
var _4=isc.AI.getEngine(_3.engineId);
if(!_4){
this.logWarn("Couldn't find any AI Engine with engineId: "+_3.engineId);
return}
_4.sendRequest(_1,function(_6,_1){
var _5=_6.message&&_6.message.content;
if(_5==null){
_4.logWarn("Unable to extract message from AI response","AI");
return}
_4.logDebug("Response text from AI: "+_5,"AI");
isc.AI.fireCallback(_2,"messageContent,config",[_5,_3])},_3)}
,isc.A.$289a=function isc_c_AI___textifyCacheKey(_1){
var _2="In the context of an Isomorphic SmartClient application,";
if(_1.startsWith(_2)){
_1="..."+_1.substring(_2.length)}
_1="'"+_1.replaceAll("\n","\\n")+"'";
if(_1.length>300)_1=_1.substring(0,166)+"..."+_1.substring(_1.length-129);
return _1}
,isc.A.$289b=function isc_c_AI__getPromptFromTemplatedString(_1,_2){
var _3=this.templatedStringFunctionsCache.get(_1);
if(_3){
if(this.logIsDebugEnabled("AI")){
isc.AI.logDebug("Cache hit for templated string "+isc.AI.$289a(_1),"AI")}
}else{
var _4=_1.replaceAll("\\","\\\\")
.replaceAll("`","\\`");
_3=new Function("evalVars","with(evalVars){return`"+_4+"`}");
this.templatedStringFunctionsCache.put(_1,_3)}
try{
return _3(Object(_2))}catch(e){
throw isc.createErrorResult("Failed to evaluate a templated string to make an AI prompt: "+String((e&&e.message)||e).asHTML(),{
templatedString:_1,
evalVars:_2
})}
}
,isc.A.asyncSendPrompt=function isc_c_AI_asyncSendPrompt(_1,_2,_3,_4){
var _5=Promise.withResolvers();
this.sendPrompt(_1,_2,function(_6){
if(!_6||_6.type!="success"){
_5.reject(isc.defaultAsyncOperationCatchCallback(_6))}else{
_5.resolve(_6)}
},_3,_4);
return _5.promise}
,isc.A.sendPrompt=function isc_c_AI_sendPrompt(_1,_2,_3,_4,_5){
var _6=isc.addPropertiesWithAssign({},_5,{willHandleError:true});
try{
_6.prompt=this.$289b(_1,_2)}catch(e){
var _7=isc.defaultAsyncOperationCatchCallback(e);
this.delayFireCallback(_3,isc.AIEngine.$2889,[_7,_6,_4]);
return}
var _8;
if(_4&&_4.engineId){
_8=this.getEngine(_4.engineId);
if(!_8){
this.logWarn("Couldn't find any AI Engine with engineId: "+_4.engineId+
"; using default")}
}
if(!_8){
var _9=this.$2679(_6);
if(_9.errorMessage){
var _7=isc.createErrorResult(_9.errorMessage);
this.delayFireCallback(_3,isc.AIEngine.$2889,[_7,_6,_4]);
return}
_8=_9.aiEngine}
_8.sendRequest(_6,_3,_4)}
,isc.A.estimateTokenCount=function isc_c_AI_estimateTokenCount(_1,_2){
var _3=isc.AI.getEngine(_2&&_2.engineId);
return _3.estimateTokenCount(_1)}
,isc.A.getVB=function isc_c_AI_getVB(){
if(this.isReify)return window.VB;
return null}
,isc.A.commandComplete=function isc_c_AI_commandComplete(_1){
isc.Class.endAEM();
if(this.isReify&&this.$2541){
isc.AI.getVB().destroyProjectState(this.$2541)}
var _2=isc.AI.lastResponse||{};
var _3=_1?isc.JSON.encode(_1):null;
isc.logWarn("commandComplete() called - "+
(_3?"JSON serialized to: "+_3:"no JSON to serialize"));
if(_2.message&&!isc.isAn.emptyString(_2.message)){
if(_2.messageType=="Notify")isc.Notify.addMessage(_2.message);
else isc.say(_2.message)}
if(_3)isc.AI.command(_3,"complete")}
,isc.A.getSessionHistory=function isc_c_AI_getSessionHistory(){
return this.getSession()[0]}
,isc.A.getSessionContext=function isc_c_AI_getSessionContext(){
return this.getSession()[1]}
,isc.A.getSessionMessages=function isc_c_AI_getSessionMessages(){
return this.getSession()[2]}
,isc.A.getSession=function isc_c_AI_getSession(){
var _1=this.sessionHistory;
var _2=this.sessionContext;
var _3=this.sessionMessages;
return[_1,_2,_3]}
,isc.A.clearSession=function isc_c_AI_clearSession(){
delete this.sessionHistory;
delete this.sessionContext;
delete this.sessionMessages}
,isc.A.addUserRequestToSessionHistory=function isc_c_AI_addUserRequestToSessionHistory(_1,_2){
if(this.useClientSessionHistory){
if(!this.sessionHistory)this.sessionHistory="";
this.sessionHistory+="\n"+this.scPostDelineator+_1+this.scPostDelineator;
if(!this.sessionMessages)this.sessionMessages=[];
this.sessionMessages.push({source:"user",content:_1});
if(_2!=null){
if(this.sessionContext==null)this.sessionContext={};
isc.addProperties(this.sessionContext,_2)}
}
}
,isc.A.addAIResponseToSessionHistory=function isc_c_AI_addAIResponseToSessionHistory(_1){
if(this.useClientSessionHistory){
var _2=isc.AI.cleanAIResponse(_1);
if(!this.sessionHistory)this.sessionHistory="";
this.sessionHistory+="\n"+this.aiResponseDelineator+_2+this.aiResponseDelineator;
if(!this.sessionMessages)this.sessionMessages=[];
this.sessionMessages.push({source:"AI",content:_2})}
}
,isc.A.handleAIResponse=function isc_c_AI_handleAIResponse(_1,_2){
this.addAIResponseToSessionHistory(_1);
var _3=isc.AI.validateAIResponse(_1);
this.handleValidatedAIResponse(_3,_2)}
,isc.A.handleValidatedAIResponse=function isc_c_AI_handleValidatedAIResponse(_1,_2){
isc.AI.lastResponse=isc.addProperties({},_1);
if(_1.errors&&_1.errors.length>0){
this.logWarn("The following errors were found during response validation:"+this.echoAll(_1.errors));
if(_1.unableToProcess){
this.adjacentValidationFailureCount++;
if(this.adjacentValidationFailureCount>4){
isc.say("The AI is unable to process this request as written. Please try rephrasing your request.")}else{
var _3="The response you shared was not formatted correctly. Please rewrite the response in the specified format. The specific error(s) encountered are as follows:\n- "+_1.errors.join("\n- ");
this.command(_3,"resolveError")}
return}
}
this.adjacentValidationFailureCount=0;
switch(_1.responseType){
case"Execute JavaScript":
var _4=isc.AI.handleAIJavaScript(_1,_2);
break;
case"Clarify":
this.showClarifyWindow(_1.message);
break;
case"Inspect":
var _4=isc.AI.handleAIJavaScript(_1,_2);
break;
case"Explain Why Not":
case"Send A Message":
var _4=isc.AI.commandComplete();
break;
case"Ad Hoc UI":
var _4=isc.AI.handleAIJavaScript(_1,_2);
break;
default:
}
}
,isc.A.getErrorText=function isc_c_AI_getErrorText(_1,_2){
return isc.AI.errorTypes[_1].evalDynamicString(this,_2)}
,isc.A.validateAIResponse=function isc_c_AI_validateAIResponse(_1){
var _2=[];
var _3={};
if(!_1||isc.isAn.emptyString(_1)){
_2.add("No Response Content");
_3.errors=_2;
_3.unableToProcess=true;
return _3}else{
var _4=isc.AI.parseAIResponse(_1);
_3=_4.response;
var _5=_3.responseType;
if(_4.aiResponse!=_1){
_2.add(this.getErrorText("ContainsAIDelineator",_3))}
if(!_5||_5==""){
_2.add(this.getErrorText("NoResponseType",_3));
_3.unableToProcess=true}else if(!isc.AI.responseTypes.contains(_5)){
_2.add(this.getErrorText("BadResponseType",_3));
_3.unableToProcess=true}
if(_3.message){
if(_5!="Clarify"){
if(!_3.messageType){
_2.add(this.getErrorText("NoMessageType",_3));
_3.unableToProcess=true}else if(!isc.AI.messageTypes.contains(_3.messageType)){
_2.add(this.getErrorText("BadMessageType",_3));
_3.unableToProcess=true}
}
}
if(["Send A Message","Explain Why Not","Clarify"].contains(_3.messageType)){
if(!_3.message||isc.isAn.emptyString(_3.message)){
_2.add(this.getErrorText("NoMessage",_3));
_3.unableToProcess=true}else if(_5!="Clarify"){
if(!isc.AI.messageTypes.contains(_3.messageType)){
_2.add(this.getErrorText("BadMessageType",_3));
_3.unableToProcess=true}
}
}
if((_5=="Inspect"||_5=="Execute JavaScript")&&
(!_3.javaScript||_3.javaScript.length==0)){
_2.add(this.getErrorText("NoJavaScript",_3));
_3.unableToProcess=true}
if(_3.noCommandComplete){
if(_5=="Inspect"){
_2.add(this.getErrorText("NoCommandComplete",_3));
_3.unableToProcess=true}else if(_5=="Execute JavaScript"||_5=="Ad Hoc UI"){
_3.fireCommandComplete=true}
}
}
if(_2.length>0)_3.errors=_2;
_3.aiResponse=_1;
isc.logInfo(isc.echoFull(_3));
return _3}
,isc.A.cleanAIResponse=function isc_c_AI_cleanAIResponse(_1){
var _2=_1.replaceAll(
isc.AI.exampleResponseDelineator,""
).replaceAll(
isc.AI.aiResponseDelineator,""
).replaceAll(
isc.AI.scPostDelineator,""
);
return _2
}
,isc.A.parseAIResponse=function isc_c_AI_parseAIResponse(_1){
var _2=this.cleanAIResponse(_1);
var _3={};
_3.responseType=this.retrieveAttributeValue("ResponseType:",_2);
_3.messageType=this.retrieveAttributeValue("MessageType:",_2);
_3.message=this.retrieveAttributeValue("Message:",_2,["MessageType:","======","ResponseType:"]);
_3.javaScript=this.retrieveAttributeValue("======",_2,["======"]);
if(_3.javaScript){
var _4=new RegExp(/(isc\.AI\.commandComplete\()([\s\S]*?)(\))+/)
if(_3.javaScript.match(_4)==null){
_3.noCommandComplete=true}
}
return{response:_3,aiResponse:_2}}
,isc.A.retrieveAttributeValue=function isc_c_AI_retrieveAttributeValue(_1,_2,_3){
var _4="(?:$|\\n)";
if(_3!=null&&_3.length>0){
_4="(?:$|\\n\\s*"+_3.join("|\\n\\s*")+")"}
var _5="(?:\\n|^)\\s*"+_1+"([\\s\\S]*?)"+_4;
var _6=_2.match(new RegExp(_5));
if(_6!=null)_6=_6.last().trim();
return _6}
,isc.A.handleAIJavaScript=function isc_c_AI_handleAIJavaScript(_1,_2){
if(this.isReify){
this.$2541=isc.AI.getVB().getProjectState()}
var _3=_1.javaScript,
_4=_1.responseType=="Ad Hoc UI",
_5
;
if(_4)_5=isc.noAutoDraw=true;
var _6=this;
delete this.aemError;
var _7=_2&&_2.idMapping;
var _8;
if(_7){
_8={};
for(var _9 in _7){
var _10=isc.AutoTest.getLocatorCanvas(_7[_9][0]);
if(_10!=null){
_8[_9]=_10}
}
}
var _11=isc.Class.evaluateAICode(
_3,
function(_14){
this.aemError=_14;
if(_14.errorType=="Timeout"){
_6.handleAEMTimeout()}else{
_6.handleAEMError(_14.error)}
},
true,
_4,
_8
);
if(this.aemError){
delete this.aemError;
return}
if(_1.fireCommandComplete){
this.commandComplete()}
if(_4){
isc.AI.uiWindow=this.createAdHocUIWindow();
var _12=_11.globals;
var _13=isc.Canvas.$112q(_12,true);
isc.AI.uiWindow.setAdHocUI(_13,_1);
isc.AI.uiWindow.show()}
}
,isc.A.handleAEMError=function isc_c_AI_handleAEMError(_1){
this.resetApplicationState();
this.logWarn("Error executing AI-generated script:"+_1);
var _2=this.errorTypes["JavaScriptError"];
var _3=_1.message,
_4=this.getJSErrorHint(_3)||"";
var _5=_2.evalDynamicString(this,{error:_1,hint:_4});
this.$2542++;
if(this.$2542>2){
this.$2542=0;
isc.say("The AI-generated script has caused an execution error. Please rephrase your request and try again.")}else{
this.command(_5,"resolveError")}
}
,isc.A.resetApplicationState=function isc_c_AI_resetApplicationState(){
if(this.isReify&&this.$2541!=null){
isc.AI.getVB().restoreProjectState(this.$2541);
delete this.$2541}else{
}
}
,isc.A.getJSErrorHint=function isc_c_AI_getJSErrorHint(_1){
var _2="";
if(new RegExp("^\S+ is undefined").test(_1)){
_2="\nSmartClient components are available by the ID in global scope. SmartClient classes may be accessed via their class name with the prefix \"isc.\" in global scope.\n"}
return _2}
,isc.A.handleAEMTimeout=function isc_c_AI_handleAEMTimeout(){
this.logWarn("Timeout after executing AI-generated script - either the code flow failed to complete, or did not invoke AI.commandComplete() when it completed.")}
,isc.A.getDataSourceNames=function isc_c_AI_getDataSourceNames(){
if(this.applicationDataSources!=null){
var _1=[];
for(var i=0;i<this.applicationDataSources.length;i++){
var _3=this.applicationDataSources[i];
if(isc.DataSource.get(_3)!=null){
_1.add(_3)}
}
return _1}
return(isc.AI.isReify?
isc.AI.getVB().getProjectDataSourceNames():
isc.DS.getRegisteredDataSourceObjects(true,true,true,true).getProperty("ID"))}
,isc.A.getDataSourceDefinitions=function isc_c_AI_getDataSourceDefinitions(_1){
if(_1==null)_1="pseudocode";
if(isc.AI.isReify){
return isc.AI.getVB().getProjectDataSourceDefinitions(_1)}else{
var _2=this.getDataSourceNames();
if(_2&&_2.length>0){
_2=_2.map(function(_3){return isc.DataSource.get(_3)})}
return isc.DS.getRegisteredDataSourceDefinitions(_1,false,_2)}
}
,isc.A.getUISummary=function isc_c_AI_getUISummary(_1){
var _2=this.customRootCanvas;
if(!_2)_2=this.applicationRootCanvas;
if(_2==null){
if(isc.AI.isReify){
var _3=isc.AI.getVB();
_2=_3&&_3.getScreenBaseComponent()}else if(isc.AI.isShowcase){
var _4=window["featureExplorer_exampleViewer"];
if(_4){
if(_4.fullScreenExampleWindow&&
_4.fullScreenExampleWindow.isDrawn()&&
_4.fullScreenExampleWindow.isVisible())
{
_2=_4.fullScreenExampleWindow.viewPane.viewContainer}else if(
_4.viewPane&&
_4.viewPane.isDrawn()&&
_4.viewPane.isVisible()
){
_2=_4.viewPane.viewContainer
}
}
}
}
if(_2==null){
var _5=isc.Canvas.$tw||[];
for(var i=0;i<_5.length;i++){
var _7=_5[i];
if(_7==null)continue;
if(isc.isA.ScreenSpan(_7))continue;
if(!_7.isVisible()||!_7.isDrawn()){
continue}
if(isc.isA.Menu(_7))continue;
if(_7==isc.AI.assistantWindow)continue;
if(_7.children!=null){
_2=_7;
break}
}
}
if(_2==null)return"";
var _8=_2.getUISummary(["data"]);
var _9={},
_10=isc.JSON.encode(this.postProcessUISummary(_8,_9));
return _1?[_10,_9]:_10}
,isc.A.postProcessUISummary=function isc_c_AI_postProcessUISummary(_1,_2){
if(isc.isA.Array(_1)){
for(var i=0;i<_1.length;i++){
this.postProcessUISummary(_1[i],_2)}
}else if(isc.isA.Object(_1)&&!isc.isA.Date(_1)){
for(var _4 in _1){
this.postProcessUISummary(_1[_4],_2)}
}
var _5=_1&&_1.smartClientComponentType;
if(_5!=null){
_1.$eu=function(_10,_11,_12){
var _5=this.smartClientComponentType;
var _6={};
var _7=this.id;
var _8=window[_7];
if(_8&&_8._autoAssignedID){
var _9=_8.getLocalId();
var i=0;
_7=_9;
while(_2[_7]!=null){
_7=_9+"_"+(++i)}
_2[_7]=[isc.AutoTest.getObjectLocator(_8),_9,_8.getScreenId()]}
_6.ID=_7;
isc.addProperties(_6,this);
delete _6.$eu;
delete _6.smartClientComponentType;
delete _6.id;
return"isc."+_5+".create("+isc.JSON.encode(_6,{prettyPrint:true,leadingIndent:_10})+")"}
}
return _1}
,isc.A.createAdHocUIWindow=function isc_c_AI_createAdHocUIWindow(){
return isc.Window.create(isc.AI.adHocUIWindowDefaults)}
,isc.A.showSaveUIWindow=function isc_c_AI_showSaveUIWindow(_1){
if(!isc.AI.saveUIWindow){
isc.AI.saveUIWindow=isc.Window.create(isc.AI.saveUIWindowDefaults)}
isc.AI.saveUIWindow.setResponse(_1);
isc.AI.saveUIWindow.show();
isc.AI.saveUIWindow.bringToFront()}
,isc.A.hideSaveUIWindow=function isc_c_AI_hideSaveUIWindow(){
if(isc.AI.saveUIWindow)isc.AI.saveUIWindow.hide()}
,isc.A.getScreensDataSource=function isc_c_AI_getScreensDataSource(){
if(!this.screensDataSource)this.screensDataSource=this.getLocalDataSource();
return this.screensDataSource}
,isc.A.getLocalDataSource=function isc_c_AI_getLocalDataSource(){
return this.$243t({
transformRequest:function(_1){
if(_1.doNotTrackRPC==null)_1.doNotTrackRPC=!isc.ss.logLocalDSRequests;
return _1},
_generated:true,
storageMode:"allRecords",
storageKey:this.savedUIStorageKey
})}
,isc.A.$243t=function isc_c_AI__getLocalDataSource(_1){
var _2=this;
return isc.LocalDataSource.create(_1,{
fields:[
{name:"name",primaryKey:true},
{name:"response",type:"text",length:1000000}
],
destroy:function(){
return this.Super("destroy")}
})}
,isc.A.saveAdHocUI=function isc_c_AI_saveAdHocUI(_1,_2){
isc.AI.getScreensDataSource().addData({name:_1,response:_2});
isc.say("Ad Hoc UI saved.")}
,isc.A.getSavedUI=function isc_c_AI_getSavedUI(_1,_2){
isc.AI.getScreensDataSource().fetchData({name:_1},
function(_3,_4,_5){
if(isc.isAn.Array(_4))_4=_4[0];
if(_2)_2(_4)}
)}
,isc.A.removeSavedUI=function isc_c_AI_removeSavedUI(_1){
isc.AI.getScreensDataSource().removeData({name:_1})}
,isc.A.showAssistant=function isc_c_AI_showAssistant(_1){
if(!isc.AI.assistantWindow){
isc.AI.assistantWindow=isc.Window.create(isc.AI.assistantWindowDefaults)}
isc.AI.initAssistantContext(_1);
isc.AI.assistantWindow.show()}
,isc.A.hideAssistant=function isc_c_AI_hideAssistant(){
if(isc.AI.assistantWindow)isc.AI.assistantWindow.close()}
,isc.A.assistantClosed=function isc_c_AI_assistantClosed(){
if(this.clearHistoryOnClose&&this.useClientSessionHistory)this.clearSession();
delete isc.AI.assistantContext;
delete isc.AI.customRootCanvas}
,isc.A.initAssistantContext=function isc_c_AI_initAssistantContext(_1){
if(isc.AI.assistantWindow){
if(isc.AI.assistantWindow.isVisible())isc.AI.hideAssistant()}else isc.AI.clearSession();
isc.AI.assistantContext=_1;
this.customRootCanvas=_1&&_1.rootCanvas}
,isc.A.useAssistant=function isc_c_AI_useAssistant(_1,_2){
isc.AI.initAssistantContext(_2);
isc.AI.command(_1,"userQuery")}
,isc.A.showClarifyWindow=function isc_c_AI_showClarifyWindow(_1){
if(!isc.AI.clarifyWindow){
isc.AI.clarifyWindow=isc.Window.create(isc.AI.clarifyWindowDefaults)}
var _2=isc.AI.clarifyWindow;
_2.label.setContents(_1);
_2.form.clearValues();
_2.show()}
,isc.A.hideClarifyWindow=function isc_c_AI_hideClarifyWindow(){
if(isc.AI.clarifyWindow)isc.AI.clarifyWindow.hide()}
,isc.A.getIconURL=function isc_c_AI_getIconURL(_1){
return isc.Media.getStockIconSrc("AIAssist")}
,isc.A._extractJsonResult=function isc_c_AI__extractJsonResult(_1,_2,_3,_4){
if(_2==null){
_2='{'}
if(_3==null){
_3='}'}
var _5=_1.lastIndexOf(_3);
if(_5<0)return this.$2593;
_1=_1.substring(0,_5+(_4?0:_3.length));
var _6;
while((_6=_1.indexOf(_2))>=0){
_1=_1.substring(_6+(_4?_2.length:0));
try{
return isc.JSON.decode(_1)}catch($al){
if(!_4)_1=_1.substring(_2.length)}
}
return this.$2593}
,isc.A.asyncRepeatRequestOnBatches=function isc_c_AI_asyncRepeatRequestOnBatches(_1,_2,_3,_4,_5){
var _6=[];
if(!this.isEnabled()){
return isc.rejectAsDisabled(this.aiWasDisabledMessage,{aiResponsesForBatches:_6})}
var _7=_4.cancellationController,
_8;
if(_7){
if(_7.canceled){
return Promise.reject(_7.asCanceledResult({
aiResponsesForBatches:_6
}))}
_8=_7.createSubController()}else{
_8=isc.CancellationController.create()}
var _9=_4.maxPasses==null?2:_4.maxPasses;
if(_9<1){
return isc.rejectWithError("Exceeded the maximum number of passes.",{aiResponsesForBatches:_6})}
var _10=this.$2679(_1);
if(_10.errorMessage)return isc.rejectWithError(_10.errorMessage,{aiResponsesForBatches:_6});
_10.aiResponsesForBatches=_6;
var _11=_10.secondPassBatches=[];
var _12={
maxRetries:_4.maxRetries==null?2:_4.maxRetries
};
var _13={
serializationFormat:"compactJSON",
fieldNames:_3,
maxRetries:_12.maxRetries,
cancellationController:_8,
aiPageSize:_4.maxRecordsPerBatch,
recordIndexFieldName:_4.recordIndexFieldName
};
var _14=_4.$270i;
if(!_14){
_1=isc.addPropertiesWithAssign({},_1);
_1.cancellationController=_8;
_1.willHandleError=true;
_14=_10.aiEngine.getBatches(_1,_2,_13)}else{
_14=_14.duplicate();
for(var i=0;i<_14.length;++i){
var _16=_14[i]=isc.addPropertiesWithAssign({},_14[i]);
_16.aiRequest=isc.addPropertiesWithAssign({},_16.aiRequest);
_16.aiRequest.cancellationController=_8;
_16.aiRequest.willHandleError=true}
}
var _17=_4.stopOnError!=false;
var _18=function(_16,_23){
if(_7&&_7.canceled)return;
_23.startIndex=_16.startIndex;
_23.length=_16.length;
_6.push(_23);
_23.callbackReturnValue=isc.AI.fireCallback(_5,isc.AI.$270h,[_23,_10]);
return _23};
var _19=isc.ResolvedValuesMapper.create({
values:_14,
keepSettledStatus:!_17?true:null,
cancellationController:_7,
maxConcurrent:_4.maxConcurrent,
asyncMap:function(_16){
return _10.aiEngine.asyncSendRequest(_16.aiRequest,_12)
.then(function(_23){
return _18(_16,_23)},function(_23){
var _20=_23.errorType;
if(_9>=2&&_16.length>=2&&
(_20=="requestSizeLimitExceeded"||_20=="responseSizeLimitExceeded"))
{
_11.addList(_10.aiEngine.splitBatch(_16));
return null}
if(_17&&!_8.canceled){
_8.cancel("The request for the batch starting at "+
_16.startIndex+", length "+_16.length+" failed: "+
isc.getAsyncMessage(_23),"external")}
return Promise.reject(_18(_16,_23))})}
});
return _19.getPromise()
.then(function(){
if(_7&&_7.canceled){
return Promise.reject(_7.asCanceledResult({
aiResponsesForBatches:_6
}))}
if(_11.isEmpty()){
isc.AI.$102q(!_17||!_7||!_7.canceled);
return{
type:"success",
aiResponsesForBatches:_6
}}
isc.AI.$102q(_9>=2);
var _21=isc.addPropertiesWithAssign({},_4);
_21.cancellationController=_8;
_21.$270i=_11;
_21.maxPasses=_9-1;
var _22=function(_23,_24){
_6.push(_23);
return isc.AI.fireCallback(_5,isc.AI.$270h,
[_23,_10])};
return isc.AI.asyncRepeatRequestOnBatches(_1,_2,_3,_21,_22)
.then(function(){
return{
type:"success",
aiResponsesForBatches:_6
}})})}
,isc.A.buildSort=function isc_c_AI_buildSort(_1,_2,_3,_4){
_4=isc.addProperties({},_4,{showPrompt:false,context:_3});
var _5=_3.grid||_3.rootCanvas;
var _6=_3.dataSource;
var _7=_6!=null?isc.getValues(_6.getFields()):_5.getFields();
var _8="This is a request for an array of SortSpecifiers to apply to a ListGrid in a web application built with the Isomorphic SmartClient Javascript framework. The SortSpecifiers should fulfill the following user request:\n'"+_1+"'\n";
_8+="Your response should include only the SortSpecifiers array and no other text.\n\nEach sort specifier consists of two attributes - 'property' (the property to sort by) and 'direction' (either 'ascending' or 'descending'). If the user is requesting the existing sort be cleared, return an empty array.\n";
_8+="For example, an appropriate response to a user request of 'Sort by supplierName, then by unitCost in descending order' might be as follows:\n[{\"fieldName\":\"supplierName\",\"direction\":\"ascending\"},[{\"fieldName\":\"unitCost\",\"direction\":\"descending\"}]\n\n";
_8+="For context, what follows is the list of fields available for use in SortSpecifiers - ";
if(this.shouldUseAIFieldPaging(_8,_7,_4)){
var _9=this;
this.retrieveFieldsForPrompt(
_1,"Apply sorting by field(s)",_7,
function(_10){
_9.$2597(_1,_8,_2,_3,_4,_10)},
_3,_4
)}else{
this.$2597(_1,_8,_2,_3,_4,_7)}
}
,isc.A.$2597=function isc_c_AI__buildSortWithFinalFields(_1,_2,_3,_4,_5,_6){
_2+=this.getSerializedFields(_6,_5);
var _7=this;
isc.AI.origSendPrompt(
_2,
function(_9){
var _8=_7._extractJsonResult(_9);
_7.fireCallback(_3,"result,context",[_8,_4])},
_5)}
,isc.A.buildSetFields=function isc_c_AI_buildSetFields(_1,_2,_3,_4){
_4=isc.addProperties({},_4,{showPrompt:false,context:_3});
var _5=this.setFieldsFixedPrompt.evalDynamicString(this,{userPrompt:_1})
var _6=_3.grid||_3.rootCanvas;
var _7=_6.getAllFields();
var _8=[];
var _9=[];
for(var i=0;i<_7.length;i++){
if(!_6.fieldIsVisible(_7[i])){
_9.add(_7[i])}else{
_8.add(_7[i])}
}
_5+=this.setFieldsVisibleFieldsPromptPrefix;
_5+=this.getSerializedFields(_8,_4)+"\n\n";
if(this.shouldUseAIFieldPaging(_5,_9,_4)){
var _11=this;
this.retrieveFieldsForPrompt(
_1,"Showing and hiding fields in a databound component",_9,
function(_12){
_11.$2598(_1,_5,_2,_3,_4,_12)},
_3,_4
)}else{
this.$2598(_1,_5,_2,_3,_4,_9)}
}
,isc.A.$2598=function isc_c_AI__buildSetFieldsWithFinalFields(_1,_2,_3,_4,_5,_6){
_2+=this.setFieldsHiddenFieldsPromptPrefix;
_2+=this.getSerializedFields(_6,_5);
var _7=this;
isc.AI.origSendPrompt(
_2,
function(_9){
var _8=_7._extractJsonResult(_9);
_7.fireCallback(_3,"result,context",[_8,_4])},
_5)}
,isc.A.buildGroupBy=function isc_c_AI_buildGroupBy(_1,_2,_3,_4){
_4=isc.addProperties({},_4,{showPrompt:false,context:_3});
var _5=_3.grid||_3.rootCanvas;
var _6=_5.getFields();
var _7="This is a request to determine which field or fields to pass to ListGrid.groupBy() in a web application built with the Isomorphic SmartClient Javascript framework. "
_7+="Your response should be strutured as a JSON string containing an array of objects.\nEach object should have the \"fieldName\" attribute set to the field the user wishes to group by.\nIf the user requested any existing grouping be cleared, the response JSON string should contain an array.\n\n";
_7+="Examples of appropriate responses to user requests:\n\nrequest:\nGroup by supplierName\nresponse:\n[{\"fieldName\":\"supplierName\"}]\n\nrequest:\nGroup the grid by availability, then by region\nresponse:\n[{\"fieldName\":\"availability\"},{\"fieldName\":\"region\"}]\n\nrequest:\nClear the current grouping\nresponse:\n[]\n\n";
_7+="For context, what follows is the list of fields in the Grid.\n";
_7+=this.getSerializedFields(_6,_4);
_7+="\n\nrequest:\n'"+_1+"'\nresponse:\n";
var _8=this;
isc.AI.origSendPrompt(
_7,
function(_10){
var _9=_8._extractJsonResult(_10);
_8.fireCallback(_2,"result,context",[_9,_3])},
_4)}
,isc.A.asyncSendRequest=function isc_c_AI_asyncSendRequest(_1,_2){
var _3=this.$2679(_1);
if(_3.errorMessage)return isc.rejectWithError(_3.errorMessage);
return _3.aiEngine.asyncSendRequest(_1,_2)}
,isc.A.$262k=function isc_c_AI__supportsAIComponentViews(_1,_2){
if(false){
return false}
var _3=_1.getID();
if(_3==null||isc.DS.get(_3)!==_1)return false;
if(!_1.supportsAdvancedCriteria())return false;
var _4=_1.getPrimaryKeyFieldNames();
if(_4==null||_4.length!=1||!_4[0])return false;
return true}
,isc.A.$267n=function isc_c_AI__createBuildViaAIContext(_1,_2,_3){
var _4=_3.cancellationController;
var _5={
$267o:Promise.withResolvers(),
cancellationController:_4,
$274w:_4?_4.createSubController():isc.CancellationController.create(),
$268c:_1,
buildRequest:_2,
$261v:0,
$261w:0,
$261x:null,
$261g:{
maxRetries:(_2.maxRetries==null?2:_2.maxRetries),
serializationFormat:"compactJSON"
}
};
if(_1=="asyncApplyAIFilter")_5.applyRequest=_2;
var _6;
if(_4){
_6=isc.observe(_4,"cancel","isc.AI.$2786(returnVal,observed,observer.$266t,reason,initiator)");
isc.addProperties(isc.Page.$2091[_6].observer,{
$266t:_5
})}
var _7=function(_9){
_5.$274w.destroy();
if(_6!=null)isc.ignore(_6);
var _8=_5.$261x;
if(_8&&!_8.destroyed){
if(_9.type=="canceled"){
_8.hide();
_8.destroy()}else{
if(_9.type=="error"){
isc.AI.$262i(
_5,
[{category:"error",content:isc.getAsyncMessage(_9)}],
true)}
_8.finish(_9.type=="success")}
}
};
_5.$267o.promise.then(_7,_7);
return _5}
,isc.A.$262i=function isc_c_AI__fireAIProgressCallback(_1,_2,_3){
if(_1.$274w.canceled)return;
var _4=_1.$261v,
_5=_1.$261w;
this.$102q(_4<=_5);
var _6=_1.$261x;
if(_6){
_6.setProgress(_4,_5);
_6.addMessages(_2);
if(_3)_6.show()}
isc.AI.fireCallback(
_1.buildRequest.progressCallback,
isc.AI.$262j,
[_1,_4,_5,_2]
)}
,isc.A.$265h=function isc_c_AI__cancelBuildViaAI(_1,_2,_3){
_1.$267o.reject({
type:"canceled",
cancellationReason:_2,
cancellationInitiator:_3
})}
,isc.A.$2786=function isc_c_AI___handleCancelBuildViaAI(_1,_2,_3,_4,_5){
if(!_1)return;
this.$102q(_2===_3.cancellationController);
this.$265h(_3,_4,_5)}
,isc.A.$2677=function isc_c_AI__wrapAsyncBuildViaAIOperation(_1,_2,_3){
var _4=function(_6){
var _5=_1=="asyncApplyAIFilter"?isc.AI.$266z:isc.AI.$265j;
isc.AI.fireCallback(_3,_5,[_6,_2])};
return this[_1](_2)
.$271y(_4)}
,isc.A.$267p=function isc_c_AI__asyncSummarizeUserMessages(_1){
var _2=_1.buildRequest,
_3=_2.userAIRequest;
var _4=[{content:_3.prompt,type:_3.promptType}];
if(_3.additionalMessages){
_4.addList(_3.additionalMessages);
_4.removeEmpty()}
_1.$2616=_4;
var _5=[],
_6=[];
for(var _7=0;_7<_4.length;++_7){
if(isc.AIEngine.isImageMessage(_4[_7])){
_5.push(_7);
_6.push(this.$267q(_4[_7],_1))}
}
if(_5.isEmpty()){
_1.$2615=_4;
return Promise.resolve(_4)}
_1.$2615=_4.duplicate();
_1.$261w+=_5.length;
this.$262i(_1,[{category:"detail",content:"AI will be asked to summarize your request."}],true);
return Promise.all(_6)
.then(function(_10){
var _8=_1.$2615;
for(var i=0;i<_5.length;++i){
_8[_5[i]]=_10[i]}
isc.AI.$262i(
_1,
[{
category:"success",
content:"Finished summarizing your request"
}]
);
return _8})}
);
isc.evalBoundary;isc.B.push(isc.A.$267q=function isc_c_AI__asyncSummarizeImage(_1,_2){
var _3={
cancellationController:_2.$274w,
messages:[
{content:"Summarize in detail the following image:",source:"system"},
isc.addProperties({},_1,{source:"user"})
],
willHandleError:true
};
return this.asyncSendRequest(_3,_2.$261g)
.then(function(_4){
++_2.$261v;
isc.AI.$262i(_2);
return{content:"An image described as: "+_4.message.content}})}
,isc.A.$267a=function isc_c_AI__canUseAICriterion(_1,_2){
if(_1.$264d!=null&&_1.$264d!=_2.getID()){
this.logWarn("'aiFilter' criterion built for DataSource '"+_1.$264d+"' is being used with DataSource '"+_2.getID()+"'.","AI")}
if(_1.$264d!=_2.getID()||
!_1.$2615||
!isc.isAn.Array(_1.$263s)||
!isc.isAn.Array(_1.$263t)||
!_1.$263q)
{
return false}
var _3=_2.getPrimaryKeyFieldNames();
if(_1.$263s.length!=_3.length)return false;
for(var i=0;i<_3.length;++i){
if(!_1.$263s.contains(_3[i]))return false}
var _5=_2.getFields();
for(var i=0;i<_1.$263t.length;++i){
if(!(_1.$263t[i]in _5))return false}
if(_1.$263v!=null&&!isc.isA.Class(_1.$263v)){
return false}
if(_1.$264f!=null&&!isc.isA.Class(_1.$264f)){
return false}
return true}
,isc.A.$268n=function isc_c_AI__getPromptText(_1,_2){
if(this.$267a(_1,_2)){
var _3=_1.userAIRequest;
if(_3!=null&&
isc.AIEngine.$272z(_3.promptType)&&
_3.prompt!=null)
{
return String(_3.prompt)}
}
return""}
,isc.A.$267j=function isc_c_AI__applyUsableAIFilterCaches(_1,_2,_3){
var _4={
matchingRecords:null,
remainingRecords:null
};
if(_1.isTrivial){
_4.matchingRecords=_2}else{
var _5=_1.$263v,
_6=_1.$264f;
if(!isc.isA.Class(_5))_5=null;
if(!isc.isA.Class(_6))_6=null;
var _7=_4.matchingRecords=[];
if(_5||_6){
var _8=_4.remainingRecords=[];
var _9=_1.$263s;
if(_9.length==1){
var _10=_9[0];
for(var _11=0;_11<_2.length;++_11){
var _12=_2[_11][_10];
if(_5&&_5.has(_12)){
}else if(_6&&_6.has(_12)){
_7.add(_2[_11])}else{
_8.add(_2[_11])}
}
}else{
this.$102q(false)}
}else _4.remainingRecords=_2}
return _4}
,isc.A.$2665=function isc_c_AI__clearAICriterionState(_1){
delete _1.$2615;
delete _1.$264d;
delete _1.$263s;
delete _1.$263t;
delete _1.$263q;
delete _1.$68o;
if(isc.isA.Class(_1.$263v)){
_1.$263v.clear()}
delete _1.$263v;
delete _1.$2667;
if(isc.isA.Class(_1.$264f)){
_1.$264f.clear()}
delete _1.$264f}
,isc.A.$268o=function isc_c_AI__getCleanAICriterion(_1){
var _2=isc.addPropertiesWithAssign({},_1);
delete _2.$263v;
delete _2.$2667;
delete _2.$264f;
delete _2.$2631;
delete _2.clone;
delete _2.criteria;
return _2}
,isc.A.$268p=function isc_c_AI__createFromCleanAICriterion(_1){
var _2,
_3;
if(isc.isAn.Array(_1.$263s)){
if(_1.$263s.length==1){
_2=isc.Set.create();
_3=isc.Set.create()}else{
_2=isc.TupleSet.create();
_3=isc.TupleSet.create()}
}
return isc.addProperties({},_1,{
_constructor:"AdvancedCriteria",
operator:"aiFilter",
$263v:_2,
$2667:null,
$264f:_3,
$2631:true,
clone:isc.AI.$2668
})}
,isc.A.$2668=function isc_c_AI__aiCriterionCloneImpl(){
return this}
,isc.A.$267r=function isc_c_AI__createBuildCriterionContext(_1,_2,_3){
var _4=this.$267n(_1,_2,_3);
_4.dataSource=_3.dataSource;
var _5=_2.mode;
if(_5==null)_5="hybrid";
else if(_5!="aiAssist"&&_5!="AIDE"&&_5!="hybrid"){
this.logWarn("unsupported AI service mode '"+_5+"'. Switching to 'hybrid'.");
_5="hybrid"}
_4.mode=_5;
if(_2.showProgressDialog==null||_2.showProgressDialog){
_4.$261x=isc.FilterViaAIProgressDialog.create(_2.progressDialogProperties,{
$266t:_4,
canCancel:_2.userCanCancel!=false
})}
_4.$261w=1;
this.$262i(_4,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
return _4}
,isc.A.buildCriterion=function isc_c_AI_buildCriterion(_1,_2){
this.$2677(this.$274q,_1,_2)}
,isc.A.asyncBuildCriterion=function isc_c_AI_asyncBuildCriterion(_1){
return this.$273t("$274x",_1)}
,isc.A.$274x=function isc_c_AI__asyncBuildCriterion(_1,_2){
var _3=this.$267r(this.$274q,_1,_2),
_4=_1.dataSource;
if(!_4||!this.$262k(_4,_3.mode)){
_3.$267o.reject(isc.createErrorResult(this.dataSourceIsRequiredErrorMessage))}else{
this.$267p(_3)
.then(function(_5){
return isc.AI.$267s(
_5,_3)})
.then(function(_5){
_3.$267o.resolve({type:"success",criterion:_5})},function(_5){
_3.$267o.reject(isc.defaultAsyncOperationCatchCallback(_5))})}
return _3.$267o.promise}
);
isc.B._maxIndex=isc.C+105;
isc.AI.registerTemplates({
buildCriterionCommonIntro:function(state,sc){
const purpose=state.purpose;
return isc.trimDoc`
            In the context of a business application developed using the Isomorphic SmartClient Framework,
            this is a request to generate an AdvancedCriteria object to apply to a DataBoundComponent
            for the purpose of ${sc.if(purpose == "hilite",
                "hiliting data-records",
                "filtering the data-records shown in the DataBoundComponent to only the ones"
            )} that match the following natural language description of criteria:
            <criteria-description>\${userMessages}</criteria-description>

            The DataBoundComponent's DataSource is:
            \${dsSummary}`},
buildCriterionAIAssistCommonResponseObjectPropertiesDescription:function(state,sc){
return isc.trimDoc`
            * "fieldSummaries" (object): A map from the name of each field of the DataSource to a string containing
              a shortened summary of all of the following details that you infer about the
              field from the field's title, description, and other available information:
                - For numeric fields, the units of the field's values if applicable,
                  or whether the units are unknown.
                - The pattern or format of the field's values.
                - Whether the field's values may be \`null\`, and hence require special care
                  in less-than comparisons.
                - Any assumptions that you are making about the field's values.
                - Any uncertainties that you have about the field's values.
            * "criteriaSummary" (string): A shortened summary of all of the following details
              that you infer from the criteria-description:
                - The units of any numeric values mentioned in the criteria-description.
                - The list of field names that are relevant.
                - When comparing a value mentioned in the criteria-description to the values
                  of a field, any conversions of units and reformatting that you made to make
                  the comparison value have the same units and format of field values.
                - When selecting field values less-than a comparison value, whether the
                  criteria-description implies that \`null\` values should be included or
                  excluded.
                - Any assumptions that you are making about the described criteria.
                - Any uncertainties that you have about the described criteria.`},
buildCriterionCommonOutro:function(state,sc){
const advancedCriteriaAIHelpDocument=isc.AI.advancedCriteriaAIHelpDocument;
return isc.trimDoc`
            Here is information about the AdvancedCriteria object:
            <requirements-document topic="${advancedCriteriaAIHelpDocument.topic}"${sc.if(advancedCriteriaAIHelpDocument.format, ` format="${advancedCriteriaAIHelpDocument.format}"`)}>
            ${advancedCriteriaAIHelpDocument.content}</requirements-document>

            For reference, consider the current date and time to be: ${state.referenceTime}

            ${sc.render("requirementsForDisplayingInformationPromptSection")}`},
buildCriterionHybridPrompt:function(state,sc){
const purpose=state.purpose;
return isc.trimDoc`
            ${sc.render("buildCriterionCommonIntro", state)}

            There are two methods of ${sc.if(purpose == "hilite", "hiliting", "filtering")}
            the data-records of the DataBoundComponent:
            1. Generate an AdvancedCriteria object that directly corresponds to the criteria-description.
            2. Evaluate each data-record on a case-by-case basis, using the properties of each data-record,
               all reasonable inferences, and your own knowledge to decide whether a data-record matches
               the criteria-description.

            Method 1 is preferred if you can create such an AdvancedCriteria object.

            Your response must be a JSON object.

            If you decide that method 1 is sufficient, your response object must contain the
            following properties:
            ${sc.render("buildCriterionAIAssistCommonResponseObjectPropertiesDescription", state)}
            * "result": The AdvancedCriteria object that fulfills the criteria-description.

            If you decide that method 2 can fulfill the criteria-description, your response
            must be exactly '{ "result": "method2" }'

            In all other cases, your response object must contain the following properties:
            * "result": The string "invalid"
            * "invalidReasoning": A plain text string directed
              at the user containing your reason(s) why you are unable to generate a functional
              AdvancedCriteria object that fulfills the criteria-description and why evaluating
              each data-record on a case-by-case basis is also insufficient. In the "invalidReasoning" string,
              you must abide by the "${sc.AI.requirementsForDisplayingInformationSectionTitle}" below
              and phrase things in the context of ${sc.if(purpose == "hilite", "hiliting", "filtering")}
              records.

            ${sc.render("buildCriterionCommonOutro", state)}
        `},
buildCriterionAIAssistPrompt:function(state,sc){
const purpose=state.purpose;
return isc.trimDoc`
            ${sc.render("buildCriterionCommonIntro", state)}

            Your response must be a JSON object with the following properties:
            ${sc.render("buildCriterionAIAssistCommonResponseObjectPropertiesDescription", state)}
            * "result" (string or object):
                - If you are unable to generate a functional AdvancedCriteria object from the
                  criteria-description, "result" must be the string "invalid".
                - Otherwise, "result" must be the AdvancedCriteria object that fulfills the
                  criteria-description.
            * "invalidReasoning" (only if "reason" is "invalid"): A plain text string directed
              at the user containing your reason(s) why you are unable to generate a functional
              AdvancedCriteria object that fulfills the criteria-description. In the "invalidReasoning" string,
              you must abide by the "${sc.AI.requirementsForDisplayingInformationSectionTitle}" below
              and phrase things in the context of ${sc.if(purpose == "hilite", "hiliting", "filtering")}
              records.

            ${sc.render("buildCriterionCommonOutro", state)}
        `}
});
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.$268u=[
"and",
"or",
"not",
"isBlank","notBlank",
"isNull","notNull",
"equals","notEqual","iEquals","iNotEqual",
"contains","notContains","iContains","iNotContains",
"startsWith","notStartsWith","iStartsWith","iNotStartsWith",
"endsWith","notEndsWith","iEndsWith","iNotEndsWith",
"greaterThan",
"lessThan",
"greaterOrEqual",
"lessOrEqual"
];
isc.A.fixCriterionPrompts=[
"The user of a web application built with the Isomorphic SmartClient JavaScript Framework has requested to filter the data-records of a data-bound component according to the following filter-query:",
"${userMessages}",
"The data-bound component's DataSource has the following summary:\n${dsSummary}\n\nYou generated the following AdvancedCriteria object:\n${encodedCriterion}\n\nThe reason(s) why this is invalid are:\n${validationErrors}\n\n${encodedValidatedCriterion ? 'We have attempted to fix your AdvancedCriteria as follows:\\n' + encodedValidatedCriterion + '\\n\\n' : ''}Here is information about the AdvancedCriteria object:\n<help-document topic=\""+isc.AI.advancedCriteriaAIHelpDocument.topic+"\" format=\""+isc.AI.advancedCriteriaAIHelpDocument.format+"\">\n"+
isc.AI.advancedCriteriaAIHelpDocument.content,
"</help-document>\n\nYou are to generate a different AdvancedCriteria object that satisfies the user's filter-query *and* avoids the validation errors listed above.\nIf you are unable to do this, then your response should be exactly '{ \"result\": \"invalid\" }'"
];
isc.A.allowedCriterionPropertyNames=["fieldName","fieldQuery","operator","value","valuePath","valueQuery","start","end"];
isc.A.$266z="applyResponse,applyRequest";
isc.A.$274r="asyncApplyAIFilter";
isc.A.applyAIFilterPrompts=[
"The objects in the source-array below represent data-records from a DataSource. Using the properties on each data-record, the summary of the DataSource, and your own knowledge, determine which data-records match the user-supplied filter-query:",
"${userMessages}",
"The DataSource has the following summary:\n${dsSummary}\n\nFor example, if the query was 'amount is larger than 100', you should look for a field with a name most related to 'amount' and compare its value to 100.\n\nYour response should be a JSON object with a single property called 'result'.  This property should be set to an array of integers, where each integer is the index of a matching record in the source-array below.  For example, if the first data-record in the array below matches the user's filter-query, your response array must include its source-array index (0) as the first entry.  Similarly, the source-array indices of any other matching data-records must also be in your response array.\n\nIf a data-record does not match the filter-query, do not include its index in your response array.\n\nIf no data-records match, the 'result' property in your response object should be set to an empty array."
];
isc.A.$274s="asyncBuildHilites";
isc.A.buildHilitesPrompts=[
"This is a request for one or more hilites to apply to a DataBoundComponent (such as a ListGrid) in a web application built with the Isomorphic SmartClient JavaScript Framework.  For reference, consider the current date and time to be: ${referenceTime}.  A hilite applies specific styling (such as a text color, background color, and/or font-weight) to one or more fields of records that match a filter-query.  The user's description of the styling to apply, the fields that should have this styling, and/or the filter-query is:\n<description-of-hilites>",
"${userMessages}",
"</description-of-hilites>\n\nThe DataBoundComponent's DataSource has the following summary:\n${dsSummary}\n\nYour response should be a JSON object with a single key \"hiliteSpecs\": an array of the HiliteSpec objects. Each HiliteSpec object has the following format:\n{\"hiliteDescription\":The user's description for this particular Hilite, as a string.  This should be written from the same perspective/point-of-view as description-of-hilites, as if the user had written this themself,\n\"filterDescription\":Just the description of the filter-query, as a string.  This should be written from the same perspective/point-of-view as description-of-hilites, as if the user had written this themself,\n\"backgroundColor\":If the user requested a background color, a CSS color or color-name of the requested background color,\n\"textColor\":If the user requested a text color, a CSS color or color-name of the requested text color,\n\"cssText\":The CSS source code for any other styling requested by the user, if any,\n\"fieldName\":If the user requested that the styling is applied to certain fields, an array of the field names.  This property should be omitted if the user did not specify any specific fields to have hilite styling,\n\"replacementValue\":If the user requested that certain fields' values be replaced, the replacement value\n}\n\nHere are examples of CSS properties to use within \"cssText\":\nfont-weight: bold\nfont-style: italic\ntext-decoration-line: one of the following keywords: none, underline, overline, strike-through\ntext-decoration-color: a CSS color or color-name for the text decoration line\n\nValid color-names are: white, lightgray, gray, darkgray, black, lightred, red, darkred, lightpink, pink, darkpink, lightpurple, purple, darkpurple, lightorange, orange, darkorange, lightbrown, brown, darkbrown, lightyellow, yellow, darkyellow, lightgreen, green, darkgreen, lightblue, blue, darkblue, turquoise, teal, gold, bronze, beige\n\nNote: If the user-request did not explicitly specify the hilite styling, assume \"make the text color red\".\n\nFor example, if the user request was \"Show a light red background on the userName for records where the payment is overdue\", a valid response might be:\n{\"hiliteSpecs\": [{\"fieldName\":\"userName\",\n\"backgroundColor\":\"lightred\",\n\"filterDescription\":\"payment is overdue\",\n\"hiliteDescription\":\"Show a light red background on the userName for records where the payment is overdue\"}]\n}\n\nOr, if the user request was \"Hilite every row where assetImprovement is less than 5\", a valid response might be:\n{\"hiliteSpecs\": [{\"textColor\":\"red\",\n\"filterDescription\":\"assetImprovement is less than 5\",\n\"hiliteDescription\":\"Hilite every row where assetImprovement is less than 5\"}]\n}\n\nOr, if the user request was \"highlight population with light green background and red text where population is greater than 3000000 and highlight country with red text where continent is Africa\", a valid response might be:\n{\"hiliteSpecs\": [{\"fieldName\":\"population\",\n\"backgroundColor\":\"lightgreen\",\n\"textColor\":\"red\",\n\"filterDescription\":\"population is greater than 3000000\",\n\"hiliteDescription\":\"highlight population with light green background and red text where population is greater than 3000000\"\n}, {\"fieldName\":\"country\",\n\"textColor\":\"red\",\n\"filterDescription\":\"continent is Africa\",\n\"hiliteDescription\":\"highlight country with red text where continent is Africa\"\n}]\n}\n\n"
];
isc.A.$270x={
"white":"#fff",
"lightgray":"#ddd",
"gray":"#aaa",
"darkgray":"#555",
"black":"#000",
"lightred":"#f88",
"red":"#e00",
"darkred":"#800",
"lightpink":"#f9c",
"pink":"#f69",
"darkpink":"#f06",
"lightpurple":"#ccf",
"purple":"#96f",
"darkpurple":"#60c",
"lightorange":"#fc9",
"orange":"#f71",
"darkorange":"#f42",
"lightbrown":"#eb8",
"brown":"#840",
"darkbrown":"#320",
"lightyellow":"#ffa",
"yellow":"#ff5",
"darkyellow":"#970",
"lightgreen":"#cfc",
"green":"#0f0",
"darkgreen":"#060",
"lightblue":"#cff",
"blue":"#06f",
"darkblue":"#00c",
"turquoise":"#3cc",
"teal":"#088",
"gold":"#fd0",
"bronze":"#775",
"beige":"#db8"
};
isc.A.$270y=isc.getKeys(isc.ColorUtils.colorNames);
isc.A.$265p="workingResponse,validationContext";
isc.A.$265o="buildContext,validationContext,callback";
isc.A.uiCodeSuffixPrompts=[
"Your response does not need to contain any explanatory text in addition to the JavaScript to execute. If any additional content is included, please use a fenced code block to delineate the JavaScript code. This should be a line of three backtick (`) characters followed by the language specifier (javascript) before the code block, and three backtick (`) characters after the code block. For example:\n```javascript\n// Javascript code to execute here\n```"
];
isc.A.uiCodeValidationPrompts=[
"This is a request for a fix to a block of JavaScript code to be executed in an Isomorphic SmartClient web application.\nThe following JavaScript code is intended to generate one or more more UI components to achieve the following goal:\n",
"${userMessages}",
"The code is failing validation because some specified property or properties are not valid. The code block is as follows\n```javascript\n${jsCode}\n```\nThe validation errors are reported as follows.\n```JSON\n${errors}\n```\nFor each error the \"nodePath\" attribute uses an xpath-like syntax to describe which component and which field has a problem. For example a nodePath like\n\"root[0||className=ListGrid||ID=grid0]/initialCriteria\"\nwould indicate a problem with the \"initialCriteria\" attribute specified on the first top-level ListGrid component defined in the code, with ID specified as \"grid0\".\nPlease return a fixed version of the code where any invalid attributes have been replaced with an appropriate property based on the Isomorphic SmartClient web framework's documentation."
];
isc.A.defaultBuildUIViaAIValidationTypes=["default"];
isc.A.dataBoundUITypeInfos={
"list":{
description:"A ListGrid displaying some data from a dataSource. This is appropriate for any list of multiple records, including lists that are aggregated or grouped by values, sorted, filtered, etc.",
componentType:"ListGrid",
codePrompt:
"Note that for ListGrids, a user may request a simple \"grouped\" view. This is different from a true aggregated view and may be achieved via the \"groupByField\" property of the grid.\nExample listGrids:\nGiven a dataSource with ID:\"myDS\", and fields  \"code\" (primary key), \"location\", \"title\", \"description\" and \"price\",the following code would satisfy a user request to view a list of records where price is less than 100, sorted by price in ascending order:\n```javascript\nisc.ListGrid.create({\n        autoFetchData:true,\n        dataSource: \"myDS\",\n        fields:[\n            {name:\"location\"},\n            {name:\"title\"},\n            {name:\"description\"},\n            {name:\"price\"}\n        ],\n        initialCriteria:{\n            fieldName:\"price\",\n            operator:\"lessThan\",\n            value:100\n        },\n        initialSort:[\n            {\n                property:\"price\",\n                direction:\"ascending\"\n            }\n        ]\n    });\n```\nOr, for the same dataSource, the following code would satisfy a user request to show the average price for each location. Note that because we're inferring the 'price' field to be a currency field, we're applying decimalPrecision:2. If the user had requested a specific precision we would respect that instead. :\n```javascript\nisc.ListGrid.create({\n        autoFetchData:true,\n        dataSource: \"myDS\",\n        fields:[\n            {name:\"location\"},\n            {name:\"price\", decimalPrecision:2}\n        ],\n        fetchRequestProperties:{\n            groupBy:[\"location\"],\n            summaryFunctions:{\n                price:\"avg\"\n            }\n        }\n    });\n```\n\nSetting the \"showFilterEditor\" property to true will show an editor that the user can use to customize the filter on the data of the ListGrid. If the user requested a filterable list, or indicated wanting to change or customize which records are displayed, set \"showFilterEditor\" to true."
},
"chart":{
description:"A FacetChart displaying some data from a dataSource. Note that as with lists, a chart may display an aggregated or filtered set of values",
componentType:"FacetChart",
codePrompt:
"Note that the FacetChart you generate should have its \"valueProperty\" set to the numeric-typed field containing data values for records, and facetFields should be used to define facets for the chart.\nThe \"showDataValuesMode\" property should typically be set to \"auto\", unless this conflicts with the user prompt in some way.\nIf a clear, simple title for the chart can be derived from the prompt, include the \"title\" attribute.\nExamples:\nGiven a dataSource with ID:\"myDS\", and fields  \"code\" (primary key), \"location\", \"title\", \"description\" and \"price\",the following code would satisfy a user request to build a chart showing items that cost more than $500 in each location:\n```javascript\nisc.FacetChart.create({\n    ID: \"myChart\",\n    dataSource: \"myDS\",\n    facets: [\n        {\n            id: \"location\",\n            title: \"Location\"\n        },\n        {\n            id: \"title\",\n            title: \"Title\"\n        }\n    ],\n    stacked:false,\n    // valueProperty set to numeric field price\n    valueProperty: \"price\",\n    showDataValuesMode:\"auto\",\n    chartType: \"Column\",\n    autoFetchData: true,\n    initialCriteria:{\n        fieldName:\"unitCost\",\n        operator:\"greaterThan\",\n        value:500\n    }\n});\n```\nOr, for the same dataSource, the following code would satisfy a user request to chart the total number of items for each location:\n```javascript\nisc.FacetChart.create({\n    title: \"Total Items by Location\",\n    dataSource: \"myDS\",\n    facets: [\n        {\n            id: \"location\",\n            title: \"Location\"\n        }\n    ],\n    // The fetchRequestProperties block below uses groupBy and summaryFunction\n    // to generate a count of \"code\" values per location.\n    // Since \"code\" is the primary key for this dataSource it is unique per item,\n    // giving us back item count per location.\n    valueProperty: \"code\",\n    showDataValuesMode:\"auto\",\n    autoFetchData: true,\n    fetchRequestProperties:{ \n        groupBy:[\"location\"],\n        summaryFunctions:{\n            countryCode:\"count\"\n        }\n    }\n});\n```\n\nValid values for the \"chartType\" property are:\n\"Column\" - (the default if not specified) a bar chart with vertical bars\n\"Bar\" - a bar chart with horizontal bars\n\"Line\" - a chart where values are displayed side-by-side, connected by lines\n\"Radar\" - a chart where values are displayed around a circle, connected by lines\n\"Pie\" - a pie chart\n\"Doughnut\" - a pie chart with a center hole\n"
},
"value":{
description:"A Label displaying a single value (scalar) derived from the data in a dataSource",
componentType:"ScalarViewer",
codePrompt:
"ScalarViewer is a component based on a SmartClient DynamicForm which uses the attribute \"fieldName\" to extract a single field value from a record and the attribute \"title\" as a title for the single field value.\nOther standard DynamicForm properties such as \"dataSource\", \"autoFetchData\" and \"initialCriteria\" may be used to populate the item with a single record.\nExamples:\nGiven a dataSource with ID:\"myDS\", and fields  \"code\" (primary key), \"location\", \"title\", \"description\" and \"price\",the following code would display the \"description\" for the some record where \"code\" has the value \"abc123\":\n```javascript\nisc.ScalarViewer.create({\n    autoFetchData:true,\n    dataSource: \"myDS\",\n    title:\"Description for item abc123\",\n    fieldName:\"description\",\n    initialCriteria:{\n        fieldName:\"code\",\n        operator:\"equals\",\n        value:\"abc123\"\n    }\n});\n```\nOr, for the same dataSource, the following code would satisfy a user request to show the average price for items in San Francisco:\n```javascript\nisc.ScalarViewer.create({\n    autoFetchData:true,\n    dataSource: \"myDS\",\n    title:\"Average price of items in San Francisco\",\n    fieldName:\"price\",\n    initialCriteria:{\n        fieldName:\"location\",\n        operator:\"equals\",\n        value:\"San Francisco\"\n    },\n    fetchRequestProperties:{ \n        groupBy:[\"location\"], \n        summaryFunctions:{\n            price:\"avg\"\n        }\n    }\n});\n```\n\nTo control which record is retrieved, it may be necessary to sort by a field, by adding a \"sortBy\" property to the ScalarViewer's \"fetchRequestProperties\" object. The \"sortBy\" property is the name of the field that the data are sorted by, prefixed with a minus sign ('-') if the data should be sorted by the field in descending order.\nFor example, using the same \"myDS\" dataSource, the following code would satisfy the request for the \"location with the highest price\":```javascript\nisc.ScalarViewer.create({\n    autoFetchData:true,\n    dataSource: \"myDS\",\n    title:\"Location with the highest price\",\n    fieldName:\"location\",\n    fetchRequestProperties:{ \n        sortBy: \"-price\"\n    }\n});\n```\nIn this example, the first row, when sorted by the price in descending order, is for the location with the highest price in the dataSource."
}
};
isc.A.dataBoundUIInitiatorPrefixPrompts=[
"A user is interacting with an Isomorphic SmartClient web application. They have requested a new user-interface component to display data from a dataSource in some way. The user request is as follows:",
"${userMessages}"
];
isc.A.dataBoundUIInitiatorPrompt_UIOptions="The user may request one of the following types of user interface components:\n${uiTypeDescriptions}\n";
isc.A.dataBoundUIInitiatorPrompt_DSOptions="The following dataSources are available for this component:\n${dsDescriptions}\n";
isc.A.dataBoundUIInitiator_UIResponseFormat="Please respond with a JSON object containing the following attribute(s):\n\"component\": The component type name that best matches the user's request, or \"invalid\" if you are unable to determine what kind of data view the user is asking for. This should be one of the following values:\n${uiTypes}\n";
isc.A.dataBoundUIInitiator_DSResponseFormat="\"dataSource\": The ID of the dataSource that best matches the user's request, or \"invalid\" if you are unable to determine which dataSource the user is attempting to view data from. This should be one of the following values:\n${dsIDs}\n";
isc.A.dataBoundUIInitiatorSuffix="Your response should contain the JSON block and no other text.\nAn example of a valid response might be:\n${responseExample}";
isc.A.dataBoundUICodePrefixPrompts=[
"A user is interacting with an Isomorphic SmartClient web application. They have requested a new ${componentType} component to display data from a dataSource in some way. The user request is as follows:",
"${userMessages}",
"The DataSource has the following summary:\n${dsSummary}\nPlease generate JavaScript code to create a SmartClient ${componentType} bound to this dataSource that meets the user's request.\nNotes:\n- The \"dataSource\" attribute of the component should be set to the ID of the dataSource.\n- In order to fetch data to display, \"autoFetchData\" should be set to true.\n- If criteria should be applied to the fetch, the \"initialCriteria\" attribute should be specified as a SmartClient AdvancedCriteria object.\n- If the user requested some form of data aggregation - for example a list of each unique value for some field along with a count of records, or sum of some other numeric field value within that group, this can be achieved by customizing the SmartClient dsRequest using the \"fetchRequestProperties\" attribute for the component, and setting appropriate \"groupBy\" and \"summaryFunctions\" attributes within that dsRequest configuration.\n${componentCodePrompt}.\n\n"
];
isc.A.$274t="asyncBuildDataBoundUI";
isc.A.fencedCodeRegex=new RegExp("^```(?:javascript)?\\s*\\n((.|\n)*)\\n```","im");
isc.A.autoLoadDataSource=true;
isc.A.dataSourceName="serverAIDataSource";
isc.A.dataSources={};
isc.A.$257l={};
isc.A.$257k={};
isc.A.spoofedResponseDelay=2000;
isc.A.responseSpoofingMode="hybrid";
isc.A.$259j=[];
isc.A.initiatorPromptTemplate="This is an Isomorphic SmartClient AI Assistant Request (version 1.0).\n*** Overview ***\nFor an Isomorphic SmartClient AI Assistant Request, you are to act as an intelligent agent assisting a user in an Isomorphic SmartClient application.\nDetails of the application and the user request text will be provided at the end after this overview.\nYou should respond to this request with a response in the following structured format. Note that text in square brackets is descriptive. Any other text should be included verbatim:\n\nResponseType: [a response type, as explained below]\nMessage: [a message to be shown to the user, either explaining what you have done or asking for clarifications]\nMessageType: [a message type, as explained below]\n======\n[JavaScript code to perform a requested action when executed in the context of the SmartClient application. Note that the JavaScript should contained between a delineator of 6 equal signs, as shown here. Certain response types (described below) do not require any JavaScript code - in these cases the response may omit this entire block including both sets of equal signs.]\n======\n\n** Response Types **\nThere are six possible response types, described in the following section. \nNote that these are not listed in order of preference - you should choose the appropriate response type based on the prompt you received.\nImmediately after the numeral is the text value you should use for the \"ResponseType\" when responding. Do not include the numeral.\n\n1. Execute JavaScript\nProduce JavaScript code to do what the user wants, along with an explanation of what you have done, to be shown to the user.\nThis ResponseType is appropriate only to perform the same set of actions that a normal user can perform via the running SmartClient application's user interface, and any changes applied to the UI should be reversable by the user, using the UI.\nThis is typically limited to interacting with existing components on the page.\nThe JavaScript you generate should be valid JavaScript and may make use of the Isomorphic SmartClient JavaScript framework APIs.\n* Important Note *\nDetails of the currently visible UI of the application are below in the section titled \"SmartClient application and environment information\"Components listed in this summary may be accessed may be accessed directly by their \"ID\" property, or by passing this property into \"isc.Canvas.getById();\".\nOther documented SmartClient APIs may also be used.\nIf your code either causes a JavaScript error or times out, this will be reported to you.\nThe Message should be some text to display to the user, explaining what was done.\nThe MessageType may be set to either \"Notify\" or \"Modal Message\". MessageType \"Notify\" will show the message as a notification that auto-hides. MessageType \"Modal Message\" will show the message in a modal dialog that the user must explicitly dismiss before proceeding.\nSome examples of requested actions that would require an \"Execute JavaScript\" type response include:\n- Applying sorting to an existing listGrid via \"listGrid.sort();\" or \"listGrid.setSort();\"\n- Changing the filter criteria applied to an existing listGrid via \"listGrid.setFilterEditorCriteria();\" or \"listGridID.filterData();\"\n- Switching to a different tab in a TabSet via \"tabSet.selectTab();\"\nIf the user prompt requires a new UI be created, do not use the \"Execute JavaScript\" response type - use \"Ad Hoc UI\" instead.\n\n2. Ad Hoc UI\nYour generated JavaScript code creates an \"ad hoc\" UI to do whatever the user needs to do.  \nIn this case, the JavaScript code you specify should create SmartClient user interface components. The code will be captured in the same way that SmartClient captures \"screens\" (as in the RPCManager.loadScreen() API) and SmartClient will automatically display the result in a Window component. \nYour code does not need to include this Window component - just create the appropriate UI and it will be displayed to the user as appropriate.\nWhen the Window is closed, the ad-hoc UI created by your code will be destroyed (as in Canvas.destroy()).\nAs with \"Execute JavaScript\":\nThe code you generate should be valid JavaScript and may make use of the Isomorphic SmartClient JavaScript framework APIs.\nThe Message should be some text to display to the user, explaining what was done.\nThe MessageType may be set to either \"Notify\" or \"Modal Message\".\nThe \"Ad Hoc UI\" response type is appropriate for situations where the underlying DataSources provide the ability to achieve the end user's goals, but the UI does not provide an easy way to do what the user wants.  \nSome examples of requested actions that would require an \"Ad Hoc UI\" type response include:\n- Creating an aggregated view of dataSource data when none is available in the default UI. This could be achieved by creating a new ListGrid bound to the appropriate dataSource, and setting \"groupBy\" and  \"summaryFunctions\" on the \"dsRequest\" object passed to listGrid.filterData().\n- Displaying data from a dataSource in a chart by creating a new FacetChart bound to the dataSource, using the \"valuePrompt\" and \"facetFields\" to specify which attributes to chart, and calling fetchData() or filterData() to populate it.\nIn your other kinds of responses, if it's possible to create an ad-hoc UI to do what the user needs, be sure to mention that to the user.  And, if the user specifically requests an ad-hoc UI, take that as a suggestion to use this approach (unless another approach, such as \"Inspect\", is appropriate first).\n\n3. Clarify\nAsk the user for clarifying information.\nFor this type of response, the \"Message\" you specify can be used to ask the user a question. You should not show this message to the user - the application will show it in a modal dialog where the user may type in a response. The user's response will be sent back to you, allowing you to take further action.\nAny \"MessageType\" you specify will be ignored for \"Clarify\" type responses.\n\"Clarify\" type responses do not need to include any JavaScript, but if you do include JavaScript it will be executed in the scope of the application. This allows you to programatically gather information about the current application by using the \"isc.AI.commandComplete()\" method.\nIf you want to make use of this capability, consider the following points when generating your JavaScript code.\n- Your code should always include a call to the method \"isc.AI.commandComplete();\". This method takes a single argument, which can be any JavaScript object or primitive, and we will send this back to you (in addition to the user's response to your question). For example you could determine the current set of (visible) field names in a listGrid by calling \"isc.AI.commandComplete(listGrid.getFieldNames())\".\n- Your code can make use of asynchronous APIs; when your inspection code is complete, it should call the API isc.AI.commandComplete() method, passing any object that can be serialized to JSON. For an asynchronous action, this would typically be done in a callback function.\nFor example - if you wanted to find the total number of records in a DataSource, you could invoke\n  dataSource.fetchData(\n    // criteria - unrestricted fetch\n    null,\n    // callback function\n    function (dsResponse, data, dsRequest) {\n        isc.AI.commandComplete(dsResponse.totalRows);\n    },\n    // dsRequest configuration - use startRow and endRow to avoid returning actual records\n    { startRow:0, endRow:0 }\n  );\nIf you want to return information gathered from multiple APIs, you can combine all necessary information into a single JSON object which your code passes to isc.AI.commandComplete().\n\n4. Inspect\nGenerate JavaScript to gather information\nSimilar to the \"Clarify\" ResponseType explained above, you can generate JavaScript to gather information about the application environment, and have it sent back to you by calling \"isc.AI.commandComplete()\".\nUnlike \"Clarify\" responses, \"Inspect\" responses do not prompt the user for information.\nIf you do include a \"Message\", it will be displayed to the user as either a \"Notification\" or \"Modal Message\" depending on the \"MessageType\" you specified.\nIf necessary you may generate repeated \"Inspect\" type responses to gather multiple pieces of information about the application before finally deciding upon an interactive response to the user, via one of the other ResponseTypes.\n\n5. Send A Message\nThe \"Send A Message\" response type will cause the specified \"Message\" to be displayed to the user and take no other action.\nThis response type should not include any JavaScript to execute.\nThis is useful for cases where you simply want to display a message to the user.\n\n6. Explain Why Not\nExplain to the user that what they want cannot be done, and why.  \nIf possible, provide suggestions for how they might achieve their goals instead, including by contacting other people with administrative access to data.\nThe explanation you provide as the \"Message\" for this response type will appear in a modal SmartClient Window, with a text field below offering the user the ability to provide a revised or clarified command, or the ability to cancel the overall AI interaction.\nThis response type should not include any JavaScript to execute.\nYou should not show this message to the user - the application will show it, according to the MessageType you provide.\n\n** Example **\nAn example of a validly formatted response is below.\nThis response might be appropriate for the following user prompt:\n  \"Show the filterEditor on my listGrid and filter it to only show items that are less than $100 and customer's name contains 'Schwabb'\"\nIn this case we're assuming the application has a listGrid with the ID \"myListGrid\" with fields \"unitCost\" and \"customer\".\nExample response:\n\nResponseType: Execute JavaScript\nMessage: The filter editor for your listGrid has been displayed and the listGrid has been filtered to show only items with unitCost less than $100, where the customer name contains the string \"Schwabb\".\nMessageType: Notify\n======\nmyListGrid.setProperties({showFilterEditor:true});\nmyListGrid.filterData({\n    _constructor:\"AdvancedCriteria\",\n    operator:\"and\",\n    criteria:[\n        {fieldName:\"unitCost\", operator:\"lessThan\", value:100},\n        {fieldName:\"customer\", operator:\"iContains\", value:\"Schwabb\"},\n    ]\n});\n======\n\nDetails about the running application, and the user request are below.\n*** End of overview ***\n";
isc.A.suggestRecordSummaryTitlePrompts=[
"This is a request for a suggested title for a new field of a DataSource. This new field will contain the following information for each record:",
"${ssMessages}",
"The DataSource has the following summary: ${dsSummary}"
];
isc.A.suggestRecordSummaryTitlePrompts_visibleFields="The suggested title should be short (at most 40 characters), succinctly describe the information that will be contained in the new field, and be similar in style to the titles in the following map from existing field names to their titles:\n";
isc.A.suggestRecordSummaryTitlePrompts_noVisibleFields="The suggested title should be short (at most 40 characters) and succinctly describe the information that will be contained in the new field. Each word of the suggested title should be capitalized.";
isc.A.suggestRecordSummaryTitlePrompts_final="Your response should be a single JSON object with one key \"suggestedTitle\" and value being a string containing the suggested title for the new field.";
isc.A.$274u="asyncBuildAIFieldRequest";
isc.A.buildAIFieldRequestTemplatedString=isc.trimDoc`
        In the context of an Isomorphic SmartClient application, this is a request for
        information about the task of generating supplemental data for each record in the
        '\${dsName}' DataSource.

        \${dsSummary}

        The supplemental data that will be generated for each record is:
        <supplemental-data-description>\${aiFieldPrompt}</supplemental-data-description>

        Note: In the supplemental-data-description, disregard directions to "sort by", "order by",
        or similar that do not describe the supplemental data to generate.

        You must decide what class of supplemental data ("valueClass") is described by the
        supplemental-data-description. The options are:
        * "general": Any kind of data. Usually this is textual, but not necessarily always so.
          An example would be a "2-4 sentence summary".
        * "categorical": A fixed list of categories or nominal values. An example would be the
          type of customer issue (e.g. "Technical Issue", "Billing Issue", "General Inquiry").
        * "ordinal": An extension of "categorical" where the categories are also strictly
          ordered from lowest/least to highest/most. An example would be customer satisfaction
          (e.g. "Dissatisfied", "Neutral", "Satisfied", "Very Satisfied").
        * "interval": Strictly numerical data. An example would be temperature in degrees Celsius.
        * "ratio": An extension of "interval" where 0 means the absence of something, and ratios
          between values are meaningful. An example would be weight in pounds, because 0 means
          no weight and 200 pounds is twice as heavy as 100 pounds.

        Your response must be a JSON object with the following properties:
        * "fieldSummaries" (object): A map from the name of each field to a string containing
          a shortened summary of all of the following details that you infer about the
          field\${haveSampleData ? " using the given sample data and" : ""} from the field's title,
          description, and other available information:
            - Whether the field's values are possibly relevant or not at all relevant to the
              task of generating the supplemental data for each record according to the
              supplemental-data-description.
            - For numeric fields, the units of the field's values if applicable,
              or whether the units are unknown.
            - The pattern or format of the field's values.
            - Whether the field's values may be \`null\`, and if so, what the meaning or significance
              of \`null\` is.
            - Any assumptions that you are making about the field's values.
            - Any uncertainties that you have about the field's values.
        * "relevantFieldNames": An array of the names of the fields of the '\${dsName}'
          DataSource that are possibly relevant to generating the supplemental data for each
          record according to the supplemental-data-description.
        * "irrelevantFieldNames": An array of the names of the fields of the '\${dsName}'
          DataSource that appear to be irrelevant to generating the supplemental data for each
          record according to the supplemental-data-description.
        * "valueClass": The "valueClass" for the requested supplemental data, either
          "general", "categorical", "ordinal", "interval", or "ratio".
        * "dataDependentReason" (only if the "valueClass" is "categorical" or "ordinal", it
          is absolutely not possible to make any reasonable choices for the categories without
          examining all of the records in the DataSource, and the data of the records reasonably
          appears to contain the categories): A string containing an explanation of why the list
          of categories absolutely depends on the records in the DataSource.
        * "categories" (only if the "valueClass" is "categorical" or "ordinal" and reasonable
          choices can be made about the categories [i.e. not data-dependent]): An array of the
          category label strings. If the "valueClass" is "ordinal", this array must list the
          categories from lowest/least value to highest/most value. This is not the
          same as your choice for "displayDirection".
        * "categoryHints" (only if the "valueClass" is "categorical" or "ordinal"): An object
          that maps each category label string to a hint for when to use that category rather
          than the other categories.
        * "minValue" (only if the "valueClass" is "interval" or "ratio" and the supplemental-data-description
          specifies or reasonably implies a minimum value): The minimum value as a number.
        * "maxValue" (only if the "valueClass" is "interval" or "ratio" and the supplemental-data-description
          specifies or reasonably implies a maximum value): The maximum value as a number.
        * "displayDirection" (only if the "valueClass" is "ordinal", "interval", or "ratio"):
          If the highest/most values are most emotionally-positive, or most optimistic, or
          likely to be most of interest, specify "most-to-least" (so that the most positive or
          most of interest values appear first).
          Otherwise, specify "least-to-most".
        * "displayDirectionReasoning" (only if the "valueClass" is "ordinal", "interval", or "ratio"):
          A string containing a shortened summary of your reasoning behind your choice of "displayDirection".
    `;
isc.A.invalidSummaryValue="-";
isc.A.$2693="partialResult,context";
isc.A.summarizeRecordsPrompts_general=[
"This is a request to supplement the data in records from a DataSource, using relevant general knowledge and your own reasonable inferences from the data. The supplemental information requested for each record is:",
"${ssMessages}",
"The records specified below are from the DataSource with the following description: ${dsSummary}\n\nYour response should be a single JSON object with one key \"result\" and value being an array of just the strings of supplemental information for each corresponding record. Here are the records:"
]
;
isc.B.push(isc.A.$267s=function isc_c_AI__asyncBuildCriterionWithSummarizedUserMessages(_1,_2){
if(_2.$274w.canceled){
throw _2.$274w.asCanceledResult()}
var _3=isc.InternalAIMessagesBuilder.create({
userMessages:_1,
target:this,
evalVars:{
purpose:_2.buildRequest.purpose,
referenceTime:_2.referenceTime,
dsSummary:"${dsSummary}",
dataSource:_2.dataSource
}
});
if(_2.mode=="aiAssist"){
_3.renderTemplate("buildCriterionAIAssistPrompt")}else if(_2.mode=="AIDE"){
_3.appendPrompts(this.applyAIFilterPrompts)}else{
_3.renderTemplate("buildCriterionHybridPrompt")}
var _4={
messages:_3.aiMessages,
responseType:"object"
};
var _5=this.$2679(_4);
if(_5.errorMessage)return isc.rejectWithError(_5.errorMessage);
var _6=_2.dataSource.getAllFields();
var _7=_5.aiEngine.shouldUseAIFieldPaging(_4,_6,_2.$261g);
if(!_7){
return this.$267t(_6,_4,_2)}
++_2.$261w;
this.$262i(_2,[{category:"detail",content:isc.AI.willSubsetFieldsDetailMessage}],true);
return _5.aiEngine.asyncRetrieveFieldsForPrompt(
_4.messages,
"Filter data-records according to the user's description of the filter criteria",
_6,
_5,
_2.$261g)
.then(function(_8){
++_2.$261v;
isc.AI.$262i(_2,[{category:"success",content:isc.AI.finishedSubsettingFieldsDetailMessage}]);
return isc.AI.$267t(
_8,_4,_2)})}
);
isc.evalBoundary;isc.B.push(isc.A.$267t=function isc_c_AI__asyncBuildCriterionWithFinalFields(_1,_2,_3){
if(_3.$274w.canceled){
throw _3.$274w.asCanceledResult()}
if(_1==null||(_1.removeEmpty(),_1).isEmpty()){
const _4=_3.buildRequest.purpose;
throw isc.createErrorResult("No fields were selected for use in building the "+
(_4||"filter")+" criterion.")}
_3.$261z=_1;
var _5=this.render("summarizeDataSource",{
dataSource:_3.dataSource,
fields:_1
});
_3.$263q=_5;
if(_3.mode=="AIDE"){
return Promise.resolve(this.$2663(_3))}
var _6={
dsSummary:_5
};
var _7={
cancellationController:_3.$274w,
messages:_2.messages.map(function(_13){
if(_13.source=="system"&&isc.AIEngine.$272z(_13.type)){
return{
source:_13.source,
content:String(_13.content).evalDynamicString(this,_6)
}}
return _13},this),
responseType:_2.responseType,
willHandleError:true
};
if(!_3.$274w.canceled&&_3.$261x)_3.$261x.show();
return this.asyncSendRequest(_7,_3.$261g)
.then(function(_13){
++_3.$261v;
isc.AI.$262i(_3);
const _8=_13.message.content;
if(isc.isAn.Object(_8)&&_8.result!="invalid"){
if(_8.result=="method2"){
return isc.AI.$2663(_3)}
var _9;
if(isc.isAn.Object(_8.result))_9=_8.result
else _9=_8;
if(_3.dataSource.isAdvancedCriteria(_9)){
var _10=isc.AI.$268v(_9);
return isc.AI.$268w(_10,_3)}
}
let _11=isc.AI.aiNotAbleToProcessRequestErrorMessage;
if(_8&&isc.isA.String(_8.invalidReasoning)){
const _12=_8.invalidReasoning.trim();
if(_12.length)_11=_12.asHTML()}
throw isc.createErrorResult(_11)})}
,isc.A.$268w=function isc_c_AI__asyncValidateAdvancedCriteria(_1,_2,_3){
var _4=_2.$261z.makeIndex("name"),
_5=[],
_6=this.$268x(isc.DS.copyCriteria(_1),
_4,
_2.dataSource,
_5);
if(_6&&_5.isEmpty()){
return Promise.resolve(_6)}
if(_3){
return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage)}
++_2.$261w;
this.$262i(_2,[{category:"error",content:"AI generated invalid criteria. Will request a fix..."}]);
var _7=isc.JSONEncoder.create({
dateFormat:"logicalDateString",
strictQuoting:true
});
var _8=isc.InternalAIMessagesBuilder.create({
userMessages:_2.$2615,
target:this,
evalVars:{
dsSummary:_2.$263q,
encodedCriterion:_7.encode(_1),
validationErrors:_5.join("\n"),
encodedValidatedCriterion:_6&&_7.encode(_6)
}
});
_8.appendPrompts(this.fixCriterionPrompts);
var _9={
messages:_8.aiMessages,
responseType:"object",
willHandleError:true
};
return this.asyncSendRequest(_9,_2.$261g)
.then(function(_12){
++_2.$261v;
isc.AI.$262i(_2);
var _10=_12.message.content;
if(_2.dataSource.isAdvancedCriteria(_10)){
var _11=isc.AI.$268v(_10);
return isc.AI.$268w(_11,_2,true)}else{
return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage)}
})}
,isc.A.$268v=function isc_c_AI__maskCriterion(_1,_2,_3){
if(_1.operator=="and"||
_1.operator=="or"||
_1.operator=="not")
{
var _4=_1.criteria;
_1={
operator:_1.operator,
criteria:_4
};
if(!isc.isAn.Array(_4))_4=_1.criteria=[_4];
for(var i=0;i<_4.length;){
var _6=_4[i];
if(_6==null){
_4.removeAt(i);
continue}
if(isc.isAn.Array(_6)){
_4.addListAt(_6,i);
_6=_4[i]}
if(isc.isAn.Object(_6))_4[i]=this.$268v(_6,_2,true);
++i}
}else{
_1=isc.applyMask(_1,_2||this.allowedCriterionPropertyNames)}
if(!_3)_1._constructor="AdvancedCriteria";
return _1}
,isc.A.$268x=function isc_c_AI__validateCriterion(_1,_2,_3,_4,_5){
if(!_1.operator){
_4.push("A criterion was missing the 'operator'.");
return null}
var _6=_1.operator,
_7=_3.getSearchOperator(_6);
if(!_7||!this.$268u.contains(_6)){
_4.push("Operator '"+_6+"' is not allowed.");
return null}
if(_7.valueType=="none"){
delete _1.value}else if(_7.valueType=="criteria"){
var _8=_1.criteria;
if(!isc.isAn.Array(_8))_8=_1.criteria=[_8];
for(var i=0;i<_8.length;){
var _10=_8[i];
if(_10==null){
_8.removeAt(i);
continue}
if(!isc.isAn.Object(_10)){
_4.push("A subcriterion was not an object.");
_8.removeAt(i);
continue}
var _11=_8[i]=this.$268x(
_10,_2,_3,_4,true);
if(!_11){
_8.removeAt(i);
continue}
++i}
}else if(_7.valueType&&_7.valueType!="fieldType"){
_4.push("Operator '"+_6+"' is not allowed because the operator valueType is '"+_7.valueType+"'.");
return null}else{
var _12=_1.fieldName;
if(!_12){
_4.push("The '"+_6+"' criterion was missing the 'fieldName'.");
return null}
var _13=(!_2
?_3.getUnderlyingField(_12)
:_2[_12]);
if(!_13){
_4.push("The '"+_6+"' criterion referenced field '"+_12+"', but that field is not allowed.");
return null}
}
if(!_5){
_1=_3.validateCriteria(_1);
_1=this.$268y(_1,_2,_3,_4);
_1=isc.DS.simplifyAdvancedCriteria(_1,true)}
return _1}
,isc.A.$268y=function isc_c_AI__validateCriterion2(_1,_2,_3,_4,_5){
var _6=_1.operator,
_7=_3.getSearchOperator(_6);
this.$102q(_7!=null);
if(_7.valueType=="criteria"){
var _8=_1.criteria;
this.$102q(isc.isAn.Array(_8));
for(var _9=_8.length;_9>0;--_9){
var i=_9-1,
_11=_8[i];
var _12=_8[i]=this.$268y(
_11,_2,_3,_4,true);
if(!_12){
_8.removeAt(i)}
}
}else if("fieldName"in _1){
var _13=_1.fieldName,
_14=(!_2
?_3.getUnderlyingField(_13)
:_2[_13]);
var _15=_3.getFieldOperators(_14);
if(!_15||!_15.contains(_6)){
_4.push("Operator '"+_6+"' is not allowed for field '"+_13+"'.");
return null}
}
return _1}
,isc.A.$2663=function isc_c_AI__buildAIFilter(_1){
var _2=_1.dataSource.getPrimaryKeyFieldNames();
var _3,
_4;
if(_2.length==1){
_3=isc.Set.create();
_4=isc.Set.create()}else{
_3=isc.TupleSet.create();
_4=isc.TupleSet.create()}
var _5=_1.buildRequest.$2664;
if(_5)isc.AI.$2665(_5);
else _5={};
isc.addProperties(_5,{
_constructor:"AdvancedCriteria",
operator:"aiFilter",
userAIRequest:_1.buildRequest.userAIRequest,
isTrivial:false,
$2615:_1.$2615,
$264d:_1.dataSource.getID(),
$263s:_2,
$263t:_1.$261z.getProperty("name"),
$263q:_1.$263q,
$263v:_3,
$2667:null,
$264f:_4,
$2631:true,
clone:isc.AI.$2668
});
return _5}
,isc.A.$267u=function isc_c_AI__createApplyAIFilterContext(_1,_2,_3){
var _4=this.$267n(_1,_2,_3);
this.$102q(_2.aiCriterion.operator=="aiFilter");
var _5=_2.aiCriterion&&_2.aiCriterion.$264d;
_4.dataSource=_5&&isc.DS.get(_5);
if(_2.showProgressDialog==true){
_4.$261x=isc.FilterViaAIProgressDialog.create(_2.progressDialogProperties,{
$266t:_4,
canCancel:_2.userCanCancel!=false
})}
this.$262i(_4,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
return _4}
,isc.A.applyAIFilter=function isc_c_AI_applyAIFilter(_1,_2){
this.$2677(this.$274r,_1,_2)}
,isc.A.asyncApplyAIFilter=function isc_c_AI_asyncApplyAIFilter(_1){
return this.$274v("$267w",_1)}
,isc.A.$267w=function isc_c_AI__asyncApplyAIFilter(_1,_2){
if(!_1.aiCriterion||_1.aiCriterion.operator!="aiFilter"){
return isc.rejectWithError("The 'aiFilter' AdvancedCriteria to evaluate is required.")}
if(!_1.records){
return isc.rejectWithError("The records to apply the AI filter to are required.")}
var _3=this.$267u(this.$274r,_1,_2),
_4=_3.dataSource;
if(!_4||!isc.AI.$262k(_4,"AIDE")){
_3.$267o.reject(isc.createErrorResult(isc.AI.dataSourceIsRequiredErrorMessage))}else{
var _5=_1.aiCriterion;
this.$102q(_5.operator=="aiFilter");
if(!isc.AI.$267a(_5,_4)){
_3.$267o.reject(isc.createErrorResult("The 'aiFilter' criterion is not usable."))}else{
this.$267v(_5,_3)
.then(function(_6){
_3.$267o.resolve({type:"success",matchingRecords:_6})},function(_6){
_3.$267o.reject(isc.defaultAsyncOperationCatchCallback(_6))})}
}
return _3.$267o.promise}
,isc.A.$267v=function isc_c_AI__asyncApplyUsableAICriterion(_1,_2){
var _3=_2.applyRequest.records,
_4=_2.applyRequest.$267i||isc.AI.$267j(_1,_3,_2.dataSource);
this.$102q(_4&&
isc.isAn.Array(_4.matchingRecords)&&
_4.matchingRecords.length+(_4.remainingRecords==null
?0
:_4.remainingRecords.length)==_3.length);
if(!_4.remainingRecords||_4.remainingRecords.length==0){
return Promise.resolve(_4.matchingRecords)}
return this.$274y(_4,_1,_2)}
,isc.A.$274y=function isc_c_AI___asyncApplyAIFilter(_1,_2,_3){
if(_3.$274w.canceled){
return Promise.reject(_3.$274w.asCanceledResult())}
var _4=isc.InternalAIMessagesBuilder.create({
userMessages:_2.$2615,
target:this,
evalVars:{dsSummary:_2.$263q}
});
_4.appendPrompts(this.applyAIFilterPrompts);
var _5=_4.aiMessages;
var _6=_1.remainingRecords,
_7=_6.getLength(),
_8=Promise.withResolvers();
var _9=function(){
if(_3.$274w.canceled){
return false}
++_3.$261v;
isc.AI.$262i(_3,null,true)};
var _10={
fieldNames:_2.$263t,
aiPageSize:_3.applyRequest.aiPageSize,
maxRetries:_3.$261g.maxRetries,
serializationFormat:_3.$261g.serializationFormat,
progressCallback:_9
};
var _11=this.$2678(_5);
if(_11.errorMessage)return isc.rejectWithError(_11.errorMessage);
var _12=_11.aiEngine.doPageRecordsPicking(_5,_6,function(_22,_23){
if(_3.$274w.canceled)return;
var _13=_23.find({_constructor:"AdvancedCriteria",fieldName:"nonSuccessfulResult",operator:"notNull"});
if(_13){
_8.reject(_13.nonSuccessfulResult);
return}
_1.matchingRecords.addAll(_22);
var _14=_2.$263s;
var _15=_2.$263v,
_16=null,
_17=_2.$264f;
if(_14.length==1){
var _18=_14[0];
for(var i=0;i<_22.length;++i){
_17.add(_22[i][_18])}
for(var i=0;i<_7;++i){
var _20=_6.get(i)[_18];
if(!_17.has(_20)){
_15.add(_20)}
}
if(!_15.isEmpty()){
_16={
_constructor:"AdvancedCriteria",
fieldName:_18,
operator:"notInSet",
value:_15.getContents()
}}
}else{
isc.AI.$102q(false)}
_2.$2667=_16;
isc.AI.$262i(_3,null,true);
_8.resolve(_1.matchingRecords)},_10);
var _21=_12.batches.length;
_3.$261w+=_21;
this.$262i(_3,[{category:"detail",content:"AI will evaluate the criteria in "+_21+" batch(es) of records."}],true);
return _8.promise}
,isc.A.removeFromAIFilterCaches=function isc_c_AI_removeFromAIFilterCaches(_1,_2){
if(_1.operator!="aiFilter"){
this.logWarn("The AdvancedCriteria passed to removeFromAIFilterCaches() has operator '"+
_1.operator+"'; expecting 'aiFilter'.","AI");
return}
var _3=_1.$263s,
_4=_1.$263v,
_5=_1.$264f;
if(!isc.isA.Class(_4)){
_4=_1.$263v=null;
_1.$2667=null}
if(!isc.isA.Class(_5)){
_5=_1.$264f=null}
if(!isc.isAn.Array(_3))return;
if(_3.length==1){
var _6=_3[0];
if(isc.isA.Class(_4)){
var _7=false;
for(var _8=0;_8<_2.length;++_8){
if(_4.remove(_2[_8][_6]))_7=true}
if(_7){
_1.$2667={
_constructor:"AdvancedCriteria",
fieldName:_6,
operator:"notInSet",
value:_4.getContents()
}}
}
if(isc.isA.Class(_5)){
for(var _8=0;_8<_2.length;++_8){
_5.remove(_2[_8][_6])}
}
}else{
this.$102q(false)}
}
,isc.A.clearAIFilterCaches=function isc_c_AI_clearAIFilterCaches(_1){
if(_1.operator!="aiFilter"){
this.logWarn("The AdvancedCriteria passed to clearAIFilterCaches() has operator '"+
_1.operator+"'; expecting 'aiFilter'.","AI");
return}
if(isc.isA.Class(_1.$263v)){
_1.$263v.clear()}
_1.$263v=null;
_1.$2667=null;
if(isc.isA.Class(_1.$264f)){
_1.$264f.clear()}
_1.$264f=null}
,isc.A.asyncReapplyAIFilter=function isc_c_AI_asyncReapplyAIFilter(_1){
if(!_1.aiCriterion||_1.aiCriterion.operator!="aiFilter"){
return isc.rejectWithError("The 'aiFilter' AdvancedCriteria to re-apply is required.")}
if(!isc.isAn.Array(_1.updatedRecords)){
return isc.rejectWithError("The updated records are required.")}
this.removeFromAIFilterCaches(_1.aiCriterion,_1.updatedRecords);
var _2=isc.addProperties({},_1,{
showProgressDialog:_1.showProgressDialog!=true,
records:_1.updatedRecords,
updatedRecords:null
});
return this.asyncApplyAIFilter(_2)
.then(function(_3){
_3.matchingUpdatedRecords=_3.matchingRecords;
delete _3.matchingRecords;
return _3})}
,isc.A.$2701=function isc_c_AI__createBuildHilitesContext(_1,_2,_3){
var _4=this.$267n(_1,_2,_3);
_4.dataSource=_3.dataSource;
var _5=_2.mode;
if(_5==null)_5="hybrid";
else if(_5!="aiAssist"&&_5!="AIDE"&&_5!="hybrid"){
this.logWarn("unsupported AI service mode '"+_5+"'. Switching to 'hybrid'.");
_5="hybrid"}
_4.mode=_5;
if(_2.showProgressDialog==null||_2.showProgressDialog){
_4.$261x=isc.HiliteViaAIProgressDialog.create(_2.progressDialogProperties,{
$266t:_4,
canCancel:_2.userCanCancel!=false
})}
_4.$261w=2;
this.$262i(_4,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
return _4}
,isc.A.buildHilites=function isc_c_AI_buildHilites(_1,_2){
this.$2677(this.$274s,_1,_2)}
,isc.A.asyncBuildHilites=function isc_c_AI_asyncBuildHilites(_1){
return this.$273t("$274z",_1)}
,isc.A.$274z=function isc_c_AI__asyncBuildHilites(_1,_2){
var _3=this.$2701(this.$274s,_1,_2),
_4=_3.dataSource;
if(!_4||!isc.AI.$262k(_4,_3.mode)){
_3.$267o.reject(isc.createErrorResult(isc.AI.dataSourceIsRequiredErrorMessage))}else{
this.$267p(_3)
.then(function(_5){
return isc.AI.$2702(
_5,_3)})
.then(function(_5){
_3.$267o.resolve({type:"success",hilites:_5})},function(_5){
_3.$267o.reject(isc.defaultAsyncOperationCatchCallback(_5))})}
return _3.$267o.promise}
,isc.A.$270z=function isc_c_AI__extendColorMap(){
var _1=this.$270x;
_1.lightgrey=_1.lightgray;
_1.grey=_1.gray;
_1.darkgrey=_1.darkgray;
_1.silver=_1.gray;
_1.platinum=_1.lightgray}
,isc.A.$2702=function isc_c_AI__asyncBuildHilitesWithSummarizedUserMessages(_1,_2){
if(_2.$274w.canceled){
return Promise.reject(_2.$274w.asCanceledResult())}
var _3=isc.getValues(_2.dataSource.getFields());
var _4=isc.InternalAIMessagesBuilder.create({
cancellationController:_2.$274w,
userMessages:_1,
target:this,
evalVars:{
dsSummary:"${dsSummary}",
referenceTime:_2.referenceTime
}
});
_4.appendPrompts(this.buildHilitesPrompts);
var _5={
messages:_4.aiMessages,
responseType:"object"
};
return this.$2703(_2,_5,_3)}
,isc.A.$2703=function isc_c_AI__asyncBuildHilitesWithFinalFields(_1,_2,_3){
if(_1.$274w.canceled){
return Promise.reject(_1.$274w.asCanceledResult())}
if(_3==null||(_3.removeEmpty(),_3).isEmpty()){
return isc.rejectWithError("No fields were selected for use in building the Hilite.")}
_1.$261z=_3;
var _4=this.summarizeDataSource(_1.dataSource,_3,_1.$261g,false);
_1.$263q=_4;
var _5={
dsSummary:_4
};
var _6={
cancellationController:_1.$274w,
messages:_2.messages.map(function(_13){
if(_13.source=="system"&&isc.AIEngine.$272z(_13.type)){
return{
source:_13.source,
content:String(_13.content).evalDynamicString(this,_5)
}}
return _13},this),
responseType:_2.responseType,
willHandleError:true
};
if(!_1.$274w.canceled&&_1.$261x)_1.$261x.show();
return this.asyncSendRequest(_6,_1.$261g)
.then(function(_13){
var _7=_13.message.content&&_13.message.content.hiliteSpecs;
if(!isc.isAn.Array(_7)){
if(isc.isAn.Object(_7)){
_7=[_7]}else{
return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage)}
}
for(var _8=_7.length;_8>0;--_8){
var i=_8-1,
_10=_7[i];
if(!isc.isAn.Object(_10)||
!isc.isA.String(_10.filterDescription)||
!isc.isA.String(_10.hiliteDescription)||
!_10.filterDescription.trim()||
!_10.hiliteDescription.trim())
{
_7.removeAt(i)}
}
if(_7.isEmpty()){
return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage)}
var _11=_7.length;
++_1.$261v;
isc.AI.$262i(_1,[{category:"success",content:"AI has determined the hilite styling and field(s) that should be hilited, for "+_11+" hilite(s)."},
{category:"detail",content:"Will now validate the hilite and apply the hilite criteria\u2026"}]);
var _12=isc.ResolvedValuesMapper.create({
values:_7,
cancellationController:_1.$274w,
maxConcurrent:3,
asyncMap:function(_10){
return isc.AI.$2704(_1,_10)}
});
return _12.getPromise()})}
,isc.A.$2700=function isc_c_AI__makeLikelyCSSColorRegExp(){
var _1="\\b(?:"+this.$270y.map(RegExp.$2680).join("|")+")\\b";
_1+="|#[a-f\\d]{3}(?:[a-f\\d](?:[a-f\\d]{2}(?:[a-f\\d]{2})?)?)?\\b";
var _2="(?:[-+]?\\d+(?:\\.\\d*)?(?:[Ee][-+]?\\d+)?%?)";
_1+="|rgba?\\(\\s*"+_2+"\\s*,?\\s*"+_2+"\\s*,?\\s*"+_2+
"(?:\\s*,\\s*"+_2+")?\\)";
this.$2705=new RegExp(_1)}
,isc.A.$2706=function isc_c_AI__extractLikelyCSSColor(_1){
this.$2705.lastIndex=0;
var _2=this.$2705.exec(_1);
return _2&&_2[0]}
,isc.A.$2707=function isc_c_AI__validateCSSColor(_1,_2){
var _3=_1[_2];
if(!isc.isA.String(_3)){
delete _1[_2];
return}
_3=_3.trim().toLowerCase();
var _4;
for(var _5=new RegExp("[a-z]+","g"),_6=_5.exec(_3);_6;_6=_5.exec(_3)){
_4=this.$270x[_6[0]];
if(_4){
break}
}
if(!_4){
_4=this.$2706(_3)}
if(!_4)delete _1[_2];
else _1[_2]=_4}
,isc.A.$2708=function isc_c_AI__removeCSSComments(_1){
var _2=0;
do{
_2=_1.indexOf("/*",_2);
if(_2<0)return _1;
var _3=_1.indexOf("*/",_2+1);
if(_3<0){
return _1.substring(0,_2)}
_1=_1.substring(0,_2)+_1.substring(_3+2)}while(_2<_1.length);
return _1}
,isc.A.$2709=function isc_c_AI__removeCSSProperty(_1,_2,_3,_4){
var _5;
var _6=new RegExp("[\\s;]*"+RegExp.$2680(_2)+"\\s*:([^;]*)[\\s;]*","gim");
var _7;
while(_7=_6.exec(_1)){
_5=_7[1]+" "+(_5||"");
var _8=_1.substring(0,_6.lastIndex-_7[0].length),
_9=_1.substring(_6.lastIndex),
_10=!_8||!_9?"":";";
_1=_8+_10+_9;
_6.lastIndex-=_7[0].length}
_3[_4]=(_3[_4]||"")+" "+_5;
return _1}
,isc.A.$2704=function isc_c_AI__asyncValidateAndFinishHilite(_1,_2){
if(_2.fieldName!=null){
if(!isc.isAn.Array(_2.fieldName))_2.fieldName=[_2.fieldName];
for(var _3=_2.fieldName.length;_3>0;--_3){
var i=_3-1,
_5=_2.fieldName[i];
if(!_1.$261z.find("name",_5)){
isc.logWarn("AI selected an invalid field '"+_5+"'. Deleting...","AI");
_2.fieldName.removeAt(i)}
}
if(_2.fieldName.isEmpty())delete _2.fieldName;
else if(_2.fieldName.length==1)_2.fieldName=_2.fieldName[0]}
if(!isc.isA.String(_2.cssText)){
delete _2.cssText}else{
_2.cssText=this.$2708(_2.cssText);
_2.cssText=this.$2709(_2.cssText,"color",_2,"textColor");
_2.cssText=this.$2709(_2.cssText,"background-color",_2,"backgroundColor");
_2.cssText=this.$2709(_2.cssText,"text-decoration-color",_2,"$271a");
this.$2707(_2,"$271a");
if(_2.$271a){
if(_2.cssText)_2.cssText+="; ";
_2.cssText+="text-decoration-color: "+_2.$271a}
}
this.$2707(_2,"textColor");
this.$2707(_2,"backgroundColor");
if(!_2.textColor){
if(!_2.backgroundColor){
_2.textColor=this.$270x["red"]}else{
if(isc.ColorUtils.isDark(_2.backgroundColor)){
_2.textColor="#fff"}
}
}
var _6={
cancellationController:_1.$274w,
purpose:"hilite",
userAIRequest:{prompt:_2.filterDescription},
dataSource:_1.dataSource,
mode:_1.mode,
maxRetries:_1.buildRequest.maxRetries,
showProgressDialog:false
};
return isc.AI.asyncBuildCriterion(_6)
.then(function(_10){
var _7=isc.applyMask(_2,
["backgroundColor","textColor","cssText","fieldName","replacementValue"]);
var _8=_10.criterion;
_7.criteria=_8;
if(_8.operator!="aiFilter")return _7;
var _9={
cancellationController:_1.$274w,
aiCriterion:_8,
dataSource:_1.dataSource,
mode:_1.mode,
records:_1.buildRequest.records,
maxRetries:_1.buildRequest.maxRetries,
showProgressDialog:false
};
return isc.AI.asyncApplyAIFilter(_9)
.then(Promise.resolve(_7))})}
,isc.A.$2672=function isc_c_AI__validateAIBuiltUI(_1){
var _2=_1.buildRequest;
var _3=_1.$261c,
_4=_1.$261d,
_5;
var _6=function(){
_1.appliedValidationTypes.add(_5);
_4=_1.$261d=_4+1;
_1.$261e=0;
_1.$261f=null;
++_1.$261v;
isc.AI.$262i(_1,[{category:"success",content:"Finished applying '"+_5+"' validation"}])};
for(
;
_4<_3.length;
_6()
){
if(_1.$274w.canceled){
_1.$2671.reject(_1.$274w.asCanceledResult());
return}
_5=_3[_4];
var _7=Math.max(0,+_1.$261e);
if(isNaN(_7))_7=_1.$261e=0;
var _8=Math.max(0,_2.maxValidationRetries==null?1:_2.maxValidationRetries);
if(isNaN(_8))_8=1;
if(_7>_8){
_1.$2671.reject(isc.createErrorResult(
"Exceeded the maximum number of retries ("+_8+") for '"+_5+"' validation."
));
return}
var _9;
if(_5=="custom"){
_9=_2.customValidator;
this.$102q(_9!=null)}else if(_5=="default"){
_9={target:this,methodName:"buildUIViaAIDefaultValidator"}}
if(_9==null){
this.logWarn("validateAIBuiltUI(): Unhandled validation type '"+_5+"'");
continue}
this.fireCallback(_9,isc.AI.$265o,[
_1,
_1.$261f,
function(_12,_13){
var _10=String.prototype.trim.call(_12.jsCode||"");
_1.jsCode=_10;
_1.nodes=_12.nodes;
_1.$261f=_13;
var _11=_12.errorMessage;
if(_11!=null){
isc.AI.logDebug("validateAIBuiltUI(): validation type '"+_5+"' failed: "+_11,"AI");
_11="Validation type '"+_5+"' failed: "+_11;
if(_10==""){
_1.$2671.reject(isc.createErrorResult(
"Validation type '"+_5+"' failed: "+_11
));
return}
++_1.$261e;
if(_1.$261e<=_8){
try{
if(!new RegExp("\\p{P}$","u").test(_11))_11+="."}catch(e){}
if(!/\s$/.test(_11))_11+=" ";
_11+="Will retry\u2026"}
isc.AI.$262i(_1,[{category:"recoverableError",content:_11}])}else{
_6()}
isc.AI.$2672(_1)}
]);
return}
_1.$2671.resolve({
type:"success",
jsCode:_1.jsCode,
nodes:_1.nodes
})}
);
isc.evalBoundary;isc.B.push(isc.A.$261q=function isc_c_AI__getPaletteNodesAndValidationResult(_1,_2,_3){
var _4=function(_6,_7){
var _5;
try{
_5=isc.EditContext.validatePaletteNodeDefaults(_7)}catch(e){
_2(e);
return}
_3(_6,_5)};
isc.EditContext.createPaletteNodesFromJS2(_1,_4)}
,isc.A.buildUIViaAIDefaultValidator=function isc_c_AI_buildUIViaAIDefaultValidator(_1,_2,_3){
var _4=this;
var _5=function(_6){
_4.fireCallback(_3,isc.AI.$265p,[_6,_2])};
if(isc.EditContext==null){
return _5({
jsCode:_1.jsCode,
nodes:_1.nodes
})}
if(_2==null){
_2={
prevJsCode:[],
prevValidationResults:[]
}}
this.$261q(
_1.jsCode,
function(_6){
_4.logWarn("buildUIViaAIDefaultValidator(): Error attempting to validate AI-built code: "+_6);
_5({
errorMessage:"Attempting to validate AI-generated JavaScript caused an error: "+_6
})},
function(_6,_7){
_2.prevJsCode.add(_1.jsCode);
_2.prevValidationResults.add(_7);
if(_7==null||isc.isAn.emptyObject(_7)){
return _5({
jsCode:_1.jsCode,
nodes:_6
})}else{
_4.requestUICodeValidationFix(
_1,
_2,
_7,
_3
);
return}
}
)}
,isc.A.requestUICodeValidationFix=function isc_c_AI_requestUICodeValidationFix(_1,_2,_3,_4){
var _5=function(_13){
isc.AI.fireCallback(_4,isc.AI.$265p,[_13,_2])};
var _6=function(_13){
_5({
type:"error",
errorMessage:_13,
jsCode:_1.jsCode
})};
var _7=isc.InternalAIMessagesBuilder.create({
userMessages:_1.$2615,
target:this,
evalVars:{
jsCode:_1.jsCode,
errors:this.$260x(_3)
}
});
_7.appendPrompts(this.uiCodeValidationPrompts);
_7.appendPrompts(this.uiCodeSuffixPrompts);
var _8={
cancellationController:_1.$274w,
messages:_7.aiMessages,
willHandleError:true
};
this.asyncSendRequest(_8,_1.$261g)
.then(function(_11){
var _9=_11.message.content||"";
var _10=String.prototype.trim.call(isc.AI.extractFencedCode(_9));
if(_10==""){
return _6("The AI engine returned no UI code in response to the request to generate corrected code.")}
isc.AI.$261q(
_10,
function(_13){
isc.AI.logWarn("requestUICodeValidationFix(): Error attempting to validate AI-built code: "+_13);
return _6("Attempting to validate AI-generated JavaScript caused an error: "+_13)},
function(_13,_14){
if(_14==null||isc.isAn.emptyObject(_14)){
return _5({
jsCode:_10,
nodes:_13
})}else{
_5({jsCode:_10,errorMessage:"AI returned code that failed validation. A request was made to correct the code."})}
}
)},function(_13){
var _11=isc.defaultAsyncOperationCatchCallback(_13);
if(_11.type=="canceled"){
var _12="An AI request was canceled. ";
if(_11.cancellationReason)_12+=_11.cancellationReason;
_5({type:_11.type,cancellationReason:_12});
return}
_6("An AI request failed: "+_11.errorMessage)})}
,isc.A.$2670=function isc_c_AI__createBuildUIViaAIContext(_1,_2,_3){
var _4=this.$267n(_1,_2,_3);
var _5=_2.$261c;
if(_5==null){
_5=isc.AI.defaultBuildUIViaAIValidationTypes}
if(_2.customValidator==null){
if(_5.contains("custom")){
_5=_5.duplicate();
_5.remove("custom")}
}else{
if(!_5.contains("custom")){
_5=_5.duplicate();
_5.add("custom")}
}
_4.$261c=_5;
_4.appliedValidationTypes=[];
_4.$261d=0;
_4.$261e=0;
_4.$261f=null;
_4.$2671=Promise.withResolvers();
_4.$261w=2+_5.length;
if(_2.showProgressDialog==null||_2.showProgressDialog){
_4.$261x=isc.BuildUIViaAIProgressDialog.create({
$266t:_4,
canCancel:_2.userCanCancel!=false
});
_4.$261x.show()}
this.$262i(_4,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
return _4}
,isc.A.buildDataBoundUI=function isc_c_AI_buildDataBoundUI(_1,_2){
this.$2677(this.$274t,_1,_2)}
,isc.A.asyncBuildDataBoundUI=function isc_c_AI_asyncBuildDataBoundUI(_1){
return this.$274v("$2740",_1)}
,isc.A.$2740=function isc_c_AI__asyncBuildDataBoundUI(_1,_2){
var _3;
var _4=this.$2670(this.$274t,_1,_2);
var _5=_1.availableDataSources||isc.AI.getDataSourceNames();
if(_5==null){
_3=isc.AI.noDataSourcesAvailableOrFoundErrorMessage}else{
if(!isc.isAn.Array(_5))_5=[_5];
var _6=_5.map(function(_10){
return isc.DS.get(_10)});
_6.removeEmpty();
if(_6.isEmpty()){
_3=isc.AI.noDataSourcesAvailableOrFoundErrorMessage}else{
_4._dataSources=_6}
}
var _7,
_8;
if(_3==null){
_7=this.dataBoundUITypeInfos;
if(_1.allowedUITypes!=null){
_7=isc.applyMask(_7,_1.allowedUITypes);
_8=isc.getKeys(_7);
if(_8.length!=_1.allowedUITypes.length){
var _9=_1.allowedUITypes.duplicate();
_9.removeList(_8);
_3="buildDataBoundUI() was passed unknown data-bound UI type(s): "+_9}
}else{
_8=isc.getKeys(_7)}
if(_8.isEmpty()){
_3="At least one UI type must be allowed."}
}
_4.$261h=_8;
_4.$261i=_7;
if(_3!=null){
_4.$267o.reject(isc.createErrorResult(_3))}else{
this.$267p(_4)
.then(function(_10){
return isc.AI.$2673(
_10,_4)})
.then(_4.$267o.resolve,function(_10){
_4.$267o.reject(isc.defaultAsyncOperationCatchCallback(_10))})}
return _4.$267o.promise}
,isc.A.$2673=function isc_c_AI__asyncBuildDataBoundUIWithSummarizedUserMessages(_1,_2){
if(_2.$274w.canceled){
return Promise.reject(_2.$274w.asCanceledResult())}
var _3=_2._dataSources,
_4=_2.$261i,
_5=_2.$261h;
this.$102q(!_3.isEmpty());
this.$102q(!_5.isEmpty());
var _6={
component:_5[0]
};
var _7=(_3.length>1);
if(_7){
_6.dataSource="someDataSourceID"}
var _8="";
for(var i=0;i<_5.length;++i){
var _10=_5[i];
_8+="\n\""+_10+"\": "+_4[_10].description}
var _11={
uiTypeDescriptions:_8,
uiTypes:this.$260x(_5),
responseExample:this.$260x(_6)
};
if(_7){
var _12={};
for(var i=0;i<_3.length;i++){
var _13=_3[i];
_12[_13.ID]=this.getShortDSDescription(_13)}
_11.dsDescriptions=this.$260x(_12);
_11.dsIDs=this.$260x(_3.getProperty("ID"))}
var _14=isc.InternalAIMessagesBuilder.create({
userMessages:_1,
target:this,
evalVars:_11
});
_14.appendPrompts(this.dataBoundUIInitiatorPrefixPrompts);
_14.appendPrompt(this.dataBoundUIInitiatorPrompt_UIOptions);
if(_7){
_14.appendPrompt(this.dataBoundUIInitiatorPrompt_DSOptions)}
_14.appendPrompt(this.dataBoundUIInitiator_UIResponseFormat);
if(_7){
_14.appendPrompt(this.dataBoundUIInitiator_DSResponseFormat)}
_14.appendPrompt(this.dataBoundUIInitiatorSuffix);
var _15={
cancellationController:_2.$274w,
messages:_14.aiMessages,
responseType:"object",
willHandleError:true
};
return this.asyncSendRequest(_15,_2.$261g)
.then(function(_18){
var _16=_18.message.content;
var _10=_16.component;
if(_10==null||
_10=="invald")
{
return isc.rejectWithError("AI could not determine a data-bound UI type to use to satisfy the request.")}
if(!_2.$261h.contains(_10)){
return isc.rejectWithError("AI requested to use the unavailable or unknown UI type '"+_10+"'.")}
_2.uiType=_10;
if(_7){
var _17=_16.dataSource;
if(_17==null||
_17=="invalid")
{
return isc.rejectWithError("AI could not determine which available data source to use to satisfy the request.")}
var _13=_2._dataSources.find("ID",_17);
if(_13==null){
return isc.rejectWithError("AI requested to use the unavailable or unknown data source '"+_17+"'.")}
_2.dataSource=_13}else{
_2.dataSource=_3[0]}
++_2.$261v;
isc.AI.$262i(
_2,
[{
category:"success",
content:"Gathered initial information about your request"
},{
category:"detail",
content:"AI will build a "+_10+
(_7?" using data source '"+_17+"'.":".")
}]
);
return isc.AI.$2674(_2)})}
,isc.A.$2674=function isc_c_AI__asyncRequestDataBoundUICode(_1){
var _2=isc.getValues(_1.dataSource.getFields());
var _3=_1.$261i[_1.uiType];
var _4=isc.InternalAIMessagesBuilder.create({
userMessages:_1.$2615,
target:this,
evalVars:{
componentType:_3.componentType,
dsSummary:"${dsSummary}",
componentCodePrompt:_3.codePrompt
}
});
_4.appendPrompts(this.dataBoundUICodePrefixPrompts);
_4.appendPrompts(this.uiCodeSuffixPrompts);
var _5={
messages:_4.aiMessages
};
var _6=this.$2679(_5);
if(_6.errorMessage)return isc.rejectWithError(_6.errorMessage);
var _7=_6.aiEngine.shouldUseAIFieldPaging(_5,_2,_1.$261g);
if(!_7){
return this.$2675(_2,_5,_1)}
++_1.$261w;
this.$262i(_1,[{category:"detail",content:isc.AI.willSubsetFieldsDetailMessage}],true);
return _6.aiEngine.asyncRetrieveFieldsForPrompt(
_5.messages,
"Build a component to show data from a dataSource",
_2,
_6,
_1.$261g)
.then(function(_8){
++_1.$261v;
this.$262i(_1,[{category:"success",content:isc.AI.finishedSubsettingFieldsDetailMessage}]);
return isc.AI.$2675(
_8,_5,_1)})}
,isc.A.$2675=function isc_c_AI__asyncBuildDataBoundUIWithFinalFields(_1,_2,_3){
if(_3.$274w.canceled){
return Promise.reject(_3.$274w.asCanceledResult())}
if(_1==null||(_1.removeEmpty(),_1).isEmpty()){
return isc.rejectWithError("No fields were selected for use in building the data-bound UI.")}
_3.$261z=_1;
var _4=this.summarizeDataSource(_3.dataSource,_1,_3.$261g,false);
var _5={
dsSummary:_4
};
var _6={
cancellationController:_3.$274w,
messages:_2.messages.map(function(_9){
if(_9.source=="system"&&isc.AIEngine.$272z(_9.type)){
return{
source:_9.source,
content:String(_9.content).evalDynamicString(this,_5)
}}
return _9},this),
willHandleError:true
};
return this.asyncSendRequest(_6,_3.$261g)
.then(function(_9){
if(_3.$274w.canceled){
return Promise.reject(_3.$274w.asCanceledResult())}
var _7=_9.message.content||"";
var _8=String.prototype.trim.call(isc.AI.extractFencedCode(_7));
if(_8==""){
return isc.rejectWithError("AI did not generate any UI code.")}
++_3.$261v;
isc.AI.$262i(_3,[{category:"success",content:"AI generated UI code. Will now validate\u2026"}]);
_3.jsCode=_8;
isc.AI.$2672(_3);
return _3.$2671.promise})}
,isc.A.buildDataUI=function isc_c_AI_buildDataUI(_1,_2,_3,_4){
var _5;
var _6={
userAIRequest:{prompt:_1}
};
if(_3==null){
_5="context is required to build a dataUI"}else{
_6.availableDataSources=_3.dataSources}
if(_5==null){
_6.allowedUITypes=_3.uiTypeNames}
var _7="status,result,context";
if(_5!=null){
return this.fireCallback(_2,_7,[-1,_5,_3])}
this.getEngine().buildDataBoundUI(_6,function(_8){
_5=_8.errorMessage;
if(_5!=null){
isc.AI.fireCallback(_2,_7,[-1,_5,_3])}else{
isc.AI.fireCallback(_2,_7,[0,_8.jsCode,_3])}
})}
,isc.A.extractFencedCode=function isc_c_AI_extractFencedCode(_1){
var _2=_1.match(this.fencedCodeRegex);
if(_2==null||_2.length<2)return _1;
return _2[1]}
,isc.A.getAIModel=function isc_c_AI_getAIModel(_1){
var _2=isc.AI.getEngine(_1);
return _2.model}
,isc.A.loadDataSource=function isc_c_AI_loadDataSource(_1){
if(isc.DS.get(_1)){
this.dataSourceLoaded(_1);
return}
if(!_1||this.$257l[_1])return;
this.$257l[_1]=true;
isc.DS.load(_1,{target:this,methodName:"dataSourceLoaded",args:[_1]},{loadParents:true})}
,isc.A.dataSourceLoaded=function isc_c_AI_dataSourceLoaded(_1){
delete this.$257l[_1];
var _2=this.dataSources[_1]=isc.DataSource.get(_1);
if(_2==null){
this.$257k[_1]=true;
this.logError("DataSource '"+_1+"' was not found or could not be loaded to make an AI request.","AI")}else{
var _3=this.$260m;
this.$260m=[];
for(let i=0;i<_3.length;i++){
const _5=_3[i];
if(_5.dataSourceName!=_1){
this.$260m.push(_5);
continue}
_5.engine.handleSendRequest(
_5.rawRequest,
_5.aiRequest,
_5.callback,
_5.config
)}
}
}
,isc.A.$2500=function isc_c_AI__getDataSource(_1,_2){
var _3=isc.AI.getEngine(_1),
_4=_3.getDataSourceName(_2),
_5=this.dataSources[_4]||isc.DS.get(_4);
if(_5&&!_5.$259m){
_5.addProperties({
$259m:true,
$259n:_5.transformRequest,
transformRequest:function(_8){
if(this.$259n){
var _6=this.$259n(_8)}
if(_8.dataProtocol=="clientCustom"){
var _7=_8.clientContext;
if(_7&&
(_7.spoofingMode=="full"||
_7.spoofedResponse!=null))
{
isc.AI.createSpoofedResponse(_8)}
}
return _6}
})}
return _5}
,isc.A.createSpoofedResponse=function isc_c_AI_createSpoofedResponse(_1){
var _2=_1.clientContext;
if(_2.spoofedResponse==null||_2.spoofingMode=="full"){
this.promptForSpoofedResponse(_1)}else{
if(_2.spoofedResponse.deferProcessSpoofedResponse){
if(_2.spoofedResponse.dsRequest){
this.processSpoofedResponse(_2.spoofedResponse.dsRequest,_2.spoofedResponse)}
_2.spoofedResponse.dsRequest=_1}else{
var _3=_2.spoofedResponse.getDelay||isc.isA.Number(_2.spoofedResponse.delay);
this.delayCall(
"processSpoofedResponse",
[_1,_2.spoofedResponse],
_3?0:this.spoofedResponseDelay
)}
}
}
,isc.A.processSpoofedResponse=function isc_c_AI_processSpoofedResponse(_1,_2){
if(_1===_2.dsRequest){
delete _2.dsRequest}
if(!_2.deferProcessSpoofedResponse&&
(_2.getDelay||isc.isA.Number(_2.delay)))
{
var _3;
if(_2.getDelay){
var _4=_1.clientContext;
_3=_2.getDelay(_4.aiRequest,_4.aiEngine)}else{
_3=_2.delay}
this.delayCall("$2697",[_1,_2],_3)}else{
this.$2697(_1,_2)}
}
,isc.A.$2697=function isc_c_AI__processSpoofedResponse(_1,_2){
_1.clientContext.dataSource.processResponse(
_1.requestId,
{
$260o:true,
status:0,
data:_2
}
)}
,isc.A.promptForSpoofedResponse=function isc_c_AI_promptForSpoofedResponse(_1){
var _2=_1.clientContext;
var _3=isc.DynamicForm.create({
autoDraw:false,
width:"100%",height:"*",
numCols:1,
titleOrientation:top,
items:[
{editorType:"HeaderItem",
value:_2.aiEngine.name+" Request"
},
{
name:"prompt",
titleOrientation:"top",
value:_2.aiRequest.prompt,
width:"*"
},
{name:"messages",
titleOrientation:"top",
editorType:"CanvasItem",
width:"*",height:"*",minHeight:400,
shouldSaveValue:true,
value:_2.aiRequest.messages,
createCanvas:function(){
var _4=this.$260p=isc.ListGrid.create({
$260q:this,
autoDraw:false,
width:"100%",height:"100%",
canEdit:true,
canFilter:false,
canSort:false,
canGroupBy:false,
canRemoveRecords:true,
canReorderFields:false,
wrapCells:true,
fixedRecordHeights:false,
alternateRecordStyles:true,
bodyProperties:{
nativeAutoHideScrollbars:false
},
fields:[{
name:"source",
title:"Source",
width:100,
valueMap:["user","system","AI"]
},{
name:"content",
title:"Content",
width:"*",
editorType:"TextAreaItem",
editorProperties:{
minHeight:100,
canHover:false
},
formatCellValue:function(_14,_15,_16,_17,_18){
if(!_14)return"";
if(_15.type=="jpegImage"||
_15.type=="pngImage")
{
var _5=isc.AIEngine.$269b(_15),
_6=_18.getColumnWidth(1);
return"<img src='data:"+_5+";base64,"+_14.asHTML()+"' style='width:"+_6+"px'>"}else if(isc.isAn.Object(_14)){
return isc.JSON.encode(_14,{dateFormat:"logicalDateString"})}
return String(_14).asHTML()}
}],
getEditorType:function(_14,_15){
if(_14.name=="content"&&_15&&isc.AIEngine.isImageMessage(_15)){
return"Base64ImageDataItem"}
return this.Super("getEditorType",arguments)},
getEditorProperties:function(_14,_15,_16){
var _7=this.Super("getEditorProperties",arguments);
if(_14.name=="content"&&_15&&isc.AIEngine.isImageMessage(_15)){
_7.accept="image/jpeg,image/png";
_7.mimeType=isc.AIEngine.$269b(_15);
_7.changed=function(_17,_18,_19){
var _5=this.mimeType,
_8=this.grid.getEditSession(_16);
_8.$31x.type=_5=="image/jpeg"?"jpegImage":"pngImage"}}
return _7},
getCellVAlign:function(_14,_15,_16){
return(_16==0?"top":"center")},
dataChanged:function(){
this.$260q.storeValue(this.data)}
});
var _9=isc.Button.create({
autoDraw:false,
title:"+",
autoFit:true,
click:function(){
_4.startEditingNew()}
});
return isc.VLayout.create({
autoDraw:false,
width:"100%",height:"100%",
members:[_4,_9]
})},
showValue:function(_14,_15){
if(this.$260p==null)return;
this.$260p.setData(_15)}
},
{editorType:"HeaderItem",
value:"Response"
},
{editorType:"ButtonItem",
title:"Generate AI Response",
click:function(_14){
var _10=_14.getItem("messages"),
_4=_10.$260p;
if(_4)_4.endEditing();
var _11=_14.getItem("$269c");
if(_11)_11.disable();
_2.aiEngine.sendRequest(
isc.addProperties({},_2.aiRequest,{
prompt:_14.getValue("prompt"),
messages:_10.getValue()
}),
function(_15,_16){
if(_11)_11.enable();
var _12=_15.message&&_15.message.content;
if(_15.message&&(_15.message.type=="array"||_15.message.type=="object")){
_12=isc.JSON.encode(_12)}
_14.setValue("response",_12)},
{
responseSpoofingMode:"none",
context:{doNotCapture:true}
}
)}
},
{name:"response",
editorType:"TextAreaItem",showTitle:false,
width:"*",height:100,
value:(_2.spoofedResponse?_2.spoofedResponse.value:null)
},
{
name:"$269c",
editorType:"ButtonItem",
title:"Process Response",
click:function(){
isc.AI.delayCall("processSpoofedResponse",[_1,{value:this.form.getValue("response")}]);
this.form.parentWindow.markForDestroy()}
}
]
});
var _13=isc.Window.create({
title:"Create AI Response",
width:700,height:"90%",
canDragResize:false,
autoCenter:true,
showCloseButton:false,
items:[_3],
bodyProperties:{
alwaysShowScrollbars:true
}
});
_3.parentWindow=_13;
_13.show()}
,isc.A.setDefaultSpoofedResponse=function isc_c_AI_setDefaultSpoofedResponse(_1){
this.$259o=_1==null?null:{value:_1}}
,isc.A.addSpoofedResponses=function isc_c_AI_addSpoofedResponses(_1){
this.$259j.addList(_1)}
,isc.A.addSpoofedResponse=function isc_c_AI_addSpoofedResponse(_1){
this.$259j.add(_1)}
,isc.A.clearSpoofedResponses=function isc_c_AI_clearSpoofedResponses(){
this.$259j=[]}
,isc.A.removeSpoofedResponse=function isc_c_AI_removeSpoofedResponse(_1){
var _2=this.$259j.findIndex(_1);
if(_2!=-1){
this.$259j.removeAt(_2)}
}
,isc.A.removeSpoofedResponses=function isc_c_AI_removeSpoofedResponses(_1){
this.$259j.removeList(_1)}
,isc.A.getSpoofedResponse=function isc_c_AI_getSpoofedResponse(_1,_2){
var _3=_2.makePromptText(_1);
for(var _4=0;_4<this.$259j.length;++_4){
var _5=this.$259j[_4];
var _6=false;
if(isc.isA.Number(_5.numMatchesRemaining)){
if(_5.numMatchesRemaining<=0)continue}else if(_5.singleUse){
_5.numMatchesRemaining=1}
if(_5.matchesPrompt!=null){
_6=_5.matchesPrompt(_3,_5)}else if(_5.prompt!=null){
var _7=_5.textMatchStyle||"iContains",
_8=_7.startsWith("i")?_3.toLowerCase():_3,
_9=_7.startsWith("i")?_5.prompt.toLowerCase():_5.prompt;
switch(_7){
case"contains":
case"iContains":
_6=_8.contains(_9);
break;
case"startsWith":
case"iStartsWith":
_6=_8.startsWith(_9);
break;
case"endsWith":
case"iEndsWith":
_6=_8.endsWith(_9);
break;
case"equals":
case"iEquals":
default:
_6=(_8==_9);
break}
}
if(_6){
if(isc.isA.Number(_5.numMatchesRemaining))--_5.numMatchesRemaining;
if(isc.isAn.Object(_5.value)){
_5.value=isc.JSON.encode(_5.value,{dateFormat:"logicalDateString"})}
return _5}
}
if(this.$259o!=null)return this.$259o}
,isc.A.getInitiatorMessage=function isc_c_AI_getInitiatorMessage(_1){
var _2=this.getDataSourceDefinitions();
var _3=this.getUISummary(true);
var _4=_3[0];
if(_1!=null){
_1.idMapping=_3[1]}
var _5=navigator.userAgent;
var _6=this.initiatorPromptTemplate.evalDynamicString();
_6+=this.getApplicationOverviewPrompt(_2,_4,_5);
return{source:"system",content:_6,type:"text"}}
,isc.A.getApplicationOverviewPrompt=function isc_c_AI_getApplicationOverviewPrompt(_1,_2,_3){
var _4="** SmartClient application and environment information **\n";
if(this.isShowcase){
_4+="The user is interacting with a sample application user interface with the following description:\n\n";
_4+=window["featureExplorer_exampleDescription"].getContents()+"\n\n"}
_4+="Partial code for the DataSources present in this application is below, with only important properties shown:\n";
_4+=_1+"\n\n";
_4+="Partial code for the currently visible UI of the application is below, with only important properties shown.\nComponents listed in this summary may be referenced directly by their \"ID\" property or by passing that ID to \"isc.Canvas.getById()\".\"\n\n"
_4+=_2+"\n\n";
_4+="The SmartClient version is \""+isc.version+
"\" and the browser's userAgent is \""+_3+"\".\n";
return _4}
,isc.A.handleAITransportError=function isc_c_AI_handleAITransportError(_1,_2,_3,_4){
var _5=_1.URL||"";
if(_5.startsWith("https://api.openai.com/")){
return true}else{
return false}
}
,isc.A.asyncSuggestRecordSummaryTitle=function isc_c_AI_asyncSuggestRecordSummaryTitle(_1){
return this.$273t("$273w",_1)}
,isc.A.suggestRecordSummaryTitle=function isc_c_AI_suggestRecordSummaryTitle(_1,_2){
this.$273v("asyncSuggestRecordSummaryTitle",_1,_2)}
,isc.A.$273w=function isc_c_AI__asyncSuggestRecordSummaryTitle(_1,_2){
var _3=_1.aiRequest;
if(!_3){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"aiRequest"}))}
var _4=_2.dataSource;
if(!_4){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"dataSource"}))}
var _5=[{content:_3.prompt,type:_3.promptType}],
_6=_3.additionalMessages;
if(_6){
_5.addList(_6);
_5.removeEmpty()}
var _7=_5;
var _8=_1.visibleFieldNames,
_9;
if(!_8){
var _10;
if(_2.component&&(_10=_2.component.getVisibleFields())){
var _11=_10.getProperty("name");
_9=isc.getValues(isc.applyMask(_2.availableFieldsIndex,_11))}else{
_9=_2.availableFields.duplicate()}
}else{
var _12=_2.availableFieldNames;
for(var i=0;i<_8.length;++i){
var _14=_8[i];
if(!_12.contains(_14)&&
!_8.contains(_14,i+1))
{
this.logWarn("'"+_14+"' was specified in the list of visible field names, but there is no such available field.","AI")}
}
_9=isc.getValue(isc.applyMask(_2.availableFieldsIndex,_8))}
if(_9){
for(var _15=_9.length;_15>0;--_15){
var i=_15-1,
_16=_9[i],
_14=_16.name,
_17=_16.title;
if(!isc.isA.nonemptyString(_14)||
!isc.isA.String(_17)||isc.isAn.emptyString(_17.trim())||
_16.canView==false||
_16.hidden==true)
{
_9.removeAt(i)}
}
if(_9.isEmpty())_9=null}
var _18=isc.InternalAIMessagesBuilder2.create({
ssMessages:_7,
messagesSource:_1.aiRequestSource,
target:this,
evalVars:{
dsSummary:"${dsSummary}",
dsName:_4.ID
}
});
_18.appendPrompts(this.suggestRecordSummaryTitlePrompts);
if(_9){
var _19={};
for(var i=0;i<_9.length;++i){
var _16=_9[i];
_19[_16.name]=_16.title}
_18.appendPrompt(this.suggestRecordSummaryTitlePrompts_visibleFields+this.$260x(_19))}else{
_18.appendPrompt(this.suggestRecordSummaryTitlePrompts_noVisibleFields)}
_18.appendPrompt(this.suggestRecordSummaryTitlePrompts_final);
var _20={
messages:_18.aiMessages,
responseType:"object"
};
var _21=_2.availableFields,
_22=_2.availableFieldNames;
var _23=this.summarizeDataSource(_4,_21,{format:"compactJSON"},false);
var _24={
dsSummary:_23
};
var _25={
cancellationController:_2.cancellationController,
messages:_20.messages.map(function(_30){
if(_30.source=="system"&&isc.AIEngine.$272z(_30.type)){
return{
source:_30.source,
content:String(_30.content).evalDynamicString(this,_24)
}}
return _30},this),
responseType:_20.responseType,
willHandleError:true
};
var _26=this.$2679(_20);
if(_26.errorMessage)return isc.rejectWithError(_26.errorMessage);
var _27={
maxRetries:_1.maxRetries
};
return _26.aiEngine.asyncSendRequest(_25,_27)
.then(function(_30){
var _28=_30.message.content,
_29;
if(!isc.isAn.Object(_28)||
!isc.isA.String(_28.suggestedTitle)||
!(_29=_28.suggestedTitle.trim()))
{
return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage)}
return{
type:"success",
suggestedTitle:_29,
relevantFieldNames:_22
}})}
);
isc.evalBoundary;isc.B.push(isc.A.isAIFieldRequestNumerical=function isc_c_AI_isAIFieldRequestNumerical(_1){
var _2=_1.valueClass;
return _2=="ordinal"||_2=="interval"||_2=="ratio"}
,isc.A.$272h=function isc_c_AI__createBuildAIFieldRequestContext(_1,_2,_3){
var _4=this.$267n(_1,
_2,
_3);
_4.dabOpContext=_3;
if(_2.showProgressDialog==true){
_4.$261x=isc.BuildViaAIProgressDialog.create(_2.progressDialogProperties,{
$266t:_4,
canCancel:_2.userCanCancel!=false
});
_4.$261x.show()}
_4.$261w=1;
this.$262i(_4,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
return _4}
,isc.A.buildAIFieldRequest=function isc_c_AI_buildAIFieldRequest(_1,_2){
this.$2677(this.$274u,_1,_2)}
,isc.A.asyncBuildAIFieldRequest=function isc_c_AI_asyncBuildAIFieldRequest(_1){
return this.$273t("$272i",_1)}
,isc.A.$272i=function isc_c_AI__asyncBuildAIFieldRequest(_1,_2){
if(!_1.userAIRequest){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"userAIRequest"}))}
var _3=_2.dataSource;
if(!_3){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"dataSource"}))}
var _4=this.$272h(this.$274u,_1,_2);
this.$274f(_1,_2,_4)
.then(function(_5){
_4.$267o.resolve({type:"success",aiFieldRequest:_5})},function(_5){
_4.$267o.reject(isc.defaultAsyncOperationCatchCallback(_5))});
return _4.$267o.promise}
,isc.A.$274f=function isc_c_AI___asyncBuildAIFieldRequest(_1,_2,_3){
var _4=_2.dataSource,
_5=_4.getID(),
_6=_2.availableFields,
_7=_2.availableFieldNames,
_8=_1.userAIRequest;
if(!isc.AIEngine.$272z(_8.promptType)||
isc.isA.nonemptyArray(_8.additionalMessages))
{
throw isc.createErrorResult("A non-text and/or multiple-message 'aiFieldPrompt' is not currently supported.")}
var _9=_8.prompt;
var _10={
dataSource:_4,
dsName:_5,
fields:_6,
aiFieldPrompt:_9
};
_10.dsSummary=this.render("summarizeDataSource",_10);
let _11=_4.sampleData;
if(_10.haveSampleData=isc.isA.nonemptyArray(_11)){
_11=isc.shallowClone(_11);
for(let r=0;r<_11.length;++r){
const _13=_11[r];
for(let n=0;n<_7.length;++n){
const _15=_7[n];
if(!Object.hasOwn(_13,_15)){
_13[_15]=null}
}
}
_11=isc.applyMask(_11,_7);
const _16=_11.length;
_10.dsSummary+="\n\nHere is a sample of "+_16+" record".pluralize(_16)+" (sample data) from the '"+_5+"' DataSource:\n"+
isc.JSON.encode(_11,{
prettyPrint:false,
strictQuoting:true,
dateFormat:"xmlSchema",
circularReferenceMode:"omit"
})}
var _17={
cancellationController:_3.$274w,
responseType:"object"
};
var _18=_7,
_19=_9;
return this.asyncSendPrompt(this.buildAIFieldRequestTemplatedString,_10,_3.$261g,_17)
.then(function(_35){
var _20=_35.message.content;
if(!isc.isAn.Object(_20)){
return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage)}
var _21=_20.relevantFieldNames,
_22;
if(isc.isA.String(_21))_21=[_21];
if(!isc.isAn.Array(_21)){
_22=_18}else{
_22=[];
for(var i=0;i<_21.length;++i){
var _15=_21[i];
if(_15==null||isc.isAn.Object(_15))continue;
_15=String(_15).trim();
if(_18.contains(_15)&&
!_22.contains(_15))
{
_22.push(_15)}
}
if(_22.isEmpty()){
_22=_18}
}
_21=_22;
var _24=_20.valueClass;
if(_24!="categorical"&&
_24!="ordinal"&&
_24!="interval"&&
_24!="ratio")
{
_24="general"}
var _25,
_26;
if(_24=="categorical"||_24=="ordinal"){
var _27=_20.dataDependentReason;
if(_27&&(_27=_27.trim())){
isc.AI.logWarn("AI specified a reason for data-dependence: "+_27,"AI")}
_25=_20.categories;
if(isc.isAn.Array(_25)){
var _28=[];
for(var i=0;i<_25.length;++i){
var _29=_25[i];
if(_29==null||isc.isAn.Object(_29))continue;
_29=String(_29);
if(!(_29=_29.trim())){
isc.AI.logWarn("AI generated an empty string as a category.","AI");
continue}
if(_28.contains(_29)){
isc.AI.logWarn("AI generated duplicate category '"+_29+"'.","AI");
continue}
_28.push(_29)}
_25=_28;
_26={};
if(isc.isAn.Object(_20.categoryHints)){
for(var _29 in _20.categoryHints){
if(!Object.hasOwn(_20.categoryHints,_29))continue;
var _30=_20.categoryHints[_29];
if(!(_29=_29.trim()))continue;
if(!_25.contains(_29)){
isc.AI.logWarn("AI generated a hint for non-existent category '"+_29+"'.","AI");
continue}
if(!isc.isA.String(_30)){
isc.AI.logWarn("AI generated a non-string hint for category '"+_29+"'.","AI");
continue}
if(!(_30=_30.trim()))continue;
_26[_29]=_30}
}
}
if(!isc.isAn.Array(_25)||_25.isEmpty()){
_26=_25=null;
_24="general"}
}
var _31,
_32;
if(_24=="interval"||_24=="ratio"){
_31=parseFloat(_20.minValue);
if(!isc.isA.Number(_31))_31=null;
_32=parseFloat(_20.maxValue);
if(!isc.isA.Number(_32))_32=null;
else if(isc.isA.Number(_31)&&_31>_32){
isc.AI.logWarn("AI selected minValue = "+_31+" greater than maxValue = "+_32+". Ignoring...","AI");
_32=_31=null}
}
const _33=_20.displayDirection;
if(/most-to-least/i.test(_33))_20.sortDirection="descending";
else if(/least-to-most/i.test(_33))_20.sortDirection="ascending";
else delete _20.sortDirection;
var _34;
if((_24=="ordinal"||_24=="interval"||_24=="ratio")&&
(_20.sortDirection=="ascending"||
_20.sortDirection=="descending"))
{
_34=_20.sortDirection;
if(_24=="ordinal"&&_34=="descending"){
_25.reverse();
_34="ascending"}
}
return isc.addPropertiesWithAssign({},_8,{
summarizedAIFieldPrompt:_19,
relevantFieldNames:_21,
valueClass:_24,
categories:_25,
categoryHints:_26,
minValue:_31,
maxValue:_32,
sortDirection:_34
})})}
,isc.A.applyAIFieldRequestToFieldDefaults=function isc_c_AI_applyAIFieldRequestToFieldDefaults(_1,_2){
this.$102q(_2.aiFieldRequest==null||_2.aiFieldRequest===_1);
_2.aiFieldRequest=_1;
var _3=_1.valueClass;
if(_3=="categorical"){
_2.type="enum";
_2.valueMap=_1.categories;
_2.editorType="SelectItem"}else if(_3=="ordinal"){
_2.type="intEnum";
_2.valueMap=isc.addPropertiesWithAssign({},_1.categories);
_2.editorType="SelectItem"}else if(this.isAIFieldRequestNumerical(_1)){
_2.type="float";
if(_1.minValue!=null||_1.maxValue!=null){
var _4=_2.validators;
if(!_4)_4=_2.validators=[];
var _5;
if(_1.minValue!=null){
supplyMinValidator:do{
for(var v=0;v<_4.length;++v){
var _7=_4[v];
if(_7.applyWhen!=null||
_7.serverOnly)
{
continue}
if(_7.type=="integerRange"||
_7.type=="floatLimit"||
_7.type=="floatRange")
{
if(isc.isA.Number(_7.min)&&
_1.minValue<=_7.min)
{
break supplyMinValidator}
}
}
_5={
type:"floatRange",
min:_1.minValue
};
_4.push(_5)}while(false)}
if(_1.maxValue!=null){
supplyMaxValidator:do{
for(var v=0;v<_4.length;++v){
var _7=_4[v];
if(_7.applyWhen!=null||
_7.serverOnly)
{
continue}
if(_7.type=="integerRange"||
_7.type=="floatLimit"||
_7.type=="floatRange")
{
if(isc.isA.Number(_7.max)&&
_1.maxValue>=_7.max)
{
break supplyMaxValidator}
}
}
if(_5!=null){
_5.max=_1.maxValue}else{
_5={
type:"floatRange",
max:_1.maxValue
};
_4.push(_5)}
}while(false)}
}
}else{
_2.type="text"}
_2.sortDirection=_1.sortDirection;
return _2}
,isc.A.asyncSummarizeRecords=function isc_c_AI_asyncSummarizeRecords(_1,_2){
return this.$273t("$274e",_1,_2)}
,isc.A.summarizeRecords=function isc_c_AI_summarizeRecords(_1,_2,_3){
this.$273v("asyncSummarizeRecords",_1,_2,_3)}
);
isc.B._maxIndex=isc.C+72;
isc.AI.registerTemplates({
summarizeRecordsPrompt_categorical:function(state,sc,j){
return isc.trimDoc`
            In the context of an Isomorphic SmartClient application, this is a request to
            supplement the data in \${numRecords} \${'record'.pluralize(numRecords)} (given below) from
            the '${state.dataSource.getID()}' DataSource, using relevant general knowledge and
            your own reasonable inferences from the data.

            ${sc.render("summarizeDataSource", state)}

            For \${numRecords == 1 ? 'the' : 'each'} record given below, you are to select
            exactly one of the following categories:
            ${j(state.categories, true)}

            The descriptions of each category are:
            ${j(state.categoryHints, true)}

            The rule for selecting which category to apply to \${numRecords == 1 ? 'the' : 'each'} record is:
            <category-selection-rule>\${ssMessages}</category-selection-rule>

            Your response must be a single JSON object with the following properties:
            * "result" (array of \${numRecords} \${'string'.pluralize(numRecords)}):
              \${numRecords > 1 ? 'For each record, in the same corresponding order of the records,' : 'A single-element array of'} the category
              that you selected for the record.
            * "reasoning" (array of \${numRecords} \${'string'.pluralize(numRecords)}):
              \${numRecords > 1 ? 'For each record, in the same corresponding order of the records,' : 'A single-element array of'} a string containing
              a shortened summary of the following:
                - The reason why you selected the category for the record according to the category-selection-rule.
                - Any general knowledge that you used in making your selection.
                - Any assumptions that you made in this selection.
                - Any uncertainties that you have.

            Here \${numRecords == 1 ? 'is' : 'are'} the \${numRecords} \${'record'.pluralize(numRecords)}:`}
});
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.summarizeRecordsPrompts_interval=[
"This is a request to calculate a number for records from a DataSource, using relevant general knowledge and your own reasonable inferences from the data. The number to be calculated for each record is:",
"${ssMessages}"
];
isc.A.summarizeRecordsPrompts_interval_minValue="The minimum value is ${minValue}. ";
isc.A.summarizeRecordsPrompts_interval_maxValue="The maximum value is ${maxValue}. ";
isc.A.summarizeRecordsPrompts_interval_final="The records specified below are from the DataSource with the following description: ${dsSummary}\n\nYour response should be a single JSON object with one key \"result\" and value being an array of just the calculated numbers for each corresponding record. Here are the records:";
isc.A.canTranslateViaAI=true;
isc.A.componentActions={
filter:{
methodName:"buildFilter",
description:"Apply filter criteria to the component"
},
hilite:{
methodName:"buildHilite",
description:"Apply hiliting to the component"
},
sort:{
methodName:"buildSort",
description:"Apply a sort to the component"
},
groupBy:{
methodName:"buildGroupBy",
description:"Group the components data by some field(s) or ungroup the component"
},
setFields:{
methodName:"buildSetFields",
description:"Change the visible set of fields for the component"
}
};
isc.B.push(isc.A.$274e=function isc_c_AI__asyncSummarizeRecords(_1,_2,_3){
var _4=_1.aiFieldRequest;
if(!_4){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"aiFieldRequest"}))}
var _5=_3.dataSource;
if(!_5){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"dataSource"}))}
var _6=_1.records;
if(!_6){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"records"}))}
var _7;
if(_4.maxRecordsPerBatch){
_7=_4.maxRecordsPerBatch;
if(_1.maxRecordsPerBatch){
_7=Math.min(_7,_1.maxRecordsPerBatch)}
}else{
_7=_1.maxRecordsPerBatch}
var _8=[{content:_4.prompt,type:_4.promptType}],
_9=_4.additionalMessages;
if(_9){
_8.addList(_9);
_8.removeEmpty()}
var _10;
if(!isc.isA.nonemptyArray(_4.relevantFieldNames)){
_10=_3.availableFields;
if(!isc.isA.nonemptyArray(_10)){
return isc.rejectWithError("There are no available fields, so no record values can be sent to AI.")}
}else{
_10=isc.getValues(isc.applyMask(_3.availableFieldsIndex,_4.relevantFieldNames));
if(_10.isEmpty()){
return isc.rejectWithError("No available field is relevant. Therefore, no record values can be sent to AI.")}
}
var _11=_10.getProperty("name");
var _12={
dataSource:_5,
fields:_10,
dsSummary:this.summarizeDataSource(_5,_10,{format:"compactJSON"},false)
};
var _13=isc.InternalAIMessagesBuilder2.create({
ssMessages:_8,
messagesSource:_1.aiFieldRequestSource,
target:this,
evalVars:_12
});
var _14=_4.valueClass,
_15=_4.categories;
if(_14=="interval"||_14=="ratio"){
_13.appendPrompts(this.summarizeRecordsPrompts_interval);
if(isc.isA.Number(_4.minValue)){
if(isc.isA.Number(_4.maxValue)&&_4.minValue>_4.maxValue){
return isc.rejectWithError("`aiFieldRequest.minValue` cannot be greater than `aiFieldRequest.maxValue`.")}
_12.minValue=_4.minValue;
_13.appendPrompt(this.summarizeRecordsPrompts_interval_minValue)}
if(isc.isA.Number(_4.maxValue)){
_12.maxValue=_4.maxValue;
_13.appendPrompt(this.summarizeRecordsPrompts_interval_maxValue)}
_13.appendPrompt(this.summarizeRecordsPrompts_interval_final)}else if(_14=="categorical"||_14=="ordinal"){
for(var i=0;i<_15.length;++i){
var _17=_15[i];
if(!isc.isA.String(_17)){
return isc.rejectWithError("Non-string category at index "+i+" within `aiFieldRequest.categories`.")}
if(_15.contains(_17,i+1)){
return isc.rejectWithError("Duplicate category '"+_17+"' in `aiFieldRequest.categories`.")}
}
if(_15.isEmpty()){
return isc.rejectWithError("No categories are defined.")}
if(_15.length<2){
return isc.rejectWithError("There must be at least two categories.")}
var _18=isc.applyMask(_4.categoryHints,_15);
_12.categories=_15;
_12.categoryHints=_18;
_13.renderTemplate("summarizeRecordsPrompt_categorical")}else{
_13.appendPrompts(this.summarizeRecordsPrompts_general)}
var _19=!this.isAIFieldRequestNumerical(_4);
var _20={
cancellationController:_3.cancellationController,
messages:_13.aiMessages,
responseType:"object"
};
var _21={
cancellationController:_3.cancellationController,
maxConcurrent:_1.maxConcurrent,
maxRecordsPerBatch:_7,
maxRetries:_1.maxRetries==null?2:_1.maxRetries,
stopOnError:false,
recordIndexFieldName:""
};
var _22=[];
var _23={
cancellationController:_3.cancellationController,
request:_1,
partialResults:_22
};
var _24;
return this.asyncRepeatRequestOnBatches(_20,_1.records,_11,_21,function(_36){
if(_3.cancellationController&&_3.cancellationController.canceled)return;
var _25,
_26;
if(_36.type!="success"){
if(!_24)_24=_36;
_25=_36;
_26=isc.addPropertiesWithAssign({},_25)}else{
var _27=_36.message&&
_36.message.content&&
_36.message.content.result;
if(!isc.isAn.Array(_27))_27=[_27];
if(_19){
for(var i=0;i<_27.length;++i){
if(_27[i]==null)continue;
_27[i]=String(_27[i])}
}else if(_14=="ordinal"){
for(var i=0;i<_27.length;++i){
if(_27[i]==null)continue;
if(isc.isAn.Object(_27[i])){
_27[i]=null;
continue}
var _28=_15.indexOf(String(_27[i]));
_27[i]=_28<0?null:_28}
}else{
for(var i=0;i<_27.length;++i){
if(_27[i]==null)continue;
if(isc.isAn.Object(_27[i])){
_27[i]=null;
continue}
var _29=parseFloat(_27[i]);
if(!isc.isA.Number(_29)){
_27[i]=null}else{
if(isc.isA.Number(_4.minValue)){
_29=Math.max(_4.minValue,_29)}
if(isc.isA.Number(_4.maxValue)){
_29=Math.min(_29,_4.maxValue)}
_27[i]=_29}
}
}
var _30=_36.length;
_27.setLength(_30);
_25={
type:"success",
startIndex:_36.startIndex,
length:_30
};
_26=isc.addPropertiesWithAssign({},_25);
if(_19){
_25.recordSummaries=_27;
_26.recordSummaries=_27.duplicate()}else{
_25.recordNumericalSummaries=_27;
_26.recordNumericalSummaries=_27.duplicate()}
}
_22.push(_25);
isc.AI.fireCallback(_2,isc.AI.$2693,
[_26,_23]);
return _25}).$271y(function(_36){
if(_24||_36.type!="success"){
return Promise.reject(isc.addPropertiesWithAssign({},_24||_36,{partialResults:_22}))}
isc.AI.$102q(!_3.cancellationController||
!_3.cancellationController.canceled);
_36.aiResponsesForBatches.sortByProperty("startIndex",true);
var _31=_36.aiResponsesForBatches.getProperty("callbackReturnValue"),
_32=[];
for(var _33=0,i=0;i<_31.length;++i){
var _25=_31[i];
isc.AI.$102q(_33==_25.startIndex);
isc.AI.$102q(_25.length>0);
var _34=_19?_25.recordSummaries:_25.recordNumericalSummaries;
isc.AI.$102q(_34.length==_25.length);
_32.addList(_34);
_33+=_25.length}
var _35={
type:"success",
partialResults:_22
};
if(_19)_35.recordSummaries=_32;
else _35.recordNumericalSummaries=_32;
return _35})}
,isc.A.translateText=function isc_c_AI_translateText(_1,_2,_3,_4){
if(!_1||!_2){
this.logWarn("'phrase' and 'targetLocales' parameters are required");
return}
if(!isc.isAn.Array(_2))_2=[_2];
var _5=_2.duplicate();
if(_2.contains("sr")){
_2.remove("sr");
_2.add("sr-Cyrl")}
var _6="Please translate the source phrase '"+_1+"' to this list of locales: "+_2.join(", ")+".\n\n";
_6+="All punctuation, HTML markup and non-alpha characters in the source phrase should be included in your translation and any word prefixed with a '$' character, such as '$description' or '$titleField', must be included verbatim without translation.\n\n ";
_6+="Your response should be a simple JSON object where property-names are the list of requested locale-codes, and each value is your translation to that locale.  Any content outside of this JSON object, such as a prefix like 'Response:' is invalid and should not be included.\n\n";
if(_4&&_4.attrName){
_6+="For context, the source phrase is the default value for an Isomorphic SmartClient framework property with the approximate name '"+
_4.attrName.replace("_"," ")+"' and the following description: "+
_4.doc+"\n"}
var _7=this;
isc.AI.origSendPrompt(_6,function(_9){
_9=_9.replaceAll("\"sr-Cyrl\"","\"sr\"");
var _8=_7._extractJsonResult(_9);
_7.fireCallback(_3,"result,context",[_8,_4])},{showPrompt:false})}
,isc.A.buildFormula=function isc_c_AI_buildFormula(_1,_2,_3,_4){
_4=isc.addProperties({},_4,{showPrompt:false});
var _5=_3.grid||_3.rootCanvas;
var _6=_3.dataSource;
var _7=_6!=null?isc.getValues(_6.getFields()):_5.getFields();
var _8=["float","integer","int","long","number","decimal","double"];
var _9=[];
for(var i=0;i<_7.length;i++){
if(_8.contains(_7[i].type||"text"))
_9.add(_7[i])}
var _11="You are to generate an Isomorphic SmartClient UserFormula object based on a user-provided description.\n\n";
_11+="A SmartClient UserFormula is an object with two properties - 'text', which is a mathematical formula that can contain variable-names, and 'formulaVars' which is an object mapping those variable-names to the names of fields on an associated data-record.  The variable-names range from A-Z, and then onward to a maximum of ZZZ.  You should map natural language to the most appropriate field-names, which are listed below.  Only fields in this list are allowed.\n\n";
_11+="For example, a user might ask for and expect the following:\n\nuser-prompt: '(field1 plus field2) times 100'\nresponse: {text:'(A+B)*100',formulaVars:{A:'field1',B:'field2'}}\n\nor\n\nuser-prompt: 'Show the average of distance1 and distance2'\nresponse: ({text:'(A+B)/2',formulaVars:{A:'distance1',B:'distance2'}})\n\n";
_11+="A trinary operator may be used if a user requests conditional logic. For example:\n\nuser-prompt: 'if field1 is greater than zero, field2 * field3, otherwise -(field2 * field3)'\nresponse: ({text:'(A > 0) ? (B * C) : -(B*C)',formulaVars:{A:'field1',B:'field2',C:'field3'}})\n\n";
_11+="In addition to simple operators ('+','-','*','/'), the UserFormula text may make use of any of the following MathFunction(s).\nmax(val1,val2): Maximum of two values\nmin(val1,val2): Minimum of two values\nround(value,decimalDigits): Round a value up or down, optionally providing decimalDigits as the maximum number of decimal places to round to. For fixed or precision rounding, use toFixed() and toPrecision() respectively.\nceil(value): Round a value up\nfloor(value): Round a value down\nabs(value): Absolute value\npow(value1,value2): value1 to the power of value2\nsqrt(value): Square root of a value\ndateAdd(value,interval,amount): Excel-compatible dataAdd function: adds quantities of a time interval to a date value. Also supports being passed interval names, like \"hour\" or \"week\".\nyear(value): 4-digit integer that represents the year of a date.\nmonth(value): 1-12 integer that represents the month of a date.\nday(value): 1-31 integer that represents the day of month of a date.\ntoPrecision(value,precision): Format a number to a length of precision digits, rounding or adding a decimal point and zero-padding as necessary. Note that the values 123, 12.3 and 1.23 have an equal precision of 3. Returns a formatted string and should be used as the outermost function call in a formula. For rounding, use round().\ntoFixed(value,digits): Round or zero-pad a number to digits decimal places. Returns a formatted string and should be used as the outermost function call in a formula. To round values or restrict precision, use round() and toPrecision() respectively.\nsin(value): Sine of a value\ncos(value): Cosine of a value\ntan(value): Tangent of a value\nln(value): natural logarithm of a value\nlog(base,value): logarithm of a value with the specified base\nasin(value): Arcsine of a value\nacos(value): Arccosine of a value\natan(value): Arctangent of a value (-PI/2 to PI/2 radians)\natan2(value1,value2): Angle theta of a point (-PI to PI radians)\nexp(value): The value of Evalue\nrandom(): Random number between 0 and 1\n\nFor example:\n\nuser-prompt: 'show the maximum of region1Revenue, region2Revenue'\nresponse: ({text:'max(A,B)',formulaVars:{A:'region1Revenue',B:'region2Revenue'}})\n\n";
_11+="The user-prompt may indicate a name or title to use for the formula.  If not, please generate a short (two to four word) title.  Either way, please include it in the UserFormula object you generate, as the 'title' property.\n\n";
_11+="Here is the list of fields available for use in UserFormula objects - ";
if(this.shouldUseAIFieldPaging(_11,_9,_4)){
var _12=this;
this.retrieveFieldsForPrompt(
_1,"Create a userFormula field for a ListGrid",_9,
function(_13){
_12.$260a(_1,_11,_2,_3,_4,_13)},
_3,_4
)}else{
this.$260a(_1,_11,_2,_3,_4,_9)}
}
,isc.A.$260a=function isc_c_AI__buildFormulaWithFinalFields(_1,_2,_3,_4,_5,_6){
_2+=this.getSerializedFields(_6,_5);
_2+="Your task is to generate a UserFormula object to satisfy this user request: '"+_1+"'\n\n";
_2+="Please respond only with the UserFormula object - any surrounding content will cause JSON decode issues down-stream.\n"
var _7=this;
isc.AI.origSendPrompt(
_2,
function(_9){
var _8=_7._extractJsonResult(_9);
_7.fireCallback(_3,"result,context",[_8,_4])},
_5
)}
,isc.A.buildCompositeViewSettings=function isc_c_AI_buildCompositeViewSettings(_1,_2,_3,_4){
var _5=_3.grid;
var _6=_5&&_5.getScClassName();
if(_6==null)_6="ListGrid";
var _7=_3.actions||isc.getKeys(this.componentActions);
var _8="A user is interacting with a(n) "+_6+" component in an application built with Isomorphic SmartClient Javascript framework.\nThe user has issued the following request:\n\n\""+_1+"\"\n\nThis may be requesting one or more actions of the following type(s):\n";
for(var i=0;i<_7.length;i++){
var _10=_7[i];
if(this.componentActions[_10]==null)continue;
_8+=_10+": "+this.componentActions[_10].description+"\n"}
_8+="\n\nPlease determine which action(s) the user is requesting and return a series of rephrased queries as a JSON string where each attribute name is the requested action type, and the attribute value is a rephrased version of the part of the query that requests that action type.\n\n"
_8+="For example if the user prompt was: \n'Show only items where cost is greater than 1 and hilite the cost field for items that are on sale'\nAn example response might be:\n"+
'{"filter":"Show only items where cost is greater than 1", "hilite":"hilite the cost field for items that are on sale"}\n\n';
_8+="\nIf you can't determine which of actions are being requested, return an empty JSON object";
var _11=this;
var _12=function(_13){
_11.processSplitCompositeViewRequests(_13,_1,_2,_3,_4)}
this.origSendPrompt(_8,_12)}
,isc.A.processSplitCompositeViewRequests=function isc_c_AI_processSplitCompositeViewRequests(_1,_2,_3,_4,_5){
var _6=JSON.parse(_1);
var _7=false;
_4.actions=_6;
_4.actionResults={};
_4.callback=_3;
var _8=this;
for(var _9 in _6){
var _10=_6[_9];
if(this.componentActions[_9]!=null){
_7=true;
var _11=this.componentActions[_9].methodName;
var _12=isc.addProperties({
actionType:_9,
originalContext:_4
},_4);
this[_11](
_10,
function(_13,_12){
_8.buildCompositeViewSettingsReply(_13,_12)},
_12,
_5
)}else{
this.logWarn("Unrecognized action type '"+_9+"' for AI-generated partial request:"+_6[_9]);
delete _6[_9]}
}
}
,isc.A.buildCompositeViewSettingsReply=function isc_c_AI_buildCompositeViewSettingsReply(_1,_2){
var _3=_2.actionType;
var _4=_2.originalContext;
_4.actionResults[_2.actionType]=_1;
delete _4.actions[_3];
if(isc.isA.emptyObject(_4.actions)){
this.fireCallback(_4.callback,"data,context",[_4.actionResults,_4])}
}
);
isc.B._maxIndex=isc.C+7;
isc.A=isc.Operators;
isc.A.aiFilterTitle="matches a natural language description of a filter, as determined by AI";
isc.A.aiFilterDescriptionPrefix="Filter via AI: "
;
isc.DataSource.addSearchOperator({
ID:"aiFilter",
titleProperty:"aiFilterTitle",
symbol:"\uD83E\uDD16",
hidden:true,
clientOnly:true,
valueType:"custom",
getDescription:function(_1,_2){
return isc.Operators.aiFilterDescriptionPrefix+isc.AI.$268n(_1,_2).asHTML()},
getCleanCriterion:function(_1,_2){
return isc.AI.$268o(_1)},
fromCleanCriterion:function(_1,_2){
return isc.AI.$268p(_1)},
condition:function(_1,_2,_3,_4){
var _5=_3.criterion;
if(!isc.AI.$267a(_5,_4)||
_5.isTrivial)
{
return true}
var _6=_5.$263s,
_7=_3.record;
if(_6.length==1){
var _8=_7[_6[0]];
if(isc.isA.Class(_5.$263v)&&_5.$263v.has(_8)){
return false}
if(isc.isA.Class(_5.$264f)&&_5.$264f.has(_8)){
return true}
}else{
this.$102q(false)}
if(_4.$59u){
if(!_5.$267f)return false;
return _4.evaluateCriterion(_7,_5.$267f)}else{
if(!_5.$267g)return true;
return _4.evaluateCriterion(_7,_5.$267g)}
},
compareCriteria:function(_1,_2){
if(_1.$264d!=_2.$264d){
return-1}
var _3=isc.DS.getDataSource(_1.$264d);
if(_3==null||
!isc.AI.$267a(_1,_3)||
!isc.AI.$267a(_2,_3))
{
return-1}
if(_1.isTrivial){
if(_2.isTrivial)return 0}else{
if(_2.isTrivial)return 1}
return-1},
getServerCriterion:function(_1,_2,_3){
var _4=_2?isc.DS.$2652:isc.DS.$2653;
if(!isc.AI.$267a(_1,_3)){
return _4}
if(_1.isTrivial){
return isc.DS.$2653}
var _5;
if(_2){
var _6=null,
_7=_1.$263s;
if(_7.length==1){
var _8=_7[0];
if(isc.isA.Class(_1.$264f)){
_6={
_constructor:"AdvancedCriteria",
fieldName:_8,
operator:"inSet",
value:_1.$264f.getContents()
}}
}else{
this.$102q(false)}
_5=_3.combineCriteria(_6,_1.$267f)}else{
_5=_3.combineCriteria(_1.$2667,_1.$267g)}
return _5==null?_4:_5},
asyncFilter:function(_1,_2,_3){
var _4=_3.dataSource;
if(!isc.AI.$267a(_1,_4)){
return Promise.reject(isc.createErrorResult("The 'aiFilter' is not usable."))}
if(_1.isTrivial)return null;
var _5={
aiCriterion:_1,
showProgressDialog:false,
cancellationController:_3.cancellationController
};
if(_3.recordsWereUpdated){
_5.updatedRecords=_2;
return isc.AI.asyncReapplyAIFilter(_5)}
var _6=isc.AI.$267j(_1,_2,_4);
isc.AI.$102q(isc.isAn.Array(_6.matchingRecords)&&
_6.matchingRecords.length+(_6.remainingRecords==null
?0
:_6.remainingRecords.length)==_2.length);
if(!_6.remainingRecords||_6.remainingRecords.length==0){
return null}
_5.records=_2;
_5.$267i=_6;
return isc.AI.asyncApplyAIFilter(_5)},
removeFromFilterCaches:function(_1,_2){
isc.AI.removeFromAIFilterCaches(_1,_2)},
clearFilterCaches:function(_1){
isc.AI.clearAIFilterCaches(_1)},
getDependencies:function(_1){
if(_1.isTrivial)return[];
return _1.$263t}
});
isc.AI.init();
isc.FieldGeneratorRegistry.register({
ID:"AI",
asyncInitField:function(_1,_2,_3){
if(_1.aiFieldRequest){
isc.AI.applyAIFieldRequestToFieldDefaults(_1.aiFieldRequest,_1);
return null}
var _4;
if(isc.isA.String(_1.aiFieldPrompt)){
_4={prompt:_1.aiFieldPrompt}}else{
_4=_1.aiFieldPrompt}
var _5=[_1.name],
_6=_2.getAllFields();
for(var f=0,_8=!_6?0:_6.length;f<_8;++f){
var _9=_6[f];
if(_9!==_1&&
_2.$275h(_9)===this)
{
_5.push(_9.name)}
}
var _10={
cancellationController:_3.cancellationController,
userAIRequest:_4,
aiFieldSettings:_1.aiFieldSettings,
component:_2,
excludeFieldNames:_5,
showProgressDialog:false
};
return isc.AI.asyncBuildAIFieldRequest(_10)
.$2800(function(_11){
isc.AI.applyAIFieldRequestToFieldDefaults(_11.aiFieldRequest,_1);
return{type:"success"}},
null,
this,
_2.ns.EH)},
asyncGenerateValues:function(_1,_2,_3,_4){
var _5=_3.component,
_6=this.getNonSuccessfulResultAtOutset(_1,_5);
if(_6){
isc.Class.$102q(_6.type!="success");
return Promise.reject(_6)}else if(_2.getLength()>_5.aiMaxRecords){
return isc.rejectAsDisabled(_5.$278z())}
var _7={
cancellationController:_3.cancellationController,
component:_5,
dataSource:_3.dataSource,
excludeFieldNames:_3.excludeFieldNames,
aiFieldRequest:_1.aiFieldRequest,
records:_2
};
return isc.AI.asyncSummarizeRecords(_7,function(_10){
var _8=_10.startIndex,
_9=_8+_10.length;
_10.records=_2.slice(_8,_9);
if(_10.type=="success"){
_10.generatedValues=_10.recordSummaries||_10.recordNumericalSummaries}
isc.AI.fireCallback(_4,"partialResult",[_10])}).then(function(_10){
return{
type:_10.type,
generatedValues:_10.recordSummaries||_10.recordNumericalSummaries
}})},
getNonSuccessfulResultAtOutset:function(_1,_2){
if(!isc.AI.isEnabled()){
return isc.createDisabledResult(isc.AI.aiWasDisabledMessage)}
},
getNonSuccessfulRecordSortResultAtOutset:function(_1,_2){
var _3=_2.getDataAsList();
if(!_3)return;
if(_3.lengthIsKnown&&!_3.lengthIsKnown()){
return isc.createDisabledResult(isc.AsyncUtil.dataBeingFetchedMessage)}else if(_3.getLength()>_2.$273n()){
return isc.createDisabledResult(_2.$2780())}
},
getDependencies:function(_1,_2){
if(!_1.aiFieldRequest)return[];
return _1.aiFieldRequest.relevantFieldNames},
settingFieldPropertyInvalidatesCache:function(_1,_2,_3,_4){
if(_3=="aiFieldRequest"){
if(_1.aiFieldRequest==null)return _4!=null;
else if(_4==null)return true;
else{
isc.Class.$102q(_1.aiFieldRequest!=null&&_4!=null);
return _1.aiFieldRequest!==_4}
}
},
controllingFieldProperties:["aiFieldPrompt","aiFieldSettings","aiFieldRequest"]
});
isc.PseudoFieldGeneratorRegistry.register({
type:"hover",
ID:"AI",
asyncGenerateValue:function(_1,_2,_3){
var _4=_1.masterFieldName;
if(!isc.isA.nonemptyString(_4)){
return isc.rejectWithError("Expecting `masterFieldName` to be a single field name.")}
var _5=_3.component.getSpecifiedField(_4);
if(!_5){
return isc.rejectWithError("No such field named '"+_4+"'")}
var _6=_5.aiHoverRequest;
if(!_6){
return isc.rejectWithError("The master field is missing an `aiHoverRequest`.")}
var _7={
cancellationController:_3.cancellationController,
value:_2[_4],
aiRequest:_6,
examples:_6.examples
};
if(_6.includeRecord!=false){
_7.component=_3.component;
_7.record=_2;
_7.relevantFieldNames=_6.relevantFieldNames;
_7.fieldName=_4}
return isc.AI.asyncSummarizeValue(_7)
.then(function(_8){
return{
type:_8.type,
generatedValue:_8.summary.trim().asHTML()
}})},
getDependencies:function(_1,_2){
var _3=_1.masterFieldName;
if(!isc.isA.nonemptyString(_3))return[];
var _4=_2.getSpecifiedField(_3);
if(!_4)return[];
var _5=_4.aiHoverRequest;
if(!_5)return[];
if(_5.includeRecord!=false)return[_3];
var _6=_5.relevantFieldNames;
if(!_6)return null;
if(!_6.contains(_3)){
_6=_6.duplicate();
_6.push(_3)}
return _6},
getRetryDelay:function(_1,_2){
return _2.aiHoverRetryDelay},
getPlaceholderHoverContents:function(_1,_2,_3){
return _3.placeholderAIHoverContents},
formatHoverContents:function(_1,_2,_3,_4){
var _5=_1.masterFieldName,
_6=!isc.isA.nonemptyString(_5)?null:_3.getSpecifiedField(_5),
_7=(_6&&_6.aiHoverContentsPrefix!=null
?_6.aiHoverContentsPrefix
:_3.aiHoverContentsPrefix)||"";
if(!_4||!(_4=String(_4))){
_7+=_3.emptyAIHoverContents}else{
_7+=_4}
return _7}
});
isc.defineClass("AIFieldBuilder","SummaryBuilder");isc.A=isc.AIFieldBuilder.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.autoTest=false;isc.A.showFieldKey=false;isc.A.showHelpIcon=false;isc.A.showMessageLabel=false;isc.A.showAutoHideCheckBox=false;isc.A.builderTypeText="Description";isc.A.canEditAttributeName="canEditAISummary";isc.A.instructionsTextStart="Enter a description of what information you want to see in the field.  AI will receive the complete record and be asked to generate a value for the record in the field.<p>AI can do things like:<ul><li>text summarization (<q>give a two line summary of the abstract</q> or <q>list the applicant's top 3 skills</q> or <q>extract any urgent request within the message</q>)<li>sentiment analysis (<q>rate the customer's satisfaction on a scale of 1 (least satisfied) to 10 (most satisfied) based on their review</q>)<li>use common knowledge (<q>guess the contact's time zone</q>)</ul>";isc.A.initialAutoSuggestTitleHint="[use AI-generated title]";isc.A.pendingSuggestTitleHint="[generating a title…]";isc.A.nonSuccessfulSuggestTitleHint="[failed to generate a title: ${message}]";isc.A.suggestedTitleHint="[AI-generated: ${suggestedTitle}]";isc.A.testButtonTitle="Try It";isc.A.testButtonHoverContents="Click to have AI generate a value from your description";isc.A.testButtonHoverContents_cantTest="You cannot try having AI generate a value at this time.";isc.A.testButtonHoverContents_cantTestWithoutData="Without data, you cannot try having AI generate a value.";isc.A.undeterminedResponsePrompt="<i>Could not determine an answer</i>";isc.A.autoSuggestTitle=true;isc.A.autoSuggestTitleDelay=500;isc.A.suggestTitleThreshold=20;isc.A.anotherSuggestedTitleRequestedCancellationReason="Another suggested title was requested.";isc.A.loadingIconSize=24;isc.A.loadingIconSrc="[SKINIMG]loadingSmall.gif";isc.A.loadingDivStyle="display:flex;align-items:center;justify-content:center;height:100%";isc.A.loadingMessage="<div style='${loadingStyle}'>${loadingImage}</div>";isc.B.push(isc.A.$2732=function isc_AIFieldBuilder__evalNonSuccessfulSuggestTitleHint(_1){return this.nonSuccessfulSuggestTitleHint.evalDynamicString(this,{message:_1&&_1.asHTML()
})}
,isc.A.$2733=function isc_AIFieldBuilder__evalSuggestedTitleHint(_1){return this.suggestedTitleHint.evalDynamicString(this,{suggestedTitle:_1&&_1.asHTML()
})}
,isc.A.$2734=function isc_AIFieldBuilder__getInitialTitleFieldHint(){var _1=this.getValue();if(_1==this.$49c&&this.$2735){return this.$2733(this.$2735)}
return!this.$2736()?null:this.initialAutoSuggestTitleHint}
,isc.A.$274l=function isc_AIFieldBuilder__getTestButtonHoverHTML(){if(this.$274m())return this.testButtonHoverContents;if(!this.getTestRecord())return this.testButtonHoverContents_cantTestWithoutData;return this.testButtonHoverContents_cantTest}
,isc.A.testButtonClick=function isc_AIFieldBuilder_testButtonClick(){this.requestTestSummary("user")}
,isc.A.$2736=function isc_AIFieldBuilder__shouldAutoSuggestTitle(){return this.autoSuggestTitle!=false}
,isc.A.setAutoSuggestTitle=function isc_AIFieldBuilder_setAutoSuggestTitle(_1){var _2=this.$2736();this.autoSuggestTitle=_1;var _3=this.$2736();if(_2==_3)return;this.setTitleFieldHint(this.$2734());if(!_3){this.cancelActionOnPause("suggestTitle")}else{this.$2737("application")}
}
,isc.A.itemChanged=function isc_AIFieldBuilder_itemChanged(_1,_2){if(_1===this.formulaField){if(this.$2736()){this.fireOnPause("suggestTitle",{methodName:"$2737",args:["user"]},this.autoSuggestTitleDelay)}
}else if(_1===this.titleField){if(!this.$2738()){this.setTitleFieldHint(this.$2734());var _3=this.$2739;if(_3&&!_3.canceled){_3.cancel(null,"user")}
}
}
}
,isc.A.$274a=function isc_AIFieldBuilder__setLastValue(_1){if(_1!=this.$49c){this.$49c=_1;delete this.$2735;delete this.$2721}
}
,isc.A.$2738=function isc_AIFieldBuilder__shouldSuggestTitle(_1){return _1&&_1.length>=this.suggestTitleThreshold&&(!this.titleField||!this.titleField.getValue())&&isc.AI.isEnabled()}
,isc.A.$2737=function isc_AIFieldBuilder__suggestTitle(_1){var _2=this.getValue();if(!this.$2738(_2)){this.setTitleFieldHint(this.$2734());return}
var _3=this.$2739;if(_3&&!_3.canceled){_3.cancel(this.anotherSuggestedTitleRequestedCancellationReason,_1)}
_3=this.$2739=this.$273x().createSubController();if(_2==this.$49c&&this.$2735)
{this.setTitleFieldHint(this.$2733(this.$2735));return}
this.setTitleFieldHint(this.pendingSuggestTitleHint);var _4=this;this.$274b(_2,_3)
.then(function(_8){var _5=_4.getValue();if(_2!=_5)return;_4.$274a(_2);_4.$2735=_8;_4.setTitleFieldHint(_4.$2734())},function(_8){var _6=isc.defaultAsyncOperationCatchCallback(_8);if(_6.type!="canceled"){var _7=isc.getAsyncMessage(_6);_4.logWarn("Failed to get a suggested title for the prompt '"+_2+"': "+_7,"AI");_4.setTitleFieldHint(_4.$2732(_7))}
})}
,isc.A.$274b=function isc_AIFieldBuilder__asyncGetSuggestedTitle(_1,_2){if(_1==this.$49c&&this.$2735)
{return Promise.resolve(this.$2735)}
var _3=this.component,_4=this.field.name,_5;if(_4&&_3.getField(_4)){_5=[_4]}
var _6={cancellationController:_2,aiRequest:{prompt:_1},component:_3,excludeFieldNames:_5
};return isc.AI.asyncSuggestRecordSummaryTitle(_6)
.then(function(_7){return _7.suggestedTitle})}
,isc.A.getUniqueFieldName=function isc_AIFieldBuilder_getUniqueFieldName(){return this.getNewUniqueFieldName("aiField")}
,isc.A.getCompleteValueObject=function isc_AIFieldBuilder_getCompleteValueObject(){var _1=this.getValue();var _2=this.titleField&&this.titleField.getValue(),_3=false,_4=false;if(!this.$2730()){_3=this.field._hasDefaultTitle;_4=this.field._hasSuggestedTitle;_2=this.field.title}
if((!_2||_3||(_4&&this.$273z()))&&_1==this.$49c&&this.$2735)
{_2=this.$2735;_3=false;_4=true}
var _5={title:_2,_hasDefaultTitle:_3,_hasSuggestedTitle:_4},_6=this.$2721||{prompt:_1};return isc.AI.applyAIFieldRequestToFieldDefaults(_6,_5)}
,isc.A.$2722=function isc_AIFieldBuilder__asyncGetAIFieldRequest(_1,_2,_3){if(_1==this.$49c&&this.$2721)
{return Promise.resolve(this.$2721)}
var _4={cancellationController:_3,userAIRequest:{prompt:_1},component:this.component,showProgressDialog:_2
};return isc.AI.asyncBuildAIFieldRequest(_4)
.then(function(_5){return _5.aiFieldRequest})}
,isc.A.$274m=function isc_AIFieldBuilder__canTest(){return isc.AI.isEnabled()&&!!this.getTestRecord()}
,isc.A.requestTestSummary=function isc_AIFieldBuilder_requestTestSummary(_1){var _2=this.getTestRecord(),_3=this.getValue();if(!_3||!_2)return;var _4=this.$274d;if(_4&&!_4.canceled){_4.cancel(this.anotherTestRequestedCancellationReason,_1)}
_4=this.$274d=this.$273x().createSubController();this.showLoadingPrompt();if(this.testButton)this.testButton.disable();var _5=this;this.$2722(_3,false,_4)
.then(function(_7){var _6={cancellationController:_4,aiFieldRequest:_7,component:_5.component,records:[_2]
};return isc.AI.asyncSummarizeRecords(_6)
.then(function(_10){_10.$2723=_7;return _10})})
.$271y(function(_10){if(_10.type!="success"){if(_10.type!="canceled"){isc.warn("Failed to summarize the test record.<br>"+isc.getAsyncMessage(_10).asHTML())}
return}else _5.$102q(!_4.canceled);var _7=_10.$2723;var _8=!isc.AI.isAIFieldRequestNumerical(_7)
?_10.recordSummaries:_10.recordNumericalSummaries;var _9=_8[0];if(_9==null){isc.warn(isc.AI.aiNotAbleToProcessRequestErrorMessage);return}
if(_7.valueClass=="ordinal"){_9=_7.categories[_9]}
_5.$274a(_3);_5.$2721=_7;_5.$48r=_2;_5.$2425=_9})
.$271k(function(){if(_5.destroyed)return;_5.testFunction();if(_5.testButton)_5.testButton.enable()})}
,isc.A.getTitle=function isc_AIFieldBuilder_getTitle(){var _1=this.Super("getTitle",arguments);if(_1!=null)_1=String(_1).trim();return _1}
,isc.A.setInitialTitle=function isc_AIFieldBuilder_setInitialTitle(){var _1=this.field.title,_2=this.field._hasDefaultTitle,_3=this.field._hasSuggestedTitle;if(!_1){_1=isc.DataSource.getAutoTitle(this.field.name);_2=true;_3=false}
if(_1)_1=String(_1).trim();if(_3)this.$2735=_1;if(!(this.$2736()&&(_2||_3))){this.setTitle(_1)}
this.setTitleFieldHint(this.$2734())}
,isc.A.getValue=function isc_AIFieldBuilder_getValue(){var _1=this.Super("getValue",arguments);if(_1!=null)_1=String(_1).trim();return _1}
,isc.A.setInitialValue=function isc_AIFieldBuilder_setInitialValue(){var _1;if(this.field.aiFieldRequest&&isc.AIEngine.$272z(this.field.aiFieldRequest.promptType)){_1=this.field.aiFieldRequest.prompt;if(_1!=null)_1=String(_1).trim();this.$49c=_1;this.$2723=this.field.aiFieldRequest}
this.setValue(_1)}
,isc.A.save=function isc_AIFieldBuilder_save(){var _1=this.$273y;if(_1&&!_1.canceled){_1.cancel(this.userSavedCancellationReason,"user")}
var _2=this.getValue();if(!_2||!this.$273z()){this.Super("save");return}
if(this.editMode){isc.FieldGeneratorUtil.$275p(this.component,this.field,"user")}
this.$2722(_2,true,null)
.$2800(function(_3){this.$274a(_2);this.$2721=_3;this.invokeSuper(isc.AIFieldBuilder,"save")},function(_3){if(_3.type!="canceled"){this.completeEditing(true)}else{this.logWarn("Failed to build the AIFieldRequest: "+isc.getAsyncMessage(_3),"AI")}
},this)}
,isc.A.showLoadingPrompt=function isc_AIFieldBuilder_showLoadingPrompt(){var _1=this.loadingIconSize;this.sampleLabel.setContents(this.loadingMessage.evalDynamicString(this,{loadingStyle:this.loadingDivStyle,loadingImage:this.imgHTML(this.loadingIconSrc,_1,_1)
}))}
);isc.B._maxIndex=isc.C+23;isc.AIFieldBuilder.changeDefaults("titleFieldDefaults",{showHintInField:true,autoFocus:false});isc.AIFieldBuilder.changeDefaults("formulaFormDefaults",{numCols:1,titleOrientation:"top",autoFocus:true});isc.A=isc.AIFieldBuilder;isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.buildDummyTestRecords=false;isc.B.push(isc.A.testFunction=function isc_c_AIFieldBuilder_testFunction(_1,_2,_3,_4,_5,_6,_7){var _8={};_8.component=_3;if(_2.text==""){_8.emptyTestValue=true;return _8}
_8.record=_6.$48r;_8.result=_6.$2425;return _8}
);isc.B._maxIndex=isc.C+1;isc.defineClass("AISortFieldBuilder","AIFieldBuilder");isc.A=isc.AISortFieldBuilder.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.titleFieldTitle="Title for sort field";isc.A.instructionsTextStart="Enter a description of what information you want to sort by.  AI will receive the complete record and be asked to generate a value for the record.<p>Some examples:<ul><li><q>guess how heavy the item is in pounds: 'Less than 1', '1-4', '5-10', 'More than 10'&#8201;</q><li><q>rate the customer's satisfaction on a scale of 1 (least satisfied) to 10 (most satisfied) based on their review</q><li><q>rate the item's usefulness in running a small bakery</q></ul>";isc.A.showSaveAddAnotherButton=false;isc.A.titleFormDefaults={_constructor:"DynamicForm",autoFocus:true,extraSpace:5,colWidths:[40,"*"]
};isc.A.formulaFormDefaults={_constructor:"DynamicForm",numCols:1,titleOrientation:"top",extraSpace:5
};isc.A.undeterminedResponsePrompt="<i>Could not determine a score</i>";isc.B.push(isc.A.completeEditing=function isc_AISortFieldBuilder_completeEditing(_1,_2){this.Super("completeEditing",arguments);if(!_1){this.component.sort(this.field.name,this.component.$766(this.field))}
}
);isc.B._maxIndex=isc.C+1;isc.defineClass("BuildViaAIProgressDialog",isc.Dialog);isc.A=isc.BuildViaAIProgressDialog.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.$2485="$2481";isc.A.autoDraw=false;isc.A.minWidth=150;isc.A.height=230;isc.A.minHeight=230;isc.A.autoSize=true;isc.A.isModal=true;isc.A.canDragResize=true;isc.A.canDragReposition=true;isc.A.showCloseButton=false;isc.A.title="Building via AI\u2026";isc.A.canCancel=false;isc.A.headerLabelDefaults=isc.addProperties({},isc.BuildViaAIProgressDialog.getSuperClass().getInstanceProperty("headerLabelDefaults"),{icon:"[SKINIMG]AI/robot_blank.png"
});isc.A.progressbarDefaults={_constructor:"Progressbar",length:50,breadth:10,layoutAlign:"center"
};isc.A.message="";isc.A.messageLabelDefaults=isc.addProperties({},isc.BuildViaAIProgressDialog.getSuperClass().getInstanceProperty("messageLabelDefaults"),{height:25,align:"center"
});isc.A.messagesGridDefaults={_constructor:"ListGrid",width:"100%",height:"100%",wrapCells:true,fixedRecordHeights:false,showHeader:false,showRollOver:false,selectionType:"none",cellPadding:0,defaultFields:[{name:"category",width:30,valueIcons:{"success":"ok","detail":"configure","recoverableError":"exclamation","error":"cancel"
},showValueIconOnly:true,imageWidth:16,imageHeight:16,imageURLPrefix:"[SKINIMG]/actions/",imageURLSuffix:".png"
},{name:"content",width:"*"
}],drawn:function(){isc.Class.delayCall("scrollToBottom",[],1,this.body)}
};isc.B.push(isc.A.initWidget=function isc_BuildViaAIProgressDialog_initWidget(){this.Super("initWidget",arguments);this.progressbar=this.createAutoChild("progressbar");this.messagesGrid=this.createAutoChild("messagesGrid");if(this.canCancel){this.setButtons([isc.Dialog.CANCEL])}
}
,isc.A.createChildren=function isc_BuildViaAIProgressDialog_createChildren(){this.Super("createChildren",arguments);this.body.addMember(this.progressbar,0);this.body.addMember(this.messagesGrid,2)}
,isc.A.resized=function isc_BuildViaAIProgressDialog_resized(){if(this.destroyed)return;this.progressbar.setLength(this.messageLabel.getWidth()-4);isc.Class.delayCall("scrollToBottom",[],1,this.messagesGrid.body)}
,isc.A.setProgress=function isc_BuildViaAIProgressDialog_setProgress(_1,_2){if(this.destroyed)return;var _3=Math.max(0,Math.min(Math.floor(_1/_2*100),100));if(isNaN(_3))_3=0;this.progressbar.setPercentDone(_3);this.progressbar.setTitle("Completed "+_1+" out of an estimated "+_2+" step(s)");this.setMessage(_1+"\u2009/\u2009"+_2)}
,isc.A.addMessages=function isc_BuildViaAIProgressDialog_addMessages(_1){if(this.destroyed)return;if(_1!=null){for(var i=0;i<_1.length;++i){this.messagesGrid.addData(_1[i])}
if(this.messagesGrid.body!=null)isc.Class.delayCall("scrollToBottom",[],1,this.messagesGrid.body)}
}
,isc.A.finish=function isc_BuildViaAIProgressDialog_finish(_1){if(this.destroyed)return;this.progressbar.disable();if(this.messageStack==null){this.messageStackProperties=isc.addProperties({},this.messageStackProperties,{disabled:true})}else{this.messageStack.disable()}
this.messagesGrid.setOpacity(60);if(!_1){this.show();this.setButtons([isc.Dialog.OK])}else{this.hide();this.destroy()}
}
,isc.A.okClick=function isc_BuildViaAIProgressDialog_okClick(){if(this.destroyed)return;this.hide();this.destroy()}
,isc.A.cancelClick=function isc_BuildViaAIProgressDialog_cancelClick(){isc.AI.$265h(this.$266t,null,"user");if(this.destroyed)return;this.hide();this.destroy()}
);isc.B._maxIndex=isc.C+8;isc.defineClass("BuildUIViaAIProgressDialog",isc.BuildViaAIProgressDialog);isc.A=isc.BuildUIViaAIProgressDialog.getPrototype();isc.A.title="Building UI via AI&hellip;";isc.defineClass("FilterViaAIProgressDialog",isc.BuildViaAIProgressDialog);isc.A=isc.FilterViaAIProgressDialog.getPrototype();isc.A.title="Filtering via AI&hellip;";isc.defineClass("HiliteViaAIProgressDialog",isc.BuildViaAIProgressDialog);isc.A=isc.HiliteViaAIProgressDialog.getPrototype();isc.A.title="Hiliting via AI&hellip;";isc.defineClass("FilterViaAIPanel",isc.DynamicForm);isc.A=isc.FilterViaAIPanel.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.minWidth=400;isc.A.numCols=3;isc.A.colWidths=[130,"*","20%"];isc.A.fields=[{name:"prompt",title:"Filter via AI",width:"*",endRow:true
},{type:"SpacerItem"},{name:"$268q",type:"StaticText",showTitle:false,canEdit:false,colSpan:2
}];isc.B.push(isc.A.getPrompt=function isc_FilterViaAIPanel_getPrompt(_1){var _2=(_1?this.getOldValues().prompt:this.getValue("prompt"));if(_2)return _2.trim();else return""}
,isc.A.promptDidChange=function isc_FilterViaAIPanel_promptDidChange(){var _1=this.getPrompt(true),_2=this.getPrompt();return _1!=_2}
,isc.A.getUserAIRequest=function isc_FilterViaAIPanel_getUserAIRequest(){var _1=this.getPrompt();if(!_1)return null;return{prompt:_1}}
);isc.B._maxIndex=isc.C+3;isc.defineClass("AIWindow","Window");isc.A=isc.AIWindow.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.$2485="$2481";isc.A.width=400;isc.A.autoCenter=true;isc.A.autoSize=true;isc.A.isModal=true;isc.A.canDragResize=true;isc.A.canDragReposition=true;isc.A.showMinimizeButton=false;isc.A.height=100;isc.A.showHeaderIcon=true;isc.A.bodyProperties={padding:10,layoutMargin:10,membersMargin:10
};isc.A.title="AI Window";isc.A.description="Enter your question and click the button below to contact the AI.";isc.A.hint="Describe what you need here.";isc.A.grid=null;isc.A.labelDefaults={_constructor:"Label",width:"100%",height:1,contents:"",extraSpace:10
};isc.A.formDefaults={_constructor:"DynamicForm",height:"*",autoFocus:true,cellPadding:0
};isc.A.footerLayoutDefaults={_constructor:"HLayout",height:1,width:"100%",align:"bottom",defaultLayoutAlign:"center",membersMargin:10
};isc.A.progressBarDefaults={_constructor:"Progressbar",width:"*",height:30,length:"*",showTitle:true,visibility:"hidden"
};isc.A.cancelButtonTitle="Cancel";isc.A.cancelButtonDefaults={_constructor:"Button",autoFit:true,disabled:true,click:function(){this.creator.cancelWindow()},layoutAlign:"right"
};isc.A.aiButtonTitle="Ask the AI";isc.A.aiButtonDefaults={_constructor:"Button",autoFit:true,click:function(){this.creator.tellTheAI()},layoutAlign:"right"
};isc.B.push(isc.A.setMode=function isc_AIWindow_setMode(_1,_2,_3,_4,_5){this.mode=_1;if(_2)this.setTitle(_2);if(_3)this.label.setContents(_3);if(_4)this.form.getItem(0).setHint(_4);if(_5)this.aiButton.setTitle(_5)}
,isc.A.initWidget=function isc_AIWindow_initWidget(){this.headerIconDefaults.src=isc.AI.getIconURL(true);this.Super("initWidget",arguments);this.addItem(this.addAutoChild("label",{contents:this.labelContents}));this.addItem(this.addAutoChild("form",{items:[{name:"userText",type:"textArea",minHeight:50,width:"*",height:"*",colSpan:"*",showTitle:false,hint:this.creator.aiFilterWindowHint,showHintInField:true,keyPress:function(_1,_2,_3,_4){if(_3=="Enter"){this.form.creator.tellTheAI();return false}
}
}
]
}));this.addAutoChild("progressBar");this.addAutoChild("cancelButton",{title:this.cancelButtonTitle});this.addAutoChild("aiButton",{title:this.aiButtonTitle});this.addAutoChild("footerLayout",{members:[this.progressBar,isc.LayoutSpacer.create({width:1}),this.cancelButton,this.aiButton
]
});this.addItem(this.footerLayout,this.items.length)}
,isc.A.cancelWindow=function isc_AIWindow_cancelWindow(){if(this.$2658){this.$2658.cancel(null,"user");delete this.$2658}
this.resetUI()}
,isc.A.resetUI=function isc_AIWindow_resetUI(){this.aiButton.setDisabled(false);this.form.setDisabled(false);this.progressBar.setPercentDone(0);this.progressBar.hide();if(this.$2658){this.$2658.destroy();delete this.$2658}
}
,isc.A.getPromptText=function isc_AIWindow_getPromptText(){return this.form.getValue("userText")}
,isc.A.setPromptText=function isc_AIWindow_setPromptText(_1){if(this.form)this.form.setValue("userText",_1)}
,isc.A.tellTheAI=function isc_AIWindow_tellTheAI(){var _1=this.form.getValue("userText");this.form.setDisabled(true);this.aiButton.setDisabled(true);this.cancelButton.setDisabled(false);this.progressBar.setPercentDone(0);this.progressBar.setTitle("Preparing&hellip;");this.progressBar.show();var _2=this.$2658=isc.CancellationController.create();var _3=this;if(this.mode=="filter"){if(!_1){_3.resetUI();_3.hide();this.grid.setAICriterion(null)}else{var _4={prompt:_1};this.grid.setUserAIFilterRequest(_4,{cancellationController:_2,showProgressDialog:false,progressCallback:function(_7,_8,_9,_10){_3.progressBar.setPercentDone(100*_8/_9);if(_8>0){_3.progressBar.setTitle(_8+"\u2009/\u2009"+_9)}
}
},function(_7){if(!_2.canceled){_3.resetUI();_3.hide();if(_7.type!="success"){isc.warn("Filter-via-AI failed: "+_7.errorMessage)}
}
}
)}
}else if(this.mode=="hilite"){if(!_1){_3.resetUI();_3.hide();var _5=_3.grid.getHilites();if(_5&&_5.removeList(this.$271b)){this.grid.setHilites(_5)}
}else{var _6={cancellationController:_2,showProgressDialog:false,progressCallback:function(_7,_8,_9,_10){_3.progressBar.setPercentDone(100*_8/_9);if(_8>0){_3.progressBar.setTitle(_8+"\u2009/\u2009"+_9)}
}
};_3.grid.hiliteViaAI(_1,_6,function(_7){if(!_2.canceled){_3.resetUI();_3.hide();if(_7.type=="success"){var _5=_3.grid.getHilites()||[];_5.removeList(_3.$271b);_5.addList(_3.$271b=_7.hilites);_3.grid.setHilites(_5)}
}
},true)}
}
}
,isc.A.closeClick=function isc_AIWindow_closeClick(){this.cancelWindow();this.hide()}
);isc.B._maxIndex=isc.C+8;isc.defineClass("AISortProgressDialog","Window");isc.A=isc.AISortProgressDialog.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.autoCenter=true;isc.A.autoSize=true;isc.A.isModal=true;isc.A.showModalMask=true;isc.A.canDragResize=true;isc.A.canDragReposition=true;isc.A.autoParent=isc.Canvas.NONE;isc.A.visibility="hidden";isc.A.bodyDefaults={layoutMargin:10
};isc.A.title="Please wait - Computing record sort values";isc.A.dismissButtonTitle="Dismiss";isc.A.progressbarDefaults={_constructor:"Progressbar",autoParent:isc.Canvas.NONE,length:"100%"
};isc.A.dismissButtonDefaults={_constructor:"IButton",autoParent:isc.Canvas.NONE,layoutAlign:"center",click:function(){this.creator.hide()}
};isc.A.bodyProperties={membersMargin:20
};isc.B.push(isc.A.initWidget=function isc_AISortProgressDialog_initWidget(){this.Super("initWidget",arguments);this.addItems([this.addAutoChild("progressbar"),this.addAutoChild("dismissButton",{title:this.dismissButtonTitle
})
])}
,isc.A.hide=function isc_AISortProgressDialog_hide(){this.Super("hide",arguments);this.progressbar.setPercentDone(0);delete this.callback}
,isc.A.updateProgress=function isc_AISortProgressDialog_updateProgress(){this.progressbar.setPercentDone(100*this.currentRecords/this.totalRecords);if(this.currentRecords>=this.totalRecords){this.delayCall("$255u",[],0)}
}
,isc.A.$255u=function isc_AISortProgressDialog__progressComplete(){this.fireCallback(this.callback);this.hide()}
,isc.A.advanceOneRecord=function isc_AISortProgressDialog_advanceOneRecord(){this.currentRecords++;this.updateProgress()}
,isc.A.setCurrentRecords=function isc_AISortProgressDialog_setCurrentRecords(_1){this.currentRecords=_1;this.updateProgress()}
,isc.A.setTotalRecords=function isc_AISortProgressDialog_setTotalRecords(_1){this.totalRecords=_1;this.updateProgress()}
,isc.A.isWaitingOnField=function isc_AISortProgressDialog_isWaitingOnField(_1){return this.isVisible()&&this.fieldName==_1}
,isc.A.deploy=function isc_AISortProgressDialog_deploy(_1,_2,_3){var _4=this.creator;if(this.isVisible()||this.callback){this.logWarn("The AI sort progress dialog for field "+_2+" of  component "+_4.getID()+" is still running; not cannot redeploy");return}
this.currentRecords=0;this.totalRecords=_1;this.fieldName=_2;this.callback=_3;this.show()}
);isc.B._maxIndex=isc.C+9;isc.ClassFactory.defineClass("AIAssistItem","TextItem");isc.A=isc.AIAssistItem.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.width="*";isc.A.colSpan="*";isc.A.hint=isc.AI.assistantHint;isc.A.showHint=true;isc.A.showHintInField=true;isc.A.prompt=isc.AI.assistantBlurb;isc.A.hoverAutoFitWidth=true;isc.A.hoverAutoFitMaxWidth=400;isc.A.icons=[{inline:true,src:"[SKINIMG]actions/help.png",click:function(_1,_2,_3){_2.sendPrompt(_1,_2)}
}
];isc.B.push(isc.A.keyPress=function isc_AIAssistItem_keyPress(_1,_2,_3,_4){if(_3=="Enter"){_1.sendPrompt(_2,_1);return false}
}
,isc.A.sendPrompt=function isc_AIAssistItem_sendPrompt(_1,_2){var _3=_2.getValue();isc.AI.useAssistant(_3,{rootCanvas:_2.rootCanvas})}
);isc.B._maxIndex=isc.C+2;isc._nonDebugModules=(isc._nonDebugModules!=null?isc._nonDebugModules:[]);isc._nonDebugModules.push('AI');isc.checkForDebugAndNonDebugModules();isc._moduleEnd=isc._AI_end=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc.Log&&isc.Log.logIsInfoEnabled('loadTime'))isc.Log.logInfo('AI module init time: '+(isc._moduleEnd-isc._moduleStart)+'ms','loadTime');delete isc.definingFramework;if(isc.Page)isc.Page.handleEvent(null,"moduleLoaded",{moduleName:'AI',loadTime:(isc._moduleEnd-isc._moduleStart)});}else{if(window.isc&&isc.Log&&isc.Log.logWarn)isc.Log.logWarn("Duplicate load of module 'AI'.");}/** AIModule End **/

