/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.ByScLocator;
import com.isomorphic.webdriver.SeleneseTestCaseParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SeleneseTestCase {
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S");
    public static final String CDATA_ELEMENTS = String.join((CharSequence)" ", new String[0]);
    private String filename;
    private String testName;
    private int failureCount;
    private List<CommandContext> contexts = new ArrayList<CommandContext>();
    private PrintStream originalOutput;
    private Date startTime;

    public SeleneseTestCase(String testFile, String testName) {
        this.filename = testFile;
        this.testName = testName;
        this.startTime = new Date();
    }

    void complete(SeleneseTestCaseParser parser) {
        if (this.contexts.isEmpty()) {
            return;
        }
        this.completeCurrentCommandContext();
        ByScLocator.clearThreadLocalErrorStream();
        parser.setOutputStream(this.originalOutput);
        parser.setErrorStream(System.err);
    }

    private CommandContext getCurrentCommandContext() {
        return this.contexts.get(this.contexts.size() - 1);
    }

    private void completeCurrentCommandContext() {
        CommandContext context = this.getCurrentCommandContext();
        if (context.failureCount > 0) {
            ++this.failureCount;
        }
        context.complete();
    }

    void resetCurrentCommandOutput() {
        if (!this.contexts.isEmpty()) {
            this.getCurrentCommandContext().reset();
        }
    }

    void commandFailure() {
        if (!this.contexts.isEmpty()) {
            ++this.getCurrentCommandContext().failureCount;
        }
    }

    void nextCommand(SeleneseTestCaseParser parser) {
        if (!this.contexts.isEmpty()) {
            this.completeCurrentCommandContext();
        } else {
            this.originalOutput = parser.getOutputStream();
        }
        CommandContext context = new CommandContext();
        this.contexts.add(context);
        PrintStream stream = context.printStream;
        ByScLocator.setThreadLocalErrorStream(stream);
        parser.setOutputStream(stream);
        parser.setErrorStream(stream);
    }

    private String formatTextForNode(String text) {
        if (!text.matches("(?s).*[\n\r].*")) {
            return text;
        }
        if (!text.startsWith("\n")) {
            text = "\n" + text;
        }
        text = text.replaceAll("[\n\r]+$", "");
        return text;
    }

    Element getXMLElement(Document doc) {
        Element testCase = doc.createElement("testcase");
        Attr testName = doc.createAttribute("name");
        testName.setValue(this.testName);
        testCase.setAttributeNode(testName);
        Attr startTime = doc.createAttribute("time");
        startTime.setValue(simpleDateFormat.format(this.startTime));
        testCase.setAttributeNode(startTime);
        Attr status = doc.createAttribute("status");
        status.setValue(this.hasErrors() || this.hasFailures() ? "failure" : "success");
        testCase.setAttributeNode(status);
        Element systemOut = doc.createElement("system-out");
        testCase.appendChild(systemOut);
        String outputText = this.formatTextForNode(this.getOutput());
        Text systemOutText = doc.createTextNode(outputText);
        systemOut.appendChild(systemOutText);
        for (String failureText : this.getFailures()) {
            failureText = this.formatTextForNode(failureText);
            Element failure = doc.createElement("failure");
            testCase.appendChild(failure);
            Text textNode = doc.createTextNode(failureText);
            failure.appendChild(textNode);
        }
        return testCase;
    }

    public String getTestFile() {
        return this.filename;
    }

    public String getTestName() {
        return this.testName;
    }

    public int getCurrentCommandIndex() {
        return this.contexts.size();
    }

    public boolean hasFailures() {
        return this.failureCount > 0;
    }

    public List<String> getFailures() {
        ArrayList<String> failures = new ArrayList<String>();
        for (CommandContext context : this.contexts) {
            if (context.failureCount == 0) continue;
            failures.add(context.commandOutput);
        }
        return failures;
    }

    public boolean hasErrors() {
        return false;
    }

    public List<String> getErrors() {
        return new ArrayList<String>();
    }

    public String getOutput() {
        StringBuffer buffer = new StringBuffer();
        for (CommandContext context : this.contexts) {
            buffer.append(context.commandOutput);
        }
        return buffer.toString();
    }

    public File getScreenshotFile() throws IOException {
        return File.createTempFile(this.testName + ".", ".r" + this.contexts.size() + ".png");
    }

    static class CommandContext {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(this.bytesOut, true);
        String commandOutput;
        int failureCount;

        void complete() {
            try {
                this.printStream.flush();
                this.commandOutput = this.bytesOut.toString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("!!! Unable to report command output" + e.getMessage());
            }
        }

        void reset() {
            this.bytesOut.reset();
        }
    }
}

