/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.Closeable;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.operations.FileOperations;

public interface FileObject
extends Comparable<FileObject>,
Iterable<FileObject>,
Closeable {
    public boolean canRenameTo(FileObject var1);

    @Override
    public void close() throws FileSystemException;

    public void copyFrom(FileObject var1, FileSelector var2) throws FileSystemException;

    public void createFile() throws FileSystemException;

    public void createFolder() throws FileSystemException;

    public boolean delete() throws FileSystemException;

    public int delete(FileSelector var1) throws FileSystemException;

    public int deleteAll() throws FileSystemException;

    public boolean exists() throws FileSystemException;

    public FileObject[] findFiles(FileSelector var1) throws FileSystemException;

    public void findFiles(FileSelector var1, boolean var2, List<FileObject> var3) throws FileSystemException;

    public FileObject getChild(String var1) throws FileSystemException;

    public FileObject[] getChildren() throws FileSystemException;

    public FileContent getContent() throws FileSystemException;

    public FileOperations getFileOperations() throws FileSystemException;

    public FileSystem getFileSystem();

    public FileName getName();

    public FileObject getParent() throws FileSystemException;

    public String getPublicURIString();

    public FileType getType() throws FileSystemException;

    default public URI getURI() {
        return URI.create(this.getName().getURI());
    }

    default public Path getPath() {
        return Paths.get(this.getURI());
    }

    public URL getURL() throws FileSystemException;

    public boolean isAttached();

    public boolean isContentOpen();

    public boolean isExecutable() throws FileSystemException;

    public boolean isFile() throws FileSystemException;

    public boolean isFolder() throws FileSystemException;

    public boolean isHidden() throws FileSystemException;

    public boolean isReadable() throws FileSystemException;

    default public boolean isSymbolicLink() throws FileSystemException {
        return false;
    }

    public boolean isWriteable() throws FileSystemException;

    public void moveTo(FileObject var1) throws FileSystemException;

    public void refresh() throws FileSystemException;

    public FileObject resolveFile(String var1) throws FileSystemException;

    public FileObject resolveFile(String var1, NameScope var2) throws FileSystemException;

    public boolean setExecutable(boolean var1, boolean var2) throws FileSystemException;

    public boolean setReadable(boolean var1, boolean var2) throws FileSystemException;

    public boolean setWritable(boolean var1, boolean var2) throws FileSystemException;
}

