/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.interfaces.ICDIBeanManager;
import com.isomorphic.interfaces.ISpringBeanFactory;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.jxpath.JXPathContext;

public class ServerObject {
    private static Logger log = new Logger(ServerObject.class.getName());
    private static Config config = Config.getGlobal();
    Map serverObjectConfig;
    RequestContext context;
    String contextString;
    ReflectionArgument[] factoryOptionalArgs;
    String lookupStyle;
    Class serverObjectClass;
    Object serverObjectInstance;
    Method method;

    public ServerObject(Map serverObjectConfig, RequestContext context, String contextString) throws Exception {
        this(serverObjectConfig, context, null, contextString);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerObject(Map serverObjectConfig, RequestContext context, ReflectionArgument[] factoryOptionalArgs, String contextString) throws Exception {
        block33: {
            String xpath;
            block35: {
                boolean lookupStyleDeclared;
                block34: {
                    this.serverObjectConfig = serverObjectConfig;
                    this.context = context;
                    this.factoryOptionalArgs = factoryOptionalArgs;
                    this.contextString = contextString;
                    this.lookupStyle = (String)serverObjectConfig.get("lookupStyle");
                    boolean bl = lookupStyleDeclared = this.lookupStyle != null;
                    if (!lookupStyleDeclared) {
                        this.lookupStyle = "new";
                    }
                    Object serverObjectConfigInstance = null;
                    if (!"factory".equals(this.lookupStyle)) break block34;
                    String className = (String)serverObjectConfig.get("className");
                    if (className == null) {
                        String string;
                        StringBuilder stringBuilder = new StringBuilder().append("No className specified in serverConfig with ");
                        if (lookupStyleDeclared) {
                            string = "declared";
                            throw new Exception(stringBuilder.append(string).append(" lookupStyle=\"factory\" used by ").append(contextString).toString());
                        }
                        string = "implied";
                        throw new Exception(stringBuilder.append(string).append(" lookupStyle=\"factory\" used by ").append(contextString).toString());
                    }
                    Class factoryClass = null;
                    try {
                        factoryClass = Reflection.classForName(className);
                    }
                    catch (Exception e) {
                        throw new Exception("Failed to lookup class by name: " + className + " specified in serverConfig used by " + contextString + " -  Exception string: " + e.toString());
                    }
                    Object factory = Reflection.newInstance(factoryClass);
                    Method factoryMethod = ServerObject.findMethod(factoryClass, "create");
                    HttpSession session = null;
                    if (Reflection.methodTakesArgType(factoryMethod, HttpSession.class)) {
                        session = context.request.getSession(true);
                    }
                    ArrayList<ReflectionArgument> optionalArgsList = new ArrayList<ReflectionArgument>();
                    if (factoryOptionalArgs != null) {
                        for (int count2 = 0; count2 < factoryOptionalArgs.length; ++count2) {
                            optionalArgsList.add(factoryOptionalArgs[count2]);
                        }
                    }
                    optionalArgsList.add(new ReflectionArgument(RequestContext.class, (Object)context, false, false));
                    if (context != null) {
                        optionalArgsList.add(new ReflectionArgument(HttpServletRequest.class, (Object)context.request, false, false));
                        optionalArgsList.add(new ReflectionArgument(HttpServletResponse.class, (Object)context.response, false, false));
                        optionalArgsList.add(new ReflectionArgument(ServletContext.class, (Object)context.servletContext, false, false));
                    }
                    optionalArgsList.add(new ReflectionArgument(HttpSession.class, (Object)session, false, false));
                    optionalArgsList.add(new ReflectionArgument(serverObjectConfig.getClass(), (Object)serverObjectConfig, false, false));
                    ReflectionArgument[] optionalArgs = optionalArgsList.toArray(new ReflectionArgument[0]);
                    this.serverObjectInstance = Reflection.adaptArgsAndInvoke(factory, factoryMethod, null, optionalArgs);
                    String xpath2 = (String)serverObjectConfig.get("targetXPath");
                    if (xpath2 != null && !xpath2.equals("")) {
                        JXPathContext jxpc = JXPathContext.newContext((Object)this.serverObjectInstance);
                        this.serverObjectInstance = jxpc.getValue(xpath2);
                        this.serverObjectClass = this.serverObjectInstance.getClass();
                    }
                    break block33;
                }
                if ("new".equals(this.lookupStyle)) {
                    String className = (String)serverObjectConfig.get("className");
                    if (className == null) {
                        String string;
                        StringBuilder stringBuilder = new StringBuilder().append("No className specified in serverConfig with ");
                        if (lookupStyleDeclared) {
                            string = "declared";
                            throw new Exception(stringBuilder.append(string).append(" lookupStyle=\"new\" used by ").append(contextString).toString());
                        }
                        string = "implied";
                        throw new Exception(stringBuilder.append(string).append(" lookupStyle=\"new\" used by ").append(contextString).toString());
                    }
                    try {
                        this.serverObjectClass = Reflection.classForName(className);
                        String xpath3 = (String)serverObjectConfig.get("targetXPath");
                        if (xpath3 == null || xpath3.equals("")) break block33;
                        try {
                            JXPathContext jxpc = JXPathContext.newContext(this.serverObjectClass.newInstance());
                            this.serverObjectInstance = jxpc.getValue(xpath3);
                            this.serverObjectClass = this.serverObjectInstance.getClass();
                            break block33;
                        }
                        catch (InstantiationException ie) {
                            throw new Exception("Could not create an instance of " + className + " whilst attempting to process targetXPath " + xpath3 + " used by " + contextString + " - Exception string: " + ie.toString());
                        }
                    }
                    catch (Exception e) {
                        throw new Exception("Failed to lookup class by name: " + className + " specified in serverConfig used by " + contextString + " -  Exception string: " + e.toString());
                    }
                }
                if ("attribute".equals(this.lookupStyle)) break block35;
                if ("spring".equals(this.lookupStyle)) {
                    String bean = (String)serverObjectConfig.get("bean");
                    log.info("DMI on Spring bean: " + bean);
                    if (bean == null) {
                        throw new Exception("No 'bean' property specified in serverConfig used by " + contextString);
                    }
                    if (context != null && context.servletContext == null) {
                        log.warn("RequestContext is missing the ServletContext. Please ensure you provide either a PageContext, a Servlet, or a ServletContext to your RequestContext.instance() call.");
                    }
                    ISpringBeanFactory beanFactory = (ISpringBeanFactory)InterfaceProvider.load("ISpringBeanFactory");
                    this.serverObjectInstance = beanFactory.getBean(context != null ? context.servletContext : null, bean);
                    String xpath4 = (String)serverObjectConfig.get("targetXPath");
                    if (xpath4 != null && !xpath4.equals("") && this.serverObjectInstance != null) {
                        JXPathContext jxpc = JXPathContext.newContext((Object)this.serverObjectInstance);
                        this.serverObjectInstance = jxpc.getValue(xpath4);
                        this.serverObjectClass = this.serverObjectInstance.getClass();
                    }
                    break block33;
                } else {
                    if (!"cdi".equalsIgnoreCase(this.lookupStyle)) throw new Exception("Unknown lookupStyle: " + this.lookupStyle + " in serverObjectConfig used by " + contextString);
                    String beanName = (String)serverObjectConfig.get("bean");
                    String beanClassName = (String)serverObjectConfig.get("className");
                    Class<?> beanClass = null;
                    if (beanName == null && beanClassName == null) {
                        throw new Exception("No 'className' or 'bean' property specified in serverConfig used by " + contextString);
                    }
                    log.info("DMI on CDI bean: " + (beanName != null ? beanName : beanClassName));
                    if (beanName == null) {
                        beanClass = Class.forName(beanClassName);
                    }
                    ICDIBeanManager beanManager = (ICDIBeanManager)InterfaceProvider.load("ICDIBeanManager");
                    this.serverObjectInstance = beanName != null ? beanManager.getBean(beanName) : beanManager.getBean(beanClass);
                    String xpath5 = (String)serverObjectConfig.get("targetXPath");
                    if (xpath5 != null && !xpath5.equals("") && this.serverObjectInstance != null) {
                        JXPathContext jxpc = JXPathContext.newContext((Object)this.serverObjectInstance);
                        this.serverObjectInstance = jxpc.getValue(xpath5);
                        this.serverObjectClass = this.serverObjectInstance.getClass();
                    }
                }
                break block33;
            }
            String attributeName = (String)serverObjectConfig.get("attributeName");
            if (attributeName == null) {
                throw new Exception("No attributeName specified in serverConfig with lookupStyle=\"attribute\" used by " + contextString);
            }
            String attributeScope = (String)serverObjectConfig.get("attributeScope");
            List<String> scopesToTry = attributeScope != null ? DataTools.buildList(attributeScope) : DataTools.buildList("request", "session", "application");
            for (String scope : scopesToTry) {
                if ("request".equals(scope)) {
                    this.serverObjectInstance = context.request.getAttribute(attributeName);
                } else if ("session".equals(scope)) {
                    this.serverObjectInstance = context.request.getSession(true).getAttribute(attributeName);
                } else {
                    if (!"application".equals(scope)) throw new Exception("Unknown attributeScope: " + scope + " in serverObject used by " + contextString + " with lookupStyle=\"attribute\"");
                    this.serverObjectInstance = context.servletContext.getAttribute(attributeName);
                }
                if (this.serverObjectInstance == null) continue;
            }
            if ((xpath = (String)serverObjectConfig.get("targetXPath")) != null && !xpath.equals("") && this.serverObjectInstance != null) {
                JXPathContext jxpc = JXPathContext.newContext((Object)this.serverObjectInstance);
                this.serverObjectInstance = jxpc.getValue(xpath);
                this.serverObjectClass = this.serverObjectInstance.getClass();
            }
            if (this.serverObjectInstance == null) {
                throw new Exception("Couldn't find serverObject instance via attribute lookup(attribute=\"" + attributeName + "\") - scopes tried: " + scopesToTry.toString() + " in " + contextString);
            }
        }
        if (this.serverObjectClass != null) return;
        this.serverObjectClass = this.serverObjectInstance.getClass();
    }

    public Class _getClass() throws Exception {
        return this.serverObjectClass;
    }

    public Object getInstance() throws Exception {
        return this.getInstance(null);
    }

    public Object getInstance(Method method) throws Exception {
        if (!(this.serverObjectInstance != null || method != null && Modifier.isStatic(method.getModifiers()))) {
            this.serverObjectInstance = Reflection.newInstance(this.serverObjectClass);
        }
        return this.serverObjectInstance;
    }

    public Method getMethod(String methodName) throws Exception {
        if (this.method == null) {
            this.method = ServerObject.findMethod(this.serverObjectClass, methodName);
        }
        return this.method;
    }

    public Map getConfig() {
        return this.serverObjectConfig;
    }

    public static Method findMethod(Class serverObjectClass, String methodName) throws Exception {
        Method[] methods = serverObjectClass.getMethods();
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!methodName.equals(method.getName()) || method.isSynthetic()) continue;
            candidateMethods.add(method);
        }
        if (candidateMethods.size() == 0) {
            log.debug("Couldn't find a public method named: " + methodName + " on class: " + serverObjectClass.getName());
            return null;
        }
        if (candidateMethods.size() > 1) {
            throw new Exception("Class " + serverObjectClass.getName() + " defines multiple methods named: " + methodName + " - overloading is not supported - please disambiguate.");
        }
        return (Method)candidateMethods.get(0);
    }
}

