import React from 'react';
import { ILogicalComponent } from './core/ILogicalComponent';
import { AsComponentXML } from './core/ReactComponent';


declare interface HiliteViaAISettingsProps {

/**
 * See {@link isc.HiliteViaAISettings.showProgressDialog HiliteViaAISettings.showProgressDialog}.
 */
showProgressDialog?: boolean;

/**
 * See {@link isc.HiliteViaAISettings.progressDialogProperties HiliteViaAISettings.progressDialogProperties}.
 */
progressDialogProperties?: HiliteViaAIProgressDialog;


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * HiliteViaAISettings wraps the SmartClient object
 * {@link isc.HiliteViaAISettings HiliteViaAISettings} for React, allowing you to import
 * HiliteViaAISettings for use in React JS and JSX.
 * @class
 */
declare class HiliteViaAISettings extends ILogicalComponent {
    props: AsComponentXML<HiliteViaAISettingsProps>;
}
