/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.datasource.BaseRequestHandler;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DefaultRequestHandler;
import com.isomorphic.datasource.PartialCommitException;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BaseRequest;
import com.isomorphic.rpc.BaseResponse;
import com.isomorphic.rpc.QueueAlreadyStartedException;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DSTransaction {
    public static Logger log = new Logger(DSTransaction.class);
    private LinkedHashMap<BaseRequest, BaseResponse> responses = new LinkedHashMap();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private int transactionPolicy = Config.getGlobal().getInt("RPCManager.transactionPolicy", 0);
    private boolean skipRemainingQueue;
    private final BaseRequestHandler<? extends BaseRequest> requestHandler;
    private final Map<Object, Object> templateContext = new HashMap<Object, Object>();
    private boolean requestProcessingStarted;
    private Boolean authenticated;
    private List<String> userRoles;
    private String userId;
    private String tenantId;
    private Boolean clientRequest;
    private Set<String> snippets = new HashSet<String>();
    private boolean usingSpringTransaction = false;
    private boolean inComplete = false;
    private List<String> completedList;
    private boolean inCommitSession = false;
    private Set<String> committedInThisSession = new HashSet<String>();
    Map scriptContext = new HashMap();
    private List<DataSource> dataSourcesToFree = new ArrayList<DataSource>();

    public Set<String> getSnippetNames() {
        return this.snippets;
    }

    public DSTransaction() {
        this(new DefaultRequestHandler());
    }

    public DSTransaction(BaseRequestHandler<? extends BaseRequest> requestHandler) {
        this.requestHandler = requestHandler;
    }

    public boolean queueHasFailures() {
        for (Map.Entry<BaseRequest, BaseResponse> entry : this.responses.entrySet()) {
            BaseResponse baseResponse = entry.getValue();
            if (baseResponse == null || baseResponse.getStatus() >= 0) continue;
            return true;
        }
        return false;
    }

    public void setUsingSpringTransaction(boolean b) {
        log.warn("Setting 'usingSpringTransaction' " + b + " for DSTransaction " + this.hashCode());
        this.usingSpringTransaction = b;
    }

    public boolean isUsingSpringTransaction() {
        return this.usingSpringTransaction;
    }

    public void skipRemainingQueue() {
        log.debug("Setting skipRemainingQueue to true");
        this.skipRemainingQueue = true;
    }

    public boolean isSkipRemainingQueue() {
        return this.skipRemainingQueue;
    }

    public void registerRequest(BaseRequest request) {
        this.responses.put(request, null);
    }

    public void registerResponse(BaseRequest request, BaseResponse response) {
        this.responses.put(request, response);
    }

    public Set<BaseRequest> getRequests() {
        return this.responses.keySet();
    }

    public void commit() throws Exception {
        this.startCommitSession();
        for (Map.Entry<BaseRequest, BaseResponse> entry : this.responses.entrySet()) {
            entry.getKey().commit(this);
        }
        this.endCommitSession();
    }

    public void rollback() throws Exception {
        for (Map.Entry<BaseRequest, BaseResponse> entry : this.responses.entrySet()) {
            entry.getKey().rollback(this);
        }
    }

    public <T> T getAttribute(String attributeKey) {
        Object attribute = this.attributes.get(attributeKey);
        if (attribute != null) {
            return (T)attribute;
        }
        return null;
    }

    public void setAttribute(String attributeKey, Object attributeValue) {
        this.attributes.put(attributeKey, attributeValue);
    }

    public void removeAttribute(String attributeKey) {
        this.attributes.remove(attributeKey);
    }

    public int getTransactionPolicy() {
        return this.transactionPolicy;
    }

    public void setTransactionPolicy(int transactionPolicy) throws QueueAlreadyStartedException {
        if (this.requestProcessingStarted) {
            throw new QueueAlreadyStartedException("Queue processing has started; transaction policy cannot be changed");
        }
        this.transactionPolicy = transactionPolicy;
    }

    public boolean requestQueueIncludesUpdates() {
        return this.requestQueueIncludesPriorUpdate(null);
    }

    public boolean requestQueueIncludesPriorUpdate(DSRequest dsRequest) {
        try {
            if (dsRequest != null && dsRequest.getDataSource().isModificationRequest(dsRequest)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Map.Entry<BaseRequest, BaseResponse> entry : this.responses.entrySet()) {
            BaseRequest baseRequest = entry.getKey();
            if (baseRequest.equals(dsRequest)) {
                return false;
            }
            if (!(baseRequest instanceof DSRequest)) continue;
            DSRequest dsRequestOnTransaction = (DSRequest)baseRequest;
            try {
                if (!dsRequestOnTransaction.getDataSource().isModificationRequest(dsRequestOnTransaction)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public void complete() {
        this.complete(true);
    }

    public void complete(boolean freeResources) {
        try {
            this.inComplete = true;
            if (this.queueHasFailures()) {
                this.onFailure(null);
            } else {
                this.onSuccess();
            }
        }
        catch (PartialCommitException partialCommitException) {
        }
        catch (Exception e) {
            log.warn(DataTools.getStackTrace(Reflection.getRealTargetException(e)));
        }
        finally {
            this.inComplete = false;
            if (freeResources) {
                this.freeQueueResources();
            }
        }
    }

    public boolean isCompleting() {
        return this.inComplete;
    }

    public void addToCompletedList(String dbName) {
        if (this.inComplete) {
            if (this.completedList == null) {
                this.completedList = new ArrayList<String>();
            }
            if (!this.completedList.contains(dbName)) {
                this.completedList.add(dbName);
            }
        }
    }

    public boolean isCompleted(String dbName) {
        return this.inComplete && this.completedList != null && this.completedList.contains(dbName);
    }

    public void startCommitSession() {
        this.inCommitSession = true;
        this.committedInThisSession.clear();
    }

    public void endCommitSession() {
        this.inCommitSession = false;
        this.committedInThisSession.clear();
    }

    public void setCommitted(String dbName) {
        this.committedInThisSession.add(dbName);
    }

    public boolean isCommitted(String dbName) {
        return this.inCommitSession && this.committedInThisSession.contains(dbName);
    }

    public void freeQueueResources() {
        for (Map.Entry<BaseRequest, BaseResponse> entry : this.responses.entrySet()) {
            BaseRequest baseRequest = entry.getKey();
            if (!baseRequest.shouldFreeOnExecute()) {
                baseRequest.freeResources();
            }
            baseRequest.freeQueueResources();
        }
    }

    public void freeAllResources() {
        for (Map.Entry<BaseRequest, BaseResponse> entry : this.responses.entrySet()) {
            BaseRequest baseRequest = entry.getKey();
            baseRequest.freeAllResources();
        }
    }

    public void onSuccess() throws Exception {
        for (Map.Entry<BaseRequest, BaseResponse> entry : this.responses.entrySet()) {
            DSResponse dsResponse;
            BaseRequest baseRequest = entry.getKey();
            if (!(baseRequest instanceof DSRequest) || (dsResponse = (DSResponse)this.getResponse(baseRequest)) == null) continue;
            dsResponse.setProperty("queueStatus", 0);
        }
        ArrayList<String> partialCommitMessages = new ArrayList<String>();
        for (Map.Entry<BaseRequest, BaseResponse> entry : this.responses.entrySet()) {
            BaseRequest baseRequest = entry.getKey();
            try {
                baseRequest.commit(this);
            }
            catch (Exception e) {
                String warning = "Exception thrown during onSuccess processing in class " + baseRequest.getClass().getName();
                if (baseRequest instanceof DSRequest) {
                    DSRequest dsRequest = (DSRequest)baseRequest;
                    warning = warning + " (DataSource " + dsRequest.getDataSource().getName() + ") - changes might not have been committed";
                    partialCommitMessages.add("DataSource " + dsRequest.getDataSource().getName());
                    log.warn((Object)warning, e);
                    try {
                        this.onFailure(dsRequest.getDataSource());
                    }
                    catch (Exception e2) {
                        log.warn((Object)"Exception thrown during onFailure processing invoked to handle a failure detected during onSuccess", e2);
                    }
                    continue;
                }
                partialCommitMessages.add(baseRequest.getClass().getName());
                log.warn((Object)warning, e);
            }
        }
        if (partialCommitMessages.size() > 0) {
            throw new PartialCommitException("Some callbacks failed during onSuccess processing - changes might not have been committed.  Failing classes: " + ((Object)partialCommitMessages).toString());
        }
    }

    public void onFailure() throws Exception {
        this.onFailure(null);
    }

    public void onFailure(DataSource testDS) throws Exception {
        BaseRequest baseRequest;
        boolean transactionalFailure = this.isTransactionalFailure(testDS);
        for (Map.Entry<BaseRequest, BaseResponse> entry : this.responses.entrySet()) {
            Object trxObj2;
            Object trxObj1;
            baseRequest = entry.getKey();
            if (!(baseRequest instanceof DSRequest)) continue;
            DSResponse dsResponse = (DSResponse)this.getResponse(baseRequest);
            if (dsResponse == null) {
                dsResponse = new DSResponse();
                this.registerResponse(baseRequest, dsResponse);
            }
            dsResponse.setProperty("queueStatus", -1);
            if (!transactionalFailure) continue;
            DSRequest dsRequest = (DSRequest)baseRequest;
            if (testDS != null && testDS instanceof BasicDataSource && dsRequest.getDataSource() instanceof BasicDataSource && (trxObj1 = testDS.getTransactionObject(dsRequest)) != (trxObj2 = dsRequest.getDataSource().getTransactionObject(dsRequest)) || !dsRequest.isPartOfTransaction() || dsResponse.getStatus() != 0) continue;
            dsResponse.setStatus(-10);
        }
        for (Map.Entry<BaseRequest, BaseResponse> entry : this.responses.entrySet()) {
            baseRequest = entry.getKey();
            if (testDS != null && baseRequest instanceof DSRequest && !((DSRequest)baseRequest).getDataSource().getName().equals(testDS.getName())) continue;
            try {
                if (transactionalFailure) {
                    baseRequest.rollback(this);
                    continue;
                }
                baseRequest.commit(this);
            }
            catch (Exception e) {
                if (testDS == null) {
                    log.warn((Object)"Exception thrown during onFailure processing", e);
                    continue;
                }
                throw e;
            }
        }
    }

    public <T extends BaseResponse> T getResponse(BaseRequest baseRequest) {
        try {
            return (T)this.responses.get(baseRequest);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isTransactionalFailure(DataSource testDS) throws Exception {
        for (Map.Entry<BaseRequest, BaseResponse> entry : this.responses.entrySet()) {
            BaseRequest baseRequest = entry.getKey();
            if (!(baseRequest instanceof DSRequest)) continue;
            DSRequest dsRequest = (DSRequest)baseRequest;
            BasicDataSource basicDataSource = (BasicDataSource)dsRequest.getDataSource();
            if (testDS != null && basicDataSource != null && !basicDataSource.getName().equals(testDS.getName())) continue;
            DSResponse dsResponse = (DSResponse)this.getResponse(baseRequest);
            if (testDS == null && (dsResponse == null || dsResponse.getStatus() >= 0)) continue;
            if (dsRequest.isPartOfTransaction()) {
                return true;
            }
            if (dsRequest.isPartOfTransactionKnown() || basicDataSource == null || !basicDataSource.shouldAutoJoinTransaction(dsRequest) || !basicDataSource.shouldAutoStartTransaction(dsRequest, true) && !this.requestQueueIncludesPriorUpdate(dsRequest)) continue;
            return true;
        }
        return false;
    }

    public Map<BaseRequest, BaseResponse> processQueue() {
        return this.processQueue(this.requestHandler);
    }

    public Map<BaseRequest, BaseResponse> processQueue(BaseRequestHandler requestHandler) {
        assert (requestHandler != null) : "RequestHandler can not be null.";
        for (Map.Entry<BaseRequest, BaseResponse> entry : new LinkedHashMap<BaseRequest, BaseResponse>(this.responses).entrySet()) {
            this.registerResponse(entry.getKey(), requestHandler.handleRequest(entry.getKey()));
        }
        return new LinkedHashMap<BaseRequest, BaseResponse>(this.responses);
    }

    public void applyEarlierResponseValues(DSRequest dsRequest) throws Exception {
        String fieldName;
        Map map;
        String opId;
        DataSource dataSource = dsRequest.getDataSource();
        if (dataSource == null) {
            return;
        }
        String opType = dsRequest.getOperationType();
        DataTypeMap opBinding = dataSource.getOperationBinding(opType, opId = dsRequest.getOperationId());
        if (opBinding == null) {
            return;
        }
        Object criteriaObj = opBinding.get("criteria");
        Object valuesObj = opBinding.get("values");
        if (criteriaObj == null && valuesObj == null) {
            return;
        }
        Map<Object, Object> params = Velocity.getStandardContextMap(dsRequest);
        if (criteriaObj != null) {
            ArrayList criterias;
            if (criteriaObj instanceof List) {
                criterias = (ArrayList)criteriaObj;
            } else {
                criterias = new ArrayList();
                criterias.add(criteriaObj);
            }
            for (Object aCriteria : criterias) {
                map = (Map)aCriteria;
                if (AdvancedCriteria.isAdvancedCriteria(map, dataSource)) {
                    Map normalized = dsRequest.getDataSource().normalizeAdvancedCriteria(map);
                    Map evaluatedMap = this.resolveTemplateValuesInAdvancedCriteria(normalized, params, dsRequest);
                    log.debug("About to add advancedCriteria to criteria: " + DataTools.prettyPrint(evaluatedMap));
                    dsRequest.addToCriteria(AdvancedCriteria.fromCollections(evaluatedMap));
                    continue;
                }
                fieldName = (String)map.get("fieldName");
                if (fieldName == null) {
                    log.warn("DataSource " + dataSource.getID() + ", operation " + opId + ": Found a <criteria> definition that does not specify a fieldName");
                    continue;
                }
                String operator = (String)map.get("operator");
                Map evaluated = map;
                try {
                    evaluated = this.resolveTemplateValuesInCriteria(map, params, dsRequest);
                }
                catch (UnlicensedException ue) {
                    log.warn("DataSource '" + dataSource.getID() + "', operationType '" + opType + "', operationId: '" + opId + "': <criteria> tag for field '" + fieldName + "' refers to $responseData, which is only available as part of the Transaction Chaining feature of Power and EE, but you have a Pro license.  See http://smartclient.com/licensing");
                }
                catch (InvalidCriteriaException ice) {
                    log.warn("DataSource " + dataSource.getID() + ", operation " + opId + ": Found a <criteria> definition for field '" + fieldName + "', operator '" + operator + "' that does not specify value, start or end - skipping");
                    continue;
                }
                log.debug("About to add to criteria: " + fieldName + " " + operator + " " + evaluated.get("value"));
                if (operator == null || operator.equals("equals")) {
                    dsRequest.addToCriteria(fieldName, evaluated.get("value"));
                    continue;
                }
                dsRequest.addToCriteria(fieldName, operator, evaluated.get("value"), evaluated.get("start"), evaluated.get("end"));
            }
        }
        if (valuesObj != null) {
            ArrayList values;
            if (valuesObj instanceof List) {
                values = (ArrayList)valuesObj;
            } else {
                values = new ArrayList();
                values.add(valuesObj);
            }
            for (Object valueObject : values) {
                String value;
                map = (Map)valueObject;
                fieldName = (String)map.get("fieldName");
                Velocity.setMasterIdHandler(params, dsRequest, fieldName);
                Object valueObj = map.get("value");
                String string = value = valueObj instanceof String ? (String)valueObj : null;
                if (fieldName == null || value == null) continue;
                Object evaluation = valueObj;
                if (valueObj instanceof String) {
                    evaluation = Velocity.evaluate(value, params, "transactionChainingValue", null, false, true);
                }
                dsRequest.getValues().put(fieldName, evaluation);
            }
        }
    }

    private Map resolveTemplateValuesInAdvancedCriteria(Map criteria, Map context, DSRequest dsRequest) throws Exception {
        if (criteria.containsKey("criteria")) {
            HashMap resolved = new HashMap(criteria);
            List subCriteria = (List)criteria.get("criteria");
            ArrayList<Map> evaluatedSubCriteria = new ArrayList<Map>();
            for (int i = 0; i < subCriteria.size(); ++i) {
                Map subCriterion = (Map)subCriteria.get(i);
                Map evaluatedSubCriterion = this.resolveTemplateValuesInAdvancedCriteria(subCriterion, context, dsRequest);
                if (evaluatedSubCriterion == null) continue;
                evaluatedSubCriteria.add(evaluatedSubCriterion);
            }
            resolved.put("criteria", evaluatedSubCriteria);
            return resolved;
        }
        String fieldName = (String)criteria.get("fieldName");
        if (fieldName == null) {
            log.warn("DataSource " + dsRequest.getDataSourceName() + ", operation " + dsRequest.getOperationId() + ": Found a <criterion> definition that does not specify a fieldName - skipping");
            return null;
        }
        try {
            return this.resolveTemplateValuesInCriteria(criteria, context, dsRequest);
        }
        catch (UnlicensedException ue) {
            log.warn("DataSource '" + dsRequest.getDataSourceName() + "', operationType '" + dsRequest.getOperationType() + "', operationId: '" + dsRequest.getOperationId() + "': <criterion> tag for field '" + criteria.get("fieldName") + "' refers to $responseData, which is only available as part of the Transaction Chaining feature of Power and EE, but you have a Pro license.  See http://smartclient.com/licensing");
            return null;
        }
        catch (InvalidCriteriaException ice) {
            log.warn("DataSource " + dsRequest.getDataSourceName() + ", operation " + dsRequest.getOperationId() + ": Found a <criterion> definition for field '" + criteria.get("fieldName") + "', operator '" + criteria.get("operator") + "' that does not specify value, start or end - skipping");
            return null;
        }
    }

    private Map resolveTemplateValuesInCriteria(Map map, Map context, DSRequest dsRequest) throws UnlicensedException, InvalidCriteriaException, Exception {
        HashMap<String, Object> evaluated = new HashMap<String, Object>(map);
        String fieldName = (String)map.get("fieldName");
        Velocity.setMasterIdHandler(context, dsRequest, fieldName);
        Object valueObj = map.get("value");
        String value = valueObj instanceof String ? (String)valueObj : null;
        String operator = (String)map.get("operator");
        String start = (String)map.get("start");
        String end = (String)map.get("end");
        if (!("isBlank".equals(operator) || "notBlank".equals(operator) || "isNull".equals(operator) || "notNull".equals(operator))) {
            if (valueObj == null && start == null && end == null) {
                throw new InvalidCriteriaException();
            }
            if (value != null) {
                evaluated.put("value", Velocity.evaluate(value, context, "transactionChainingCriteriaValue", null, false, true));
            }
            if (start != null) {
                evaluated.put("start", Velocity.evaluate(start, context, "transactionChainingCriteriaStart", null, false, true));
            }
            if (end != null) {
                evaluated.put("end", Velocity.evaluate(end, context, "transactionChainingCriteriaEnd", null, false, true));
            }
        }
        return evaluated;
    }

    public <T extends BaseResponse> T findResponse(String firstOrLast, String dsName, String opType) {
        int stop;
        int inc;
        int loop;
        BaseRequest thisDSReq = null;
        int index = 0;
        for (Map.Entry<BaseRequest, BaseResponse> entry : this.responses.entrySet()) {
            if (entry.getValue() == null) {
                thisDSReq = entry.getKey();
                if (index != 0) break;
                log.debug("Transaction chaining invoked on first request, ignoring");
                return null;
            }
            ++index;
        }
        LinkedList<BaseRequest> requests = new LinkedList<BaseRequest>(this.responses.keySet());
        if ("first".equals(firstOrLast)) {
            loop = 0;
            inc = 1;
            stop = requests.size();
        } else {
            inc = -1;
            stop = -1;
            for (loop = requests.size() - 1; loop != stop; --loop) {
                DSRequest dsReq = (DSRequest)requests.get(loop);
                if (dsReq != thisDSReq) continue;
                --loop;
                break;
            }
        }
        while (loop != stop) {
            if (requests.get(loop) instanceof DSRequest) {
                DSRequest dsRequest = (DSRequest)requests.get(loop);
                if ((dsName == null || dsName.equals(dsRequest.getDataSourceName())) && (opType == null || opType.equals(dsRequest.getOperationType()))) {
                    T response = this.getResponse(dsRequest);
                    if (response == null) {
                        log.warn("Found null DSResponse mapped to valid-looking DSRequest when searching for " + firstOrLast + " operation on DataSource " + dsName + " with operation type " + opType + ". Maybe requests have been run out of order?");
                        return null;
                    }
                    return response;
                }
            }
            loop += inc;
        }
        log.warn("Could not find a suitable request searching for " + firstOrLast + " operation on DataSource " + dsName + " with operation type " + opType);
        return null;
    }

    public Object findResponseData(String firstOrLast, String dsName, String opType) {
        Object response = this.findResponse(firstOrLast, dsName, opType);
        if (response != null && ((BaseResponse)response).getData() != null) {
            log.debug("Found response for FIRST = " + response + " which has data = " + ((BaseResponse)response).getData());
            return ((BaseResponse)response).getData();
        }
        log.warn("Found null dsResponse.data when searching for " + firstOrLast + " operation on DataSource " + dsName + " with operation type " + opType + ". Looks like the operation does not return anything.");
        return null;
    }

    public <T extends BaseResponse> T findLastResponse(String dsName, String opType) {
        return this.findResponse("last", dsName, opType);
    }

    public <T extends BaseResponse> T findFirstResponse(String dsName, String opType) {
        return this.findResponse("first", dsName, opType);
    }

    public Map<Object, Object> getTemplateContext() {
        return new HashMap<Object, Object>(this.templateContext);
    }

    public <T> T getFromTemplateContext(Object key) {
        return (T)this.templateContext.get(key);
    }

    public void addToTemplateContext(Object key, Object value) {
        this.templateContext.put(key, value);
    }

    public void addToTemplateContext(String name, Object value, boolean isSnippet) {
        this.templateContext.put(name, value);
        if (isSnippet) {
            this.snippets.add(name);
        }
    }

    public void addToScriptContext(String name, Object value) {
        this.scriptContext.put(name, value);
    }

    public Map getScriptContext() {
        return this.scriptContext;
    }

    public void initiateRequestProcessing() throws Exception {
        this.requestProcessingStarted = true;
        Date currentDate = new Date();
        this.addToTemplateContext("currentDate", currentDate);
        if (this.getFromTemplateContext("transactionDate") == null) {
            this.addToTemplateContext("transactionDate", currentDate);
        }
    }

    public DataSource getDataSource(String dsName) throws Exception {
        return this.getDataSource(dsName, null);
    }

    public DataSource getDataSource(String dsName, DSRequest dsRequest) throws Exception {
        return this.getDataSource(dsName, dsRequest, null);
    }

    public DataSource getDataSource(String dsName, DSRequest dsRequest, String tenantId) throws Exception {
        DataSource ds;
        if (dsRequest != null && this.getTenantId() != null) {
            dsRequest.setTenantId(this.getTenantId());
        }
        if ((ds = DataSourceManager.getDataSource(dsName, dsRequest, tenantId)) != null) {
            this.dataSourcesToFree.add(ds);
        }
        return ds;
    }

    public void freeDataSources() throws Exception {
        for (DataSource aDataSourcesToFree : this.dataSourcesToFree) {
            DataSourceManager.free(aDataSourcesToFree);
        }
    }

    public void setUserId(String userId) {
        this.userId = userId;
        this.setAuthenticated(true);
    }

    public String getUserId() {
        if (this.userId != null) {
            return this.userId;
        }
        return null;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void setAuthenticated(Boolean newValue) {
        this.authenticated = newValue;
    }

    public List<String> getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(String rolesString) {
        String roles = rolesString == null ? "" : rolesString;
        List<String> list = DataTools.commaSeparatedStringToList(roles);
        this.setUserRoles(list);
    }

    public void setUserRoles(String ... roles) {
        String[] stringArray;
        if (roles == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = roles;
        }
        String[] rolesString = stringArray;
        List<String> list = Arrays.asList(rolesString);
        this.setUserRoles(list);
    }

    public void setUserRoles(List<String> rolesList) {
        this.userRoles = rolesList;
    }

    public Boolean isClientRequest() {
        return this.clientRequest;
    }

    public void setClientRequest(Boolean clientRequest) {
        this.clientRequest = clientRequest;
    }

    private static class InvalidCriteriaException
    extends Exception {
        private InvalidCriteriaException() {
        }
    }

    private static class UnlicensedException
    extends Exception {
        private UnlicensedException() {
        }
    }
}

