/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.OperatorBase;
import com.isomorphic.criteria.criterion.AndCriterion;
import com.isomorphic.criteria.criterion.CustomCriterion;
import com.isomorphic.criteria.criterion.LogicalCriterion;
import com.isomorphic.criteria.criterion.NotCriterion;
import com.isomorphic.criteria.criterion.OrCriterion;
import com.isomorphic.criteria.criterion.RangeCriterion;
import com.isomorphic.criteria.criterion.SetCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.date.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;

public class AdvancedCriteria {
    protected static Logger log = new Logger(AdvancedCriteria.class);
    public static final String CONSTRUCTOR_NAME = "AdvancedCriteria";
    Criterion criteria;
    Boolean strictSQLFiltering = null;

    public AdvancedCriteria(Criterion _criteria) {
        Map criteriaMap;
        this.criteria = _criteria;
        if (this.criteria instanceof Map && (criteriaMap = (Map)((Object)this.criteria)).get("strictSQLFiltering") != null) {
            this.strictSQLFiltering = (Boolean)criteriaMap.get("strictSQLFiltering");
        }
    }

    public AdvancedCriteria(Operator operator, Criterion ... criteria) {
        this(operator.getID(), criteria);
    }

    public AdvancedCriteria(String operator, Criterion ... criteria) {
        this.criteria = criteria.length == 1 ? (operator.equals(DefaultOperators.Not.getID()) ? new NotCriterion(criteria) : criteria[0]) : (operator.equals(DefaultOperators.And.getID()) ? new AndCriterion(criteria) : (operator.equals(DefaultOperators.Or.getID()) ? new OrCriterion(criteria) : (operator.equals(DefaultOperators.Not.getID()) ? new NotCriterion(criteria) : new LogicalCriterion(operator, criteria))));
    }

    public Object getFieldValue(String fieldName) {
        Criterion criterion = this.getFieldCriterion(fieldName);
        if (criterion != null) {
            try {
                if (criterion instanceof SetCriterion) {
                    return ((SetCriterion)criterion).getValues();
                }
                return criterion.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Criterion getFieldCriterion(String fieldName) {
        return this.getFieldCriterion(fieldName, this.criteria);
    }

    public Criterion getFieldCriterion(String fieldName, Criterion criteria) {
        if (criteria instanceof LogicalCriterion) {
            LogicalCriterion lc = (LogicalCriterion)criteria;
            if (lc.getCriteria() != null) {
                for (Criterion c : lc.getCriteria()) {
                    Criterion res = this.getFieldCriterion(fieldName, c);
                    if (res == null) continue;
                    return res;
                }
            }
        } else if (criteria != null && criteria.getFieldName() != null && criteria.getFieldName().equals(fieldName)) {
            return criteria;
        }
        return null;
    }

    public void convertRelativeDates() {
        this.convertRelativeDates((Date)null);
    }

    public void convertRelativeDates(DataSource ds) {
        this.convertRelativeDates(null, ds);
    }

    public void convertRelativeDates(Date baseDate) {
        this.criteria = DataSource.convertRelativeDates(this.criteria, baseDate, null);
    }

    public void convertRelativeDates(Date baseDate, DataSource ds) {
        this.criteria = DataSource.convertRelativeDates(this.criteria, baseDate, ds);
    }

    public void convertRelativeDates(Date baseDate, DataSource ds, boolean useEmbeddedTZ) {
        this.criteria = DataSource.convertRelativeDates(this.criteria, baseDate, ds, useEmbeddedTZ);
    }

    public static boolean hasRelativeDates(Object criteriaObject) {
        if (criteriaObject != null) {
            if (criteriaObject instanceof List) {
                for (Object l : (List)criteriaObject) {
                    if (!AdvancedCriteria.hasRelativeDates(l)) continue;
                    return true;
                }
            } else if (criteriaObject instanceof Map) {
                Map criteriaMap = (Map)criteriaObject;
                if (criteriaMap.containsKey("criteria")) {
                    Iterator i = DataTools.makeListIfSingle(criteriaMap.get("criteria")).iterator();
                    while (i.hasNext()) {
                        if (!AdvancedCriteria.hasRelativeDates(i.next())) continue;
                        return true;
                    }
                } else {
                    if (DateUtil.isRelativeDate(criteriaMap.get("value"))) {
                        return true;
                    }
                    if (DateUtil.isRelativeDate(criteriaMap.get("start"))) {
                        return true;
                    }
                    if (DateUtil.isRelativeDate(criteriaMap.get("end"))) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void setStrictSQLFiltering(Boolean strictSQLFiltering) {
        this.strictSQLFiltering = strictSQLFiltering;
    }

    public Boolean getStrictSQLFiltering() {
        return this.strictSQLFiltering;
    }

    public static AdvancedCriteria decodeClientCriteria(String clientCriteria) throws Exception {
        return AdvancedCriteria.fromCollections(JSTranslater.get().fromJS(clientCriteria));
    }

    public Set<Criterion> getFieldCriterions(String fieldName) {
        return this.getFieldCriterions(fieldName, this.criteria, new HashSet<Criterion>());
    }

    public Set<Criterion> getFieldCriterions(String fieldName, Criterion criteria, Set<Criterion> resultAccumulator) {
        if (criteria instanceof LogicalCriterion) {
            LogicalCriterion lc = (LogicalCriterion)criteria;
            if (lc.getCriteria() != null) {
                for (Criterion c : lc.getCriteria()) {
                    this.getFieldCriterions(fieldName, c, resultAccumulator);
                }
            }
        } else if (criteria.getFieldName() != null && fieldName.equals(criteria.getFieldName())) {
            resultAccumulator.add(criteria);
        }
        return resultAccumulator;
    }

    public Map<String, Object> getCriteriaAsMap() {
        Operator o = DefaultOperators.getDefaultOperatorMap().get(this.criteria.getOperatorId());
        if (o instanceof OperatorBase) {
            Map<String, Object> result = ((OperatorBase)o).convertToMap(this.criteria);
            result.put("_constructor", CONSTRUCTOR_NAME);
            if (this.getStrictSQLFiltering() != null) {
                result.put("strictSQLFiltering", this.getStrictSQLFiltering());
            }
            return result;
        }
        if (this.criteria instanceof CustomCriterion) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>((Map)((Object)this.criteria));
            result.put("_constructor", CONSTRUCTOR_NAME);
            if (this.getStrictSQLFiltering() != null) {
                result.put("strictSQLFiltering", this.getStrictSQLFiltering());
            }
            return result;
        }
        return null;
    }

    public static boolean isAdvancedCriteria(Map<String, Object> criteriaMap) {
        return AdvancedCriteria.isAdvancedCriteria(criteriaMap, null);
    }

    public static boolean isAdvancedCriteria(Map<String, Object> criteriaMap, DataSource dataSource) {
        Object subFieldName;
        Object criterion;
        if (criteriaMap == null || criteriaMap.isEmpty()) {
            return false;
        }
        String constructor = (String)criteriaMap.get("_constructor");
        if (CONSTRUCTOR_NAME.equals(constructor)) {
            return true;
        }
        String operator = (String)criteriaMap.get("operator");
        Operator searchOp = null;
        if (operator != null) {
            searchOp = dataSource != null ? dataSource.getEvaluator().getSearchOperator(operator) : DefaultOperators.getDefaultOperatorMap().get(operator);
        }
        boolean returnVal = false;
        List subCriteria = DataTools.makeListIfSingle(criteriaMap.get("criteria"));
        if (subCriteria.size() > 0 && (criterion = subCriteria.get(0)) instanceof Map && (subFieldName = ((Map)criterion).get("fieldName")) instanceof String && !"".equals(subFieldName)) {
            returnVal = true;
        }
        String fieldName = (String)criteriaMap.get("fieldName");
        if (!returnVal) {
            if (dataSource != null && dataSource.getField(fieldName) != null && searchOp != null) {
                returnVal = true;
            } else if (dataSource != null && (dataSource.getField("fieldName") != null || dataSource.getField("operator") != null)) {
                returnVal = false;
            } else if (fieldName != null && operator != null && searchOp != null) {
                returnVal = true;
            } else if (fieldName != null && operator == null && criteriaMap.get("value") == null) {
                returnVal = true;
            } else if (operator != null && ("and".equals(operator.trim()) || "or".equals(operator.trim()))) {
                returnVal = true;
            }
        }
        if (!returnVal) {
            if (operator != null && searchOp != null && criteriaMap.get("fieldQuery") != null) {
                returnVal = true;
            } else if (operator != null && searchOp != null && criteriaMap.get("valueQuery") != null) {
                returnVal = true;
            }
        }
        if (returnVal) {
            log.info("Criteria object:" + DataTools.prettyPrint(criteriaMap) + " not explicitly marked as AdvancedCriteria but treating as Advanced based on format.");
        }
        return returnVal;
    }

    public static Map<String, Object> getFlattenedFieldValueMap(final Map<String, Object> criteriaPart) {
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
        if (!AdvancedCriteria.isAdvancedCriteria(criteriaPart)) {
            return fieldValueMap;
        }
        Object object = criteriaPart.get("criteria");
        if (object == null) {
            object = new ArrayList(){
                {
                    this.add(criteriaPart);
                }
            };
        }
        if (object instanceof List) {
            List objects = (List)object;
            for (Object listObject : objects) {
                if (!(listObject instanceof Map)) continue;
                Map objectMap = (Map)listObject;
                String fieldName = String.valueOf(objectMap.get("fieldName"));
                if (fieldName != null) {
                    if (fieldValueMap.containsKey(fieldName)) continue;
                    fieldValueMap.put(ObjectUtils.toString((Object)fieldName), objectMap.get("value"));
                    continue;
                }
                if (!CONSTRUCTOR_NAME.equalsIgnoreCase(String.valueOf(objectMap.get("_constructor")))) continue;
                for (Map.Entry<String, Object> entry : AdvancedCriteria.getFlattenedFieldValueMap(objectMap).entrySet()) {
                    if (fieldValueMap.containsKey(entry.getKey())) continue;
                    fieldValueMap.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return fieldValueMap;
    }

    public static Map<String, Object> getCriteriaAsMap(Criterion criterion) {
        Operator o = DefaultOperators.getDefaultOperatorMap().get(criterion.getOperatorId());
        if (o instanceof OperatorBase) {
            return ((OperatorBase)o).convertToMap(criterion);
        }
        if (criterion instanceof CustomCriterion) {
            return new LinkedHashMap<String, Object>((Map)((Object)criterion));
        }
        return null;
    }

    public static Boolean isFieldComparisonOperator(String operator) {
        return operator != null && (operator.equals("equalsField") || operator.equals("notEqualField") || operator.equals("greaterThanField") || operator.equals("greaterOrEqualField") || operator.equals("lessThanField") || operator.equals("lessOrEqualField") || operator.equals("containsField") || operator.equals("iContainsField") || operator.equals("startsWithField") || operator.equals("iStartsWithField") || operator.equals("endsWithField") || operator.equals("iEndsWithField") || operator.equals("iEqualsField") || operator.equals("notContainsField") || operator.equals("iNotContainsField") || operator.equals("notStartsWithField") || operator.equals("iNotStartsWithField") || operator.equals("notEndsWithField") || operator.equals("iNotEndsWithField") || operator.equals("iNotEqualField"));
    }

    public static AdvancedCriteria fromCollections(Object criteria) {
        return AdvancedCriteria.fromCollections(criteria, DefaultOperators.Equals.getID());
    }

    public static AdvancedCriteria fromCollections(Object criteria, String operator) {
        return AdvancedCriteria.fromCollections(criteria, operator, null);
    }

    public static AdvancedCriteria fromCollections(Object criteria, OperatorBase operator) {
        return AdvancedCriteria.fromCollections(criteria, operator.getID(), null);
    }

    public static AdvancedCriteria fromCollections(Object criteria, OperatorBase operator, DSRequest req) {
        return AdvancedCriteria.fromCollections(criteria, operator.getID(), req);
    }

    public static AdvancedCriteria fromCollections(Object criteria, String operator, DSRequest req) {
        ArrayList l = null;
        if (criteria instanceof List) {
            l = (ArrayList)criteria;
        } else if (criteria instanceof Collection) {
            l = new ArrayList((Collection)criteria);
        }
        if (l != null) {
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return DataSource.parseAdvancedCriteria((Map)l.get(0));
            }
            HashMap<String, Object> advCritMap = new HashMap<String, Object>();
            advCritMap.put("_constructor", CONSTRUCTOR_NAME);
            if (operator != null && (DefaultOperators.Or.getID().equals(operator) || DefaultOperators.And.getID().equals(operator))) {
                advCritMap.put("operator", operator);
            } else {
                advCritMap.put("operator", DefaultOperators.And.getID());
            }
            advCritMap.put("criteria", l);
            return DataSource.parseAdvancedCriteria(advCritMap);
        }
        if (criteria instanceof Map) {
            Map criteriaMap = (Map)criteria;
            String constructor = (String)criteriaMap.get("_constructor");
            if (CONSTRUCTOR_NAME.equals(constructor)) {
                return DataSource.parseAdvancedCriteria(criteriaMap);
            }
            ArrayList c = new ArrayList();
            BasicDataSource ds = null;
            if (req != null) {
                try {
                    ds = (BasicDataSource)req.getDataSource();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception converting criteria", e);
                }
            }
            for (Object key : criteriaMap.keySet()) {
                HashMap<String, Object> critMap = new HashMap<String, Object>();
                HashMap<String, Object> innerCritMap = null;
                String overriddenOperator = null;
                Object value = criteriaMap.get(key);
                List valueList = null;
                if (value instanceof List) {
                    valueList = (List)value;
                    if (valueList.size() > 1) {
                        innerCritMap = new HashMap<String, Object>();
                        innerCritMap.put("operator", DefaultOperators.Or.getID());
                        ArrayList innerCritList = new ArrayList();
                        innerCritMap.put("criteria", innerCritList);
                        for (Object listValue : valueList) {
                            overriddenOperator = AdvancedCriteria.getOperator(key, ds, listValue, operator);
                            HashMap<String, Object> innerCriterion = new HashMap<String, Object>();
                            innerCriterion.put("operator", overriddenOperator);
                            innerCriterion.put("fieldName", key);
                            innerCriterion.put("value", listValue);
                            innerCritList.add(innerCriterion);
                        }
                        c.add(innerCritMap);
                        continue;
                    }
                    if (valueList.size() > 0) {
                        value = valueList.get(0);
                    } else {
                        log.warn("Encountered empty list as the value for key '" + String.valueOf(key) + "' in simple criteria.  Ignoring this criterion.");
                        continue;
                    }
                }
                overriddenOperator = AdvancedCriteria.getOperator(key, ds, value, operator);
                critMap.put("operator", overriddenOperator);
                critMap.put("fieldName", key);
                critMap.put("value", value);
                c.add(critMap);
            }
            HashMap<String, Object> advCritMap = new HashMap<String, Object>();
            advCritMap.put("_constructor", CONSTRUCTOR_NAME);
            if (operator != null && (DefaultOperators.Or.getID().equals(operator) || DefaultOperators.And.getID().equals(operator))) {
                advCritMap.put("operator", operator);
            } else {
                advCritMap.put("operator", DefaultOperators.And.getID());
            }
            advCritMap.put("criteria", c);
            return DataSource.parseAdvancedCriteria(advCritMap);
        }
        return null;
    }

    public static Map<String, Object> toCollections(Criterion criterion) {
        return AdvancedCriteria.getCriteriaAsMap(criterion);
    }

    private static String getOperator(Object fieldName, BasicDataSource ds, Object value, String baseOperator) {
        if (ds != null) {
            DSField field = ds.getField((String)fieldName);
            if (field != null) {
                try {
                    String type = ds.getSimpleBaseType(field.getType());
                    if (!("text".equals(type) || ("integer".equals(type) || "float".equals(type)) && value instanceof String)) {
                        return DefaultOperators.Equals.getID();
                    }
                }
                catch (Exception e) {
                    log.warn((Object)"Exception converting criteria", e);
                }
            }
        } else {
            return DefaultOperators.Equals.getID();
        }
        return baseOperator;
    }

    public void addCriteria(Criterion criterion) {
        if (this.criteria == null) {
            this.criteria = new AndCriterion(criterion);
        } else if (this.criteria instanceof AndCriterion) {
            List<Criterion> listCriteria = ((AndCriterion)this.criteria).getCriteria();
            listCriteria.add(criterion);
        } else {
            AndCriterion c = new AndCriterion(criterion);
            List<Criterion> listCriteria = c.getCriteria();
            listCriteria.add(this.criteria);
            this.criteria = c;
        }
    }

    public void addCriteria(String field, OperatorBase operator, Object start, Object end) {
        if (!(operator.getID().equals(DefaultOperators.Between.getID()) || operator.getID().equals(DefaultOperators.BetweenInclusive.getID()) || operator.getID().equals(DefaultOperators.IBetween.getID()) || operator.getID().equals(DefaultOperators.IBetweenInclusive.getID()))) {
            throw new IllegalArgumentException("The passed operator may only be of the type that takes a start and end value such as \"between\" etc.");
        }
        this.addCriteria(new RangeCriterion(field, operator.getID(), (Comparable)start, (Comparable)end));
    }

    public void addCriteria(String field, OperatorBase operator, Object value) {
        if (operator.getID().equals(DefaultOperators.Between.getID()) || operator.getID().equals(DefaultOperators.BetweenInclusive.getID()) || operator.getID().equals(DefaultOperators.IBetween.getID()) || operator.getID().equals(DefaultOperators.IBetweenInclusive.getID())) {
            throw new IllegalArgumentException("The passed operator may only be of the type that takes a singular value such as \"and\" etc. ");
        }
        this.addCriteria(new SimpleCriterion(field, operator, value));
    }

    public Criterion asCriterion() {
        return this.criteria;
    }

    public String toString() {
        return "AdvancedCriteria:[" + String.valueOf(this.criteria) + "]";
    }

    public static boolean hasFieldQueryCriterion(AdvancedCriteria ac) {
        return AdvancedCriteria.hasACSCriterion(ac.asCriterion(), true);
    }

    public static boolean hasValueQueryCriterion(AdvancedCriteria ac) {
        return AdvancedCriteria.hasACSCriterion(ac.asCriterion(), false);
    }

    public static boolean hasACSCriterion(Criterion criterion, Boolean fieldQuery) {
        boolean hasValueQuery;
        if (criterion == null) {
            return false;
        }
        if (criterion instanceof LogicalCriterion) {
            List<Criterion> criterions = ((LogicalCriterion)criterion).getCriteria();
            for (int i = 0; i < criterions.size(); ++i) {
                if (!AdvancedCriteria.hasACSCriterion(criterions.get(i), fieldQuery)) continue;
                return true;
            }
            return false;
        }
        boolean hasFieldQuery = criterion.getFieldQuery() != null;
        boolean bl = hasValueQuery = criterion.getValueQuery() != null;
        return fieldQuery == null ? hasFieldQuery || hasValueQuery : (fieldQuery != false ? hasFieldQuery : hasValueQuery);
    }
}

