/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.SeleneseSuite;
import com.isomorphic.webdriver.SeleneseTestCase;
import com.isomorphic.webdriver.SeleneseTestCaseParser;
import com.isomorphic.webdriver.SeleneseTestOptions;
import com.isomorphic.webdriver.SeleneseWebDriverProperties;
import com.isomorphic.webdriver.SmartClientChromeDriver;
import com.isomorphic.webdriver.SmartClientEdgeDriver;
import com.isomorphic.webdriver.SmartClientFirefoxDriver;
import com.isomorphic.webdriver.SmartClientIEDriver;
import com.isomorphic.webdriver.SmartClientWebDriver;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Parser;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SeleneseRunner {
    private static final String SOURCE_OUT_LABEL = "*** Generating WebDriver Java to: ";
    private static final String CAPABILITIES_IN_LABEL = "*** Setting driver capabilities from properties file: ";
    private static final String DEFAULT_BASE_URL = "http://localhost";

    public static void main(String[] args) throws ParserException, IOException {
        String action;
        boolean allPassed = true;
        boolean quiet = false;
        boolean debug = false;
        String baseUrl = null;
        SeleneseSuite suite = null;
        PrintStream sourceOut = null;
        String jUnitXMLFilename = null;
        SeleneseWebDriverProperties driverProps = null;
        List<Object> testFiles = new LinkedList();
        Class driverClass = SmartClientFirefoxDriver.class;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-ff".equals(arg) || "-firefox".equals(arg)) {
                driverClass = SmartClientFirefoxDriver.class;
                continue;
            }
            if ("-ie".equals(arg) || "-internetexplorer".equals(arg)) {
                driverClass = SmartClientIEDriver.class;
                continue;
            }
            if ("-ed".equals(arg) || "-edge".equals(arg)) {
                driverClass = SmartClientEdgeDriver.class;
                continue;
            }
            if ("-ch".equals(arg) || "-chrome".equals(arg)) {
                driverClass = SmartClientChromeDriver.class;
                continue;
            }
            if ("-d".equals(arg) || "-debug".equals(arg)) {
                debug = true;
                continue;
            }
            if ("-q".equals(arg) || "-quiet".equals(arg)) {
                quiet = true;
                continue;
            }
            if ("-p".equals(arg)) {
                if (++i >= args.length) {
                    SeleneseRunner.usageError();
                    continue;
                }
                try {
                    arg = args[i];
                    driverProps = new SeleneseWebDriverProperties(arg);
                    if (quiet) continue;
                    System.out.println(CAPABILITIES_IN_LABEL + arg);
                }
                catch (FileNotFoundException e) {
                    System.err.println("!!! Config file not found: " + arg + "\n");
                    SeleneseRunner.usageError();
                }
                continue;
            }
            if ("-j".equals(arg)) {
                if (++i >= args.length) {
                    SeleneseRunner.usageError();
                    continue;
                }
                jUnitXMLFilename = arg = args[i];
                if (quiet) continue;
                System.out.println("*** JUnit XML Report file set to " + arg);
                continue;
            }
            if ("-s".equals(arg)) {
                Object sourceOutBanner = SOURCE_OUT_LABEL;
                if (++i >= args.length) {
                    SeleneseRunner.usageError();
                    continue;
                }
                arg = args[i];
                if ("-".equals(arg)) {
                    sourceOut = System.out;
                    sourceOutBanner = (String)sourceOutBanner + "STDOUT";
                } else {
                    sourceOut = new PrintStream(arg);
                    sourceOutBanner = (String)sourceOutBanner + arg;
                }
                if (quiet) continue;
                System.out.println((String)sourceOutBanner);
                continue;
            }
            testFiles.add(arg);
        }
        if (testFiles.size() < 1) {
            SeleneseRunner.usageError();
        } else {
            Pattern urlPattern = Pattern.compile("(https?|ftp):.*");
            Matcher urlMatcher = urlPattern.matcher((CharSequence)testFiles.get(0));
            if (urlMatcher.matches()) {
                baseUrl = (String)testFiles.remove(0);
                if (!quiet) {
                    System.out.println("*** Using baseUrl: " + baseUrl);
                }
            } else if (debug) {
                debug = false;
                System.err.println("!!! No browser will be opened - ignoring debug option");
            }
        }
        if (baseUrl == null && sourceOut == null) {
            baseUrl = DEFAULT_BASE_URL;
            if (!quiet) {
                System.out.println("*** No output sourceFile or baseUrl provided");
                System.out.println("*** Defaulting baseUrl to " + baseUrl + " to allow execution");
            }
        }
        String string = action = baseUrl != null ? "translation & execution" : "translation";
        if (testFiles.size() >= 1 && SeleneseSuite.isASuiteFile((String)testFiles.get(0))) {
            try {
                suite = new SeleneseSuite((String)testFiles.get(0), jUnitXMLFilename);
                testFiles = suite.getTestFiles();
                if (!quiet) {
                    System.out.println("*** Loaded suite '" + suite.getTitle() + "' with " + testFiles.size() + " test cases");
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("!!! Test suite file " + (String)testFiles.get(0) + " not found\n");
                SeleneseRunner.usageError();
            }
        }
        for (int i = 0; i < testFiles.size(); ++i) {
            String fileName;
            SeleneseTestCase testCase = suite != null ? suite.getTestCase(i) : null;
            String string2 = fileName = testCase != null ? testCase.getTestFile() : (String)testFiles.get(i);
            if (!quiet) {
                System.out.println("*** Beginning " + action + " of " + fileName);
            }
            String content = SeleneseRunner.getTestContent(fileName, null);
            if (sourceOut != null) {
                sourceOut.println("@Test\npublic void " + SeleneseRunner.getTestName(fileName) + "() {");
            }
            boolean passed = SeleneseRunner.parseEntry(driverClass, driverProps, baseUrl, content, testCase, null, sourceOut, debug);
            if (!quiet) {
                System.out.println("*** Finished " + fileName + " with status: " + (passed ? "PASS" : "FAIL") + "\n");
            }
            if (sourceOut != null) {
                sourceOut.println("}\n");
            }
            allPassed &= passed;
        }
        if (suite != null && jUnitXMLFilename != null) {
            suite.writeJUnitXMLReport();
            if (!quiet) {
                System.out.println("*** JUnit XML Report written to " + jUnitXMLFilename);
            }
        }
        System.exit(allPassed ? 0 : -1);
    }

    private static String getTestContent(String fileName, InputStream stream) throws IOException {
        String line;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(stream != null ? new InputStreamReader(stream) : new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            System.err.println("!!! File not found: " + fileName + "\n");
            SeleneseRunner.usageError();
        }
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        reader.close();
        return builder.toString();
    }

    private static String getTestName(String fileName) {
        int indexOf = (fileName = Paths.get(fileName, new String[0]).normalize().toString()).indexOf(".rctest.html");
        if (indexOf < 0) {
            SeleneseRunner.usageError();
        }
        String baseName = fileName.substring(0, indexOf);
        return baseName.replaceAll("^[^A-Za-z0-9_]+", "").replaceAll("[^A-Za-z0-9_]", "_");
    }

    private static void usageError() {
        System.err.println("Usage: [-ff|-ie|-ch|-ed] [-d] [-q] [-p <testConfigFile>] [-s <sourceFile>]");
        System.err.println("                         [-j <reportFile>] [<baseUrl>] <suiteFile> | <testFile>...");
        System.err.println("");
        System.err.println(" -ff | -ie | -ch | -ed to specify the browser to be used. Default is FireFox");
        System.err.println(" -d | -debug outputs actions being executed and inserts a 5 second delay between each");
        System.err.println(" -q | -quiet means that results are not reported. Exit status of 0 implies all successful");
        System.err.println(" -s <sourceFile> : approximate java code for JUnit type testing is produced");
        System.err.println(" -j <reportFile> : reports results in JUnit XML format (test suites only)");
        System.err.println("");
        System.err.println("If you provide a baseUrl, your Selenese tests will be run against it.  If you supply a");
        System.err.println("sourceFile, SeleneseRunner will write a translation of your tests to it.  If neither is");
        System.err.println("provided, your Selenese tests will be executed assuming a baseUrl of \"http://localhost\",");
        System.err.println("which is only appropriate if your Selenese tests open new pages using absolute URLs.");
        System.err.println("You may either provide a single test suite file, named as [Test Suite Name].html");
        System.err.println("or one more test files, named according to the pattern [Test Name].rctest.html");
        System.exit(1);
    }

    private static SmartClientWebDriver getWebDriver(Class driverClass, SeleneseWebDriverProperties driverProps) {
        SmartClientWebDriver driver = null;
        try {
            if (driverClass == SmartClientFirefoxDriver.class) {
                FirefoxOptions options = new FirefoxOptions();
                driver = new SmartClientFirefoxDriver(driverProps == null ? options : driverProps.addToOptions(options));
            } else if (driverProps != null) {
                Constructor driverCons = driverClass.getConstructor(Capabilities.class);
                DesiredCapabilities capabilities = driverProps.getConfiguredCapabilities();
                driver = (SmartClientWebDriver)driverCons.newInstance(capabilities);
            } else {
                Constructor driverCons = driverClass.getConstructor(new Class[0]);
                driver = (SmartClientWebDriver)driverCons.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            System.err.println("!!! Failed to create driver class " + String.valueOf(driverClass) + ":");
            e.printStackTrace();
        }
        return driver;
    }

    private static boolean parseEntry(SmartClientWebDriver driver, String baseUrl, String content, SeleneseTestCase testCase, SeleneseTestOptions options, PrintStream sourceOut, PrintStream errorStream, boolean debug, boolean close) throws ParserException {
        SeleneseTestCaseParser visitor = new SeleneseTestCaseParser(driver, baseUrl, testCase, options, sourceOut, errorStream, debug, close);
        Parser parser = new Parser(new Lexer(new Page(content, "UTF-8")));
        parser.visitAllNodesWith((NodeVisitor)visitor);
        return visitor.getResult();
    }

    private static boolean parseEntry(Class driverClass, SeleneseWebDriverProperties driverProps, String baseUrl, String content, SeleneseTestCase testCase, SeleneseTestOptions testOptions, PrintStream sourceOut, boolean debug) throws ParserException {
        SmartClientWebDriver driver = null;
        if (baseUrl != null && (driver = SeleneseRunner.getWebDriver(driverClass, driverProps)) == null) {
            return false;
        }
        return SeleneseRunner.parseEntry(driver, baseUrl, content, testCase, testOptions, sourceOut, System.err, debug, true);
    }

    public static boolean executeSelenese(String baseUrl, String content, Class driverClass) throws ParserException {
        if (driverClass == null) {
            driverClass = SmartClientFirefoxDriver.class;
        }
        return SeleneseRunner.parseEntry(driverClass, null, baseUrl, content, null, null, null, false);
    }

    public static boolean executeSelenese(String baseUrl, String content) throws ParserException {
        return SeleneseRunner.executeSelenese(baseUrl, content, null);
    }

    public static boolean executeSelenese(String baseUrl, String testFile, Class driverClass, DesiredCapabilities capabilities) throws ParserException, IOException {
        if (driverClass == null) {
            driverClass = SmartClientFirefoxDriver.class;
        }
        return SeleneseRunner.parseEntry(driverClass, new SeleneseWebDriverProperties(capabilities), baseUrl, SeleneseRunner.getTestContent(testFile, null), null, null, null, false);
    }

    public static boolean executeSelenese(String baseUrl, String testFile, SmartClientWebDriver driver, SeleneseTestOptions testOptions, PrintStream out, PrintStream err) throws IOException {
        return SeleneseRunner.executeSelenese(baseUrl, testFile, null, driver, testOptions, out, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeSelenese(String baseUrl, String testFile, InputStream testStream, SmartClientWebDriver driver, SeleneseTestOptions testOptions, PrintStream out, PrintStream err) throws IOException {
        if (err == null) {
            err = System.err;
        }
        try {
            if (driver != null) {
                driver.setErrorStream(err);
            }
            boolean bl = SeleneseRunner.parseEntry(driver, baseUrl, SeleneseRunner.getTestContent(testFile, testStream), null, testOptions, out != null ? out : System.out, err, false, false);
            return bl;
        }
        catch (ParserException p) {
            err.println("!!! Encountered syntax error reading test " + testFile);
            p.printStackTrace(err);
            boolean bl = false;
            return bl;
        }
        finally {
            if (driver != null) {
                driver.clearErrorStream();
            }
        }
    }

    public static final class Entry {
        protected String description;
        protected int count;
        protected String title;
    }
}

