/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class FirebirdDriver
extends SQLDriver {
    private static Logger log = new Logger(FirebirdDriver.class.getName());
    private static final Map<String, String> formulaReplacements;
    private static final SQLDriver.FormulaConfig formulaConfig;

    public FirebirdDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public boolean supportsRegexp() throws Exception {
        return this.getDatabaseMajorVersion() > 2 || this.getDatabaseMajorVersion() == 2 && this.getDatabaseMinorVersion() >= 5;
    }

    @Override
    public String getExpressionForRegexp(String escapedColumnOrExpression, String operator, String regexp) throws Exception {
        return escapedColumnOrExpression + " SIMILAR TO " + this.escapeRegexp(regexp) + " ESCAPE ''" + ("iregexp".equals(operator) ? " COLLATE UNICODE_CI" : "");
    }

    @Override
    public boolean supportsNativeReplace() {
        return false;
    }

    @Override
    public boolean supportsSQLLimit() {
        return true;
    }

    @Override
    public String limitQuery(String query, long startRow, long batchSize, List outputColumns, String baseOrderClause, String computedOrderClause, DSRequest req, List dataSources, Map context) {
        String token;
        int insertPoint;
        Object q = query;
        if (computedOrderClause != null && computedOrderClause.trim().length() > 0) {
            q = baseOrderClause == null || baseOrderClause.trim().length() == 0 || "$defaultOrderClause".equals(baseOrderClause) && (context.get("defaultOrderClause") == null || ((String)context.get("defaultOrderClause")).trim().length() == 0) ? (String)q + " ORDER BY " : (String)q + ", ";
            q = (String)q + computedOrderClause;
        }
        if ((insertPoint = ((String)q).indexOf(token = "SELECT ")) == -1) {
            return q;
        }
        return ((String)q).substring(0, insertPoint += token.length()) + "FIRST " + batchSize + " SKIP " + startRow + " " + ((String)q).substring(insertPoint);
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        if (this.dbConnection == null && req == null) {
            throw new Exception("No existing db connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        for (String sequenceName : sequencesNotPresent) {
            String sequence = this.getCurrentSequenceValue((String)ds.ds2NativeFieldMap().get(sequenceName), ds);
            if (sequence == null) continue;
            Object obj = FirebirdDriver.getScalarResult("SELECT " + sequence + " FROM RDB$DATABASE", this.dbConnection, this.dbName, this, req);
            Object transformed = this.getTransformedSequenceValue(obj, sequenceName, ds, req);
            if (transformed != null) {
                primaryKeys.put(sequenceName, transformed);
                continue;
            }
            BigDecimal value = new BigDecimal(obj.toString());
            primaryKeys.put(sequenceName, value.longValue());
        }
        return primaryKeys;
    }

    @Override
    public boolean useActualSequenceObjects(SQLDataSource ds) {
        return true;
    }

    public String getCurrentSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName);
        if (sequenceName == null) {
            return null;
        }
        return "GEN_ID(" + sequenceName + ", 0)";
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName, dataSource);
        if (sequenceName == null) {
            return null;
        }
        return "NEXT VALUE FOR " + sequenceName;
    }

    @Override
    public String formatValue(Object value) {
        return value.toString();
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        Object output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = (String)output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + (String)output;
        }
        return output;
    }

    @Override
    protected SQLDriver.FormulaConfig getFormulaConfig() {
        return formulaConfig;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (escapeForFilter) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    public String escapeClause(Object value) {
        return " {ESCAPE '\\'}";
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        if (this._sqlConfig.getBoolean((Object)"useCaseForSortBy", false)) {
            return column;
        }
        String expr = "CASE " + column;
        for (String rawValue : valueMap.keySet()) {
            String actualValue = this.transformActualValueForSort(rawValue, column, request);
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(rawValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN " + actualValue + " THEN " + displayValue;
        }
        expr = expr + " ELSE " + column + " END";
        return expr;
    }

    @Override
    public String sqlCast(String result, DSField field) {
        String type = field.getType();
        if (type != null && DataSource.simpleTypeInheritsFromBuiltInType((String)type, (String)"datetime")) {
            return "CAST(" + result + " AS TIMESTAMP)";
        }
        return super.sqlCast(result, field);
    }

    @Override
    public int caseInsensitiveStrategy() {
        return 2;
    }

    @Override
    public Timestamp getUTCTimestamp(ResultSet rs, int index) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(index);
        long millis = timestamp.getTime();
        TimeZone tz = TimeZone.getDefault();
        int offset = tz.getOffset(millis);
        return new Timestamp(millis + (long)offset);
    }

    @Override
    public InputStream handleInputStream(InputStream in) throws Exception {
        return super.handleInputStream(in);
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName == null ? null : objectName.toUpperCase();
    }

    @Override
    public String getDummyQuery() {
        return "SELECT 1 FROM RDB$DATABASE";
    }

    @Override
    protected int defaultAliasLengthLimit() {
        return 63;
    }

    @Override
    public String getTextColumnDefinitionForLength(long length) throws Exception {
        if (length <= 32767L) {
            return "varchar(" + length + ")";
        }
        return "BLOB SUB_TYPE 1";
    }

    @Override
    public String getFloatType() {
        return "float";
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("ceiling", "ceil");
        m.put("max", "maxvalue");
        m.put("greatest", "maxvalue");
        m.put("min", "minvalue");
        m.put("least", "minvalue");
        m.put("pow", "power");
        m.put("random", "rand");
        m.put("currentDateTime()", "current_timestamp");
        m.put("now()", "current_timestamp");
        m.put("year(", "extract(year from");
        m.put("month(", "extract(month from");
        m.put("day(", "extract(day from");
        m.put("hour(", "extract(hour from");
        m.put("minute(", "extract(minute from");
        m.put("second(", "extract(second from");
        formulaReplacements = Collections.synchronizedMap(m);
        formulaConfig = new SQLDriver.FormulaConfig(formulaReplacements);
    }
}

