# AutoTest Documentation

[← Back to API Index](../reference.md)

---

## Class: AutoTest

### Description
Standalone class providing a general interface for integration with Automated Testing Tools

_For an overview of Automated Testing in SmartClient, see the documentation [here](../kb_topics/automatedTesting.md#kb-topic-automated-testing)._

## AutoTestLocators

The AutoTest class is responsible for creating and resolving [autoTestLocators](../reference_2.md#type-autotestlocator) - identifier strings which can reliably identify an interactive element in a SmartClient application.

These locators are designed to work across browsers, SmartClient versions, and even major changes to your application's UI. They do not rely on the DOM structure, and are intended to be able to identify the target element reliably without requiring pervasive explicitly specified [component IDs](Canvas.md#attr-canvasid).

Note that AutoTest locators are the only supported way to identify SmartClient generated DOM elements when recording tests for automated testing tools. Using XPath DOM locators to identify elements is not a supported approach. The DOM structure and DOM element attributes generated by SmartClient components are not guaranteed to be identical for functionally equivalent elements across different SmartClient builds, different browsers, and for dynamically generated components, could even change across page reloads.

The primary APIs for working with AutoTest locators are as follows:

*   [AutoTest.getLocator](#classmethod-autotestgetlocator) to retrieve a locator for an element
*   [AutoTest.getElement](#classmethod-autotestgetelement) to resolve a stored locator back to an element

Developers should also be aware of the [AutoTest.installLocatorShortcut](#classmethod-autotestinstalllocatorshortcut) method which allows you to retreive locators via a simple key combo + mouseDown event on the target element.

See the [AutoTestLocator overview](../reference_2.md#type-autotestlocator) documentation for details on how locators are structured.

See the [Reliable AutoTestLocators overview](../kb_topics/reliableLocators.md#kb-topic-generating-reliable-autotestlocators) documentation for best practices for generating high quality locators.

#### AutoTest locator variables
AutoTest locators may be written to include dynamic variables to be resolved at runtime. See the following APIs for details:

*   [AutoTest.setVariable](#classmethod-autotestsetvariable): Set up a named variable for later use
*   [AutoTest.storeLocatorResult](#classmethod-autoteststorelocatorresult): Resolve a locator against the current environment and store it as a variable
*   [AutoTest.getVariable](#classmethod-autotestgetvariable): Retrieves the value of a previously defined variable

#### Locator testRoot
For tests that target a standard widget hierarchy such as a [screen](RPCManager.md#classmethod-rpcmanagerloadscreen), the [AutoTest.testRoot](#classattr-autotesttestroot) may be used to reliably identify the widget hierarchy in question wherever it is rendered inside a larger application.

## Waiting for asynchronous operations

The AutoTest class provides utilities to wait for asynchronous actions, including both system delays (such as [redraws that fire on system idle](Canvas.md#method-canvasmarkforredraw), for example), and asynchronous [RPC operations](RPCManager.md#class-rpcmanager).

*   [AutoTest.waitForElement](#classmethod-autotestwaitforelement): this method will wait for asynchronous operations to complete before resolving an [AutoTestLocator](../reference_2.md#type-autotestlocator) to an element and firing a callback function. This allows recorded tests to reference elements that are blocked or unavailable until some asynchronous action(s) complete.
*   [AutoTest.waitForSystemDone](#classmethod-autotestwaitforsystemdone): this method will wait for any outstanding asynchronous system operations to complete and then fire the specified callback.
*   [AutoTest.isSystemDone](#classmethod-autotestissystemdone): this method may be called to check whether there are currently any outstanding asynchronous system operations.

Note that SmartClient's support for integrating with high level tools such as [Playwright](../kb_topics/smartClientPlaywright.md#kb-topic-integrating-smartclient-with-playwright), [Cypress](../kb_topics/smartClientCypress.md#kb-topic-integrating-smartclient-with-cypress) and [Selenium](../kb_topics/usingSelenium.md#kb-topic-using-selenium-scripts-selenese) automatically makes use of these APIs.

### Groups

- autoTest

---
## ClassAttr: AutoTest.implicitNetworkWait

### Description
Controls whether certain AutoTest APIs wait for network operations to complete before returning true. When value is true, [AutoTest.isElementClickable](#classmethod-autotestiselementclickable) will return false until all network operations have completed.

### Groups

- autoTest

**Flags**: IRW

---
## ClassAttr: AutoTest.useMinimalFallbackAttributes

### Description
Should generated locators omit fallback locator attributes when generating segments that identify components or other objects by attribute values?

See the [AutoTestLocator overview](../reference_2.md#type-autotestlocator) for details of locator fallback attributes.

**Flags**: IRW

---
## ClassAttr: AutoTest.testRoot

### Description
Sets the implicit root canvas available in scLocators starting "//testRoot\[\]". Setting this property may enable one to use the same script to test identical widget hierarchies that are rooted under different base widgets.

### Groups

- autoTest

**Flags**: IRW

---
## ClassAttr: AutoTest.useSearchSegments

### Description
Should generated locators include search segments (as detailed in the [AutoTestLocator overview](../reference_2.md#type-autotestlocator)) to identify components with [defining property values](Canvas.md#method-canvasgetdefiningpropertyname)?

See also [AutoTestLocatorConfiguration.searchSegmentsIncludeHidden](AutoTestLocatorConfiguration.md#attr-autotestlocatorconfigurationsearchsegmentsincludehidden)

**Flags**: IRW

---
## ClassAttr: AutoTest.defaultElementWaitStyle

### Description
Default [ElementWaitStyle](../reference_2.md#type-elementwaitstyle) for [AutoTest.waitForElement](#classmethod-autotestwaitforelement)

**Flags**: IRW

---
## ClassAttr: AutoTest.searchSegmentsIncludeHidden

### Description
When generating locators with [search segments](AutoTestLocatorConfiguration.md#attr-autotestlocatorconfigurationusesearchsegments), should the generation logic always consider hidden components as well as visible components to determine whether the search segment will uniquely resolve?

Setting this property to true ensures that, even for visible components, search segments will be guaranteed to resolve uniquely when considering both visible and hidden components on the page. Any search segments in the generated locator will include a marker to indicate that both hidden and visible widgets should be considered when resolving the locator back to a target via [AutoTest.getElement](#classmethod-autotestgetelement), [AutoTest.getObject](#classmethod-autotestgetobject) and related methods.

Note that this setting has no impact on locators being generated for components that are currently hidden. Any search segments for hidden components will always consider uniqueness among all components (hidden and visible), and include the marker to ensure that they are considered when resolving the locator back to an object.

See the [AutoTestLocator overview](../reference_2.md#type-autotestlocator) for more information about search segments in AutoTestLocators

**Flags**: IRWA

---
## ClassAttr: AutoTest.simplifyLocatorAttributeHTML

### Description
Should HTMLStrings in fallback locator attributes be simplified to ordinary strings before being written out? For example:
```
    title="<div id=\"foo\">bar</div>"
 
```
would become
```
     title="bar"
 
```
if so simplified.

### See Also

- [AutoTest.legacyLocatorAttributeHTML](#classattr-autotestlegacylocatorattributehtml)

**Flags**: IRW

---
## ClassAttr: AutoTest.useCompactFallbackSyntax

### Description
This setting controls whether locator segments that identify components or other objects by attribute values use a compact or verbose syntax.

See the [AutoTestLocator overview](../reference_2.md#type-autotestlocator) for details of locator attributes.

**Flags**: IRW

---
## ClassAttr: AutoTest.useIDsAsLocators

### Description
May a simple widget ID with no other content be returned from [AutoTest.getLocator](#classmethod-autotestgetlocator)?

If true, when a locator is requested for a component, and that component has an explicitly specified [Canvas.ID](Canvas.md#attr-canvasid), the ID will be returned as the entire locator.

This only applies when the target of the locator is the component itself or its handle. If the target is a child, or an interior DOM element that requires additional locator segments to identify, a standard multi-segment locator will be generated.

See the [AutoTestLocator overview](../reference_2.md#type-autotestlocator) for more information on locators.

**Flags**: IRW

---
## ClassMethod: AutoTest.setTestRoot

### Description
Sets the implicit root canvas available in scLocators starting "//testRoot\[\]". Setting this property may enable one to use the same script to test identical widget hierarchies that are rooted under different base widgets.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| canvas | [Canvas](#type-canvas) | false | — | the implicit root |

### Groups

- autoTest

---
## ClassMethod: AutoTest.variableIsDefined

### Description
Determine whether a variable has been explicitly set via [AutoTest.setVariable](#classmethod-autotestsetvariable) or [AutoTest.storeLocatorResult](#classmethod-autoteststorelocatorresult).

This method will return true if the variable has been set to any value, including `null`, or false if the variable has never been set or has been [cleared](#classmethod-autotestclearvariable).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| name | [String](#type-string) | false | — | variable to retrieve |

### Returns

`[Boolean](#type-boolean)` — true

---
## ClassMethod: AutoTest.locateCanvasFromDOMElement

### Description
Given an element in the DOM, returns the canvas containing this element, or null if the element is not contained in any canvas handle.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| element | [DOMElement](#type-domelement) | false | — | DOM element within in the page |

### Returns

`[Canvas](#type-canvas)` — canvas containing the element, or null if none apply

### Groups

- autoTest

---
## ClassMethod: AutoTest.isSystemDone

### Description
Returns a boolean to indicate whether the current application is fully loaded with no pending operations, and is ready for user interaction. This includes the following checks:

*   page has finished loading
*   all ListGrids (as defined by isc.isA.ListGrid) satisfy [AutoTest.isGridDone](#classmethod-autotestisgriddone)
*   all TileGrids that are drawn satisfy [AutoTest.isTileGridDone](#classmethod-autotestistilegriddone)
*   all TileLayouts that are drawn satisfy [AutoTest.isTileLayoutDone](#classmethod-autotestistilelayoutdone)
*   all DynamicForms that are drawn satisfy [AutoTest.isFormDone](#classmethod-autotestisformdone)
*   all Canvii that are drawn satisfy [AutoTest.isCanvasDone](#classmethod-autotestiscanvasdone)

In addition to this the `options` parameter allows developers to check additional criteria as documented under [SystemDoneConfig](../reference.md#object-systemdoneconfig).

Note: [AutoTest.waitForSystemDone](#classmethod-autotestwaitforsystemdone) will poll this method repeatedly to check for all pending actions being complete. The [SystemWaitConfig](../reference.md#object-systemwaitconfig) parameter of that method allow the user to speciofy which actions to wait for. By default [AutoTest.waitForSystemDone](#classmethod-autotestwaitforsystemdone) will wait for _all_ actions to complete, including queued redraws, timers, network requests, as well as page load and comopnent level `is_Component_Done` checks.

Depending on your application configuration, it is possible that this method will not be able to determine whether it is truly in a busy state. Some examples include:

*   If [SystemDoneConfig.includeTimers](SystemDoneConfig.md#attr-systemdoneconfigincludetimers) is true and the application has a constantly running background timer to perform some ongoing polling action or similar, this method may return `false` even though the application is ready for interaction
*   Similarly if [SystemDoneConfig.includeRedraws](SystemDoneConfig.md#attr-systemdoneconfigincluderedraws) is true, and the application is using messaging, or some other mechanism to periodically refresh component(s) such that they are repeatedly marked as dirty, this method may return `false` even though the application is ready for interaction
*   If this application makes use of some third-party library to perform asynchronous actions, this method may return `true` even when the application is waiting on a response from this third-party tool.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| options | [SystemDoneConfig](#type-systemdoneconfig)|[boolean](../reference.md#type-boolean) | true | — | This parameter determines what specific outstanding actions are required to be completed before the system is considered "done" with current processing. If passed as a boolean rather than a SystemDoneConfig object, this determines whether the system should wait for [pending redraws](Canvas.md#method-canvasmarkforredraw). |

### Returns

`[boolean](../reference.md#type-boolean)` — whether loaded page is 'done' as described above

### Groups

- autoTest

---
## ClassMethod: AutoTest.isCanvasDone

### Description
Returns whether the canvas associated with the given DOM element is in a consistent state with no pending operations. Returns null if the argument is not valid or isn't associated with an element representing a valid canvas. Otherwise, returns true or false according as the conditions below are all satisfied:

*   page has finished loading
*   canvas is drawn
*   canvas isn't dirty
*   canvas has no queued overflow operations
*   canvas is not animating

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| element | [Canvas](#type-canvas)|[DOMElement](#type-domelement)|[AutoTestLocator](../reference_2.md#type-autotestlocator) | false | — | DOM element to test (element obtained from canvas or SmartClient locator if provided) |

### Returns

`[Boolean](#type-boolean)` — whether element is 'done' as described above

### Groups

- autoTest

---
## ClassMethod: AutoTest.isTileLayoutDone

### Description
Returns whether the TileLayout associated with the given DOM element is in a consistent state with no pending operations. Returns null if the argument is not valid or isn't associated with an element representing a valid TileLayout. Otherwise, returns true or false according as the conditions below are all satisfied:

*   page has finished loading
*   the TileLayout (as a canvas) satisfies [AutoTest.isCanvasDone](#classmethod-autotestiscanvasdone)
*   the TileLayout is not currently animating any layout operations

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| element | [Canvas](#type-canvas)|[DOMElement](#type-domelement)|[AutoTestLocator](../reference_2.md#type-autotestlocator) | false | — | DOM element to test (element obtained from canvas or SmartClient locator if provided) |

### Returns

`[Boolean](#type-boolean)` — whether element is 'done' as described above

### Groups

- autoTest

---
## ClassMethod: AutoTest.waitForElement

### Description
Waits for any in-progress actions to complete and then returns the element for the specified locator.

By default this method will wait for the [system to be done](#classmethod-autotestissystemdone) before calling [AutoTest.getElement](#classmethod-autotestgetelement) with the specified locator. The [waitStyle](../reference.md#attr-elementwaitconfigwaitstyle) attribute of the options parameter may be used to instead wait for the locator to resolve to a [clickable element](#classmethod-autotestiselementclickable).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| locator | [AutoTestLocator](../reference_2.md#type-autotestlocator) | false | — | locator for the element to retrieve |
| callback | [Callback](../reference.md#type-callback) | false | — | callback to fire when the element has been retrieved - takes two parameters:

*   "element" ([DOMElement](../reference_2.md#object-domelement)) - the clickable element the locator resolved to (or null)
*   "done" (boolean) - this will be false if the method timed out |
| options | [ElementWaitConfig](#type-elementwaitconfig) | true | — | Options to configure the wait |

---
## ClassMethod: AutoTest.isElementClickable

### Description
Returns whether the DOM element is ready to be clicked on by a Selenium test. Returns null if the argument is not valid or isn't associated with an element representing a valid canvas or form item. Otherwise, returns true or false according as the conditions below are all satisfied:

*   page has finished loading
*   no network operations are outstanding (configurable, see [AutoTest.implicitNetworkWait](#classattr-autotestimplicitnetworkwait))
*   canvas is visible, enabled, and not masked,
*   canvas satisfies [AutoTest.isCanvasDone](#classmethod-autotestiscanvasdone)
*   if canvas is a TileGrid, it satisfies [AutoTest.isTileGridDone](#classmethod-autotestistilegriddone)
*   if canvas is a TileLayout, it satisfies [AutoTest.isTileLayoutDone](#classmethod-autotestistilelayoutdone)
*   if canvas is a ListGrid or body of a ListGrid, it satisfies [AutoTest.isGridDone](#classmethod-autotestisgriddone)
*   if canvas is a DynamicForm, it satisfies [AutoTest.isFormDone](#classmethod-autotestisformdone)

Note that for a form item in a DynamicForm, the DynamicForm must satisfy the third condition above, while the container widget of the element must satisfy the remaining conditions.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| element | [Canvas](#type-canvas)|[FormItem](#type-formitem)|[DOMElement](#type-domelement)|[AutoTestLocator](../reference_2.md#type-autotestlocator) | false | — | DOM element to test (element obtained from canvas, form item, or SmartClient locator if provided) |

### Returns

`[Boolean](#type-boolean)` — whether element is 'clickable' as described above

### Groups

- autoTest

---
## ClassMethod: AutoTest.storeLocatorResult

### Description
This method will resolve a locator against the current environment and store it as a [variable](#classmethod-autotestsetvariable).

For example, the following code would store the first record from a listGrid with ID "myList" as AutoTest variable `"testRecord"`

```
 isc.AutoTest.storeLocatorResult(
     "testRecord",
     "//ListGrid[ID=\"myList\"]/body/row[0]",
     "record"
 );
 
```

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| name | [String](#type-string) | false | — | variable name for the locator |
| locator | [String](#type-string) | true | — | locator to resolve. If null the named variable will be cleared. |
| attribute | [LocatorAttributeType](../reference_2.md#type-locatorattributetype) | true | — | what type of value should be derived from the locator? Valid options differ based on the locator |

---
## ClassMethod: AutoTest.waitForSystemDone

### Description
Fires the provided callback when [AutoTest.isSystemDone](#classmethod-autotestissystemdone) returns true.

By default this will wait for the following system actions to complete:

*   All outstanding SmartClient [RPC and DataSource requests](RPCManager.md#class-rpcmanager)
*   All outstanding [FileLoader requests](../reference_2.md#object-fileloader)
*   Any [queued redraws](Canvas.md#method-canvasmarkforredraw)
*   Any non-recurring [delayed actions](Timer.md#class-timer)

Note that this behavior may differ from the default settings for [AutoTest.isSystemDone](#classmethod-autotestissystemdone)

The `options` parameter gives developers finer grained control over what to wait for.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| callback | [Callback](../reference.md#type-callback) | false | — | Action to fire. This will take a single parameter "done" which will be set to false if the method timed out waiting for isSystemDone() to return true; |
| options | [SystemWaitConfig](#type-systemwaitconfig) | true | — | options to configure the wait |

---
## ClassMethod: AutoTest.getPageCoords

### Description
Returns the page-level coordinates corresponding to the supplied locator. Note: The physical position might change due to app redesign, but these coordinates would still reflect the same logical part of the DOM element for components where event position matters.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| locator | [AutoTestLocator](../reference_2.md#type-autotestlocator) | false | — | Locator String previously returned by [AutoTest.getLocator](#classmethod-autotestgetlocator) |

### Returns

`[Array](#type-array)` — X, Y page position

### Groups

- autoTest

---
## ClassMethod: AutoTest.getLocator

### Description
Returns an [AutoTestLocator](../reference_2.md#type-autotestlocator) for some DOM element or object in a SmartClient application page. The generated locator may be resolved to a target element or object via [AutoTest.getElement](#classmethod-autotestgetelement) or [AutoTest.getObject](#classmethod-autotestgetobject), to target event coordinates via [AutoTest.getPageCoords](#classmethod-autotestgetpagecoords), or may be used to retrieve some data value relevant to the target via [AutoTest.getValue](#classmethod-autotestgetvalue).

The optional `coords` parameter allows developers to specify page-level event coordinates. For certain components where the exact mouse-position of an event would change its behavior, this may cause the generated locator to include information about the position of an event within a target in the form of a "target area" suffix or similar. Note that not page coordinates may not impact the generated locator in every case, and calling [AutoTest.getPageCoords](#classmethod-autotestgetpagecoords) is not typically expected to return exactly the coordinates passed into this method. That method will return coordinates that would result in the same event handling behavior as an event that occurred over the specified coordinates when the locator was created.

The `options` parameter may be used to configure how the locator is generated - see [AutoTestLocatorConfiguration](../reference.md#object-autotestlocatorconfiguration).

See also the [AutoTestLocator overview](../reference_2.md#type-autotestlocator) for more information about autoTest locators.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| target | [DOMElement](#type-domelement)|[Canvas](#type-canvas)|[FormItem](#type-formitem) | true | — | Target within the page. This may be a DOM element, a [Canvas](Canvas.md#class-canvas) or a [FormItem](FormItem.md#class-formitem). If null, a locator for the last mouse event target DOM element will be generated. |
| checkForNativeHandling | [boolean](../reference.md#type-boolean) | true | — | If this parameter is passed in, check whether the target element responds to native browser events directly rather than going through the SmartClient widget/event handling model. If we detect this case, return null rather than a live locator. This allows us to differentiate between (for example) an event on a Canvas handle, and an event occurring directly on a simple ``<a href=...>`` tag written inside a Canvas handle. |
| coords | [Array](#type-array) | true | — | X, Y page position |
| options | [AutoTestLocatorConfiguration](#type-autotestlocatorconfiguration) | true | — | Options to configure the locator returned by this method |

### Returns

`[AutoTestLocator](../reference_2.md#type-autotestlocator)` — Locator string allowing the AutoTest subsystem to find an equivalent DOM element on subsequent page loads.

### Groups

- autoTest

---
## ClassMethod: AutoTest.getValue

### Description
Given an [AutoTestLocator](../reference_2.md#type-autotestlocator) that refers to a live SmartClient object or a logical subcomponent of that object, return the associated meaningful JS value, if any.

For example:

*   For a locator to a ListGrid/CubeGrid cell, return the cell's value
*   For a locator to a FormItem, return the FormItem's value
*   For a locator to a ListGrid field header, return the checkbox/sorting state
*   For a locator to a Calendar EventCanvas header or body, return the text

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| locator | [AutoTestLocator](../reference_2.md#type-autotestlocator) | false | — | Locator String previously returned by [AutoTest.getLocator](#classmethod-autotestgetlocator) |

### Returns

`[Object](../reference.md#type-object)` — value associated with SC object if any, otherwise undefined

### Groups

- autoTest

---
## ClassMethod: AutoTest.locateFormItemFromDOMElement

### Description
Given an element in the DOM, returns the FormItem containing this element, or null if the element is not contained in any FormItem.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| element | [DOMElement](#type-domelement) | false | — | DOM element within in the page |

### Returns

`[FormItem](#type-formitem)` — formItem containing the element, or null if none apply

### Groups

- autoTest

---
## ClassMethod: AutoTest.getMinimalLocator

### Description
Convenience method to generate a [AutoTestLocator](../reference_2.md#type-autotestlocator) that is as compact as possible.

This method sets [AutoTest.getLocator](#classmethod-autotestgetlocator) with the following [configuration settings](../reference.md#object-autotestlocatorconfiguration):

*   useSearchSegments:true
*   searchSegmentsIncludeHidden:false
*   useMinimalFallbackAttributes:true
*   useCompactFallbackSyntax:true

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| target | [DOMElement](#type-domelement)|[Canvas](#type-canvas)|[FormItem](#type-formitem) | true | — | Target within the page. This may be a DOM element, a [Canvas](Canvas.md#class-canvas) or a [FormItem](FormItem.md#class-formitem). If null, a locator for the last mouse event target DOM element will be generated. |
| checkForNativeHandling | [boolean](../reference.md#type-boolean) | true | — | If this parameter is passed in, check whether the target element responds to native browser events directly rather than going through the SmartClient widget/event handling model. If we detect this case, return null rather than a live locator. This allows us to differentiate between (for example) an event on a Canvas handle, and an event occurring directly on a simple ``<a href=...>`` tag written inside a Canvas handle. |
| coords | [Array](#type-array) | true | — | X, Y page position |

### Returns

`[AutoTestLocator](../reference_2.md#type-autotestlocator)` — minimal locator string to identify the target.

---
## ClassMethod: AutoTest.isElementReadyForKeyPresses

### Description
Given a DOM element, returns whether the associated SmartClient Canvas or FormItem is ready to receive keyPress events from a Selenium test. Returns null if the locator is not valid or doesn't represent a valid Canvas or FormItem. Otherwise, returns true or false according as the conditions below are all satisfied:

*   page has finished loading
*   if a [TextItem](TextItem.md#class-textitem), [FileItem](FileItem.md#class-fileitem), or [TextAreaItem](TextAreaItem.md#class-textareaitem), it has native focus,
*   the element satisfies [AutoTest.isElementClickable](#classmethod-autotestiselementclickable)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| element | [Canvas](#type-canvas)|[FormItem](#type-formitem)|[DOMElement](#type-domelement)|[AutoTestLocator](../reference_2.md#type-autotestlocator) | false | — | DOM element to test (element obtained from canvas, form item, or SmartClient locator if provided) |

### Returns

`[Boolean](#type-boolean)` — whether element is 'ready' as described above

### Groups

- autoTest

---
## ClassMethod: AutoTest.getFullPathLocator

### Description
Convenience method to generate a [AutoTestLocator](../reference_2.md#type-autotestlocator) with no search segments and an explicit path from the locator root to the target.

This method sets [AutoTest.getLocator](#classmethod-autotestgetlocator) with the following [configuration settings](../reference.md#object-autotestlocatorconfiguration):

*   useSearchSegments:false
*   useMinimalFallbackAttributes:false
*   useCompactFallbackSyntax:false

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| target | [DOMElement](#type-domelement)|[Canvas](#type-canvas)|[FormItem](#type-formitem) | true | — | Target within the page. This may be a DOM element, a [Canvas](Canvas.md#class-canvas) or a [FormItem](FormItem.md#class-formitem). If null, a locator for the last mouse event target DOM element will be generated. |
| checkForNativeHandling | [boolean](../reference.md#type-boolean) | true | — | If this parameter is passed in, check whether the target element responds to native browser events directly rather than going through the SmartClient widget/event handling model. If we detect this case, return null rather than a live locator. This allows us to differentiate between (for example) an event on a Canvas handle, and an event occurring directly on a simple ``<a href=...>`` tag written inside a Canvas handle. |
| coords | [Array](#type-array) | true | — | X, Y page position |

### Returns

`[AutoTestLocator](../reference_2.md#type-autotestlocator)` — full-path locator string to identify the target.

---
## ClassMethod: AutoTest.uninstallLocatorShortcut

### Description
Uninstalls the locator shortcut installed by [AutoTest.installLocatorShortcut](#classmethod-autotestinstalllocatorshortcut)

---
## ClassMethod: AutoTest.isItemDone

### Description
Returns whether the FormItem associated with the given DOM element is in a consistent state with no pending operations. Returns null if the argument is not valid or isn't associated with an element representing a valid [FormItem](FormItem.md#class-formitem). Otherwise, returns true or false according as the conditions below are all satisfied:

*   page has finished loading
*   if the container widget of the item isn't the parent DynamicForm, then the container widget must satisfy [AutoTest.isCanvasDone](#classmethod-autotestiscanvasdone) (or [AutoTest.isGridDone](#classmethod-autotestisgriddone), etc., as appropriate)
*   the item cannot have any fetches in progress for missing display/value field values
*   picklists ([SelectItem](SelectItem.md#class-selectitem) or [ComboBoxItem](ComboBoxItem.md#class-comboboxitem)) cannot have any pending row fetches
*   any contained [FormItem](FormItem.md#class-formitem)s must satisfy `isItemDone()` themselves
*   any contained [Canvas](Canvas.md#class-canvas) must satisfy [AutoTest.isCanvasDone](#classmethod-autotestiscanvasdone) (or [AutoTest.isGridDone](#classmethod-autotestisgriddone), etc., as appropriate)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| element | [FormItem](#type-formitem)|[DOMElement](#type-domelement)|[AutoTestLocator](../reference_2.md#type-autotestlocator) | false | — | DOM element to test (element obtained from canvas or SmartClient locator if provided) |

### Returns

`[Boolean](#type-boolean)` — whether element is 'done' as described above

### Groups

- autoTest

---
## ClassMethod: AutoTest.isTileGridDone

### Description
Returns whether the TileGrid associated with the given DOM element is in a consistent state with no pending operations. Returns null if the argument is not valid or isn't associated with an element representing a valid TileGrid. Otherwise, returns true or false according as the conditions below are all satisfied:

*   page has finished loading
*   the TileGrid (as a tileLayout) satisfies [AutoTest.isTileLayoutDone](#classmethod-autotestistilelayoutdone)
*   the TileGrid has no pending layout animation operations queued

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| element | [Canvas](#type-canvas)|[DOMElement](#type-domelement)|[AutoTestLocator](../reference_2.md#type-autotestlocator) | false | — | DOM element to test (element obtained from canvas or SmartClient locator if provided) |

### Returns

`[Boolean](#type-boolean)` — whether element is 'done' as described above

### Groups

- autoTest

---
## ClassMethod: AutoTest.getLocatorWithIndicators

### Description
Returns the [QualityIndicatedLocator](../reference_2.md#object-qualityindicatedlocator) associated with some DOM element in a SmartClient application page. If coords, representing the page position, is passed in, the locator may be generated with a specific trailing "target area" identifer that will map back to the appropriate, potentially different, physical coordinates, even if the widget is moved. The coords argument will only have an effect in cases where the mouse position over the target could potentially change behavior.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| DOMElement | [DOMElement](#type-domelement) | false | — | DOM element within in the page. If null the locator for the last mouse event target will be generated |
| checkForNativeHandling | [boolean](../reference.md#type-boolean) | true | — | If this parameter is passed in, check whether the target element responds to native browser events directly rather than going through the SmartClient widget/event handling model. If we detect this case, return null rather than a live locator. This allows us to differentiate between (for example) an event on a Canvas handle, and an event occurring directly on a simple ``<a href=...>`` tag written inside a Canvas handle. |
| coords | [Array](#type-array) | true | — | X, Y page position |

### Returns

`[QualityIndicatedLocator](#type-qualityindicatedlocator)` — Locator details allowing the AutoTest subsystem to find an equivalent DOM element on subsequent page loads.

### Groups

- autoTest

---
## ClassMethod: AutoTest.getObject

### Description
Given an [AutoTestLocator](../reference_2.md#type-autotestlocator), return the live SmartClient object it refers to, if any.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| locator | [AutoTestLocator](../reference_2.md#type-autotestlocator) | false | — | Locator String previously returned by [AutoTest.getLocator](#classmethod-autotestgetlocator) |

### Returns

`[Canvas](#type-canvas)|[FormItem](#type-formitem)|[SectionStackSection](#type-sectionstacksection)` — target object, or null if unable to resolve the locator to a live object.

### Groups

- autoTest

---
## ClassMethod: AutoTest.clearVariable

### Description
Clear a [stored variable](#classmethod-autotestsetvariable).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| name | [String](#type-string) | false | — | name for the variable to clear |

---
## ClassMethod: AutoTest.setVariable

### Description
Store a named variable for later use in an autoTest.

Variables may be resolved dynamically by autoTest locators using the `${...}` notation. For example a locator containing the following substring:

`.../body/row[countryCode=${testRecord.countryCode}]/...`

Would resolve to the `countryCode` attributes of an object stored as `"testRecord"`.

This makes it possible to make portable tests where it is easy to modify the test conditions and identifiers for a specific data set.

See also [AutoTest.storeLocatorResult](#classmethod-autoteststorelocatorresult)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| name | [String](#type-string) | false | — | name for the variable |
| value | [Any](#type-any) | false | — | value to store for this variable |

---
## ClassMethod: AutoTest.getVariable

### Description
Retrieve a variable stored by [AutoTest.setVariable](#classmethod-autotestsetvariable) or [AutoTest.storeLocatorResult](#classmethod-autoteststorelocatorresult)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| name | [String](#type-string) | false | — | variable to retrieve |

### Returns

`[Any](#type-any)` — stored variable value

---
## ClassMethod: AutoTest.getElement

### Description
—

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| locator | [AutoTestLocator](../reference_2.md#type-autotestlocator) | false | — | Locator String previously returned by [AutoTest.getLocator](#classmethod-autotestgetlocator) |

### Returns

`[DOMElement](#type-domelement)` — DOM element this locator refers to in the running application, or null if not found

### Groups

- autoTest

---
## ClassMethod: AutoTest.isFormDone

### Description
Returns whether the DynamicForm associated with the given DOM element is in a consistent state with no pending operations. Returns null if the argument is not valid or isn't associated with an element representing a valid [DynamicForm](DynamicForm.md#class-dynamicform). Otherwise, returns true or false according as the conditions below are all satisfied:

*   page has finished loading
*   form has no pending delayed "set values" or "set values focus" operations
*   all contained items satisfy [AutoTest.isItemDone](#classmethod-autotestisitemdone)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| element | [Canvas](#type-canvas)|[DOMElement](#type-domelement)|[AutoTestLocator](../reference_2.md#type-autotestlocator) | false | — | DOM element to test (element obtained from canvas or SmartClient locator if provided) |

### Returns

`[Boolean](#type-boolean)` — whether element is 'done' as described above

### Groups

- autoTest

---
## ClassMethod: AutoTest.isGridDone

### Description
Returns whether the ListGrid associated with or contained by the given DOM element is in a consistent state with no pending operations. Returns null if the argument is not valid or isn't associated with an element inside a valid ListGrid. Otherwise, returns true or false according as the conditions below are all satisfied:

*   page has finished loading
*   no pending scroll operations
*   no pending filter editor operations
*   no unsaved edits to the grid records
*   no asynchronous regrouping operations are in progress
*   no outstanding fetch/filter operations are present for the ResultSet
*   no outstanding sort operations are present that will update the ListGrid

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| element | [Canvas](#type-canvas)|[DOMElement](#type-domelement)|[AutoTestLocator](../reference_2.md#type-autotestlocator) | false | — | DOM element to test (element obtained from canvas or SmartClient locator if provided) |

### Returns

`[Boolean](#type-boolean)` — whether element is 'done' as described above

### Groups

- autoTest

---
## ClassMethod: AutoTest.installLocatorShortcut

### Description
This method allows developers to retrieve locators for elements on the page via a key-combo plus mouseDown on the element in question.  
It may be invoked from a bookmarklet stored in the browser, giving developers a one-click way to retrieve locators for any SmartClient application

When installLocatorShortcut() is invoked, it will register a Page-level `mouseDown` handler which, if the Shift+Ctrl or Shift+Meta key-combo are being held down will display the locator for the element under the mouse in a text-box and also copy it to clipboard.

As with the [isc.showConsole()](../kb_topics/debugging.md#kb-topic-debugging) method, developers may wish to create a bookmark in their browser to quickly enable this functionality on any SmartClient application, without any changes to the application code:

1.  Create a new bookmark in your browser.
2.  Enter url "javascript:isc.AutoTest.installLocatorShortcut()".
3.  Label the bookmark as "Locator Shortcut"
4.  Consider adding this to the Bookmarks Toolbar. This allows you to enable the feature with a single click from any SmartClient application.

To uninstall the locator shortcut, call [AutoTest.uninstallLocatorShortcut](#classmethod-autotestuninstalllocatorshortcut)

---
