# Supported Browsers

[← Back to API Index](../reference.md)

---

## KB Topic: Supported Browsers

### Description
When considering which browser versions are supported, developers should consider which browser versions they wish to support within their application. Generally this will be a subset of what the framework supports, and should be decided based on the needs of your customers (typically corporate policies on browser usage for intranet applications, or general browser usage for customer facing applications).

The SmartClient framework supports all major browsers, and will always support the current versions at release-time.

The full list of SmartClient browser support (at the time of the initial SNAPSHOT_v15.0d_2025-12-03/EVAL Deployment release) is listed below. Note that support for some framework features may be implemented using different native approaches - or in rare cases, may be unavailable - in some older browser versions. Such cases are covered in documentation where they occur. For example, see the [skinning](skinning.md#kb-topic-skinning--theming) discussion about CSS3 mode.

At the application level, we'd typically recommend advertising support for the latest versions of Chrome, Safari and Firefox, the most recent Firefox ESR release and the most common (and most recent) versions of Internet Explorer.

#### Support for new browser versions introduced after SmartClient release
When new browser versions are released we will generally determine whether any issues are introduced by the new version, and update the most recent released SmartClient version to add support for these new browsers if changes are necessary. These changes will be made available in nightly patch builds.

Older branches of SmartClient may also be updated to support new browser versions. This will be considered on a case-by-case basis, depending on the effort required to work around any newly introduced browser bugs on these older branches.

#### Unsupported browser handling
Every distributed SmartClient skin contains an "Unsupported Browser" page. This is an optional placeholder for an application to state its browser support policies.

**The following browser versions were supported as of the original SNAPSHOT_v15.0d_2025-12-03/EVAL Deployment release**:

|  | Browser/Version | Operating System(s) |
|---|---|---|
|  | Edge 20.10240.16384.0+, 86.0.622.63+ | Windows/MacOS/iOS/Android |
|  | Firefox 4.x-82.x | Windows/MacOS/Linux |
|  | Safari 5.0-14.x | MacOS/Windows |
|  | Chrome 10.x-88.x | Windows/MacOS/Linux/ChromeOS |
|  | Opera 11.x-72.x | Windows/MacOS |
|  | Safari (mobile) | iOS 10+ |
|  | Android browser | Android 4.4+ |

### Related

- [Page.checkBrowserAndRedirect](../classes/Page.md#classmethod-pagecheckbrowserandredirect)
- [Page.getUnsupportedBrowserPromptString](../classes/Page.md#classmethod-pagegetunsupportedbrowserpromptstring)
- [Page.defaultUnsupportedBrowserURL](../classes/Page.md#classattr-pagedefaultunsupportedbrowserurl)
- [Page.unsupportedBrowserAction](../classes/Page.md#classattr-pageunsupportedbrowseraction)

---
