# File Assembly

[← Back to API Index](../reference.md)

---

## KB Topic: File Assembly

### Description
File assembly concatenates multiple files into a single response, reducing the number of HTTP fetches required to load a page. This concatenation also improves the compressibility of responses, since the compression algorithm may reduce redundancy across a larger data set.

The ISC FileAssembly service provides configuration-driven file assembly, with integrated compression and JavaScript stripping services. Assemblies are specified in an xml format and map a URI to a set of files to concatenate together. There also additional flags to enable stripping and compression.

You can use the FileAssembler to create assemblies of javascript and css. Since it's basically a file concatenator with some specialized services for javascript files, you could use it to assembly anything else, but javascript and css are probably the main things to consider.

The FileAssembler has a development mode and a production packaging mode. In the development mode, there is a servlet that you can register at virtual URLs that are assembled on the fly by the FileAssembler based on its configuration. For production packaging, you can use the same configuration file to generate static, pre-compressed versions of these files. The format of the file is as follows:

```
 <FileAssembly>
     <assemblies>
         <FileAssemblyEntry uri="/myAssembly.js">
             <compress>true</compress>
             <components>
                 <component>
                     <type>file</type>
                     <fileName>copyright.txt</fileName>
                 </component>
                 <component>
                     <type>datasource</type>
                     <name>myDatasource1</name>
                 </component>
                 <component>
                     <type>ds</type>
                     <name>myDatasource2</name>
                 </component>
                 <component>
                     <type>file</type>
                     <fileName>myPublicCode.js</fileName>
                 </component>
                 <component>
                     <type>file</type>
                     <fileName>myPrivateCode.js</fileName>
                     <jsStripping>full</jsStripping>
                 </component>
             </components>
         </FileAssemblyEntry>
     </assemblies>
 </FileAssembly>
 
```
You can specify as many FileAssemblyEntry blocks as you want, simply place them alongside each other under the `<assemblies>` element. The above example states that the /myAssembly.js file should be assembled from the various components listed above. Component blocks support the following attributes:

| Name | Values | Description |
|---|---|---|
| type | filexmlFileds\|datasourcetypeui | any fileXML fileISC DataSource fileISC SimpleType fileISC UI file |
| name | file identifier | identifier for a ds or ui file |
| fileName | file path | path to a file or xmlFile (relative to webRoot) |
| jsStripping | nonepartialfull | level of stripping (whitespace, comment, and delimiter removal) applied to file |

All component types except file are converted from valid ISC XML format to JavaScript format by the FileAssembler. The `jsStripping` attribute only applies to assembled javascript files.

Once you've created the configuration file, you'll probably want to place it somewhere in webRoot. Generally, it can be placed anywhere you like, but the development-time FileAssembly servlet requires the file be placed under webRoot. The default location is /isomorphicConfig/fileAssembly.xml and can be changed via the `configFile` init-param of the FileAssembly servlet. To enable development mode support for FileAssembly, you'll need to register the FileAssembly servlet in your web.xml as follows:

```
     <servlet>
       <servlet-name>FileAssembly</servlet-name>
       <servlet-class>com.isomorphic.servlet.FileAssembly</servlet-class>
     </servlet>
 
```
Now, for every FileAssemblyEntry URI you specified in your fileAssembly.xml, you'll need corresponding mappings in web.xml, to tell the servlet container to send requests for that file to the FileAssembler. For example, assuming your fileAssembly.xml contained the contents shown above, you'd register /myAssembly.js in your web.xml with the FileAssembler as follows:
```
     <servlet-mapping>
       <servlet-name>FileAssembly</servlet-name>
       <url-pattern>/myAssembly.js</url-pattern>
     </servlet-mapping>
 
```
You'll need a similar entry for any other entry in your fileAssembly.xml. Note that this is for development only - we'll pregenerate static files for production. Once you've done the above, you can load /myAssembly.js into your page via a standard SCRIPT block, like so:
```
 <script src="/myAssembly.js"></script>
 
```
Now, whenever requests are made for this file, the FileAssembler will check the timestamps of all the components of this assembly, rebuild the assembled file if required, and serve it to the browser as if it was a static file on disk.

To create static assembled files for production, you can use the fileAssembler command line tool provided as part of the SDK. This is a Java-based command line tool located in smartclientSDK/WEB-INF/bin. There are three versions of the tool in that directory - fileAssembler.bat is for Windows platforms, fileAssembler.command is for MacOS platforms, and fileAssembler.sh is for \*nix platforms. Running this tool with the --help argument will show you the command line switches available. Typically, you'll need to specify:

*   \--config `<file>` - location of the fileAssembly.xml configuration file
*   \--webRoot `<dir>` - location of the webRoot that the fileAssembler uses to access the component files.
*   \--outputDir `<dir>` - location of directory where you want output files to go - typically this is the webRoot of your production build. These are the files you'll deploy to production.

Finally, since the generated files are likely to be compressed and they're static, you'll probably want to map the FileDownload servlet to serve them in your production web.xml

---
