# <isomorphic:loadISC>

[← Back to API Index](../reference.md)

---

## KB Topic: <isomorphic:loadISC>

### Description
See [jspTags](../reference.md#kb-topic-smartclient-jsp-tags)

_produces:_ HTML

This tag sets window.isomorphicDir and loads a default set of SmartClient modules and a skin. SmartClient modules are JavaScript files that need to be loaded via ``<SCRIPT SRC=/some/filename.js>``</SCRIPT>`` blocks as part of the loading HTML page. These and [optional](loadingOptionalModules.md#kb-topic-loading-optional-modules) modules are stored in the `[webroot]/isomorphic/system/modules` directory. A skin defines the look and feel of your website and typically consists of at least one CSS file and some SmartClient UI Component default overrides. Skins are located in `[webroot]/isomorphic/skins`. Loading a skin consists of loading the corresponding `load_skin.js` - residing at top-level in each skin directory.

The default set of modules loaded by this tag are: `Core, Foundation, Containers, Grids, Forms, Drawing, DataBinding, Calendar`.  
The default skin is the `Tahoe` skin.  
So, for example inserting this into your JSP:

```
 <isomorphic:loadISC/>
 
```
Produces the output like:
```
 <SCRIPT>window.isomorphicDir='isomorphic/';</SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC_Core.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC_Foundation.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC_Containers.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC_Grids.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC_Forms.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC_Drawing.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC_DataBinding.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC_Calendar.js></SCRIPT>
 <SCRIPT src=isomorphic/skins/Tahoe/load_skin.js></SCRIPT>
 
```
_(Note: The output you see may differ slightly from the above. The isomorphicDir will be set to an appropriate value based on the location of the file in the file system, and the target URLs for resources may include version information as described in the **versionStyle** attribute details below.)_

**Tag Attributes:**

**skin**  
_value format_: Name of skin to load. See the `[webroot]/isomorphic/skins` directory for a list of available skins. You can also create your own skin by copying an existing skin directory recursively, modifying anything you need, and using your new skin name as the value here.  
_default value_: "Tahoe"

This selects a skin other than the default. The value of this attribute is used as a path component to `load_skin.js`. For example, specifying:

```
 <isomorphic:loadISC skin="Stratus"/>
 
```
Produces the following `load_skin.js` directive (in addition to all the standard module loads):
```
 <SCRIPT src=isomorphic/skins/Stratus/load_skin.js></SCRIPT>
 
```

**versionStyle**  
_value format_: one of "param", "pathSegment" or "none"  
_default value_: "param"

By default the URLs generated by a `loadISC` tag include version information. This ensures that the browser will reliably fetch new resources each time a new version of SmartClient is loaded, even if the browser has been instructed to cache these files indefinitely.

[The default setting of `"param"`](server_properties.md#kb-topic-serverproperties-file) appends a URL parameter of the format "`?isc_version=_SmartClient_Version_`" to each of the ``<SCRIPT SRC=... >`` tags used to load the framework.

The alternative setting of `"pathSegment"` instead adds a new segment to the URL path of the format "`isc_version._SmartClient_Version_`". The `"isc_version."` prefix is derived from the [isc.versionPathSegmentPrefix in server.properties](server_properties.md#kb-topic-serverproperties-file). The versioned path-segment will always be added after the isomorphicDir, so the generated output might look like this:

```
 <SCRIPT>window.isomorphicDir='isomorphic/isc_version.version';</SCRIPT>
 <SCRIPT SRC=isomorphic/isc_version.version/system/modules/ISC_Core.js></SCRIPT>
 <SCRIPT SRC=isomorphic/isc_version.version/system/modules/ISC_Foundation.js></SCRIPT>
 ... etc
 
```
Note that the `"param"` setting ensures that the browser will request new versions of the SmartClient JavaScript libraries, but does not ensure that other resources such as CSS and images under the skin directory will be re-fetched. The `"pathSegment"` setting ensures the browser will request new versions of all SmartClient resources. In order to support this, the SmartClient resources must be made available at the generated URLs. The server side FileDownload servlet, or the dedicated VersionedURLFilter filter will automatically handle stripping out SmartClient-version path segments - see the server side JavaDocs for details.

For more information on caching of resources see the [caching overview](caching.md#kb-topic-caching).

**skinDir**  
_value format_: path or URL up to and including the name of the skin  
_default value_: automatically derived from the value of the `skin` attribute

This attribute is usable in lieu of the `skin` attribute and allows you to specify the full path or URL to the directory containing the load\_skin.js for your skin. This allows you to move the directory containing the skin anywhere you want - including to a completely different server.

**includeModules**  
_value format_: Comma separated list of additional modules to load. See the `[webroot]/isomorphic/system/modules` directory for a list of loadable modules. The leading "ISC\_" is optional, spaces after commas are also optional.  
_default value_: NONE

This attribute allows you to specify SmartClient modules that you want to load in addition to the default set of modules. For example, specifying:

```
 <isomorphic:loadISC includeModules="Analytics"/>
 
```
Will add a tag to load the module to the generated block of `SCRIPT` tags described above:
```
 <SCRIPT SRC=isomorphic/system/modules/ISC_Analytics.js></SCRIPT>
 
```
SmartClient modules must be loaded in a particular order and may have dependencies on other modules. The `loadISC` automatically resolves any missing dependencies and includes them in the list of modules to load. The list of modules to load is also automatically reordered as required by this tag, so you can specify just the modules you care about, in any order, and `loadISC` will do the right thing.  
The skin will always be loaded after all modules.

**modules**  
_value format_: Comma separated list of modules to load. See the `[webroot]/isomorphic/system/modules` directory for a list of loadable modules. The leading "ISC\_" is optional, spaces after commas are also optional.  
_default value_: `"Core,Foundation,Containers,Grids,Forms,Drawing,DataBinding,Calendar"`

Specifying this attribute overrides the default set of modules loaded by `loadISC`. This is useful if you don't need to load all of the default modules on a particular page.

**locale**  
_value format_: String - name of locale to load _default value_: null

Use this attribute to specify a locale to load. The default value of null omits locale loading, which effectively means the framework default "en" locale is used. Note that if you're using a mix of `loadISC` and `loadModules` tags, or multiple `loadModules` tags, the right place to specify this attribute is on the last `loadModules` tag.

**isomorphicURI**  
_value format_: absolute or relative (from current URI) path to the `isomorphic` directory (by default, located in webRoot).  
_default value_: automatically derived

This value sets `window.isomorphicDir` and defines the base path to SmartClient modules from the currently executing JSP. By default, this value is automatically derived and you don't need to override it. Generally, an override is only required if you're pointing multiple web application deployments at one base URL for cache coherence reasons.

**defer**  
_value format_: boolean - acceptable values: "true" or "false"  
_default value_: "false"

This attribute applies only if you're using the optional Network Performance component of SmartClient. By default, the modules specified by the `loadISC` tag are loaded synchronously - that is, the browser waits for each module to download before rendering any HTML on the page. Specifying `defer="true"` makes the module load asynchronous. In this mode, all the page content except the modules specified by `loadISC` is loaded and rendered first, and then the SmartClient modules are loaded. The asynchronous mode makes it possible to render some content and allow the user to interact with the site immediately, while SmartClient modules load in the background.

Note that typically SmartClient modules are delivered compressed with cache headers, so the download delay really only affects first time users of your site, those whose cached versions have expired, or if you've upgraded your SmartClient module to a newer version that the user has cached.

Using this directive is equivalent to calling [FileLoader.load](../classes/FileLoader.md#classmethod-fileloaderload).

**cacheOnly**  
_value format_: boolean - acceptable values: "true" or "false"  
_default value_: "false"

This attribute applies only if you're using the optional Network Performance component of SmartClient. This works like `defer` (see above), except that the modules are only loaded into the browser cache, but not executed. This means that when the specified modules download, they'll be added to the browser cache, but will not be available to the execution context of the page. Actually executing the module code takes some processing time on the client, whereas simply caching it does not. The typical use case for this directive is on some intermediary page before the user gets to a SmartClient-enabled page. For example, you could include a cacheOnly `loadISC` tag on a login page that does not use SmartClient components, but protects a SmartClient-enabled application. While the user is typing in their credentials, the SmartClient modules will cache in the background, then once the user logs in and is sent to a SmartClient-enabled page, the modules are simply read from cache.

Using this directive is equivalent to calling [FileLoader.cache](../classes/FileLoader.md#classmethod-fileloadercache).

**onload**  
_value format_: String - any javascript code  
_default value_: NONE

This attribute applies only if you're using the optional Network Performance component of SmartClient. This attribute is usable in conjunction with `defer` and `cacheOnly` attributes. This attribute allows you to specify a callback to execute when loading or caching of the specified modules has completed. You can use this to, for example, replace portions of the page with SmartClient components once SmartClient has loaded.

The value of this attribute is passed as the `onload` handler to the generated [FileLoader.cache](../classes/FileLoader.md#classmethod-fileloadercache) or [FileLoader.load](../classes/FileLoader.md#classmethod-fileloaderload) call as appropriate.

**useSimpleNames**  
_value format_: boolean - acceptable values: "true" or "false"  
_default value_: "true"

Setting this attribute to false puts SmartClient in namespace mode. See [isc](../reference.md#object-isc) for more info.

---
