/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentArrayHolder;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.internal.AbstractCollectionInitializer;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ArrayInitializer
extends AbstractImmediateCollectionInitializer {
    private static final String CONCRETE_NAME = ArrayInitializer.class.getSimpleName();
    private final DomainResultAssembler<Integer> listIndexAssembler;
    private final DomainResultAssembler<?> elementAssembler;
    private final int indexBase;

    public ArrayInitializer(NavigablePath navigablePath, PluralAttributeMapping arrayDescriptor, FetchParentAccess parentAccess, LockMode lockMode, DomainResult<?> collectionKeyResult, DomainResult<?> collectionValueKeyResult, Fetch listIndexFetch, Fetch elementFetch, boolean isResultInitializer, AssemblerCreationState creationState) {
        super(navigablePath, arrayDescriptor, parentAccess, lockMode, collectionKeyResult, collectionValueKeyResult, isResultInitializer, creationState);
        this.listIndexAssembler = listIndexFetch.createAssembler(this, creationState);
        this.elementAssembler = elementFetch.createAssembler(this, creationState);
        this.indexBase = this.getCollectionAttributeMapping().getIndexMetadata().getListIndexBase();
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    @Override
    protected void forEachAssembler(Consumer<DomainResultAssembler<?>> consumer) {
        consumer.accept(this.listIndexAssembler);
        consumer.accept(this.elementAssembler);
    }

    public @Nullable PersistentArrayHolder<?> getCollectionInstance() {
        return (PersistentArrayHolder)super.getCollectionInstance();
    }

    @Override
    protected void readCollectionRow(CollectionKey collectionKey, List<Object> loadingState, RowProcessingState rowProcessingState) {
        Integer indexValue = this.listIndexAssembler.assemble(rowProcessingState);
        if (indexValue == null) {
            throw new HibernateException("Illegal null value for array index encountered while reading: " + this.getCollectionAttributeMapping().getNavigableRole());
        }
        Object element = this.elementAssembler.assemble(rowProcessingState);
        if (element == null) {
            return;
        }
        int index = indexValue;
        if (this.indexBase != 0) {
            index -= this.indexBase;
        }
        for (int i = loadingState.size(); i <= index; ++i) {
            loadingState.add(i, null);
        }
        loadingState.set(index, element);
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, RowProcessingState rowProcessingState) {
        Object[] array = (Object[])this.getInitializedPart().getValue(parentInstance);
        assert (array != null);
        this.collectionInstance = new PersistentArrayHolder(rowProcessingState.getSession(), array);
        this.state = AbstractCollectionInitializer.State.INITIALIZED;
        this.initializeSubInstancesFromParent(rowProcessingState);
    }

    @Override
    protected void initializeSubInstancesFromParent(RowProcessingState rowProcessingState) {
        Initializer initializer = this.elementAssembler.getInitializer();
        if (initializer != null) {
            Iterator iter = ((PersistentArrayHolder)this.getCollectionInstance()).elements();
            while (iter.hasNext()) {
                initializer.initializeInstanceFromParent(iter.next(), rowProcessingState);
            }
        }
    }

    public String toString() {
        return "ArrayInitializer{" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

