/* Auto-Generated React */
import React from 'react';
import 'smartclient-eval/release';
import 'smartclient-eval/skins/Tahoe';

import { SC, DynamicForm, HLayout, HStack, IButton, LGField, ListGrid, SelectItem, SortSpecifier, VLayout } from 'smartclient-eval/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

let onDsSelectorChanged = function (form, item, value) {
    if (value == 'UserIssues') {
        scienceStudiesLayout.hide();
        userIssuesLayout.show();
        worldLayout.hide();
    } else if (value == 'ScienceStudies') {
        scienceStudiesLayout.show();
        userIssuesLayout.hide();
        worldLayout.hide();
    } else {
        scienceStudiesLayout.hide();
        userIssuesLayout.hide();
        worldLayout.show();
    }
};
let onSortByRelevanceToIVPumpSafetyClick = function () {
    addAISummaryField({
        name: 'relevance',
        title: 'Relevance',
        width: 175,
        type: 'integer'
    }, this.prompt, lgScienceStudies);
    lgScienceStudies.setSort([
        {
            property: 'relevance',
            direction: 'descending'
        },
        {
            property: 'Study_ID',
            direction: 'ascending'
        }
    ]);
};
let onCustomPromptClick = function () {
    lgScienceStudies.addAISummaryField();
};
let onUrgencyClick = function () {
    addAISummaryField({
        name: 'urgencyLevel',
        title: 'Urgency Level',
        width: 175
    }, this.prompt, lgIssues);
    lgIssues.setSort([
        {
            property: 'urgencyLevel',
            direction: 'ascending'
        },
        {
            property: 'Issue_ID',
            direction: 'ascending'
        }
    ]);
};
let onImpactClick = function () {
    addAISummaryField({
        name: 'impactLevel',
        title: 'Impact Level',
        width: 175
    }, this.prompt, lgIssues);
    lgIssues.setSort([
        {
            property: 'impactLevel',
            direction: 'ascending'
        },
        {
            property: 'Issue_ID',
            direction: 'ascending'
        }
    ]);
};
let onCustomPromptClick1 = function () {
    lgIssues.addAISummaryField();
};
let onGridCellHover = function (record, rowNum, colNum) {
    if (this.cellValueIsClipped(rowNum, colNum))
        return;
    var field = this.getField(colNum);
    if (this.isValuePendingAsyncOrAsyncError(record, field))
        return;
    return false;
};
let onGridCellHoverHTML = function (record, rowNum, colNum) {
    var field = this.getField(colNum);
    if (this.isValuePendingAsync(record, field)) {
        return 'This value for ' + record.countryName + ' is being computed.';
    }
    return this.Super('cellHoverHTML', arguments);
};
let onGridUserRemovedField = function (field) {
    if (field.name == aiDemographicsFieldName) {
        addDemographicsButton.enable();
    } else if (field.name == aiReligionsFieldName) {
        addReligionsButton.enable();
    } else if (field.name == aiLandmarkFieldName) {
        addLandmarkButton.enable();
    }
};

var addDemographicsButton, aiDemographicsFieldName = 'aiDemographics', addReligionsButton, aiReligionsFieldName = 'aiReligions', addLandmarkButton, aiLandmarkFieldName = 'aiLandmark';
function addAISummaryField(fieldProps, aiFieldPrompt, listGrid) {
    var fields = listGrid.getFields();
    fields = fields.duplicate();
    var existingIndex = fields.findIndex('name', fieldProps.name);
    if (existingIndex >= 0)
        fields.removeAt(existingIndex);
    fieldProps = isc.addProperties({
        width: 180,
        wrap: true,
        showHover: true
    }, fieldProps);
    fieldProps.aiFieldPrompt = aiFieldPrompt;
    fields.addAt(fieldProps, existingIndex < 0 ? fields.length : existingIndex);
    listGrid.setFields(fields);
}

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <VLayout membersMargin="15" width="100%" height="100%">
        <members>
            <DynamicForm ID="form" width="600">
                <items>
                    <SelectItem name="dsSelector" title="DataSource" defaultValue="UserIssues" required="true" changed={onDsSelectorChanged}>
                        <valueMap>
                                <value>UserIssues</value>
                                <value>ScienceStudies</value>
                                <value>worldDS</value>
                        </valueMap>
                    </SelectItem>
                </items>
            </DynamicForm>
            <VLayout membersMargin="10" ID="scienceStudiesLayout" width="100%" height="100%" visibility="hidden">
                <members>
                    <HLayout membersMargin="10" ID="buttonLayoutScience" width="*">
                        <members>
                            <IButton title="Sort by Relevance to IV Pump Safety" width="260" prompt="Read each Abstract and assign it an importance score from 1 (least) to 10 (most) based on its relevance to IV Pump Safety" click={onSortByRelevanceToIVPumpSafetyClick}/>
                            <IButton title="Custom Prompt" click={onCustomPromptClick}/>
                        </members>
                    </HLayout>
                    <ListGrid ID="lgScienceStudies" dataSource="ScienceStudies" autoFetchData="true" width="100%" height="100%" sortViaAIMode="hybrid" canAddAISummaryFields="true">
                        <fields>
                            <LGField name="Study_ID" width="150"/>
                            <LGField name="Title" width="150" showHover="true" hoverWidth="300"/>
                            <LGField name="Authors" width="150"/>
                            <LGField name="Journal" width="150"/>
                            <LGField name="Year" width="150"/>
                            <LGField name="Abstract" width="*" showHover="true" hoverWidth="500"/>
                        </fields>
                    </ListGrid>
                </members>
            </VLayout>
            <VLayout membersMargin="15" ID="userIssuesLayout" width="100%" height="100%">
                <members>
                    <HLayout membersMargin="10" ID="buttonLayout" width="*">
                        <members>
                            <IButton title="Urgency" width="150" prompt="Assess the urgency to the Department of the reported issue" click={onUrgencyClick}/>
                            <IButton title="Impact" width="150" prompt="Select the issue category based on its impact: Critical (threatens core functions/safety), High (major disruptions needing immediate attention), Moderate (manageable disruptions), or Low (minimal effect on operations)" click={onImpactClick}/>
                            <IButton title="Custom Prompt" click={onCustomPromptClick1}/>
                        </members>
                    </HLayout>
                    <ListGrid ID="lgIssues" dataSource="UserIssues" autoFetchData="true" width="100%" height="100%" sortViaAIMode="hybrid" canAddAISummaryFields="true">
                        <fields>
                            <LGField name="Issue_ID" width="235"/>
                            <LGField name="Reported_By" width="125"/>
                            <LGField name="Department" width="235"/>
                            <LGField name="Category" width="235"/>
                            <LGField name="Issue_Description" width="235"/>
                        </fields>
                    </ListGrid>
                </members>
            </VLayout>
            <VLayout membersMargin="10" ID="worldLayout" width="100%" height="100%" visibility="hidden">
                <members>
                    <HStack members={[
    addDemographicsButton = isc.Button.create({
        autoDraw: false,
        autoFit: true,
        title: 'Add Demographics',
        prompt: 'A 2-4 sentence demographic and economic description of the country',
        click: function () {
            addAISummaryField({
                name: aiDemographicsFieldName,
                title: 'Demographics Summary',
                width: '*',
                minWidth: 300
            }, this.prompt, grid);
            this.disable();
        }
    }),
    addReligionsButton = isc.Button.create({
        autoDraw: false,
        autoFit: true,
        title: 'Add Religions',
        prompt: 'Most common religions, as a comma-separated list',
        click: function () {
            addAISummaryField({
                name: aiReligionsFieldName,
                title: 'Common Religions'
            }, this.prompt, grid);
            this.disable();
        }
    }),
    addLandmarkButton = isc.Button.create({
        autoDraw: false,
        autoFit: true,
        title: 'Add Landmark',
        prompt: 'Most famous landmark',
        click: function () {
            addAISummaryField({
                name: aiLandmarkFieldName,
                title: 'Famous Landmark'
            }, this.prompt, grid);
            this.disable();
        }
    }),
    isc.IButton.create({
        title: 'Custom Prompt',
        click: function () {
            grid.addAISummaryField();
        }
    })
]} membersMargin="8" height="*" autoDraw="false"/>
                    <ListGrid ID="grid" fixedRecordHeights="false" canHover="true" showHover="true" minFieldWidth="70" wrapCells="true" autoFitData="horizontal" autoFitWidthApproach="both" dataSource="worldDS" autoFetchData="true" width="100%" height="100%" autoDraw="false" dataFetchMode="paged" canAddAISummaryFields="true" showClippedValuesOnHover="true" cellHover={onGridCellHover} cellHoverHTML={onGridCellHoverHTML} userRemovedField={onGridUserRemovedField}>
                        <fields>
                            <LGField name="countryCode" title="Code" width="70"/>
                            <LGField name="countryName" width="235"/>
                            <LGField name="independence" title="Nationhood" width="125"/>
                            <LGField name="population" width="125"/>
                            <LGField name="gdp" width="125"/>
                        </fields>
                        <initialCriteria continent="South America"/>
                        <initialSort>
                            <SortSpecifier direction="ascending" property="countryName"/>
                        </initialSort>
                    </ListGrid>
                </members>
            </VLayout>
        </members>
    </VLayout>,
    document.getElementById(target)
);

if (isc.AI._spoofedAIGeneratedFieldsAIDEResponses)
    isc.AI.removeSpoofedResponses(isc.AI._spoofedAIGeneratedFieldsAIDEResponses);
isc.AI.addSpoofedResponses(isc.AI._spoofedAIGeneratedFieldsAIDEResponses = [
    {
        matchesPrompt: function (prompt) {
            return prompt.contains('a request to supplement the data in records from a DataSource') && prompt.contains('data-record index') && /The supplemental information requested for each record is:\s+most famous landmark\s+The records specified below are from the DataSource with the following description:/i.test(prompt);
        },
        makeAIResponse: function (aiRequest, aiEngine) {
            var mostFamousLandmarksByCountryName = {
                'Argentina': 'Obelisco de Buenos Aires',
                'Bolivia': 'Salar de Uyuni',
                'Brazil': 'Christ the Redeemer',
                'Chile': 'Easter Island',
                'Colombia': 'The Gold Museum',
                'Ecuador': 'The Middle of the World Monument',
                'Guyana': 'Kaieteur Falls',
                'Paraguay': 'The Grand Chaco',
                'Peru': 'Machu Picchu',
                'Suriname': 'The Saint Peter and Paul Cathedral',
                'Uruguay': 'Montevideo Metropolitan Cathedral',
                'Venezuela': 'Angel Falls'
            };
            var prompt = aiEngine.makePromptText(aiRequest), records = isc.AI._extractJsonResult(prompt, '[', ']'), results = [];
            for (var i = 0; i < records.length; ++i) {
                var record = records[i];
                results.push(mostFamousLandmarksByCountryName[record['countryName']]);
            }
            return {
                type: 'success',
                message: { content: { result: results } }
            };
        }
    },
    {
        matchesPrompt: function (prompt) {
            return prompt.contains('This is a request to gather information about a request to supplement') && /The supplemental data requested for each record is:\s*<supplemental-data-description>\s*most populous city\s*<\/supplemental-data-description>\s*Note: In the supplemental-data-description, ignore directions to/i.test(prompt);
        },
        value: {
            valueClass: 'general',
            relevantFieldNames: ['countryName']
        }
    },
    {
        matchesPrompt: function (prompt) {
            return prompt.contains('a request to supplement the data in records from a DataSource') && prompt.contains('data-record index') && /The supplemental information requested for each record is:\s+most populous city\s+The records specified below are from the DataSource with the following description:/i.test(prompt);
        },
        makeAIResponse: function (aiRequest, aiEngine) {
            var mostPopulousCityByCountryName = {
                'Argentina': 'Buenos Aires',
                'Bolivia': 'La Paz',
                'Brazil': 'São Paulo',
                'Chile': 'Santiago',
                'Colombia': 'Bogotá',
                'Ecuador': 'Quito',
                'Guyana': 'Georgetown',
                'Paraguay': 'Asunción',
                'Peru': 'Lima',
                'Suriname': 'Paramaribo',
                'Uruguay': 'Montevideo',
                'Venezuela': 'Caracas'
            };
            var prompt = aiEngine.makePromptText(aiRequest), records = isc.AI._extractJsonResult(prompt, '[', ']'), results = [];
            for (var i = 0; i < records.length; ++i) {
                var record = records[i];
                results.push(mostPopulousCityByCountryName[record['countryName']]);
            }
            return {
                type: 'success',
                message: { content: { result: results } }
            };
        }
    }
]);
