/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.cache;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.CacheIndex;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class CacheIndexMetadata
extends ORMetadata {
    private List<String> m_columnNames = new ArrayList<String>();
    private Boolean updateable;

    public CacheIndexMetadata() {
        super("<cache-index>");
    }

    public CacheIndexMetadata(MetadataAnnotation index, MetadataAccessor accessor) {
        super(index, accessor);
        if (index != null) {
            Object[] objectArray = (Object[])index.getAttributeArray("columnNames");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object columnName = objectArray[n2];
                this.m_columnNames.add((String)columnName);
                ++n2;
            }
            this.updateable = (Boolean)index.getAttribute("updateable");
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof CacheIndexMetadata) {
            CacheIndexMetadata index = (CacheIndexMetadata)objectToCompare;
            if (this.updateable != index.getUpdateable()) {
                return false;
            }
            return this.m_columnNames.equals(index.getColumnNames());
        }
        return false;
    }

    public List<String> getColumnNames() {
        return this.m_columnNames;
    }

    public Boolean getUpdateable() {
        return this.updateable;
    }

    public void process(MetadataDescriptor descriptor, String defaultColumnName) {
        if (this.m_columnNames.isEmpty() && defaultColumnName != null) {
            descriptor.getClassDescriptor().getCachePolicy().addCacheIndex(defaultColumnName);
        } else {
            CacheIndex index = new CacheIndex();
            if (this.updateable != null) {
                index.setIsUpdateable(this.updateable);
            }
            for (String column : this.m_columnNames) {
                index.addFieldName(column);
            }
            descriptor.getClassDescriptor().getCachePolicy().addCacheIndex(index);
        }
    }

    public void setColumnNames(List<String> columnNames) {
        this.m_columnNames = columnNames;
    }

    public void setUpdateable(Boolean updateable) {
        this.updateable = updateable;
    }
}

