/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.classic.Lifecycle;
import org.hibernate.classic.Validatable;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.tuple.component.ComponentMetamodel;
import org.hibernate.type.AnyType;
import org.hibernate.type.ArrayType;
import org.hibernate.type.BagType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.CustomCollectionType;
import org.hibernate.type.CustomType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.IdentifierBagType;
import org.hibernate.type.ListType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MapType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.OrderedMapType;
import org.hibernate.type.OrderedSetType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.SetType;
import org.hibernate.type.SortedMapType;
import org.hibernate.type.SortedSetType;
import org.hibernate.type.SpecialOneToOneType;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeFactory
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TypeFactory.class);
    private final TypeScopeImpl typeScope = new TypeScopeImpl();

    public void injectSessionFactory(SessionFactoryImplementor factory) {
        this.typeScope.injectSessionFactory(factory);
    }

    public Type byClass(Class clazz, Properties parameters) {
        if (Type.class.isAssignableFrom(clazz)) {
            return this.type(clazz, parameters);
        }
        if (CompositeUserType.class.isAssignableFrom(clazz)) {
            return this.customComponent(clazz, parameters);
        }
        if (UserType.class.isAssignableFrom(clazz)) {
            return this.custom(clazz, parameters);
        }
        if (Lifecycle.class.isAssignableFrom(clazz) || Validatable.class.isAssignableFrom(clazz)) {
            return this.manyToOne(clazz.getName());
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return TypeFactory.serializable(clazz);
        }
        return null;
    }

    public Type type(Class<Type> typeClass, Properties parameters) {
        try {
            Type type = typeClass.newInstance();
            TypeFactory.injectParameters(type, parameters);
            return type;
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate Type: " + typeClass.getName(), e);
        }
    }

    public static void injectParameters(Object type, Properties parameters) {
        if (ParameterizedType.class.isInstance(type)) {
            ((ParameterizedType)type).setParameterValues(parameters);
        } else if (parameters != null && !parameters.isEmpty()) {
            throw new MappingException("type is not parameterized: " + type.getClass().getName());
        }
    }

    public CompositeCustomType customComponent(Class<CompositeUserType> typeClass, Properties parameters) {
        return TypeFactory.customComponent(typeClass, parameters, this.typeScope);
    }

    public static CompositeCustomType customComponent(Class<CompositeUserType> typeClass, Properties parameters, TypeScope scope) {
        try {
            CompositeUserType userType = typeClass.newInstance();
            TypeFactory.injectParameters(userType, parameters);
            return new CompositeCustomType(userType);
        }
        catch (Exception e) {
            throw new MappingException("Unable to instantiate custom type: " + typeClass.getName(), e);
        }
    }

    public CollectionType customCollection(String typeName, Properties typeParameters, String role, String propertyRef, boolean embedded) {
        Class typeClass;
        try {
            typeClass = ReflectHelper.classForName(typeName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("user collection type class not found: " + typeName, cnfe);
        }
        CustomCollectionType result = new CustomCollectionType(this.typeScope, typeClass, role, propertyRef, embedded);
        if (typeParameters != null) {
            TypeFactory.injectParameters(result.getUserType(), typeParameters);
        }
        return result;
    }

    public CustomType custom(Class<UserType> typeClass, Properties parameters) {
        return TypeFactory.custom(typeClass, parameters, this.typeScope);
    }

    public static CustomType custom(Class<UserType> typeClass, Properties parameters, TypeScope scope) {
        try {
            UserType userType = typeClass.newInstance();
            TypeFactory.injectParameters(userType, parameters);
            return new CustomType(userType);
        }
        catch (Exception e) {
            throw new MappingException("Unable to instantiate custom type: " + typeClass.getName(), e);
        }
    }

    public static <T extends Serializable> SerializableType<T> serializable(Class<T> serializableClass) {
        return new SerializableType<T>(serializableClass);
    }

    public EntityType oneToOne(String persistentClass, ForeignKeyDirection foreignKeyType, String uniqueKeyPropertyName, boolean lazy, boolean unwrapProxy, boolean isEmbeddedInXML, String entityName, String propertyName) {
        return new OneToOneType(this.typeScope, persistentClass, foreignKeyType, uniqueKeyPropertyName, lazy, unwrapProxy, isEmbeddedInXML, entityName, propertyName);
    }

    public EntityType specialOneToOne(String persistentClass, ForeignKeyDirection foreignKeyType, String uniqueKeyPropertyName, boolean lazy, boolean unwrapProxy, String entityName, String propertyName) {
        return new SpecialOneToOneType(this.typeScope, persistentClass, foreignKeyType, uniqueKeyPropertyName, lazy, unwrapProxy, entityName, propertyName);
    }

    public EntityType manyToOne(String persistentClass) {
        return new ManyToOneType(this.typeScope, persistentClass);
    }

    public EntityType manyToOne(String persistentClass, boolean lazy) {
        return new ManyToOneType(this.typeScope, persistentClass, lazy);
    }

    public EntityType manyToOne(String persistentClass, String uniqueKeyPropertyName, boolean lazy, boolean unwrapProxy, boolean isEmbeddedInXML, boolean ignoreNotFound, boolean isLogicalOneToOne) {
        return new ManyToOneType(this.typeScope, persistentClass, uniqueKeyPropertyName, lazy, unwrapProxy, isEmbeddedInXML, ignoreNotFound, isLogicalOneToOne);
    }

    public CollectionType array(String role, String propertyRef, boolean embedded, Class elementClass) {
        return new ArrayType(this.typeScope, role, propertyRef, elementClass, embedded);
    }

    public CollectionType list(String role, String propertyRef, boolean embedded) {
        return new ListType(this.typeScope, role, propertyRef, embedded);
    }

    public CollectionType bag(String role, String propertyRef, boolean embedded) {
        return new BagType(this.typeScope, role, propertyRef, embedded);
    }

    public CollectionType idbag(String role, String propertyRef, boolean embedded) {
        return new IdentifierBagType(this.typeScope, role, propertyRef, embedded);
    }

    public CollectionType map(String role, String propertyRef, boolean embedded) {
        return new MapType(this.typeScope, role, propertyRef, embedded);
    }

    public CollectionType orderedMap(String role, String propertyRef, boolean embedded) {
        return new OrderedMapType(this.typeScope, role, propertyRef, embedded);
    }

    public CollectionType sortedMap(String role, String propertyRef, boolean embedded, Comparator comparator) {
        return new SortedMapType(this.typeScope, role, propertyRef, comparator, embedded);
    }

    public CollectionType set(String role, String propertyRef, boolean embedded) {
        return new SetType(this.typeScope, role, propertyRef, embedded);
    }

    public CollectionType orderedSet(String role, String propertyRef, boolean embedded) {
        return new OrderedSetType(this.typeScope, role, propertyRef, embedded);
    }

    public CollectionType sortedSet(String role, String propertyRef, boolean embedded, Comparator comparator) {
        return new SortedSetType(this.typeScope, role, propertyRef, comparator, embedded);
    }

    public ComponentType component(ComponentMetamodel metamodel) {
        return new ComponentType(this.typeScope, metamodel);
    }

    public EmbeddedComponentType embeddedComponent(ComponentMetamodel metamodel) {
        return new EmbeddedComponentType(this.typeScope, metamodel);
    }

    public Type any(Type metaType, Type identifierType) {
        return new AnyType(metaType, identifierType);
    }

    private static class TypeScopeImpl
    implements TypeScope {
        private SessionFactoryImplementor factory;

        private TypeScopeImpl() {
        }

        public void injectSessionFactory(SessionFactoryImplementor factory) {
            if (this.factory != null) {
                log.warn("Scoping types to session factory {} after already scoped {}", (Object)this.factory, (Object)factory);
            } else {
                log.trace("Scoping types to session factory {}", (Object)factory);
            }
            this.factory = factory;
        }

        public SessionFactoryImplementor resolveFactory() {
            if (this.factory == null) {
                throw new HibernateException("SessionFactory for type scoping not yet known");
            }
            return this.factory;
        }
    }

    public static interface TypeScope
    extends Serializable {
        public SessionFactoryImplementor resolveFactory();
    }
}

