/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.MysqlDriver;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ISCSystem;
import java.io.File;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OracleDriver
extends SQLDriver {
    private static Logger log = new Logger(OracleDriver.class.getName());
    public static final int UNIQUE_CONSTRAINT_VIOLATED = 1;
    static Map newEscapeSyntax = new HashMap();
    protected boolean _supportsSQLLimit = this.driverConfig.getBoolean((Object)"supportsSQLLimit", false);

    private static boolean useNewEscapeSyntax(String dbName) {
        if (!newEscapeSyntax.containsKey(dbName)) {
            if (config.get((Object)"sql.oracle.encloseEscapeClauseInBraces") != null) {
                newEscapeSyntax.put(dbName, !config.getBoolean((Object)"sql.oracle.encloseEscapeClauseInBraces", false));
            } else {
                newEscapeSyntax.put(dbName, Boolean.TRUE);
            }
        }
        return (Boolean)newEscapeSyntax.get(dbName);
    }

    public OracleDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public boolean supportsNativeReplace() {
        return false;
    }

    @Override
    public boolean supportsSQLLimit() {
        return this._supportsSQLLimit;
    }

    @Override
    public String limitQuery(String query, long startRow, long batchSize, List outputColumns, DSRequest req) {
        DataSource ds = null;
        try {
            ds = req.getDataSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean useHint = true;
        if (ds != null) {
            useHint = DataTools.getBoolean((Map)ds.getConfig(), (Object)"sqlUsePagingHint", (boolean)true);
            DataTypeMap opConfig = ds.getOperationBinding(req);
            if (opConfig != null && opConfig.containsKey("sqlUsePagingHint")) {
                useHint = DataTools.getBoolean((Map)opConfig, (Object)"sqlUsePagingHint", (boolean)true);
            }
        }
        query = "SELECT * FROM (SELECT " + (useHint ? "/*+ FIRST_ROWS(" + batchSize + ") */ " : "") + "a.*, rownum myrownum FROM (" + query + ") a where rownum <=" + (startRow + batchSize) + ") WHERE myrownum >= " + (startRow + 1L);
        return query;
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        if (this.dbConnection == null && req == null) {
            throw new Exception("no existing db connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        for (String sequenceName : sequencesNotPresent) {
            String sequence = this.getCurrentSequenceValue(sequenceName, ds);
            if (sequence == null) continue;
            Object obj = OracleDriver.getScalarResult("SELECT " + sequence + " FROM DUAL", this.dbConnection, this.dbName, this, req);
            BigDecimal value = new BigDecimal(obj.toString());
            primaryKeys.put(sequenceName, value.toString());
        }
        return primaryKeys;
    }

    @Override
    public String formatValue(Object value) {
        return value.toString();
    }

    @Override
    public String sqlInTransform(Object value, DSField field, SQLDataSource ds, boolean addLiteralPrefix) throws Exception {
        long start = System.currentTimeMillis();
        boolean isText = false;
        if (field != null) {
            try {
                isText = ds.simpleTypeInheritsFrom(field.getType(), "text");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof java.util.Date && (field == null || field.get((Object)"sqlStorageStrategy") == null)) {
            long timeStamp = ((java.util.Date)value).getTime();
            boolean isDateTime = false;
            try {
                isDateTime = ds.simpleTypeInheritsFrom(field.getType(), "datetime");
            }
            catch (Exception ignored) {
                isDateTime = true;
            }
            if (isDateTime) {
                String dateTime = this.formatTimestamp(timeStamp, isDateTime, ds, field);
                if (field != null && field.shouldStoreMilliseconds()) {
                    String format = config.getString((Object)"sql.defaultDateTimeFormatWithMilliseconds");
                    return "TO_TIMESTAMP(" + this.escapeValue(dateTime) + ",'" + format + "')";
                }
                String format = config.getString((Object)"sql.defaultDateTimeFormat");
                return "TO_DATE(" + this.escapeValue(dateTime) + ",'" + format + "')";
            }
            String date = this.formatDate(timeStamp);
            String format = config.getString((Object)"sql.defaultDateFormat");
            return "TO_DATE(" + this.escapeValue(date) + ",'" + format + "')";
        }
        if (isText) {
            if (this.supportsLongVarchar() || !this.fieldAssignableInline(field)) {
                return this.escapeValue(value);
            }
            String strValue = value.toString();
            if (strValue.length() <= 1000) {
                return this.escapeValue(strValue);
            }
            List chunks = DataTools.splitByLength((String)strValue, (int)1000);
            StringBuffer buffer = new StringBuffer();
            boolean first = true;
            for (String chunk : chunks) {
                if (first) {
                    first = false;
                    buffer.append("TO_CLOB(");
                    buffer.append(this.escapeValue(chunk));
                    buffer.append(")");
                    continue;
                }
                buffer.append(" || ");
                buffer.append(this.escapeValue(chunk));
            }
            String rtnVal = buffer.toString();
            long elapsed = System.currentTimeMillis() - start;
            log.debug((Object)("sqlInTransform took " + elapsed + "ms"));
            return rtnVal;
        }
        return super.sqlInTransform(value, field, ds, addLiteralPrefix);
    }

    @Override
    public String sqlStringComparisonRValue(String value, String operator) {
        if (this.supportsLongVarchar() || value.length() <= 998) {
            return super.sqlStringComparisonRValue(value, operator);
        }
        StringBuffer sql = new StringBuffer();
        List chunks = DataTools.splitByLength((String)value, (int)998);
        int l = chunks.size();
        for (int i = 0; i < l; ++i) {
            String chunk = (String)chunks.get(i);
            if (i == 0) {
                sql.append("TO_CLOB(");
                if ((operator.contains("ndsWith") || operator.contains("tains")) && !value.startsWith("%")) {
                    chunk = "%" + chunk;
                }
                sql.append(this.escapeValue(chunk));
                sql.append(")");
                continue;
            }
            if (i == l - 1 && (operator.contains("rtsWith") || operator.contains("tains")) && !value.endsWith("%")) {
                chunk = chunk + "%";
            }
            sql.append(" || ");
            sql.append(this.escapeValue(chunk));
        }
        return sql.toString();
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        boolean forceRemap = false;
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName, String functionName, Map functionParams) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (tableName != null) {
            output = tableName + "." + output;
        }
        if (functionName != null && !"".equals(functionName)) {
            if ("CONCAT".equals(functionName.toUpperCase())) {
                String prefix = "";
                String suffix = "";
                String delimiter = ", ";
                if (functionParams != null) {
                    prefix = functionParams.get("joinPrefix") == null ? prefix : (String)functionParams.get("joinPrefix");
                    suffix = functionParams.get("joinSuffix") == null ? suffix : (String)functionParams.get("joinSuffix");
                    delimiter = functionParams.get("joinString") == null ? delimiter : (String)functionParams.get("joinString");
                }
                output = "LISTAGG ('" + prefix + "' || " + output + " || '" + suffix + "', '" + delimiter + "') WITHIN GROUP (ORDER BY " + output + ")";
            } else {
                output = functionName + "(" + output + ")";
            }
            if (remapName != null) {
                output = output + " AS " + this.escapeColumnName(remapName);
            }
        } else if (remapName != null && !remapName.equals(columnName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        return output;
    }

    @Override
    public int getMaximumSetSize() {
        return 1000;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    @Override
    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (escapeForFilter) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    public String escapeClause() {
        if (OracleDriver.useNewEscapeSyntax(this.dbName)) {
            return " ESCAPE'\\' ";
        }
        return " {ESCAPE '\\'}";
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName, dataSource);
        if (sequenceName == null) {
            return null;
        }
        String schema = "";
        if (dataSource != null) {
            schema = (String)dataSource.getConfig().get((Object)"schema");
            schema = schema == null ? "" : schema + ".";
        }
        return schema + sequenceName + ".NextVal";
    }

    public String getCurrentSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName);
        if (sequenceName == null) {
            return null;
        }
        String schema = "";
        if (dataSource != null) {
            schema = (String)dataSource.getConfig().get((Object)"schema");
            schema = schema == null ? "" : schema + ".";
        }
        return schema + sequenceName + ".CurrVal";
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "DECODE(" + column;
        for (String actualValue : valueMap.keySet()) {
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(actualValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + ", '" + actualValue + "', " + displayValue;
        }
        expr = expr + ", " + column + ")";
        return expr;
    }

    public boolean supportsLongVarchar() {
        return false;
    }

    @Override
    public boolean fieldAssignableInline(DSField field) {
        String fieldType = field.getType();
        Long fieldLength = field.getLength();
        return super.fieldAssignableInline(field) && (fieldLength == null || fieldLength <= 1000L);
    }

    @Override
    public boolean shouldSetFetchSizeForStreaming() {
        return false;
    }

    @Override
    public Object modifyTemporalObject(Object obj, ResultSet rs, int ii) throws SQLException {
        Timestamp work = rs.getTimestamp(ii);
        if (work == null) {
            return obj;
        }
        return new Date(work.getTime());
    }

    @Override
    public String blankComparison(String fieldName, String operator) {
        if (fieldName == null) {
            return null;
        }
        if ("isBlank".equals(operator)) {
            return "(" + fieldName + " IS NULL OR LENGTH(" + fieldName + ")=0)";
        }
        return "(" + fieldName + " IS NOT NULL AND LENGTH(" + fieldName + ")>0)";
    }

    @Override
    public String generateJoinClause(String escapedTo, String escapedFrom, Relation relation) {
        return escapedFrom + " = " + escapedTo + (relation.getJoinType() == 1 ? "(+)" : "");
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName == null ? null : objectName.toUpperCase();
    }

    @Override
    public String getDummyQuery() {
        return "SELECT 1 FROM dual";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSnapshot(File snapshotFile) throws Exception {
        snapshotFile.deleteOnExit();
        String snapshotFileName = snapshotFile.getCanonicalPath();
        String cmd = "db --name=" + this.dbName + " snapshot " + this.defaultSchemaName + " " + snapshotFileName;
        Class<MysqlDriver> clazz = MysqlDriver.class;
        synchronized (MysqlDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreFromSnapshot(File snapshotFile) throws Exception {
        String snapshotFileName = snapshotFile.getCanonicalPath();
        String cmd = "db --name=" + this.dbName + " restore " + this.defaultSchemaName + " " + snapshotFileName;
        Class<MysqlDriver> clazz = MysqlDriver.class;
        synchronized (MysqlDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSandbox(String sandboxName) throws Exception {
        String sandboxMechanism = this.sqlConfig.getString((Object)"sandbox.mechanism", "schema");
        if (!"workspace".equals(sandboxMechanism)) {
            throw new Exception("Oracle driver currently supports sandboxing only via workspaces. You must set sql." + this.dbName + ".sandbox.mechanism: sandbox in server.properties");
        }
        Connection conn = this.getOrCreateConnection();
        CallableStatement cs = conn.prepareCall("CALL DBMS_WM.CreateWorkspace('" + sandboxName + "')");
        try {
            cs.execute();
        }
        catch (Exception e) {
            log.error((Object)("Unable to create workspace: " + sandboxName), (Throwable)e);
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSandbox(String sandboxName) throws Exception {
        String sandboxMechanism = this.sqlConfig.getString((Object)"sandbox.mechanism", "schema");
        if (!"workspace".equals(sandboxMechanism)) {
            throw new Exception("Oracle driver currently supports sandboxing only via workspaces. You must set sql." + this.dbName + ".sandbox.mechanism: sandbox in server.properties");
        }
        Connection conn = this.getOrCreateConnection();
        CallableStatement cs = conn.prepareCall("CALL DBMS_WM.RemoveWorkspace('" + sandboxName + "')");
        try {
            cs.execute();
        }
        catch (Exception e) {
            log.error((Object)("Unable to remove workspace: " + sandboxName), (Throwable)e);
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }
}

