/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.file.ISCRelativeFile;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.keyvalue.MultiKey;

public class ProjectFileDataSource
extends BasicDataSource {
    private static Logger log = new Logger(ProjectFileDataSource.class.getName());
    private static final String PROJECT_FILE_KEY = "projectFileKey";
    private static final String PROJECT_FILE_LOCATIONS = "projectFileLocations";
    protected ArrayDeque<ISCFile> projectFileLocations = null;

    public List<String> getProjectFileLocations() {
        if (this.projectFileLocations == null) {
            return null;
        }
        ArrayList<String> locations = new ArrayList<String>(this.projectFileLocations.size());
        for (ISCFile file : this.projectFileLocations) {
            try {
                locations.add(file.getCanonicalPath());
            }
            catch (IOException ex) {
                locations.add(null);
            }
        }
        return locations;
    }

    @Override
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        super.init(theConfig, dsRequest);
        String projectFileKey = (String)this.dsConfig.get(PROJECT_FILE_KEY);
        if (projectFileKey != null) {
            String configString = Config.getGlobal().getString("project." + projectFileKey);
            if (configString == null) {
                log.warn("DataSource " + this.getID() + ": Could not find project." + projectFileKey + " in the global Config");
            } else {
                List<String> locations = DataTools.commaSeparatedStringToList(configString);
                this.projectFileLocations = new ArrayDeque(locations.size());
                for (String location : locations) {
                    this.projectFileLocations.add(ISCFile.newInstance(location));
                }
            }
        }
        if (theConfig.containsKey(PROJECT_FILE_LOCATIONS)) {
            Object locations = this.dsConfig.get(PROJECT_FILE_LOCATIONS);
            if (locations instanceof Collection) {
                Collection collection = (Collection)locations;
                if (this.projectFileLocations == null) {
                    this.projectFileLocations = new ArrayDeque(collection.size());
                }
                for (String location : collection) {
                    Config.getGlobal();
                    String expandedLocation = Config.expandPathVariables(location, false, true);
                    this.projectFileLocations.add(ISCFile.newInstance(expandedLocation));
                }
            } else {
                log.error("<projectFileLocations> had unexpected class: " + locations.getClass().getName());
            }
        }
        if (this.projectFileLocations == null) {
            log.error("DataSource " + this.getID() + " requires either projectFileKey or projectFileLocations to be configured.");
        }
    }

    protected ISCRelativeFile findExistingFileInLocations(Map<String, Object> values, DSRequest request) throws IOException {
        Iterator<ISCFile> iter = this.projectFileLocations.descendingIterator();
        while (iter.hasNext()) {
            ISCFile location = iter.next();
            ISCFile file = location.getChild(values, request);
            if (!file.exists()) continue;
            return new ISCRelativeFile(location, file);
        }
        return null;
    }

    protected ISCRelativeFile makeNewFile(Map<String, Object> values, DSRequest request) throws IOException {
        ISCFile lastLocation = this.projectFileLocations.getLast();
        ISCFile child = lastLocation.getChild(values, request);
        return new ISCRelativeFile(lastLocation, child);
    }

    @Override
    public DSResponse executeFileSource(DSRequest req) throws Exception {
        String operationType = req.getOperationType();
        DSResponse response = new DSResponse(this);
        response.setDropExtraFields(false);
        if ("listFiles".equals(operationType)) {
            LinkedHashMap<MultiKey, Map> data = new LinkedHashMap<MultiKey, Map>();
            Object criteria = req.getIsAdvancedCriteria() ? req.getAdvancedCriteria() : req.getCriteria();
            for (ISCFile location : this.projectFileLocations) {
                List<Map<String, Object>> children = location.findChildAttributes(criteria, req);
                for (Map map : children) {
                    MultiKey key = new MultiKey(map.get("fileName"), map.get("fileType"), map.get("fileFormat"));
                    data.put(key, map);
                }
            }
            Collection attributes = data.values();
            response.setData(attributes);
        } else {
            Map existingFileValues = "renameFile".equals(operationType) ? req.getOldValues() : req.getValues();
            this.warnFileSourceField(existingFileValues, "not provided for fileSource:" + operationType + " operation", "fileName", "fileType", "fileFormat");
            ISCRelativeFile existingFile = this.findExistingFileInLocations(existingFileValues, req);
            if ("hasFile".equals(operationType)) {
                if (existingFile == null) {
                    response.setData(new ArrayList(0));
                } else {
                    response.setData(DataTools.makeList(existingFile.readRelativeAttributes()));
                }
            } else if ("getFile".equals(operationType)) {
                if (existingFile == null) {
                    response.setData(new ArrayList(0));
                } else {
                    response.setData(DataTools.makeList(existingFile.readRelativeAttributes()));
                    String contents = existingFile.getAsString();
                    response.setFieldValue("fileContents", contents);
                }
            } else if ("saveFile".equals(operationType)) {
                Object contents;
                if (existingFile == null) {
                    existingFile = this.makeNewFile(existingFileValues, req);
                }
                if ((contents = existingFileValues.get("fileContents")) == null) {
                    throw new IllegalStateException("no contents provided to saveFile operation");
                }
                if (!(contents instanceof String)) {
                    throw new IllegalStateException("contents provided to saveFile had unsupported class: " + contents.getClass().getName());
                }
                Writer writer = existingFile.getWriter();
                writer.write((String)contents);
                writer.flush();
                writer.close();
                response.setData(DataTools.makeList(existingFile.readRelativeAttributes()));
                response.setAffectedRows(1L);
                response.setInvalidateCache(true);
            } else if ("renameFile".equals(operationType)) {
                if (existingFile == null) {
                    response.setFailure("source file does not exist");
                } else {
                    Map newFileValues = req.getValues();
                    ISCRelativeFile newFile = existingFile.getRelativeChild(newFileValues, req);
                    if (newFile.exists()) {
                        response.setFailure("destination file already exists");
                    } else {
                        boolean success = existingFile.renameTo(newFile);
                        if (success) {
                            response.setData(DataTools.makeList(newFile.readRelativeAttributes()));
                            response.setAffectedRows(1L);
                            response.setInvalidateCache(true);
                        } else {
                            response.setFailure("error renaming file -- check server logs");
                        }
                    }
                }
            } else if ("removeFile".equals(operationType) && existingFile != null) {
                boolean success = existingFile.delete();
                if (success) {
                    response.setData(DataTools.makeList(existingFileValues));
                    response.setAffectedRows(1L);
                    response.setInvalidateCache(true);
                } else {
                    response.setFailure("unable to delete file -- check server logs");
                }
            }
        }
        this.convertXmlToJsIfRequested(req, response);
        return response;
    }

    @Override
    public DSResponse executeAdd(DSRequest req) throws Exception {
        req.setOperationType("saveFile");
        return this.executeFileSource(req);
    }

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        req.setOperationType("listFiles");
        return this.executeFileSource(req);
    }

    @Override
    public DSResponse executeUpdate(DSRequest req) throws Exception {
        req.setOperationType("renameFile");
        req.setOldValues(req.getCriteria());
        return this.executeFileSource(req);
    }

    @Override
    public DSResponse executeRemove(DSRequest req) throws Exception {
        req.setOperationType("removeFile");
        req.setValues(req.getCriteria());
        return this.executeFileSource(req);
    }
}

