/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.io.file;

import com.isomorphic.criteria.Evaluator;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.VFS;

public class ISCVfsFile
extends ISCFile {
    private static Logger log = new Logger(ISCFile.class.getName());
    FileObject fileObject;

    public ISCVfsFile(String path, DSRequest request) throws IOException {
        super(path, request);
        this.fileObject = VFS.getManager().resolveFile(path);
    }

    public ISCVfsFile(String path) throws IOException {
        this(path, null);
    }

    public ISCVfsFile(FileObject fileObject, DSRequest request) {
        super(null, request);
        if (fileObject == null) {
            throw new IllegalArgumentException("fileObject cannot be null");
        }
        this.fileObject = fileObject;
    }

    public ISCVfsFile(FileObject fileObject) {
        this(fileObject, null);
    }

    @Override
    public Object getNativeHandler() {
        return this.fileObject;
    }

    @Override
    public boolean delete() throws IOException {
        return this.fileObject.delete();
    }

    @Override
    public boolean renameTo(ISCFile destination) {
        Object handler = destination.getNativeHandler();
        if (handler instanceof FileObject) {
            FileObject nativeDestination = (FileObject)handler;
            try {
                this.fileObject.moveTo(nativeDestination);
                this.fileObject = nativeDestination;
                if (this.filename != null) {
                    this.filename = ISCVfsFile.canonicalizePath(this.fileObject.getURL().toString());
                }
                return true;
            }
            catch (FileSystemException ex) {
                log.warn(ex.toString());
                return false;
            }
        }
        log.warn("renameTo destination was not ISCVfsFile");
        return false;
    }

    @Override
    public boolean exists() {
        try {
            return this.fileObject.exists();
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @Override
    public String getParent() {
        try {
            return this.fileObject.getParent().getName().getURI();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Override
    public boolean canRead() {
        try {
            return this.fileObject.isReadable();
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        try {
            return this.fileObject.isWriteable();
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @Override
    public String getCanonicalPath() {
        try {
            if (this.filename == null) {
                return ISCVfsFile.canonicalizePath(this.fileObject.getURL().toString());
            }
            return this.filename;
        }
        catch (Exception ignored) {
            return this.filename;
        }
    }

    @Override
    public boolean mkdir() {
        try {
            this.fileObject.createFolder();
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    public boolean mkdirs() {
        return this.mkdir();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.fileObject.getContent().getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.fileObject.getContent().getOutputStream();
    }

    @Override
    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }

    @Override
    public long lastModified() throws IOException {
        if (this.exists()) {
            long lastModified = this.fileObject.getContent().getLastModifiedTime();
            lastModified = (long)Math.floor(lastModified / 1000L) * 1000L;
            return lastModified;
        }
        return 0L;
    }

    @Override
    public boolean isDirectory() throws IOException {
        return this.fileObject.getType().hasChildren();
    }

    @Override
    public List<Map<String, Object>> findChildAttributes(Object criteria, DSRequest request) throws Exception {
        if (request == null) {
            request = this.requestContext;
        }
        Evaluator eval = new Evaluator(criteria, "exact");
        FileObject[] allChildren = this.fileObject.getChildren();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(allChildren.length);
        for (FileObject eachChild : allChildren) {
            ISCVfsFile child = new ISCVfsFile(eachChild, request);
            Map<String, Object> attributes = child.readAttributes();
            if (!eval.valuesMatchCriteria(attributes)) continue;
            result.add(attributes);
        }
        return result;
    }

    @Override
    public List<ISCFile> findChildren(Object criteria, DSRequest request) throws Exception {
        if (request == null) {
            request = this.requestContext;
        }
        Evaluator eval = new Evaluator(criteria, "exact");
        FileObject[] allChildren = this.fileObject.getChildren();
        ArrayList<ISCFile> result = new ArrayList<ISCFile>(allChildren.length);
        for (FileObject eachChild : allChildren) {
            ISCVfsFile child = new ISCVfsFile(eachChild, request);
            Map<String, Object> attributes = child.readAttributes();
            if (!eval.valuesMatchCriteria(attributes)) continue;
            result.add(child);
        }
        return result;
    }

    @Override
    public ISCFile getChild(Map<String, Object> primaryKeys, DSRequest request) {
        Set<String> keys;
        if (request == null) {
            request = this.requestContext;
        }
        if ((keys = primaryKeys.keySet()).containsAll(DataSource.FS_PRIMARY_KEYS)) {
            return this.getChild(ISCVfsFile.expandFileExtensions(primaryKeys), request);
        }
        try {
            List<ISCFile> children = this.findChildren(primaryKeys, request);
            if (children.size() == 0) {
                return this.getChild(ISCVfsFile.expandFileExtensions(primaryKeys), request);
            }
            if (children.size() > 1) {
                log.warn("getChild found more than one file -- returning first");
            }
            return children.get(0);
        }
        catch (Exception ex) {
            log.warn(ex.toString());
            return this.getChild(ISCVfsFile.expandFileExtensions(primaryKeys), request);
        }
    }

    @Override
    public ISCFile getChild(String path, DSRequest request) {
        if (request == null) {
            request = this.requestContext;
        }
        try {
            FileObject fo = this.fileObject.resolveFile(path, NameScope.CHILD);
            return new ISCVfsFile(fo, request);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

