/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.naming;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import com.isomorphic.naming.JNDI;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class DNS
extends Base {
    private static Logger log = new Logger(DNS.class.getName());
    protected DirContext ctx;
    static Pattern MX_PRIORITY_PATTERN = Pattern.compile("(\\d+)\\s+(\\S+)");
    static Pattern ipv4AddressPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)");

    public DNS(String configId) throws Exception {
        this.ctx = new InitialDirContext(JNDI.bindConfiguredContext(configId).getEnvironment());
    }

    public DirContext getJNDIContext() {
        return this.ctx;
    }

    public List lookupMX(String name) throws Exception {
        return this.attributeValuesAsList(this.lookup(name, "MX"));
    }

    public static Map mxMapForList(String mxList) throws Exception {
        return DNS.mxMapForList(DataTools.simpleSplit(mxList, ","));
    }

    public static Map mxMapForList(List mxList) throws Exception {
        if (mxList == null) {
            return null;
        }
        Map result = new HashMap();
        Iterator i = mxList.iterator();
        while (i.hasNext()) {
            String mx = i.next().toString();
            Matcher matcher = MX_PRIORITY_PATTERN.matcher(mx);
            if (matcher.find()) {
                result = DataTools.putMultipleAsList(result, Integer.valueOf(matcher.group(1)), matcher.group(2));
                continue;
            }
            if ((mx = mx.trim()).length() > 0) {
                result = DataTools.putMultipleAsList(result, new Integer(1), mx);
                continue;
            }
            throw new Exception("malformed MX: " + mx);
        }
        return result;
    }

    public List lookupNS(String name) throws Exception {
        return this.attributeValuesAsList(this.lookup(name, "NS"));
    }

    public List lookupAddress(String name) throws Exception {
        return this.attributeValuesAsList(this.lookup(name, "A"));
    }

    public List lookupName(String address) throws Exception {
        Matcher matcher = ipv4AddressPattern.matcher(address);
        if (!matcher.find()) {
            return null;
        }
        address = matcher.group(4) + "." + matcher.group(3) + "." + matcher.group(2) + "." + matcher.group(1) + ".in-addr.arpa";
        return this.attributeValuesAsList(this.lookup(address, "PTR"));
    }

    public List attributeValuesAsList(Attribute attr) throws Exception {
        if (attr == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        NamingEnumeration<?> ne = attr.getAll();
        while (ne.hasMore()) {
            result.add(ne.next());
        }
        return result;
    }

    public Attribute lookup(String query, String type) throws Exception {
        try {
            Attributes attrs = this.ctx.getAttributes(query, new String[]{type});
            return attrs.get(type);
        }
        catch (NameNotFoundException nfe) {
            return null;
        }
    }
}

