/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.protos.SystemInputProtos;
import com.opera.core.systems.scope.services.desktop.DesktopUtils;
import com.opera.core.systems.scope.services.desktop.SystemInput;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public abstract class OperaUIElement {
    private SystemInput systemInputManager;
    private DesktopUtils desktopUtils;

    public OperaUIElement(SystemInput systemInputManager, DesktopUtils desktopUtils) {
        this.systemInputManager = systemInputManager;
        this.desktopUtils = desktopUtils;
    }

    protected SystemInput getSystemInputManager() {
        return this.systemInputManager;
    }

    protected DesktopUtils getDesktopUtils() {
        return this.desktopUtils;
    }

    public abstract DesktopWmProtos.DesktopWindowRect getRect();

    public Point getLocation() {
        DesktopWmProtos.DesktopWindowRect rect = this.getRect();
        return new Point(rect.getX(), rect.getY());
    }

    public boolean isVisible() {
        return true;
    }

    public Dimension getSize() {
        DesktopWmProtos.DesktopWindowRect rect = this.getRect();
        return new Dimension(rect.getWidth(), rect.getHeight());
    }

    public abstract String toFullString();

    public void click(SystemInputProtos.MouseInfo.MouseButton button, int numClicks, List<SystemInputProtos.ModifierPressed> modifiers) {
        this.systemInputManager.click(this.getCenterLocation(), button, numClicks, modifiers);
    }

    protected Point getCenterLocation() {
        DesktopWmProtos.DesktopWindowRect rect = this.getRect();
        Point topLeft = this.getLocation();
        return new Point(topLeft.x + rect.getWidth() / 2, topLeft.y + rect.getHeight() / 2);
    }

    public void hover() {
        ArrayList<SystemInputProtos.ModifierPressed> alist = new ArrayList<SystemInputProtos.ModifierPressed>();
        alist.add(SystemInputProtos.ModifierPressed.NONE);
        this.systemInputManager.mouseMove(this.getCenterLocation(), SystemInputProtos.MouseInfo.MouseButton.LEFT, alist);
    }

    public boolean verifyText(String stringId) {
        String text = this.desktopUtils.getString(stringId, true);
        return this.getText().equals(text);
    }

    public boolean verifyContainsText(String stringId) {
        String text = this.desktopUtils.getString(stringId, true);
        return this.getText().indexOf(text) >= 0;
    }

    public abstract String getText();
}

