/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.util.KeyDataPair;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class HtmlFileInput
extends HtmlInput {
    private String contentType_;
    private byte[] data_;
    private File[] files_ = new File[0];

    HtmlFileInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        DomAttr valueAttrib = attributes.get("value");
        if (valueAttrib != null) {
            this.setDefaultValue(valueAttrib.getNodeValue(), false);
        }
    }

    public final byte[] getData() {
        return this.data_;
    }

    public final void setData(byte[] data) {
        this.data_ = data;
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        if (this.files_ == null || this.files_.length == 0) {
            return new NameValuePair[]{new KeyDataPair(this.getNameAttribute(), null, null, null, (Charset)null)};
        }
        ArrayList<KeyDataPair> list = new ArrayList<KeyDataPair>();
        for (File file : this.files_) {
            String contentType;
            if (this.contentType_ == null) {
                contentType = this.getPage().getWebClient().getBrowserVersion().getUploadMimeType(file);
                if (StringUtils.isEmpty((CharSequence)contentType)) {
                    contentType = "application/octet-stream";
                }
            } else {
                contentType = this.contentType_;
            }
            Charset charset = this.getPage().getCharset();
            KeyDataPair keyDataPair = new KeyDataPair(this.getNameAttribute(), file, null, contentType, charset);
            keyDataPair.setData(this.data_);
            list.add(keyDataPair);
        }
        return list.toArray(new NameValuePair[list.size()]);
    }

    public void setContentType(String contentType) {
        this.contentType_ = contentType;
    }

    public String getContentType() {
        return this.contentType_;
    }

    @Override
    public String asText() {
        return "";
    }

    @Override
    public void setValueAttribute(String newValue) {
        this.setFiles(new File(newValue));
    }

    @Deprecated
    public void setValueAttribute(String[] files) {
        File[] array = (File[])Stream.of(files).map(p -> new File((String)p)).toArray(File[]::new);
        this.setFiles(array);
    }

    public void setFiles(File ... files) {
        if (files.length > 1 && this.getAttribute("multiple") == ATTRIBUTE_NOT_DEFINED) {
            throw new IllegalStateException("HtmlFileInput is not 'multiple'.");
        }
        for (int i = 0; i < files.length; ++i) {
            files[i] = HtmlFileInput.normalizeFile(files[i]);
        }
        this.files_ = files;
        this.fireEvent("change");
    }

    private static File normalizeFile(File file) {
        File f = null;
        String path = file.getPath().replace('\\', '/');
        if (path.startsWith("file:/")) {
            if (path.startsWith("file://") && !path.startsWith("file:///")) {
                path = "file:///" + path.substring(7);
            }
            try {
                f = new File(new URI(path));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (f == null) {
            f = new File(path);
        }
        return f;
    }

    public File[] getFiles() {
        return this.files_;
    }
}

