/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.JsonToBeanConverter;

public class NewSessionPayload
implements Closeable {
    private static final Logger LOG = Logger.getLogger(NewSessionPayload.class.getName());
    private static final Dialect DEFAULT_DIALECT = Dialect.OSS;
    private static final Predicate<String> ACCEPTED_W3C_PATTERNS = Stream.of("^[\\w-]+:.*$", "^acceptInsecureCerts$", "^browserName$", "^browserVersion$", "^platformName$", "^pageLoadStrategy$", "^proxy$", "^setWindowRect$", "^timeouts$", "^unhandledPromptBehavior$").map(Pattern::compile).map(Pattern::asPredicate).reduce(identity -> false, Predicate::or);
    private static final long THRESHOLD = Runtime.getRuntime().maxMemory() / 10L;
    private static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory(ListAdapter.access$100()).registerTypeAdapterFactory(MapAdapter.access$000()).setLenient().serializeNulls().create();
    private static final Type MAP_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
    private final Path root;
    private final Sources sources;

    public static NewSessionPayload create(Capabilities caps) throws IOException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"desiredCapabilities", caps.asMap());
        ImmutableMap.Builder w3cCaps = ImmutableMap.builder();
        caps.asMap().entrySet().stream().filter(e -> ACCEPTED_W3C_PATTERNS.test((String)e.getKey())).filter(e -> e.getValue() != null).forEach(e -> w3cCaps.put(e.getKey(), e.getValue()));
        builder.put((Object)"capabilities", (Object)ImmutableMap.of((Object)"firstMatch", (Object)ImmutableList.of((Object)w3cCaps.build())));
        return new NewSessionPayload((Map<String, ?>)builder.build());
    }

    public NewSessionPayload(Map<String, ?> source) throws IOException {
        Sources sources;
        Objects.requireNonNull(source, "Payload must be set");
        String json = new BeanToJsonConverter().convert(source);
        long size = json.length() * 2;
        if (size > THRESHOLD || Runtime.getRuntime().freeMemory() < size) {
            this.root = Files.createTempDirectory("new-session", new FileAttribute[0]);
            sources = this.diskBackedSource(new StringReader(json));
        } else {
            this.root = null;
            sources = this.memoryBackedSource(source);
        }
        this.validate(sources);
        this.sources = this.rewrite(sources);
    }

    public NewSessionPayload(long size, Reader source) throws IOException {
        Sources sources;
        if (size > THRESHOLD || Runtime.getRuntime().freeMemory() < size) {
            this.root = Files.createTempDirectory("new-session", new FileAttribute[0]);
            sources = this.diskBackedSource(source);
        } else {
            this.root = null;
            sources = this.memoryBackedSource(new JsonToBeanConverter().convert(Map.class, CharStreams.toString((Readable)source)));
        }
        this.validate(sources);
        this.sources = this.rewrite(sources);
    }

    private void validate(Sources sources) {
        if (!sources.getDialects().contains((Object)Dialect.W3C)) {
            return;
        }
        Map<String, Object> alwaysMatch = sources.getAlwaysMatch().get();
        this.validateSpecCompliance(alwaysMatch);
        Set duplicateKeys = (Set)sources.getFirstMatch().stream().map(Supplier::get).peek(this::validateSpecCompliance).map(fragment -> Sets.intersection(alwaysMatch.keySet(), fragment.keySet())).flatMap(Collection::stream).collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)Ordering.natural()));
        if (!duplicateKeys.isEmpty()) {
            throw new IllegalArgumentException("W3C payload contained keys duplicated between the firstMatch and alwaysMatch items: " + duplicateKeys);
        }
    }

    private void validateSpecCompliance(Map<String, Object> fragment) {
        ImmutableList badKeys = (ImmutableList)fragment.keySet().stream().filter(ACCEPTED_W3C_PATTERNS.negate()).collect(ImmutableList.toImmutableList());
        if (!badKeys.isEmpty()) {
            throw new IllegalArgumentException("W3C payload contained keys that do not comply with the spec: " + badKeys);
        }
    }

    private Sources rewrite(Sources sources) {
        if (!sources.getDialects().contains((Object)Dialect.OSS)) {
            return sources;
        }
        if (!sources.getDialects().contains((Object)Dialect.W3C)) {
            return sources;
        }
        Map ossPayload = (Map)sources.getOss().get().entrySet().stream().filter(e -> !"platform".equals(e.getKey()) || !"ANY".equals(e.getValue())).filter(e -> !"version".equals(e.getKey()) || !"".equals(e.getValue())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, Object> always = sources.getAlwaysMatch().get();
        Optional<ImmutableMap> w3cMatch = sources.getFirstMatch().stream().map(Supplier::get).map(m -> ImmutableMap.builder().putAll(always).putAll(m).build()).filter(m -> m.equals((Object)ossPayload)).findAny();
        if (w3cMatch.isPresent()) {
            LOG.fine("Found a w3c capability that matches the oss one.");
            return sources;
        }
        LOG.info("Mismatched capabilities. Creating a synthetic w3c capability.");
        ImmutableList.Builder newFirstMatches = ImmutableList.builder();
        newFirstMatches.add(sources.getOss());
        sources.getFirstMatch().forEach(m -> newFirstMatches.add(() -> NewSessionPayload.lambda$null$9(sources, (Supplier)m)));
        return new Sources(sources.getOriginalPayload(), sources.getPayloadSize(), sources.getOss(), ImmutableMap::of, (List<Supplier<Map<String, Object>>>)newFirstMatches.build(), (Set<Dialect>)sources.getDialects());
    }

    private Sources memoryBackedSource(Map<?, ?> source) {
        LOG.fine("Memory-based payload for: " + source);
        TreeSet<Dialect> dialects = new TreeSet<Dialect>();
        Map<String, Object> oss = NewSessionPayload.toMap(source.get("desiredCapabilities"));
        if (oss != null) {
            dialects.add(Dialect.OSS);
        }
        TreeMap<String, Object> alwaysMatch = new TreeMap<String, Object>();
        LinkedList<Supplier<Map<String, Object>>> firstMatches = new LinkedList<Supplier<Map<String, Object>>>();
        Map<String, Object> caps = NewSessionPayload.toMap(source.get("capabilities"));
        if (caps != null) {
            Object raw;
            Map<String, Object> always = NewSessionPayload.toMap(caps.get("alwaysMatch"));
            if (always != null) {
                alwaysMatch.putAll(always);
                dialects.add(Dialect.W3C);
            }
            if ((raw = caps.get("firstMatch")) instanceof Collection) {
                ((Collection)raw).stream().map(NewSessionPayload::toMap).filter(Objects::nonNull).forEach(m -> firstMatches.add(() -> m));
                dialects.add(Dialect.W3C);
            }
            if (firstMatches.isEmpty()) {
                firstMatches.add(ImmutableMap::of);
            }
        }
        byte[] json = new BeanToJsonConverter().convert(source).getBytes(StandardCharsets.UTF_8);
        return new Sources(() -> new ByteArrayInputStream(json), json.length, () -> oss, () -> alwaysMatch, firstMatches, dialects);
    }

    /*
     * Exception decompiling
     */
    private Sources diskBackedSource(Reader source) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Path write(String fileName, JsonReader json) throws IOException {
        Path out = this.root.resolve(fileName);
        Map value = (Map)GSON.fromJson(json, MAP_TYPE);
        try (BufferedWriter writer = Files.newBufferedWriter(out, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            GSON.toJson((Object)value, (Appendable)writer);
        }
        return out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> read(Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            Map map = (Map)GSON.fromJson((Reader)reader, MAP_TYPE);
            return map;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Map<String, Object> toMap(Object obj) {
        if (!(obj instanceof Map)) {
            return null;
        }
        return (Map)((Map)obj).entrySet().stream().filter(e -> e.getKey() != null).filter(e -> e.getValue() != null).collect(ImmutableMap.toImmutableMap(e -> String.valueOf(e.getKey()), Map.Entry::getValue));
    }

    public Stream<Capabilities> stream() throws IOException {
        Stream<Object> mapStream;
        if (this.getDownstreamDialects().contains((Object)Dialect.W3C)) {
            Map<String, Object> always = this.sources.getAlwaysMatch().get();
            mapStream = this.sources.getFirstMatch().stream().map(Supplier::get).map(m -> ImmutableMap.builder().putAll(always).putAll(m).build());
        } else {
            mapStream = this.getDownstreamDialects().contains((Object)Dialect.OSS) ? Stream.of(this.sources.getOss().get()) : Stream.of(ImmutableMap.of());
        }
        return mapStream.map(ImmutableCapabilities::new);
    }

    public ImmutableSet<Dialect> getDownstreamDialects() {
        return this.sources.getDialects().isEmpty() ? ImmutableSet.of((Object)((Object)DEFAULT_DIALECT)) : this.sources.getDialects();
    }

    public Supplier<InputStream> getPayload() {
        return this.sources.getOriginalPayload();
    }

    public long getPayloadSize() {
        return this.sources.getPayloadSize();
    }

    @Override
    public void close() {
        if (this.root != null) {
            FileHandler.delete(this.root.toAbsolutePath().toFile());
        }
    }

    private static Object readValue(JsonReader in, Gson gson) throws IOException {
        switch (in.peek()) {
            case BEGIN_ARRAY: 
            case BEGIN_OBJECT: 
            case BOOLEAN: 
            case NULL: 
            case STRING: {
                return gson.fromJson(in, Object.class);
            }
            case NUMBER: {
                String number = in.nextString();
                if (number.indexOf(46) != -1) {
                    return Double.parseDouble(number);
                }
                return Long.parseLong(number);
            }
        }
        throw new JsonParseException("Unexpected type: " + in.peek());
    }

    private static /* synthetic */ InputStream lambda$diskBackedSource$19(Path payload) {
        try {
            return Files.newInputStream(payload, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private /* synthetic */ Map lambda$diskBackedSource$18(Path ossCaps) {
        return this.read(ossCaps);
    }

    private /* synthetic */ Map lambda$diskBackedSource$17(Path f) {
        return this.read(f);
    }

    private /* synthetic */ Map lambda$diskBackedSource$16(Path a) {
        return this.read(a);
    }

    private static /* synthetic */ Map lambda$null$9(Sources sources, Supplier m) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(sources.getAlwaysMatch().get());
        builder.putAll((Map)m.get());
        return builder.build();
    }

    private static class ListAdapter
    extends TypeAdapter<List<?>> {
        private static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                if (type.getRawType() == List.class) {
                    return new ListAdapter(gson);
                }
                return null;
            }
        };
        private final Gson gson;

        private ListAdapter(Gson gson) {
            this.gson = Objects.requireNonNull(gson);
        }

        public List<?> read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            LinkedList<Object> list = new LinkedList<Object>();
            in.beginArray();
            while (in.hasNext()) {
                list.add(NewSessionPayload.readValue(in, this.gson));
            }
            in.endArray();
            return list;
        }

        public void write(JsonWriter out, List<?> value) throws IOException {
            out.beginArray();
            for (Object entry : value) {
                TypeAdapter adapter = this.gson.getAdapter(entry.getClass());
                adapter.write(out, entry);
            }
            out.endArray();
        }

        static /* synthetic */ TypeAdapterFactory access$100() {
            return FACTORY;
        }
    }

    private static class MapAdapter
    extends TypeAdapter<Map<?, ?>> {
        private static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                if (type.getRawType() == Map.class) {
                    return new MapAdapter(gson);
                }
                return null;
            }
        };
        private final Gson gson;

        private MapAdapter(Gson gson) {
            this.gson = Objects.requireNonNull(gson);
        }

        public Map<?, ?> read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            in.beginObject();
            while (in.hasNext()) {
                String key = in.nextName();
                Object value = NewSessionPayload.readValue(in, this.gson);
                map.put(key, value);
            }
            in.endObject();
            return map;
        }

        public void write(JsonWriter out, Map<?, ?> value) throws IOException {
            out.beginObject();
            for (Map.Entry<?, ?> entry : value.entrySet()) {
                out.name(String.valueOf(entry.getKey()));
                TypeAdapter adapter = this.gson.getAdapter(entry.getValue().getClass());
                adapter.write(out, entry.getValue());
            }
            out.endObject();
        }

        static /* synthetic */ TypeAdapterFactory access$000() {
            return FACTORY;
        }
    }

    private static class Sources {
        private final Supplier<InputStream> originalPayload;
        private final long payloadSizeInBytes;
        private final Supplier<Map<String, Object>> oss;
        private final Supplier<Map<String, Object>> alwaysMatch;
        private final List<Supplier<Map<String, Object>>> firstMatch;
        private final ImmutableSet<Dialect> dialects;

        Sources(Supplier<InputStream> originalPayload, long payloadSizeInBytes, Supplier<Map<String, Object>> oss, Supplier<Map<String, Object>> alwaysMatch, List<Supplier<Map<String, Object>>> firstMatch, Set<Dialect> dialects) {
            this.originalPayload = originalPayload;
            this.payloadSizeInBytes = payloadSizeInBytes;
            this.oss = oss;
            this.alwaysMatch = alwaysMatch;
            this.firstMatch = firstMatch;
            this.dialects = ImmutableSet.copyOf(dialects);
        }

        Supplier<InputStream> getOriginalPayload() {
            return this.originalPayload;
        }

        Supplier<Map<String, Object>> getOss() {
            return this.oss;
        }

        Supplier<Map<String, Object>> getAlwaysMatch() {
            return this.alwaysMatch;
        }

        List<Supplier<Map<String, Object>>> getFirstMatch() {
            return this.firstMatch;
        }

        ImmutableSet<Dialect> getDialects() {
            return this.dialects;
        }

        public long getPayloadSize() {
            return this.payloadSizeInBytes;
        }
    }
}

