#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )

$symbol_pound Google App Engine with Cloud Datastore

This example illustrates an approach to running a SmartGWT application on the Google App Engine standard environment using Google Cloud Datastore as a _limited_ JPA DataSource.  It was generated by a Maven archetype available in the SDK. 

_Note that, given a choice, most App Engine users will want to start new projects with the **archetype-smartgwt-example-gae** archetype.  Refer to the Quick Start Guide distributed with your build for further discussion on best practices._

To start with a new application like this one:

1. Install Maven, if necessary 

     <https://maven.apache.org/install.html>

2. Install SmartGWT, if necessary.
              
        mvn com.isomorphic:isc-maven-plugin:1.4.5:install $symbol_escape
          -Dproduct=SMARTGWT -Dlicense=LGPL -DbuildNumber=12.1p

3. Generate a project (using LATEST as below, or the version installed for you in step 2)

        mvn archetype:generate $symbol_escape
          -DartifactId=my-application -Dmodule=MyApplication $symbol_escape
          -DgroupId=com.example -Dpackage=com.example.myapplication $symbol_escape
          -DarchetypeGroupId=com.isomorphic.archetype $symbol_escape
          -DarchetypeArtifactId=archetype-smartgwt-example-gaedatastore $symbol_escape
          -DarchetypeVersion=LATEST -DinteractiveMode=false

Instructions are provided below for using the generated project with Eclipse and command line development environments.

If you instead want to add Smart GWT EE to an existing project, see these instructions:  

<http://www.smartclient.com/smartgwtee/javadoc/com/smartgwt/client/docs/SgwtEESetup.html>

For instructions for launching tools such as the Developer Console, Visual Builder or DataSource Wizards, see the Smart GWT FAQ:

<http://forums.smartclient.com/showthread.php?t=8159>


$symbol_pound$symbol_pound Prerequisites

Variations on the following are possible, but archetypes & sample projects were created with the following environment/s in mind:

- [Java 8](https://java.com/en/download/manual.jsp)

- [Google Web Toolkit](https://developers.google.com/web-toolkit/download) version 2.8.2 or later

- [Google Cloud SDK](https://cloud.google.com/sdk/docs/quickstarts) version 192.0.0 or later. 

- [Apache Maven](http://maven.apache.org/download.cgi) version 3.5.0 or later

- [Apache Ant](https://ant.apache.org/bindownload.cgi) version 1.9.10 or later.

  - *Ensure that the GWT_HOME environment variable is set to the location of your Google Web Toolkit SDK directory*

  - *Ensure that the ANT_HOME environment variable is set to the location of your Apache Ant directory, and the 'ant' command is in your PATH.*
  
  - *Ensure that the APPENGINE_HOME environment variable is set to the location of your Google App Engine SDK directory, and the 'ant' command is in your PATH.*

- [Google App Engine](https://cloud.google.com/appengine/docs/standard/java/download) version 1.9.62 or later.

- [Eclipse Java EE IDE for Web Developers](http://www.eclipse.org/downloads/packages/eclipse-ide-java-ee-developers/oxygen2), version 4.7.2 (Oxygen) or later with [GWT Eclipse Plugin](http://gwt-plugins.github.io/documentation/gwt-eclipse-plugin/Download.html) version 3.0.0 or later, [Google Cloud Platform for Eclipse](https://cloud.google.com/eclipse/docs/quickstart) version 1.6.0 or later and [DataNucleus Eclipse Plugin](http://www.datanucleus.org/products/accessplatform_3_1/jdo/guides/eclipse.html) version 4.0.0.release or later.

$symbol_pound$symbol_pound$symbol_pound Initialization

1.  Ant users will begin by restructuring the project and removing Maven-specific resources.

        cd my-application
        ant unmaven

2. If necessary, install and initialize the Cloud SDK: 
   <https://cloud.google.com/sdk/docs/quickstarts>

3. Create and/or select a Cloud project.  Take note of your Project ID:
   <https://cloud.google.com/resource-manager/docs/creating-managing-projects>

4. Change the build's gcloud.projectId property value to the ID you recorded in step 3.  

   Maven users will modify the parent project's pom.xml

        <gcloud.projectId>my-application-xxxxxx</gcloud.projectId>
        
   Ant users will modify build.xml

        <property name="gcloud.projectId" value="my-application-xxxxxx" />


$symbol_pound$symbol_pound Usage: Apache Maven

$symbol_pound$symbol_pound$symbol_pound Command line tools

1. Navigate to your project directory
        
        cd my-application

2. Start the GWT codeserver.

        mvn gwt:codeserver -am -pl *-client

3.  At another command line from the server project directory, start the Google App Engine development server

        cd my-application-server
        mvn appengine:run -Pdev

4. Wait for each process to indicate that it's ready, and then load the app in your browser at <http://localhost:8080/index.jsp>

$symbol_pound$symbol_pound$symbol_pound Eclipse

1. Import the generated project using the "Existing Maven Projects" wizard (File/Import/Maven/Existing Maven Projects).

2. Ensure that both the 'dev' and 'eclipse' maven profiles are activated on the imported project's server module (Project Properties / Maven / Active Maven Profiles reads, "dev, eclipse").

3. Ensure that the imported project's server module takes the App Engine Java Standard Environment Facet (Project Properties / Project Facets / App Engine Java Standard Environment is checked).

4. Ensure that the imported project's client module takes the GWT Facet (Project Properties / Project Facets / GWT is checked).

5. Package the parent project, causing the SmartGWT runtime to be unpacked to the server (Provide "package" to the 'goals' prompt at Run / Run As / Maven Build). 

   _Note that this won't be strictly necessary if you've already tested the project using Command Line Tools, but you'll need to repeat this step following any 'mvn clean' execution._

6. Add the SmartGWT runtime to the server project's 'Deployment Assembly' (Project Properties / Deployment Assembly).  A refresh of the server project's 'target' folder may be necessary.
   
   **Source**: /target/my-application-server-1.0-SNAPSHOT/myapplication 
   **Deploy Path**: myapplication

7. If necessary, create a Google App Engine server, add the application to the server, and launch it.  This can all be done in a single step using the 'Debug on App Engine' menu item at the Google Cloud Platform toolbar button.

8. Wait for each process to indicate that it's ready, and then load the app in your browser at the URL reported by Eclipse.  <http://localhost:8080/index.jsp>


$symbol_pound$symbol_pound Usage: Apache Ant

$symbol_pound$symbol_pound$symbol_pound Command line tools

1. Navigate to your project directory
        
        cd my-application

2. Launch the Google App Engine development server.  _Note that this may fail the first time when Apache Ivy has not been installed, but correction should occur automatically, and subsequent attempts should be successful_.

        ant devmode

3. Wait for the process to indicate that it's ready, and then load the app in your browser at <http://127.0.0.1:8888/index.html>

$symbol_pound$symbol_pound$symbol_pound Eclipse

1. Configure the DataNucleus Eclipse Plugin for the JPA API (Eclipse Preferences > DataNucleus> Persistence API).

2. Create a new project using the "Java Project" wizard (File/New/Project/Java Project)

3. When prompted for the 'Project name', use the name of the directory holding your project on disk.  

   **Project name: my-application**

   The wizard will automatically configure the JRE and the project layout based on the existing source.

4. Ensure that the imported project takes the App Engine Java Standard Environment Facet (Right-click & select Configure > Convert to App Engine Project).

5. Ensure that the GWT SDM Builder is enabled (Right-click & select Configure > Enable GWT SDM builder).

6. Add DataNucleus support (Project Properties > DataNucleus > Add DataNucleus Support) and enable automatic enhancement (Right-click & select DataNucleus > Enable Auto-Enhancement)

7. If necessary, run the Ant build's 'gwtc' target to retrieve dependencies and force GWT compilation.  If you are using Ant tools for Eclipse, you'll need to make sure Eclipse has proper values for the environment variables outlined in the Prerequisites section above.

        ant gwtc

   Alternatively, you may choose to do this in steps by first running the Ant build's 'ivy-get' target and then compiling via Eclipse (Right-click > GWT > Compile).  The benefit to doing so is that there is no need for the aforementioned environment variables.  

   In either case, you may need to refresh your project's contents.

   _Note that this won't be strictly necessary if you've already tested the project using Command Line Tools, but you'll need to repeat this step following any 'ant clean' execution._
   
8. Disable the Cloud Tools "Open start page on launch" option (Eclipse Preferences / Google Cloud Tools / Launching)

9. Create a Google App Engine server, add the application to the server, and launch it.  This can all be done in a single step using the "Debug on App Engine" menu item from the Google Cloud Platform toolbar button.

10. Wait for each process to indicate that it's ready, and then load the app in your browser at <http://localhost:8080/index.jsp>


$symbol_pound$symbol_pound Related Topics

- Hosted Mode is being being phased out by GWT and replaced with Super Dev Mode.  You can find an overview of SDM at:

  <http://www.gwtproject.org/articles/superdevmode.html>

- For more details about how to set up or use SDM, see our online Smart GWT SDM Troubleshooting help topic at 

  <http://www.smartclient.com/smartgwt/javadoc/com/smartgwt/client/docs/SuperDevModeTroubleshooting.html>

- See our debugging overview at <http://www.smartclient.com/smartgwt/javadoc/com/smartgwt/client/docs/Debugging.html>
