/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.datasource.SystemSchemaTranslation;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestTimer;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoadSystemSchemaServlet
extends BaseServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = config.getString("RPCManager.defaultCharset", "UTF-8");
        }
        if (!encoding.toLowerCase().equals("none")) {
            request.setCharacterEncoding(encoding);
            response.setContentType("application/javascript;charset=" + encoding);
        } else {
            response.setContentType("application/javascript");
        }
        try {
            String responseContent = SystemSchemaTranslation.getTranslatedSystemSchema();
            response.setStatus(200);
            PrintWriter rw = response.getWriter();
            rw.print(responseContent);
            rw.close();
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
        finally {
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException responseContent) {}
        }
    }
}

