/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.log;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.log.ANSIColorizedPatternLayout;
import com.isomorphic.log.ILogger;
import com.isomorphic.log.Level;
import com.isomorphic.log.Log4jLogger;
import com.isomorphic.log.Slf4jLogger;
import com.isomorphic.util.DataTools;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Logger {
    private static Logger staticLog;
    public static Logger auth;
    public static Logger timing;
    public static Logger validation;
    public static Logger fileSandbox;
    public static Logger resultData;
    public static Logger download;
    public static Logger global;
    public static final Level OFF;
    public static final Level FATAL;
    public static final Level ERROR;
    public static final Level WARN;
    public static final Level INFO;
    public static final Level DEBUG;
    public static final Level ALL;
    public static final String STANDARD_MESSAGE = "Caught unexpected exception";
    protected static boolean logEnabled;
    private static boolean prefixWithPackage;
    private static boolean useSlf4j;
    private static boolean useLog4jConfig;
    public static boolean useLog4j;
    private static boolean useLog4j2;
    private static boolean log4j2Present;
    private static String log4j2RMA;
    protected static final ThreadLocal<String> disableThreads;
    protected static final ThreadLocal<String> ignoreThreads;
    private static final String DEFAULT_SUBSYSTEM = "Undefined Subsystem";
    private ILogger log = null;
    private String subsystem;
    private String packageName;
    private String packagePrefix;
    private String messagePrefix;
    public Level level;
    private static final ThreadLocal<Stack> threadContext;
    private static Map<String, Level> savedThresholds;
    private static Object _context;
    private static final Map<Level, Object> toLog4j;
    public static final Map<Object, Level> fromLog4j;

    public static Object getLoggerRepository() {
        if (Logger.threadDisabled()) {
            return null;
        }
        if (!useLog4j) {
            return null;
        }
        return Log4jLogger.getLoggerRepository();
    }

    public static void setLoggerRepository(Object newRepos) {
        if (Logger.threadDisabled()) {
            return;
        }
        if (!useLog4j) {
            return;
        }
        Log4jLogger.setLoggerRepository(newRepos);
    }

    public static void disableThread() {
        disableThreads.set("1");
    }

    public static boolean enableThread() {
        boolean wasDisabled = Logger.threadDisabled();
        disableThreads.remove();
        return wasDisabled;
    }

    public static boolean threadDisabled() {
        return disableThreads.get() != null;
    }

    public static void ignoreThread() {
        ignoreThreads.set("1");
    }

    public static boolean observeThread() {
        boolean wasIgnored = Logger.threadIgnored();
        ignoreThreads.remove();
        return wasIgnored;
    }

    public static boolean threadIgnored() {
        return ignoreThreads.get() != null;
    }

    public static Throwable getRealTargetException(Throwable ite) {
        if (ite instanceof InvocationTargetException) {
            return Logger.getRealTargetException(((InvocationTargetException)ite).getTargetException());
        }
        return ite;
    }

    public static void initialize() {
        Config config = Config.getGlobal();
        if (useLog4j) {
            ANSIColorizedPatternLayout.initialize();
        }
        staticLog = new Logger(Logger.class.getName());
        staticLog.info("Logging system started.");
        auth = new Logger("com.isomorphic.auth.Auth");
        timing = new Logger("com.isomorphic.timing.Timing");
        validation = new Logger("com.isomorphic.validation.Validation");
        fileSandbox = new Logger("com.isomorphic.fileSandbox.FileSandbox");
        resultData = new Logger("com.isomorphic.resultData.ResultData");
        download = new Logger("com.isomorphic.download.Download");
        global = new Logger("GLOBAL");
    }

    public static Level getLevelForCategory(String category) {
        if (Logger.threadDisabled()) {
            return OFF;
        }
        if (useLog4j) {
            return Log4jLogger.getLevelForCategory(category);
        }
        if (Logger._useLog4j2()) {
            try {
                Object logger;
                Object ctx = Logger._getLoggerContext();
                if (ctx != null && (logger = Reflection.invokeMethod(ctx, "getLogger", category)) != null) {
                    return fromLog4j.get(Reflection.invokeMethod(logger, "getLevel"));
                }
            }
            catch (Exception ex) {
                System.out.println("ISC: Failed to getLevelForCategory: " + ex.getMessage());
            }
        }
        return OFF;
    }

    public static void setLevelForCategory(String category, Level level) {
        if (Logger.threadDisabled()) {
            return;
        }
        if (useLog4j) {
            Log4jLogger.setLevelForCategory(category, level);
        } else if (Logger._useLog4j2()) {
            try {
                Object ctx = Logger._getLoggerContext();
                if (ctx != null) {
                    Object configuration = Reflection.invokeMethod(ctx, "getConfiguration");
                    Object cfg = Reflection.invokeMethod(configuration, "getLoggerConfig", category);
                    if (cfg != null) {
                        Reflection.invokeMethod(cfg, "setLevel", toLog4j.get(level));
                        Reflection.invokeMethod(ctx, "updateLoggers");
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("ISC: Failed to setLevelForCategory: " + ex.getMessage());
            }
        }
    }

    public static void setLevelForCategory(String category, String level) {
        if (Logger.threadDisabled()) {
            return;
        }
        if (useSlf4j && Logger._useLog4j2()) {
            Logger._setLevelForCategory(category, level);
        } else {
            Log4jLogger.setLevelForCategory(category, level);
        }
    }

    public static List getCurrentLoggers() {
        if (Logger.threadDisabled()) {
            return new ArrayList();
        }
        if (useSlf4j && Logger._useLog4j2()) {
            return Logger._getCurrentLoggers();
        }
        return Log4jLogger.getCurrentLoggers();
    }

    private ILogger getNativeLog() {
        if (this.log == null && !Logger.threadDisabled()) {
            this.log = !useSlf4j ? new Log4jLogger(this.subsystem) : new Slf4jLogger(this.subsystem);
        }
        return this.log;
    }

    private static String prependContext(Object message) {
        Stack s = Logger.getThreadContext();
        if (s.empty()) {
            return message.toString();
        }
        return s.toString() + " " + message.toString();
    }

    private String prefixMessage(Object message) {
        if (message != null) {
            StringBuilder msg = new StringBuilder();
            if (this.messagePrefix != null) {
                msg.append(this.messagePrefix);
            }
            if (prefixWithPackage) {
                msg.append(this.packagePrefix);
            }
            msg.append(Logger.prependContext(message));
            return msg.toString();
        }
        return "null";
    }

    public Logger(Class objClass) {
        this(objClass.getName());
    }

    public Logger(Object obj) {
        this(obj.getClass().getName());
    }

    public Logger(String subsystem) {
        this(subsystem, null);
    }

    public Logger(String subsystem, String messagePrefix) {
        int start = 0;
        int end = 0;
        if (subsystem == null) {
            subsystem = DEFAULT_SUBSYSTEM;
        }
        if (subsystem.indexOf(".") != -1) {
            end = subsystem.lastIndexOf(".");
            start = subsystem.lastIndexOf(".", end - 1);
        }
        this.packageName = start > 0 && end > start ? subsystem.substring(start + 1, end).toUpperCase() : subsystem;
        this.packagePrefix = this.packageName + " - ";
        this.subsystem = subsystem;
        if (!Logger.threadDisabled()) {
            this.log = !useSlf4j ? new Log4jLogger(subsystem) : new Slf4jLogger(subsystem);
        }
        if (messagePrefix != null) {
            this.messagePrefix = messagePrefix + " - ";
        }
    }

    public Logger() {
        this(DEFAULT_SUBSYSTEM);
    }

    public void fatal(Object message) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isFatalEnabled()) {
            this.getNativeLog().fatal(this.prefixMessage(message));
        }
    }

    public void forceFatal(Object message) {
        boolean wasIgnored = Logger.observeThread();
        this.fatal(message);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void fatal(Object message, Throwable t) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isFatalEnabled()) {
            this.getNativeLog().fatal(this.prefixMessage(message), Logger.getRealTargetException(t));
        }
    }

    public void fatal(Throwable t) {
        this.fatal((Object)STANDARD_MESSAGE, t);
    }

    public void forceFatal(Object message, Throwable t) {
        boolean wasIgnored = Logger.observeThread();
        this.fatal(message, t);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void fatal(Object message, Object o) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isFatalEnabled()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.getNativeLog().fatal(message.toString() + ": " + ostring);
        }
    }

    public void forceFatal(Object message, Object o) {
        boolean wasIgnored = Logger.observeThread();
        this.fatal(message, o);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void error(Object message) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isErrorEnabled()) {
            this.getNativeLog().error(this.prefixMessage(message));
        }
    }

    public void error(Throwable t) {
        this.error((Object)STANDARD_MESSAGE, t);
    }

    public void forceError(Object message) {
        boolean wasIgnored = Logger.observeThread();
        this.error(message);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void error(Object message, Throwable t) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isErrorEnabled()) {
            this.getNativeLog().error(this.prefixMessage(message), Logger.getRealTargetException(t));
        }
    }

    public void forceError(Object message, Throwable t) {
        boolean wasIgnored = Logger.observeThread();
        this.error(message, t);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void error(Object message, Object o) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isErrorEnabled()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.error(message.toString() + ": " + ostring);
        }
    }

    public void forceError(Object message, Object o) {
        boolean wasIgnored = Logger.observeThread();
        this.error(message, o);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void warning(Object message) {
        this.warn(message);
    }

    public void warning(Throwable t) {
        this.warning((Object)STANDARD_MESSAGE, t);
    }

    public void warning(Object message, Throwable t) {
        this.warn(message, t);
    }

    public void warning(Object message, Object o) {
        this.warn(message, o);
    }

    public void warn(Object message) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isWarnEnabled()) {
            this.getNativeLog().warn(this.prefixMessage(message));
        }
    }

    public void warn(Throwable t) {
        this.warn((Object)STANDARD_MESSAGE, t);
    }

    public void forceWarn(Object message) {
        boolean wasIgnored = Logger.observeThread();
        this.warn(message);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void warn(Object message, Throwable t) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isWarnEnabled()) {
            this.getNativeLog().warn(this.prefixMessage(message), Logger.getRealTargetException(t));
        }
    }

    public void forceWarn(Object message, Throwable t) {
        boolean wasIgnored = Logger.observeThread();
        this.warn(message, t);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void warn(Object message, Object o) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isWarnEnabled()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.warn(message.toString() + ": " + ostring);
        }
    }

    public void forceWarn(Object message, Object o) {
        boolean wasIgnored = Logger.observeThread();
        this.warn(message, o);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void info(Object message, Throwable t) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isInfoEnabled()) {
            this.getNativeLog().info(this.prefixMessage(message), Logger.getRealTargetException(t));
        }
    }

    public void forceInfo(Object message) {
        boolean wasIgnored = Logger.observeThread();
        this.info(message);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void info(Object message) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isInfoEnabled()) {
            this.getNativeLog().info(this.prefixMessage(message));
        }
    }

    public void forceInfo(Object message, Throwable t) {
        boolean wasIgnored = Logger.observeThread();
        this.info(message, t);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void info(Object message, Object o) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isInfoEnabled()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.info(message.toString() + ": " + ostring);
        }
    }

    public void forceInfo(Object message, Object o) {
        boolean wasIgnored = Logger.observeThread();
        this.info(message, o);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void debug(Object message) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isDebugEnabled()) {
            this.getNativeLog().debug(this.prefixMessage(message));
        }
    }

    public void forceDebug(Object message) {
        boolean wasIgnored = Logger.observeThread();
        this.debug(message);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void debug(Object message, Throwable t) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isDebugEnabled()) {
            this.getNativeLog().debug(this.prefixMessage(message), Logger.getRealTargetException(t));
        }
    }

    public void forceDebug(Object message, Throwable t) {
        boolean wasIgnored = Logger.observeThread();
        this.debug(message, t);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public void debug(Object message, Object o) {
        if (Logger.threadDisabled() || Logger.threadIgnored()) {
            return;
        }
        if (this.isDebugEnabled()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.debug(message.toString() + ": " + ostring);
        }
    }

    public void forceDebug(Object message, Object o) {
        boolean wasIgnored = Logger.observeThread();
        this.debug(message, o);
        if (wasIgnored) {
            Logger.ignoreThread();
        }
    }

    public boolean isFatalEnabled() {
        return this.isEnabledFor(FATAL);
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor(INFO);
    }

    public boolean isWarnEnabled() {
        return this.isEnabledFor(WARN);
    }

    public boolean isErrorEnabled() {
        return this.isEnabledFor(ERROR);
    }

    public boolean isEnabledFor(Level level) {
        if (!logEnabled) {
            return false;
        }
        if (Logger.threadDisabled()) {
            return false;
        }
        ILogger log = this.getNativeLog();
        if (this.level != null) {
            return level.isGreaterOrEqual(this.level);
        }
        if (FATAL.equals(level)) {
            return log.isFatalEnabled();
        }
        if (ERROR.equals(level)) {
            return log.isErrorEnabled();
        }
        if (WARN.equals(level)) {
            return log.isWarnEnabled();
        }
        if (INFO.equals(level)) {
            return log.isInfoEnabled();
        }
        return log.isDebugEnabled();
    }

    private static Stack getThreadContext() {
        Stack s = threadContext.get();
        if (s == null) {
            s = new Stack();
            threadContext.set(s);
        }
        return s;
    }

    public static void clearMDC() {
        if (staticLog == null) {
            return;
        }
        staticLog.getNativeLog().clearMDC();
    }

    public static void putMDC(String key, Object o) {
        if (staticLog == null) {
            return;
        }
        staticLog.getNativeLog().putMDC(key, o);
    }

    public static void removeMDC(String key) {
        if (staticLog == null) {
            return;
        }
        staticLog.getNativeLog().removeMDC(key);
    }

    public static Object getMDC(String key) {
        if (staticLog == null) {
            return null;
        }
        return staticLog.getNativeLog().getMDC(key);
    }

    public static Map getMDC() {
        if (staticLog == null) {
            return null;
        }
        return staticLog.getNativeLog().getMDC();
    }

    public static void pushContext(String message) {
        Logger.getThreadContext().push(message);
    }

    public static boolean containsContext(String message) {
        return Logger.getThreadContext().contains(message);
    }

    public static boolean pushUniqueContext(String message) {
        Stack s = Logger.getThreadContext();
        if (!Logger.containsContext(message)) {
            s.push(message);
            return true;
        }
        return false;
    }

    public static void popContext() {
        Stack s = Logger.getThreadContext();
        try {
            s.pop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String peekContext() {
        Stack s = Logger.getThreadContext();
        if (s.empty()) {
            return null;
        }
        return s.toString();
    }

    public static void removeContext() {
        threadContext.remove();
    }

    public Level getLevel() {
        if (Logger.threadDisabled()) {
            return OFF;
        }
        if (useLog4j) {
            return this.getNativeLog().getLevel();
        }
        return null;
    }

    public void setLevel(Level level) {
        if (Logger.threadDisabled()) {
            return;
        }
        if (useLog4j) {
            this.getNativeLog().setLevel(level);
        }
    }

    public Level getInstanceLevel() {
        if (this.level != null) {
            return this.level;
        }
        return this.getLevel();
    }

    public void setInstanceLevel(Level level) {
        this.level = level;
    }

    public static void saveCurrentThreshold(String category) {
        if (Logger.threadDisabled()) {
            return;
        }
        if (Logger._useLog4j2()) {
            try {
                Object logger;
                Object ctx = Logger._getLoggerContext();
                if (ctx != null && (logger = Reflection.invokeMethod(ctx, "getLogger", category)) != null) {
                    Level level = fromLog4j.get(Reflection.invokeMethod(logger, "getLevel"));
                    savedThresholds.put(category, level);
                    return;
                }
            }
            catch (Exception ex) {
                System.out.println("ISC: Failed to _saveCurrentThreshold: " + ex.getMessage());
            }
        }
        if (useLog4j) {
            Level level = Log4jLogger.getLevelForCategory(category);
            savedThresholds.put(category, level);
        }
    }

    public static void restoreSavedThresholds() {
        if (Logger.threadDisabled()) {
            return;
        }
        if (Logger._useLog4j2()) {
            try {
                Object ctx = Logger._getLoggerContext();
                if (ctx != null) {
                    Object configuration = Reflection.invokeMethod(ctx, "getConfiguration");
                    for (Map.Entry<String, Level> entry : savedThresholds.entrySet()) {
                        Object cfg = Reflection.invokeMethod(configuration, "getLoggerConfig", entry.getKey());
                        if (cfg == null) continue;
                        Reflection.invokeMethod(cfg, "setLevel", toLog4j.get(entry.getValue()));
                    }
                    Reflection.invokeMethod(ctx, "updateLoggers");
                    savedThresholds.clear();
                    return;
                }
            }
            catch (Exception ex) {
                System.out.println("ISC: Failed to _restoreSavedThresholds(): " + ex.getMessage());
            }
        }
        if (useLog4j) {
            for (Map.Entry<String, Level> entry : savedThresholds.entrySet()) {
                Log4jLogger.setLevelForCategory(entry.getKey(), entry.getValue());
            }
            savedThresholds.clear();
        }
    }

    public static boolean _useLog4j2() {
        return useLog4j2 && log4j2Present;
    }

    public static String _log4j2RMA() {
        return useLog4j2 && log4j2Present ? log4j2RMA : null;
    }

    private static Object _getLoggerContext() throws Exception {
        if (_context == null) {
            _context = Reflection.invokeStaticMethod("org.apache.logging.log4j.LogManager", "getContext", false);
        }
        return _context;
    }

    private static void _setLoggerContext(Object newContext) {
        _context = newContext;
    }

    private static List _getCurrentLoggers() {
        ArrayList<DataTypeMap> loggers = new ArrayList<DataTypeMap>();
        try {
            Object ctx = Logger._getLoggerContext();
            if (ctx != null) {
                Object configuration = Reflection.invokeMethod(ctx, "getConfiguration");
                Map cfgMap = (Map)Reflection.invokeMethod(configuration, "getLoggers");
                for (Object cfg : cfgMap.values()) {
                    loggers.add(DataTools.buildMap("category", Reflection.invokeMethod(cfg, "getName"), "threshold", Reflection.invokeMethod(cfg, "getLevel").toString()));
                }
            }
        }
        catch (Exception ex) {
            System.out.println("ISC: Log4j2 failed to _getCurrentLogger(): " + ex.getMessage());
        }
        return loggers;
    }

    private static void _setLevelForCategory(String category, String level) {
        try {
            Object ctx = Logger._getLoggerContext();
            if (ctx != null) {
                Object configuration = Reflection.invokeMethod(ctx, "getConfiguration");
                Object cfg = Reflection.invokeMethod(configuration, "getLoggerConfig", category);
                if (cfg != null) {
                    Object levelConverted = Reflection.invokeStaticMethod("org.apache.logging.log4j.Level", "toLevel", level);
                    Reflection.invokeMethod(cfg, "setLevel", levelConverted);
                    Reflection.invokeMethod(ctx, "updateLoggers");
                }
            }
        }
        catch (Exception ex) {
            System.out.println("ISC: Log4j2 failed to _setLevelForCategory(): " + ex.getMessage());
        }
    }

    static {
        OFF = new Level(0);
        FATAL = new Level(0);
        ERROR = new Level(3);
        WARN = new Level(4);
        INFO = new Level(6);
        DEBUG = new Level(7);
        ALL = new Level(7);
        logEnabled = true;
        prefixWithPackage = false;
        useSlf4j = false;
        useLog4jConfig = true;
        useLog4j = true;
        useLog4j2 = false;
        log4j2Present = false;
        log4j2RMA = null;
        disableThreads = new ThreadLocal();
        ignoreThreads = new ThreadLocal();
        try {
            String sUseLog4j2;
            String sLogEnabled = System.getProperty("iscLogEnabled");
            if ("false".equals(sLogEnabled)) {
                logEnabled = false;
            }
            if ("true".equals(sUseLog4j2 = System.getProperty("iscUseLog4j2"))) {
                useLog4j2 = true;
                useSlf4j = true;
                useLog4j = false;
                log4j2RMA = System.getProperty("iscLog4j2RMA", "com.isomorphic.log.RevolvingMemoryAppenderImpl");
            } else {
                String sUseSlf4j = System.getProperty("iscUseSlf4j");
                if ("true".equals(sUseSlf4j)) {
                    useSlf4j = true;
                }
                if (useSlf4j) {
                    String sUseLog4jConfig = System.getProperty("iscUseLog4jConfig");
                    if ("false".equals(sUseLog4jConfig)) {
                        useLog4jConfig = false;
                    }
                    useLog4j = false;
                }
            }
            if (useLog4j) {
                Log4jLogger.init(logEnabled);
            }
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            try {
                sw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("ISC: ERROR: Unable to configure log4j - logging may not be available.\r\n" + sw.toString());
        }
        try {
            Class.forName("org.apache.logging.log4j.LogManager");
            log4j2Present = true;
        }
        catch (ClassNotFoundException e) {
            log4j2Present = false;
        }
        threadContext = new ThreadLocal();
        savedThresholds = Collections.synchronizedMap(new HashMap());
        _context = null;
        toLog4j = new HashMap<Level, Object>(){
            {
                try {
                    this.put(ALL, Class.forName("org.apache.logging.log4j.Level").getDeclaredField("ALL"));
                    this.put(OFF, Class.forName("org.apache.logging.log4j.Level").getDeclaredField("OFF"));
                    this.put(FATAL, Class.forName("org.apache.logging.log4j.Level").getDeclaredField("FATAL"));
                    this.put(ERROR, Class.forName("org.apache.logging.log4j.Level").getDeclaredField("ERROR"));
                    this.put(WARN, Class.forName("org.apache.logging.log4j.Level").getDeclaredField("WARN"));
                    this.put(INFO, Class.forName("org.apache.logging.log4j.Level").getDeclaredField("INFO"));
                    this.put(DEBUG, Class.forName("org.apache.logging.log4j.Level").getDeclaredField("DEBUG"));
                }
                catch (Exception ex) {
                    System.out.println("ISC: Failed to get Log4j2 logging levels: " + ex.getMessage());
                }
            }
        };
        fromLog4j = new HashMap<Object, Level>(){
            {
                try {
                    this.put(Class.forName("org.apache.logging.log4j.Level").getDeclaredField("ALL"), ALL);
                    this.put(Class.forName("org.apache.logging.log4j.Level").getDeclaredField("OFF"), OFF);
                    this.put(Class.forName("org.apache.logging.log4j.Level").getDeclaredField("FATAL"), FATAL);
                    this.put(Class.forName("org.apache.logging.log4j.Level").getDeclaredField("ERROR"), ERROR);
                    this.put(Class.forName("org.apache.logging.log4j.Level").getDeclaredField("WARN"), WARN);
                    this.put(Class.forName("org.apache.logging.log4j.Level").getDeclaredField("INFO"), INFO);
                    this.put(Class.forName("org.apache.logging.log4j.Level").getDeclaredField("DEBUG"), DEBUG);
                    this.put(Class.forName("org.apache.logging.log4j.Level").getDeclaredField("TRACE"), ALL);
                }
                catch (Exception ex) {
                    System.out.println("ISC: Failed to get Log4j2 logging levels: " + ex.getMessage());
                }
            }
        };
    }
}

