/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.drawing;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * A class used to define a shadow used in a Draw&lt;Shape&gt; Types.
 */
@BeanFactory.FrameworkClass
public class Shadow extends DataClass {

    public static Shadow getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new Shadow(jsObj);
    }
        


    public Shadow(){
        
    }

    public Shadow(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }


    // ********************* Properties / Attributes ***********************

    /**
     * 
     *
     * @param blur New blur value. Default value is 10
     * @return {@link com.smartgwt.client.widgets.drawing.Shadow Shadow} instance, for chaining setter calls
     */
    public Shadow setBlur(int blur) {
        return (Shadow)setAttribute("blur", blur);
    }

    /**
     * 
     *
     * @return Current blur value. Default value is 10
     */
    public int getBlur()  {
        return getAttributeAsInt("blur");
    }
    

    /**
     * 
     *
     * @param color New color value. Default value is black
     * @return {@link com.smartgwt.client.widgets.drawing.Shadow Shadow} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public Shadow setColor(String color) {
        return (Shadow)setAttribute("color", color);
    }

    /**
     * 
     *
     * @return Current color value. Default value is black
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public String getColor()  {
        return getAttributeAsString("color");
    }
    

    /**
     * 
     *
     * @param offset New offset value. Default value is [0,0]
     * @return {@link com.smartgwt.client.widgets.drawing.Shadow Shadow} instance, for chaining setter calls
     */
    public Shadow setOffset(Point offset) {
        return (Shadow)setAttribute("offset", offset == null ? null : offset.getJsObj());
    }

    /**
     * 
     *
     * @return Current offset value. Default value is [0,0]
     */
    public Point getOffset()  {
        return Point.getOrCreateRef(getAttributeAsJavaScriptObject("offset"));
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
