package com.smartgwt.sample.showcase.client.forms;

import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.layout.LayoutSpacer;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.ToggleSwitch;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ToggleItem;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;

public class ToggleSwitchSample extends ShowcasePanel {
    private static final String DESCRIPTION = "<p>The ToggleSwitch implements the standard toggle appearance popularized "+
        "in mobile interfaces. ToggleItem is a FormItem based on ToggleSwitch, which can manage a boolean value.";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
        	ToggleSwitchSample panel = new ToggleSwitchSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {
        Label toggleSwitchLabel = new Label();
    	toggleSwitchLabel.setWidth(300);
    	toggleSwitchLabel.setHeight(25);
    	toggleSwitchLabel.setContents("Standalone Toggle");
    	toggleSwitchLabel.setBaseStyle("exampleSeparator");

        ToggleSwitch toggleSwitch = new ToggleSwitch();
        
        LayoutSpacer layoutSpacer = new LayoutSpacer();
        layoutSpacer.setHeight(20);
        
        Label toggleItemLabel = new Label();
    	toggleItemLabel.setWidth(300);
    	toggleItemLabel.setHeight(25);
    	toggleItemLabel.setContents("Toggle in a form");
    	toggleItemLabel.setBaseStyle("exampleSeparator");
    	
        ToggleItem toggleItem = new ToggleItem();
        toggleItem.setTitle("Enable Noise Cancellation");
        toggleItem.setWrapTitle(false);

        DynamicForm form = new DynamicForm();
        form.setFields(toggleItem);

        VLayout vLayout = new VLayout();
        vLayout.setMembersMargin(5);
        vLayout.addMember(toggleSwitchLabel);
        vLayout.addMember(toggleSwitch);
        vLayout.addMember(layoutSpacer);
        vLayout.addMember(toggleItemLabel);
        vLayout.addMember(form);

        return vLayout;
    }

    public String getIntro() {
        return DESCRIPTION;
    }
}
