/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Context for an ongoing build-UI-via-AI operation.
 */
@BeanFactory.FrameworkClass
public class BuildUIViaAIContext extends BuildViaAIContext {

    public static BuildUIViaAIContext getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof BuildUIViaAIContext) {
            existingObj.setJsObj(jsObj);
            return (BuildUIViaAIContext)existingObj;
        } else

        {
            return new BuildUIViaAIContext(jsObj);
        }
    }
        


    public BuildUIViaAIContext(){
        
    }

    public BuildUIViaAIContext(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * The initial request. It is read-only; do not modify it during handling of the request.
     *
     * @param buildRequest New buildRequest value. Default value is null
     * @return {@link com.smartgwt.client.ai.BuildUIViaAIContext BuildUIViaAIContext} instance, for chaining setter calls
     */
    public BuildUIViaAIContext setBuildRequest(BuildUIViaAIRequest buildRequest) {
        return (BuildUIViaAIContext)setAttribute("buildRequest", buildRequest == null ? null : buildRequest.getJsObj());
    }

    /**
     * The initial request. It is read-only; do not modify it during handling of the request.
     *
     * @return Current buildRequest value. Default value is null
     */
    public BuildUIViaAIRequest getBuildRequest()  {
        return BuildUIViaAIRequest.getOrCreateRef(getAttributeAsJavaScriptObject("buildRequest"));
    }
    

    /**
     * The working JavaScript code.
     *
     * @param jsCode New jsCode value. Default value is null
     * @return {@link com.smartgwt.client.ai.BuildUIViaAIContext BuildUIViaAIContext} instance, for chaining setter calls
     */
    public BuildUIViaAIContext setJSCode(String jsCode) {
        return (BuildUIViaAIContext)setAttribute("jsCode", jsCode);
    }

    /**
     * The working JavaScript code.
     *
     * @return Current jsCode value. Default value is null
     */
    public String getJSCode()  {
        return getAttributeAsString("jsCode");
    }
    

    /**
     * The working PaletteNodes.
     *
     * @param nodes New nodes value. Default value is null
     * @return {@link com.smartgwt.client.ai.BuildUIViaAIContext BuildUIViaAIContext} instance, for chaining setter calls
     */
    public BuildUIViaAIContext setNodes(PaletteNode... nodes) {
        return (BuildUIViaAIContext)setAttribute("nodes", nodes);
    }

    /**
     * The working PaletteNodes.
     *
     * @return Current nodes value. Default value is null
     */
    public PaletteNode[] getNodes()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfPaletteNode(getAttributeAsJavaScriptObject("nodes"));
    }
    

    /**
     * The AI-selected UI type.
     *
     * @param uiType New uiType value. Default value is null
     * @return {@link com.smartgwt.client.ai.BuildUIViaAIContext BuildUIViaAIContext} instance, for chaining setter calls
     */
    public BuildUIViaAIContext setUIType(String uiType) {
        return (BuildUIViaAIContext)setAttribute("uiType", uiType);
    }

    /**
     * The AI-selected UI type.
     *
     * @return Current uiType value. Default value is null
     */
    public String getUIType()  {
        return getAttributeAsString("uiType");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
