/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Base class for a representation of a high-level request to AI to build something.
 */
@BeanFactory.FrameworkClass
public class BuildViaAIRequest extends AsyncOperationParams {

    public static BuildViaAIRequest getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof BuildViaAIRequest) {
            existingObj.setJsObj(jsObj);
            return (BuildViaAIRequest)existingObj;
        } else

        {
            return new BuildViaAIRequest(jsObj);
        }
    }
        


    public BuildViaAIRequest(){
        
    }

    public BuildViaAIRequest(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * The maximum number of retries of any one particular request to an AI engine. <p> Note that multiple AI requests may be
     * involved in processing the build request. This limit is the maximum number of retries of any one request. For example,
     * if there are 2 requests made to AI, then each one would be submitted at most <code>1 + maxRetries</code> number of times
     * for up to <code>2 * (1 + maxRetries)</code> total requests.
     *
     * @param maxRetries New maxRetries value. Default value is 2
     * @return {@link com.smartgwt.client.ai.BuildViaAIRequest BuildViaAIRequest} instance, for chaining setter calls
     */
    public BuildViaAIRequest setMaxRetries(Integer maxRetries) {
        return (BuildViaAIRequest)setAttribute("maxRetries", maxRetries);
    }

    /**
     * The maximum number of retries of any one particular request to an AI engine. <p> Note that multiple AI requests may be
     * involved in processing the build request. This limit is the maximum number of retries of any one request. For example,
     * if there are 2 requests made to AI, then each one would be submitted at most <code>1 + maxRetries</code> number of times
     * for up to <code>2 * (1 + maxRetries)</code> total requests.
     *
     * @return Current maxRetries value. Default value is 2
     */
    public Integer getMaxRetries()  {
        return getAttributeAsInt("maxRetries");
    }
    
    

    /**
     * When {@link com.smartgwt.client.ai.BuildViaAIRequest#getShowProgressDialog showing a progress dialog}, the {@link
     * com.smartgwt.client.widgets.ai.BuildViaAIProgressDialog} properties to apply.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param progressDialogProperties New progressDialogProperties value. Default value is null
     * @return {@link com.smartgwt.client.ai.BuildViaAIRequest BuildViaAIRequest} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public BuildViaAIRequest setProgressDialogProperties(BuildViaAIProgressDialog progressDialogProperties) {
        if (progressDialogProperties != null) {
            if (progressDialogProperties.isCreated()) {
                ConfigUtil.warnOfPreConfigInstantiation(BuildViaAIRequest.class, "setProgressDialogProperties", "BuildViaAIProgressDialog");
            }
            progressDialogProperties.setConfigOnly(true);
        }
        JavaScriptObject config = progressDialogProperties == null ? null : progressDialogProperties.getConfig();
        return (BuildViaAIRequest)setAttribute("progressDialogProperties", JSOHelper.cleanProperties(config, true));
    }

    /**
     * When {@link com.smartgwt.client.ai.BuildViaAIRequest#getShowProgressDialog showing a progress dialog}, the {@link
     * com.smartgwt.client.widgets.ai.BuildViaAIProgressDialog} properties to apply.
     *
     * @return Current progressDialogProperties value. Default value is null
     */
    public BuildViaAIProgressDialog getProgressDialogProperties()  {
        BuildViaAIProgressDialog properties = new BuildViaAIProgressDialog();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("progressDialogProperties"));
        return properties;
    }
    

    /**
     * Whether to show a progress dialog to inform the user about the processing of the build-request.
     *
     * @param showProgressDialog New showProgressDialog value. Default value is true
     * @return {@link com.smartgwt.client.ai.BuildViaAIRequest BuildViaAIRequest} instance, for chaining setter calls
     */
    public BuildViaAIRequest setShowProgressDialog(Boolean showProgressDialog) {
        return (BuildViaAIRequest)setAttribute("showProgressDialog", showProgressDialog);
    }

    /**
     * Whether to show a progress dialog to inform the user about the processing of the build-request.
     *
     * @return Current showProgressDialog value. Default value is true
     */
    public Boolean getShowProgressDialog()  {
        Boolean result = getAttributeAsBoolean("showProgressDialog", true);
        return result == null ? true : result;
    }
    

    /**
     * The user's request to AI in the context of this build-via-AI operation.
     *
     * @param userAIRequest New userAIRequest value. Default value is null
     * @return {@link com.smartgwt.client.ai.BuildViaAIRequest BuildViaAIRequest} instance, for chaining setter calls
     */
    public BuildViaAIRequest setUserAIRequest(UserAIRequest userAIRequest) {
        return (BuildViaAIRequest)setAttribute("userAIRequest", userAIRequest == null ? null : userAIRequest.getJsObj());
    }

    /**
     * The user's request to AI in the context of this build-via-AI operation.
     *
     * @return Current userAIRequest value. Default value is null
     */
    public UserAIRequest getUserAIRequest()  {
        return UserAIRequest.getOrCreateRef(getAttributeAsJavaScriptObject("userAIRequest"));
    }
    

    /**
     * Whether the user can cancel the build-request. If {@link com.smartgwt.client.ai.BuildViaAIRequest#getShowProgressDialog
     * showProgressDialog} is <code>true</code>, then the progress dialog will have a cancel button if
     * <code>userCanCancel</code> is set. <p> Other user cancellation mechanisms may be added in the future, but
     * <code>userCanCancel</code> will be respected.
     *
     * @param userCanCancel New userCanCancel value. Default value is true
     * @return {@link com.smartgwt.client.ai.BuildViaAIRequest BuildViaAIRequest} instance, for chaining setter calls
     */
    public BuildViaAIRequest setUserCanCancel(Boolean userCanCancel) {
        return (BuildViaAIRequest)setAttribute("userCanCancel", userCanCancel);
    }

    /**
     * Whether the user can cancel the build-request. If {@link com.smartgwt.client.ai.BuildViaAIRequest#getShowProgressDialog
     * showProgressDialog} is <code>true</code>, then the progress dialog will have a cancel button if
     * <code>userCanCancel</code> is set. <p> Other user cancellation mechanisms may be added in the future, but
     * <code>userCanCancel</code> will be respected.
     *
     * @return Current userCanCancel value. Default value is true
     */
    public Boolean getUserCanCancel()  {
        Boolean result = getAttributeAsBoolean("userCanCancel", true);
        return result == null ? true : result;
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
