/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MutationQueryLogging;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.mutation.internal.TableKeyExpressionCollector;
import org.hibernate.query.sqm.mutation.internal.temptable.AbstractDeleteExecutionDelegate;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.ColumnReferenceCheckingSqlAstWalker;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithTemporaryTableHelper;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithoutIdTableHelper;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.MutatingTableReferenceGroupWrapper;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateCollector;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class RestrictedDeleteExecutionDelegate
extends AbstractDeleteExecutionDelegate {
    public RestrictedDeleteExecutionDelegate(EntityMappingType entityDescriptor, TemporaryTable idTable, AfterUseAction afterUseAction, SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref, QueryOptions queryOptions, LoadQueryInfluencers loadQueryInfluencers, QueryParameterBindings queryParameterBindings, Function<SharedSessionContractImplementor, String> sessionUidAccess, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, idTable, afterUseAction, sqmDelete, domainParameterXref, queryOptions, loadQueryInfluencers, queryParameterBindings, sessionUidAccess, sessionFactory);
    }

    @Override
    public int execute(DomainQueryExecutionContext executionContext) {
        EntityPersister entityDescriptor = this.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(((SqmRoot)this.getSqmDelete().getTarget()).getEntityName());
        String hierarchyRootTableName = ((Joinable)((Object)entityDescriptor)).getTableName();
        TableGroup deletingTableGroup = this.getConverter().getMutatingTableGroup();
        TableReference hierarchyRootTableReference = deletingTableGroup.resolveTableReference(deletingTableGroup.getNavigablePath(), hierarchyRootTableName);
        assert (hierarchyRootTableReference != null);
        Predicate specifiedRestriction = this.getConverter().visitWhereClause(this.getSqmDelete().getWhereClause());
        PredicateCollector predicateCollector = new PredicateCollector(specifiedRestriction);
        entityDescriptor.applyBaseRestrictions(predicateCollector, deletingTableGroup, true, executionContext.getSession().getLoadQueryInfluencers().getEnabledFilters(), null, this.getConverter());
        this.getConverter().pruneTableGroupJoins();
        ColumnReferenceCheckingSqlAstWalker walker = new ColumnReferenceCheckingSqlAstWalker(hierarchyRootTableReference.getIdentificationVariable());
        if (predicateCollector.getPredicate() != null) {
            predicateCollector.getPredicate().accept(walker);
        }
        boolean needsIdTable = !walker.isAllColumnReferencesFromIdentificationVariable() || entityDescriptor != entityDescriptor.getRootEntityDescriptor();
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext);
        if (needsIdTable) {
            return this.executeWithIdTable(predicateCollector.getPredicate(), deletingTableGroup, this.getConverter().getJdbcParamsBySqmParam(), this.getConverter().getSqmParameterMappingModelExpressibleResolutions(), executionContextAdapter);
        }
        return this.executeWithoutIdTable(predicateCollector.getPredicate(), deletingTableGroup, this.getConverter().getJdbcParamsBySqmParam(), this.getConverter().getSqmParameterMappingModelExpressibleResolutions(), this.getConverter().getSqlExpressionResolver(), executionContextAdapter);
    }

    private int executeWithoutIdTable(Predicate suppliedPredicate, TableGroup tableGroup, Map<SqmParameter<?>, List<List<JdbcParameter>>> restrictionSqmParameterResolutions, final Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions, SqlExpressionResolver sqlExpressionResolver, ExecutionContext executionContext) {
        assert (this.getEntityDescriptor() == this.getEntityDescriptor().getRootEntityDescriptor());
        EntityPersister rootEntityPersister = this.getEntityDescriptor().getEntityPersister();
        String rootTableName = ((Joinable)((Object)rootEntityPersister)).getTableName();
        NamedTableReference rootTableReference = (NamedTableReference)tableGroup.resolveTableReference(tableGroup.getNavigablePath(), rootTableName);
        QuerySpec matchingIdSubQuerySpec = ExecuteWithoutIdTableHelper.createIdMatchingSubQuerySpec(tableGroup.getNavigablePath(), rootTableReference, suppliedPredicate, rootEntityPersister, sqlExpressionResolver, this.getSessionFactory());
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.getDomainParameterXref(), SqmUtil.generateJdbcParamsXref(this.getDomainParameterXref(), () -> restrictionSqmParameterResolutions), this.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> tableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)paramTypeResolutions.get(parameter);
            }
        }, executionContext.getSession());
        SqmMutationStrategyHelper.cleanUpCollectionTables(this.getEntityDescriptor(), (tableReference, attributeMapping) -> {
            if (suppliedPredicate == null) {
                return null;
            }
            ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
            QuerySpec idSelectFkSubQuery = fkDescriptor.getTargetPart().isEntityIdentifierMapping() ? matchingIdSubQuerySpec : ExecuteWithoutIdTableHelper.createIdMatchingSubQuerySpec(tableGroup.getNavigablePath(), rootTableReference, suppliedPredicate, rootEntityPersister, sqlExpressionResolver, this.getSessionFactory());
            return new InSubQueryPredicate(MappingModelCreationHelper.buildColumnReferenceExpression(new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, (NamedTableReference)tableReference), fkDescriptor, null, this.getSessionFactory()), idSelectFkSubQuery, false);
        }, jdbcParameterBindings, executionContext);
        if (rootTableReference instanceof UnionTableReference) {
            MutableInteger rows = new MutableInteger();
            this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> {
                NamedTableReference tableReference = new NamedTableReference(tableExpression, tableGroup.getPrimaryTableReference().getIdentificationVariable());
                QuerySpec idMatchingSubQuerySpec = suppliedPredicate == null ? null : matchingIdSubQuerySpec;
                rows.plus(this.deleteFromNonRootTableWithoutIdTable(tableReference, tableKeyColumnVisitationSupplier, sqlExpressionResolver, tableGroup, idMatchingSubQuerySpec, jdbcParameterBindings, executionContext));
            });
            return rows.get();
        }
        this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> {
            if (!tableExpression.equals(rootTableName)) {
                NamedTableReference tableReference = (NamedTableReference)tableGroup.getTableReference(tableGroup.getNavigablePath(), tableExpression, true);
                QuerySpec idMatchingSubQuerySpec = suppliedPredicate == null ? null : matchingIdSubQuerySpec;
                this.deleteFromNonRootTableWithoutIdTable(tableReference, tableKeyColumnVisitationSupplier, sqlExpressionResolver, tableGroup, idMatchingSubQuerySpec, jdbcParameterBindings, executionContext);
            }
        });
        return this.deleteFromRootTableWithoutIdTable(rootTableReference, suppliedPredicate, jdbcParameterBindings, executionContext);
    }

    private int deleteFromRootTableWithoutIdTable(NamedTableReference rootTableReference, Predicate predicate, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        return RestrictedDeleteExecutionDelegate.executeSqlDelete(new DeleteStatement(rootTableReference, predicate), jdbcParameterBindings, executionContext);
    }

    private int deleteFromNonRootTableWithoutIdTable(NamedTableReference targetTableReference, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, SqlExpressionResolver sqlExpressionResolver, TableGroup rootTableGroup, QuerySpec matchingIdSubQuerySpec, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        InSubQueryPredicate tableDeletePredicate;
        assert (targetTableReference != null);
        MutationQueryLogging.MUTATION_QUERY_LOGGER.tracef("deleteFromNonRootTable - %s", (Object)targetTableReference.getTableExpression());
        NamedTableReference deleteTableReference = new NamedTableReference(targetTableReference.getTableExpression(), "to_delete_", true);
        if (matchingIdSubQuerySpec == null) {
            tableDeletePredicate = null;
        } else {
            ArrayList deletingTableColumnRefs = new ArrayList();
            tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
                assert (deleteTableReference.getTableReference(selection.getContainingTableExpression()) != null);
                Expression expression = sqlExpressionResolver.resolveSqlExpression(deleteTableReference, selection);
                deletingTableColumnRefs.add((ColumnReference)expression);
            });
            Expression deletingTableColumnRefsExpression = deletingTableColumnRefs.size() == 1 ? (Expression)deletingTableColumnRefs.get(0) : new SqlTuple(deletingTableColumnRefs, this.getEntityDescriptor().getIdentifierMapping());
            tableDeletePredicate = new InSubQueryPredicate(deletingTableColumnRefsExpression, matchingIdSubQuerySpec, false);
        }
        DeleteStatement sqlAstDelete = new DeleteStatement(deleteTableReference, tableDeletePredicate);
        int rows = RestrictedDeleteExecutionDelegate.executeSqlDelete(sqlAstDelete, jdbcParameterBindings, executionContext);
        MutationQueryLogging.MUTATION_QUERY_LOGGER.debugf("deleteFromNonRootTable - `%s` : %s rows", (Object)targetTableReference, (Object)rows);
        return rows;
    }

    private static int executeSqlDelete(DeleteStatement sqlAst, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcOperationQueryMutation jdbcDelete = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(factory, sqlAst).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        return jdbcServices.getJdbcMutationExecutor().execute(jdbcDelete, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeWithIdTable(Predicate predicate, TableGroup deletingTableGroup, Map<SqmParameter<?>, List<List<JdbcParameter>>> restrictionSqmParameterResolutions, final Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions, ExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.getDomainParameterXref(), SqmUtil.generateJdbcParamsXref(this.getDomainParameterXref(), () -> restrictionSqmParameterResolutions), this.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> deletingTableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)paramTypeResolutions.get(parameter);
            }
        }, executionContext.getSession());
        ExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(this.getIdTable(), executionContext);
        try {
            int n = this.executeUsingIdTable(predicate, executionContext, jdbcParameterBindings);
            return n;
        }
        finally {
            ExecuteWithTemporaryTableHelper.performAfterTemporaryTableUseActions(this.getIdTable(), this.getSessionUidAccess(), this.getAfterUseAction(), executionContext);
        }
    }

    private int executeUsingIdTable(Predicate predicate, ExecutionContext executionContext, JdbcParameterBindings jdbcParameterBindings) {
        int rows = ExecuteWithTemporaryTableHelper.saveMatchingIdsIntoIdTable(this.getConverter(), predicate, this.getIdTable(), this.getSessionUidAccess(), jdbcParameterBindings, executionContext);
        QuerySpec idTableIdentifierSubQuery = ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(this.getIdTable(), this.getSessionUidAccess(), this.getEntityDescriptor(), executionContext);
        SqmMutationStrategyHelper.cleanUpCollectionTables(this.getEntityDescriptor(), (tableReference, attributeMapping) -> {
            ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
            QuerySpec idTableFkSubQuery = fkDescriptor.getTargetPart().isEntityIdentifierMapping() ? idTableIdentifierSubQuery : ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(this.getIdTable(), fkDescriptor.getTargetPart(), this.getSessionUidAccess(), this.getEntityDescriptor(), executionContext);
            return new InSubQueryPredicate(MappingModelCreationHelper.buildColumnReferenceExpression(new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, (NamedTableReference)tableReference), fkDescriptor, null, this.getSessionFactory()), idTableFkSubQuery, false);
        }, JdbcParameterBindings.NO_BINDINGS, executionContext);
        this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> this.deleteFromTableUsingIdTable(tableExpression, tableKeyColumnVisitationSupplier, idTableIdentifierSubQuery, executionContext));
        return rows;
    }

    private void deleteFromTableUsingIdTable(String tableExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, QuerySpec idTableSubQuery, ExecutionContext executionContext) {
        MutationQueryLogging.MUTATION_QUERY_LOGGER.tracef("deleteFromTableUsingIdTable - %s", (Object)tableExpression);
        TableKeyExpressionCollector keyColumnCollector = new TableKeyExpressionCollector(this.getEntityDescriptor());
        NamedTableReference targetTable = new NamedTableReference(tableExpression, "to_delete_", true);
        tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
            assert (selection.getContainingTableExpression().equals(tableExpression));
            assert (!selection.isFormula());
            assert (selection.getCustomReadExpression() == null);
            assert (selection.getCustomWriteExpression() == null);
            keyColumnCollector.apply(new ColumnReference(targetTable, selection));
        });
        InSubQueryPredicate predicate = new InSubQueryPredicate(keyColumnCollector.buildKeyExpression(), idTableSubQuery, false);
        RestrictedDeleteExecutionDelegate.executeSqlDelete(new DeleteStatement(targetTable, predicate), JdbcParameterBindings.NO_BINDINGS, executionContext);
    }
}

