/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.base.ISCInvocationHandler;
import com.isomorphic.base.MethodArgPair;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.DBSandbox;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.WrappedDatabaseMetaData;
import com.isomorphic.sql.WrappedStatement;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class WrappedConnection
extends ISCInvocationHandler {
    protected static Logger log = new Logger(WrappedConnection.class.getName());
    protected static Config config = Config.getGlobal();
    private List<MethodArgPair> replayLog = new ArrayList<MethodArgPair>();
    public static ThreadLocal passivating = new ThreadLocal();
    String dbName;
    String schemaName;
    public DBSandbox sandbox = null;

    public static boolean methodAltersState(String methodName) {
        return methodName.startsWith("set");
    }

    public WrappedConnection(String dbName, String schemaName) {
        this.dbName = dbName;
        this.schemaName = schemaName;
    }

    public Object invoke(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?> methodReturnType = method.getReturnType();
        boolean autoTestRunning = config.getBoolean((Object)"autotest.instance.running", false);
        if (DBSandbox.isEnabled(this.dbName) && !autoTestRunning) {
            DBSandbox prevailingSandbox = DBSandbox.getPrevailingSandbox(this.dbName);
            if (prevailingSandbox != null || this.sandbox != null && prevailingSandbox != null && !prevailingSandbox.getSandboxName().equals(this.sandbox.getSandboxName())) {
                this.divertToSandbox(prevailingSandbox);
            } else if (prevailingSandbox == null && this.sandbox != null) {
                this.divertToPrimaryDB();
            } else if (DBSandbox.autoCreateOnWrite(this.dbName) && WrappedConnection.methodAltersState(methodName)) {
                log.debug((Object)("Recording API call in replayLog: " + methodName));
                this.replayLog.add(new MethodArgPair(methodName, args));
            }
        }
        if (this.sandbox != null) {
            log.debug((Object)("Invoking wrapped api method: " + String.valueOf(method) + " via sandbox: " + this.sandbox.getSandboxName()));
        }
        Object retVal = method.invoke(this.target, args);
        if (Statement.class.isAssignableFrom(methodReturnType)) {
            retVal = new WrappedStatement(this.dbName, this.schemaName, this, new MethodArgPair(methodName, args)).wrap(retVal);
        } else if (DatabaseMetaData.class.isAssignableFrom(methodReturnType)) {
            retVal = new WrappedDatabaseMetaData(this).wrap(retVal);
        }
        return retVal;
    }

    public Connection getWrappedConnection() {
        return (Connection)this.getWrappedInstance();
    }

    public Connection getUnwrappedConnection() {
        return (Connection)this.target;
    }

    public void setUnwrappedConnection(Connection conn) {
        this.target = conn;
    }

    public void divertToPrimaryDB() throws Exception {
        this.sandbox = null;
        Connection conn = this.getUnwrappedConnection();
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        conn = SQLDriver.instance(this.dbName).rawConnection();
        this.setUnwrappedConnection(conn);
    }

    public void divertToSandbox(DBSandbox sandbox) throws Exception {
        if (this.sandbox != null && sandbox.getSandboxName().equals(this.sandbox.getSandboxName())) {
            return;
        }
        if (DBSandbox.autoCreateOnWrite(this.dbName)) {
            sandbox.create();
        }
        this.sandbox = sandbox;
        Connection conn = this.getUnwrappedConnection();
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        conn = sandbox.openConnection();
        this.setUnwrappedConnection(conn);
        for (MethodArgPair replayEntry : this.replayLog) {
            Reflection.invokeMethod((Object)conn, (String)replayEntry.getMethodName(), (Object[])replayEntry.getArgs());
        }
        this.replayLog.clear();
    }
}

