/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.uuid;

import java.lang.reflect.Member;
import java.util.EnumSet;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.annotations.UuidGenerator;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.id.factory.spi.CustomIdGeneratorCreationContext;
import org.hibernate.id.uuid.CustomVersionOneStrategy;
import org.hibernate.id.uuid.StandardRandomStrategy;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.descriptor.java.UUIDJavaType;

public class UuidGenerator
implements BeforeExecutionGenerator {
    private final ValueGenerator generator;
    private final UUIDJavaType.ValueTransformer valueTransformer;

    private UuidGenerator(org.hibernate.annotations.UuidGenerator config, Member idMember) {
        this.generator = config.style() == UuidGenerator.Style.TIME ? new CustomVersionOneStrategy() : StandardRandomStrategy.INSTANCE;
        Class<?> propertyType = ReflectHelper.getPropertyType(idMember);
        if (UUID.class.isAssignableFrom(propertyType)) {
            this.valueTransformer = UUIDJavaType.PassThroughTransformer.INSTANCE;
        } else if (String.class.isAssignableFrom(propertyType)) {
            this.valueTransformer = UUIDJavaType.ToStringTransformer.INSTANCE;
        } else if (byte[].class.isAssignableFrom(propertyType)) {
            this.valueTransformer = UUIDJavaType.ToBytesTransformer.INSTANCE;
        } else {
            throw new HibernateException("Unanticipated return type [" + propertyType.getName() + "] for UUID conversion");
        }
    }

    public UuidGenerator(org.hibernate.annotations.UuidGenerator config, Member idMember, CustomIdGeneratorCreationContext creationContext) {
        this(config, idMember);
    }

    public UuidGenerator(org.hibernate.annotations.UuidGenerator config, Member member, GeneratorCreationContext creationContext) {
        this(config, member);
    }

    @Override
    public EnumSet<EventType> getEventTypes() {
        return EventTypeSets.INSERT_ONLY;
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object owner, Object currentValue, EventType eventType) {
        return this.valueTransformer.transform(this.generator.generateUuid(session));
    }

    static interface ValueGenerator {
        public UUID generateUuid(SharedSessionContractImplementor var1);
    }
}

