/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.js.JSTranslater;
import com.isomorphic.servlet.BaseFilter;
import com.isomorphic.servlet.ServletTools;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class MessagingAuthFilter
extends BaseFilter {
    protected static JSTranslater jsTrans = JSTranslater.instance();

    public void _doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (ServletTools.isRealtimeMessaging((String)httpRequest.getRequestURI())) {
            ArrayList<String> blockedChannels = new ArrayList<String>();
            try {
                Map queryParams = ServletTools.parseQueryString((String)httpRequest.getQueryString());
                Map channels = (Map)jsTrans.fromJS((String)queryParams.get("subscribedChannels"));
                for (String channel : channels.keySet()) {
                    if (this.authenticate(channel, httpRequest)) continue;
                    blockedChannels.add(channel);
                }
            }
            catch (Exception e) {
                this.log.forceError((Object)"Fatal error while authorizing messaging subscribe", (Throwable)e);
                return;
            }
            if (blockedChannels.size() > 0) {
                String message = "Not authorized to subscribe to channel(s): " + String.valueOf(blockedChannels);
                message = message + httpRequest.getRequestURI();
                ((HttpServletResponse)response).sendError(403, message);
                this.log.forceWarn((Object)message);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public boolean authenticate(String channel, HttpServletRequest request) {
        return true;
    }
}

