/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.collection.spi.PersistentMap;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class MapInitializer
extends AbstractImmediateCollectionInitializer {
    private static final String CONCRETE_NAME = MapInitializer.class.getSimpleName();
    private final DomainResultAssembler<?> mapKeyAssembler;
    private final DomainResultAssembler<?> mapValueAssembler;

    public MapInitializer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParentAccess parentAccess, LockMode lockMode, DomainResult<?> collectionKeyResult, DomainResult<?> collectionValueKeyResult, Fetch mapKeyFetch, Fetch mapValueFetch, boolean isResultInitializer, AssemblerCreationState creationState) {
        super(navigablePath, attributeMapping, parentAccess, lockMode, collectionKeyResult, collectionValueKeyResult, isResultInitializer, creationState);
        this.mapKeyAssembler = mapKeyFetch.createAssembler(this, creationState);
        this.mapValueAssembler = mapValueFetch.createAssembler(this, creationState);
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    @Override
    protected void forEachAssembler(Consumer<DomainResultAssembler<?>> consumer) {
        consumer.accept(this.mapKeyAssembler);
        consumer.accept(this.mapValueAssembler);
    }

    public @Nullable PersistentMap<?, ?> getCollectionInstance() {
        return (PersistentMap)super.getCollectionInstance();
    }

    @Override
    protected void readCollectionRow(CollectionKey collectionKey, List<Object> loadingState, RowProcessingState rowProcessingState) {
        Object key = this.mapKeyAssembler.assemble(rowProcessingState);
        if (key == null) {
            return;
        }
        Object value = this.mapValueAssembler.assemble(rowProcessingState);
        if (value == null) {
            return;
        }
        loadingState.add(new Object[]{key, value});
    }

    @Override
    protected void initializeSubInstancesFromParent(RowProcessingState rowProcessingState) {
        Initializer keyInitializer = this.mapKeyAssembler.getInitializer();
        Initializer valueInitializer = this.mapValueAssembler.getInitializer();
        if (keyInitializer != null || valueInitializer != null) {
            PersistentCollection map = this.getCollectionInstance();
            assert (map != null);
            for (Map.Entry entry : ((PersistentMap)map).entrySet()) {
                if (keyInitializer != null) {
                    keyInitializer.initializeInstanceFromParent(entry.getKey(), rowProcessingState);
                }
                if (valueInitializer == null) continue;
                valueInitializer.initializeInstanceFromParent(entry.getValue(), rowProcessingState);
            }
        }
    }

    public String toString() {
        return "MapInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

