/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FileSourceCaches {
    private static Logger log = new Logger(FileSourceCaches.class.getName());
    private static Set<String> negativeCache = new HashSet<String>();
    private static Map<String, Map> writeThruCache = new HashMap<String, Map>();
    public static final boolean useCache = Config.getGlobal().getBoolean((Object)"FileSource.use.cache", false);
    public static final boolean useNegativeCache = Config.getGlobal().getBoolean((Object)"FileSource.use.negative.cache", false);
    public static final boolean hasFileReturnsContents = Config.getGlobal().getBoolean((Object)"FileSource.hasFile.returns.contents", true);

    public static void clearNegativeCache() {
        if (!useNegativeCache) {
            log.debug("clearNegativeCache() called but useNegativeCache is false; ignoring");
            return;
        }
        log.debug("Clearing the negativeCache completely");
        negativeCache.clear();
    }

    public static void clearNegativeCache(DataSource fileSourceDS) {
        if (!useNegativeCache) {
            log.debug("clearNegativeCache(DS) called but useNegativeCache is false; ignoring");
            return;
        }
        log.debug("Clearing the negativeCache for DS " + fileSourceDS.getName());
        try {
            String sandboxName = fileSourceDS.getPrevailingSandboxOrDbName();
            if (sandboxName == null) {
                FileSourceCaches.clearNegativeCache();
                return;
            }
            log.debug("Clearing the negativeCache of entries for sandbox " + sandboxName);
            Iterator<String> i = negativeCache.iterator();
            while (i.hasNext()) {
                String key = i.next();
                if (!key.startsWith(sandboxName)) continue;
                i.remove();
            }
        }
        catch (Exception e) {
            log.warn(e);
        }
    }

    public static void addToNegativeCache(DataSource fileSourceDS, String fqFilename) {
        if (!useNegativeCache) {
            log.debug("addToNegativeCache() called for '" + fqFilename + "' but useNegativeCache is false; ignoring");
            return;
        }
        String key = FileSourceCaches.getKey(fileSourceDS, fqFilename);
        negativeCache.add(key);
        log.debug("Added entry for DS '" + fileSourceDS.getName() + "', filename '" + key + "' to the negative cache");
    }

    public static void removeFromNegativeCache(DataSource fileSourceDS, String fqFilename) {
        if (!useNegativeCache) {
            log.debug("removeFromNegativeCache() called for '" + fqFilename + "' but useNegativeCache is false; ignoring");
            return;
        }
        String key = FileSourceCaches.getKey(fileSourceDS, fqFilename);
        if (negativeCache.remove(key)) {
            log.debug("Removed entry for DS '" + fileSourceDS.getName() + "', filename '" + key + "' from the negative cache");
        } else {
            log.debug("removeFromNegativeCache() called for DS '" + fileSourceDS.getName() + "', filename '" + key + "', but that entry was not in the negative cache.  Ignoring");
        }
    }

    public static boolean isInNegativeCache(DataSource fileSourceDS, String fqFilename) {
        if (!useNegativeCache) {
            log.debug("isInNegativeCache() called for '" + fqFilename + "' but useNegativeCache is false; just returning false");
            return false;
        }
        String key = FileSourceCaches.getKey(fileSourceDS, fqFilename);
        if (key == null) {
            return false;
        }
        boolean inCache = negativeCache.contains(key);
        log.debug("Is there an entry for DS '" + fileSourceDS.getName() + "', filename '" + key + "' in the negative cache? " + (inCache ? "Yes" : "No"));
        return inCache;
    }

    public static void clearCache() {
        if (!useCache) {
            log.debug("clearCache() called but useCache is false; ignoring");
            return;
        }
        log.debug("Clearing the write-thru cache completely");
        writeThruCache.clear();
    }

    public static void clearCache(DataSource fileSourceDS) {
        if (!useCache) {
            log.debug("clearCache() called for fileSourceDS '" + fileSourceDS.getName() + "' but useCache is false; ignoring");
            return;
        }
        log.debug("Clearing the write-thru cache for DS " + fileSourceDS.getName());
        try {
            String sandboxName = fileSourceDS.getPrevailingSandboxOrDbName();
            if (sandboxName == null) {
                FileSourceCaches.clearCache();
                return;
            }
            log.debug("Clearing the write-thru cache of entries for sandbox " + sandboxName);
            for (String key : writeThruCache.keySet()) {
                if (!key.startsWith(sandboxName)) continue;
                writeThruCache.remove(key);
            }
        }
        catch (Exception e) {
            log.warn(e);
        }
    }

    public static void addToCache(DataSource fileSourceDS, String fqFilename, Map dsConfig) {
        if (!useCache) {
            log.debug("addToCache() called for '" + fqFilename + "' but useCache is false; ignoring");
            return;
        }
        String key = FileSourceCaches.getKey(fileSourceDS, fqFilename);
        if (key == null) {
            log.warn("Refusing to cache with null key for file name " + fqFilename);
        } else {
            writeThruCache.put(key, dsConfig);
            log.debug("Added entry for DS '" + fileSourceDS.getName() + "', filename '" + key + "' to the write-thru cache");
        }
    }

    public static void removeFromCache(DataSource fileSourceDS, String fqFilename) {
        if (!useCache) {
            log.debug("removeFromCache() called for '" + fqFilename + "' but useCache is false; ignoring");
            return;
        }
        String key = FileSourceCaches.getKey(fileSourceDS, fqFilename);
        writeThruCache.remove(key);
        log.debug("Removed '" + key + "' from the write-thru cache");
        log.debug("Remove entry for DS '" + fileSourceDS.getName() + "', filename '" + key + "' from the write-thru cache");
    }

    public static Map getFromCache(DataSource fileSourceDS, String fqFilename) {
        if (!useCache) {
            log.debug("getFromCache() called for '" + fqFilename + "' but useCache is false; returning null");
            return null;
        }
        String key = FileSourceCaches.getKey(fileSourceDS, fqFilename);
        Map file = writeThruCache.get(key);
        log.debug("Is there an entry for DS '" + fileSourceDS.getName() + "', filename '" + key + "' in the write-thru cache? " + (file == null ? "No" : "Yes"));
        return file;
    }

    private static String getKey(DataSource fileSourceDS, String fqFilename) {
        try {
            String sandboxName = fileSourceDS.getPrevailingSandboxOrDbName();
            String key = sandboxName == null ? fqFilename : sandboxName + "_" + fqFilename;
            return key;
        }
        catch (Exception e) {
            log.warn(e);
            return null;
        }
    }
}

