/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DB2iDialect;
import org.hibernate.dialect.DB2zDialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HANADialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MariaDBDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.PostgresPlusDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SpannerDialect;
import org.hibernate.dialect.SybaseASEDialect;
import org.hibernate.engine.jdbc.dialect.spi.BasicSQLExceptionConverter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.internal.util.config.ConfigurationHelper;

public enum Database {
    DB2{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            String databaseVersion = info.getDatabaseVersion();
            if (databaseVersion != null) {
                switch (databaseVersion.substring(0, 3)) {
                    case "SQL": {
                        return new DB2Dialect(info);
                    }
                    case "DSN": {
                        return new DB2zDialect(info);
                    }
                    case "QSQ": {
                        return new DB2iDialect(info);
                    }
                }
            }
            return new DB2Dialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return databaseName.startsWith("DB2");
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
    }
    ,
    DERBY{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new DerbyDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return "Apache Derby".equals(databaseName);
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return jdbcUrl.startsWith("jdbc:derby://") ? "org.apache.derby.jdbc.ClientDriver" : "org.apache.derby.jdbc.EmbeddedDriver";
        }
    }
    ,
    ENTERPRISEDB{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new PostgresPlusDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return "EnterpriseDB".equals(databaseName);
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "com.edb.Driver";
        }

        @Override
        public String getUrlPrefix() {
            return "jdbc:edb:";
        }
    }
    ,
    H2{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new H2Dialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return "H2".equals(databaseName);
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "org.h2.Driver";
        }
    }
    ,
    HSQL{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new HSQLDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return "HSQL Database Engine".equals(databaseName);
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "org.hsqldb.jdbc.JDBCDriver";
        }

        @Override
        public String getUrlPrefix() {
            return "jdbc:hsqldb:";
        }
    }
    ,
    HANA{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new HANADialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return "HDB".equals(databaseName);
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "com.sap.db.jdbc.Driver";
        }

        @Override
        public String getUrlPrefix() {
            return "jdbc:sap:";
        }
    }
    ,
    MARIADB{

        @Override
        public boolean matchesResolutionInfo(DialectResolutionInfo info) {
            if (this.productNameMatches(info.getDatabaseName())) {
                return true;
            }
            String driverName = info.getDriverName();
            return driverName != null && driverName.startsWith("MariaDB");
        }

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new MariaDBDialect(info);
        }

        @Override
        public boolean productNameMatches(String productName) {
            return "MariaDB".equals(productName);
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "org.mariadb.jdbc.Driver";
        }
    }
    ,
    MYSQL{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new MySQLDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return "MySQL".equals(databaseName);
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "com.mysql.cj.jdbc.Driver";
        }
    }
    ,
    ORACLE{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new OracleDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return "Oracle".equals(databaseName);
        }
    }
    ,
    POSTGRESQL{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            String version = this.getVersion(info);
            if (version.startsWith("Cockroach")) {
                return new CockroachDialect(info, version);
            }
            return new PostgreSQLDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return "PostgreSQL".equals(databaseName);
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "org.postgresql.Driver";
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getVersion(DialectResolutionInfo info) {
            DatabaseMetaData databaseMetaData = info.getDatabaseMetadata();
            if (databaseMetaData == null) return ConfigurationHelper.getString("hibernate.dialect.cockroach.version_string", info.getConfigurationValues(), "");
            try (Statement statement = databaseMetaData.getConnection().createStatement();){
                ResultSet rs = statement.executeQuery("select version()");
                if (!rs.next()) return ConfigurationHelper.getString("hibernate.dialect.cockroach.version_string", info.getConfigurationValues(), "");
                String string = rs.getString(1);
                return string;
            }
            catch (SQLException e) {
                throw BasicSQLExceptionConverter.INSTANCE.convert(e);
            }
        }
    }
    ,
    SPANNER{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new SpannerDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return databaseName.startsWith("Google Cloud Spanner");
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "com.google.cloud.spanner.jdbc.JdbcDriver";
        }
    }
    ,
    SQLSERVER{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new SQLServerDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return databaseName.startsWith("Microsoft SQL Server");
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
    }
    ,
    SYBASE{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            String databaseName = info.getDatabaseName();
            if (this.isASE(databaseName)) {
                return new SybaseASEDialect(info);
            }
            return null;
        }

        private boolean isASE(String databaseName) {
            return "Sybase SQL Server".equals(databaseName) || "Adaptive Server Enterprise".equals(databaseName) || "ASE".equals(databaseName);
        }

        @Override
        public boolean productNameMatches(String productName) {
            return this.isASE(productName);
        }

        @Override
        public boolean matchesUrl(String jdbcUrl) {
            return jdbcUrl.startsWith("jdbc:sybase:") || jdbcUrl.startsWith("jdbc:sqlanywhere:");
        }
    };


    public boolean matchesResolutionInfo(DialectResolutionInfo info) {
        return this.productNameMatches(info.getDatabaseName());
    }

    public abstract boolean productNameMatches(String var1);

    public abstract Dialect createDialect(DialectResolutionInfo var1);

    public String getDriverClassName(String jdbcUrl) {
        return null;
    }

    public String getUrlPrefix() {
        return "jdbc:" + this.toString().toLowerCase() + ":";
    }

    public boolean matchesUrl(String jdbcUrl) {
        return jdbcUrl.toLowerCase().startsWith(this.getUrlPrefix());
    }
}

