/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.VirtualModelPart;
import org.hibernate.metamodel.spi.ValueAccess;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableLoadingLogger;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntityInsideEmbeddableSelectFetchInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractEmbeddableInitializer
extends AbstractFetchParentAccess
implements EmbeddableInitializer,
ValueAccess {
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart embedded;
    private final FetchParentAccess fetchParentAccess;
    private final FetchParentAccess owningParent;
    private final EntityMappingType ownedModelPartDeclaringType;
    private final boolean isPartOfKey;
    private final boolean createEmptyCompositesEnabled;
    private final SessionFactoryImplementor sessionFactory;
    protected final DomainResultAssembler<?>[] assemblers;
    private final Object[] rowState;
    private State state = State.INITIAL;
    protected Object compositeInstance;
    private RowProcessingState wrappedProcessingState;

    public AbstractEmbeddableInitializer(EmbeddableResultGraphNode resultDescriptor, FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.embedded = resultDescriptor.getReferencedMappingContainer();
        this.fetchParentAccess = parentAccess;
        EmbeddableMappingType embeddableTypeDescriptor = this.embedded.getEmbeddableTypeDescriptor();
        int size = embeddableTypeDescriptor.getNumberOfFetchables();
        this.rowState = new Object[size];
        this.isPartOfKey = this.embedded.isEntityIdentifierMapping() || Initializer.isPartOfKey(this.navigablePath, parentAccess);
        this.owningParent = FetchParentAccess.determineOwningParent(parentAccess);
        this.ownedModelPartDeclaringType = FetchParentAccess.determineOwnedModelPartDeclaringType(this.embedded, parentAccess, this.owningParent);
        this.createEmptyCompositesEnabled = !this.isPartOfKey && embeddableTypeDescriptor.isCreateEmptyCompositesEnabled();
        this.sessionFactory = creationState.getSqlAstCreationContext().getSessionFactory();
        this.assemblers = this.createAssemblers(resultDescriptor, creationState, embeddableTypeDescriptor);
    }

    protected DomainResultAssembler<?>[] createAssemblers(EmbeddableResultGraphNode resultDescriptor, AssemblerCreationState creationState, EmbeddableMappingType embeddableTypeDescriptor) {
        int size = embeddableTypeDescriptor.getNumberOfFetchables();
        DomainResultAssembler[] assemblers = new DomainResultAssembler[size];
        for (int i = 0; i < size; ++i) {
            DomainResultAssembler<?> stateAssembler;
            Fetchable stateArrayContributor = embeddableTypeDescriptor.getFetchable(i);
            Fetch fetch = resultDescriptor.findFetch(stateArrayContributor);
            assemblers[i] = stateAssembler = fetch == null ? new NullValueAssembler(stateArrayContributor.getJavaType()) : fetch.createAssembler(this, creationState);
        }
        return assemblers;
    }

    @Override
    public EmbeddableValuedModelPart getInitializedPart() {
        return this.embedded;
    }

    @Override
    public FetchParentAccess getFetchParentAccess() {
        return this.fetchParentAccess;
    }

    @Override
    public @Nullable FetchParentAccess getOwningParent() {
        return this.owningParent;
    }

    @Override
    public @Nullable EntityMappingType getOwnedModelPartDeclaringType() {
        return this.ownedModelPartDeclaringType;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public Object getCompositeInstance() {
        return this.state == State.NULL ? null : this.compositeInstance;
    }

    @Override
    public boolean isPartOfKey() {
        return this.isPartOfKey;
    }

    @Override
    public FetchParentAccess findFirstEntityDescriptorAccess() {
        if (this.fetchParentAccess == null || this.embedded instanceof CollectionPart) {
            return null;
        }
        return this.fetchParentAccess.findFirstEntityDescriptorAccess();
    }

    @Override
    public EntityInitializer findFirstEntityInitializer() {
        FetchParentAccess firstEntityDescriptorAccess = this.findFirstEntityDescriptorAccess();
        if (firstEntityDescriptorAccess == null) {
            return null;
        }
        return firstEntityDescriptorAccess.findFirstEntityInitializer();
    }

    @Override
    public void resolveKey(RowProcessingState processingState) {
    }

    @Override
    public void resolveInstance(RowProcessingState processingState) {
    }

    @Override
    public void initializeInstance(RowProcessingState processingState) {
        EmbeddableLoadingLogger.EMBEDDED_LOAD_LOGGER.debugf("Initializing composite instance [%s]", (Object)this.navigablePath);
        switch (this.state) {
            case NULL: {
                return;
            }
            case INITIAL: {
                this.state = this.determinInitialState(processingState);
                if (this.state != State.INITIAL) {
                    return;
                }
                if (this.wrappedProcessingState == null) {
                    this.wrappedProcessingState = this.wrapProcessingState(processingState);
                }
                this.extractRowState(this.wrappedProcessingState);
                this.prepareCompositeInstance(this.wrappedProcessingState);
                if (this.state == State.NULL) {
                    return;
                }
                this.notifyResolutionListeners(this.compositeInstance);
            }
            case EXTRACTED: {
                if (this.embedded.getParentInjectionAttributePropertyAccess() != null || this.embedded instanceof VirtualModelPart) {
                    this.handleParentInjection();
                    LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(this.compositeInstance);
                    if (lazyInitializer != null) {
                        if (this.fetchParentAccess != null) {
                            this.fetchParentAccess.registerResolutionListener(entity -> {
                                this.embedded.getEmbeddableTypeDescriptor().setValues(entity, this.rowState);
                                this.state = State.INJECTED;
                            });
                            break;
                        }
                        Object target = this.embedded.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator().instantiate(this, this.sessionFactory);
                        this.state = State.INJECTED;
                        lazyInitializer.setImplementation(target);
                        break;
                    }
                    this.embedded.getEmbeddableTypeDescriptor().setValues(this.compositeInstance, this.rowState);
                    this.state = State.INJECTED;
                    break;
                }
                this.state = State.INJECTED;
            }
        }
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, RowProcessingState rowProcessingState) {
        Object instance;
        AttributeMapping attributeMapping = this.getInitializedPart().asAttributeMapping();
        this.compositeInstance = instance = attributeMapping != null ? attributeMapping.getValue(parentInstance) : parentInstance;
        this.state = State.INJECTED;
        if (instance != null) {
            for (DomainResultAssembler<?> assembler : this.assemblers) {
                Initializer initializer = assembler.getInitializer();
                if (initializer == null) continue;
                initializer.initializeInstanceFromParent(instance, rowProcessingState);
            }
        }
    }

    private void prepareCompositeInstance(RowProcessingState processingState) {
        if (this.fetchParentAccess != null && this.embedded instanceof VirtualModelPart && !this.isPartOfKey) {
            this.fetchParentAccess.resolveInstance(processingState);
            this.compositeInstance = this.fetchParentAccess.getInitializedInstance();
            EntityInitializer entityInitializer = this.fetchParentAccess.asEntityInitializer();
            if (entityInitializer != null && entityInitializer.isEntityInitialized()) {
                return;
            }
        }
        if (this.compositeInstance == null) {
            this.compositeInstance = this.createCompositeInstance(this.navigablePath, this.sessionFactory);
        }
        EmbeddableLoadingLogger.EMBEDDED_LOAD_LOGGER.debugf("Created composite instance [%s]", (Object)this.navigablePath);
    }

    private State determinInitialState(RowProcessingState rowProcessingState) {
        if (this.isPartOfKey || this.isResultInitializer()) {
            assert (!this.isParentShallowCached());
            return State.INITIAL;
        }
        if (this.isParentShallowCached() || this.shouldSkipInitializer(rowProcessingState)) {
            return State.NULL;
        }
        return State.INITIAL;
    }

    private void extractRowState(RowProcessingState processingState) {
        boolean stateAllNull = true;
        for (int i = 0; i < this.assemblers.length; ++i) {
            DomainResultAssembler<?> assembler = this.assemblers[i];
            Object contributorValue = assembler.assemble(processingState, processingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
            this.rowState[i] = contributorValue == BatchEntityInsideEmbeddableSelectFetchInitializer.BATCH_PROPERTY ? null : contributorValue;
            if (contributorValue != null) {
                stateAllNull = false;
                continue;
            }
            if (!this.isPartOfKey) continue;
            stateAllNull = true;
            break;
        }
        this.state = stateAllNull ? State.NULL : State.EXTRACTED;
    }

    @Override
    public void resolveState(RowProcessingState rowProcessingState) {
        if (this.determinInitialState(rowProcessingState) == State.INITIAL) {
            for (DomainResultAssembler<?> assembler : this.assemblers) {
                assembler.resolveState(rowProcessingState);
            }
        }
    }

    private Object createCompositeInstance(NavigablePath navigablePath, SessionFactoryImplementor sessionFactory) {
        if (this.state == State.NULL && !this.createEmptyCompositesEnabled) {
            return null;
        }
        Object instance = this.embedded.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator().instantiate(this, sessionFactory);
        this.state = State.EXTRACTED;
        EmbeddableLoadingLogger.EMBEDDED_LOAD_LOGGER.debugf("Created composite instance [%s] : %s", (Object)navigablePath, instance);
        return instance;
    }

    @Override
    public Object[] getValues() {
        return this.state == State.NULL ? null : this.rowState;
    }

    @Override
    public <T> T getValue(int i, Class<T> clazz) {
        return this.state == State.NULL ? null : (T)clazz.cast(this.rowState[i]);
    }

    @Override
    public Object getOwner() {
        return this.fetchParentAccess.getInitializedInstance();
    }

    private void handleParentInjection() {
        PropertyAccess parentInjectionAccess = this.embedded.getParentInjectionAttributePropertyAccess();
        if (parentInjectionAccess == null) {
            return;
        }
        Initializer parentInitializer = this.determineParentInjectionInitializer();
        Object parent = this.determineParentInstance(parentInitializer);
        if (parent == null) {
            EmbeddableLoadingLogger.EMBEDDED_LOAD_LOGGER.debugf("Unable to determine parent for injection into embeddable [%s]", (Object)this.navigablePath);
            return;
        }
        EmbeddableLoadingLogger.EMBEDDED_LOAD_LOGGER.debugf("Injecting parent into embeddable [%s] : `%s` -> `%s`", (Object)this.navigablePath, parent, this.compositeInstance);
        Setter setter = parentInjectionAccess.getSetter();
        assert (setter != null);
        EntityInitializer entityInitializer = this.findFirstEntityInitializer(parentInitializer);
        if (entityInitializer != null) {
            entityInitializer.registerResolutionListener(o -> setter.set(this.compositeInstance, o));
        } else {
            setter.set(this.compositeInstance, parent);
        }
    }

    private @Nullable EntityInitializer findFirstEntityInitializer(Initializer initializer) {
        EntityInitializer entityInitializer = initializer.asEntityInitializer();
        if (entityInitializer != null) {
            return entityInitializer;
        }
        assert (initializer.isCollectionInitializer());
        return ((CollectionInitializer)initializer).findFirstEntityInitializer();
    }

    private Initializer determineParentInjectionInitializer() {
        for (FetchParentAccess parentAccess = this.fetchParentAccess; parentAccess != null; parentAccess = parentAccess.getFetchParentAccess()) {
            if (parentAccess.isEmbeddableInitializer()) continue;
            return parentAccess;
        }
        throw new UnsupportedOperationException("Injection of parent instance into embeddable result is not possible");
    }

    private Object determineParentInstance(Initializer parentInitializer) {
        if (parentInitializer == null) {
            throw new UnsupportedOperationException("Cannot determine Embeddable: " + this.navigablePath + " parent instance, parent initializer is null");
        }
        if (parentInitializer.isCollectionInitializer()) {
            return ((CollectionInitializer)parentInitializer).getCollectionInstance().getOwner();
        }
        EntityInitializer parentEntityInitializer = parentInitializer.asEntityInitializer();
        if (parentEntityInitializer != null) {
            return parentEntityInitializer.getInitializedInstance();
        }
        throw new UnsupportedOperationException("The Embeddable: " + this.navigablePath + " parent initializer is neither an instance of an EntityInitializer nor of a CollectionInitializer");
    }

    @Override
    public void markShallowCached() {
        assert (!this.isPartOfKey);
        super.markShallowCached();
        this.markSubInitializersAsShallowCached();
    }

    private void markSubInitializersAsShallowCached() {
        for (DomainResultAssembler<?> assembler : this.assemblers) {
            Initializer initializer = assembler.getInitializer();
            if (initializer == null) continue;
            initializer.markShallowCached();
        }
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.compositeInstance = null;
        this.state = State.INITIAL;
        this.wrappedProcessingState = null;
        this.clearResolutionListeners();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.navigablePath + ") : `" + this.getInitializedPart().getJavaType().getJavaTypeClass() + "`";
    }

    static enum State {
        INITIAL,
        EXTRACTED,
        NULL,
        INJECTED;

    }
}

